#!/bin/bash

                         ##                     ##
                        ##  nukereq 2.0 by ugly  ##
                         ##                     ##


sitename="MYNAME"		# replace this with the name of your site

root="/usr/glftpd"		# full glftpd root path

del_pub="YES"			# allow all users to delete a nuke request in
				# your public site channel?

date_format="%m%d"		# format that the date should be output in the
				# nukereq database - default is "MMDD" - do NOT
				# use spaces!

max_output_lines="8"		# Maximum number of lines for the bot to output
				# when executing a nukereq listing - set to ""
				# to disable (doesn't include the header/footer)

sedcmd="sed -r"			# Linux users leave this alone, Free/NetBSD set
				# this to "sed -E", and for other OSes, find
				# the appropriate command for using EXTENDED
				# regular expressions with sed (openbsd users
				# need to install GNU sed)


### END CONFIG ###


### AUTO-DETECT ENVIRONMENT ###

if [ -d "$root" ]; then
   nukereq_db="${root}/ftp-data/misc/nukerequests"
else
   nukereq_db="/ftp-data/misc/nukerequests"
   del_pub="YES"
fi

if [ ! -w "$nukereq_db" ]; then
   echo "$nukereq_db isn't writable or doesn't exist!"
   exit 0
fi

### END ###

echo_syntax () {
   if [ -d "$root" ]; then
      echo "-$sitename- [NUKEREQ] - Make, delete, or list nuke requests. " \
         "Add nuke request syntax: !nukereq <rel> <reason>.  Delete nukereq" \
         "syntax: !nukereq del <#> OR !nukereq del <name>.  Delete all" \
	 "nukereqs syntax: !nukereq clean.  List nuke requests syntax:" \
	 "!nukereqls."
   else
      echo "Syntax: SITE NUKEREQ [ help | list | clean | del <#|name> |" \
         "<release> <reason> ]: Make, delete, or list nuke requests."
   fi
}

add_to_rels () {
   if [ -z "$deleted_rels" ]; then
      deleted_rels="$1"
   else
      deleted_rels="${deleted_rels}, $1"
   fi
}

if [ -z "$1" ]; then
   echo_syntax
   exit 0
fi 

case "$1" in
  help) echo_syntax ;;
  del)
     if [ "$del_pub" = "NO" ]; then
        echo "-$sitename- [NUKEREQ] - ERROR: You do not have permission" \
	   "to delete a nuke request!"
     else
        if [ -z "$2" ]; then
           echo "-$sitename- [NUKEREQ] - ERROR: You did not enter a nuke" \
	      "request number or name."
        else
	   shift
	   until [ -z "$1" ]; do
   	      # if deleting by nuke NAME
              if echo "$1" | grep -vE "^[0-9]+$" &>/dev/null; then
   	         if grep -w "$1" "$nukereq_db" &>/dev/null; then
		    add_to_rels "$1"
		    sed_del_lines="${sed_del_lines}; /\<$1\>/ d"
   	         else
   	            echo "-$sitename- [NUKEREQ] - ERROR: Nuke request $1" \
   	               "does not exist in the database."
   	         fi
   	      else
   	         output=`sed -n "$1 p" < "$nukereq_db"`
                 if [ -z "$output" ]; then
                    echo "-$sitename- [NUKEREQ] - ERROR: Nuke request #$1" \
   	               "does not exist in the database."
                 else
                    delrelname=`echo "$output" | awk '{print $2}' | \
		       sed 's///g'`
		    add_to_rels "$delrelname"
		    sed_del_lines="${sed_del_lines}; $1 d"
                 fi
              fi
	      shift
	   done
	   if [ ! -z "$deleted_rels" -a ! -z "$sed_del_lines" ]; then
	      new_db_output=`sed "$sed_del_lines" < "$nukereq_db"`
	      if [ -z "$new_db_output" ]; then
	         : > "$nukereq_db"
              else
	         echo "$new_db_output" > "$nukereq_db"
	      fi
	      echo "-$sitename- [NUKEREQ] - The following rel(s) has been" \
	         "deleted from the database: $deleted_rels"
           fi
        fi
     fi
  ;;
  list)
    if [ -s "$nukereq_db" ]; then
       output_db () {
          if [ -z "$max_output_lines" ]; then
             grep -n "." "$nukereq_db" | $sedcmd \
	        's/^([0-9]+):/\[#\1\] /'
          else
	     num_lines=`grep -c "." "$nukereq_db"`
	     if [ $num_lines -gt $max_output_lines ]; then
	        remainder=$(( $num_lines - $max_output_lines ))
	        grep -n "." "$nukereq_db" | head -n $max_output_lines | \
		$sedcmd 's/^([0-9]+):/\[#\1\] /'
		echo "and $remainder more ..."
	     else
	        grep -n "." "$nukereq_db" | $sedcmd \
		   's/^([0-9]+):/\[#\1\] /'
             fi
          fi
       }
       if [ -d "$root" ]; then
          cat "${root}/ftp-data/misc/nukerequests.head"
	  output_db
          cat "${root}/ftp-data/misc/nukerequests.foot"
       else
          cat /ftp-data/misc/nukerequests.head
	  output_db
          cat /ftp-data/misc/nukerequests.foot
       fi
    else
       echo "-$sitename- [NUKEREQ] - Nukereq database is empty."
    fi
  ;;
  clean)
    : > "$nukereq_db"
    echo "-$sitename- [NUKEREQ] - Nukereq database cleaned."
  ;;
  *)
     if [ -z "$2" ]; then
        echo "-$sitename- [NUKEREQ] - You didn't enter a nuke reason!"
     else
        if grep -w "$1" "$nukereq_db" &>/dev/null; then
	  echo "-$sitename- [NUKEREQ] - Nukerequest already exists in" \
	     "the database!"
	else
           date=`date "+${date_format}"`
           if [ -d "$root" ]; then
              # $1 = rel, $2 = reason, $3 = nick (as given by the TCL)
              echo "$date $1 REASON: $2 REQ BY: $3" >> "$nukereq_db"
           else
              # easy way to use the same formatting as above
	      rel="$1"; shift
              echo "$date $rel REASON: $@ REQ BY: $USER" >> \
	         "$nukereq_db"
           fi
           echo "-$sitename- [NUKEREQ] - Nuke request added to database."
	fi
     fi
     ;;
esac

exit 0
