#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <curses.h>
#include <unistd.h>
#include <fcntl.h>

#define MAX_KEYS 256


WINDOW	*Window_Query,
	*Window_Main,
	*Window_Preview;
char	*key_data[MAX_KEYS],
        *key_name[MAX_KEYS];
int	 key_quotes[MAX_KEYS],
	 key_convert[MAX_KEYS],
         key_id[MAX_KEYS],
	 keys = 0, /* Keys in memory */
         pos = 0,  /* Real position */
         vpos = 0; /* Virtual position */

#define  query_box_size 5
#define  preview_box_size 5

#include "defaults.h"
#include "convert.h"
#include "config.h"


void mvwprintw_bold(WINDOW *win, int Y, int X, char *data) {
 int cnt = 0, bold = 0;

 wmove(win, 0, 0);
 for ( ; data[cnt] != 0 ; cnt++ ) {
  if ( data[cnt] == '%' && data[cnt + 1] == 'b') {
   cnt++;
   if ( ! bold ) { wattron(win, A_BOLD); bold++; }
    else { wattroff(win, A_BOLD); bold--; }

  } else wprintw(win, "%c", data[cnt]);
 }
 wattroff(win, A_BOLD);
}



void showvalue(WINDOW *win, char *instr, int a_pos) {
 char tmp[4096];
 struct tm timenow;
 time_t tnow = time( NULL );
 timenow = *localtime( &tnow );

 werase(win);
 wrefresh(win);
 switch ( key_convert[a_pos] ) {
  case 4:
   strftime(tmp, 4096, instr, &timenow);
   mvwprintw(win, 0, 0, "%s", tmp);
   break;
  case 5:
   mvwprintw_bold(win, 0, 0, convert(instr, 1));
   break;
  case 1:
   mvwprintw_bold(win, 0, 0, convert(instr, 0));
   break;
  case 2:
   mvwprintw_bold(win, 0, 0, convert2(instr, 0, 0));
   break;
  case 3:
   mvwprintw_bold(win, 0, 0, convert3(instr, 0, 0));
   break;
  case 0:
   mvwprintw(win, 0, 0, "%s", instr);
 }
 wrefresh(win);
}



/* Query value in query window */
void query(int a_pos) {
 char	*tmp, *oldtmp;
 int	key = 0,
	spos,
	slen,
	loop = 1, 
        ty, tx;

 mvhline(1 + preview_box_size, 1, '-', COLS - 2);
 refresh();
 tmp = malloc((query_box_size * COLS) - 1);
 oldtmp = malloc((query_box_size * COLS) - 1);
 strcpy(tmp, key_data[a_pos]);
 spos = slen = strlen(tmp);
 werase(Window_Query);
 werase(Window_Preview);
 mvwprintw(Window_Query, 0, 0, "%s", tmp);
 showvalue(Window_Preview, tmp, a_pos);
 wrefresh(Window_Query);

 while ( loop == 1 ) switch( key = getch() ) {
  case 27: loop = 2; break;
  case 343: loop = 0; break;
  case 13: loop = 0; break;
  case 260: 
   if (spos) {
    spos--;
    tx = spos; ty = 0;
    while ( tx > COLS - 2 ) { ty++; tx -= (COLS - 2); }
    wmove(Window_Query, ty, tx);
    wrefresh(Window_Query);
   }
   break;
  case 261: 
   if (spos < (query_box_size * COLS) - 3 && spos < slen) {
    spos++;
    tx = spos; ty = 0;
    while ( tx > COLS - 2 ) { ty++; tx -= (COLS - 2); }
    wmove(Window_Query, ty, tx);
    wrefresh(Window_Query);
   }
   break;
  case 127: 
   if (spos < slen) {
    strcpy(oldtmp, tmp);
    strncpy(tmp, oldtmp, spos);
    sprintf(tmp + spos, "%s", oldtmp + spos + 1);
    mvwprintw(Window_Query, 0, 0, "%s ", tmp);
    slen--;
    tx = spos; ty = 0;
    while ( tx > COLS - 2 ) { ty++; tx -= (COLS - 2); }
    wmove(Window_Query, ty, tx);
    showvalue(Window_Preview, tmp, a_pos);
    wrefresh(Window_Query);
   }
   break;
  case 263: 
   if (slen && spos) {
    strcpy(oldtmp, tmp);
    strncpy(tmp, oldtmp, spos - 1);
    sprintf(tmp + spos - 1, "%s", oldtmp + spos);
    werase(Window_Query);
    mvwprintw(Window_Query, 0, 0, "%s", tmp);
    slen--; spos--;
    tx = spos; ty = 0;
    while ( tx > COLS - 2 ) { ty++; tx -= (COLS - 2); }
    wmove(Window_Query, ty, tx);
    showvalue(Window_Preview, tmp, a_pos);
    wrefresh(Window_Query);
   }
   break;
  default :
    if ( isprint(key) && slen < (query_box_size * COLS) - 3) {
     strcpy(oldtmp, tmp);
     strncpy(tmp, oldtmp, spos);
     sprintf(tmp + spos, "%c%s", key, oldtmp + spos);
     mvwprintw(Window_Query, 0, 0, "%s", tmp);
     slen++; spos++;
     tx = spos; ty = 0;
     while ( tx > COLS - 2 ) { ty++; tx -= (COLS - 2); }
     wmove(Window_Query, ty, tx);
     showvalue(Window_Preview, tmp, a_pos);
     wrefresh(Window_Query);
    }
   break;
 }

 if ( loop != 2 ) {
  if ( slen > strlen(key_data[a_pos]) ) key_data[a_pos] = realloc(key_data[a_pos], slen + 1);
  strcpy(key_data[a_pos], tmp);
 }

 showvalue(Window_Query, key_data[a_pos], a_pos);

 free(oldtmp);
 free(tmp);
}



void print_keys(int show_pos) {
 int cnt;
 char tmp[10];

 sprintf(tmp, "%%%is", COLS - 2); 
 for ( cnt = 0 ; cnt <= LINES - 4 - query_box_size ; cnt++ )
  mvwprintw(Window_Main, cnt + 1, 1, tmp, "");

 for ( cnt = 0 ; cnt <= LINES - 4 - query_box_size && cnt + vpos < keys ; cnt++ ) {
  if ( strlen(key_data[cnt + vpos]) > COLS - 31 ) {
   sprintf(tmp, " %%0.%is...", COLS - 34);
  } else {
   sprintf(tmp, " %%s");
  }
  if ( cnt == pos ) {
   wattron(Window_Main, A_REVERSE);
   mvwprintw(Window_Main, cnt + 1, 1, "%-28s", key_name[cnt + vpos]);
   wattroff(Window_Main, A_REVERSE);
   wprintw(Window_Main, tmp, key_data[cnt + vpos]);
  } else {
   mvwprintw(Window_Main, cnt + 1, 1, "%-28s", key_name[cnt + vpos]);
   wprintw(Window_Main, tmp, key_data[cnt + vpos]);
  }
 }
}



main( int argc, char **argv ) {
 int	key = 0;

/* read config */
 if ( argc == 2 ) readconfig(argv[1]);
  else {
   printf("Usage: %s <config>\n", argv[0]);
   exit(0);
  }

/* init screen and keyboard */
 initscr();
 cbreak(); 
 noecho(); 
 nonl(); 
 intrflush(stdscr, FALSE); 
 keypad(stdscr, TRUE); 
 curs_set(0);
 doupdate();

/* allocate screen buffers and draw borders */
 Window_Main  = stdscr;
 Window_Query = newwin(query_box_size, COLS - 2, LINES - query_box_size - 1, 1);
 Window_Preview = newwin(preview_box_size, COLS - 2, 1, 1);

 wborder(Window_Main, 124,124,45,45,43,43,43,43);
 doupdate();
// wrefresh(Window_Preview);
 mvhline(LINES - 2 - query_box_size, 1, '-', COLS - 2);
 refresh();

 while ( key != 81 && key != 113 ) {
  switch ( key ) {
   case 13:
     query(pos + vpos);
    break;
   case 258:
    if ( pos + vpos < keys - 1 ) { 
     if ( pos == LINES - 4 - query_box_size ) { 
      vpos += 5;
      pos -= 4;
     } else {
      pos++;
     }
    }
    break;
   case 259:
    if ( pos + vpos > 0 ) {
     if ( ! pos ) {
      vpos -= 5;
      pos += 4;
      while ( vpos < 0 ) { pos--; vpos++; }
     } else {
      pos--;
     }
    }
    break;
  }

  print_keys(pos + vpos);
  showvalue(Window_Query, key_data[pos + vpos], pos + vpos);
  wrefresh(Window_Main);
  key = getch();
 }

/* write config */
 writeconfig("zsconfig.h");

/* quit - clear variables */
 delwin(Window_Query);
 delwin(Window_Preview);
 reset_shell_mode();
 endwin();
}
