
/* CONVERT[2] COOKIES TO VARIABLES (FOR USERTOP) */
char output2[1024];
char* convert2(char *instr, short pos, short rank) {
 int cnt, tmp = cnt = 0;
 for ( ; instr[cnt] != 0 ; cnt++ )
  if ( instr[cnt] == '%' ) {
   cnt++;
   if ( instr[cnt] == 0 ) break;
   switch ( instr[cnt] ) {
    case 'b': tmp += sprintf(output2 + tmp, "%b"); break;
    case 'f': tmp += sprintf(output2 + tmp, "4875"); break;
    case 'F': tmp += sprintf(output2 + tmp, "%i", userI[rank].files); break;
    case 'G': tmp += sprintf(output2 + tmp, groupI[userI[rank].group].name); break;
    case 'M': tmp += sprintf(output2 + tmp, "%.1f", (double)(userI[rank].bytes >> 16) / 16); break;
    case 'n': tmp += sprintf(output2 + tmp, "%i", pos + 1); break;
    case 'P': tmp += sprintf(output2 + tmp, "%.1f", userI[rank].bytes * 100.0 / totalbytes); break;
    case 's': tmp += sprintf(output2 + tmp, "2525"); break;
    case 'S': tmp += sprintf(output2 + tmp, "%0.0f", userI[rank].bytes / userI[rank].speed ); break;
    case 'U': tmp += sprintf(output2 + tmp, userI[rank].name); break;
    case '%': tmp += sprintf(output2 + tmp, "%%");
   }
  } else tmp += sprintf(output2 + tmp, "%c", instr[cnt]);
 return output2;
}

/* CONVERT[3] COOKIES TO VARIABLES (FOR GROUPTOP) */
char* convert3(char *instr, short pos, short rank) {
 int cnt, tmp = cnt = 0;
 for ( ; instr[cnt] != 0 ; cnt++ )
  if ( instr[cnt] == '%' ) {
   cnt++;
   if ( instr[cnt] == 0 ) break;
   switch ( instr[cnt] ) {
    case 'b': tmp += sprintf(output2 + tmp, "%b"); break;
    case 'F': tmp += sprintf(output2 + tmp, "%i", groupI[rank].files); break;
    case 'G': tmp += sprintf(output2 + tmp, groupI[rank].name); break;
    case 'M': tmp += sprintf(output2 + tmp, "%.1f", (double)(groupI[rank].bytes >> 16) / 16); break;
    case 'n': tmp += sprintf(output2 + tmp, "%i", pos + 1); break;
    case 'P': tmp += sprintf(output2 + tmp, "%.1f", groupI[rank].bytes * 100.0 / totalbytes); break;
    case 'u': tmp += sprintf(output2 + tmp, "%i", groupI[rank].users); break;
    case 'S': tmp += sprintf(output2 + tmp, "%.0f", groupI[rank].bytes / groupI[rank].speed ); break;
    case '%': tmp += sprintf(output2 + tmp, "%%");
   }
  } else tmp += sprintf(output2 + tmp, "%c", instr[cnt]);
 return output2;
}

/* Convert[1] */
char output[2048];
char* convert(char *instr, int boolean) {
 char usertop[1024],
      grouptop[1024],
      racers[1024];
 int  cnt, n, tmp = 0;
   
 for ( cnt = 0 ; cnt < users ; cnt++ )
  tmp += sprintf(usertop + tmp, " %s", convert2(key_data[key_id[3]], cnt, cnt));
 tmp = 0;
 for ( cnt = 1 ; cnt < users ; cnt++ )
  tmp += sprintf(racers + tmp, " %s", convert2(key_data[key_id[9]], cnt, cnt));
 tmp = 0;
 for ( cnt = 0 ; cnt < groups ; cnt++ )
  tmp += sprintf(grouptop + tmp, " %s", convert2(key_data[key_id[5]], cnt, cnt));

 tmp = 0;   
 for ( cnt = 0; instr[cnt] != 0 ; cnt++ )
  if ( instr[cnt] == '%' ) {
   cnt++;
   if ( instr[cnt] == 0 ) break;
   switch ( instr[cnt] ) {
    case 'a': tmp += sprintf(output + tmp, "%.1f", totalbytes / 19. / 1024); break;
    case 'A': tmp += sprintf(output + tmp, "%.1f", totalbytes / ((tstop.tv_sec - tstart.tv_sec) + (tstop.tv_usec - tstart.tv_usec) / 1000000.) / 1024); break;
    case 'b': tmp += sprintf(output + tmp, "%b"); break;
    case 'D': tmp += sprintf(output + tmp, "%b8%bs"); break;
    case 'e': tmp += sprintf(output + tmp, "%0.1f", 15000000 * 5. / 1024 / 1024); break;
    case 'C': cnt++; n = (int)instr[cnt] - 48; if ( n < users ) tmp += sprintf(output + tmp, convert2(key_data[key_id[4]], n, n)); break;
    case 'c': cnt++; n = (int)instr[cnt] - 48; if ( n < groups ) tmp += sprintf(output + tmp, convert3(key_data[key_id[6]], n, n)); break;
    case 'F': tmp += sprintf(output + tmp, "%i", fcount); break;
    case 'g': tmp += sprintf(output + tmp, mp3file.genre); break;
    case 'G': tmp += sprintf(output + tmp, "pHASE"); break;
    case 'k': tmp += sprintf(output + tmp, "%i", groups); break;
    case 'K': tmp += sprintf(output + tmp, mp3file.bitrate); break;
    case 'l': tmp += sprintf(output + tmp, convert2(key_data[key_id[8]], 0, 1)); break;
    case 'L': tmp += sprintf(output + tmp, convert2(key_data[key_id[7]], 0, 0)); break;
    case 'M': tmp += sprintf(output + tmp, "%i", mcount); break;
    case 'r': tmp += sprintf(output + tmp, racers + 1); break;
    case 'R': tmp += sprintf(output + tmp, "%bTest.release-dark0n3%b"); break;
    case 's': tmp += sprintf(output + tmp, "%0.1f", 15000000 * 5. / 1024 / 1024); break;
    case 'S': tmp += sprintf(output + tmp, "4875"); break;
    case 't': tmp += sprintf(output + tmp, grouptop + 1); break;
    case 'T': tmp += sprintf(output + tmp, usertop + 1); break;
    case 'u': tmp += sprintf(output + tmp, "%i", users); break;
    case 'U':
     if ( ! boolean ) tmp += sprintf(output + tmp, "darkone");
      else tmp += sprintf(output + tmp, "%i", fcount - mcount); break;
    case 'Y': tmp += sprintf(output + tmp, mp3file.year); break;
    case '%': tmp += sprintf(output + tmp, "%%");
   }
  } else tmp += sprintf(output + tmp, "%c", instr[cnt]);
 return output;
}
