#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

static const char *search[] = { 
 "[?!/##]",
 "(?!/##)",
 "[?!!/###]",
 "(?!!/###)",
 "[?/#]",
 "(?/#)",
 "[disk:!!/##]",
 "o?/o#",
 "disks[!!/##",
 " !/# ",
 " !!/##&/",
 "&/!!/## ",
 "[!!/#]",
 "?!/## ",
 ": ?!/##&/",
 "xx/##" };
int strings = 15;
/*
 
 ? = any char
 & = character is not (&/ = character is not /)
 # = total disk count
 ! = chars 0-9, o & x

 !!! USE LOWERCASE !!!

*/
/* DO NOT EDIT BEYOND THIS POINT */


/* REMOVE SPACES FROM STRING */
char output[4096];
char* removespaces(char *instr) {
 int spaces, cnt2, cnt = cnt2 = spaces = 0;
 for ( ; instr[cnt] != '\0' ; cnt++ ) switch( instr[cnt] ) {
  case ' ':
   if ( ! spaces ) output[cnt2++] = ' ';
   spaces++;
   break;
  case '\n':
   if ( ! spaces ) output[cnt2++] = ' ';
   spaces++;
   break;
  default :
   output[cnt2++] = tolower(instr[cnt]);
   spaces = 0;
   break;
 }
 output[cnt2++] = '\0';
 return output;
}


/* MAIN LOOP */
main ( int argc, char **argv ) {
 int pos, fd, matches, diskc, control, cnt, cnt3, cnt2 = cnt = cnt3 = 0;
 char data[4096];
 char disks[4];

 if ( argc < 2 ) { printf("Usage: %s file_id.diz\n", argv[0]); exit(0); }
 fd = open(argv[1], O_NONBLOCK);
 while ( read(fd, data, 4096) > 0 ) {
  strcpy(data, removespaces(data));
  for ( cnt = 0 ; data[cnt] != '\0' ; cnt++ ) 
   for ( cnt2 = 0 ; cnt2 < strings ; cnt2++ ) {
    pos = matches = control = 0; disks[0] = disks[1] = disks[2] = disks[3] = '\0';
    for ( cnt3 = 0; cnt3 <= (strlen(search[cnt2]) - control) ; cnt3++ )
     switch ( search[cnt2][cnt3 + control] ) {
      case '#': if ( isdigit(data[cnt + cnt3]) || data[cnt + cnt3] == ' ' ) { matches++; pos += sprintf(disks + pos, "%c", data[cnt + cnt3]); } break;
      case '?': matches++; break;
      case '!': if ( isdigit(data[cnt + cnt3]) || data[cnt + cnt3] == 'o' || data[cnt + cnt3] == 'x') matches++; break;
      case '&': control++; if ( data[cnt + cnt3] != search[cnt2][cnt3 + control] ) matches++; break; 
      default : if ( search[cnt2][cnt3 + control] == data[cnt + cnt3] ) matches++; break;
     }
    if ( matches == strlen(search[cnt2]) - control && (diskc = atoi(disks))) exit(diskc);
   }
 }
 close(fd);
 exit(0);
}
