#!/bin/bash
zipdatadir="/ftp-data/zipscript/"

case "$2" in
 /site/requests/*)
  exit 0;
 ;;
esac


case "$1" in  
 *.[rR][aA][rR]|*.[rR0123456789][0123456789][0123456789]|*.[mM][pP]3)
  if ls "$2" | grep -i sfv &> /dev/null ; then
    if [ -z "`grep -aie $1 "$zipdatadir/$2/sfvdata" | tr -s ' ' | tr [:cntrl:] '\n' | cut -d' ' -f1 | grep -iae $1`" ] ; then
     echo -e "File does not exist in sfv!\n"
     exit 2
    fi
   exit 0
  else
   if [ -e "$zipdatadir/$2/sfvdata" ] ; then
    if [ -z "`grep -aie $1 "$zipdatadir/$2/sfvdata" | tr -s ' ' | tr [:cntrl:] '\n' | cut -d' ' -f1 | grep -iae $1`" ] ; then
     echo -e "File does not exist in sfv!\n"
     exit 2
    fi
    exit 0
   else
    echo -e "You must upload .sfv first!\n"
    exit 2
   fi
  fi
 ;;
 *.[dD][iI][zZ])
  exit 2
 ;;
 *.[sS][fF][vV])
  if [ -e *.[Ss][Ff][Vv] ] ; then
   echo -e "SFV already exists in this directory!\n"
   exit 2
  fi
 ;;
 *.[zZ][iI][pP])
  if [ -e *.[Zz][Ii][Pp] ] ; then
   searchstr=`echo $1 | cut -c-4`
   if [ -z "`ls -1 | cut -c-4 | grep -i $searchstr`" ] ; then
    echo -e "Filename does not match with existing disks"
    exit 2
   fi
  fi
 ;;
 *)
  exit 0
 ;;
esac
