##############################################################################
#   ____________________________________________________________________     #
#   ,       _____   __   ______   _____   _____    _____   ______      ,     #
#    ,     |  ___| |  | |_    _| |  ___| |  __ \  /     \ |_    _|    ,      #
#     ,    |___  | |  |   |  |   |  ___| |  __ <  |  |  |   |  |     ,       #
#      ,   |_____| |__|   |__|   |_____| |_____/  \_____/   |__|    ,        #
#       ,---------------------GLFTPD-EDITION-----------------------,         #
#        ,   CODER: DaRKHeaRT                                     ,          #
#         ,  VERSION: sitebot-glftpd.tcl v2.8                    ,           #
#          ,____________________________________________________,            #
#           ,..................................................,             #
#            ,................................................,              #
#                                                                            #
##############################################################################
#                                                                            #
#   Script   sitebot-glftpd.tcl                                             #
#   Coder    DaRKHeaRT (rhett@lotus-net.ch) of MOONSHINE COURIERS (MSN)     #
#   Assist   dopestar (ds@dopestar.net) of MOONSHINE COURIERS               #
#   URL      http://darkheart.moonshine.ch/                                 #
#             http://scriptworld.eggsource.com/script/?script_id=3           #
#                                                                            #
#   IRC      find me on linknet, nick DaRKHeaRT                             #
#                                                                            #
#             ircd.link-net.org         (usa)                                #
#             irc.christmasland.net     (fi)                                 #
#             irc.bahnhof.se            (se)                                 #
#             irc.fudgefactory.com.au   (au)                                 #
#                                                                            #
#             or alternativly on efnet in #glftpd                            #
#                                                                            #
#   Version  2.8 -glftpd edition-                                           #
#                                                                            #
#   This TCL does not need to be modified in anyway. Specific preferences    #
#   are set in sitebot-glftpd.config which will be generated if you dont     #
#   have one in your scripts/sitebot dir or updated if your config file      #
#   is old.								     #
#                                                                            #
#   Any lines in glftpd.log which need to be manipulated and then announced  #
#   to a set of channels are set in sitebot-glftpd.api                       #
#                                                                            #
#   READ sitebot-glftpd.readme BEFORE DOING ANYTHING!                        #
#   READ sitebot-glftpd.config.help WHEN SETTING BOT UP!		     #
#   READ sitebot-glftpd.api.help WHEN SETTING BOT UP!			     #
#   READ sitebot-glftpd.faq BEFORE MESSAGING ME (DaRKHeaRT) WITH "PROBLEMS"  #
#                                                                            #
##############################################################################
#                                                                            #
#   Copyright (C) 1998 - 2001 DaRKHeaRT                                      #
#                                                                            #
#   This program is free software; you can redistribute it and/or modify     #
#   it under the terms of the GNU General Public License as published by     #
#   the Free Software Foundation; either version 2 of the License, or        #
#   (at your option) any later version.                                      #
#                                                                            #
#   This script is distributed in the hope that it will be useful,           #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of           #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
#   GNU General Public License for more details.                             #
#                                                                            #
##############################################################################

proc sitebot:main {} {
  uplevel #0 {
    sitebot:killoldtimers
    sitebot:init
    putlog "--dh-----------------------------------------------------dh--"
    putlog "SITEBOT: use '.${dcc_prefix}help' for commands."
    sitebot:loadapi
    sitebot:loadconf
    sitebot:checkscripts
    sitebot:connftp
    putlog "$sitein.. BOT UP.. Fingers Crossed.. Loading Sections"
    if $enabled(auto_bw) { sitebot:autobw }
    if $enabled(auto_wktop) { sitebot:autowktop }
    if $enabled(site_msgaddip) { sitebot:msgaddip }
    if $enabled(site_msginvite) { sitebot:msginvite }
    if $enabled(site_msgbnc) {sitebot:msgbnc }
    if $enabled(santino_zipscript) {sitebot:santinozipscript ; putlog "- Santino Zipscript Extras by Santino / DaRKHeaRT Loaded!" }
    if $enabled(announce) { sitebot:announce ; putlog "- Site Announce by DaRKHeaRT Loaded!" }
    if $enabled(stats) { sitebot:stats ; putlog "- Site Stats by DaRKHeaRT Loaded!" }
    if $enabled(dcc) { sitebot:dcc ; putlog "- Site DCC Components by DaRKHeaRT Loaded!" }
    if $enabled(updater) { sitebot:updater ; putlog "- Sitebot updater by DaRKHeaRT Loaded!"}
    sitebot:addonsearch
    putlog "$sitein $ver"
    putlog "--dh-----------------------------------------------------dh--"
  }
}

# LIBRARY TYPE FUNCTIONS
proc n {} {return "\n"};    #newline
proc u {} {return "\037"};  #underline
proc r {} {return "\026"};  #reverse
proc b {} {return "\002"};  #bold
proc c {} {return "\003"};  #color
proc a {} {return "\001"};
proc putchanreq { chan msg } { global showrequest ; if {$showrequest == "1"} { putserv "PRIVMSG $chan : $msg" } { return 0 }; }
proc putchan { chan msg } { putserv "PRIVMSG $chan : $msg" };             # shortcut - channel msg
proc putnot { nick msg } { putserv "NOTICE $nick : $msg" };               # shortcut - notice nick
proc putmsg { nick msg } { putserv "PRIVMSG $nick : $msg" };              # shortcut - msg nick
proc putnm { nick not } {global outputt ; if {$outputt == "1"} { putmsg $nick $not ; return 0 } ; putnot $nick $not ; return 0 }; # shortcut notice/msg nick

proc charreplace { string key with } {
  if ![string match *$key* $string] { return $string }
  set out ""
  for {set j 0} {$j < [string length $string]} {incr j} {
    set a [string index $string $j]
    if { $a == $key } { set a $with }
      append out $a
    }
  return $out
}

proc checkpass {username pass} { global glbindir
  catch {[exec "$glbindir/passchk" $username $pass]} result
  if {[string match "*NO MATCH!*" $result]} {return 0}
  if {[string match "*MATCH!*" $result]} {return 1}
  return 0
}

proc filt {data} {
  regsub -all -- \\\\ $data \\\\\\\\ data; regsub -all -- \\\[ $data \\\\\[ data; regsub -all -- \\\] $data \\\\\] data
  regsub -all -- \\\} $data \\\\\} data; regsub -all -- \\\{ $data \\\\\{ data; regsub -all -- \\\" $data \\\\\" data; return $data
}

proc find { list value } {
  set a [lsearch -exact $list $value]
  if { $a >= 0 } { return 1 } { return 0 }
}

proc fixlenc {txt len char} {
  while {[string length $txt] < $len} { append txt $char }
  return $txt
}

proc fixsize {size} {
  if {$size == ""} { return [b][b] }
  if {$size >= 1048576} {
    return "[round [expr $size / 1048576.0] 2]GB"
  } elseif {$size >= 1024} {
    return "[round [expr $size / 1024.0] 2]MB"
  } else {
    return "$size K"
  }
}

proc get_section { path } { global sectionnames sections default;
  foreach sn $sectionnames {
    foreach p $sections($sn-path) {
      if {[string match $p $path]} {
        return $sn;
      }
    }
  }
  return $default;
}

proc glconfg {opt} { global glconf
  set of [open $glconf r]
  while {![eof $of]} {
    set cl [gets $of]
    if {[lindex $cl 0] == $opt} {close $of ; return [lrange $cl 1 end]}
  }
  close $of
  return 0
}

proc glreadgroup {username} { global glusers
  set of [open $glusers/$username r]
  while {![eof $of]} {
    set cl [gets $of]
    if {[lindex $cl 0] == "GROUP"} {close $of ; return [lrange $cl 1 end]}
  }
  close $of
  return "NoGroup"
}


proc ldelete { list value } {
  set a [lsearch -exact $list $value]
  if { $a >= 0 } {
    return [lreplace $list $a $a]
  } else {
    return $list 
  }
}

proc logtime {} { clock format [clock seconds] -format "%D - %H:%M:%S" }

proc round {num dec} {
  if {[string first . $num] != -1} {
    set num [string range $num 0 [expr [string first . $num] + $dec]]
    set num [fixlenc $num [expr [string first . $num] + $dec + 1] 0]
    return $num
  } else {
    append num "." ;
    set num [fixlenc $num [expr [string first . $num] + $dec + 1] 0]
    return $num
  }
}

proc splitlines { info length } {
        set times [expr [llength $info] / $length ]
        set extra [lrange $info [expr [llength $info] - [expr [llength $info] - [expr $times * $length ]]] end]
        set output ""; set l 0
        for {set i 0} {$i<$times} {incr i} {
                set output1 ""
                set limit [expr $length + $l ]
                for {} {$l<$limit} {incr l} { append output1 "[lindex $info $l] " }
                lappend output [string trimright $output1 " "]
        }
        if { $extra != "" } { lappend output $extra }
        return $output
}

proc sitebot:addversion { addonver } { global ver
   set ver "$ver +$addonver"
}

proc sndall {msg} { global dirlog_testchans
  foreach chan $dirlog_testchans { putchan $chan $msg }
}

proc str { string key with } {
  regsub -all -nocase "$key" $string "$with" string;return $string
}

proc strreplace { string key with } {
  if ![string match "*$key*" $string] { return $string }
  set t1 [string range $string 0 [expr [string first $key $string] -1]]
  set t2 [string range $string [expr [string first $key $string] + [string length $key]] end]
  return "${t1}${with}${t2}"
}

proc timerlist { timer_proc } {
  set result ""
  foreach timer [timers] {
    if {[string compare [lindex $timer 1] $timer_proc] == 0} {
      lappend result [lindex $timer 2]
    }
  }
  return $result
}

proc cleanmask { str } {
        set output ""
        for {set i 0} {$i<[string length $str]} {incr i} {
                set chr [string index $str $i]
                if { $chr == "\[" } { set chr "\[" }
                if { $chr == "\]" } { set chr "\]" }
                if { $chr == "\$" } { set chr "\$" }
                if { $chr == "\{" } { set chr "" }
                if { $chr == "\}" } { set chr "" }
                if { $chr == "\\" } { set chr "\\" }
                if { $chr == "\/" } { set chr "\/" }
                if { $chr == "\|" } { set chr "\|" }
                append output $chr
        }
        return $output
}

proc sitebot:speed {username} { global ftpwho hideinwho
  if {[file exists $ftpwho]} {
    set output ""
    if {[string length $username] > 8} {set username [string range $username 0 7]}
    if {[lsearch -exact $hideinwho $username] != -1} {return 0}
    if {![file exists $ftpwho]} {return 1}
    set of [open "|$ftpwho" r]
    while {![eof $of]} {
      set line "[lrange [filt [gets $of]] 1 end]"
      set usr [lindex $line 0]
      if {$usr == $username} {
        lappend output "[b][lindex $line 0][b] is [string trim [lrange $line 6 end] "|"]"
      }
    }
    close $of
    return $output
  }
  return 0
}

proc sitebot:bw {} { global ftpwho
  if {[file exists $ftpwho]} {
    set counter 0
    set idle 0
    set up 0
    set dn 0
    set upspeed 0
    set dnspeed 0

    set of [open "|$ftpwho" r]
    while {![eof $of]} {
      incr counter
      set line "[filt [gets $of]]"
      if {$line == "No Users Currently On Site!"} {close $of ; return 0}
      if {$line == "`----------------------------------------------------------------------------'"} {continue}
      if {$counter < 4} {continue}
      set status [string trim [lindex $line 7] ":"]
      if {$status == "Up"} {
        incr up
        set speed [lindex [split [lindex $line 10] "K"] 0]
        set upspeed [expr $upspeed + $speed]
      } elseif {$status == "Dn"} {
        incr dn
        set speed [lindex [split [lindex $line 10] "K"] 0]
        set dnspeed [expr $dnspeed + $speed]
      } elseif {$status == "Idle"} {
        incr idle
      } else {
        continue
      }
    }
    close $of
    return "[expr $counter - 5] $up $dn $idle $upspeed $dnspeed [expr $upspeed + $dnspeed] [expr $up + $dn]"
  }
  return 1
}

proc sitebot:santinozipscript {} {
  proc get_file_time {file_transfer_time} { global formatted_file_transfer_time

        if {$file_transfer_time >= 86400} {
                set days "[expr $file_transfer_time / 86400]"
                set hours "[expr ($file_transfer_time - ($days * 86400)) / 3600 ]"
                set minutes "[expr ( ($file_transfer_time - ($days * 86400) ) - ($hours * 3600) ) / 60 ]"
                set seconds "[expr ( ($file_transfer_time - ($days * 86400) ) - ($hours * 3600) ) - ($minutes * 60) ]"
                set formatted_file_transfer_time "$days days $hours hrs $minutes mins $seconds secs"
        } elseif {$file_transfer_time >= 3600} {
                set hours "[expr $file_transfer_time / 3600]"
                set minutes "[expr ( $file_transfer_time - ($hours * 3600) ) / 60 ]"
                set seconds "[expr ( $file_transfer_time - ($hours * 3600) ) - ($minutes * 60) ]"
                set formatted_file_transfer_time "$hours hrs $minutes mins $seconds secs"
        } elseif {$file_transfer_time >= 60} {
                set minutes "[expr $file_transfer_time / 60 ]"
                set seconds "[expr $file_transfer_time - ($minutes * 60) ]"
                set formatted_file_transfer_time "$minutes mins $seconds secs"
        } else {
                set formatted_file_transfer_time "$file_transfer_time secs"
        }
  }

  proc get_race_time {race_elapsed_time} { global formatted_race_elapsed_time

        if {$race_elapsed_time >= 86400} {
                set days "[expr $race_elapsed_time / 86400]"
                set hours "[expr ($race_elapsed_time - ($days * 86400)) / 3600 ]"
                set minutes "[expr ( ($race_elapsed_time - ($days * 86400) ) - ($hours * 3600) ) / 60 ]"
                set seconds "[expr ( ($race_elapsed_time - ($days * 86400) ) - ($hours * 3600) ) - ($minutes * 60) ]"
                set formatted_race_elapsed_time "$days days $hours hrs $minutes mins $seconds secs"
        } elseif {$race_elapsed_time >= 3600} {
                set hours "[expr $race_elapsed_time / 3600]"
                set minutes "[expr ( $race_elapsed_time - ($hours * 3600) ) / 60 ]"
                set seconds "[expr ( $race_elapsed_time - ($hours * 3600) ) - ($minutes * 60) ]"
                set formatted_race_elapsed_time "$hours hrs $minutes mins $seconds secs"
        } elseif {$race_elapsed_time >= 60} {
                set minutes "[expr $race_elapsed_time / 60 ]"
                set seconds "[expr $race_elapsed_time - ($minutes * 60) ]"
                set formatted_race_elapsed_time "$minutes mins $seconds secs"
        } else {
                set formatted_race_elapsed_time "$race_elapsed_time secs"
        }
  }

  proc get_size {total_release_size} { global formatted_total_release_size

        if {$total_release_size >= 1048576} {
                set formatted_total_release_size "[expr $total_release_size / 1048576]MB"
        } else {
                set formatted_total_release_size "[expr $total_release_size / 1024]KB"
        }
  }
}

proc sitebot:init {} {
  uplevel #0 {
    if {![info exists sitebot(api)]} { set sitebot(api) sitebot-glftpd.api }
    if {![info exists sitebot(config)]} { set sitebot(config) sitebot-glftpd.config }
    set www "http://darkheart.moonshine.ch/files/sitebot/"
    set proxy(enabled) "0";             # 1 = yes 0 = no
    set proxy(host) "myproxy.isp.com";  # Proxy Host
    set proxy(port) "8080";             # Proxy Port
    set currentconfigversion 2.8
    set currentapiversion 2.8
    set glconf /etc/glftpd.conf
    set types "NEWDIR NUKE UNNUKE LOGIN LOGOUT DELDIR INVITE AUTONUKE BW MSGINVITE BADMSGINVITE"
    set sectionnames "iso 0day"
    set defaultsection 0day
    set sections(iso-path)  { /path/to/isos/* };
    set sections(0day-path) { /site/* };
    set chans(0day-NEWDIR)  { #sbgl }
    set chans(0day-NUKE)    { #sbgl }
    set chans(0day-UNNUKE)  { #sbgl }
    set chans(0day-LOGIN)   { #sbgl }
    set chans(0day-LOGOUT)  { #sbgl }
    set chans(0day-DELDIR)  { #sbgl }
    set chans(0day-INVITE)  { #sbgl }
    set chans(0day-AUTONUKE) { #sbgl }
    set chans(iso-NEWDIR)   { #sbgl2 }
    set chans(iso-NUKE)     { #sbgl2 }
    set chans(iso-UNNUKE)   { #sbgl2 }
    set chans(iso-LOGIN)    { #sbgl2 }
    set chans(iso-LOGOUT)   { #sbgl2 }
    set chans(iso-DELDIR)   { #sbgl2 }
    set chans(iso-INVITE)   { #sbgl2 }
    set chans(iso-AUTONUKE) { #sbgl }
    set chans(0day-BW) { #notimportant }
    set chans(iso-BW) { #notimportant }
    set echovars(BW) "users ul dl idle uspeed dspeed totalspeed totalupdn"
    set echovars(NEWDIR) "pf user group tagline"
    set echovars(DELDIR) "pf user group tagline"
    set echovars(NUKE) "pf"
    set echovars(UNNUKE) "pf"
    set echovars(LOGIN) "hostname ip user group tagline"
    set echovars(LOGOUT) "hostname ip user group tagline"
    set echovars(INVITE) "nickname username group"
    set echovars(MSGINVITE) "nick uhost group username chan"
    set echovars(BADMSGINVITE) "nick uhost username chan"
    set echovars(AUTONUKE) ""
    set enabled_announce(BW) 0
    set enabled_announce(NEWDIR) 1
    set enabled_announce(DELDIR) 1
    set enabled_announce(NUKE) 1
    set enabled_announce(UNNUKE) 1
    set enabled_announce(LOGIN) 1
    set enabled_announce(LOGOUT) 1
    set enabled_announce(INVITE) 1
    set enabled_announce(AUTONUKE) 0
    set mask(BW) "\[[b]%sitein[b]\] BANDWIDTH: (ul:%ul at [b]%uspeedkb/s[b]) - (dl:%dl at [b]%dspeedkb/s[b]) - \[total:%totalupdn at [b]%totalspeedkb/s[b]\]"
    set mask(MSGINVITE) "\[[b]%sitein[b]\] MSG INVITE: (%nick from %uhost) was just invited by [b]%username[b]"
    set mask(BADMSGINVITE) "\[[b]%sitein[b]\] BAD MSG INVITE: (%nick from %uhost) tried to get invited using [b]%username[b]'s account"
    set mask(INVITE) "\[[b]%sitein[b]\] INVITE: [b]%nickname[b] by (%username from %group)"
    set mask(NEWDIR) "\[[b]%sitein[b]\] \002NEW RELEASE:\002 -%path- [b]%rel[b] at [b]%now[b] by [b]%user[b] from [b]%group[b] \[%tagline\]"
    set mask(DELDIR) "\[[b]%sitein[b]\] [b]DELETED:[b] %path/%rel by [b]%user[b]."
    set mask(NUKE) "\[[b]%sitein[b]\][b] -[b]%type %multx[b]-[b] %dir (Nuker: [b]%nuker[b] Nukee(s): [b]%nukee[b] Reason: [b]%reason[b])"
    set mask(UNNUKE) "\[[b]%sitein[b]\][b] -[b]%type %multx[b]-[b] %dir (Nuker: [b]%nuker[b] Nukee(s): [b]%nukee[b] Reason: [b]%reason[b])"
    set mask(LOGIN) "\[[b]%sitein[b]\] [b]LOGIN:[b] %user from %group just logged in."
    set mask(LOGOUT) "\[[b]%sitein[b]\] [b]LOGOUT:[b] %user from %group just logged out."
    set mask(AUTONUKE) ""
    set enabled(updater) 1
    set enabled(santino_zipscript) 0
    set enabled(announce) 1
    set enabled(announce_toallbots) 0
    set enabled(stats) 1
    set enabled(stats_info) 1
    set enabled(stats_calc) 1
    set enabled(stats_df) 1
    set enabled(stats_rules) 1
    set enabled(stats_nuketop) 1
    set enabled(stats_free) 1
    set enabled(stats_who) 1
    set enabled(stats_traffic) 1
    set enabled(stats_laston) 1
    set enabled(stats_search) 1
    set enabled(stats_dupe) 1
    set enabled(stats_seen) 1
    set enabled(stats_speed) 1
    set enabled(stats_nukes) 1
    set enabled(stats_user) 1
    set enabled(stats_usage) 1
    set enabled(dcc) 1
    set enabled(site_invite) 0
    set enabled(site_msginvite) 0
    set enabled(site_msgbnc) 0
    set enabled(site_msgaddip) 0
    set enabled(auto_bw) 0
    set enabled(auto_wktop) 0
    set timer(wktop) 360
    set timer(bw) 60
    set hideinwho "sitebot"
    set bnclist "123.456.789.0:21 123.456.789.0:1992"
    set invitechan #sbgl
    set sitename "My Site Name"
    set sitein "MSN"
    set outputt 1
    set showrequest 1
    set prefix !msn
    set dcc_prefix s
    set logfile ~/msn.log
    set dirlog_testchans "#sbgl #sbgl2"
    set sonjoin 1
    set site(ip) localhost
    set site(port) 3212
    set site(user) !sitebot
    set site(pass) wally
    set today /today
    set ftpwho /glftpd/bin/ftpwho
    set glftpddir /glftpd
    set gllog $glftpddir/ftp-data/logs/glftpd.log
    set glusers $glftpddir/ftp-data/users
    set glbindir $glftpddir/bin
    set deny_post {*/site/pre/* */site/groups/* *demo* *sample* *cover* *kbps*}
    set ver SiteBot-v2.8-glftpd-edition
    set flag6 S
    set flag7 N
    set flag8 C
  }
}

proc updateapi {} {
  uplevel #0 {
    set file [open $sitebot(api) w]
    puts $file "# $sitebot(api)"
    puts $file ""
    puts $file "# for help in configuration of this file view: sitebot-glftpd.api.help"
    puts $file "# this file is best edited using dcc function: .sset"
    puts $file ""
    puts $file "set apiversion $currentapiversion; # dont touch this line."
    puts $file ""
    puts $file "set sectionnames \"$sectionnames\""
    puts $file "set defaultsection \"$defaultsection\""
    puts $file "set types \"$types\""
    puts $file ""
    foreach section $sectionnames {
      if {![info exists sections($section-path)]} {set section($section-path) "/path/not/set"}
      puts $file "set sections($section-path) \"$sections($section-path)\""
      foreach type [array names echovars] {
        if {![info exists chans($section-$type)]} {set chans($section-$type) "" }
        puts $file "set chans($section-$type) \"$chans($section-$type)\""
      }
      puts $file ""
    }
    puts $file ""

    foreach type [array names echovars] {
      if {![info exists echovars($type)]} {set echovars($type) "" }
      puts $file "set echovars($type) \"$echovars($type)\""
    }
    puts $file ""
    foreach type [array names echovars] {
      if {![info exists enabled_announce($type)]} {set enabled_announce($type) "0"}
      puts $file "set enabled_announce($type) $enabled_announce($type)"
    }
    puts $file ""
    foreach type [array names echovars] {
      if {![info exists mask($type)]} {set mask($type) "" }
      puts $file "set mask($type) \"[filt $mask($type)]\""
    }
    close $file
    exec mv $sitebot(api) scripts/sitebot
    putlog "api file: $sitebot(api) updated successfully."
    unset file
  }
}

proc update {} {
  uplevel #0 {
    if ![info exists sitedir] {
      set sitedir(vcd) /site/vcd/
      set sitedir(iso) /site/iso/
      set sitedir(mp3) /site/mp3/
      set sitedir(0day) /site/0day/
      set sitedir(request) /site/request/
    }
    if ![info exists df] {
      set df(2) "0DAY 3"
      set df(3) "ISO 3"
    }
    set file [open $sitebot(config) w]
    puts $file "# $sitebot(config)"
    puts $file "# this file is best edited using dcc function: .sset"
    puts $file ""
    puts $file "set configversion $currentconfigversion; # dont touch this line."
    puts $file ""
    foreach type [lsort [array names enabled]] {
      if {![info exists enabled($type)]} {set enabled($type) "0"}
      puts $file "set enabled($type) $enabled($type);# (0=off/1=on)"
    }
    puts $file "set invitechan $invitechan; #channel to invite to on \"site invite nickname\" and \"/msg bot !siteinv username pass\""
    puts $file "set bnclist \"$bnclist\"; # connectable ips ie \"ip1:port ip2:port ip3:port\" seperate with space.."
    puts $file "set timer(bw) $timer(bw);# Announce Bandwidth every x minutes"
    puts $file "set timer(wktop) $timer(wktop);# Announce Weektop Stats every x minutes"
    puts $file ""
    puts $file "set sitename \"$sitename\";# Full Site Name"
    puts $file "set sitein \"$sitein\";  # Short Site Name"
    puts $file "set outputt \"$outputt\";    # Notices = 0 or Private Messages = 1"
    puts $file "set showrequest \"$showrequest\"; # show.. \[SITE\] Blah has requested wkup etc... (0=off/1=on)"
    puts $file "set prefix \"$prefix\"; # prefix before public commands."
    puts $file "set dcc_prefix \"$dcc_prefix\";# Letter before commands in dcc chat"
    puts $file "set logfile \"$logfile\";   # Log File of changes made through Bot"
    puts $file "set dirlog_testchans \"$dirlog_testchans\";# Channels to announce to Seperate by space"
    puts $file "set sonjoin $sonjoin;       # show onjoin in pubchans (0=off/1=on)"
    puts $file "set today $today;    # today dir location relative to within ftp"
    puts $file ""
    foreach line [lsort -integer [array names df]] {
      puts $file "set df($line) \"$df($line)\";# df(linenumber) \"sectionname positionoffreespace\""
    }
    puts $file "set deny_post \"$deny_post\"; # dirs you want to not announce"
    puts $file "set hideinwho \"$hideinwho\"; # users who will be hidden in !sitewho and .swho"
    puts $file "set ftpwho \"$ftpwho\"; # /fullpath/filename to standard ftpwho binary which comes with glftpd"
    puts $file ""
    puts $file "# Site Stat Sections, note the name of the section will effect the type ie"
    puts $file "# !prefix vcd wkup !prefix iso wkup just copy/paste this line or delete lines"
    puts $file "# relative to how many stats sections you have on your site."
    puts $file "# These dirs are set relative to once you are logged onto the ftp ie no /glftpd"
    puts $file ""
    foreach sitedirtype [array names sitedir] {
      puts $file "set sitedir($sitedirtype) \"$sitedir($sitedirtype)\""
    }
    puts $file ""
    puts $file "# You need to make a login on your site with full siteop access if intending"
    puts $file "# to allow proper use of dcc section or just standard flags will do if only"
    puts $file "# using stats section. nuke flags required if you want autonuke.. best if you"
    puts $file "# ust make a login with siteop access and all the flags 14ABCDEFGH etc."
    puts $file ""
    puts $file "set site(ip) $site(ip);      # Site ip"
    puts $file "set site(port) $site(port);# Site Port"
    puts $file "set site(user) $site(user);      # Login Name"
    puts $file "set site(pass) $site(pass);     # Password"
    puts $file ""
    puts $file "# If you need to use a proxy to look at web pages from your shell and you"
    puts $file "# are using the update feature in the sitebot then change the following:"
    puts $file ""
    puts $file "set proxy(enabled) \"$proxy(enabled)\";             # 1 = yes 0 = no"
    puts $file "set proxy(host) \"$proxy(host)\";	 # Proxy Host"
    puts $file "set proxy(port) \"$proxy(port)\";             # Proxy Port"
    puts $file ""
    puts $file "# Where is GLFTPD located? probably dont need to change this..."
    puts $file ""
    puts $file "set glconf $glconf"
    puts $file "set glftpddir $glftpddir"
    puts $file "set gllog $gllog"
    puts $file "set glusers $glusers"
    puts $file "set glbindir $glbindir"
    close $file
    exec mv $sitebot(config) scripts/sitebot
    putlog "config file: $sitebot(config) updated succesfully."
    unset file
  }
}

proc sitebot:loadapi {} { global sitebot apiversion currentapiversion
  if {![file exists scripts/sitebot/$sitebot(api)]} {
    putlog "SITEBOT: api file: $sitebot(api) not in scripts dir, creating default api file."
    putlog "SITEBOT: recommended that you edit scripts/sitebot/$sitebot(api) asap..."
    set apiversion 2.8
    updateapi
  } else {
    putlog "SITEBOT: api located.... loading"
    uplevel #0 {source scripts/sitebot/$sitebot(api)}
  }

  if {![info exists apiversion]} {
    putlog "SITEBOT: cant read api version number... some idiot deleted it from the api file :)"
    putlog "SITEBOT: updating api file. default values used for missing variables.."
    set apiversion 2.8
    updateapi
  }

  if {$apiversion < $currentapiversion} {
    putlog "SITEBOT: api file is old updating... default values been used for"
    putlog "SITEBOT: missing variables strongly recommend you edit scripts/sitebot/$sitebot(api)"
    set apiversion 2.8
    updateapi
  }

  if {$apiversion == $currentapiversion} {
        #putlog "SITEBOT: api version matchs tcl version! Variables Read Succesfully!"
  }

  if {$apiversion > $currentapiversion} {
    putlog "SITEBOT: api version is newer then tcl... no changes made"
    putlog "SITEBOT: possibility for errors due to version mismatch"
  }

}

proc sitebot:loadconf {} { global sitebot configversion currentconfigversion

  if {![file exists scripts/sitebot/$sitebot(config)]} {
    putlog "SITEBOT: config file: $sitebot(config) not in scripts dir, creating default file."
    putlog "SITEBOT: recommended that you edit scripts/sitebot/$sitebot(config) asap..."
    set configversion 2.8
    update
  } else {
    putlog "SITEBOT: config located.... loading"
    uplevel #0 {source scripts/sitebot/$sitebot(config)}
  }

  if {![info exists configversion]} { global configversion
    putlog "SITEBOT: cant read config version number... some idiot deleted it from the conf file :)"
    putlog "SITEBOT: updating config file. default values used for missing variables.."
    set configversion 2.8
    update
  }

  if {$configversion < $currentconfigversion} {
    putlog "SITEBOT: config file is old updating... default values been used for"
    putlog "SITEBOT: missing variables strongly recommend you edit your conf.."
    set configversion 2.8
    update
  }

  if {$configversion == $currentconfigversion} {
        #putlog "SITEBOT: config version matchs tcl version! Variables Read Succesfully!"
  }

  if {$configversion > $currentconfigversion} {
    putlog "SITEBOT: config version is newer then tcl... no changes made"
    putlog "SITEBOT: possibility for errors due to version mismatch"
  }
}

proc sitebot:checkscripts {} { global glbindir enabled enabled_announce
  putlog "SITEBOT: checking for missing files in $glbindir and eggdrop scripts/sitebot dir."
  set die 0
  if {![file exists scripts/sitebot/ftp_lib.tcl]} {
    putlog "SITEBOT: - missing \"ftp_lib.tcl\" from eggdrop scripts directory."
    set die 1
  } {
    uplevel #0 {
      source scripts/sitebot/ftp_lib.tcl
    }
  }
  if $enabled(updater) {
    if ![file exists scripts/sitebot/http.tcl] {
      putlog "SITEBOT: - missing \"http.tcl\" to be in your eggdrop scripts directory."
    } {
      uplevel #0 {
        source scripts/sitebot/http.tcl
      }
    }
  }
  if $enabled(announce) {
    if {![file exists $glbindir/tail]} { putlog "SITEBOT: - missing \"tail\"" ; set die 1}
    if $enabled_announce(AUTONUKE) {if {![file exists $glbindir/autonuke]} {putlog "SITEBOT: - missing \"autonuke\"" ; set die 1 } }
  }
  if $enabled(auto_wktop) {
    if {![file exists $glbindir/weektop]} { putlog "SITEBOT: - missing \"weektop\"" ; set die 1}
  }

  if $enabled(stats_df) {
    if {![file exists $glbindir/df]} { putlog "SITEBOT: - missing \"df\"" ; set die 1}
  }

  if {[expr $enabled(site_msgaddip) + $enabled(site_msginvite) + $enabled(site_msgbnc)] > 0} {
    if {![file exists $glbindir/passchk]} {putlog "SITEBOT: - missing \"passchk\"" ; set die 1 }
  }

  if {$die == "1"} {
    putlog "SITEBOT: will not load until missing files are in $glbindir"
    uplevel #0 { die }
  }
}

proc sitebot:connftp {} { global site
  utimer 5 "FTP::Open $site(ip) $site(port) $site(user) $site(pass)";     # open ftp connection timer - 5sec int
  timer 1 pwdtimer;                                                       # call password timer - 1sec int
  proc pwdtimer {} { timer 1 pwdtimer ; FTP::Pwd };                       # send password
}

proc sitebot:killoldtimers {} {
  foreach this [timers] {
    if {([string compare [lindex $this 1] "pwdtimer"] == 0) || ([string compare [lindex $this 1] "sitebot:auto_bandwidth"] == 0) || ([string compare [lindex $this 1] "sitebot:auto_weektopstats"] == 0) } {
      killtimer [lindex $this 2]
    }
  }
}

proc sitebot:addonsearch {} {global script
  putlog "- Searching for sitebot addons"
  if {[catch { set scripts [glob scripts/sitebot/sitebot-addon-*.tcl] } ] != 0 } { putlog "- No sitebot addons found" } {
    foreach script $scripts {
      putlog "  - Loading $script"
      uplevel #0 {source $script}
    }
    putlog "- Finished loading addons"
  }
}

#######################################################
################## SITEBOT UPDATER ####################
#######################################################

proc sitebot:updater {} {
  uplevel #0 {

    proc sitebot:checkfile {fn} {
      set check [open $fn r]
      gets $check line
      if {[string index $line 0] == "<"} {
        close $check
        file delete $fn
        return 0
      }
      close $check ; return 1
    }

    bind dcc C ${dcc_prefix}update dcc_update

    proc dcc_update {hand idx arg} {
      global configversion dcc_prefix proxy www
      set cmd [lindex $arg 0]
      putlog "#$hand# ${dcc_prefix}update $arg"
      switch -exact -- $cmd {
        "tarball" {
          putdcc $idx "sitebot: connecting to webpage... attempting to download sitebot tarball"
          if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}version.txt" ; set tok [http_get $url] ; upvar #0 $tok state ; set currentversion [lindex $state(body) 0]
          set url "${www}sitebot-${currentversion}.tar.gz"
          set out [open scripts/sitebot/sitebot-${currentversion}.tar.gz w] ; set tok [http_get $url -channel $out] ; close $out
	  set result [sitebot:checkfile scripts/sitebot/sitebot-${currentversion}.tar.gz]
  	  if {$result == 0} {
	    putdcc $idx "Download of sitebot-${currentversion}.tar.gz unsuccessful.. file not found"
	  } {
	    putdcc $idx "sitebot: sitebot-${currentversion}.tar.gz Successfully Downloaded"
	  }
        } "deladdon" {
          set file [lindex $arg 1]
          if { $file == "" } {putdcc $idx "Usage: .${dcc_prefix}update deladdon <addon_name>" ; return 0 }
          putdcc $idx "sitebot: request to remove addon: $arg"
          if {![file exists scripts/sitebot/sitebot-addon-${file}.tcl]} { putdcc $idx "scripts/sitebot/sitebot-addon-${file}.tcl not found." ; return 0 }
          set result [exec rm scripts/sitebot/sitebot-addon-${file}.tcl]
          putdcc $idx "sitebot: sitebot-addon-${file}.tcl removed. Please type .rehash for changes to take effect"
        } "addonlist" {
          putdcc $idx "sitebot: connecting to webpage... looking up addons list.."
          if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}addons/list.txt"
          set tok [http_get $url] ; upvar #0 $tok state
	  set counter "-1" ; foreach body [array names state] { set counter [expr $counter + 1] ; set file [lindex $state(body) $counter] ; putdcc $idx "$file" }
        } "getaddon" {
          set file [lindex $arg 1]
          if { $file == "" } {putdcc $idx "Usage: .${dcc_prefix}update getaddon <addon_name>" ; return 0 }
          putdcc $idx "sitebot: connecting to webpage... attempting to download the addon : $file"
          set url "${www}addons/sitebot-addon-${file}.tcl"
          set out [open scripts/sitebot/sitebot-addon-${file}.tcl w] ; set tok [http_get $url -channel $out] ; close $out
	  set result [sitebot:checkfile scripts/sitebot/sitebot-addon-${file}.tcl]
  	  if {$result == 0} {
	    putdcc $idx "Download of $file unsuccessful.. addon doesnt exist! (.${dcc_prefix}update addonlist <-- list available addons!)"
	  } {
  	    putdcc $idx "Download of $file complete... type .rehash to load it."
	  }
  	} "checkversion" {
          putdcc $idx "sitebot: checking for new versions of sitebot tcl"
          if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}version.txt"
          set tok [http_get $url] ; upvar #0 $tok state
          set currentversion [lindex $state(body) 0]
          if {$configversion < $currentversion} { 
  	    putdcc $idx "Your Version: $configversion Latest Version: $currentversion" 
	    putdcc $idx "Seems you have an old version!"
	    putdcc $idx " \".${dcc_prefix}update install\" to download and install the latest version."
	    putdcc $idx " \".${dcc_prefix}update tarball\" to just grab the latest pack."
	  }
          if {$configversion == $currentversion} { putdcc $idx "Your Version: $configversion Latest Version: $currentversion" ; putdcc $idx "Versions Match! Seems your uptodate!" }
          if {$configversion > $currentversion} { putdcc $idx "Your Version: $configversion Latest Version: $currentversion" ; putdcc $idx "If your seeing this i mustnt be keeping my web page uptodate" ; putdcc $idx "or someone has changed the versions or someone else is maintaining" ; putdcc $idx "my script now! who knows?" }
        } "install" {

	  set choice [lindex $arg 1]
	  if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}version.txt"
          set tok [http_get $url] ; upvar #0 $tok state
          set currentversion [lindex $state(body) 0]

	  if {$choice != "nocheck"} {
  	    putdcc $idx "sitebot: checking to makesure your running an old version."
  	    if {$configversion < $currentversion} { putdcc $idx "Your Version: $configversion Latest Version: $currentversion" }
            if {$configversion == $currentversion} { putdcc $idx "Your Version: $configversion Latest Version: $currentversion" ; putdcc $idx "Versions Match! Seems your already uptodate! ... Exiting Update" ; return 0 }
            if {$configversion > $currentversion} { putdcc $idx "Your Version: $configversion Latest Version: $currentversion" ; putdcc $idx "If your seeing this i mustnt be keeping my web page uptodate" ; putdcc $idx "or someone has changed the versions or someone else is maintaining" ; putdcc $idx "my script now! who knows? ... Exiting Update" ; return 0 }
          }

          putdcc $idx "connecting to webpage... attempting to upgrade.. fingers crossed :)"
          if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}list.txt"
          set tok [http_get $url] ; upvar #0 $tok state

          file mkdir scripts/sitebot
	  file mkdir scripts/sitebot/extras
	  file mkdir scripts/sitebot/extras/sources
	  file mkdir scripts/sitebot/extras/misc

          set counter "-1"
	  foreach body [array names state] {
	    incr counter ; set file [lindex $state(body) $counter] 
	    if {$file == ""} {continue}
	    putdcc $idx "downloading : ${www}$file"
	    set url "${www}$file"
            set out [open scripts/sitebot/$file w] ; set tok [http_get $url -channel $out] ; close $out
	    set result [sitebot:checkfile scripts/sitebot/$file]
	    if {$result == 0} {
      	      putdcc $idx "missing file : ${www}$file"
	    } {
      	      putdcc $idx "downloaded : ${www}$file"	      
	    }
	  }

          if $proxy(enabled) {http_config -proxyhost $proxy(host) -proxyport(port)}
          set url "${www}/updateinfo.txt"
          set tok [http_get $url] ; upvar #0 $tok state
	  set counter "-1" ; foreach body [array names state] { set counter [expr $counter + 1] ; set file [lindex $state(body) $counter] ; putdcc $idx "$file" }
          putdcc $idx ""
          putdcc $idx "Upgrade to SiteBot $currentversion Complete.. Type .restart for changes to take effect."
          putdcc $idx ""
	  putdcc $idx "Please look in sitebot-glftpd.changelog for changes (in your eggdrop scripts dir)"
	}

        default {putdcc $idx ".${dcc_prefix}update help.............."
                 putdcc $idx ".${dcc_prefix}update install          - downloads and installs latest sitebot-glftpd tcl"
 	         putdcc $idx ".${dcc_prefix}update install nocheck  - downloads and installs latest sitebot-glftpd tcl (doesnt makesure your running an old version)"
                 putdcc $idx ".${dcc_prefix}update tarball          - downloads latest sitebot tar.gz to your scripts/sitebot dir"
                 putdcc $idx ".${dcc_prefix}update checkversion     - checks to see if you have the latest version"
                 putdcc $idx ".${dcc_prefix}update addonlist        - lists available addons"
                 putdcc $idx ".${dcc_prefix}update getaddon <name>  - download and install an addon."
                 putdcc $idx ".${dcc_prefix}update deladdon <name>  - delete an addon from your scripts/sitebot dir."
        }
      }
    }
    sitebot:addversion "Script Updater v0.6"
  }
}

#######################################################
################### AUTORUN SCRIPT ####################
#######################################################

#BANDWIDTH ANNOUNCE

proc sitebot:autobw {} {
  uplevel #0 {
    timer $timer(bw) sitebot:auto_bandwidth

    proc sitebot:auto_bandwidth {} { global mask echovars dirlog_testchans sitein sitename timer
      set result [sitebot:bw]
      set now [clock format [clock seconds] -format "%H:%M"]
      if {$result == 0} {putchan $chan "\[[b]$sitein[b]\] bandwidth function not working. ftp showing no users, this should not happen since sitebot logs in." ; return 0 }
      set count -1
      foreach value $echovars(BW) {
        set count [expr $count + 1]
        set procvalue($value) [lindex $result $count]
      }
      set put "$mask(BW)"
      if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
      if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
      if {[string match "*%now*" $put]} {set put [str $put %now $now]}
      foreach value $echovars(BW) {
        set myoutput $procvalue($value)
        if {[string match "*%$value*" $put]} {set put [str $put %$value $myoutput]}
      }
      if {[string match "*;*" $put]} {
        foreach line [split $put ";"] {
          foreach channel $dirlog_testchans {
            putchan $channel $line
          }
        }
      } {
        foreach channel $dirlog_testchans {
          putchan $channel $put
        }
      }
      timer $timer(bw) sitebot:auto_bandwidth
    }
  }
}

#WEEKTOPSTATS

proc sitebot:autowktop {} {
  uplevel #0 {
    timer $timer(wktop) sitebot:auto_weektopstats

    proc sitebot:auto_weektopstats {} { global sitein glbindir dirlog_testchans timer
      foreach line [split [exec $glbindir/weektop] \n] {
        foreach chan $dirlog_testchans {
          putchan $chan "\[\002$sitein\002\] WEEKTOPANNOUNCE-\002 $line"
        }
      }
      timer $timer(wktop) sitebot:auto_weektopstats
    }
  }
}

#######################################################
############# ADDIP/INVITE/BNC SCRIPT #################
#######################################################

proc sitebot:msgaddip {} {
  uplevel #0 {

    bind msg - !siteaddip msg_siteaddip

    proc msg_siteaddip { nick uhost hand arg } { global logfile
      set username [lindex $arg 0]
      set password [lindex $arg 1]
      set ip [lindex $arg 2]
      if {[checkpass $username $password]} {
        set fd [open "$logfile" a] ; puts $fd "[logtime] - ADDIP $hand ($uhost) - $arg" ; close $fd
        set result [FTP::Site addip $username $ip]
        foreach line $result {putmsg $nick $line}
        return 0
      }
      set fd [open "$logfile" a] ; puts $fd "[logtime] - BAD ADDIP $hand ($uhost) - $arg" ; close $fd
      putmsg $nick "Invalid Username/Password... This attempt has been logged."
    }
  }
}

proc sitebot:msginvite {} {
  uplevel #0 {
    bind msg - !siteinv msg_siteinv

    proc msg_siteinv { nick uhost hand arg } { global invitechan logfile mask echovars sitein sitename
      set now [clock format [clock seconds] -format "%H:%M"]

      set username [lindex $arg 0]
      set password [lindex $arg 1]
      if {[checkpass $username $password]} {
        set group [glreadgroup $username]
        set put "$mask(MSGINVITE)"
        if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
        if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
        if {[string match "*%now*" $put]} {set put [str $put %now $now]}
        if {[string match "*%uhost*" $put]} {set put [str $put %uhost $uhost]}
        if {[string match "*%nick*" $put]} {set put [str $put %nick $nick]}
        if {[string match "*%username*" $put]} {set put [str $put %username $username]}
        if {[string match "*%chan*" $put]} {set put [str $put %chan $invitechan]}
        if {[string match "*%group*" $put]} {set put [str $put %group $group]}
        set fd [open "$logfile" a] ; puts $fd "[logtime] - INVITE $hand ($uhost) ---> $invitechan" ; close $fd

        putchan $invitechan $put
        putserv "INVITE $nick $invitechan"
        return 0
      } {
        set fd [open "$logfile" a] ; puts $fd "[logtime] - BAD INVITE $hand ($uhost) ---> $arg" ; close $fd
        putmsg $nick "Invalid Username/Password. This attempt has been logged."

        set put "$mask(BADMSGINVITE)"
        if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
        if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
        if {[string match "*%now*" $put]} {set put [str $put %now $now]}
        if {[string match "*%uhost*" $put]} {set put [str $put %uhost $uhost]}
        if {[string match "*%nick*" $put]} {set put [str $put %nick $nick]}
        if {[string match "*%username*" $put]} {set put [str $put %username $username]}
        if {[string match "*%chan*" $put]} {set put [str $put %chan $invitechan]}
        putchan $invitechan $put
      }
    }
  }
}

proc sitebot:msgbnc {} {
  uplevel #0 {

    bind msg - !sitebnc pub_sitebnc

    proc pub_sitebnc { nick uhost hand arg } { global bnclist sitename logfile
      set username [lindex $arg 0] ; set password [lindex $arg 1]
      if {[checkpass $username $password]} {
        set fd [open "$logfile" a] ; puts $fd "[logtime] - SITEBNC $hand ($uhost) $arg" ; close $fd
        putmsg $nick "$sitename Connectable IPs."
        foreach ip $bnclist {putmsg $nick $ip}
        return 0
      }
      set fd [open "$logfile" a] ; puts $fd "[logtime] - BAD SITEBNC $hand ($uhost) $arg" ; close $fd
      putmsg $nick "Invalid Username/Password. This attempt has been logged."
    }
  }
}

#######################################################
################## ANNOUNCE SCRIPT ####################
#######################################################

proc sitebot:announce {} {
  uplevel #0 {
    set nuke(dir) "" ; set lasttype ""
    set default $defaultsection

    proc announce {chans put} { global enabled
      putlog $put
      foreach chan $chans { putchan $chan $put }
      if $enabled(announce_toallbots) {putallbots "sndall $put"}
    }

    proc announce_nuke {} { global nuke sitein path rel now mask chans name sitename nuke
      if {$nuke(shown) == 1} {return 0}
      set nuke(nukee) [string trim $nuke(nukee) "\002,\002 "]
      set put $mask($nuke(type))
      if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
      if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
      if {[string match "*%now*" $put]} {set put [str $put %now $now]}
      if {[string match "*%path*" $put]} {set put [str $put %path $path]}
      if {[string match "*%rel*" $put]} {set put [str $put %rel $rel]}
      foreach value [array names nuke] {
        if {[string match "*%$value*" $put]} {set put [str $put %$value $nuke($value)]}
      }
      if {[string length $put] > 0} {
        if {[string match "*;*" $put]} {foreach line [split $put ";"] {announce $chans([get_section $path]-$name) $line}} {
          announce $chans([get_section $path]-$name) $put
        }
      }
      set nuke(shown) 1 ; set nuke(dir) ""
    }

    proc nukeline {type dir args} { global lasttype nuke
      set args [lindex $args 0]
      if {[string match $nuke(dir) $dir] && [string match $lasttype $type]} {
        append nuke(nukee) "[lindex $args 2] ([lindex [lindex $args 3] 1]\002MB\002)\002,\002 "
      } else {
        set nuke(type) $type
        set nuke(dir) $dir
        set nuke(nuker) [lindex $args 1]
        set nuke(nukee) "[lindex $args 2] ([lindex [lindex $args 3] 1]\002MB\002)\002,\002 "
        set nuke(mult) [lindex [lindex $args 3] 0]
        set nuke(reason) [lindex $args 4]
        set nuke(shown) 0
        utimer 2 announce_nuke
      }
      set lasttype $type
      set lastdir $dir
    }

    proc rel { fpath } {
      set split [split $fpath "/"];
      set ll [llength $split];
      if {$ll < 3} { return "\{ERR\} \{ERR\}"; }
      set loc "[lindex $split [expr $ll - 2]]";
      set rel "[lindex $split [expr $ll - 1]]";
      if {[string match "\[cC\]\[dD\]\[0-9\]" $rel] ||
        [string match "\[dD\]\[iI\]\[sS\]\[cCkK\]*" $rel] ||
        [string match "\[cC\]\[oO\]\[vV\]\[eE\]\[rR\]" $rel] ||
        [string match "\[pP\]\[aA\]\[rR\]\[tT\]*" $rel]} {
          set loc "[lindex $split [expr $ll - 3]]";
          set rel "[lindex $split [expr $ll - 2]]/$rel";
      }
      return "\{$loc\} \{$rel\}";
    }

    proc nukechk {nukepath p} { global glbindir sitein mask
      set fd [open "|$glbindir/autonuke $p"]
      if {![eof $fd]} { set pq [gets $fd] }
      close $fd
      if { $pq == "Can not open DUPELOG" } { putlog "ERROR OPENING DUPELOG" ; set pq "" }
      if { $pq != "" } {
        putlog "***** AUTONUKING $p (REUP $pq)"
        sndall "\[[b]$sitein[b]\] [b]AUTONUKE:[b] $p ----> (REUP-$pq)"
        FTP::Cd $nukepath
        FTP::Site "nuke $p 1 (REUP--$pq)"
      }
    }

    if {![info exists tail]} {
      set tail [open "|$glbindir/tail -f -n0 $gllog" r]
      fileevent $tail readable "newline $tail"
    }

    proc newline { tail } { global mask
      if {[gets $tail line]<0} {
        close $tail
        putlog "something fucked up... closing tail."
        return
      }
      putlog "raw dataline: $line"
      catch {newline:parse $line} problems
      if {$problems != 0} {putlog $problems}
    }

    proc newline:parse { line } {
      global mask enabled_announce echovars deny_post invitechan name sitein now path rel chans defaultsection sitename
      global formatted_file_transfer_time formatted_race_elapsed_time formatted_total_release_size enabled sitebot

      # set type global variables

      if {$line == ""} {return 0}
      if {[catch {set date [clock scan [lrange $line 0 4]]}] != 0} {return 0}
      set now [clock format [clock seconds] -format "%H:%M"]
      set name [string trimright [lindex $line 5] ":"]
      set args [lrange $line 6 end]
      set path $defaultsection

      # test validity

      set stop 0
      if {![info exists echovars($name)]} {putlog "echovars($name) is not set in $sitebot(api) file." ; set stop 1}
      if {![info exists mask($name)]} {putlog "mask($name) is not set in $sitebot(api) file." ; set stop 1}
      if {![info exists enabled_announce($name)]} {putlog "enabled_announce($name) is not set in $sitebot(api) file." ; set enabled_announce($name) "0";}
      if {$enabled_announce($name) == "0"} {set stop 1}
      foreach skip $deny_post {if {[string match "$skip" [string tolower [lindex $args 0]]]} {set stop 1}}
      if {$stop == "1"} {return 0}

      # set type unique variables

      if {[lsearch -exact $echovars($name) "pf"] != -1} {
        set pf [rel [lindex $args 0]]
        set path [lindex $pf 0]
        set rel [lindex $pf 1]
      }
      set count -1
      foreach value $echovars($name) {
        set count [expr $count + 1]
        set procvalue($value) [lindex $args $count]
      }

      # run type unique functions

      if {[lsearch -exact $echovars($name) "group"] != -1} { if { $procvalue(group) == "" } { set procvalue(group) "NoGroup" } }
      if {[string match "INVITE" $name]} {
        putserv "INVITE $procvalue(nickname) $invitechan"
      }
      if {[string match "NEWDIR" $name]} {if {$enabled_announce(AUTONUKE)} {[nukechk $path $rel]} }
      if {[string match "NUKE" $name]} { nukeline NUKE $rel $args ; return 0}
      if {[string match "UNNUKE" $name]} { nukeline UNNUKE $rel $args ; return 0}

      # santino custom type uniques

      if $enabled(santino_zipscript) {
        if {[lsearch "COMPLETE_RACE_AND_GROUP_TIE COMPLETE_GROUP_TIE COMPLETE_RACE_TIE COMPLETE COMPLETE_RACE_AND_GROUP_TIE_HALFWAY COMPLETE_RACE_TIE_HALFWAY COMPLETE_GROUP_TIE_HALFWAY COMPLETE_HALFWAY" $name] != -1} {
          get_race_time $procvalue(race_elapsed_time)
          get_size $procvalue(total_release_size)
        }
        if {[string match "ZIP" $name]} {
          get_size $procvalue(total_release_size)
        }
        if {[string match "NEWRACER" $name] || [string match "RACESTART" $name]} {
          get_file_time $procvalue(file_transfer_time)
          get_race_time $procvalue(race_elapsed_time)
        }
      }

      # substitue %values with $values

      set put "$mask($name)"
      foreach value $echovars($name) {
        set myoutput $procvalue($value)
        if {[string match "*%$value*" $put]} {set put [str $put %$value $myoutput]}
      }

      if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
      if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
      if {[string match "*%now*" $put]} {set put [str $put %now $now]}
      if {[string match "*%path*" $put]} {set put [str $put %path $path]}
      if {[string match "*%rel*" $put]} {set put [str $put %rel $rel]}

      if {[string match "*%formatted_file_transfer_time*" $put]} {set put [str $put %formatted_file_transfer_time $formatted_file_transfer_time]}
      if {[string match "*%formatted_race_elapsed_time*" $put]} {set put [str $put %formatted_race_elapsed_time $formatted_race_elapsed_time]}
      if {[string match "*%formatted_total_release_size*" $put]} {set put [str $put %formatted_total_release_size $formatted_total_release_size]}
      if {[string length $put] > 0} {
        if {[string match "*;*" $put]} {foreach line [split $put ";"] {announce $chans([get_section [lindex $args 0]]-$name) $line}} {
          announce $chans([get_section [lindex $args 0]]-$name) $put
        }
      }
    }
  }
}

#######################################################
#################### STATS SCRIPT #####################
#######################################################

proc sitebot:stats {} {
  uplevel #0 {

    #ONJOIN
    bind join - * siteonjoin

    proc siteonjoin {nick uhost hand chan} { global sonjoin sitein prefix dirlog_testchans
      if {$sonjoin != "1"} {return 0}
      if {[lsearch [string tolower $dirlog_testchans] [string tolower $chan]] == -1} {return 0}
      putnot $nick "[b]\[[b]$sitein[b]\][b] Type [b]${prefix}help[b] to view the list of commands"
    }

    #MAIN STATS
    if $enabled(stats_info) {
      bind pub - ${prefix} pub_stats

      proc pub_stats { nick uhost hand chan arg } { global sitein outputt ver sitedir prefix dirlog_testchans
        if {[lsearch -exact [string tolower $dirlog_testchans] [string tolower $chan]] == -1} {return 0}
        set _section [string tolower [lindex $arg 0]]
        set cmd [string tolower [lindex $arg 1]]
        if [info exists sitedir($_section)] {
          set dir $sitedir($_section)
          set section [string toupper $_section]
          set cmd [lindex $arg 1]
        } {
          putnm $nick "Sorry, there is no section named $_section"
          putnm $nick "Valid sections are: [array names sitedir]"
          return 0
        }

        switch -exact -- $cmd {
          "wkup" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section WEEKTOP-\002 Request for $nick"
            FTP::Cd $dir
            set result [FTP::Site wkup]
            foreach line $result { putnm $nick $line }
          } "wkdn" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section WEEK DOWN-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site wkdn]
            foreach line $result { putnm $nick $line }
          } "alup" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section ALLTIME WEEKTOP-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site alup]
            foreach line $result { putnm $nick $line }
          } "aldn" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section ALLTIME DOWNLOADERS-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site aldn]
            foreach line $result { putnm $nick $line }
          } "gpwk" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section GROUP WEEKTOP-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site gpwk]
            foreach line $result { putnm $nick $line }
          } "gpal" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section GROUP ALLTIME TOP-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site gpal]
            foreach line $result { putnm $nick $line }
          } "gpwd" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section GROUP WEEKTOP DOWN-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site gpwd]
            foreach line $result { putnm $nick $line }
          } "gpad" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section GROUP ALLTIME DOWN-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site gpad]
            foreach line $result { putnm $nick $line }
          } "dayup" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section DAYTOP UP-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site dayup]
            foreach line $result { putnm $nick $line }
          } "daydn" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section DAYTOP DOWN-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site daydn]
            foreach line $result { putnm $nick $line }
          } "monthup" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section MONTH TOP-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site monthup]
            foreach line $result { putnm $nick $line }
          } "monthdn" {
            putchanreq $chan "\[\002$sitein\002\] Processing \002-$section MONTH DOWN-\002 Request For $nick"
            FTP::Cd $dir
            set result [FTP::Site monthdn]
            foreach line $result { putnm $nick $line }
          } "new" {
            set num [lindex $arg 2]
            if { $num == "" } { putnm $nick "Usage: $prefix $_section new <#number> - For last <#number> Uploads" ; return 0}
            if { $num < 100 } { putchanreq $chan "\[\002$sitein\002\] Processing \002-$section RECENT UPLOADS-\002 Request for $nick" }
            FTP::Cd $dir
            set result [FTP::Site "new $num"]
            foreach line $result { putnm $nick $line }
          }
            default {putnm $nick "$cmd is not valid. type ${prefix}help"}
        }
      }
    }


    #CALC
    if $enabled(stats_calc) {
      bind pub - ${prefix}calc pub_calc

      proc formattime {var1} {
        set hms [clock format $var1 -format "%T" -gmt true]
        set days [expr [clock format $var1 -format "%j" -gmt true] - 1]
        return "$hms:$days"
      }

      proc pub_calc {nick uhost hand chan args} { global sitein
        set args [string trim [string trim $args \{ ] \}]
        if {[string match "\"" $args]} {set args "illegal illegal illegal"}
        putchanreq $chan "\[\002$sitein\002\] Processing \002-CALC-\002 Request for $nick"
        if { [llength $args] != 3 } {putchan $chan "Valid arguments (speed(k/s) size(mb) time(s)). Input a 0 for the argument you wish to calculate." ; return 0}
        set arg1 [lindex $args 0] ; set arg2 [lindex $args 1] ; set arg3 [lindex $args 2]
        if { [string length $arg1] >= 7 || [string length $arg2] >= 7 || [string length $arg3] >= 7 } {putchan $chan "Overflow.. please use realistic values." ; return 0}

        set illegalchar1 [regexp \[^0-9\] $arg1]
        set illegalchar2 [regexp \[^*0-9\] $arg2]
        set illegalchar3 [regexp \[^0-9\] $arg3]
        if { $illegalchar1 == 1 || $illegalchar2 == 1 || $illegalchar3 == 1 } {
          putchan $chan "Input had illegal characters.. please try again."
          putchan $chan "Valid arguments: (speed(k/s) size(mb) time(s)). Input a 0 for the argument you wish to calculate."
          return 0
        }
        if { $arg1 == 0 && $arg2 == 0 } { putchan $chan "You can only set one argument to 0." ; return 0}
        if { $arg1 == 0 && $arg3 == 0 } { putchan $chan "You can only set one argument to 0." ; return 0}
        if { $arg2 == 0 && $arg3 == 0 } { putchan $chan "You can only set one argument to 0." ; return 0}
        if { $arg1 != 0 && $arg2 != 0 && $arg3 != 0 } { putchan $chan "You must set one argument to 0." ; return 0}

        if { $arg1 == 0 } {putchan $chan "Speed: [round [expr [expr $arg2 * 1024] / $arg3] 2]\k/s, Size: $arg2\MB, Time: [formattime $arg3] ($arg3\s)"}
        if { $arg2 == 0 } {putchan $chan "Speed: $arg1\k/s, Size: [expr [expr $arg1 * $arg3] / 1024]\MB, Time: [formattime $arg3] ($arg3\s)"}
        if { $arg3 == 0 } {putchan $chan "Speed: $arg1\k/s, Size: $arg2\MB, Time: [formattime [expr [expr $arg2 * 1024] / $arg1]] ([expr [expr $arg2 * 1024] / $arg1]\s)"}
      }
    }

    #DUPE
    if $enabled(stats_dupe) {
      bind pub - ${prefix}dupe pub_dupe

      proc pub_dupe { nick uhost hand chan args } { global sitein prefix outputt
        set string [lindex $args 0]
        if { $string == "" } {putnm $nick "Usage: ${prefix}dupe <string>" ; return 0 }
        putchanreq $chan "\[\002$sitein\002\] Processing \002-DUPE-\002 Request for $nick"
        set result [FTP::Site "dupe $string 50"]
        foreach line $result { putnm $nick $line }
      }
    }


    #WHO
    if $enabled(stats_who) {
      bind pub - ${prefix}who pub_who
      proc pub_who {nick host handle chan text} { global sitein outputt hideinwho
        putchanreq $chan "\[\002$sitein\002\] Processing \002-WHO-\002 Request For $nick"
        set result [FTP::Site who]
        foreach line $result {
          set skip 0
          foreach user $hideinwho {if {[lsearch -exact [lindex $line 1] $user] != -1} {set skip 1}}
          if {$skip == 0} { putnm $nick $line }
        }
      }
    }

    #LASTON
    if $enabled(stats_laston) {
      bind pub - ${prefix}laston pub_laston

      proc pub_laston {nick host handle chan text} { global sitein outputt
        putchanreq $chan "\[\002$sitein\002\] Processing \002-LAST ON-\002 Request For $nick"
        set result [FTP::Site laston]
        foreach line $result { putnm $nick $line }
      }
    }


    #SPEED
    if $enabled(stats_speed) {
      bind pub - ${prefix}speed pub_speed

      proc pub_speed { nick uhost hand chan args } { global sitein prefix outputt hideinwho ftpwho
        set user [lindex $args 0]
        if {($user == "") || ([llength $args] != 1)} {putnm $nick "Usage: ${prefix}speed <username>" ; return 0}
        set result [sitebot:speed $user]
        if {$result == ""} {putnm $nick "$user is not currently logged in." ; return 0}
        if {$result == 0} {putnm $nick "user [b]$user[b] is hidden in site who." ; return 0}
        if {$result == 1} {putnm $nick "$ftpwho does not exist." ; return 0}
        foreach line $result { putnm $nick $line  }
      }
    }


    #SEEN
    if $enabled(stats_seen) {
      bind pub - ${prefix}seen pub_seen

      proc pub_seen { nick uhost hand chan args } { global sitein prefix outputt
        set user [lindex $args 0]
        if { $user == "" } {putnm $nick Usage "${prefix}seen <username>" ; return 0 }
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE SEEN $user-\002 Request for $nick"
        set result [FTP::Site "seen $user"]
        foreach line $result { putnm $nick $line }
      }
    }

    #SEARCH
    if $enabled(stats_search) {
      bind pub - ${prefix}search pub_search

      proc pub_search { nick uhost hand chan args } { global sitein prefix outputt
        set string [lindex $args 0]
        if { $string == "" } {putnm $nick Usage "${prefix}search <String> - To search dirs on the site for <String>" ; return 0 }
        putchanreq $chan "\[\002$sitein\002\] Processing \002-DIRECTORY SEARCH-\002 Request for $nick"
        set result [FTP::Site "search $string"]
        foreach line $result { putnm $nick $line }
      }
    }


    #DF
    if $enabled(stats_df) {
      bind pub - ${prefix}df pub_df

      proc pub_df {nick uhost hand chan args} { global df sitein glbindir
        set total 0
        set counter 0
        set message "FREE SPACE :"

        set of [open "|$glbindir/df -k" r]
        while {![eof $of]} {
          incr counter
          set line "[gets $of]"
          if {$line == ""} {continue}
          if {[lsearch -exact [array names df] $counter] != -1} {
            if ![regexp \[^0-9\] [lindex $line [lindex $df($counter) 1]]] {
              set total [expr $total + ([lindex $line [lindex $df($counter) 1]] / 1024.0)]
              append message " [lindex $df($counter) 0] [b][expr ([lindex $line [lindex $df($counter) 1]]) / 1024] MB[b]"
              append message " -"
            } {
              putlog "sitebot!\]: DF line specified where the position contains non-integer values... skipping"
            }
          }
        }
        close $of

        if { $total > 1024 } {
          set total "[format "%.2f" "[expr $total / 1024.0]"] GB"
        } else {
          set total "[format "%.2f" "$total"] MB"
        }

        append message " total: [b]$total[b]"
        putchan $chan "\[\002$sitein\002\] $message"
      }
    }

    #FREE
    if $enabled(stats_free) {
      bind pub - ${prefix}free msdf

      proc msdf {nick uhost hand chan args} { global sitein
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE FREE-\002 Request for $nick"
        vrsdf 1 $nick [lindex $args 0]
      }

      proc vrsdf {otf nick args} { global glftpddir sitein
        set plen 5
        foreach part [lrange [split [exec /bin/df] \n] 1 end] {
          set parts([lindex $part 5]) [lrange $part 1 3]
        }
        if {[lsearch [array names parts] $glftpddir] != -1} {
          set show $glftpddir
        } else {
          set show /
        }
        foreach part [array names parts] {
          if {[string match $glftpddir/* $part]} {
            lappend show $part
            if {[string length $part] > $plen} {set plen [string length $part]}
          }
        }
        set plen [expr $plen - [string length $glftpddir]]
        putnm $nick "\([b]$sitein[b]\) [b]Free Space:[b]"
        foreach part [lsort $show] {
          regsub $glftpddir/ $part {/} glpath
          regsub $glftpddir $glpath {/} glpath
          putnm $nick "[format "%-${plen}s  FREE: %8s of %8s" $glpath [fixsize [lindex $parts($part) 2]] [fixsize [lindex $parts($part) 0]]]"
        }
      }
    }

    #NUKETOP
    if $enabled(stats_nuketop) {
      bind pub - ${prefix}nuketop pub_nuketop

      proc pub_nuketop { nick uhost hand chan args } { global sitein prefix outputt
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE NUKETOP-\002 Request for $nick"
        set result [FTP::Site "nuketop"]
        foreach line $result { putnm $nick $line }
      }
    }

    #NUKES
    if $enabled(stats_nukes) {
      bind pub - ${prefix}nukes pub_nukes

      proc pub_nukes { nick uhost hand chan args } { global sitein prefix outputt
        set num [lindex $args 0]
        if { $num == "" } {putnm $nick "Usage: ${prefix}nukes <#number> - For last <#number> Nukes" ; return 0}
        if { $num < 100 } {putchanreq $chan "\[\002$sitein\002\] Processing \002-RECENT NUKES-\002 Request for $nick"}
        set result [FTP::Site "nukes $num"]
        foreach line $result { putnm $nick $line }
      }
    }

    #TRAFFIC
    if $enabled(stats_traffic) {
      bind pub - ${prefix}traffic pub_traffic

      proc pub_traffic {nick host handle chan text} { global outputt sitein
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE TRAFFIC-\002 Request For $nick"
        set result [FTP::Site traffic]
        foreach line $result { putnm $nick $line }
      }
    }

    #USAGE
    if $enabled(stats_usage) {
      bind pub - ${prefix}bw pub_bwusage
      bind pub - ${prefix}usage pub_bwusage
      proc pub_bwusage {nick host handle chan text} { global sitein glbindir mask sitename echovars
        set result [sitebot:bw]
        set now [clock format [clock seconds] -format "%H:%M"]
        if {$result == 0} {putchan $chan "\[[b]$sitein[b]\] bandwidth function not working. ftp showing no users, this should not happen since sitebot logs in." ; return 0 }

        set count -1
        foreach value $echovars(BW) {
          set count [expr $count + 1]
          set procvalue($value) [lindex $result $count]
        }
        set put "$mask(BW)"
        if {[string match "*%sitein*" $put]} {set put [str $put %sitein $sitein]}
        if {[string match "*%sitename*" $put]} {set put [str $put %sitename $sitename]}
        if {[string match "*%now*" $put]} {set put [str $put %now $now]}
        foreach value $echovars(BW) {
          set myoutput $procvalue($value)
          if {[string match "*%$value*" $put]} {set put [str $put %$value $myoutput]}
        }
        if {[string match "*;*" $put]} {
          foreach line [split $put ";"] {
            putchan $chan $line
          }
        } {
          putchan $chan $put
        }
      }
    }

    #RULES
    if $enabled(stats_rules) {
      bind pub - ${prefix}rules pub_rules

      proc pub_rules {nick host handle chan text} { global outputt sitein
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE RULES-\002 Request For $nick"
        set result [FTP::Site rules]
        foreach line $result { putnm $nick $line }
      }
    }

    #USER
    if $enabled(stats_user) {
      bind pub - ${prefix}user pub_user

      proc pub_user {nick host handle chan text} { global sitein outputt
        set statnick [lindex $text 0]
        putchanreq $chan "\[\002$sitein\002\] Processing \002-SITE USER $statnick-\002 For $nick"
        set result [FTP::Site "user $statnick"]
        if {[string match "*nable to load*" $result]} { putnm $nick "User: $statnick doesnt exist" ; return 0 }

        set line1 [lindex $result 0] ; set line2 [lindex $result 1] ; set line3 [lindex $result 2] ; set line4 [lindex $result 3]
        set line5 [lindex $result 4] ; set line6 [lindex $result 5] ; set line7 [lindex $result 6] ; set line8 [lindex $result 7]
        set line9 [lindex $result 8] ; set line10 [lindex $result 9] ; set line11 [lindex $result 10] ; set line12 [lindex $result 11]
        set line13 [lindex $result 12] ; set line14 [lindex $result 13] ; set line15 [lindex $result 14]

        set userline [string trim [string trim [lrange $line2 1 end] "|"] " "]
        set tagline [string trim [string trim [lrange $line3 1 end] "|"] " "]
        set flagline [string trim [string trim [lrange $line4 1 end] "|"] " "]
        set createdline [string trim [string trim [lrange $line5 1 end] "|"] " "]
        set groupline [string trim [string trim [lrange $line6 1 end] "|"] " "]
        set privgroupline [string trim [string trim [lrange $line7 1 end] "|"] " "]
        set ratioline [string trim [string trim [lrange $line8 1 end] "|"] " "]
        set creditsline [string trim [string trim [lrange $line9 1 end] "|"] " "]
        set wklyalot [string trim [string trim [lrange $line10 1 end] "|"] " "]
        set loginsline [string trim [string trim [lrange $line11 1 end] "|"] " "]
        set maxloginsline [string trim [string trim [lrange $line12 1 end] "|"] " "]
        set timesnukedline [string trim [string trim [lrange $line14 1 end] "|"] " "]

        putnm $nick "+--------------------------------\\"
        putnm $nick "| [format %30s $userline] |"
        putnm $nick "|--------------------------------|"
       #putnm $nick "| [format %30s $flagline] |"
       #putnm $nick "| [format %30s $tagline] |"
        putnm $nick "| [format %30s $groupline] |"
       #putnm $nick "| [format %30s $privgroupline] |"
        putnm $nick "| [format %30s $ratioline] |"
        putnm $nick "| [format %30s $creditsline] |"
        putnm $nick "| [format %30s $loginsline] |"
       #putnm $nick "| [format %30s $timesnukedline] |"
       #putnm $nick "| [format %30s $wklyalot] |"
        putnm $nick "| [format %30s $maxloginsline] |"
        putnm $nick "| [format %30s $createdline] |"
        putnm $nick "'--------------------------------/"
      }
    }

    #VER
    bind pub - ${prefix}ver pub_ver

    proc pub_ver { nick uhost hand chan args } { global sitein ver
      putchan $chan "\[\002$sitein\002\] Using \002-$ver-\002 by DaRKHeaRT"
    }

    #HELP
    bind pub - ${prefix}help pub_help

    proc pub_help {nick host handle chan text} { global sitename sitein prefix ver dirlog_testchans outputt sitedir enabled
      putchanreq $chan "\[\002$sitein\002\] Processing \002-HELP-\002 Request For $nick"
      putnm $nick "$sitename Help. (Public Commands)"
      putnm $nick "--------------------------------------------------------------"
      putnm $nick "${prefix}ver                  - Show Version."
      if $enabled(stats_rules) {putnm $nick "${prefix}rules                      - Site Rules."}
      if $enabled(stats_info) {
        putnm $nick "${prefix} <section> wkup     - Weeks Top Uploaders."
        putnm $nick "${prefix} <section> wkdn     - Weeks Top Downloaders."
        putnm $nick "${prefix} <section> gpwk     - Weeks Top Groups Up."
        putnm $nick "${prefix} <section> gpwd     - Weeks Top Groups Down."
        putnm $nick "${prefix} <section> alup     - Alltime Top Uploaders."
        putnm $nick "${prefix} <section> aldn     - Alltime Top Downloaders."
        putnm $nick "${prefix} <section> gpal     - Alltime Top Group Uploads."
        putnm $nick "${prefix} <section> gpad     - Alltime Top Group Downloads."
        putnm $nick "${prefix} <section> dayup    - Today's Top Uploaders."
        putnm $nick "${prefix} <section> daydn    - Today's Top Downloaders."
        putnm $nick "${prefix} <section> monthup  - Top Uploaders For The Month."
        putnm $nick "${prefix} <section> monthdn  - Top Downloaders For The Month."
        putnm $nick "${prefix} <section> new <#>  - Last <#number> Uploads."
      }
      if $enabled(stats_nuketop) {putnm $nick "${prefix}nuketop           - View NukeTop Stats."}
      if $enabled(stats_free)    {putnm $nick "${prefix}free              - Show Free Space on site."}
      if $enabled(stats_who)     {putnm $nick "${prefix}who               - Whos Online and What are They Doing."}
      if $enabled(stats_traffic) {putnm $nick "${prefix}traffic           - View site traffic."}
      if $enabled(stats_laston)  {putnm $nick "${prefix}laston            - Last 10 Logins."}
      if $enabled(stats_search)  {putnm $nick "${prefix}search <string>   - Search for directories containing <string>."}
      if $enabled(stats_dupe)    {putnm $nick "${prefix}dupe <string>     - Search the Dupe datebase."}
      if $enabled(stats_seen)    {putnm $nick "${prefix}seen <login>      - Show When User was last Logged on."}
      if $enabled(stats_speed)   {putnm $nick "${prefix}speed <username>  - speed check a user or group of users."}
      if $enabled(stats_nukes)   {putnm $nick "${prefix}nukes <#number>   - Last <#number> Nukes."}
      if $enabled(stats_user)    {putnm $nick "${prefix}user <login>      - Show Stats on a User."}
      if $enabled(stats_usage)   {putnm $nick "${prefix}bw                - Show Bandwidth in Use."}
      if $enabled(stats_df)      {putnm $nick "${prefix}df                - Show Free Disk space."}
      if $enabled(stats_info) {
        putnm $nick "------------------------------------------------------------"
        putnm $nick "Valid sections are: [array names sitedir]"
      }
      putnm $nick "-----------------------------------------------------------"
    }
  }
}
#######################################################
##################### DCC SCRIPT ######################
#######################################################

proc sitebot:dcc {} {
  uplevel #0 {

    #TRANSFER
    bind dcc C ${dcc_prefix}transfer dcc_transfer

    proc dcc_transfer {hand idx arg} { global logfile dcc_prefix sitedir
      putlog "#$hand# transfer $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - TRANSFER $arg" ; close $fd
      set user [lindex $arg 0]
      set multiplier [lindex $arg 1]
      set section1 [lindex $arg 2]
      set section2 [lindex $arg 3]
      set credits [lindex $arg 4]
      if { $user == "" } {putdcc $idx "Usage: .${dcc_prefix}transfer <username> <multiplier> <section1> <section2> <mb>" ; return 0 }
      if { $section1 == "" } {putdcc $idx "Usage: .${dcc_prefix}transfer <username> <multiplier> <section1> <section2> <mb>" ; return 0 }
      if { $section2 == "" } {putdcc $idx "Usage: .${dcc_prefix}transfer <username> <multiplier> <section1> <section2> <mb>" ; return 0 }
      if { $multiplier == "" } {putdcc $idx "Usage: .${dcc_prefix}transfer <username> <multiplier> <section1> <section2> <mb>" ; return 0 }
      if { $credits == "" } {putdcc $idx "Usage: .${dcc_prefix}transfer <username> <multiplier> <section1> <section2> <mb>" ; return 0 }
      set amount {[expr $credits * 1024 * $multiplier]}
      if [info exists sitedir($section1)] {set dir1 $sitedir($section1)} {putdcc $idx "Sorry, there is no section named $section1 : Valid sections are: [array names sitedir]" ; return 0 }
      if [info exists sitedir($section2)] {set dir2 $sitedir($section2)} {putdcc $idx "Sorry, there is no section named $section2 : Valid sections are: [array names sitedir]" ; return 0 }
      set result [FTP::Cd $dir1] ; putdcc $idx "Change to section ($section1 : $dir1)"
      set result [FTP::Site "take $user $amount"] ; foreach line $result {putdcc $idx $line}
      set result [FTP::Cd $dir2] ; putdcc $idx "Change to section ($section2 : $dir2)"
      set result [FTP::Site "give $user $amount"] ; foreach line $result {putdcc $idx $line}
    }

    #MSGAUTHOR
    bind dcc - ${dcc_prefix}msgauthor dcc_msgauthor

    proc dcc_msgauthor {hand idx arg} { global sitename sitein logfile botnick from email

      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }

      set from $hand
      set email [lindex $arg 0]
      set head "$sitename - $sitein" ; regsub -all " " $head + hed
      set msg [lrange $arg 1 end] ; regsub -all " " $msg + mssg

      if { $email == "" } {putdcc $idx "Usage: .msgauthor <youremail> <message>" ; return 0 }
      if { $msg == "" } {putdcc $idx "Usage: .msgauthor <youremail> <message>" ; return 0 }

      putlog "#$hand# Sending Message \"$msg\" "

      set body $hed
      append body $mssg
      set var $body
      append var $hand
      append var $botnick
      set l [string length $var]
      set ln [expr $l + 41]

      go_connect $body $ln $mssg $hed

      putdcc $idx "#$hand# Message successfully sent to DaRKHeaRT"
      return 1
    }

    proc go_connect {body ln mssg hed} { global from email botnick $body $ln $mssg $hed
      if [catch {socket "wwp.icq.com" 80} sockresult] { putlog "Could not connect:  $sockresult" ; return 0 }
      putlog "Socket $sockresult was opened"

      fconfigure $sockresult -translation auto -buffering line -blocking 0
      puts $sockresult "POST /scripts/WWPMsg.dll HTTP/1.1"
      puts $sockresult "Accept: application/vnd.ms-excel, application/msword, application/vnd.ms-powerpoint, image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*"
      puts $sockresult "Referer: http://nothing.com"
      puts $sockresult "Accept-Language: en-u"
      puts $sockresult "s"
      puts $sockresult "Content-Type: application/x-www-form-urlencoded"
      puts $sockresult "Accept-Encoding: gzip, deflate"
      puts $sockresult "User-Agent: Mozilla/4.0 (compatible; MSIE 4.01; Windows 95)"
      puts $sockresult "Host: x"
      puts $sockresult "Content-Length: $ln"
      puts $sockresult "Connection: Keep-Alive"
      puts $sockresult ""
      puts $sockresult "subject=$hed&to=3744675&from=$from&fromemail=$email&body=$mssg&x=90&y=50"
      close $sockresult
      return 1
    }

    #ADDUSER
    bind dcc C ${dcc_prefix}adduser dcc_adduser

    proc dcc_adduser {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# adduser $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ADDUSER $arg" ; close $fd
      set user [lindex $arg 0]
      set pass [lindex $arg 1]
      set group [lindex $arg 2]
      set ip1 [lindex $arg 3]
      set ip2 [lindex $arg 4]
      set ip3 [lindex $arg 5]
      set ip4 [lindex $arg 6]
      set ip5 [lindex $arg 7]
      set ip6 [lindex $arg 8]
      set ip7 [lindex $arg 9]
      set ip8 [lindex $arg 10]
      if { $user == "" } {putdcc $idx    "Usage: .${dcc_prefix}adduser <username> <password> <group>" ; return 0 }
      if { $pass == "" } { putdcc $idx  "Usage: .${dcc_prefix}adduser <username> <password> <group>" ; return 0 }
      if { $group == "" } { putdcc $idx  "Usage: .${dcc_prefix}adduser <username> <password> <group>" ; return 0 }
      set result [FTP::Site "adduser $user $pass"]
      foreach line $result {putdcc $idx  $line}
      set result [FTP::Site "chgrp $user $group"]
      foreach line $result {putdcc $idx  $line}
      set result [FTP::Site "addip $user $ip1"]
      foreach line $result {putdcc $idx  $line}
      if { $ip2 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip2"]
      foreach line $result {putdcc $idx  $line}
      if { $ip3 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip3"]
      foreach line $result {putdcc $idx  $line}
      if { $ip4 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip4"]
      foreach line $result {putdcc $idx  $line}
      if { $ip5 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip5"]
      foreach line $result {putdcc $idx  $line}
      if { $ip6 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip6"]
      foreach line $result {putdcc $idx  $line}
      if { $ip7 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip7"]
      foreach line $result {putdcc $idx  $line}
      if { $ip8 == "" } { return 0 }
      set result [FTP::Site "addip $user $ip8"]
      foreach line $result {putdcc $idx  $line}
   }

    #CHPASS
    bind dcc C ${dcc_prefix}chpass dcc_chpass

    proc dcc_chpass {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chpass $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHPASS $arg" ; close $fd
      set user [lindex $arg 0]
      set pass [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chpass <username> <password>" ; return 0 }
      if { $pass == "" } { putdcc $idx "Usage: .${dcc_prefix}chpass <username> <password>" ; return 0 }
      set result [FTP::Site "chpass $user $pass"]
      foreach line $result {putdcc $idx $line}
    }

    #CHGRP
    bind dcc C ${dcc_prefix}chgrp dcc_chgrp

    proc dcc_chgrp {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chgrp $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHGRP $arg" ; close $fd
      set user [lindex $arg 0]
      set oldgroup [lindex $arg 1]
      set newgroup [lindex $arg 2]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chgrp <username> <oldgroup> <newgroup>" ; return 0 }
      if { $oldgroup == "" } { putdcc $idx "Usage: .${dcc_prefix}chgrp <username> <oldgroup> <newgroup>" ; return 0 }
      set result [FTP::Site "chgrp $user $oldgroup"]
      foreach line $result {putdcc $idx $line}
      set result [FTP::Site "chgrp $user $newgroup"]
      foreach line $result {putdcc $idx $line}
    }

    #CHRATIO
    bind dcc C ${dcc_prefix}chratio dcc_chratio

    proc dcc_chratio {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chratio $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHRATIO $arg" ; close $fd
      set user [lindex $arg 0]
      set newratio [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chratio <username> <newratio>" ; return 0 }
      if { $newratio == "" } { putdcc $idx "Usage: .${dcc_prefix}chratio <username> <newratio>" ; return 0 }
      set result [FTP::Site "change $user ratio $newratio"]
      foreach line $result {putdcc $idx $line}
    }

    #CHLOGINS
    bind dcc C ${dcc_prefix}chlogins dcc_chlogins

    proc dcc_chlogins {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chlogins $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHLOGINS $arg" ; close $fd
      set user [lindex $arg 0]
      set value [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chlogins <user> <logins>" ; return 0 }
      if { $value == "" } { putdcc $idx "Usage: .${dcc_prefix}chlogins <user> <logins>" ; return 0 }
      set result [FTP::Site "change $user num_logins $value"]
      foreach line $result {putdcc $idx $line}
    }

    #DELUSER
    bind dcc C ${dcc_prefix}deluser dcc_deluser

    proc dcc_deluser {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# deluser $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - DELUSER $arg" ; close $fd
      set user [lindex $arg 0]
      if { $user == "" } {putdcc $idx    "Usage: .${dcc_prefix}deluser <username>" ; return 0 }
      set result [FTP::Site "deluser $user"]
      foreach line $result {putdcc $idx  $line}
    }

    #GIVE
    bind dcc C ${dcc_prefix}give dcc_give

    proc dcc_give {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# give $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GIVE $arg" ; close $fd
      set user [lindex $arg 0]
      set credits [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}give <username> <credits>" ; return 0 }
      if { $credits == "" } { putdcc $idx "Usage: .${dcc_prefix}give <username> <credits>" ; return 0 }
      set amount [expr $credits * 1024]
      set result [FTP::Site "give $user $amount"]
      foreach line $result {putdcc $idx $line}
    }

    #TAKE
    bind dcc C ${dcc_prefix}take dcc_take

    proc dcc_take {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# take $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - TAKE $arg" ; close $fd
      set user [lindex $arg 0]
      set credits [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}take <username> <credits>" ; return 0 }
      if { $credits == "" } { putdcc $idx "Usage: .${dcc_prefix}take <username> <credits>" ; return 0 }
      set amount [expr $credits * 1024]
      set result [FTP::Site "take $user $amount"]
      foreach line $result {putdcc $idx $line}
    }

    #KILL
    #bind dcc C ${dcc_prefix}kill dcc_kill
 
    proc dcc_kill {hand idx arg} {
      global logfile botnick dcc_prefix
      putlog "#$hand# kill $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - KILL $arg" ; close $fd
      set pid [lindex $arg 0]
      if { $pid == "" } { putdcc $idx "Usage: ${dcc_prefix}kill <pid>" ; return 0 }
      set result [FTP::Site "kill $pid"]
      foreach line $result {putdcc $idx $line}
    }

    #CHFLAGS
    bind dcc C ${dcc_prefix}chflags dcc_chflags

    proc dcc_chflags {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chflags $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHFLAG $arg" ; close $fd
      set user [lindex $arg 0]
      set flags [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chflag <user> <+/-><flags>" ; return 0 }
      if { $flags == "" } { putdcc $idx "Usage: .${dcc_prefix}chflag <user> <+/-><flags>" ; return 0 }
      set result [FTP::Site "change $user flags $flags"]
      foreach line $result {putdcc $idx $line}
    }

    #CHSLOTS
    bind dcc C ${dcc_prefix}chslots dcc_chslots

    proc dcc_chslots {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chslots $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHGRPSLOTS $arg" ; close $fd
      set user [lindex $arg 0]
      set slots [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chslots <user> <slots>" ; return 0 }
      if { $slots == "" } { putdcc $idx "Usage: .${dcc_prefix}chslots <user> <slots>" ; return 0 }
      set result [FTP::Site "change $user group_slots $slots"]
      foreach line $result {putdcc $idx $line}
    }

    #CHUNFO
    bind dcc C ${dcc_prefix}chunfo dcc_chunfo

    proc dcc_chunfo {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chunfo $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHTAGLINE $arg" ; close $fd
      set user [lindex $arg 0]
      set tagline [lrange $arg 1 end]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chunfo <user> <tagline>" ; return 0 }
      if { $tagline == "" } { putdcc $idx "Usage: .${dcc_prefix}chunfo <user> <tagline>" ; return 0 }
      set result [FTP::Site "change $user tagline $tagline"]
      foreach line $result {putdcc $idx $line}
    }

    #CHTLIMIT
    bind dcc C ${dcc_prefix}chtlimit dcc_chtlimit

    proc dcc_chitime {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# chtlimit $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - CHIDLETIME $arg" ; close $fd
      set user [lindex $arg 0]
      set newtime [lindex $arg 1]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}chtlimit <user> <newtime>" ; return 0 }
      if { $newtime == "" } { putdcc $idx "Usage: .${dcc_prefix}chtlimit <user> <newtime>" ; return 0 }
      set result [FTP::Site "change $user time_limit $newtime"]
      foreach line $result {putdcc $idx $line}
    }

    #GRPADD
    bind dcc C ${dcc_prefix}grpadd dcc_grpadd

    proc dcc_grpadd {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# grpadd $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GRPADD $arg" ; close $fd
      set group [lindex $arg 0]
      if { $group == "" } { putdcc $idx "Usage: .${dcc_prefix}grpadd <group>" ; return 0 }
      set result [FTP::Site "grpadd $group"]
      foreach line $result {putdcc $idx $line}
    }

    #GRPDEL
    bind dcc C ${dcc_prefix}grpdel dcc_grpdel

    proc dcc_grpdel {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# grpdel $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GRPDEL $arg" ; close $fd
      set group [lindex $arg 0]
      if { $group == "" } { putdcc $idx "Usage: .${dcc_prefix}grpdel <group>" ; return 0 }
      set result [FTP::Site "grpdel $group"]
      foreach line $result {putdcc $idx $line}
    }

    #GRPNFO
    bind dcc C ${dcc_prefix}grpnfo dcc_grpnfo

    proc dcc_grpnfo {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# grpnfo $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GRPNFO $arg" ; close $fd
      set group [lindex $arg 0]
      set nfo [lindex $arg 1]
      if { $group == "" } { putdcc $idx "Usage: .${dcc_prefix}grpnfo <group> <nfo>" ; return 0 }
      if { $nfo == "" } { putdcc $idx "Usage: .${dcc_prefix}grpnfo <group> <nfo>" ; return 0 }
      set result [FTP::Site "grpnfo $group $nfo"]
      foreach line $result {putdcc $idx $line}
    }

    #GRPREN
    bind dcc C ${dcc_prefix}grpren dcc_grpren

    proc dcc_grpren {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# grpren $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GRPREN $arg" ; close $fd
      set oldgroup [lindex $arg 0]
      set newgroup [lindex $arg 1]
      if { $oldgroup == "" } { putdcc $idx "Usage: .${dcc_prefix}grpren <oldgroup> <newgroup>" ; return 0 }
      if { $newgroup == "" } { putdcc $idx "Usage: .${dcc_prefix}grpren <oldgroup> <newgroup>" ; return 0 }
      set result [FTP::Site "grpren $oldgroup $newgroup"]
      foreach line $result {putdcc $idx $line}
    }

    #GRPLOG
    bind dcc C ${dcc_prefix}grplog dcc_grplog

    proc dcc_grplog {hand idx arg} { global logfile botnick
      putlog "#$hand# grplog $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - GRPLOG $arg" ; close $fd
      set group [lindex $arg 0]
      set logins [lindex $arg 1]
      if { $group == "" } { putdcc $idx "Usage: .${dcc_prefix}grplog <group> <logins>" ; return 0 }
      if { $logins == "" } { putdcc $idx "Usage: .${dcc_prefix}grplog <group> <logins>" ; return 0 }
      set result [FTP::Site "grplog $group $logins"]
      foreach line $result {putdcc $idx $line}
    }


    #DISABLE
    bind dcc C ${dcc_prefix}disable dcc_disable

    proc dcc_disable {hand idx arg} { global logfile botnick
      putlog "#$hand# disable $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - DISABLE $arg" ; close $fd
      set user [lindex $arg 0]
      if { $user == "" } { putdcc $idx "Usage: .sdisable <username>" ; return 0 }
      set result [FTP::Site "change $user flags +6"]
      foreach line $result {putdcc $idx $line}
    }

    #ENABLE
    bind dcc C ${dcc_prefix}enable dcc_enable

    proc dcc_enable {hand idx arg} { global logfile botnick
      putlog "#$hand# enable $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ENABLE $arg" ; close $fd
      set user [lindex $arg 0]
      if { $user == "" } { putdcc $idx "Usage: .senable <username>" ; return 0 }
      set result [FTP::Site "readd $user"]
      foreach line $result {putdcc $idx $line}
    }

    #SITE
    bind dcc C ${dcc_prefix}site dcc_site

    proc dcc_site {hand idx arg} { global logfile botnick
      putlog "#$hand# site $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - SITE $arg" ; close $fd
      set 1 [lindex $arg 0]
      set 2 [lindex $arg 1]
      set 3 [lindex $arg 2]
      set 4 [lindex $arg 3]
      set 5 [lindex $arg 4]
      set 6 [lindex $arg 5]
      set 7 [lindex $arg 6]
      set 8 [lindex $arg 7]
      if { $1 == "" } { putdcc $idx "Usage: site <1> <2> <3> ..." ; return 0 }
      if { $2 == "" } {
        set result [FTP::Site "$1"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $3 == "" } {
        set result [FTP::Site "$1 $2"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $4 == "" } {
        set result [FTP::Site "$1 $2 $3"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $5 == "" } {
        set result [FTP::Site "$1 $2 $3 $4"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $6 == "" } {
        set result [FTP::Site "$1 $2 $3 $4 $5"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $7 == "" } {
        set result [FTP::Site "$1 $2 $3 $4 $5 $6"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      if { $8 == "" } {
        set result [FTP::Site "$1 $2 $3 $4 $5 $7"]
        foreach line $result {putdcc $idx $line}
        return 0
      }
      set result [FTP::Site "$1 $2 $3 $4 $5 $7 $8"]
      foreach line $result {putdcc $idx $line}
    }

    #PURGE
    bind dcc C ${dcc_prefix}purge dcc_purge

    proc dcc_purge {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# purge $arg"
      set username [lindex $arg 0]
      if { $username == "" } { putdcc $idx "Usage: ${dcc_prefix}purge <*|username>" ; return 0 }
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - PURGE" ; close $fd
      if { $username == "*"} {
        set result [FTP::Site "purge"]
        foreach line $result {putdcc $idx $line}
      } {
        set result [FTP::Site "purge $username"]
        foreach line $result {putdcc $idx $line}
      }
    }

    #WHO2
    bind dcc C ${dcc_prefix}who2 dcc_who2

    proc dcc_who2 {hand idx arg} { global logfile botnick
      putlog "#$hand# who2 $arg"
      set result [FTP::Site "swho"]
      foreach line $result {putdcc $idx $line}
    }

    #UCHANGES
    bind dcc C ${dcc_prefix}uchanges dcc_uchanges

    proc dcc_uchanges {hand idx arg} { global logfile botnick
      putlog "#$hand# uchanges"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ACCESED UCHANGES LOG" ; close $fd
      set days [lindex $arg 0]
      if { $days == "" } { putdcc $idx "Usage: .suchanges <for last number of days>" ; return 0 }
      set result [FTP::Site "uchanges $days"]
      foreach line $result {putdcc $idx $line}
    }

    #LOGINS
    bind dcc C ${dcc_prefix}logins dcc_logins

    proc dcc_logins {hand idx arg} { global logfile botnick
      putlog "#$hand# logins"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ACCESS TO LOGINS LOG" ; close $fd
      set days [lindex $arg 0]
      if { $days == "" } { putdcc $idx "Usage: .slogins <for last number of days>" ; return 0 }
      set result [FTP::Site "logins $days"]
      foreach line $result {putdcc $idx $line}
    }

    #LOG
    bind dcc C ${dcc_prefix}log dcc_log
    proc dcc_log {hand idx arg} { global logfile botnick
      putlog "#$hand# log"
      set fd [open "$logfile"]
      gets $fd line
      set end [eof $fd]
      while { $end != 1 } {
        putdcc $idx $line
        gets $fd line
        set end [eof $fd]
      }
      close $fd
    }

    ############## COMMANDS STAFF ARE ABLE TO DO

    #ADDIP
    bind dcc - ${dcc_prefix}addip dcc_addip
    proc dcc_addip {hand idx arg} { global logfile botnick
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }

      putlog "#$hand# addip $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ADDIP $arg" ; close $fd
      set user [lindex $arg 0]
      set 1 [lindex $arg 1]
      set 2 [lindex $arg 2]
      set 3 [lindex $arg 3]
      set 4 [lindex $arg 4]
      set 5 [lindex $arg 5]
      set 6 [lindex $arg 6]
      set 7 [lindex $arg 7]
      set 8 [lindex $arg 8]
      set 9 [lindex $arg 9]
      set 10 [lindex $arg 10]
      set 11 [lindex $arg 11]
      if { $user == "" } { putdcc $idx "Usage: .saddip <username> <ip1> <ip2> <ip3> <ip4> <ip5> ..." ; return 0 }
      if { $1 == "" } { putdcc $idx "Usage: .saddip <username> <ip1> <ip2> <ip3> <ip4> <ip5> ..." ; return 0 }
      if { $11 == "" } {} else { putdcc $idx "only 10 ips per user are supported under glftpd - adding the rest..." }
      set result [FTP::Site "addip $user $1"]
      foreach line $result {putdcc $idx $line}
      if { $2 == "" } { return 0 }
      set result [FTP::Site "addip $user $2"]
      foreach line $result {putdcc $idx $line}
      if { $3 == "" } { return 0 }
      set result [FTP::Site "addip $user $3"]
      foreach line $result {putdcc $idx $line}
      if { $4 == "" } { return 0 }
      set result [FTP::Site "addip $user $4"]
      foreach line $result {putdcc $idx $line}
      if { $5 == "" } { return 0 }
      set result [FTP::Site "addip $user $5"]
      foreach line $result {putdcc $idx $line}
      if { $6 == "" } { return 0 }
      set result [FTP::Site "addip $user $6"]
      foreach line $result {putdcc $idx $line}
      if { $7 == "" } { return 0 }
      set result [FTP::Site "addip $user $7"]
      foreach line $result {putdcc $idx $line}
      if { $8 == "" } { return 0 }
      set result [FTP::Site "addip $user $8"]
      foreach line $result {putdcc $idx $line}
      if { $9 == "" } { return 0 }
      set result [FTP::Site "addip $user $9"]
      foreach line $result {putdcc $idx $line}
      if { $10 == "" } { return 0 }
      set result [FTP::Site "addip $user $10"]
      foreach line $result {putdcc $idx $line}
    }

    #DELIP
    bind dcc - ${dcc_prefix}delip dcc_delip

    proc dcc_delip {hand idx arg} { global logfile botnick
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# delip $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - DELIP $arg" ; close $fd
      set user [lindex $arg 0]
      set 1 [lindex $arg 1]
      set 2 [lindex $arg 2]
      set 3 [lindex $arg 3]
      set 4 [lindex $arg 4]
      set 5 [lindex $arg 5]
      set 6 [lindex $arg 6]
      if { $user == "" } { putdcc $idx "Usage: .sdelip <username> <ip1> <ip2> <ip3> <ip4> <ip5>" ; return 0 }
      if { $1 == "" } { putdcc $idx "Usage: .sdelip <username> <ip1> <ip2> <ip3> <ip4> <ip5>" ; return 0 }
      if { $6 == "" } {} else { putdcc $idx "only 5 ips supported at a time, sorry - adding the rest..." }
      set result [FTP::Site "delip $user $1"]
      foreach line $result {putdcc $idx $line}
      if { $2 == "" } { return 0 }
      set result [FTP::Site "delip $user $2"]
      foreach line $result {putdcc $idx $line}
      if { $3 == "" } { return 0 }
      set result [FTP::Site "delip $user $3"]
      foreach line $result {putdcc $idx $line}
      if { $4 == "" } { return 0 }
      set result [FTP::Site "delip $user $4"]
      foreach line $result {putdcc $idx $line}
      if { $5 == "" } { return 0 }
      set result [FTP::Site "delip $user $5"]
      foreach line $result {putdcc $idx $line}
    }

    #GINFO
    bind dcc - ${dcc_prefix}ginfo dcc_ginfo

    proc dcc_ginfo {hand idx arg} { global logfile botnick
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# ginfo $arg"
      set group [lindex $arg 0]
      if { $group == "" } { putdcc $idx "Usage: .sginfo <group>" ; return 0 }
      set result [FTP::Site "ginfo $group"]
      foreach line $result {putdcc $idx $line}
    }

    #FLAGS
    bind dcc - ${dcc_prefix}flags dcc_flags

    proc dcc_flags {hand idx arg} { global logfile botnick
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# flags $arg"
      set user [lindex $arg 0]
      if { $user == "" } { putdcc $idx "Usage: .sflags <username> " ; return 0 }
      set result [FTP::Site "flags $user"]
      foreach line $result {putdcc $idx $line}
    }

    #USERS
    bind dcc - ${dcc_prefix}users dcc_users

    proc dcc_users {hand idx arg} { global logfile botnick
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# users $arg"
      set which [lindex $arg 0]
      if { $which == "" } { putdcc $idx "Usage: .susers <*|LEECH|SITEOP|GADMIN|DELETED>" ; return 0 }
      if { $which == "*" } {
        set result [FTP::Site "users"]
        foreach line $result {putdcc $idx $line}
      } {
        set result [FTP::Site "users $which"]
        foreach line $result {putdcc $idx $line}
      }
    }

    #ANNOUNCE
    bind dcc - ${dcc_prefix}announce dcc_announce

    proc dcc_announce {hand idx arg} { global sitein logfile dirlog_testchans
      if { ![matchattr $hand C] && ![matchattr $hand S] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# announce $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - ANNOUNCE $arg" ; close $fd
      foreach chan $dirlog_testchans {putchan $chan "\[\002$sitein\002\] \002-$hand: ANNOUNCEMENT-\002 $arg"}
    }

    #UNDUPE
    bind dcc - ${dcc_prefix}undupe dcc_undupe

    proc dcc_undupe {hand idx arg} { global logfile botnick dcc_prefix
      if { ![matchattr $hand C] && ![matchattr $hand S] && ![matchattr $hand N]} { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# undupe $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - UNDUPE $arg" ; close $fd
      set file [lindex $arg 0]
      if { $file == "" } { putdcc $idx "Usage: .${dcc_prefix}undupe <filename>" ; return 0 }
      set result [FTP::Site "undupe $file"]
      foreach line $result {putdcc $idx $line}
    }

    #NUKE
    bind dcc - ${dcc_prefix}nuke dcc_nuke

    proc dcc_nuke {hand idx arg} { global logfile botnick dcc_prefix today sitedir
      if { ![matchattr $hand C] && ![matchattr $hand S] && ![matchattr $hand N] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# nuke $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - NUKE $arg" ; close $fd
      set where [lindex $arg 0]
      set release [lindex $arg 1]
      set x [lindex $arg 2]
      set reason [lindex $arg 3]
      if { $where == "" } { putdcc $idx "Usage: .${dcc_prefix}nuke <where|today> <dir> <times> <reason>" ; return 0 }
      if { $release == "" } { putdcc $idx "Usage: .${dcc_prefix}nuke <where|today> <dir> <times> <reason>" ; return 0 }
      if { $x == "" } { putdcc $idx "Usage: .${dcc_prefix}nuke <where|today> <dir> <times> <reason>" ; return 0 }
      if { $reason == "" } { putdcc $idx "Usage: .${dcc_prefix}nuke <where|today> <dir> <times> <reason>" ; return 0 }
      if {$where=="today"} {
        FTP::Cd $today
        set result [FTP::Site "nuke $release $x $reason"]
        foreach line $result {putdcc $idx $line}
      } else {
        FTP::Cd $where
        set result [FTP::Site "nuke $release $x $reason"]
        foreach line $result {putdcc $idx $line}
      }
      FTP::Cd /
    }

    #UNNUKE
    bind dcc - ${dcc_prefix}unnuke dcc_unnuke

    proc dcc_unnuke {hand idx arg} { global logfile botnick dcc_prefix today
      if { ![matchattr $hand C] && ![matchattr $hand S] && ![matchattr $hand N] } { putdcc $idx "What?  You need '.help'" ; return 0 }
      putlog "#$hand# unnuke $arg"
      set fd [open "$logfile" a] ; puts $fd "[logtime] - $hand - UNNUKE $arg" ; close $fd
      set where [lindex $arg 0]
      set release [lindex $arg 1]
      set reason [lindex $arg 2]
      if { $where == "" } { putdcc $idx "Usage: .${dcc_prefix}unnuke <date> <dir> <reason>" ; return 0 }
      if { $release == "" } { putdcc $idx "Usage: .${dcc_prefix}unnuke <date> <dir> <reason>" ; return 0 }
      if { $reason == "" } { putdcc $idx "Usage: .${dcc_prefix}unnuke <date> <dir> <reason>" ; return 0 }
      if {$fd=="today"} {
        FTP::Cd $today
        set result [FTP::Site "unnuke $release $reason"]
        foreach line $result {putdcc $idx $line}
      } else {
        FTP::Cd $where
        set result [FTP::Site "unnuke $release $reason"]
        foreach line $result {putdcc $idx $line}
      }
      FTP::Cd /
    }

    ############## COMMANDS ANYONE CAN DO

    #TIME
    bind dcc - ${dcc_prefix}time dcc_time

    proc dcc_time {hand idx arg} { global logfile botnick
      putlog "#$hand# time"
      set result [FTP::Site "time"]
      foreach line $result {putdcc $idx $line}
    }

    #GROUPS
    bind dcc - ${dcc_prefix}groups dcc_groups

    proc dcc_groups {hand idx arg} { global logfile botnick
      putlog "#$hand# groups"
      set result [FTP::Site "groups"]
      foreach line $result {putdcc $idx $line}
    }

    #RULES
    bind dcc - ${dcc_prefix}rules dcc_rules

    proc dcc_rules {hand idx arg} { global logfile botnick
      putlog "#$hand# rules"
      set result [FTP::Site "rules"]
      foreach line $result {putdcc $idx $line}
    }

    #USER
    bind dcc - ${dcc_prefix}user dcc_user

    proc dcc_user {hand idx arg} { global logfile botnick dcc_prefix
      putlog "#$hand# user $arg"
      set user [lindex $arg 0]
      if { $user == "" } { putdcc $idx "Usage: .${dcc_prefix}user <username>" ; return 0 }
      set result [FTP::Site "user $user"]
      foreach line $result {putdcc $idx $line}
      set result [FTP::Site "stats $user"]
      foreach line $result {putdcc $idx $line}
    }

    #WHO
    bind dcc - ${dcc_prefix}who dcc_who

    proc dcc_who {hand idx arg} { global logfile botnick hideinwho
      putlog "#$hand# who $arg"
      set result [FTP::Site "who"]
      foreach line $result {
        set skip 0
        foreach user $hideinwho {if {[lsearch -exact [lindex $line 1] $user] != -1} {set skip 1}}
        if {$skip == 0} { putdcc $idx $line }
      }
    }

    #SAVECONF
    bind dcc C ${dcc_prefix}saveconfig dcc_saveconfig
    proc dcc_saveconfig { hand idx args } { global sitein
      putdcc $idx "\[\002$sitein\002\] SAVING CHANGES TO CONFIG/API FILE."
      update
      updateapi
    }

    #SET
    bind dcc C ${dcc_prefix}set dh:set_dcc
    proc dh:set_dcc { hand idx arg } { global dcc_prefix ; putlog "\#$hand\# ${dcc_prefix}set $arg" ; foreach line [dh:set $arg] { putdcc $idx $line } }

    proc dh:set { args } {

      global sitename sitein outputt prefix dcc_prefix logfile dirlog_testchans sonjoin today hideinwho
      global glconf glftpddir gllog glusers glbindir bnclist invitechan deny_post showrequest sitebot ftpwho
      global site timer mask enabled enabled_announce echovars types sectionnames defaultsection sections chans sitedir

      set args [lindex $args 0]
      set command [string tolower [lindex $args 0]]
      set arg [lrange $args 1 end]
      set output ""

      switch -exact -- $command {
        "ftpwho" { if { $arg == "" } { lappend output "ftpwho is: $ftpwho" } { set ftpwho $arg ; lappend output "ftpwho is now: $ftpwho" } }
        "sectionnames" { if { $arg == "" } { lappend output "Section Names is: $sectionnames" } { set sectionnames $arg ; lappend output "Section Names is now: $sectionnames" } }
        "defaultsection" { if { $arg == "" } { lappend output "default section is: $defaultsection" } elseif {[llength $arg] != 1} { lappend output "may only set one default section." } else { set defaultsection $arg ; lappend output "default section is now: $defaultsection" } }
        "sitename" { if { $arg == "" } { lappend output "Site name is: $sitename" } { set sitename $arg ; lappend output "Site name is now: $sitename" } }
        "sitein" { if { $arg == "" } { lappend output "Site Short name is: $sitein" } { set sitein $arg ; lappend output "Site short name is now: $sitein" } }
        "outputt" { if { $arg == "" } { lappend output "outputt is set to: $outputt" } elseif {$arg == 1 || $arg == 0} { set outputt $arg ; lappend output "outputt is now: $outputt" } else {lappend output "1 or 0 are the only valid options for this variable... on/off respectivly." } }
        "prefix" { if { $arg == "" } { lappend output "prefix is: $prefix" } { set prefix $arg ; lappend output "prefix is now: $prefix" } }
        "dcc_prefix" { if { $arg == "" } { lappend output "dcc prefix is: $dcc_prefix" } { set dcc_prefix $arg ; lappend output "dcc_prefix is now: $dcc_prefix" } }
        "logfile" { if { $arg == "" } { lappend output "Logfile location is: $logfile" } { set logfile $arg ; lappend output "Logfile is now: $logfile" } }
        "dirlog_testchans" { if { $arg == "" } { lappend output "Echo Chans is: $dirlog_testchans" } { set dirlog_testchans $arg ; lappend output "Echo Chans is now: $dirlog_testchans" } }
        "sonjoin"  { if { $arg == "" } { lappend output "Channel Onjoin is: $sonjoin" } elseif {$arg == 1 || $arg == 0} { set sonjoin $arg ; lappend output "Channel onjoin is now: $sonjoin" } else {lappend output "1 or 0 are the only valid options for this variable... on/off respectivly." } }
        "today" { if { $arg == "" } { lappend output "today is: $today" } { set today $arg ; lappend output "today is now: $today" } }
        "invitechan" { if { $arg == "" } { lappend output "invitechan is: $invitechan" } { set invitechan $arg ; lappend output "invitechan is now: $invitechan" } }
        "deny_post" { if { $arg == "" } { lappend output "deny_post is: $deny_post" } { set deny_post $arg ; lappend output "deny_post is now: $deny_post" } }
        "glconf" { if { $arg == "" } { lappend output "glconf is: $glconf" } { set glconf $arg ; lappend output "glconf is now: $glconf" } }
        "glftpddir" { if { $arg == "" } { lappend output "glftpddir is: $glftpddir" } { set glftpddir $arg ; lappend output "glftpddir is now: $glftpddir" } }
        "gllog" { if { $arg == "" } { lappend output "gllog is: $gllog" } { set gllog $arg ; lappend output "gllog is now: $gllog" } }
        "glusers" { if { $arg == "" } { lappend output "glusers is: $glusers" } { set glusers $arg ; lappend output "glusers is now: $glusers" } }
        "glbindir" { if { $arg == "" } { lappend output "glbindir is: $glbindir" } { set glbindir $arg ; lappend output "glbindir is now: $glbindir" } }
        "bnclist" { if { $arg == "" } { lappend output "bnclist is: $bnclist" } { set bnclist $arg ; lappend output "bnclist is now: $bnclist" } }
        "hideinwho" { if { $arg == "" } { lappend output "users hidden in site who are: $hideinwho" } { set hideinwho $arg ; lappend output "users hidden in site who are now: $hideinwho" } }
        "showrequest"  { if { $arg == "" } { lappend output "show request is: $showrequest" } elseif {$arg == 1 || $arg == 0} { set showrequest $arg ; lappend output "shoq request is now: $showrequest" } else {lappend output "1 or 0 are the only valid options for this variable... on/off respectivly." } }
        "+type" { if { $arg == "" } { lappend output "valid TYPES are: [array names echovars]" } { set echovars($arg) ""; lappend output "defined new type: $arg" ; updateapi } }
        "+sitedir" { if { $arg == "" } { lappend output "valid SITEDIRS are: [array names sitedir]" } { set sitedir([string toupper $arg]) ""; lappend output "defined new sitedir: [string toupper $arg]" ; update } }
        "-type" {
          if {[llength $arg] != 1} {
            lappend output "Usage: .${dcc_prefix}set deltype <type>"
          } elseif { $arg == "" } {
            lappend output "valid TYPES are: [array names echovars]"
          } elseif {![info exists echovars($arg)]} {
            lappend output "$arg is not a valid TYPE."
          } else {
            unset echovars($arg) ; unset mask($arg) ; unset enabled_announce($arg)
            lappend output "deleted sitedir($arg)"
            updateapi
          }
        }
        "-sitedir" {
          if {[llength $arg] != 1} {
            lappend output "Usage: .${dcc_prefix}set delsitedir <type>"
          } elseif { $arg == "" } {
            lappend output "valid SITEDIRS are: [array names sitedir]"
          } elseif {![info exists sitedir($arg)]} {
            lappend output "sitedir($arg) does not exist."
          } else {
            unset sitedir($arg)
            lappend output "deleted sitedir($arg)"
            update
          }
        }
        "chans" {
          set section [string tolower [lindex $arg 0]]
          set type [string toupper [lindex $arg 1]]
          set channels [lrange $arg 2 end]
          if {[llength $arg] < 2} {
            lappend output "Usage: .${dcc_prefix}set chans <section> <type> <channels>"
          } elseif {[lsearch -exact $sectionnames $section] == -1 } {
            lappend output "invalid section... valid sections are: $sectionnames"
          } elseif {[lsearch -exact [array names echovars] $type] == -1} {
            lappend output "invalid TYPE... valid types are: [array names echovars]"
          } elseif {$channels == ""} {
            lappend output "chans($section-$type) is currently set to: $chans($section-$type)"
          } else {
            putlog "set chans\($section-$type\) to $channels"
            lappend output "set chans\($section-$type\) to $channels"
            set chans($section-$type) "$channels"
          }
        }
        "path" {
          set section [string tolower [lindex $arg 0]]
          set path [lrange $arg 1 end]
          if {[lsearch -exact $sectionnames $section] == -1 } {
            lappend output "invalid section... valid sections are: $sectionnames"
          } elseif {$path == ""} {
            if {![info exists sections($section-path)]} {set sections($section-path) "/not/set/yet" }
            lappend output "sections($section-path) is currently set to \"$sections($section-path)\""
          } else {
            set sections($section-path) "$path"
            lappend output "set sections($section-path) to \"$path\""
          }
        }
        "sitedir" {
          set command [string tolower [lindex $arg 0]]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names sitedir] $command] == -1} {
            lappend output "sitedir($command) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "sitedir($command) is currently set to \"$sitedir($command)\""
          } else {
            set sitedir($command) "$arg"
            lappend output "sitedir($command) set to $sitedir($command)"
          }
        }
        "site" {
          set command [string tolower [lindex $arg 0]]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names site] $command] == -1} {
            lappend output "site($command) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "site($command) is currently set to \"$site($command)\""
          } else {
            set site($command) "$arg"
            lappend output "site($command) set to $site($command)"
          }
        }
        "timer" {
          set command [string tolower [lindex $arg 0]]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names timer] $command] == -1} {
            lappend output "timer($command) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "timer($command) is currently set to \"$timer($command)\""
          } else {
            set timer($command) "$arg"
            lappend output "timer($command) set to $timer($command)"
          }
        }
        "echovars" {
          set type [lindex $arg 0]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names echovars] $type] == -1} {
            lappend output "echovars($type) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "echovars($type) is currently set to \"$echovars($type)\""
          } else {
            set echovars($type) "$arg"
            lappend output "echovars($type) set to $echovars($type)"
          }
        }
        "mask" {
          set type [lindex $arg 0]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names mask] $type] == -1} {
            lappend output "mask($type) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "mask($type) is currently set to \"$mask($type)\""
          } else {
            set mask($type) "[cleanmask $arg]"
            lappend output "mask($type) set to $mask($type)"
          }
        }
        "enabled" {
          set type [lindex $arg 0]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names enabled] $type] == -1} {
            lappend output "enabled($type) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "enabled($type) is currently set to \"$enabled($type)\""
          } elseif {$arg != 1 || $arg != 0} {
            set enabled($type) $arg
            lappend output "enabled($type) set to $enabled($type)"
          } else {
            lappend output "1/0 are the only valid settings for this variable... yes/no respectivly."
          }
        }
        "enabled_announce" {
          set type [lindex $arg 0]
          set arg [lrange $arg 1 end]
          if {[lsearch -exact [array names enabled_announce] $type] == -1} {
            lappend output "enabled_announce($type) is not a valid variable."
          } elseif {$arg == ""} {
            lappend output "enabled_announce($type) is currently set to \"$enabled_announce($type)\""
          } elseif {$arg != 1 || $arg != 0} {
            set enabled_announce($type) "$arg"
            lappend output "enabled_announce($type) set to $enabled_announce($type)"
          } else {
            lappend output "1/0 are the only valid settings for this variable... yes/no respectivly."
          }
        }
        "help" {
          set command [string tolower [lindex $arg 0]]
          switch -exact -- $command {
            "sectionnames" { lappend output "All the different sections you want to seperate in announces." }
            "defaultsection" { lappend output "Some values in the log file cant be determined which section they belong too.. so if it cant figure it out it will announce to this sections set of channels." }
            "sitename" { lappend output "sets the sitename." }
            "sitein" { lappend output "sets the site short name." }
            "outputt" { lappend output "chose between msg or notice output for public commands (1/0)." }
            "prefix" { lappend output "sets the public commands prefix. ie !prefix wkup" }
            "dcc_prefix" { lappend output "sets the dcc chat prefix before all commands ie \"s\" "}
            "logfile" { lappend output "sets the filename of the sitebots logfile." }
            "dirlog_testchans" { lappend output "sets the channels which bot will announce to." }
            "sonjoin" { lappend output "enables or disables the channel onjoin message." }
            "today" { lappend output "the today dir link relative to within the ftp. " }
            "invitechan" { lappend output "which channel do you want to have the bot invite people to. " }
            "deny_post" { lappend output "sets the dirs which the bot will not announce at all." }
            "glconf" { lappend output "glftpd.conf file." }
            "glftpddir" { lappend output "glftpd root directory." }
            "gllog" { lappend output "glftpd.log file." }
            "glusers" { lappend output "glftpd users dir." }
            "glbindir" { lappend output "glftpd bin dir." }
            "hideinwho" { lappend output "Users who will be hidden in ${prefix}who and .${dcc_prefix}who" }
            "bnclist" { lappend output "site connectable ips ip1:port ip2:port etc." }
            "sitedir" { lappend output "this needs to be set manually in the $sitebot(config) file." }
            "showrequest" { lappend output "this means do you want the bot to acknowledge when someone has done !site iso wkup etc.." }
            "site" {
              set command [string tolower [lindex $arg 1]]
              set arg [lrange $arg 2 end]
              switch -exact -- $command {
                "ip" { lappend output "ip the bot connects to ftp on" }
                "port" { lappend output "port the site is on" }
                "login" { lappend output "login name the bot uses (hint: use !loginname)" }
                "password" { lappend output "password the bot uses" }
                default { lappend output "valid site values are: " ; foreach line {[splitlines [lsort [array names site]] 5]} {lappend output "$line"} }
              }
            }
            "timer" {
              set command [string tolower [lindex $arg 1]]
              set arg [lrange $arg 2 end]
              switch -exact -- $command {
                "wktop" { lappend output "how often in seconds to display weektop stats to dirlog_testchans: $dirlog_testchans" }
                "bw" { lappend output "how often in seconds to display bandwidth stats to dirlog_testchans: $dirlog_testchans" }
                default { lappend output "valid timer values are: " ; foreach line {[splitlines [lsort [array names timer]] 5]} {lappend output "$line"} }
              }
            }
            "enabled" {
              set command [string tolower [lindex $arg 1]]
              set arg [lrange $arg 2 end]
              switch -exact -- $command {
                "announce" { lappend output "turn all of announce section of script (1=on/0=off)"}
                "announce_toallbots" { lappend output "make bot send new announces to all bots.. in the format \"sndall message\" (1=on/0=off)"}
                "stats" { lappend output "turn all of stats section of script (1=on/0=off)"}
                "stats_info" { lappend output "turn !siteinfo function (1=on/0=off)"}
                "stats_rules" { lappend output "turn !siterules function (1=on/0=off)"}
                "stats_nuketop" { lappend output "turn !sitenuketop function (1=on/0=off)"}
                "stats_free" { lappend output "turn !sitefree function (1=on/0=off)"}
                "stats_who" { lappend output "turn !sitewho function (1=on/0=off)"}
                "stats_traffic" { lappend output "turn !sitetraffic function (1=on/0=off)"}
                "stats_laston" { lappend output "turn !sitelaston function (1=on/0=off)"}
                "stats_search" { lappend output "turn !sitesearch function (1=on/0=off)"}
                "stats_df" { lappend output "turn !sitedf function (1=on/0=off)"}
                "stats_dupe" { lappend output "turn !sitedupe function (1=on/0=off)"}
                "stats_seen" { lappend output "turn !siteseen function (1=on/0=off)"}
                "stats_speed" { lappend output "turn !sitespeed function (1=on/0=off)"}
                "stats_nukes" { lappend output "turn !sitenukes function (1=on/0=off)"}
                "stats_user" { lappend output "turn !siteuser function (1=on/0=off)"}
                "stats_usage" { lappend output "turn !siteusage function (1=on/0=off)"}
                "dcc" { lappend output "turn all of dcc section of script (1=on/0=off)"}
                "site_invite" { lappend output "turn \"site invite nickname\" (1=on/0=off)" }
                "site_msginvite" { lappend output "turn \"/msg sitebot !siteinv <username> <password>\"  (1=on/0=off)" }
                "site_msgbnc" { lappend output "turn \"/msg sitebot !sitebnc <username> <password>\"   (1=on/0=off)" }
                "site_msgaddip" { lappend output "turn \"/msg sitebot !siteaddip <username> <password> <ident@ip>   \"(1=on/0=off)" }
                "auto_bw" { lappend output "turn bandwidth announces every $timer(bw) seconds to $dirlog_testchans (1=on/0=off)" }
                "auto_wktop" { lappend output "turn weektop announces every $timer(wktop) seconds to $dirlog_testchans (1=on/0=off)" }
                default { lappend output "valid enabled values are: " ; foreach line {[splitlines [lsort [array names enabled]] 5]} {lappend output "$line"} }
              }
            }
            "+sitedir" { lappend output "this relates to adding a sitedir name, ie, $prefix <sitedirname> wkup"}
            "-sitedir" { lappend output "this relates to deleting a sitedir name, ie, $prefix <sitedirname> wkup"}
            "sitedir" { lappend output "this is the path associated with a particular sitedir which the bot needs to change dir too, ie \"/site/ISO\""}
            "" {
              lappend output "+--\[ .${dcc_prefix}set help \]--------------------------------------- -- --- - - -"
              lappend output "|  valid variables in \($sitebot(config)\):"
              lappend output "|    sitename sitein outputt prefix sonjoin bnclist"
              lappend output "|    dcc_prefix logfile dirlog_testchans showrequest"
              lappend output "|    today invitechan deny_post bnclist glbindir ftpwho"
              lappend output "|    glconf glftpddir gllog glusers glbindir hideinwho"
              lappend output "|  bit more complex variables:"
              lappend output "|    site <ip|port|login|password> <value>"
              lappend output "|    timer <wktop|bw> <value>"
              lappend output "|    enabled <field> <0|1>"
              lappend output "|    +sitedir <sitedirtype>"
              lappend output "|    -sitedir <sitedirtype>"
              lappend output "|    sitedir <sitedirtype> <path>"
              lappend output "|------------------------------------------------ - - -"
              lappend output "|  valid variables in \($sitebot(api)\):"
              lappend output "|    sectionnames defaultsection"
              lappend output "|  bit more complex variables:"
              lappend output "|    +type <type>"
              lappend output "|    -type <type>"
              lappend output "|    path <sectionname> <what to>"
              lappend output "|    chans <sectionname> <type> <channels>"
              lappend output "|    echovars <type> <info>"
              lappend output "|    enabled_announce <type> <0|1>"
              lappend output "|    mask <type> <mask>"
              lappend output "|----------------------------------------------------- - -  -"
              lappend output "|   ${dcc_prefix}saveconfig    - save changes."
              lappend output "|   ${dcc_prefix}set variablename <value>"
              lappend output "|   ${dcc_prefix}set help variable - more detailed help"
              lappend output "|----------------------------------------------------- - - -"
              lappend output "|  valid types are: "
              foreach line [splitlines [lsort [array names echovars]] 6] { lappend output "|   $line" }
              lappend output "|"
              lappend output "|  valid fields for enabled are:"
              foreach line [splitlines [lsort [array names enabled]] 5] { lappend output "|   $line" }
              lappend output "|"
              lappend output "|  valid sitedir sections are:"
              foreach line [splitlines [lsort [array names sitedir]] 6] { lappend output "|   $line" }
              lappend output "`----------------------------- -- ----- -  "
            }
            default { lappend output "Help on that item is unavailable." }
          }
        }
        default {
          lappend output "unknown variable... check \".${dcc_prefix}set help\""
        }
      }
      return $output
    }


    #HELP
    bind dcc - ${dcc_prefix}help dcc_help

    proc dcc_help {hand idx arg} { global prefix dcc_prefix ver sitedir enabled
      putlog "#$hand# help"
      putdcc $idx "\002STANDARD HELP-(PUBLIC & DCC)\002----${ver}-"
      putdcc $idx "------------------------------------------------------------"
      putdcc $idx "${prefix}ver      - Show Version."
      if $enabled(stats_rules) {putdcc $idx "${prefix}rules    - Site Rules."}
      if $enabled(stats_info) {
        putdcc $idx "${prefix} <section> wkup  - Weeks Top Uploaders."
        putdcc $idx "${prefix} <section> wkdn  - Weeks Top Downloaders."
        putdcc $idx "${prefix} <section> gpwk  - Weeks Top Groups Up."
        putdcc $idx "${prefix} <section> gpwd  - Weeks Top Groups Down."
        putdcc $idx "${prefix} <section> alup  - Alltime Top Uploaders."
        putdcc $idx "${prefix} <section> aldn  - Alltime Top Downloaders."
        putdcc $idx "${prefix} <section> gpal  - Alltime Top Group Uploads."
        putdcc $idx "${prefix} <section> gpad  - Alltime Top Group Downloads."
        putdcc $idx "${prefix} <section> dayup - Today's Top Uploaders."
        putdcc $idx "${prefix} <section> daydn - Today's Top Downloaders."
        putdcc $idx "${prefix} <section> monthup       - Top Uploaders For The Month."
        putdcc $idx "${prefix} <section> monthdn       - Top Downloaders For The Month."
        putdcc $idx "${prefix} <section> new <#number> - Last <#number> Uploads."
      }
      if $enabled(stats_nuketop) {putdcc $idx "${prefix}nuketop           - View NukeTop Stats."}
      if $enabled(stats_free)    {putdcc $idx "${prefix}free              - Show Free Space on site."}
      if $enabled(stats_who)     {putdcc $idx "${prefix}who               - Whos Online and What are They Doing."}
      if $enabled(stats_traffic) {putdcc $idx "${prefix}traffic           - View site traffic."}
      if $enabled(stats_laston)  {putdcc $idx "${prefix}laston            - Last 10 Logins."}
      if $enabled(stats_search)  {putdcc $idx "${prefix}search <string>   - Search for directories containing <string>."}
      if $enabled(stats_dupe)    {putdcc $idx "${prefix}dupe <string>     - Search the Dupe datebase."}
      if $enabled(stats_seen)    {putdcc $idx "${prefix}seen <login>      - Show When User was last Logged on."}
      if $enabled(stats_speed)   {putdcc $idx "${prefix}speed <username>  - speed check a user or group of users."}
      if $enabled(stats_nukes)   {putdcc $idx "${prefix}nukes <#number>   - Last <#number> Nukes."}
      if $enabled(stats_user)    {putdcc $idx "${prefix}user <login>      - Show Stats on a User."}
      if $enabled(stats_usage)   {putdcc $idx "${prefix}bw                - Show Bandwidth in Use."}
      if $enabled(stats_df)      {putdcc $idx "${prefix}df                - Show Free Disk Space."}
      if $enabled(stats_info) {
        putdcc $idx "------------------------------------------------------------"
        putdcc $idx "Valid sections are: [array names sitedir]"
        putdcc $idx "------------------------------------------------------------"
      }
      if { [matchattr $hand C] } {
        putdcc $idx "\002SITEOP HELP\002---------------------------------------------"
        putdcc $idx ".${dcc_prefix}announce <announcement>"
        putdcc $idx ".${dcc_prefix}addip    <user> <ip1> <ip2> <ip3> <ip4> <ip5> ..."
        putdcc $idx ".${dcc_prefix}adduser  <user> <password> <group> <ip1> <ip2> ..."
        putdcc $idx ".${dcc_prefix}delip    <user> <ip1> <ip2> <ip3> <ip4> <ip5>"
        putdcc $idx ".${dcc_prefix}deluser  <user>"
        putdcc $idx ".${dcc_prefix}chgrp    <user> <oldgroup> <newgroup>"
        putdcc $idx ".${dcc_prefix}chlogins <user> <max login>"
        putdcc $idx ".${dcc_prefix}chpass   <user> <new password>"
        putdcc $idx ".${dcc_prefix}chratio  <user> <ratio>"
        putdcc $idx ".${dcc_prefix}chslots  <user> <slots>"
        putdcc $idx ".${dcc_prefix}chunfo   <user> <tagline>"
        putdcc $idx ".${dcc_prefix}chflags  <user> <+/-><FLAGS>"
        putdcc $idx ".${dcc_prefix}chitime  <user> <new idle time>"
        putdcc $idx ".${dcc_prefix}disable  <user>"
        putdcc $idx ".${dcc_prefix}enable   <user>"
        putdcc $idx ".${dcc_prefix}flags    <user>"
        putdcc $idx ".${dcc_prefix}groups   (Display All Groups)"
        putdcc $idx ".${dcc_prefix}grpadd   <group>"
        putdcc $idx ".${dcc_prefix}grpdel   <group>"
        putdcc $idx ".${dcc_prefix}grplog   <group> <num>"
        putdcc $idx ".${dcc_prefix}grpnfo   <group> <info>"
        putdcc $idx ".${dcc_prefix}grpren   <group> <newgroup>"
        putdcc $idx ".${dcc_prefix}ginfo    <group>"
        putdcc $idx ".${dcc_prefix}give     <user> <mbs>"
        putdcc $idx ".${dcc_prefix}help     (This Window)"
        #putdcc $idx ".${dcc_prefix}kill     <pid>"
        putdcc $idx ".${dcc_prefix}logins   <how many days to show> (Logins Log)"
        putdcc $idx ".${dcc_prefix}log      (Log of Changes Made Through bot)"
        putdcc $idx ".${dcc_prefix}msgauthor <youremail> <message>"
        putdcc $idx ".${dcc_prefix}nuke     <today|date> <dir> <x> <reason>"
        putdcc $idx ".${dcc_prefix}purge    <*/username> (Clear Database of Users Flagged For Deletion)"
        putdcc $idx ".${dcc_prefix}rules    (Site Rules)"
        putdcc $idx ".${dcc_prefix}set      <variable> <value>"
        putdcc $idx ".${dcc_prefix}site     <whatever>"
        putdcc $idx ".${dcc_prefix}take     <user> <mbs>"
        putdcc $idx ".${dcc_prefix}time     (Display Local Time And Stat Reset Times)"
        putdcc $idx ".${dcc_prefix}transfer <user> <section1> <section2> <mbs>"
        putdcc $idx ".${dcc_prefix}uchanges <how many days to show> (User Changes Log)"
        putdcc $idx ".${dcc_prefix}undupe   <filename>"
        putdcc $idx ".${dcc_prefix}unnuke   <today|date> <dir> <reason>"
        putdcc $idx ".${dcc_prefix}user     <username>"
        putdcc $idx ".${dcc_prefix}users    <*/LEECH/GADMIN/SITEOP/USEREDIT> etc.."
        putdcc $idx ".${dcc_prefix}who      (Display Whos Connected)"
        putdcc $idx ".${dcc_prefix}who2     (Display Whos Connected With PIDS)"
        putdcc $idx "---------------------------------------------------------------------"
      } elseif { [matchattr $hand S] } {
        putdcc $idx "\002STAFF HELP\002------------------------------------------------"
        putdcc $idx ".${dcc_prefix}addip    <user> <ip1> <ip2> <ip3> <ip4> <ip5>"
        putdcc $idx ".${dcc_prefix}announce <announcement>"
        putdcc $idx ".${dcc_prefix}delip    <user> <ip1> <ip2> <ip3> <ip4> <ip5>"
        putdcc $idx ".${dcc_prefix}flags    <user>"
        putdcc $idx ".${dcc_prefix}ginfo    <group>"
        putdcc $idx ".${dcc_prefix}groups   (Display All Groups)"
        putdcc $idx ".${dcc_prefix}help     (This Window)"
        putdcc $idx ".${dcc_prefix}msgauthor <youremail> <message>"
        putdcc $idx ".${dcc_prefix}nuke     <where|today> <dir> <x> <reason>"
        putdcc $idx ".${dcc_prefix}rules    (Site Rules)"
        putdcc $idx ".${dcc_prefix}time     (Display Local Time And Stat Reset Times)"
        putdcc $idx ".${dcc_prefix}undupe   <filename>"
        putdcc $idx ".${dcc_prefix}unnuke   <where|today> <dir> <reason>"
        putdcc $idx ".${dcc_prefix}user     <username>"
        putdcc $idx ".${dcc_prefix}users    <*/LEECH/GADMIN/SITEOP/USEREDIT> etc.."
        putdcc $idx ".${dcc_prefix}who      (Display Whos Connected)"
        putdcc $idx "---------------------------------------------------------------------"
      } elseif { [matchattr $hand N] } {
        putdcc $idx "\002NUKER HELP\002-----------------------------------------------"
        putdcc $idx ".${dcc_prefix}undupe   <filename>"
        putdcc $idx ".${dcc_prefix}nuke     <where|today> <release> <x> <reason>"
        putdcc $idx ".${dcc_prefix}unnuke   <where|today> <release> <reason>"
        putdcc $idx ".${dcc_prefix}groups   (Display All Groups)"
        putdcc $idx ".${dcc_prefix}help     (This Window)"
        putdcc $idx ".${dcc_prefix}rules    (Site Rules Contains Nuking Chart)"
        putdcc $idx ".${dcc_prefix}time     (Display Local Time And Stat Reset Times)"
        putdcc $idx ".${dcc_prefix}user     <username>"
        putdcc $idx ".${dcc_prefix}who      (Display Whos Connected)"
        putdcc $idx "---------------------------------------------------------------------"
      } else {
        putdcc $idx "\002GENERAL HELP\002----------------------------------------------------------"
        putdcc $idx ".${dcc_prefix}groups   (Display All Groups)"
        putdcc $idx ".${dcc_prefix}help     (This Window)"
        putdcc $idx ".${dcc_prefix}rules    (Site Rules Contains Nuking Chart)"
        putdcc $idx ".${dcc_prefix}time     (Display Local Time And Stat Reset Times)"
        putdcc $idx ".${dcc_prefix}user     <username>"
        putdcc $idx ".${dcc_prefix}who      (Display Whos Connected)"
        putdcc $idx "---------------------------------------------------------------------"
        putdcc $idx "| +N = nuker access   |  +C = siteop access   |  +S = staff access  |"
        putdcc $idx "---------------------------------------------------------------------"
      }
    }
  }
}

sitebot:main
