#########################################################
# This script is part of zipscript-c made by dark0n3    #
#########################################################
# BASIC CONFIG                                          #
#########################################################
set location(GLLOG)  "/glftpd/ftp-data/logs/glftpd.log"
set location(PASSWD) "/glftpd/etc/passwd"
set location(USERS)  "/glftpd/ftp-data/users/"

set msgtypes(RACE)    "NEWDIR DELDIR INCOMPLETE NUKE UNNUKE PRE RACE SFV UPDATE HALFWAY NEWLEADER COMPLETE STATS"
set msgtypes(DEFAULT) "MSGINVITE BADMSGINVITE INVITE LOGIN LOGOUT"

set sitename       "dS"
set cmdpre         "!ds"
set bnc(LIST)      "msn.test1.com:123 msn.test2.com:345 msn.test3.com:567"
set bnc(USER)      "bncuser"
set bnc(PASS)      "bncpass"
set bnc(TIMEOUT)   "2"
set sections       "GAMES APPS MP3 0DAY MV"

set statsection(0) "MP3"
set statsection(1) "0DAY"
set statsection(2) "ISO"

set binary(CAT)		"/glftpd/bin/cat"
set binary(WHO)		"/glftpd/bin/sitewho"
set binary(BW)		"/glftpd/bin/bandwidth.sh"
set binary(STATS)	"/glftpd/bin/stats"
set binary(PASSCHK)	"/glftpd/bin/passchk"
set binary(NCFTPLS)	"/usr/bin/ncftpls"
set binary(BNCTEST)	"/glftpd/bin/bnctest.sh"
set binary(INCOMPLETE)  "/glftpd/bin/incomplete-list.sh"
set binary(DF)		"/glftpd/bin/df"

set device(0)		"/dev/hda1 ISO"
set device(1)		"/dev/hdc1 MP3"

set paths(GAMES)  "/site/incoming/games/*"
set type(GAMES)   "RACE"
set paths(APPS)   "/site/incoming/apps/*"
set type(APPS)    "RACE"
set paths(MP3)    "/site/incoming/mp3/*"
set type(MP3)     "RACE"
set paths(0DAY)   "/site/incoming/0day/*"
set type(0DAY)    "RACE"
set paths(MV)     "/site/incoming/musicvideos/*"
set type(MV)      "RACE"

set chanlist(GAMES)   "#dserver"
set chanlist(APPS)    "#dserver"
set chanlist(MP3)     "#dserver"
set chanlist(0DAY)    "#dserver"
set chanlist(MV)      "#dserver"
set chanlist(DEFAULT) "#dserver"

set disable(NEWDIR)          0
set disable(DELDIR)          0
set disable(PRE)             0
set disable(INVITE)          0
set disable(NUKE)            0
set disable(UNNUKE)          0
set disable(MSGINVITE)       0
set disable(BADMSGINVITE)    0
set disable(LOGIN)           1
set disable(LOGOUT)          1
set disable(INCOMPLETE)      0

set disable(RACE)      0
set disable(SFV)       1
set disable(UPDATE)    0
set disable(HALFWAY)   0
set disable(NEWLEADER) 0
set disable(COMPLETE)  0
set disable(STATS)     0

set disable(WELCOME)        0

set disable(DEFAULT)        1

#########################################################
# ADVANCED CONFIG, EDIT _VERY_ CAREFULLY                #
#########################################################

set denypost "*Complete* *COMPLETE*"

## Defining variables for announce
#
# Example:
#  set variables(PRE) "%pf %user %group %pregroup %files %mbytes"
#  set announce(PRE)  "-%sitename- \[%section\] %user@%group launches new %pregroup-pre called %release (%mbytesM in %filesF)"
#
# Special variables: 
#  %pf      = path filter, must be the first parameter and contain full path of the release, it defines: 
#   %release = Last directory in path ( /site/xxx/marissa-exxtasy/cd1 => cd1 )
#   %path    = Second last directory in path ( /site/xxx/marissa-exxtasy/cd1 => marissa-exxtasy )
#   %relname = all directories after those defined in paths 
#              ( paths(ISO) = "/site/xxx/" does: /site/xxx/marissa-exxtasy/cd1 => marissa-exxtasy/cd1 ) 
#
#  %bold    = bolds text
#  %uline   = underlines text
#  %section = current section name
#
#  %nuker   = name of nuker
#  %mult    = nuke multiplier
#  %reason  = nuke reason
#  %nukee   = ppl that got nuked

set variables(NEWDIR)      "%pf %user %group %tagline"
set variables(DELDIR)      "%pf %user %group %tagline"
set variables(LOGIN)       "%hostmask %ip %user %group %tagline"
set variables(LOGOUT)      "%hostmask %ip %user %group %tagline"
set variables(INVITE)      "%ircnick %user %group"
set variables(DEFAULT)     "%pf %msg"

## Converts empty or zero variable to something else if defined
#
# Example:
#  set zeroconvert(%user) "NoOne"

set zeroconvert(%group) "NoGroup"

## Splits output line to smaller pieces
# 
# To disable set it to "\n"

set splitter(CHAR) "|"


## RANDOMIZING OUTPUT
#
# Example:
#  set random(NEWDIR-0)       "-%sitename- \[%section\] + %user@%group creates a directory called %release"
#  set random(NEWDIR-1)       "-%sitename- \[%section\] + %user@%group makes a directory called %release"
#  set random(NEWDIR-2)       "-%sitename- \[%section\] + %user@%group does mkdir %release"
#   TYPE --------^   ^
#         ID --------^              
#
#  set announce(NEWDIR) "random 3"
#   TYPE ---------^        ^    ^
#         RANDOM ----------^    ^
#             # OF IDS ---------^

set announce(NEWDIR)       "-%sitename- \[%section\] + New Release: %path/%bold%release%bold (%relname) by %bold%user%bold@%group"
set announce(DELDIR)       "-%sitename- \[%section\] - Directory deleted: %path/%bold%release%bold by %bold%user%bold@%group"
set announce(BW)           "-%sitename- \[%section\] - %bold%uploads%bold uploads @ %bold%upspeed%boldkb/sec - %bold%downloads%bold downloads @ %bold%dnspeed%bold kb/sec - total: %bold%transfers%bold transfers @ %bold%totalspeed%boldkb/sec"
set announce(LOGIN)        "-%sitename- \[LOGIN\] + %bold%user%bold@%group has logged in"
set announce(LOGOUT)       "-%sitename- \[LOGOUT\] - %bold%user%bold@%group has logged out"
set announce(NUKE)         "-%sitename- \[%section\] + %path/%bold%release%bold was %ulinenuked %mult%uline by %bold%nuker%bold - reason: %reason - nukees: %nukees"
set announce(UNNUKE)       "-%sitename- \[%section\] + %path/%bold%release%bold was %ulineunnuked %mult%uline by %bold%nuker%bold - reason: %reason - nukees: %nukees"
set announce(INVITE)       "-%sitename- \[INVITE\] + %bold%user%bold@%group invited himself as %bold%ircnick%bold"
set announce(MSGINVITE)    "-%sitename- \[INVITE\] + %bold%user%bold@%group invited himself as %bold%ircnick%bold"
set announce(BADMSGINVITE) "-%sitename- \[INTRUDER\] - %bold%ircnick%bold (%host) tried to invite himself with invalid login!"
set announce(WELCOME)      "Welcome to dS's sitechan. Type !dshelp for help."
set announce(DEFAULT)      "-%sitename- \[%section\] - %msg"

#################################################################################
# SET BINDINGS                                                                  #
#################################################################################

bind pub -|- [set cmdpre]who who
bind pub -|- [set cmdpre]speed speed
bind pub -|- [set cmdpre]bw bandwidth
bind pub -|- [set cmdpre]bnc bnc

bind pub -|- [set cmdpre]dayup stats_user_dayup
bind pub -|- [set cmdpre]wkup stats_user_wkup
bind pub -|- [set cmdpre]monthup stats_user_monthup
bind pub -|- [set cmdpre]allup stats_user_allup

bind pub -|- [set cmdpre]daydn stats_user_daydn
bind pub -|- [set cmdpre]wkdn stats_user_wkdn
bind pub -|- [set cmdpre]monthdn stats_user_monthdn
bind pub -|- [set cmdpre]alldn stats_user_alldn

bind pub -|- [set cmdpre]gpwk stats_group_gpwk
bind pub -|- [set cmdpre]gpal stats_group_gpal
bind pub -|- [set cmdpre]inc  show_incompletes

bind pub -|- [set cmdpre]gwpd stats_group_gpwd
bind pub -|- [set cmdpre]gpad stats_group_gpad
bind pub -|- [set cmdpre]help help

bind pub -|- [set cmdpre]free show_free

bind join -|- * welcome_msg

bind msg -|- !invite invite


#################################################################################
# SOME IMPORTANT GLOBAL VARIABLES                                               #
#################################################################################

set dver "0.0.1"
set lastoct [file size $location(GLLOG)]
set defaultsection "DEFAULT"
set nuke(LASTTYPE) ""
set nuke(LASTDIR) ""
set nuke(SHOWN) 1
set variables(NUKE)   ""
set variables(UNNUKE) ""
set mpath ""

#################################################################################
# MAIN LOOP - PARSES DATA FROM GLFTPD.LOG                                       #
#################################################################################
proc readlog {} {
 global location lastoct disable defaultsection variables msgtypes 

 utimer 1 "readlog"
 
 set glftpdlogsize [file size $location(GLLOG)]

 if { $glftpdlogsize == $lastoct } { return 0 }
 if { $glftpdlogsize  < $lastoct } { set lastoct 0 }
 if { [catch { set of [open $location(GLLOG) r] } ] } { return 0 }

 seek $of $lastoct
 while {![eof $of]} {
  set line [gets $of]
  if {$line == ""} {continue}
  set msgtype [string trim [lindex $line 5] ":"]
  set path [lindex $line 6]

  set section [getsection "$path" "$msgtype"]
  if { [denycheck "$path"] == 0 } {
   if { [string compare "$section" "$defaultsection"] } {
    if { $disable($msgtype) == 0 || $disable(DEFAULT) == 0 } {
     if { [info exists variables($msgtype)] } {
      set echoline [parse "$msgtype" "[lrange $line 6 end]" "$section"]
      sndall "$section" "$echoline"
     } else {
      set echoline [parse "DEFAULT" "[lrange $line 6 end]" "$section"]
      sndall "$section" "$echoline"
     }
    }
   } else {
    if { [lsearch -glob "$msgtypes(DEFAULT)" "$msgtype"] != -1 } {
     if { $disable($msgtype) == 0 } {
      set echoline [parse "$msgtype" "[lrange $line 6 end]" "DEFAULT"]
      sndall "DEFAULT" "$echoline"
     }
    } else { 
     if { $disable(DEFAULT) == 0 } {
      set echoline [parse "$msgtype" "[lrange $line 6 end]" "DEFAULT"]
      sndall "DEFAULT" "$echoline"
     }
    }
   }
  }
 }

 close $of
 set lastoct [file size $location(GLLOG)]
 launchnuke
 return 0
}
#################################################################################



#################################################################################
# GET SECTION NAME (BASED ON PATH)                                              #
#################################################################################
proc getsection {cpath msgtype} {
 global sections msgtypes paths type defaultsection mpath

 foreach section $sections {
  foreach path $paths($section) {
   if { [string match $path $cpath] == 1 && [string first $msgtype $msgtypes($type($section))] != -1 } {
    set mpath $path
    return $section
   }
  }
 }
 return $defaultsection
}
#################################################################################




#################################################################################
# REPLACE WHAT WITH WITHWHAT                                                    #
#################################################################################
proc replacevar {strin what withwhat} {
 global zeroconvert
 
 set output "$strin"
 set replacement "$withwhat"

 if { [string length $replacement] == 0 && [info exists zeroconvert($what)] } { set replacement $zeroconvert($what) }
 set cutpos 0

 while { [string first $what $output] != -1 } {
  set cutstart [expr [string first $what $output] - 1]
  set cutstop  [expr $cutstart + [string length $what] + 1]
  set output "[string range $output 0 $cutstart]$replacement[string range $output $cutstop end]"
 }
 return "$output"
}
#################################################################################




#################################################################################
# CONVERT BASIC COOKIES TO DATA                                                 #
#################################################################################
proc basicreplace {strin section} {
 global sitename 

 set output [replacevar "$strin" "%sitename" "$sitename"]
 set output [replacevar "$output" "%bold" "\002"]
 set output [replacevar "$output" "%uline" "\037"]
 set output [replacevar "$output" "%section" "$section"]
 return "$output"
}
#################################################################################




#################################################################################
# CONVERT COOKIES TO DATA                                                       #
#################################################################################
proc parse {msgtype msgline section} {
 global variables announce random mpath

 set type      $msgtype

 if { ! [string compare "$type" "NUKE"] || ! [string compare "$type" "UNNUKE"] } {
  fuelnuke "$type" [lindex "$msgline" 0] "$section" "$msgline"
  return ""
 }

 if { ! [info exists announce($type)] || ! [info exists variables($type)] } { set type "DEFAULT" }

 set vars      $variables($type)

 if { ! [string compare [lindex $announce($type) 0] "random"] && [string is alnum -strict [lindex $announce($type) 1]] == 1 } {
  set output "$random($msgtype\-[rand [lindex $announce($type) 1]])"
 } else {
  set output    $announce($type)
 }

 set output [basicreplace "$output" "$section"]
 set cnt    0

 if { [ string compare [lindex $vars 0] "%pf" ] == 0 } {
  set split [split [lindex "$msgline" 0] "/"]
  set ll [llength $split]

  set split2 [split $mpath "/"]
  set sl [llength $split2]

  set temp [lrange $split [expr $sl - 1] end]
  set relname ""
  foreach part $temp {
   set relname "$relname/$part"
  }
  set temp [string range $relname 1 end]
  set output [replacevar "$output" "%relname" "$temp"]
  
  set output [replacevar "$output" "%release" "[lindex $split [expr $ll -1]]"]
  set output [replacevar "$output" "%path" "[lindex $split [expr $ll -2]]"]
  set vars [string range "$vars" 4 end]
  set cnt 1
 }

 foreach vari $vars {
  set output [replacevar "$output" "$vari" "[lindex $msgline $cnt]"]
  set cnt [expr $cnt + 1]
 }

 return "$output"
}
#################################################################################




#################################################################################
# SEND TO ALL CHANNELS LISTED                                                   #
#################################################################################
proc sndall {section args} {
 global chanlist splitter
 foreach chan $chanlist($section) {
  foreach line [split [lindex $args 0] $splitter(CHAR)] {
   putquick "PRIVMSG $chan :$line"
  }
 }
}
#################################################################################




#################################################################################
# POST WHO INFO                                                                 #
#################################################################################
proc who {nick uhost hand chan args} {
 global binary
 foreach line [split [exec $binary(WHO)] \n] {
  if { ! [info exists newline("$line")] } { set newline("$line") 0 } else { set newline("$line") [expr $newline("$line") + 1] }
  puthelp "PRIVMSG $nick :$line\003$newline("$line")"
 }
 puthelp "PRIVMSG $nick : "
}          
#################################################################################




#################################################################################
# POST SPEED                                                                    #
#################################################################################
proc speed {nick uhost hand chan args} {
 global binary announce

 set output "$announce(DEFAULT)"
 set output [replacevar "$output" "%msg" [exec $binary(WHO) [lindex $args 0]]]
 set output [basicreplace "$output" "SPEED"]
 putserv "PRIVMSG $chan :$output"  
}          
#################################################################################




#################################################################################
# POST BANDWIDTH                                                                #
#################################################################################
proc bandwidth {nick uhost hand chan args} {
 global binary announce

 set output "$announce(BW)"
 set data [exec $binary(BW)]
 set output [replacevar "$output" "%uploads" [lindex $data 0]]
 set output [replacevar "$output" "%downloads" [lindex $data 2]]
 set output [replacevar "$output" "%transfers" [lindex $data 4]]
 set output [replacevar "$output" "%upspeed" [lindex $data 1]]
 set output [replacevar "$output" "%dnspeed" [lindex $data 3]]
 set output [replacevar "$output" "%totalspeed" [lindex $data 5]]
 set output [basicreplace "$output" "BW"]

 putserv "PRIVMSG $chan :$output"  
}          
#################################################################################




#################################################################################
# POST STATS                                                                    #
#################################################################################
proc showstats {nick type time section} {
 global binary statsection

 set sect 0
 if { [string length $section] != 0 } {
  set error 1
  set sections ""
  foreach sectnumb [array names statsection] {
   if { ! [string compare [string tolower $statsection($sectnumb)] [string tolower $section]] } { 
    set sect $sectnumb
    set error 0
    break
   } else {
    append sections "$statsection($sectnumb) "
   }
  }
  if { $error == 1 } {
   puthelp "PRIVMSG $nick :Invalid section."
   puthelp "PRIVMSG $nick :Valid sections are: \002$sections\002"
   puthelp "PRIVMSG $nick : "
   return
  }
 }

 foreach line [split [exec $binary(STATS) $type $time -s $sect] "\n"] {
  if { ! [info exists newline($line)] } { set newline($line) 0 } else { set newline($line) [expr $newline($line) + 1] }
  puthelp "PRIVMSG $nick :$line\003$newline($line)"
 }
 puthelp "PRIVMSG $nick :------------------------------------------------------------------------"
 puthelp "PRIVMSG $nick : "
}
#################################################################################




#################################################################################
# INVITE CHECK                                                                  #
#################################################################################
proc invite { nick host hand arg } {
 global location binary chanlist announce

 if { [llength $arg] == 2 } {
  set username [lindex $arg 0]
  set password [lindex $arg 1]
  set result [exec $binary(PASSCHK) $username $password $location(PASSWD)]
  set group ""

  set userfile "$location(USERS)$username"


  if { ! [string compare $result "MATCH"] } {
   set output $announce(MSGINVITE)
   foreach channel $chanlist(DEFAULT) { puthelp "INVITE $nick $channel" }
   foreach line [split [exec $binary(CAT) $userfile] "\n"] {
    if { ! [string compare [lindex "$line" 0] "GROUP"] } {
     set group [lrange $line 1 end]
     break
    }
   }
  } else { if { ! [string compare $result "NOMATCH"] } {
    set output $announce(BADMSGINVITE)
   } else {
    set output $announce(BADMSGINVITE)
   }
  }

  set output [replacevar "$output" "%ircnick" "$nick"]
  set output [replacevar "$output" "%user" "$username"]
  set output [replacevar "$output" "%host" "$host"]
  set output [replacevar "$output" "%group" "$group"]
  set output [basicreplace "$output" "INVITE"]
  sndall "DEFAULT" "$output"
 }
}
#################################################################################



#################################################################################
# SHOW FREE SPACE                                                               #
#################################################################################
proc show_free { nick uhost hand chan arg } {
 global binary announce device

  set output $announce(DEFAULT)
  set devices ""

  foreach line [split [exec $binary(DF) "-m"] "\n"] {
   foreach dev [array names device] {
    set t_line [split "$line" " "]
    if { [string match [lindex "$line" 0] [lindex "$device($dev)" 0]] == 1 } {
     append devices "\[ [lindex "$device($dev)" 1]: %bold[lindex "$line" 3]%boldMB \] "
    }
   }
  }

  set output [replacevar "$output" "%msg" "$devices"]
  set output [basicreplace "$output" "DF"]
  sndall "DEFAULT" "$output"
}
#################################################################################




#################################################################################
# UPDATE NUKE BUFFER                                                            #
#################################################################################
proc fuelnuke {type path section args} {global nuke
 set args [lindex $args 0]
 if {$type == $nuke(LASTTYPE) && $path == $nuke(LASTDIR) && $nuke(SHOWN) == 0} {
   append nuke(NUKEE) "\002[lindex $args 2]\002 (\002[lindex [lindex $args 3] 1]\002MB), "
 } else {
   launchnuke
   set nuke(TYPE) $type
   set nuke(PATH) $path
   set nuke(SECTION) $section
   set nuke(NUKER) [lindex $args 1]
   set nuke(NUKEE) "\002[lindex $args 2]\002 (\002[lindex [lindex $args 3] 1]\002MB) "
   set nuke(MULT) [lindex [lindex $args 3] 0]
   set nuke(REASON) [lindex $args 4]
   set nuke(SHOWN) 0
 }
 set nuke(LASTTYPE) $type
 set nuke(LASTDIR) $path
}
#################################################################################



    
#################################################################################
# FLUSH NUKE BUFFER                                                             #
#################################################################################
proc launchnuke {} { global nuke sitename announce
 if {$nuke(SHOWN) == 1} {return 0}
 set nuke(NUKEE) [string trim $nuke(NUKEE) ", "]

 set split [split $nuke(PATH) "/"]
 set ll [llength $split]

 set output $announce($nuke(TYPE))
 set output [replacevar "$output" "%nuker" "$nuke(NUKER)"]
 set output [replacevar "$output" "%nukees" "$nuke(NUKEE)"]
 set output [replacevar "$output" "%type" "$nuke(TYPE)"]
 set output [replacevar "$output" "%mult" "$nuke(MULT)"]
 set output [replacevar "$output" "%reason" "$nuke(REASON)"]
 set output [replacevar "$output" "%section" "$nuke(SECTION)"]
 set output [replacevar "$output" "%release" "[lindex $split [expr $ll -1]]"]
 set output [replacevar "$output" "%path" "[lindex $split [expr $ll -2]]"]
 set output [basicreplace "$output" "$nuke(TYPE)"]
 sndall "$nuke(SECTION)" "$output"
  
 set nuke(SHOWN) 1
}
#################################################################################


#################################################################################
# CHECK IF RELEASE SHOULD NOT BE ANNOUNCED                                      #
#################################################################################
proc denycheck {strin} { 
 global denypost
 foreach deny $denypost {
  if { [string match $deny $strin] == 1 } { return 1 }
 }
 return 0
}
#################################################################################



#################################################################################
# SHOW INCOMPLETE LIST                                                          #
#################################################################################
proc show_incompletes { nick uhost hand chan arg } {
 global sitename binary

 foreach line [split [exec $binary(INCOMPLETE)] "\n"] {
  if { ! [info exists newline($line)] } { set newline($line) 0 } else { set newline($line) [expr $newline($line) + 1] }
  puthelp "PRIVMSG $nick :$line\003$newline($line)"
 } 
}


#################################################################################
# SHOW WELCOME MSG                                                              #
#################################################################################
proc welcome_msg { nick uhost hand chan } {
 global announce disable

 if { $disable(WELCOME) == 0 } {
  puthelp "NOTICE $nick : $announce(WELCOME)"
 }
}

#################################################################################
# SHOW BNC LIST                                                                 #
#################################################################################
proc bnc { nick uhost hand chan arg } {
 global bnc sitename binary
 putquick "NOTICE $nick : list of bnc's for $sitename"
 foreach eachbnc $bnc(LIST) {
  if {$eachbnc == ""} {continue}
  set ipport [split $eachbnc ":"]
  set status [exec $binary(BNCTEST) "$binary(NCFTPLS)" "$bnc(USER)" "$bnc(PASS)" "[lindex $ipport 1]" "$bnc(TIMEOUT)" "[lindex $ipport 0]"]
  puthelp "NOTICE $nick : $eachbnc - $status"
 }
}
#################################################################################



#################################################################################
# CHOOSE STATS PARAMETERS                                                       #
#################################################################################
proc stats_user_dayup {nick uhost hand chan args} { showstats "$nick" "-u" "-t" "[lindex $args 0]" }
proc stats_user_daydn {nick uhost hand chan args} { showstats "$nick" "-d" "-t" "[lindex $args 0]" }
#################################################################################
proc stats_user_wkup {nick uhost hand chan args} { showstats "$nick" "-u" "-w" "[lindex $args 0]" }
proc stats_user_wkdn {nick uhost hand chan args} { showstats "$nick" "-d" "-w" "[lindex $args 0]" }
#################################################################################
proc stats_user_monthup {nick uhost hand chan args} { showstats "$nick" "-u" "-m" "[lindex $args 0]" }
proc stats_user_monthdn {nick uhost hand chan args} { showstats "$nick" "-d" "-m" "[lindex $args 0]" }
#################################################################################
proc stats_user_allup {nick uhost hand chan args} { showstats "$nick" "-u" "-a" "[lindex $args 0]" }
proc stats_user_alldn {nick uhost hand chan args} { showstats "$nick" "-d" "-a" "[lindex $args 0]" }
#################################################################################
proc stats_group_gpwk {nick uhost hand chan args} { showstats "$nick" "-u" "-W" "[lindex $args 0]" }
proc stats_group_gpwd {nick uhost hand chan args} { showstats "$nick" "-d" "-W" "[lindex $args 0]" }
#################################################################################
proc stats_group_gpal {nick uhost hand chan args} { showstats "$nick" "-u" "-A" "[lindex $args 0]" }
proc stats_group_gpad {nick uhost hand chan args} { showstats "$nick" "-d" "-A" "[lindex $args 0]" }
#################################################################################



#################################################################################
#                                  Help Section                                 #
#################################################################################
proc help {nick uhost hand chan arg} {
 global sections cmdpre dver

 if {![file exist scripts/dZSbot.help]} {
  puthelp "PRIVMSG $nick : help file dZSbot.help is missing please check install"
  return 0 
 }

 puthelp "PRIVMSG $nick : -------zipscript-c--------"
 puthelp "PRIVMSG $nick : - Dark0n3's sitebot help -"
 puthelp "PRIVMSG $nick : ----------V.$dver---------"
 puthelp "PRIVMSG $nick : "
 puthelp "PRIVMSG $nick : All comands begin with $cmdpre"

 set htopic [lindex $arg 0]

 if {$htopic == ""} {
  set helpfile [open scripts/dZSbot.help r]
  set helpdb [read $helpfile]
  close $helpfile
  foreach line [split $helpdb "\n"] {
   puthelp "PRIVMSG $nick :$line"
  }
 puthelp "PRIVMSG $nick : Valid sections are : $sections"
 }

 if {$htopic != ""} {
  set hlpd "0"
  set helpfile [open scripts/dZSbot.help r]
  set helpdb [read $helpfile]
  close $helpfile
  foreach line [split $helpdb "\n"] {
   if {[lindex $line 0] == "$htopic"} {
    puthelp "PRIVMSG $nick :$line"
    set hlpd "1" 
   }
  }
  if {$hlpd == "0"} { 
   puthelp "PRIVMSG $nick : no help on that"
  }
 }
}
#################################################################################


putlog "Launching sitebot (v$dver) for zipscript-c..."
readlog
putlog "Sitebot online!"
