UPDATER_DATA="updater.dat"

NEW_CONFIG="zsconfig-new.h"
OLD_CONFIG="zsconfig.h"
SRC_CONFIG="../zipscript-c/zsconfig.h"

AWK=`which awk 2> /dev/null`

echo ""
echo "	ZipScript-C config autoupdater (c) 2001 dark0n3"
echo ""


###########################################################################
if [ -z "$AWK" ] ; then
 echo "Error, awk was not found!"
 exit 2
fi
###########################################################################



###########################################################################
read -p "Filename & location of old config file [$OLD_CONFIG]: " TMP_CONFIG
###########################################################################



###########################################################################
if [ -e "$TMP_CONFIG" ] && [ ! -z "$TMP_CONFIG" ] ; then
 OLD_CONFIG=$TMP_CONFIG
fi

if [ ! -e $OLD_CONFIG ] ; then
 echo ""
 echo "Error, old config file not found!"
 exit 2
fi

if [ ! -e $SRC_CONFIG ] ; then
 echo ""
 echo "Error, source config file not found!"
 exit 2
fi

if [ ! -e $UPDATER_DATA ] ; then
 echo ""
 echo "Error, updater datafile not found!"
 exit 2
fi
###########################################################################

echo ""

###########################################################################
echo "$OLD_CONFIG" "$SRC_CONFIG" "$NEW_CONFIG" "$UPDATER_DATA" | $AWK '{
 config["OLD"] = $1
 config["SRC"] = $2
 config["NEW"] = $3
 datafile      = $4

###
 printf("Caching %s to memory...", config["OLD"])
 while ( getline < config["OLD"] ) {
  if ( $1 == "#define" ) {
   data[$2] = substr($0, length($1) + length($2) + 2)
  }
 }
 print(" oK!")
###

###
 print("Converting old variables...")
 while ( getline < datafile ) {
  if ( data[$2] ) {
   if ( $1 == "COPY" ) {
    printf("+ Copying %s to: ", $2)
    for ( cnt = 2 ; cnt <= NF ; cnt++ ) {
     printf("%s ", data[$cnt])
     data[$cnt] = data[$2]
    }
    print("")
   } else if ( $1 == "RENAME" ) {
    printf("+ Renaming %s to: ", $2)
    for ( cnt = 2 ; cnt <= NF ; cnt++ ) {
     printf("%s ", data[$cnt])
     data[$cnt] = data[$2]
    }
    print("")
    delete data[$2]
   } else if ( $1 == "DELETE" ) {
    printf("- Removing %s from memory\n", $2) 
    delete data[$2]
   }
  }
 }
 print("Done!")
###

 printf("") > config["NEW"]

###
 printf("Checking used variables from %s and writing %s...", config["SRC"], config["NEW"])
 while ( getline < config["SRC"] ) {
  if ( $1 == "#define" ) {
   if ( data[$2] ) {
    printf("#define %s%s\n", $2, data[$2]) > config["NEW"]
   } else {
    print($0) > config["NEW"]
   }
  } else {
   print($0) > config["NEW"]
  }
 }
 print(" oK!")
###
 close(config["NEW"])

}'
###########################################################################

