#include <fcntl.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "zsconfig.h"

#ifndef PATH_MAX
#include <sys/syslimits.h>
#endif

struct tm *timenow;
time_t     tnow;

void scandirectory(char *directoryname) {
 struct dirent **namelist, **namelist2;  
 int m, n, fd;
 if ( chdir(directoryname) != -1 ) {
  if ((n = scandir(".", &namelist, 0, 0)) > 0)        
   while(n--) if ( namelist[n]->d_name[0] != '.' ) {  
    chdir(namelist[n]->d_name);
    if ((m = scandir(".", &namelist2, 0, 0)) > 0) while (m--) if ( namelist2[m]->d_name[0] != '.' ) {
     if ( (fd = open(namelist2[m]->d_name, O_NDELAY, 0777)) != -1 ) close(fd);                                          
      else unlink(namelist2[m]->d_name);        
    }
    chdir("..");
    rmdir(namelist[n]->d_name);
   }
 }
}


void scandirectory2(char *directoryname) {
 struct dirent **namelist;  
 int m, fd;
 if ( chdir(directoryname) != -1 ) {
  if ((m = scandir(".", &namelist, 0, 0)) > 0) while (m--) if ( namelist[m]->d_name[0] != '.' ) {
   if ( (fd = open(namelist[m]->d_name, O_NDELAY, 0777)) != -1 ) close(fd); 
    else unlink(namelist[m]->d_name);        
  }
 }
}



void cleanup (char *pathlist) {
 char      *data, *path;
 int        cnt, l, n = 0;

 data = malloc(PATH_MAX);
 path = malloc(PATH_MAX);

 l = strlen(pathlist);
 for ( cnt = 0 ; cnt <= l ; cnt++ ) if ( pathlist[cnt] == ' ' || cnt == l ) {
  snprintf(path, n + 1, "%s", pathlist + cnt - n);
  strftime(data, PATH_MAX, path, timenow);
  scandirectory2(data);
  n = 0;
 } else n++;

 free(data);
 free(path);
}



main( int argc, char **argv ) {
 tnow = time( NULL );
 timenow = localtime( &tnow ); 
    
 chroot(glftpdroot);
 #if ( enabled_mp3_genredir )
  scandirectory((char *)mp3_genredir);
 #endif
 #if ( enabled_mp3_yeardir ) 
  scandirectory((char *)mp3_yeardir);
 #endif
 #if ( enabled_mp3_artistdir )
  scandirectory((char *)mp3_artistdir);
 #endif
 if ( cleanupdirs[0] ) cleanup(cleanupdirs);
 exit(0);
}
