#include "zsconfig.h"
#include "include/objects.h"

char	ttime		[40],
	output2		[1024],
	output 		[2048];

/* char *hms(long secs)
*
* Converts source integer to bolded time string.
*
*/
char* hms(long secs) {
 long	hours = 0,
	mins = 0,
	tmp = 0;
 
 while ( secs >= 3600 ) { 
	 hours++;
	 secs -= 3600; 
 	}
 while ( secs >= 60 ) {
	 mins++;
	 secs -= 60; 
	}

 if ( hours ) tmp = sprintf(ttime, "\\002%i\\002h ", hours);
 if ( mins )  tmp += sprintf(ttime + tmp, "\\002%i\\002m ", mins);
 if ( secs || ! tmp ) tmp += sprintf(ttime + tmp, "\\002%i\\002s ", secs);
 return ttime;
}


/* char *convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos)
*
* Converts cookie containing string to plain text.
*
*/
char* convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos) {
 int	n, val1,
	m, val2;
 char   *out_p,
	ctrl[50];


 out_p = output2;
 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) {
	 n++;
	 m = n;
	 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
    
	 if ( n > m ) {
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val1 = atoi(ctrl);
		} else val1 = 0;
 
	 if ( instr[n] == '.' ) {
		 n++;
		 m = n;
		 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val2 = atoi(ctrl);
		} else val2 = -1;

	 switch ( instr[n] ) {
		 case 'B': out_p += sprintf(out_p, "\\002"); break;
		 case 'F': out_p += sprintf(out_p, "%*i", val1, raceI->fastest_user[0]); break;
		 case 'n': out_p += sprintf(out_p, "%*i", val1, userpos + 1); break;
		 case 'u': out_p += sprintf(out_p, "%*.*s", val1, val2, userI->name); break;
		 case 'g': out_p += sprintf(out_p, "%*.*s", val1, val2, groupI[userI->group]->name); break;
		 case 'U':
			 sprintf(ctrl, "%s/%s", userI->name, groupI[userI->group]->name);
			 out_p += sprintf(out_p, "%*.*s", val1, val2, ctrl);
			break;
		 case 'b': out_p += sprintf(out_p, "%*i", val1, userI->bytes); break;
		 case 'k': out_p += sprintf(out_p, "%*.*f", val1, val2, userI->bytes / 1024.); break;
		 case 'm': out_p += sprintf(out_p, "%*.*f", val1, val2, (userI->bytes >> 10) / 1024.); break;
		 case 'p': out_p += sprintf(out_p, "%*.*f", val1, val2, userI->bytes * 100. / raceI->total_size); break;
		 case 'f': out_p += sprintf(out_p, "%*i", val1, userI->files); break;
		 case 'S': out_p += sprintf(out_p, "%*i", val1, raceI->slowest_user[0]); break;
		 case 's': out_p += sprintf(out_p, "%*.*f", val1, val2, userI->bytes / userI->speed); break;
		 case '%': out_p++[0] = instr[n];
		}
	} else out_p++[0] = instr[n];
 out_p[0] = 0;
 return output2;
} 
 



/* char *convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos)
*
* Converts cookie containing string to plain text.
*
*/
char* convert3(struct VARS *raceI, struct GROUPINFO *groupI, char *instr, short grouppos) {
 int	n, val1,
	m, val2;
 char   *out_p,
	ctrl[10];

 out_p = output2;
 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) {
	 n++;
	 m = n;
	 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
    
	 if ( n > m ) {
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val1 = atoi(ctrl);
		} else val1 = 0;

	if ( instr[n] == '.' ) {
		 n++;
		 m = n;
		 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val2 = atoi(ctrl);
		} else val2 = -1;
    
	 switch ( instr[n] ) {
		 case 'B': out_p += sprintf(out_p, "\\002"); break;
		 case 'n': out_p += sprintf(out_p, "%*i", val1, grouppos + 1); break;
		 case 'g': out_p += sprintf(out_p, "%*.*s", val1, val2, groupI->name); break;
		 case 'b': out_p += sprintf(out_p, "%*i", val1, groupI->bytes); break;
		 case 'k': out_p += sprintf(out_p, "%*.*f", val1, val2, groupI->bytes / 1024.); break;
		 case 'm': out_p += sprintf(out_p, "%*.*f", val1, val2, (groupI->bytes >> 10) / 1024.); break;
		 case 'p': out_p += sprintf(out_p, "%*.*f", val1, val2, groupI->bytes * 100.0 / raceI->total_size); break;
		 case 'f': out_p += sprintf(out_p, "%*i", val1, groupI->files); break;
		 case 's': out_p += sprintf(out_p, "%*.*f", val1, val2, groupI->bytes / groupI->speed); break;
		 case 'u': out_p += sprintf(out_p, "%*i", val1, groupI->users); break;
		 case '%': out_p++[0] = instr[n];
		}
	} else out_p++[0] = instr[n];
 out_p[0] = 0;
 return output2;
}




/* char *convert(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr)
*
* Converts cookie containing string to plain text.
*
*/
char* convert(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *instr) {
 int 	n, val1,
	m, val2;
 char	*out_p,
 	ctrl[10];

 out_p = output;

 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) {
	 n++;
	 m = n;
	 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
    
	 if ( n > m ) {
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val1 = atoi(ctrl);
		} else val1 = 0;

	 if ( instr[n] == '.' ) {
		 n++;
		 m = n;
		 while ( isdigit(instr[n]) || instr[n] == '-' ) n++;
		 sprintf(ctrl, "%.*s", n - m, instr + m);
		 val2 = atoi(ctrl);
		} else val2 = -1;

	 switch ( instr[n] ) {
		 case 'a': out_p += sprintf(out_p, "%*.*f", val1, val2, raceI->total_size / raceI->total_speed); break;
		 case 'A': out_p += sprintf(out_p, "%*.*f", val1, val2, raceI->total_size / ((raceI->transfer_stop.tv_sec - raceI->transfer_start.tv_sec) + (raceI->transfer_stop.tv_usec - raceI->transfer_start.tv_usec) / 1000000.) / 1024); break;
		 case 'b': out_p += sprintf(out_p, "%*i", val1, raceI->total_size); break;
		 case 'B': out_p += sprintf(out_p, "\\002"); break;
		 case 'c': n++; m = (int)instr[n] - 48; if ( m < raceI->groups ) out_p += sprintf(out_p, "%*.*s", val1, val2, convert3(raceI, groupI[groupI[m]->pos], group_info, m)); break;
		 case 'C': n++; m = (int)instr[n] - 48; if ( m < raceI->users ) out_p += sprintf(out_p, "%*.*s", val1, val2, convert2(raceI, userI[userI[m]->pos], groupI, user_info, m)); break;
		 case 'd': out_p += sprintf(out_p, "%*.*s", val1, val2, hms(raceI->transfer_stop.tv_sec - raceI->transfer_start.tv_sec)); break;
		 case 'e': out_p += sprintf(out_p, "%*.*f", val1, val2, (raceI->file_size * raceI->total_files >> 10) / 1024.); break;
		 case 'f': out_p += sprintf(out_p, "%*i", val1, raceI->total_files); break;
		 case 'F': out_p += sprintf(out_p, "%*i", val1, raceI->total_files - raceI->missing_files); break;
		 case 'g': out_p += sprintf(out_p, "%*i", val1, raceI->groups); break;
		 case 'G': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->user_group); break;
		 case 'k': out_p += sprintf(out_p, "%*.*f", val1, val2, raceI->total_size / 1024.); break;
		 case 'l': out_p += sprintf(out_p, "%*.*s", val1, val2, convert2(raceI, userI[raceI->slowest_user[1]], groupI, slowestfile, 0)); break;
		 case 'L': out_p += sprintf(out_p, "%*.*s", val1, val2, convert2(raceI, userI[raceI->fastest_user[1]], groupI, fastestfile, 0)); break;
		 case 'm': out_p += sprintf(out_p, "%*.*f", val1, val2, (raceI->total_size >> 10) / 1024.); break;
		 case 'M': out_p += sprintf(out_p, "%*i", val1, raceI->missing_files); break;
		 case 'n': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->fname); break;
		 case 'o': out_p += sprintf(out_p, "%*.*f", val1, val2, raceI->total_bad_files); break;
		 case 'O': out_p += sprintf(out_p, "%*.*f", val1, val2, (raceI->total_bad_size >> 10) / 1024.); break;
		 case 'p': out_p += sprintf(out_p, "%*.*f", val1, val2, (raceI->total_files - raceI->missing_files) * 100. / raceI->total_files); break;
		 case 'P': out_p += sprintf(out_p, "%*.*f", val1, val2, (raceI->total_bad_size / 1024.)); break;
		 case 'S': out_p += sprintf(out_p, "%*.*f", val1, val2, raceI->speed / 1024.); break;
		 case 'r': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->release_name); break;
		 case 'R': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->racer_list + 1); break;
		 case 't': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->top_messages[1] + 1); break;
		 case 'T': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->top_messages[0] + 1); break;
		 case 'u': out_p += sprintf(out_p, "%*i", val1, raceI->users); break;
		 case 'U': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->user); break;
		 case 'v': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->error_msg); break;
		 case 'V': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->progress_bar); break;
		 case 'w': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.genre); break;
		 case 'W': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.album); break;
		 case 'x': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.artist); break;
		 case 'X': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.bitrate); break;
		 case 'y': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.title); break;
		 case 'Y': out_p += sprintf(out_p, "%*.*s", val1, val2, raceI->mp3info.year); break;
		 case 'Z': out_p++[0] = raceI->compression_method; break;
		 case '%': out_p++[0] = instr[n];
		}
	} else out_p++[0] = instr[n];
 out_p[0] = 0;
 return output;
}
