#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <dirent.h>
#include "zsconfig.h"

struct stat	entry_stat;
int		zd_length;

#ifndef PATH_MAX
 #include <sys/syslimits.h>
#endif

void remove_dir_loop(char *path) {
 struct dirent	**list;
 int		n;
 char		target[PATH_MAX];

 chdir(path);
 n = scandir(path, &list, 0, 0);
 while ( n-- ) if ( list[n]->d_name[0] != '.' ) {
  stat(list[n]->d_name, &entry_stat);
  if ( S_ISDIR(entry_stat.st_mode) ) {
   sprintf(target, "%s/%s", path, list[n]->d_name);
   remove_dir_loop(target);
   rmdir(target);
   chdir(path);
  } else unlink(list[n]->d_name);
  free(list[n]);
 }
 free(list);
}


void check_dir_loop(char *path) {
 struct dirent	**list;
 int		n;
 char		target[PATH_MAX];
 
 chdir(path);
 n = scandir(path, &list, 0, 0);
 while ( n-- ) if ( list[n]->d_name[0] != '.' ) {
  stat(list[n]->d_name, &entry_stat);
  if ( S_ISDIR(entry_stat.st_mode) ) {
   sprintf(target, "%s/%s", path, list[n]->d_name );
   if ( closedir(opendir(target + zd_length)) != -1 ) {
    check_dir_loop(target);
    chdir(path);
   } else {
    remove_dir_loop(target);
    rmdir(target);
    chdir(path);
   }
  }
  free(list[n]);
 }
 free(list);
}


main () {
 zd_length = strlen(zipdatadir);
 chroot( glftpdroot );
 check_dir_loop( zipdatadir );
}
