
#if ( enabled_read_mp3info )

static const char *
genre[] =
{
  "Blues",
  "Classic Rock",
  "Country",
  "Dance",
  "Disco",
  "Funk",
  "Grunge",
  "Hip-Hop",
  "Jazz",
  "Metal",
  "New Age",
  "Oldies",
  "Other",
  "Pop",
  "R&B",
  "Rap",
  "Reggae",
  "Rock",
  "Techno",
  "Industrial",
  "Alternative",
  "Ska",
  "Death Metal",
  "Pranks",
  "Soundtrack",
  "Euro-Techno",
  "Ambient",
  "Trip-Hop",
  "Vocal",
  "Jazz+Funk",
  "Fusion",
  "Trance",
  "Classical",
  "Instrumental",
  "Acid",
  "House",
  "Game",
  "Sound Clip",
  "Gospel",
  "Noise",
  "Alternative Rock",
  "Bass",
  "Soul",
  "Punk",
  "Space",
  "Meditative",
  "Instrumental Pop",
  "Instrumental Rock",
  "Ethnic",
  "Gothic",
  "Darkwave",
  "Techno Industrial",
  "Electronic",
  "Pop Folk",
  "Eurodance",
  "Dream",
  "Southern Rock",
  "Comedy",
  "Cult",
  "Gangsta",
  "Top40",
  "Christian Rap",
  "Pop Funk",
  "Jungle",
  "Native US",
  "Cabaret",
  "New Wave",
  "Psychadelic",
  "Rave",
  "Showtunes",
  "Trailer",
  "Lo-Fi",
  "Tribal",
  "Acid Punk",
  "Acid Jazz",
  "Polka",
  "Retro",
  "Musical",
  "Rock & Roll",
  "Hard Rock",
  "Folk",
  "Folk Rock",
  "National Folk",
  "Swing",
  "Fast Fusion",
  "Bebob",
  "Latin",
  "Revival",
  "Celtic",
  "Bluegrass",
  "Avantgarde",
  "Gothic Rock",
  "Progressive Rock",
  "Psychedelic Rock",
  "Symphonic Rock",
  "Slow Rock",
  "Big Band",
  "Chorus",
  "Easy Listening",
  "Acoustic",
  "Humour",
  "Speech",
  "Chanson",
  "Opera",
  "Chamber Music",
  "Sonata",
  "Symphony",
  "Booty Bass",
  "Primus",
  "Porn Groove",
  "Satire",
  "Slow Jam",
  "Club",
  "Tango",
  "Samba",
  "Folklore",
  "Ballad",
  "Power Ballad",
  "Rhytmic Soul",
  "Freestyle",
  "Duet",
  "Punk Rock",
  "Drum Solo",
  "Acapella",
  "Euro House",
  "Dance Hall",
  "Goa",
  "Drum & Bass",
  "Club House",
  "Hardcore",
  "Terror",
  "Indie",
  "BritPop",
  "Negerpunk",
  "Polsk Punk",
  "Beat",
  "Christian Gangsta Rap",
  "Heavy Metal",
  "Black Metal",
  "Crossover",
  "Contemporary Christian",
  "Christian Rock",
  "Merengue",
  "Salsa",
  "Trash Metal",
  "Anime",
  "Jpop",
  "Synthpop",
  "Unknown"
};


/* CHECK IF MP3 IS ALLOWED */
static
void isallowedmp3() {
 #if ( enabled_banned_genres )
  if ( strcomp(banned_genres, raceI.mp3info.genre)) {
   sprintf(raceI.error_msg, "%s is banned here!", raceI.mp3info.genre);
   ERROR_CODE = 2;
  }
 #endif
 #if ( enabled_allowed_years )
  if ( ! strcomp(allowed_years, raceI.mp3info.year)) {
   sprintf(raceI.error_msg, "Releases from %s are not allowed here!", raceI.mp3info.year);
   ERROR_CODE = 2;
  }
 #endif
 #if ( enabled_allowed_rates )
  if ( ! strcomp(allowed_rates, raceI.mp3info.bitrate)) {
   sprintf(raceI.error_msg, "%s kbit encodec is not allowed here!", raceI.mp3info.bitrate);
   ERROR_CODE = 2;
  }
 #endif
}



/* READ MP3 INFO - QUITE FAST - CONVERTED FROM FREEMAN'S CPP + ADDED FEW FEATURES */
void get_mp3_info(char *filename) {
 int fd, n;
 char tmp[5];
 short iBitrate[16] = {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 0};
  
    
 fd = open(filename, O_SYNC );
 n = read(fd, tmp, 1);
   
 while ( (int)tmp[0] != -1 && n > 0 ) n = read(fd, tmp, 1);
 while ( (int)tmp[0] == -1 && n > 0 ) n = read(fd, tmp, 1);
 read(fd, tmp, 1); n = (int)tmp[0];
 if ( n < 0 ) n += 256;
 sprintf(raceI.mp3info.bitrate, "%i", iBitrate[n >> 4]);
 lseek(fd, -128, SEEK_END); read(fd, tmp, 3);
 if ( strncmp(tmp, "TAG", 3) ) { raceI.mp3info.year[0] = raceI.mp3info.title[0] = raceI.mp3info.artist[0] = raceI.mp3info.album[0] = 0 ; return; }
 read(fd, raceI.mp3info.title, 30);
 read(fd, raceI.mp3info.artist, 30);
 read(fd, raceI.mp3info.album, 30);
 lseek(fd, -35, SEEK_END); read(fd, raceI.mp3info.year, 4);
 if ( tolower(raceI.mp3info.year[1]) == 'k' ) {
  strcpy(tmp, raceI.mp3info.year);
  sprintf(raceI.mp3info.year, "%c00%c", tmp[0], tmp[2]);
 }
 lseek(fd, -1, SEEK_END); read(fd, tmp, 1); n = (int)tmp[0];
 if ( (int)tmp[0] < 0 ) n += 256;
 if ( n > 148 ) n = 148;

 strcpy(raceI.mp3info.genre, genre[n]);
 close(fd);
 
 raceI.mp3info.year[4] = raceI.mp3info.artist[30] = raceI.mp3info.title[30] = raceI.mp3info.album[30] = '\0';
}


void link_mp3() {
 int cnt;
 char chr[2];
 #if ( enabled_mp3_genredir )
  for ( cnt = 0 ; raceI.mp3info.genre[cnt] != '\0' ; cnt++ ) if ( raceI.mp3info.genre[cnt] == ' ' ) raceI.mp3info.genre[cnt] = '_';
  createlink(mp3_genredir, raceI.mp3info.genre, locations.link_source, locations.link_target);
 #endif
 #if ( enabled_mp3_artistdir )
  if ( raceI.mp3info.artist[0] ) {
   sprintf(chr, "%c", toupper(raceI.mp3info.artist[0]));  
   if ( ! varelease ) createlink(mp3_artistdir, chr, locations.link_source, locations.link_target);
                 else createlink(mp3_artistdir, "VA", locations.link_source, locations.link_target);
  }
 #endif
 #if ( enabled_mp3_yeardir )
  if ( raceI.mp3info.year[0] ) createlink(mp3_yeardir, raceI.mp3info.year, locations.link_source, locations.link_target);
 #endif
}



#else
 #define get_mp3_info(filename)
 #define isallowedmp3()
 #define link_mp3()
 #define show_mp3_info(raceI)
#endif

/*EOF*/

