#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include "include/objects.h"
#include "zsconfig.h"
#include "enabled.h"
#include "../config.h"

static struct USERINFO  **userI;
static struct GROUPINFO **groupI;
static struct VARS      raceI;
static struct LOCATIONS locations;

extern void readrace_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void read_write_leader_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI);
extern char* readsfv_mysql(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount);
extern void remove_table_mysql(char *table);
extern void delete_sfv_mysql(struct LOCATIONS *locations);

extern void clear_file_mysql(struct LOCATIONS *locations);
extern void clear_file_file(struct LOCATIONS *locations); 
extern void readrace_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void read_write_leader_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI);
extern short table_exists(struct LOCATIONS *locations, char *table);
extern char* convert(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *instr);

#include "zsfunctions.h"
 
#ifdef HAVE_MYSQL
 #define data_exists(paths, datalocation) table_exists(paths, datalocation)
 #define sql_set_race   sprintf
 #define sql_set_sfv    sprintf
 #define sql_set_leader sprintf
 #define file_set_race
 #define file_set_sfv
 #define file_set_leader

 #define sql_get_index(x)	index = get_index_mysql(x)

 #define clear_file(f)	clear_file_mysql(f)
 #define remove_data	remove_table_mysql     
 #define readsfv	readsfv_mysql
 #define readrace	readrace_mysql
 #define delete_sfv	delete_sfv_mysql
#else
 #define data_exists(paths, datalocation) fileexists(datalocation)
 #define sql_set_sfv
 #define sql_set_race   
 #define sql_set_leader
 #define file_set_race	 sprintf
 #define file_set_sfv	 sprintf
 #define file_set_leader sprintf

 #define sql_get_index(x)

 #define remove_data	unlink
 #define readsfv	readsfv_file
 #define readrace	readrace_file
 #define delete_sfv	delete_sfv_file
 #define read_write_leader read_write_leader_file
 #define clear_file(f)	clear_file_file(f)
 #define connect_mysql()
 #define disconnect_mysql()
#endif




/* WRITE TO GLFTPD LOG */
void writelog(char *msg, char *status) {
 FILE    *glfile;
 time_t timenow; 

 if ( raceI.write_log ) {
  debuglog("Writing to glftpd.log");

  timenow = time( NULL );
  fprintf(glfile = fopen(glftpdlog, "a+"), "%.24s %s: \"%s\" \"%s\"\n", ctime(&timenow), status, locations.path, msg);
  fclose(glfile);
 }
}



/* Converts cookies in incomplete indicators */
char    i_buf[ FILE_MAX ];
char *c_incomplete(char *instr, char **path) {
 int    n;
 char   *buf_p;
   
 buf_p = i_buf;
 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) {
  n++;
  switch ( instr[n] ) {
   case '1': buf_p += sprintf( buf_p, "%s", path[0] ); break;
   case '0': buf_p += sprintf( buf_p, "%s", path[1] ); break;
   case '%': buf_p++[0] = '%' ; break;
  }
 } else {
  buf_p++[0] = instr[n];
 }
 buf_p[0] = 0;
 return i_buf;
}



/* GET NAME OF MULTICD RELEASE (CDx/DISCx) (SYMLINK LOCATION + INCOMPLETE FILENAME)*/
void getrelname(char *directory) {
 int    cnt,
        l,
        n = 0,
        k = 2;
 long   index;
 char   *path[2];
  
 for ( cnt = strlen(directory) ; k && cnt ; cnt-- )
  if ( directory[cnt] == '/' ) {
   k--;
   path[k] = malloc(n + 1);
   strncpy(path[k], directory + cnt + 1, n);
   path[k][n] = 0;
   n = 0;
  } else n++;

 l = strlen(path[1]);

 sql_get_index(&locations);
 sql_set_race(locations.race, "R_%i", index);
 sql_set_sfv(locations.sfv, "S_%i", index);
 sql_set_leader(locations.leader, "L_%i", index);
 
 if (( ! strncasecmp(path[1], "CD"  , 2) && l <= 4 ) ||
     ( ! strncasecmp(path[1], "DISC", 4) && l <= 6 )) {  
  n = strlen(path[0]);
  raceI.release_name    = malloc( n + 18 );
  sprintf(raceI.release_name, "%s/\\002%s\\002", path[0], path[1]);
  locations.incomplete = c_incomplete( incomplete_cd_indicator, path );
 } else {
  raceI.release_name    = malloc( l + 10 );
  sprintf(raceI.release_name, "\\002%s\\002", path[1]);
  locations.incomplete = c_incomplete( incomplete_indicator, path );
 }
 free(path[1]);
 free(path[0]);
}




/* CORE CODE - NOT MUCH HERE - JUST CALLS FUNCTIONS IN RIGHT ORDER & SET FEW VARIABLES */
main( int argc, char **argv ) {
   char *fileext, *target;
   int n, cnt;

   #if ( enabled_suid )
    debuglog("Changing program gid/uid");
    setegid(program_gid);
    seteuid(program_uid);
   #endif

   debuglog("Caching directory");
   cachedir();
   if ( fileexists(argv[1] + 5) ) exit(0);
   connect_mysql();

   umask(0666 & 000);

   raceI.slowest_user[0] = 30000;
   raceI.fastest_user[0] =
   raceI.total_speed =
   raceI.missing_files =
   raceI.total_files =
   raceI.total_size =
   raceI.users =
   raceI.groups =
   raceI.write_log = 0;

   debuglog("Allocating memory for variables");
   raceI.user = malloc(24);
   strcpy(raceI.user, getenv("USER"));
   sprintf(raceI.user_group, getenv("GROUP"));
   if ( ! raceI.user_group[0] ) strcpy(raceI.user_group, "NoGroup");

   userI    = malloc( sizeof(int) * 30 );
   groupI   = malloc( sizeof(int) * 30 );
   locations.path   = malloc(PATH_MAX); getcwd(locations.path, PATH_MAX);
   locations.race   = malloc( n = strlen(locations.path) + 10 + strlen(zipdatadir) ); 
   locations.sfv    = malloc( n ); 
   locations.leader = malloc( n );
   raceI.fname = locations.filename = argv[1] + 5;
   file_set_sfv(locations.sfv, zipdatadir "/%s/sfvdata", locations.path);
   file_set_leader(locations.leader, zipdatadir "/%s/leader", locations.path);

   target  = malloc(4096);
   getrelname(locations.path);
 
   cnt = n = strlen( locations.filename );
   while ( locations.filename[cnt] != '.' && cnt > 0 ) cnt--;
   if ( locations.filename[cnt] != '.' ) cnt = n - 1; 
   fileext = malloc( n - cnt );
   strcpy( fileext, locations.filename + cnt + 1);
   strtolower( fileext );

   file_set_race(locations.race, zipdatadir "/%s/racedata", locations.path);

   if ( ! strcmp(fileext, "zip")) goto ZIP;
   if ( ! strcmp(fileext, "sfv")) goto SFV;
   if ( ! strcomp(ignored_types, fileext)) goto SFV_CHECK;
   goto END;


SFV_CHECK:
    debuglog("Reading sfv-file");
    clear_file(&locations);
    readsfv(&locations, &raceI, enabled_create_missing_files, 0);
    removecomplete();
    if ( raceI.write_log = matchpath(sfv_dirs, locations.path) ) raceI.write_log = 1 - matchpath(group_dirs, locations.path);
    readrace(&locations, &raceI, userI, groupI);
    buffer_progress_bar(&raceI);
    if ( raceI.missing_files == 1 ) writelog(convert(&raceI, userI, groupI, incompletemsg), "INCOMPLETE"); 
    if ( raceI.missing_files < raceI.total_files ) {
     goto INCOMPLETE;
    } else { 
     remove_data(locations.race);
     if ( findfileext(".sfv") == NULL ) goto EMPTY_DIR;
     			      else goto INCOMPLETE;
    }
   goto END;


ZIP:
    debuglog("Removing zip-data");
    clear_file(&locations);
    if ( raceI.write_log = matchpath(zip_dirs, locations.path) ) raceI.write_log = 1 - matchpath(group_dirs, locations.path);
    else {
     if ( matchpath(sfv_dirs, locations.path) ) goto END;
    } 
    if ( ! fileexists("file_id.diz") ) {
     sprintf(target, "/bin/unzip -qqjnpC %s file_id.diz > file_id.diz", findfileext(".zip"));
     system(target);
    }
    raceI.total_files = read_diz("file_id.diz");
    if ( raceI.total_files == 0 ) raceI.total_files = 1; 
    raceI.missing_files = raceI.total_files;
    readrace(&locations, &raceI, userI, groupI);
    buffer_progress_bar(&raceI);
    removecomplete();
    if ( raceI.missing_files < 0 ) { raceI.total_files -= raceI.missing_files ; raceI.missing_files = 0; }
    if ( raceI.missing_files == 1 ) writelog(convert(&raceI, userI, groupI, incompletemsg), "INCOMPLETE"); 
    if ( ! raceI.missing_files ) { 
     createstatusbar( convert(&raceI, userI, groupI, zip_completebar) ); 
    } else if ( raceI.missing_files < raceI.total_files ) goto INCOMPLETE; 
       					       	     else goto EMPTY_DIR;
    goto END;

SFV:
    readsfv(&locations, &raceI, enabled_create_missing_files, 0);
    if ( data_exists(&locations, locations.race) ) { 
     readrace(&locations, &raceI, userI, groupI);
    }
    buffer_progress_bar(&raceI);
    if (raceI.missing_files == raceI.total_files) goto EMPTY_DIR;
    goto END;



EMPTY_DIR:
 removecomplete();
 if ( data_exists(&locations, locations.sfv)) delete_sfv(&locations); 
 unlink(locations.incomplete);
 unlink("file_id.diz"); 
 move_progress_bar(1, &raceI);
 debuglog(locations.incomplete);
 remove_data(locations.sfv);
 remove_data(locations.race); 
 remove_data(locations.leader); 
 goto END;


INCOMPLETE:
 if ( raceI.total_files ) {
  create_incomplete();
  move_progress_bar(0, &raceI);
 }


END:
  free(fileext);
  free(target);
  free(raceI.release_name);
  free(locations.path);
  free(locations.race);
  free(locations.sfv);
  free(locations.leader);
  free(raceI.user);
  disconnect_mysql();
  exit(0);
  
}

/* NEAT CODE EHH? */
