#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include "zsconfig.h"
#include "include/objects.h"
#define createzerofile(filename) fclose(fopen(filename, "a+"))

extern char* findfile(char *filename);
extern short israr (char *fileext);
extern short strcomp(char *instr, char *searchstr);

/* BSD COMPATABILITY */
#ifndef O_SYNC
 #define O_SYNC O_FSYNC
#endif


/* ALLOCA SUPPORT */
#ifndef alloca
 #define m_alloc(x) malloc(x)
 #define m_free(p) free(p)
#else
 #define m_alloc(x) alloca(x)
 #define m_free(p)
#endif


char	sfvcrc	[9];
/* READ SFV FILE & GET FCOUNT & CRC FOR CURRENT FILE IF ANY */
char* readsfv_file(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount) {
 char	*fname,
	crc[8];
 FILE	*sfvfile;
 int	len;
 
 strcpy(sfvcrc, "........" );
 if ( (sfvfile = fopen(locations->sfv, "r")) == NULL ) return;

 fread( &raceI->release_type, sizeof(int), 1, sfvfile);
 while ( fread( &len, sizeof(int), 1, sfvfile ) == 1 ) {
	 fname = m_alloc(len + 8);
	 fread( fname, 1, len, sfvfile );
	 fread( crc, 1, 8, sfvfile );
	 raceI->total_files++;
	 if ( ! strcasecmp(locations->filename, fname) ) strncpy(sfvcrc, crc, 8);
	 if ( ! findfile(fname)) {
		 if ( create ) {
			 strcpy(fname + len - 1, "-missing");
			 createzerofile(fname);
			}
		} else if ( getfcount ) raceI->missing_files--;
	 m_free( fname );
	}
 fclose(sfvfile);
 raceI->missing_files += raceI->total_files;
 return sfvcrc;
}


void delete_sfv_file(struct LOCATIONS *locations) {
 char	*fname;
 FILE	*sfvfile;
 int	len;
 
 sfvfile = fopen(locations->sfv, "r");
 fseek(sfvfile, sizeof( int ), SEEK_CUR);
 while ( fread( &len, sizeof( int ), 1, sfvfile ) == 1 ) {
	 fname = m_alloc( len + 8 );
	 fread( fname, 1, len, sfvfile );
	 fseek( sfvfile, 8, SEEK_CUR );
	 strcpy( fname + len - 1, "-missing" );
	 unlink( fname );
	 m_free( fname );
	}
 fclose(sfvfile);
}



/* READ RACESTATS FROM STATS FILE*/
void readrace_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI) {
 unsigned long  fsize;
 int            len;
 unsigned char	status;
 long		uspeed;
 long           startsec, startusec;
 FILE	*file;
 char	uname   [24],
	ugroup  [24];
 
 file = fopen(locations->race, "r");

 while ( fread( &len, sizeof( int ), 1, file ) == 1 ) {
	 fseek( file, len, SEEK_CUR );
	 fread( &status, sizeof( unsigned char ), 1, file );
	 fseek( file, 8, SEEK_CUR );
	 fread( uname, 1, 24, file );
	 fread( ugroup, 1, 24, file );
	 fread( &fsize, sizeof(unsigned long), 1, file );
	 fread( &uspeed, sizeof(long), 1, file );
	 fread( &startsec, sizeof(long), 1, file );
	 fread( &startusec, sizeof(long), 1, file );
	 switch ( status ) {
		 case F_NOTCHECKED:
		 case F_CHECKED: updatestats(raceI, userI, groupI, uname, ugroup, fsize, uspeed, startsec, startusec); break;
		 case F_BAD: raceI->total_bad_files++; raceI->total_bad_size += fsize; break;
		}
 	}
 fclose(file);
}




/* MAKE DIRECTORY FOR STATS FILE */
void maketempdir(struct LOCATIONS *locations) {
 int	cnt;
 char	*tmp;

 tmp = m_alloc(locations->length_zipdatadir + locations->length_path + 2);
 strcpy(tmp, zipdatadir);
 strcpy(tmp + locations->length_zipdatadir, locations->path);

 for ( cnt = 1; cnt <= locations->length_path ; cnt++ ) if ( locations->path[cnt] == '/' || cnt == locations->length_path ) {
	 tmp[locations->length_zipdatadir + cnt] = 0;
	 mkdir(tmp, 0777);
	 tmp[locations->length_zipdatadir + cnt] = '/';
	}
 m_free( tmp );
} 



/* READ OLD AND WRITE NEW RACE LEADER */   
void read_write_leader_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO *userI) {
 FILE	*file;

 if ( (file = fopen(locations->leader, "r+")) != NULL ) {
	 fread(&raceI->old_leader, 1, 24, file);
	 rewind(file);
	 fwrite(userI->name, 1, 24, file);
	} else {
	 raceI->old_leader[0] = 0;
	 file = fopen(locations->leader, "w+");
	 fwrite(userI->name, 1, 24, file);
	}
 fclose(file);
}



/* Test untested files */
void testfiles_file(struct LOCATIONS *locations, struct VARS *raceI) {
 int		len;
 unsigned char	status;
 FILE		*file;
 char		*fname, *realfile,
		crc[8];

 if ( ( file = fopen( locations->race, "r+" ) ) != NULL ) {
	 realfile = locations->filename;
	 while ( fread( &len, sizeof( int ), 1, file ) == 1 ) {

		 fname = m_alloc( len );
		 fread( fname, 1, len, file );
		 fread( &status, sizeof(unsigned char), 1, file );
		 fread( crc, 1, 8, file );

		 if ( status == F_NOTCHECKED ) {
			 locations->filename = fname;
			 if ( ! strncasecmp(readsfv_file(locations, raceI, 0, 0), crc, 8) ) {
				 status = F_CHECKED;
				} else {
				 unlink(fname);
				 status = F_DELETED;
				}
			}

		 fseek( file, - sizeof( unsigned char ) - 8, SEEK_CUR );
		 fwrite( &status, sizeof( unsigned char ), 1, file );
		 fseek( file, 56 + 3 * sizeof(long) + sizeof(unsigned long), SEEK_CUR );
		 m_free( fname );
		}

  locations->filename = realfile;
  raceI->total_files = raceI->missing_files = 0;
  fclose(file);
 }
}



/* SFV file parsing */
void copysfv_file(char *source, char *target, long buf_bytes) {
 int    fd,
        line_start = 0,
        index_start,
	ext_start,
        n = 0,
	m;
 char   *buf,
        *fname,
        *crc;
 int	mp3s = 0,
	rars = 0,
	others = 0;
 
 fd  = open( source, O_SYNC );
 buf = m_alloc( buf_bytes );
 read(fd, buf, buf_bytes);
 close( fd );

 fd = open( target, O_CREAT|O_TRUNC|O_WRONLY, 0666 ); 
 write( fd, &n, sizeof( int ) );

 for ( ; n < buf_bytes; n++ ) if ( buf[n] == '\n' || n == buf_bytes ) {
	 index_start = n - line_start;
	 if ( buf[line_start] != ';' ) {
		 while ( buf[index_start + line_start] != ' ' && index_start-- );
		 if ( index_start > 0 ) {
			 buf[index_start + line_start] = 0;
			 crc = fname = buf + line_start;
			 ext_start = index_start;
			 for ( m = 0 ; m < index_start ; m++ ) fname[m] = tolower(fname[m]);
			 while ( fname[ext_start] != '.' && ext_start-- ) ;
			 if ( ext_start <= 0 ) ext_start = index_start; else ext_start++;

			 index_start++;
			 crc += index_start;
			 if ( ! strcomp(ignored_types, fname + ext_start) ) {
				 if ( ! strcmp(fname + ext_start, "mp3") ) {
					 mp3s++;
					} else if ( israr(fname + ext_start) ) {
					 rars++;
					} else {
					 others++;
					}
				 write( fd, &index_start, sizeof( int ) );
				 write( fd, fname, index_start );
				 write( fd, crc, 8 );
				}
			}
   		}
   	 line_start = n + 1;
  	}

 lseek( fd, 0, 0 );

 if ( mp3s > rars ) {
	 if ( mp3s > others ) {
		 n = 3;
		} else {
		 n = 2;
		}
	} else if ( rars > others ) {
	 n = 1;
	} else {
	 n = 2;
	}

 m_free( buf );
 write( fd, &n, sizeof( int ) );
 close( fd );
}


/* Create list of all files in release (cached entries) */
void create_indexfile_file(struct LOCATIONS *locations, char *filename) {
 FILE	*index;
 int	n;

 index = fopen(filename, "w");
 fprintf(index, "Feature currently disabled... - dark0n3\n");
 fclose(index);
}



void clear_file_file(struct LOCATIONS *locations) {
 int            len;
 unsigned char	status;
 FILE		*file;
 char		*fname;

 if ( (file = fopen(locations->race, "r+")) != NULL ) {
	 while ( fread( &len, sizeof( int ), 1, file ) == 1 ) {
		 fname = m_alloc( len );
		 fread( fname, 1, len, file );
		 fread( &status, sizeof( unsigned char ), 1, file );

		 if ( status >= F_CHECKED && ! strcmp(locations->filename, fname)) {
			 status = F_DELETED;
			 fseek( file, - sizeof(unsigned char), SEEK_CUR );
			 fwrite( &status, sizeof(unsigned char), 1, file );
			}

		 fseek( file, 56 + 3 * sizeof(long) + sizeof(unsigned long), SEEK_CUR);
		 m_free( fname );
		}
	 fclose(file);
	}
}



/* write race data into racedata file */
void writerace_file(struct LOCATIONS *locations, struct VARS *raceI, char *crc, unsigned char status) {
 FILE  *file;
 int    len;

 len = strlen(locations->filename) + 1;

 clear_file_file(locations);
 
 file = fopen(locations->race, "a+");

 fwrite(&len, sizeof(int), 1, file);
 fwrite(locations->filename, 1, len, file);
 fwrite(&status, sizeof(unsigned char), 1, file);
 fwrite(crc, 1, 8, file);

 fwrite(raceI->user,  1, 24, file);
 fwrite(raceI->user_group, 1, 24, file);
 fwrite(&raceI->file_size, sizeof(unsigned long), 1, file);
 fwrite(&raceI->speed, sizeof(long), 1, file);
 fwrite(&raceI->transfer_start.tv_sec, sizeof(long), 1, file);
 fwrite(&raceI->transfer_start.tv_usec, sizeof(long), 1, file);
 fclose(file);
}
