#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include "zsconfig.h"
#include "include/objects.h"

#define GROUPFILE "/etc/group"
#define PASSWDFILE "/etc/passwd"

struct GROUP {
	char		*name;
	gid_t		id;
};

struct USER {
	char		*name;
	uid_t		id;
};

int	groups = 0,
	users  = 0;

static struct USER	**user;
static struct GROUP	**group;
static struct USERINFO  **userI;
static struct GROUPINFO **groupI;
static struct VARS      raceI;
static struct LOCATIONS locations;
static struct stat      fileinfo;

extern void sortstats(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern char* convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos);
extern char* convert3(struct VARS *raceI, struct GROUPINFO *groupI, char *instr, short grouppos);
extern char* convert(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *instr);
extern char* readsfv_file(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount);

extern void writerace_file(struct LOCATIONS *locations, struct VARS *raceI, char *crc, int logtype);
extern void readrace_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void copysfv_file(char *source, char *target, long buf_bytes);
extern void testfiles_file(struct LOCATIONS *locations, struct VARS *raceI);
extern void read_write_leader_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO *userI);
extern void create_indexfile_file(struct LOCATIONS *locations, char *filename);
extern void maketempdir(struct LOCATIONS *locations);

extern long get_index_mysql(struct LOCATIONS *locations);

extern char* readsfv_mysql(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount);
extern void writerace_mysql(struct LOCATIONS *locations, struct VARS *raceI, char *crc, int status);
extern void readrace_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void copysfv_mysql(struct LOCATIONS *locations, char *source, char *target, unsigned long buf_bytes);
extern void create_indexfile_mysql(struct LOCATIONS *locations, char *filename);
extern void testfiles_mysql(struct LOCATIONS *locations, struct VARS *raceI);

extern void read_write_leader_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO *userI);
extern short table_exists(struct LOCATIONS *locations, char *table);

#include "zsfunctions.h"

#ifdef HAVE_MYSQL
 #define data_exists(paths, datalocation) table_exists(paths, datalocation)
 #define sql_set_race   sprintf   
 #define sql_set_sfv    sprintf  
 #define sql_set_leader sprintf
 #define sql_get_index(x)       index = get_index_mysql(x)
 #define file_set_race
 #define file_set_sfv
 #define file_set_leader
 #define maketempdir

 #define readsfv           readsfv_mysql
 #define writerace         writerace_mysql
 #define copysfv(a,b,c,d)  copysfv_mysql(a,b,c,d)
 #define readrace          readrace_mysql
 #define testfiles         testfiles_mysql
 #define create_indexfile  create_indexfile_mysql
 #define read_write_leader read_write_leader_mysql   
#else
 #define data_exists(paths, datalocation) fileexists(datalocation)
 #define sql_set_sfv
 #define sql_set_race
 #define sql_set_leader
 #define file_set_race   sprintf
 #define file_set_sfv    sprintf
 #define file_set_leader sprintf

 #define sql_get_index(x)

 #define readsfv           readsfv_file
 #define writerace         writerace_file
 #define copysfv(a,b,c,d)  copysfv_file(b,c,d)
 #define readrace          readrace_file
 #define testfiles         testfiles_file
 #define read_write_leader read_write_leader_file
 #define create_indexfile  create_indexfile_file
 #define connect_mysql()
 #define disconnect_mysql()
#endif


char    i_buf[ FILE_MAX ];
char *c_incomplete(char *instr, char **path) {
 int    n;
 char   *buf_p;

 buf_p = i_buf;
 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) { 
  n++;
  switch ( instr[n] ) {
   case '1': buf_p += sprintf( buf_p, "%s", path[0] ); break;
   case '0': buf_p += sprintf( buf_p, "%s", path[1] ); break;
   case '%': buf_p++[0] = '%' ; break;
  }
 } else {
  buf_p++[0] = instr[n];
 }
 buf_p[0] = 0;
 return i_buf;
}


void getrelname(char *directory) {
 int    cnt,
        l,
        n = 0,
        k = 2;
 long   index; 
 char   *path[2];
 
 for ( cnt = locations.length_path - 1 ; k && cnt ; cnt-- )
  if ( directory[cnt] == '/' ) {
   k--;
   path[k] = malloc(n + 1);
   strncpy(path[k], directory + cnt + 1, n);
   path[k][n] = 0;
   n = 0;
  } else n++;
  
 l = strlen(path[1]);
 
 sql_get_index(&locations);
 sql_set_race(locations.race, "R_%i", index);
 sql_set_sfv(locations.sfv, "S_%i", index);
 sql_set_leader(locations.leader, "L_%i", index);
  
 if (( ! strncasecmp(path[1], "CD"  , 2) && l <= 4 ) ||
     ( ! strncasecmp(path[1], "DISC", 4) && l <= 6 )) {
  n = strlen(path[0]);
  raceI.release_name    = malloc( n + 18 );
  locations.link_source = malloc(k = (locations.length_path - l)); k--;
  sprintf(raceI.release_name, "%s/\\002%s\\002", path[0], path[1]);
  strncpy(locations.link_source, locations.path, k);
  locations.link_source[k] = 0;
  locations.link_target = path[0];
  locations.incomplete = c_incomplete( incomplete_cd_indicator, path );
  free(path[1]);
 } else {
  raceI.release_name    = malloc( l + 10 );
  locations.link_source = malloc( locations.length_path + 1 );
  strcpy(locations.link_source, locations.path);
  sprintf(raceI.release_name, "\\002%s\\002", path[1]);
  locations.link_target = path[1];
  locations.incomplete = c_incomplete( incomplete_indicator, path );
  free(path[0]);
 }
}




/* Buffer groups file */
void buffer_groups(char *groupfile) {
 char   *f_buf,
        *g_name;
 long   f, n, m,
        f_size,
        g_id,
        g_n_size,
        l_start = 0;
 int	GROUPS = 0;
 
 f = open( groupfile, O_NONBLOCK );
 fstat( f, &fileinfo );
 f_size = fileinfo.st_size;
 f_buf  = malloc( f_size );
 read( f, f_buf, f_size );
 
 for ( n = 0 ; n < f_size ; n++ ) if ( f_buf[n] == '\n' ) GROUPS++;
 group = malloc( GROUPS * sizeof( int ) );
   
 for ( n = 0 ; n < f_size ; n++ ) {
  if ( f_buf[n] == '\n' || n == f_size ) {
   f_buf[n] = 0;
   m        = l_start;
   while ( f_buf[m] != ':' && m < n ) m++;
   if ( m != l_start ) {
    f_buf[m] = 0;
    g_name   = f_buf + l_start;
    g_n_size = m - l_start;
    m        = n;
    while ( f_buf[m] != ':' && m > l_start ) m--;
    f_buf[m] = 0;
    while ( f_buf[m] != ':' && m > l_start ) m--;
    if ( m != n ) {
     g_id = atoi( f_buf + m + 1 );
     group[groups] = malloc( sizeof( struct GROUP ) );
     group[groups]->name = malloc( g_n_size + 1 );
     strcpy( group[groups]->name, g_name );
     group[groups]->id = g_id;
     groups++;
    }
   }
   l_start = n + 1;
  }
 }
 
 close( f );
 free( f_buf );
}


/* Buffer groups file */
void buffer_users(char *passwdfile) {
 char   *f_buf,
        *u_name;
 long   f, n, m, l,
        f_size,
        u_id,
        u_n_size,
        l_start = 0;
 int	USERS = 0;
 
 f = open( passwdfile, O_NONBLOCK );
 fstat( f, &fileinfo );
 f_size = fileinfo.st_size;
 f_buf  = malloc( f_size );
 read( f, f_buf, f_size );
 
 for ( n = 0 ; n < f_size ; n++ ) if ( f_buf[n] == '\n' ) USERS++;
 user = malloc( USERS * sizeof( int ) );
   
 for ( n = 0 ; n < f_size ; n++ ) {
  if ( f_buf[n] == '\n' || n == f_size ) {
   f_buf[n] = 0;
   m        = l_start;
   while ( f_buf[m] != ':' && m < n ) m++;
   if ( m != l_start ) {
    f_buf[m] = 0;
    u_name   = f_buf + l_start;
    u_n_size = m - l_start;
    m        = n;
    for ( l = 0 ; l < 4 ; l ++ ) { 
     while ( f_buf[m] != ':' && m > l_start ) m--;
     f_buf[m] = 0;
    }
    while ( f_buf[m] != ':' && m > l_start ) m--;
    if ( m != n ) {
     u_id = atoi( f_buf + m + 1 );
     user[users] = malloc( sizeof( struct USER ) );
     user[users]->name = malloc( u_n_size + 1 );
     strcpy( user[users]->name, u_name );
     user[users]->id = u_id;
     users++;
    }
   }
   l_start = n + 1;
  }
 }
 
 close( f );
 free( f_buf );
}



char* get_g_name(int gid) {
 int n;
 for ( n = 0 ; n < groups ; n++ ) if ( group[n]->id == gid ) return group[n]->name;
 return "NoGroup";
}

char* get_u_name(int uid) {
 int n;
 for ( n = 0 ; n < users ; n++ ) if ( user[n]->id == uid ) return user[n]->name;
 return "NoOne";
}


main () {
 int	n, m, l;
 char	*ext;
 
 uid_t	f_uid;
 gid_t	f_gid;

 #if ( enabled_suid )
  debuglog("Changing program gid/uid");
  setegid(program_gid);
  seteuid(program_uid);
 #endif

 connect_mysql();
 umask(0666 & 000);
 cachedir();

 userI    = malloc( sizeof(int) * 30 );
 groupI   = malloc( sizeof(int) * 30 );

 raceI.slowest_user[0] = 30000;
 raceI.fastest_user[0] =
 raceI.total_speed =
 raceI.missing_files =
 raceI.total_files =
 raceI.total_bad_files = 
 raceI.total_size =
 raceI.total_bad_size =
 raceI.users =
 raceI.groups =
 raceI.release_type = 0;    

 locations.path = malloc(PATH_MAX);
 getcwd(locations.path, PATH_MAX);

 locations.race   = malloc( n = (locations.length_path = strlen(locations.path)) + 10 + strlen(zipdatadir) );
 locations.sfv    = malloc( n );
 locations.leader = malloc( n );
 raceI.user       = malloc( 24 );

 getrelname(locations.path);
 buffer_groups( GROUPFILE );
 buffer_users( PASSWDFILE );

 file_set_sfv(locations.sfv, zipdatadir "/%s/sfvdata", locations.path);
 file_set_leader(locations.leader, zipdatadir "/%s/leader", locations.path);
 file_set_race(locations.race, zipdatadir "/%s/racedata", locations.path);

 
 if ( (locations.filename = findfileext(".sfv")) != NULL) {
  removecomplete();
  copysfv(&locations, locations.filename, locations.sfv, raceI.file_size);
  unlink( locations.race );
  n = direntries;
  while ( n-- ) {
   m = l = strlen(dirlist[n]->d_name);
   ext   = dirlist[n]->d_name;
   while ( ext[m] != '.' && m > 0 ) m--;
   if ( ! m && ext[m] != '.' ) m = l; else m++;
   ext += m;
   if ( ! strcomp(ignored_types, ext) ) {
    stat( dirlist[n]->d_name, &fileinfo );
    f_uid = fileinfo.st_uid;
    f_gid = fileinfo.st_gid;

    strcpy(raceI.user, get_u_name( f_uid ));
    strcpy(raceI.user_group, get_g_name( f_gid ));
    raceI.speed = 2001 * 1024.;
    locations.filename = dirlist[n]->d_name;
    raceI.transfer_start.tv_sec = 0;
    raceI.transfer_start.tv_usec = 0;
    raceI.file_size = fileinfo.st_size;
    writerace(&locations, &raceI, "12345678", 1);
   }
  }
  readrace(&locations, &raceI, userI, groupI);
  sortstats(&raceI, userI, groupI);
 }
 if ( (locations.filename = findfileext(".zip")) != NULL) printf("ZIP\n");
 
}
