#include "zsconfig.h"
#include "include/objects.h"

extern char* convert(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *instr);
extern char* convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos);
extern char* convert3(struct VARS *raceI, struct GROUPINFO *groupI, char *instr, short grouppos);

/* UPDATE GROUP AND USERARRAYS */
void updatestats(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *usern, char *group, unsigned long filesize, long speed, long startsec, long startusec) {
 short     update = -1, cnt;
 double    speedD = filesize / (speed / 1024.);

 for ( cnt = 0 ; cnt < raceI->users ; cnt++ ) if ( strcmp(userI[cnt]->name, usern) == 0 ) { update = cnt; break; }
 if ( update > -1 ) {
  userI[update]->bytes += filesize;
  userI[update]->speed += speedD;
  userI[update]->files++;
  groupI[userI[update]->group]->bytes += filesize;
  groupI[userI[update]->group]->speed += speedD;
  groupI[userI[update]->group]->files++;
  #if ( enabled_fastestfile )
   if ( speed >> 10 > raceI->fastest_user[0] ) { raceI->fastest_user[1] = update; raceI->fastest_user[0] = speed >> 10; }
  #endif
  #if ( enabled_slowestfile )
   if ( speed >> 10 < raceI->slowest_user[0] ) { raceI->slowest_user[1] = update; raceI->slowest_user[0] = speed >> 10; }
  #endif
 } else {
  if ( ! raceI->users ) { raceI->transfer_start.tv_sec = startsec; raceI->transfer_start.tv_usec = startusec; }
  (struct USERINFO **)userI[raceI->users] = malloc(sizeof(struct USERINFO));
  strcpy(userI[raceI->users]->name, usern);
  userI[raceI->users]->files = 1;
  userI[raceI->users]->bytes = filesize;
  userI[raceI->users]->speed = speedD;
  #if ( enabled_fastestfile )
   if ( speed >> 10 > raceI->fastest_user[0] ) { raceI->fastest_user[1] = raceI->users; raceI->fastest_user[0] = speed >> 10; }
  #endif
  #if ( enabled_slowestfile )
   if ( speed >> 10 < raceI->slowest_user[0] ) { raceI->slowest_user[1] = raceI->users; raceI->slowest_user[0] = speed >> 10; }
  #endif
  for ( cnt = 0 ; cnt < raceI->groups ; cnt++ ) if ( strcmp(groupI[cnt]->name, group) == 0 ) { update = cnt; break; }
  if ( update > -1 ) {
   groupI[cnt]->bytes += filesize;
   groupI[cnt]->speed += speedD;
   groupI[cnt]->users++;
   groupI[cnt]->files++;
   userI[raceI->users]->group = cnt;
  } else {
   (struct GROUPINFO **)groupI[raceI->groups] = malloc(sizeof(struct GROUPINFO));
   strcpy(groupI[raceI->groups]->name, group);
   groupI[raceI->groups]->files = groupI[raceI->groups]->users = 1;
   groupI[raceI->groups]->bytes = filesize;
   userI[raceI->users]->group = raceI->groups;
   groupI[raceI->groups]->speed = speedD;
   raceI->groups++;
  }
  raceI->users++;
 }
 raceI->total_speed += speedD;
 raceI->total_size += filesize;
 raceI->missing_files--;
}



/* SORT USERS AND GROUPS - FAST ALGORITHM */
void sortstats(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI) {
 int cnt, cnt2, tmp, tmp2 = 0;

 for ( cnt = 0 ; cnt < raceI->users ; cnt++ ) {
  tmp = raceI->users - 1;
  for ( cnt2 = 0 ; cnt2 < raceI->users; cnt2++ )
   if ( (userI[cnt]->bytes > userI[cnt2]->bytes) || (userI[cnt]->bytes == userI[cnt2]->bytes && cnt > cnt2) ) tmp--;
  userI[tmp]->pos = cnt;
  #if ( enabled_racersmsg )
   if ( strcmp(raceI->user, userI[cnt]->name) ) tmp2 += sprintf(raceI->racer_list + tmp2, " %s", convert2(raceI, userI[cnt], groupI, racersmsg, tmp));
                                    else raceI->user_pos = cnt;
  #else
   if ( ! strcmp(raceI->user, userI[cnt]->name) ) raceI->user_pos = cnt;
  #endif
 }
 for ( cnt = 0 ; cnt < raceI->groups ; cnt++ ) {
  tmp = raceI->groups - 1;
  for ( cnt2 = 0 ; cnt2 < raceI->groups; cnt2++ )
   if ( (groupI[cnt]->bytes > groupI[cnt2]->bytes) || (groupI[cnt]->bytes == groupI[cnt2]->bytes && cnt > cnt2) ) tmp--;
  groupI[tmp]->pos = cnt;
 }
}



/* PRINT USERTOP AND GROUPTOP */
void showstats(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI) {
 int cnt;

 printf( convert(raceI, userI, groupI, realtime_user_header) );
 for ( cnt = 0 ; cnt < raceI->users ; cnt++ ) printf(convert2(raceI, userI[userI[cnt]->pos], groupI, realtime_user_body, cnt));
 printf( convert(raceI, userI, groupI, realtime_user_footer) );

 printf( convert(raceI, userI, groupI, realtime_group_header) );
 for ( cnt = 0 ; cnt < raceI->groups ; cnt++ ) printf(convert3(raceI, groupI[groupI[cnt]->pos], realtime_group_body, cnt));
 printf( convert(raceI, userI, groupI, realtime_group_footer) );
}
