#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include "include/objects.h"
#include "../config.h"
#include "zsconfig.h"
#include "enabled.h"

static struct USERINFO  **userI;
static struct GROUPINFO **groupI;
static struct VARS      raceI;
static struct LOCATIONS locations;
static struct stat	fileinfo;

extern void sortstats(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern char* convert2(struct VARS *raceI, struct USERINFO *userI, struct GROUPINFO **groupI, char *instr, short userpos);
extern char* convert3(struct VARS *raceI, struct GROUPINFO *groupI, char *instr, short grouppos);
extern char* convert(struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI, char *instr);
extern char* readsfv_file(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount);

extern void writerace_file(struct LOCATIONS *locations, struct VARS *raceI, char *crc, int logtype);
extern void readrace_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void copysfv_file(char *source, char *target, long buf_bytes);
extern void testfiles_file(struct LOCATIONS *locations, struct VARS *raceI);
extern void read_write_leader_file(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO *userI);
extern void create_indexfile_file(struct LOCATIONS *locations, char *filename);
extern void maketempdir(struct LOCATIONS *locations);

extern long get_index_mysql(struct LOCATIONS *locations);

extern char* readsfv_mysql(struct LOCATIONS *locations, struct VARS *raceI, int create, int getfcount);
extern void writerace_mysql(struct LOCATIONS *locations, struct VARS *raceI, char *crc, int status);
extern void readrace_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO **userI, struct GROUPINFO **groupI);
extern void copysfv_mysql(struct LOCATIONS *locations, char *source, char *target, unsigned long buf_bytes);
extern void create_indexfile_mysql(struct LOCATIONS *locations, char *filename);
extern void testfiles_mysql(struct LOCATIONS *locations, struct VARS *raceI);

extern void read_write_leader_mysql(struct LOCATIONS *locations, struct VARS *raceI, struct USERINFO *userI);
extern short table_exists(struct LOCATIONS *locations, char *table);


#ifdef HAVE_MYSQL
 #define data_exists(paths, datalocation) table_exists(paths, datalocation)
 #define sql_set_race   sprintf
 #define sql_set_sfv    sprintf
 #define sql_set_leader sprintf
 #define sql_get_index(x)	index = get_index_mysql(x)
 #define file_set_race  
 #define file_set_sfv
 #define file_set_leader
 #define maketempdir

 #define readsfv	   readsfv_mysql
 #define writerace	   writerace_mysql
 #define copysfv(a,b,c,d)  copysfv_mysql(a,b,c,d)
 #define readrace	   readrace_mysql
 #define testfiles	   testfiles_mysql
 #define create_indexfile  create_indexfile_mysql
 #define read_write_leader read_write_leader_mysql
#else
 #define data_exists(paths, datalocation) fileexists(datalocation)
 #define sql_set_sfv
 #define sql_set_race
 #define sql_set_leader
 #define file_set_race   sprintf
 #define file_set_sfv    sprintf
 #define file_set_leader sprintf

 #define sql_get_index(x)

 #define readsfv	   readsfv_file
 #define writerace	   writerace_file
 #define copysfv(a,b,c,d)  copysfv_file(b,c,d)
 #define readrace	   readrace_file
 #define testfiles	   testfiles_file
 #define read_write_leader read_write_leader_file
 #define create_indexfile  create_indexfile_file
 #define connect_mysql()
 #define disconnect_mysql()
#endif


short     varelease  = 2,       // Various Artists release
          ERROR_CODE = 0;

#include "zsfunctions.h"
#include "mp3.h"


/* WRITE TO GLFTPD LOG */
void writelog(char *msg, char *status) {
 FILE	*glfile;
 char	*date;
 time_t	timenow;

 if ( raceI.write_log ) {
	 timenow = time( NULL );
	 date = ctime(&timenow);
	 fprintf(glfile = fopen(glftpdlog, "a+"), "%.24s %s: \"%s\" \"%s\"\n", date, status, locations.path, msg);
	 fclose(glfile);
	}
}



/* RELEASE COMPLETE, REMOVE INCOMPLETE & RACE FILES, WRITE MESSAGE */
void complete(int completetype) {
 int	cnt,
	usrtmp,
	grptmp;
 FILE *msgfile;

 move_progress_bar(1, &raceI);
 unlink(locations.incomplete);

 #if ( enabled_write_message )
  msgfile = fopen(".message", "w+");
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_header));
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_user_header));
  for ( cnt = 0 ; cnt < raceI.users ; cnt++ ) {
   usrtmp = userI[cnt]->pos;
   fprintf(msgfile, "%s", convert2(&raceI, userI[usrtmp], groupI, message_user_body, cnt));
  }
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_user_footer));
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_group_header));
  for ( cnt = 0 ; cnt < raceI.groups ; cnt++ ) {
   grptmp = groupI[cnt]->pos;
   fprintf(msgfile, "%s", convert3(&raceI, groupI[grptmp], message_group_body, cnt));
  }
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_group_footer));

  #if ( enabled_read_mp3info )
   if ( varelease < 2 ) fprintf(msgfile, convert(&raceI, userI, groupI, message_mp3));
  #endif
  fprintf(msgfile, "%s", convert(&raceI, userI, groupI, message_footer));
  fclose(msgfile);
 #endif
 
 grptmp = usrtmp = 0;
 if ( raceI.write_log ) switch ( completetype ) {
  case 1 :
  case 2 :
   #if ( enabled_user_top && enabled_pre_user_top )
    usrtmp = sprintf(raceI.top_messages[0], convert(&raceI, userI, groupI, pre_user_top)); 
   #endif
   #if ( enabled_group_top && enabled_pre_group_top )
    grptmp = sprintf(raceI.top_messages[1], convert(&raceI, userI, groupI, pre_group_top));
   #endif
  case 0 :
   #if ( enabled_user_top )
    for ( cnt = 0 ; cnt < max_users_in_top && cnt < raceI.users ; cnt++ )
     usrtmp += sprintf(raceI.top_messages[0] + usrtmp, " %s", convert2(&raceI, userI[userI[cnt]->pos], groupI, user_top, cnt));
   #endif
   #if ( enabled_group_top )
    for ( cnt = 0 ; cnt < max_groups_in_top && cnt < raceI.groups ; cnt++ )
     grptmp += sprintf(raceI.top_messages[1] + grptmp, " %s", convert3(&raceI, groupI[groupI[cnt]->pos], group_top, cnt));
   #endif
   break;
 }
}



/* WRITE TOP MESSAGES TO GLFTPD LOG */
void writetop(int completetype, char *logtype) {
 char	*output;
 int	cnt;

 switch ( completetype ) {
  case 1 :
   output = malloc( strlen(raceI.top_messages[0]) + strlen(raceI.top_messages[1]) + 1 );
   #if ( enabled_user_top )
    strcat(output, raceI.top_messages[0]);
   #endif
   #if ( enabled_group_top )
    strcat(output, raceI.top_messages[1]);
   #endif
   if ( output[0] ) writelog(output, logtype);
   free( output );
   break;

  case 2 :
   #if ( enabled_user_top )
    writelog(raceI.top_messages[0], logtype);
   #endif
   #if ( enabled_group_top )
    writelog(raceI.top_messages[1], logtype);
   #endif
   break;

  case 3 :
   #if ( enabled_user_top )
    #if ( enabled_pre_user_top ) 
     writelog(pre_user_top, logtype);
    #endif
    for ( cnt = 0 ; cnt < max_users_in_top && cnt < raceI.users; cnt++ ) writelog(convert2(&raceI, userI[userI[cnt]->pos], groupI, user_top, cnt), logtype);
   #endif
   #if ( enabled_group_top )
    #if ( enabled_pre_group_top )
     writelog(pre_group_top, logtype);
    #endif
    for ( cnt = 0 ; cnt < max_groups_in_top && cnt < raceI.groups; cnt++ ) writelog(convert3(&raceI, groupI[groupI[cnt]->pos], group_top, cnt), logtype);
   #endif
   break;
 }
}



/* Converts cookies in incomplete indicators */
char	i_buf[ FILE_MAX ];
char *c_incomplete(char *instr, char **path) {
 int	n;
 char	*buf_p;

 buf_p = i_buf;
 for ( n = 0 ; instr[n] ; n++ ) if ( instr[n] == '%' ) {
	 n++;
	 switch ( instr[n] ) {
		 case '1': buf_p += sprintf( buf_p, "%s", path[0] ); break;
		 case '0': buf_p += sprintf( buf_p, "%s", path[1] ); break;
		 case '%': buf_p++[0] = '%' ; break;
		}
	} else buf_p++[0] = instr[n];
 buf_p[0] = 0;
 return i_buf;
}



/* GET NAME OF MULTICD RELEASE (CDx/DISCx) (SYMLINK LOCATION + INCOMPLETE FILENAME)*/
void getrelname(char *directory) {
 int	cnt,
	l, 
	n = 0, 
	k = 2;
 long	index;
 char	*path[2];

 for ( cnt = locations.length_path - 1 ; k && cnt ; cnt-- ) if ( directory[cnt] == '/' ) {
	 k--;
	 path[k] = malloc(n + 1);
	 strncpy(path[k], directory + cnt + 1, n);
	 path[k][n] = 0;
	 n = 0;
	} else n++;

 l = strlen(path[1]);

 sql_get_index(&locations);
 sql_set_race(locations.race, "R_%i", index);
 sql_set_sfv(locations.sfv, "S_%i", index);
 sql_set_leader(locations.leader, "L_%i", index);

 if (( ! strncasecmp(path[1], "CD"  , 2) && l <= 4 ) || ( ! strncasecmp(path[1], "DISC", 4) && l <= 6 )) {
	 n = strlen(path[0]);
	 raceI.release_name = malloc( n + 18 );
	 locations.link_source = malloc(k = (locations.length_path - l)); k--;
	 sprintf(raceI.release_name, "%s/\\002%s\\002", path[0], path[1]);
	 strncpy(locations.link_source, locations.path, k);
	 locations.link_source[k] = 0;
	 locations.link_target = path[0];
	 locations.incomplete = c_incomplete( incomplete_cd_indicator, path );
	 free(path[1]);
	} else {
	 raceI.release_name	= malloc( l + 10 );
	 locations.link_source	= malloc( locations.length_path + 1 );
	 strcpy(locations.link_source, locations.path);
	 sprintf(raceI.release_name, "\\002%s\\002", path[1]);
	 locations.link_target = path[1];
	 locations.incomplete = c_incomplete( incomplete_indicator, path );
	 free(path[0]);
	}
}



/* READ USER INFO FROM SHARED MEMORY - MORE ACCURATE SPEED */
void read_user_info() {
 int	usersonline, cnt;
 pid_t	pid;
 struct	shmid_ds ipcbuf;
 double	dT;

 pid = getppid();
 gettimeofday(&raceI.transfer_stop, (struct timezone *)0 );
 cnt = shmget( (key_t)KEY, 0, 0);
 online = (struct ONLINE *)shmat( cnt, NULL, SHM_RDONLY);
 shmctl( cnt, IPC_STAT, &ipcbuf);
 usersonline = ipcbuf.shm_segsz / sizeof( struct ONLINE );
 for ( cnt = 0 ; cnt < usersonline ; cnt++ ) if ( online[cnt].procid == pid ) {
	 raceI.user = online[cnt].username;
	 raceI.transfer_start = online[cnt].tstart;
	 dT = (raceI.transfer_stop.tv_usec - raceI.transfer_start.tv_usec) / 1000000.;
	 dT += (raceI.transfer_stop.tv_sec - raceI.transfer_start.tv_sec);
	 raceI.speed = online[cnt].bytes_xfer / dT;
	 break;
	}
}





/* CORE CODE - NOT MUCH HERE - JUST CALLS FUNCTIONS IN RIGHT ORDER & SET FEW VARIABLES */
main( int argc, char **argv ) {
   char *target,
	*fileext;
 
   char	*complete_msg,
	*update_msg,
	*race_msg,
	*sfv_msg,
	*newleader_msg,
	*halfway_msg,
	*complete_bar;

   int	cnt,
	n,
	complete_type;

   #if ( enabled_benchmark )
    struct timeval bstart, bstop;
    debuglog("Benchmark mode is enabled");
    gettimeofday(&bstart, (struct timezone *)0 );
   #endif

   umask(0666 & 000);
 
   #if ( enabled_suid )
    debuglog("Changing program gid/uid");
    setegid(program_gid);
    seteuid(program_uid);
   #endif

   if ( argc != 4 ) {
    debuglog("Abort, not enough parameters");
    printf(" - - Dark0n3's c++ zipscript v" version " - - (c) 2001 - -\n\nUsage: %s <filename> <path> <crc>\n\n", argv[0]);
    exit(1);
   }

   debuglog("Reseting important variables");
   raceI.slowest_user[0] = 30000;
   raceI.fastest_user[0] =
   raceI.total_speed =
   raceI.missing_files =
   raceI.total_files =
   raceI.total_bad_files = 
   raceI.total_size =
   raceI.total_bad_size =
   raceI.users =
   raceI.groups = 
   raceI.release_type = 0;

   sprintf(raceI.user_group, getenv("GROUP"));
   if ( ! raceI.user_group[0] ) strcpy(raceI.user_group, "NoGroup");

   debuglog("Reading user info from shared memory");
   read_user_info();

   debuglog("Allocating memory for dynamic variables");
   raceI.fname = locations.filename = argv[1];
   n = (locations.length_path = strlen(locations.path = argv[2])) + 1;
   locations.race   = malloc( n += 10 + (locations.length_zipdatadir = strlen(zipdatadir)));
   locations.sfv    = malloc( n );
   locations.leader = malloc( n );
   target   = malloc( n + 256 );
   userI    = malloc( sizeof(int) * 30 ); 
   groupI   = malloc( sizeof(int) * 30 );

   file_set_sfv(locations.sfv, zipdatadir "/%s/sfvdata", locations.path);
   file_set_leader(locations.leader, zipdatadir "/%s/leader", locations.path);
   file_set_race(locations.race, zipdatadir "/%s/racedata", locations.path);

   connect_mysql();
   chdir(locations.path);

   cnt = n = strlen( argv[1] );
   while ( argv[1][cnt] != '.' && cnt > 0 ) cnt--;
   if ( argv[1][cnt] != '.' ) cnt = n - 1;
   fileext = malloc( n - cnt );
   strcpy( fileext, argv[1] + cnt + 1);
   strtolower( fileext );

   cachedir();

   debuglog("Reading file size");
   stat(locations.filename, &fileinfo);
   raceI.file_size = fileinfo.st_size;

   debuglog("Parsing release name from release path");
   getrelname(locations.path);
   debuglog("Creating directory for race files");
   maketempdir(&locations);
   printf( zipscript_header );

   if ( matchpath(nocheck_dirs, locations.path) ) goto ACCEPTED_EXTENSIONS;
   if ( ! raceI.file_size ) {
    sprintf(raceI.error_msg, "zero-byte file: Not allowed!");
    goto ERROR;
   }
   if ( ! strcmp(fileext, "zip")) goto ZIP;
   if ( ! strcmp(fileext, "sfv")) goto SFV;
   if ( ! strcomp(ignored_types, fileext)) goto SFV_CHECK;
   if ( strcomp(allowed_types, fileext) ) goto ACCEPTED_EXTENSIONS;

   sprintf(raceI.error_msg, "%s-file: Not allowed!", fileext);
   goto ERROR;

SFV_CHECK:
    debuglog("Checking file integrity");
    if ( data_exists(&locations, locations.sfv) ) {
     if ( strncasecmp(readsfv(&locations, &raceI, enabled_create_missing_files, 0), argv[3], 8) ) {
       sprintf(raceI.error_msg, "CRC-Check: BAD!");
       goto ERROR;
      }
     printf( zipscript_SFV_ok );
     writerace( &locations, &raceI, argv[3], F_CHECKED );
    } else {
     #if ( enabled_sfvfirst )
      strcpy(raceI.error_msg, "CRC-Check: SFV first!");
      goto ERROR;
     #else
      printf( zipscript_SFV_skip );
      writerace( &locations, &raceI, argv[3], F_NOTCHECKED );
     #endif
    }

    debuglog("Checking if we should enable logging to glftpd.log");
    if ( raceI.write_log = matchpath(sfv_dirs, locations.path) ) raceI.write_log = 1 - matchpath(group_dirs, locations.path);

    debuglog("Performing standard race operations");

    sprintf(target, "%s-missing", locations.filename); 
    strtolower(target);
    unlink(target);

    readrace(&locations, &raceI, userI, groupI);
    if ( raceI.total_files ) buffer_progress_bar(&raceI);
    sortstats(&raceI, userI, groupI);
    showstats(&raceI, userI, groupI);
    read_write_leader(&locations, &raceI, userI[userI[0]->pos]);


    switch ( raceI.release_type ) {
     case 1:
      goto RAR;
     case 2:
      goto OTHER;
     case 3:
      goto MP3;
     default:
      if ( israr(fileext)) goto RAR;
      if ( ! strcmp(fileext, "mp3")) goto MP3;
      goto OTHER;
    }

 RAR:
    debuglog("Special RAR calls");
    get_rar_info(locations.filename);

    race_msg      = rar_race;
    update_msg    = rar_update;
    halfway_msg   = rar_halfway;
    newleader_msg = rar_newleader;
    raceI.release_type = 1;
    goto RT;

 MP3:
    debuglog("Special MP3 calls");
    get_mp3_info(locations.filename); 
    is_mp3_allowed();
    if ( ERROR_CODE ) goto ERROR;
    printf(convert(&raceI, userI, groupI, realtime_mp3_info));

    race_msg      = mp3_race;
    update_msg    = mp3_update;
    halfway_msg   = mp3_halfway;
    newleader_msg = mp3_newleader;
    raceI.release_type = 3;
    goto RT;

 OTHER:
    race_msg      = other_race;
    update_msg    = other_update;
    halfway_msg   = other_halfway;
    newleader_msg = other_newleader;
    raceI.release_type = 2;

 RT:
    debuglog("Writing to glftpd.log");

    if ( raceI.users == 1 && userI[raceI.user_pos]->files == 1 && raceI.total_files >= min_update_files ) writelog(convert(&raceI, userI, groupI, update_msg), "UPDATE");
    if ( raceI.users > 1 ) {
     if ( userI[raceI.user_pos]->files == 1 ) writelog(convert(&raceI, userI, groupI, race_msg), "RACE");
     if ( raceI.total_files >= min_newleader_files && strcmp(raceI.old_leader, userI[userI[0]->pos]->name)) writelog(convert(&raceI, userI, groupI, newleader_msg), "NEWLEADER");
    }
    if ( raceI.missing_files == raceI.total_files >> 1 && raceI.total_files >= min_halfway_files ) writelog(convert(&raceI, userI, groupI, halfway_msg), "HALFWAY");

    if ( raceI.missing_files ) goto INCOMPLETE;
    debuglog("Release is complete");

SFV_COMPLETE:
    switch ( raceI.release_type ) {
     case 1:
      complete_msg  = rar_complete;
      complete_type = rar_completetype;
      complete_bar  = rar_completebar;
      break;
     case 2:
      complete_msg  = other_complete;
      complete_type = other_completetype;
      complete_bar  = other_completebar;
      break;
     case 3:
      complete_msg  = mp3_complete;
      complete_type = mp3_completetype;
      complete_bar  = mp3_completebar;
      varelease = 0;
      if ( ! strncasecmp(locations.link_target, "VA", 2) && (locations.link_target[2] == '-' || locations.link_target[2] =='_')) { strcpy(raceI.mp3info.artist, "VA"); varelease = 1; }
      debuglog("Creating symbolic links");
      link_mp3();
      #if ( enabled_create_m3u ) 
       cnt = sprintf(target, findfileext(".sfv"));
       strcpy(target + cnt - 3, "m3u");
       create_indexfile(&locations, target);
      #endif
    }

    debuglog("Removing previous complete inidcator");
    removecomplete();
    debuglog("Creating .message file");
    complete(complete_type);

    debuglog("Writing stats to glftpd.log");
    writelog(convert(&raceI, userI, groupI, complete_msg), "COMPLETE");
    writetop(complete_type, "STATS");

    debuglog("Creating complete indicator");
    createstatusbar( convert(&raceI, userI, groupI, complete_bar) );
    #if ( enabled_complete_script )
     sprintf( target, complete_script " %s", locations.filename );
     system( target );
    #endif
    goto CHECKED;

ZIP:
    debuglog("Checking ZIP file integrity");

    sprintf(target, "/bin/unzip -qqt %s &> /dev/null", locations.filename);
    if ( system(target) ) {
     sprintf(raceI.error_msg, "ZiP integrity - BAD!");
     goto ERROR;
    }
    printf( zipscript_zip_ok );

    #if ( enabled_includezip )
     debuglog("Adding specified files to zip");
     sprintf(target, "/bin/zip -ujqq %s %s &> /dev/null", locations.filename, includezip);
     system(target);
    #endif

    debuglog("Checking if we should enable logging to glftpd.log");
    if ( raceI.write_log = matchpath(zip_dirs, locations.path) ) raceI.write_log = 1 - matchpath(group_dirs, locations.path); 
     else if (matchpath(sfv_dirs, locations.path)) goto NOT_CHECKED;

    if ( ! fileexists("file_id.diz") ) {
     debuglog("Unzipping file_id.diz using unzip");
     sprintf(target, "/bin/unzip -qqjnpC %s file_id.diz > file_id.diz", locations.filename);
     system(target);
    }

    debuglog("Reading filecount from diz");
    raceI.total_files = read_diz("file_id.diz");

    if ( ! raceI.total_files ) { raceI.total_files = 1; unlink("file_id.diz"); }
    raceI.missing_files = raceI.total_files;

    debuglog("Performing standard race operations");

    writerace(&locations, &raceI, argv[3], 1);
    readrace(&locations, &raceI, userI, groupI);
    if ( raceI.missing_files < 0 ) { raceI.total_files -= raceI.missing_files; raceI.missing_files = raceI.write_log = 0; }
    if ( raceI.total_files ) buffer_progress_bar(&raceI);
    sortstats(&raceI, userI, groupI);
    showstats(&raceI, userI, groupI);
    read_write_leader(&locations, &raceI, userI[userI[0]->pos]);

    debuglog("Writing to glftpd.log");
    update_zip();
    race_zip();
    newleader_zip();

    if ( raceI.missing_files > 0 ) goto INCOMPLETE;

    debuglog("Release is complete");
    complete_bar = zip_completebar;
    debuglog("Removing previous complete inidcator");
    removecomplete();
    debuglog("Creating .message file");
    complete(zip_completetype);
    debuglog("Creating complete indicator");
    createstatusbar( convert(&raceI, userI, groupI, complete_bar) );
    debuglog("Writing stats to glftpd.log");
    complete_zip();
    writetop(zip_completetype, "STATS");

    #if ( enabled_complete_script )
     sprintf( target, complete_script " %s", locations.filename );
     system( target );
    #endif
    goto CHECKED;

SFV:
   debuglog("Performing checks on sfv");
   if ( data_exists(&locations, locations.sfv) ) {
    debuglog("Checking if new sfv is better than old");
    readsfv(&locations, &raceI, 0, 1);
    cnt = raceI.total_files - raceI.missing_files; 
    raceI.missing_files = raceI.total_files = 0; 
    readsfv_ffile(locations.filename, raceI.file_size);
    if ( (raceI.total_files - raceI.missing_files) &&  ! cnt ) {
     strcpy(raceI.error_msg, "SFV does not match with files!");
     goto ERROR;
    }
    raceI.total_files = raceI.missing_files = 0;
   }

   debuglog("Parsing sfv for data");
   copysfv(&locations, locations.filename, locations.sfv, raceI.file_size);

   #if ( ! enabled_sfvfirst )
    if ( data_exists(&locations, locations.race) ) {
     debuglog("Testing integrity of untested files");
     testfiles(&locations, &raceI);
    }
   #endif

   debuglog("Reading current sfv");
   readsfv(&locations, &raceI, enabled_create_missing_files, 0);

   if ( ! raceI.total_files ) {
    sprintf(raceI.error_msg, "SFV-file: BAD!");
    goto ERROR;
   }

   printf( zipscript_sfv_ok );
   if ( data_exists(&locations, locations.race) ) {
    debuglog("Reading race stats");
    readrace(&locations, &raceI, userI, groupI);
    debuglog("Sorting race stats");
    sortstats(&raceI, userI, groupI);
   }
   buffer_progress_bar(&raceI);

   debuglog("Removing complete indicator");
   removecomplete();

  switch( raceI.release_type ) {
   case 1:
    sfv_msg = rar_sfv;
    break;
   case 2:
    sfv_msg = other_sfv;
    break;
   case 3:
    sfv_msg = mp3_sfv;
  }

  if ( raceI.write_log = matchpath(sfv_dirs, locations.path) ) raceI.write_log = 1 - matchpath(group_dirs, locations.path);

  if ( raceI.missing_files ) {
   writelog(convert(&raceI, userI, groupI, sfv_msg), "SFV");
   goto INCOMPLETE;
  }

  if ( raceI.release_type == 3 ) get_mp3_info(findfileext(".mp3"));
  debuglog("Release is complete");
  goto SFV_COMPLETE;


ACCEPTED_EXTENSIONS:
  debuglog("File in allowed list");
  printf( zipscript_any_ok );
  goto NOT_CHECKED;

INCOMPLETE:
  debuglog("Release is still incomplete");
  if ( raceI.total_files ) create_incomplete();
  move_progress_bar(0, &raceI);

CHECKED:
  debuglog("File check succesful");
  if ( raceI.missing_files < 0 ) {
   raceI.total_files = - raceI.missing_files; raceI.missing_files = 0;
   printf( convert(&raceI, userI, groupI, zipscript_footer_unknown) );
  } else {
   printf( convert(&raceI, userI, groupI, zipscript_footer_ok) );
  }
  goto END;

NOT_CHECKED:
  debuglog("File was not checked");
  printf( convert(&raceI, userI, groupI, zipscript_footer_skip) );
  goto END;

ERROR:
  debuglog("Abort with error");
  writerace(&locations, &raceI, argv[3], F_BAD);
  printf( convert(&raceI, userI, groupI, zipscript_footer_error) );
  ERROR_CODE = 2;

END:
  #if ( enabled_accept_script )
   if ( ! ERROR_CODE ) {
    sprintf( target, accept_script " %s", locations.filename );
    system( target );
   }
  #endif
  debuglog("Cleaning memory");
  disconnect_mysql();

  free(target);
  free(fileext);
  free(locations.link_source);
  free(raceI.release_name);
  free(locations.race);
  free(locations.sfv);
  free(locations.leader);

  #if ( enabled_benchmark ) 
   gettimeofday(&bstop, (struct timezone *)0 );
   printf("Checks completed in %0.6f seconds\n", ((bstop.tv_sec - bstart.tv_sec) + (bstop.tv_usec - bstart.tv_usec) / 1000000.));
  #endif

  exit(ERROR_CODE);
}

/* NEAT CODE EHH? */
