/* CONFIG FILE */
#define KEY		0x0000DEAD // IPC KEY

// IMPORTANT LOCATIONS

#define glftpdroot	"/glftpd/"
#define glftpdlog	"/ftp-data/logs/glftpd.log"
#define zipdatadir	"/ftp-data/zipscript/"
#define userspath	"/ftp-data/users/"

// LOCATIONS
#define group_dirs	"/site/groups/"
#define zip_dirs	"/site/incoming/0day/"
#define sfv_dirs	"/site/incoming/mp3/ /site/incoming/games/ /site/incoming/apps/ /site/incoming/musicvideos/"
#define nocheck_dirs	"/site/private/"

// SYMLINK CLEANUP
#define cleanupdirs	"/site/incoming/games/ /site/incoming/apps/ /site/incoming/0day/%Y-%m-%d/ /site/incoming/mp3/%Y-%m-%d/"
/*
 %Y = year (four digits)
 %y = year (two digits)
 %m = month 
 %d = day
 ... see man date for more help
      !!! If you use cleanup + daydirs - crontab it to run on last minute of the day for best results !!!
 */

// SYMLINK LOCATIONS
#define mp3_genredir	"/site/incoming/MP3.by.genre/"
#define mp3_artistdir	"/site/incoming/MP3.by.artist/"
#define mp3_yeardir	"/site/incoming/MP3.by.year/"

#define sitename		"dS"

#define program_uid		10   /* Change effective uid to n (Do not use 0 here - security risk) */
#define program_gid		200  /* Change effective gid to n */

#define sql_user		"dServer"
#define sql_pass		"dServer"  
#define sql_host		"212.146.42.251"
#define sql_db			"reldata"

#define min_newleader_files	1    /* Do not show newleader msg, if release is smaller than n files */
#define min_update_files	1    /* Do not show UPDATE if release has fewer than N files */
#define min_halfway_files	10   /* Do not show halfway msg, if release is smaller than n files */

#define max_users_in_top	7    /* Number of users to show in stats */
#define max_groups_in_top	7    /* Number of groups to show in stats */

#define excludenonmp3dirs	1    /* Allow all kinds of mp3s in non mp3dirs */
#define status_bar_type		1    /* Status bar is directory (0 = file, 1 = directory) */
#define incompleteislink	1    /* Incomplete pointer is link */

#define mp3_completetype	3
#define rar_completetype	3
#define other_completetype	3
#define zip_completetype	0    /* Defines how stats are shown:
                                               0 = One line. (Use %T & %t cookies in completemessages to show race stats)
                                               1 = Two lines. 1. line = completemsg. 2. line = user & group top.
                                               2 = Three lines. 1. line = completemsg. 2. line = user top. 3. line = group top.
                                               3 = N lines. 1. line = completemsg. Lines after that are for user & group top. */

/* BANS AND ALLOWED FILES */
#define allowed_rates	"160,192"			/* Only these rates are allowed */
#define allowed_years	"2000,2001"			/* Only these years are allowed */
#define banned_genres	"Christian Rap,Christian Rock"	/* These genres are banned (see mp3.h for genre list) */
#define allowed_types	"jpg,avi,mpg,cue,m3u,nfo"	/* These filetypes are allowed  */
#define ignored_types	",jpg,cue,m3u,nfo,sfv"		/* Do not count these files as missing if in sfv */

/* COMPILE ON/OFF */ 
#define enabled_benchmark		0
#define enabled_sfvfirst		0
#define enabled_debug			0
#define enabled_display_top		1 
#define enabled_write_message		1 
#define enabled_suid			1 
#define enabled_create_missing_files	1 
#define enabled_read_mp3info 		1
#define enabled_create_m3u		0
#define enabled_accept_script		0
#define enabled_complete_script		0

#define enabled_mp3_genredir	1
#define enabled_mp3_yeardir	1
#define enabled_mp3_artistdir	1

#define enabled_allowed_rates	1
#define enabled_allowed_years	1
#define enabled_banned_genres	1

#define enabled_pre_user_top	1
#define enabled_pre_group_top	1
#define enabled_user_top	1
#define enabled_group_top	1
#define enabled_user_info	1
#define enabled_group_info	1
#define enabled_fastestfile	1
#define enabled_slowestfile	1
#define enabled_racersmsg	1
#define enabled_includezip	1

#define enabled_mp3_race	1
#define enabled_mp3_sfv		1
#define enabled_mp3_update	1
#define enabled_mp3_halfway	1
#define enabled_mp3_newleader	1
#define enabled_mp3_complete	1

#define enabled_sfv_race	1
#define enabled_sfv_sfv		1
#define enabled_sfv_update	1
#define enabled_sfv_halfway	1
#define enabled_sfv_newleader	1
#define enabled_sfv_complete	1

#define enabled_zip_race	1
#define enabled_zip_update	1
#define enabled_zip_newleader	1
#define enabled_zip_complete	1


// ANNOUNCEMENTS VARIABLES
#define pre_user_top	"UserTop: " // If completetype 1-3 this variable is used.
#define pre_group_top	" GroupTop: "
#define user_top	"%n. %B%u%B/%-10g [%.1mM/%fF/%.1p%%/%.0sKB/s]"
#define user_info	"%B%u%B/%g [%.1mM/%fF/%.1p%%/%.0sKB/s]"
#define group_top	"%n. %B%g%B [%.1mM/%fF/%.1p%%/%.0sKB/s]"
#define group_info	"%B%g%B [%.1mM/%fF/%.1p%%/%.0sKB/s]"
#define fastestfile	"Fastest upload by %B%u%B/%g at %B%.0F%BKB/S."
#define slowestfile	"Slowest upload by %B%u%B/%g at %B%.0S%BKB/S."
#define racersmsg	"%B%u%B(%g)"
#define includezip	"/bin/zipscript-awk/ds.nfo" // Include this file in every zip

#define mp3_race	"%B%U%B is racing [ %R ] on %r @ %B%.0S%BkB/s."
#define mp3_sfv		"Got SFV for %r. Expecting %B%f%BF."
#define mp3_update	"Got MP3 info for %r. Expecting %B%f%BF of %B%w%B from %B%Y%B."
#define mp3_halfway	"%r is in halfway. Leading uploader is %C0. Leading group is %c0."
#define mp3_newleader	"%C0 takes the lead in %r!"
#define mp3_complete	"%r [ %B%.0m%BmB in %B%f%BF at %B%.0A%BkB/s - %d ] was completed by %B%u%B racer(s) from %B%g%B group(s). %l %L"

#define rar_race	"%B%U%B is racing [ %R ] on %r @ %B%.0S%BkB/s."
#define rar_sfv		"Got SFV for %r. Expecting %B%f%BF."
#define rar_update	"%B%U%B/%G was the first to upload file in %r. Expecting %B%.1e%BmB."
#define rar_halfway	"%r is in halfway. Leading uploader is %C0. Leading group is %c0."
#define rar_newleader	"%C0 takes the lead in %r!"
#define rar_complete	"%r [ %B%.0m%BmB in %B%f%BF at %B%.0A%BkB/s - %d ] was completed by %B%u%B racer(s) from %B%g%B group(s). Compression method: m%B%Z%B. %l %L"

#define other_race	"%B%U%B is racing [ %R ] on %r @ %B%.0S%BkB/s."
#define other_sfv	"Got SFV for %r. Expecting %B%f%BF."
#define other_update	"%B%U%B/%G was the first to upload file in %r. Expecting %B%.1e%BmB."
#define other_halfway	"%r is in halfway. Leading uploader is %C0. Leading group is %c0."
#define other_newleader	"%C0 takes the lead in %r!"
#define other_complete	"%r [ %B%.0m%BmB in %B%f%BF at %B%.0A%BkB/s - %d ] was completed by %B%u%B racer(s) from %B%g%B group(s). %l %L"

#define zip_race	"%B%U%B is racing [ %R ] on %r @ %B%.0S%bkB/s."
#define zip_update	"Got DiZ for %r. Expecting %B%.1e%BmB in %B%f%BF"
#define zip_newleader	"%C0 takes the lead in %r!"
#define zip_complete	"%r [ %B%.0m%BmB in %B%f%BF at %B%.0A%BkB/s - %d ] was completed by %B%u%B racer(s) from %B%g%B group(s). %l %L Lucky7: %T"

#define stats_line	"%r: %B%F%B of %B%f%B files uploaded by %B%u%B racer(s) from %B%g%B group(s). Leading uploader: %C0."

#define incompletemsg	"%B%U%B/%G deletes file from %r. Release is now %Bincomplete%B!"

/* Output variables */

#define message_header		""
#define message_user_header	"\n                           U S E R T O P\n+--------------------------------------------------------------------+\n"
#define message_user_body	"%3n %-34U %7.1mM %3fF %5.1p%% %5.0sKBs\n"
#define message_user_footer	"+--------------------------------------------------------------------+\n%3u Total %36.1mM %3fF 100.0%% %5.0sKBs\n"

#define message_group_header	"\n\n                          G R O U P T O P\n+--------------------------------------------------------------------+\n"
#define message_group_body	"%3n %-34g %7.1mM %3fF %5.1p%% %5.0sKBs\n"
#define message_group_footer	"+--------------------------------------------------------------------+\n%3g Total %36.1mM %3fF 100.0%% %5.0sKBs\n"

#define message_mp3 		"\n\n                            I D 3 - T A G\n+--------------------------------------------------------------------+\n  Artist: %x\n  Album : %W\n  Genre : %-34w Rate: %Xkbit/sec\n  Tracks: %-34f Year: %Y\n+--------------------------------------------------------------------+\n"
#define message_footer		""

#define mp3_completebar		"[dS] - ( %.0mM %fF - COMPLETE - %w %Y ) - [dS]"
#define rar_completebar		"[dS] - ( %.0mM %fF - COMPLETE ) - [dS]"
#define other_completebar	"[dS] - ( %.0mM %fF - COMPLETE ) - [dS]"
#define zip_completebar		"[dS] - ( %.0mM %fF - COMPLETE ) - [dS]"
#define del_completebar		"\\[dS] - \\( .*F - COMPLETE.*) - \\[dS]"

#define complete_script		"/bin/nfo_copy.sh"
#define accept_script		"/bin/imdb_parse.sh"

#define incomplete_cd_indicator	"../../[iNCoMPLETe]-[%0]-%1"
#define incomplete_indicator	"../[iNCoMPLETe]-%0"

#define progressmeter		"[%V] - %3.0p%% Complete - [dS]"
#define del_progressmeter	"\\[.*] - ...% Complete - \\[dS]"

#define zipscript_header	 ".----=== D1 C++ ZipScript ===--=== (C) 2001 ===----.\n"
#define zipscript_sfv_ok	 "| + SFV-file: oK!                                  |\n"
#define zipscript_any_ok	 "| + File: ok!                                      |\n"
#define zipscript_SFV_ok	 "| + CRC-Check: oK!                                 |\n"
#define zipscript_SFV_skip	 "| + CRC-Check: SKIPPED!                            |\n"
#define zipscript_zip_ok	 "| + ZiP integrity: oK!                             |\n"
#define realtime_mp3_info	 "+-=[ID3tag]=------------------------===------------+\n| Title  : %-39y |\n| Artist : %-39x |\n| Album  : %-39W |\n| Genre  : %-39w |\n| Year   : %-39Y |\n"
#define realtime_user_header	 "+-=[UserTop]=-------------------===----------------+\n"
#define realtime_user_body	 "| %2n. %-17u %8.1mmB %2fF %7.0skB/s |\n"
#define realtime_user_footer	 ""
#define realtime_group_header	 "+-=[GroupTop]=--------------------===--------------+\n"
#define realtime_group_body	 "| %2n. %-17g %8.1mmB %2fF %7.0skB/s |\n"
#define realtime_group_footer	 ""
#define zipscript_footer_unknown "`-[ - NO - SFV - ]------------------------[%2F/??]--'\n"
#define zipscript_footer_ok	 "`-[%V]------------------------[%2F/%-2f]--'\n"
#define zipscript_footer_error	 "| - %-46v |\n`-----------------------------------========-------'\n"
#define zipscript_footer_skip	 "`--------------------------------=====-------------'\n"

#define version		"0.5.3"

/* CONFIG FILE */
