#include <stdio.h>
#include <regex.h>
/*
 Dark0n3's c-zipscript functions file.
 Do NOT edit if you dont know what you're doing
*/

#ifndef PATH_MAX
#include <sys/syslimits.h>
#endif

struct ONLINE
{
  char   tagline[64];
  char   username[24];
  char   status[256];
  char   host[256];
  char   currentdir[256];
  long   groupid;
  time_t login_time;
  struct timeval tstart;
  unsigned long bytes_xfer;
  pid_t  procid;
};

static struct ONLINE *online;

struct dirent **dirlist;
int             direntries;


/* If debug mode is enabled, this function is defined.
   Please note that using debug mode will slow program
   a bit. Turn debug mode on only if you encounter 
   crashes                                            */

#if ( enabled_debug )
void debuglog(char *instr) {
 FILE	*file;
 time_t timenow;
          
 timenow = time( NULL );
 fprintf(file = fopen(".debug", "a+"), "%.24s - %s\n", c_time(&timenow), instr);
 fclose(file);
}
#else
 #define debuglog(x)
#endif



/* BSD does not know O_SYNC, it has O_FSYNC instead */
#ifndef O_SYNC
 #define O_SYNC O_FSYNC
#endif



/* Searches directory for a filename with certain extension */
char* findfileext(char *fileext) { 
 int n, k;
 
 n = direntries;
 while(n--) if (( k = strlen(dirlist[n]->d_name)) > 3 )
  if ( strcasecmp(dirlist[n]->d_name + k - 4, fileext) == 0 ) return dirlist[n]->d_name;
 return NULL;
}



/* Creates empty file */
#define createzerofile(filename) fclose(fopen(filename, "a+"))



/* Creates status bar file */
#if ( status_bar_type == 0 )
 #define createstatusbar(bardata) createzerofile(bardata);
#endif
#if ( status_bar_type == 1 )
 #define createstatusbar(bardata) mkdir(bardata, 0777);
#endif
#if ( status_bar_type == 2 )
 #define createstatusbar(bardata)
#endif


/* Read directory to buffer */
#define cachedir() direntries = scandir(".", &dirlist, 0, 0);


/* Lowers all uppercase chars from string */
void strtolower(char *s) {
 int n = 0;
 while ( (s[n] = tolower(s[n])) ) n++;
}


/* Compares fileext on known rar extensions */
short israr (char *fileext) {
 if ( ! fileext[3] ) {
  if ( ! strcmp(fileext, "rar")) return 1;
  if ( (fileext[0] == 'r' || fileext[0] == 's' || isdigit(fileext[0]) ) && isdigit(fileext[1]) && isdigit(fileext[2]) ) return 1;
 }
 return 0;
}

 

/* Creates 15char progressmeter and returns pointer to it */
void buffer_progress_bar(struct VARS *raceI) {
 int n;
 raceI->progress_bar[14] = 0;
 for ( n = 0 ; n < (raceI->total_files - raceI->missing_files) * 14 / raceI->total_files ; n++) raceI->progress_bar[n] = '#';
 for ( ; n < 14 ; n++) raceI->progress_bar[n] = ':';
}


/* Renames / Deletes / Creates release status indicator */
void move_progress_bar(short delete, struct VARS *raceI) {
 char 		*bar;
 int		n;
 regex_t        preg;
 regmatch_t     pmatch[1];

 if ( ! raceI->total_files ) return;

 regcomp( &preg, del_progressmeter, REG_NEWLINE|REG_EXTENDED );
 bar = convert(raceI, userI, groupI, progressmeter);

 n = direntries;
 while(n--) {
  if ( regexec( &preg, dirlist[n]->d_name, 1, pmatch, 0) == 0 ) {
   if ( ! (int)pmatch[0].rm_so && (int)pmatch[0].rm_eo == strlen(dirlist[n]->d_name) ) {
    if ( ! delete ) rename(dirlist[n]->d_name, bar);
               else remove(dirlist[n]->d_name);
    return;
   }
  }
 }
 if ( ! delete ) createstatusbar(bar);
}



/* Case insensitive filesearch */
short findfile(char *filename) {
 int n;

 n = direntries;
 while(n--) if ( ! strcasecmp(dirlist[n]->d_name, filename)) return 1;
 return 0;
}


/* Removes complete bar and message file */
void removecomplete() {
 int		n;
 regex_t	preg;
 regmatch_t	pmatch[1];

 unlink(".message");
 regcomp( &preg, del_completebar, REG_NEWLINE|REG_EXTENDED );
 n = direntries;
 while(n--) {
  if( regexec( &preg, dirlist[n]->d_name, 1, pmatch, 0 ) == 0 ) {
   if ( ! (int)pmatch[0].rm_so && (int)pmatch[0].rm_eo == strlen(dirlist[n]->d_name) ) remove(dirlist[n]->d_name);
  }
 }
}



/* COMPARE PATH ON INSTR */
short matchpath(char *instr, char *path) {
 int cnt, pos, k;

 k = strlen(instr);
 for ( cnt = pos = 0 ; cnt <= k ; cnt++ ) 
  if ( instr[cnt] == ' ' || instr[cnt] == 0 ) {
   if ( ! strncmp(instr + cnt - pos, path, pos - 1) ) { return 1; }
   pos = 0;
  } else pos++;
 return 0;
}



/* RETURN 1 IF INSTR HAS ELEMENT THAT MATCHES WITH SEARCHSTR */  
short strcomp(char *instr, char *searchstr) {
 int	cnt,
	pos,
	k, 
	l;

 k = strlen(searchstr);
 l = strlen(instr) + 1;
 for ( cnt = pos = 0 ; cnt < l ; cnt++ )
  if ( instr[cnt] == ',' || ! instr[cnt] ) {
   if ( k == pos && ! strncasecmp(instr + cnt - pos, searchstr, pos) ) { return 1; }
   pos = 0;
 } else pos++;
 return 0;
}


/* Checks if file exists */
short fileexists(char *filename) {
 if ( close(open(filename, O_RDONLY)) == -1 ) return 0;
 return 1;
}


/* Create symbolic link */
void createlink(char *factor1, char *factor2, char *source, char *ltarget) {
 char target[ PATH_MAX ];
  
 sprintf(target, "%s/%s/", factor1, factor2);
 mkdir(target, 0777); 
 strcat(target, ltarget);
 symlink(source, target);
}



void readsfv_ffile(char *filename, long buf_bytes ) {
 int    fd,
        line_start = 0,
        index_start,
        ext_start,
        n;
 char   *buf,
        *fname;
     
 fd  = open( filename, O_SYNC );
 buf = malloc( buf_bytes );
 read(fd, buf, buf_bytes);
 close( fd );
  
 for ( n = 0 ; n < buf_bytes; n++ ) {
  if ( buf[n] == '\n' || n == buf_bytes ) {
   index_start = n - line_start;
   if ( buf[line_start] != ';' ) {
    while ( buf[index_start + line_start] != ' ' && index_start-- );
    if ( index_start > 0 ) {
     buf[index_start + line_start] = 0;
     fname = buf + line_start;
     ext_start = index_start;
     while ( (fname[ext_start] = tolower(fname[ext_start])) != '.' && ext_start-- ) ;
     if ( ext_start <= 0 ) ext_start = index_start; else ext_start++;
        
     index_start++;
     if ( ! strcomp(ignored_types, fname + ext_start) ) {
      if ( findfile(fname) ) raceI.missing_files--;
     }
    }
   }
   line_start = n + 1;
  }
 }
 raceI.missing_files += raceI.total_files;
}


void get_rar_info(char *filename) {
 FILE	*file;

 file = fopen(filename, "r");
 fseek(file, 45, SEEK_CUR);
 fread(&raceI.compression_method, 1, 1, file);
 fclose(file);
}
