#!/bin/bash

# PSXC IMDB INFO v0.1 #
#######################

#######
#CONFIG

### These variables is not very interesting. Unless you use a somewhat ###
### modified version of glftpd, these will be okay with little or no   ###
### modification.                                                      ###

# this path is usually sufficient for chrooted env.
PATHCHROOTED="/bin"

# PATH variable. Make sure you have all needed executables.
PATH=$GLROOT/bin:/bin:/usr/bin:/usr/local/bin:/sbin:/usr/sbin:/usr/local/sbin

# This dir must ONLY exist outside glftpd's chrooted/jailed
# environment, else the script will fail.
TESTDIR=/home

# your glftpd root path
GLROOT=/glftpd

# logfile used - chrooted version.
IMDBLOGCHROOTED=/ftp-data/logs/psxc-imdb.log

# path to logfile for imdb lookups
IMDBLOG=$GLROOT$IMDBLOGCHROOTED

# location of glftpd.log.
GLLOG=$GLROOT/ftp-data/logs/glftpd.log

# a temp file used to fetch imdb info
TMPFILE=$GLROOT/ftp-data/logs/psxc-imdb.tmp

# bold character used for bot. Use "" to disable.
BOLD=""

# Date format used by bot. Edit according to your OS (FBSD/Linux is default)
DATE=`date +"%a %b %d %H:%M:%S %Y"`

### The following will affect output of the script. First the variables ###
### for the bot output.                                                 ###

# should the script write to glftpd.log (ie, bot support)? Use "" to
# disable.
USEBOT="YES"
#USEBOT=""

# Trigger for bot. Most bots should be able to show the info with the UPDATE
# trigger. If you like to modify your bot for special purposes, edit to
# whatever catches your fancy.
TRIGGER="UPDATE:"
#TRIGGER="IMDB:"

# This line will be written prior to whatever IMDB info found. Use "" to disable.
# Put RELEASENAME somewhere if you'd like to announce the name of the release.
BOTHEAD="IMDb has some interesting facts on RELEASENAME:"
#BOTHEAD=""

# Should the short version of user comments be shown in channel? "" disables
SHOWCOMMENTSHORT="YES"
#SHOWCOMMENTSHORT=""

# Showing both Tagline and Plot Outline may be too much to your liking. This variable
# will show either Tagline or Plot Outline if either or both are found. Use "TAG" if
# you prefer Tagline over Plot Outline, "PLOT" if you prefer Plot Outline over Tagline,
# "NONE" to disable both, or "" to show both.
#TAGPLOT=""      # Show both
#TAGPLOT="TAG"   # Show one, tag prefered
TAGPLOT="PLOT"  # Show one, plot prefered
#TAGPLOT="NONE"  # Show none

### The next variables will affect output to a file in the release-dir. The ###
### idea here is to show this file when users enters the dir, thus removing ###
### the need to view the .nfo and looking up info on IMDb themselves. Check ###
### the README for more info.                                               ###

# The file to write imdb info to in the movie dir. Use "" to disable.
DOTIMDB=".imdb"
#DOTIMDB=""

# Maximum number of cast members listed.
CASTNUM=10 # max number of lines showing Credited Cast
#CASTNUM=99

# Should user comment be shown in DOTIMDB? "" disables. This is in some cases a
# lot of info - feel your way on this one.
SHOWCOMMENT="YES"
#SHOWCOMMENT=""

# Maximum width for text written to DOTIMDB. This controls how many chars wide the
# text should be before word-wrapping it.
IMDBWIDTH=77

# head and tail written to DOTIMDB. Take notice of IMDBWITH - this should not be
# wider than that. This output will be written as "echo -e" which means you can use
# control characters like \n, thus the head and tail can stretch over 1 or more lines.
IMDBHEAD="============================ PSXC IMDB INFO v0.1 ============================\n"
IMDBTAIL="\n============================ PSXC IMDB INFO v0.1 ============================"

### The following is a BETA feature, and has really nothing to do with IMDb info ###
### at all. It's a quick and dirty way to extract release dates from the .nfo    ###
### files, and putting that info in a separate file. It works like the .imdb     ###
### file (above) and is supposed to be listed on entering the dir.               ###

# Use the beta date-extraction? Enter a name here, or "" to disable.
DOTDATE=".date"
#DOTDATE=""


# END OF CONFIG
##########################################################################################

if [ ! -d $TESTDIR ]; then

##### CHROOTED PART #####
 PATH=$PATHCHROOTED
 IMDBLOG=$IMDBLOGCHROOTED
 FILENAME="$@"
 case $FILENAME in
  *.[nN][fF][oO])
   if [ ! -z "$DOTDATE" ]; then
    grep [Dd][Aa][Tt][Ee] $FILENAME | tr -c '/a-zA-Z0-9:. -/\n' ' ' | tr -s ' ' >> $DOTDATE
   fi
   IMDBURL="`grep [Ii][Mm][Dd][Bb] $FILENAME | tr ' ' '\n' | sed -n /[hH][tT][tT][pP]:[/][/].*[.][iI][mM][dD][bB].*[?].[0-9]/p | head -n 1`"
   if [ ! -z "$IMDBURL" ]; then
    echo "$IMDBURL""|""$PWD" >> $IMDBLOG
   fi
  ;;
 esac
 exit 0

else
##### MAIN PART #####
 if [ ! -e $IMDBLOG ]; then
  exit 0
 fi
 for IMDBLINE in `cat $IMDBLOG`; do
  IMDBURL=`echo $IMDBLINE | cut -d "|" -f 1`
  IMDBLNK="`echo $IMDBLINE | cut -d "|" -f 2`"
  if [ -d $GLROOT$IMDBLNK ]; then
   IMDBDIR="`basename $IMDBLNK`"
   IMDBLKL="$IMDBLNK"
   IMDBLNK="$GLROOT$IMDBLNK/$DOTIMDB"
  else
   DOTIMDB=""
  fi
  lynx -dump -nolist -width=1000 -hiddenlinks=ignore $IMDBURL > $TMPFILE
  if [ ! "$?" = "1" ]; then
   TITLE="`cat $TMPFILE | grep "^[a-zA-z0-9]" | head -1`"
   if [ "$TITLE" = "IMDb title search" ] || [ -z "$TITLE" ]; then
    exit 0
   fi
   GENRE=`cat $TMPFILE | grep "Genre:" | sed "s/(more)//" | sed "s/   //" | sed "s/Genre:/Genre........:/" | sed s/\"/_/g | head -1`
   TAGLINE=`cat $TMPFILE | grep "Tagline:" | sed "s/(more)//" | sed "s/   //" | sed "s/([Mm][Oo][Rr][Ee])//" | sed "s/Tagline:/Tagline......:/" | sed s/\"/_/g | head -1`
   RATING=`cat $TMPFILE | grep "User\ Rating:" | sed "s/   //" | sed "s/ [Vv][Oo][Tt][Ee] [Hh][Ee][Rr][Ee]//" | sed "s/User Rating:/User Rating..:/" | sed s/\"/_/g | head -1`
   COUNTRY=`cat $TMPFILE | grep "Country:" | sed "s/   //" | sed "s/Country:/Country......:/" | sed s/\"/_/g | head -1`
   LANGUAGE=`cat $TMPFILE | grep "Language:" | sed "s/   //" | sed "s/Language:/Language.....:/" | sed s/\"/_/g | head -1`
   PLOT=`cat $TMPFILE | grep "Plot\ [OS][u][tm][lm][ia][nr][ey]:" | sed "s/   //" | sed "s/ ([Vv][Ii][Ee][Ww] [Tt][Rr][Aa][Ii][Ll][Ee][Rr])//" | sed "s/([Mm][Oo][Rr][Ee])//" | sed "s/Plot [OS][u][tm][lm][ia][nr][ey][:]/Plot Outline.:/" | sed s/\"/_/g | head -1`
   CERT=`cat $TMPFILE | grep "Certification:" | sed "s/   //" | sed s/\"/_/g | head -1`
   CAST=`cat $TMPFILE | grep "\ \.\.\.\.\ " | sed s/\"/_/g | head -$CASTNUM`
   COMMENTSHORT=`cat $TMPFILE | grep "User Comments:" | head -1 | sed "s/   //" | sed "s/([Mm][Oo][Rr][Ee])//" | sed s/\"/_/g`
   COMMENT=`cat $TMPFILE | awk '/User Comments:$/, /Check for other user comments.$/' | sed s/\"/_/g`
   RUNTIME=`cat $TMPFILE | grep "Runtime:" |  sed "s/   //" | sed "s/Runtime:/Runtime......:/" | sed s/\"/_/g | head -1`
   DIRECTOR=`cat $TMPFILE | awk '/Directed by$/, /Writing credits$/' | grep -v "Directed by" | grep -v "Writing Credits" | sed "s/   //" | head -1 | sed s/\"/_/g`
   if [ ! -z "$IMDBHEAD" ]; then
    BOTHEAD=`echo $BOTHEAD | sed s/RELEASENAME/$BOLD$IMDBDIR$BOLD/`
   fi
   if [ ! -z "$DIRECTOR" ]; then
    DIRECTOR="Directed by..: $DIRECTOR"
   fi
   if [ ! -z "$USEBOT" ]; then
    HEADTMP="Title........: $BOLD$TITLE$BOLD"
    if [ ! -z "$COUNTRY" ]; then
     HEADTMP="$HEADTMP / $COUNTRY"
    fi
    if [ ! -z "$LANGUAGE" ]; then
     HEADTMP="$HEADTMP / $BOLD$LANGUAGE$BOLD"
    fi
    HEAD=`echo "$HEADTMP" | sed "s/Country......: //" | sed "s/Language.....: //"`
    if [ ! -z "$BOTHEAD" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$BOTHEAD\"" >> $GLLOG
    fi
    if [ ! -z "$HEAD" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$HEAD\"" >> $GLLOG
    fi
    if [ ! -z "$DIRECTOR" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$DIRECTOR\"" >> $GLLOG
    fi
    if [ ! -z "$GENRE" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$GENRE\"" >> $GLLOG
    fi
    if [ ! -z "$RATING" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$RATING\"" >> $GLLOG
    fi
    if [ ! -z "$RUNTIME" ]; then  
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$RUNTIME\"" >> $GLLOG
    fi
    if [ ! -z "$TAGLINE" ] && [ ! -z "$PLOT" ]; then
     if [ "$TAGPLOT" = "TAG" ]; then
      echo "$DATE $TRIGGER \"$IMDBLKL\" \"$TAGLINE\"" >> $GLLOG
     elif [ "$TAGPLOT" = "PLOT" ]; then
      echo "$DATE $TRIGGER \"$IMDBLKL\" \"$PLOT\"" >> $GLLOG
     fi
    elif [ -z "$TAGPLOT" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$PLOT\"" >> $GLLOG
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$TAGLINE\"" >> $GLLOG
    elif [ ! -z "$TAGLINE" ] && [ ! "$TAGPLOT" = "NONE" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$TAGLINE\"" >> $GLLOG
    elif [ ! -z "$PLOT" ] && [ ! "$TAGPLOT" = "NONE" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$PLOT\"" >> $GLLOG
    fi
    if [ ! -z "$SHOWCOMMENTSHORT" ] && [ ! "$COMMENTSHORT" = "User Comments:" ]; then
     echo "$DATE $TRIGGER \"$IMDBLKL\" \"$COMMENTSHORT\"" >> $GLLOG
    fi
   fi
   if [ ! -z "$DOTIMDB" ]; then
    echo -e "$IMDBHEAD" >> $IMDBLNK
    OWNER=`ls -1nl $GLROOT$IMDBLKL | tail -1 | { read junk junk owner group junk; echo $owner:$group; };`
    chown -f $OWNER $IMDBLNK
    echo "$TITLE" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    echo "-" >> $IMDBLNK
    if [ ! -z "$DIRECTOR" ]; then
     echo "$DIRECTOR" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$GENRE" ]; then
     echo "$GENRE" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$RATING" ]; then
     echo "$RATING" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$TAGLINE" ]; then
     echo "$TAGLINE" | fold -s -w $IMDBWIDTH >> $IMDBLNK
    fi
    echo "-" >> $IMDBLNK
    if [ ! -z "$COUNTRY" ]; then
     echo "$COUNTRY" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$LANGUAGE" ]; then
     echo "$LANGUAGE" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$CERT" ]; then
     echo "$CERT" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$RUNTIME" ]; then
     echo "$RUNTIME" | fold -s -w $IMDBWIDTH | head -1 >> $IMDBLNK
    fi
    if [ ! -z "$CAST" ]; then
     echo "-" >> $IMDBLNK
     echo "Credited Cast:" >> $IMDBLNK
     echo "$CAST" | fold -s -w $IMDBWIDTH >> $IMDBLNK
    fi
    if [ ! -z "$PLOT" ]; then
     echo "-" >> $IMDBLNK
     echo "$PLOT" | fold -s -w $IMDBWIDTH >> $IMDBLNK
    fi
    if [ ! -z "$SHOWCOMMENT" ] && [ ! -z "`echo $COMMENT | grep "^User Comments:" | grep "Check for other user comments.$"`" ]; then
     echo "---" >> $IMDBLNK
     echo "User Comments:" >> $IMDBLNK
     echo "$COMMENT" | grep "^     " | sed "s/     //g" | fold -s -w $IMDBWIDTH >> $IMDBLNK
    fi
    echo -e "$IMDBTAIL" >> $IMDBLNK
   fi
  fi
 done
 rm -f $IMDBLOG
 exit 0
fi

