#!/bin/bash
VER=1.0

##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-hub.id in the same folder as mss-post.sh
# GLROOT="/glftpd"

## Ignore this!
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

## Remove the # from the below line to hard set where mss-hub.conf is.
## Otherwise, it will be read from the same folder as mss-post.sh is in.
# MSSHUBCONFIG=$GLROOT/bin/mss-hub.conf


##################################################################
# READ CONFIG FILE
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="`dirname $0`/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "GLROOT not set. Either create a file called mss-hub.id and add 'GLROOT=/glftpd'"
    echo "or add that line to mss-hub.conf."
    echo "This can also mean I do not have permission to read mss-hub.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  GLROOT=""
fi

if [ -z $MSSHUBCONFIG ]; then
  MSSHUBCONFIG="`dirname $0`/mss-hub.conf"
fi

if [ ! -r $MSSHUBCONFIG ]; then
  echo "Error. Cant not read $MSSHUBCONFIG"
  exit 1
else
  . $MSSHUBCONFIG
fi

if [ -z "$SOURCENAME" ]; then
  IDENTFILE="`dirname $0`/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "SOURCENAME not set. Either create a file called mss-slave.id and add 'SOURCENAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$SOURCENAME" ]; then
      echo "Error. Cant read SOURCENAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -e "$GLETC/mss-automove.db" ]; then
  touch "$GLETC/mss-automove.db"
  chmod 666 "$GLETC/mss-automove.db"
  echo "First time run. Creating file."
  if [ ! -e "$GLETC/mss-automove.db" ]; then
    echo "Error. Couldnt create $GLETC/mss-automove.db - Make sure $GLETC has 777 perms."
    exit 1
  fi
elif [ ! -r "$GLETC/mss-automove.db" ]; then
  echo "Error. Can not write to db file. Tell a siteop to 666 the file."
  exit 1
fi

proc_help() {
  echo "-------------------------------------------------"
  echo "Welcome to the Credits Transfer System $VER      "
  echo "This is the hub server. You can only initiate"
  echo "transfers from the slaves."
  echo "However, you can enable an automatic move of "
  echo "credits at the end of a race on either slave so "
  echo "its all moved back here automatically."
  echo ""
  echo "-------------------------------------------------"
  echo "Usage:"
  echo "site transfer status"
  echo "site transfer automove <slave> <ON/OFF>"
  echo ""
  echo "Current slaves are:"
  echo "-> $SLAVES <-"
  echo "You can also specify 'all' instead of a specific"
  echo "slave, to change them all at once."
  echo ""
  echo "-------------------------------------------------"
}

proc_writeit() {
  for CURSLAVE in $SELECTED_SLAVES; do
    if [ -z "`grep "^$CURSLAVE:$USER:" "$GLETC/mss-automove.db"`" ]; then
      echo "$CURSLAVE:$USER:$ONOFF" >> "$GLETC/mss-automove.db"
    else
      grep -v "$CURSLAVE:$USER:" "$GLETC/mss-automove.db" >> "$GLETC/mss-automove.tmp"
      echo "$CURSLAVE:$USER:$ONOFF" >> "$GLETC/mss-automove.tmp"
      cp -f "$GLETC/mss-automove.tmp" "$GLETC/mss-automove.db"
      rm -f "$GLETC/mss-automove.tmp"
    fi
    echo "$WORD automatic transfer of credits from $CURSLAVE"
  done
}

COMMAND="$1"
SELECTED_SLAVE="$2"
ONOFF="$3"

proc_status() {
  echo "Current status for $USER. Automove credits ON/OFF ?"
  for CURSLAVE in $SLAVES; do
    if [ -z "`grep "$CURSLAVE:$USER:" "$GLETC/mss-automove.db"`" ]; then
      echo "$CURSLAVE = OFF"
    elif [ "`grep "$CURSLAVE:$USER:OFF" "$GLETC/mss-automove.db"`" ]; then
      echo "$CURSLAVE = OFF"
    elif [ "`grep "$CURSLAVE:$USER:ON" "$GLETC/mss-automove.db"`" ]; then
      echo "$CURSLAVE = ON"
    fi
  done
}

proc_set() {

  if [ -z "$COMMAND" ] || [ -z "$SELECTED_SLAVE" ] || [ -z "$ONOFF" ]; then
    proc_help
    exit 0
  fi

  case $ONOFF in
    [oO][nN]) ONOFF="ON"; WORD="Enabling" ;;
    [oO][fF][fF]) ONOFF="OFF"; WORD="Disabling" ;;
    *) proc_help; exit 1 ;;
  esac

  SLAVELIST=" $SLAVES "

  if [ "$SELECTED_SLAVE" != "all" ] && [ "$SELECTED_SLAVE" != "ALL" ]; then
    if [ -z "`echo "$SLAVELIST" | grep -i "\ $SELECTED_SLAVE\ "`" ]; then
      echo "Error. $SELECTED_SLAVE isnt a valid slave."
      proc_help; exit 1
    else
      for CURSLAVE in $SLAVES; do
        if [ "`echo " $CURSLAVE " | grep -i "\ $SELECTED_SLAVE\ "`" ]; then
          SELECTED_SLAVES="$CURSLAVE"
          break
        fi
      done
    fi
  else
    SELECTED_SLAVES="$SLAVES"
  fi

  echo "Selected slave: $SELECTED_SLAVE"
  proc_writeit
}

## Main menu
case $COMMAND in
  [aA][uU][tT][oO][mM][oO][vV][eE]) proc_set ;;
  [sS][tT][aA][tT][uU][sS]) proc_status ;;
  *) proc_help; exit 0 ;;
esac

