#!/bin/bash
VER=1.1

## Remove the # from the below line to hard set where mss-hub.conf is.
## Otherwise, it will be read from the same folder as mss-post.sh is in.
# MSSHUBCONFIG=$GLROOT/bin/mss-hub.conf

##################################################################
# READ CONFIG FILE
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="`dirname $0`/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "GLROOT not set. Either create a file called mss-hub.id and add 'GLROOT=/glftpd'"
    echo "or add that line to mss-hub.conf."
    echo "This can also mean I do not have permission to read mss-hub.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  echo "Error. $GLROOT, defined in mss-hub.id, does not exist. Not trying to run this from inside glftpd, are you?"
  exit 1
fi

if [ -z $MSSHUBCONFIG ]; then
  MSSHUBCONFIG="`dirname $0`/mss-hub.conf"
fi

if [ ! -r $MSSHUBCONFIG ]; then
  echo "Error. Cant not read $MSSHUBCONFIG"
  exit 1
else
  . $MSSHUBCONFIG
fi

if [ "$WAITING_TIME" ]; then
  if [ "$WAITING_TIME" -ge "60" ]; then
    echo "Error. WAITING_TIME should NOT be 60 seconds or more."
    exit 1
  fi
  sleep $WAITING_TIME
fi

## Check list of slaves in up/down file.
if [ ! -e "$REPORTDIR/mss-slavestatus.db" ]; then
  echo "First time run. Creating $REPORTDIR/mss-slavestatus.db"
  echo "**SLAVES=$SLAVES" > $REPORTDIR/mss-slavestatus.db
  chmod 666 $REPORTDIR/mss-slavestatus.db
  for slavename in $SLAVES; do
    echo "$slavename=NoStatus" >> $REPORTDIR/mss-slavestatus.db
  done
else
  if [ "`grep "^\*\*SLAVES\=" $REPORTDIR/mss-slavestatus.db | cut -d '=' -f2-`" != "$SLAVES" ]; then
    echo "Slave list changed. Updating list..."
    grep -v "^\*\*SLAVES\=" $REPORTDIR/mss-slavestatus.db > /tmp/mss-slavestatus.tmp
    echo "**SLAVES=$SLAVES" >> /tmp/mss-slavestatus.tmp
    cat /tmp/mss-slavestatus.tmp | sort > $REPORTDIR/mss-slavestatus.db
    rm -f /tmp/mss-slavestatus.tmp
  fi
fi

## Any slave gone from list? Remove it from file if so.
for rawdata in `grep -v "^\*\*SLAVES\=" $REPORTDIR/mss-slavestatus.db`; do
  slavename="`echo "$rawdata" | cut -d '=' -f1`"
  if [ -z "`echo "$SLAVES" | grep -w "$slavename"`" ]; then
    grep -v "^$slavename\=" $REPORTDIR/mss-slavestatus.db > /tmp/mss-slavestatus.tmp
    cat /tmp/mss-slavestatus.tmp | sort > $REPORTDIR/mss-slavestatus.db
    rm -f /tmp/mss-slavestatus.tmp
  fi
done

## Start check for errors reported.   
if [ "$CHECKERROR" = "TRUE" ]; then
  for slavename in $SLAVES; do
    if [ -e "$REPORTDIR/$slavename.msg" ]; then
      for rawdata in `cat $REPORTDIR/$slavename.msg | tr ' ' '^' | grep "MSSERR:" | cut -d '"' -f2- | tr -d '"'`; do
        errormsg="`echo "$rawdata" | tr '^' ' '`"
        echo `date "+%a %b %e %T %Y"` MSSREP: \"Slave $slavename reports: $errormsg\" >> $GLLOG
      done

      ## Remove this file if CHECKALIVE isnt on. Otherwise, it will do it.
      if [ "$CHECKALIVE" != "TRUE" ]; then
        rm -f $REPORTDIR/$slavename.msg
      fi
    fi
  done
fi

## Start check if slave is even alive.
if [ "$CHECKALIVE" = "TRUE" ]; then
  for slavename in $SLAVES; do
    if [ ! -e "$REPORTDIR/$slavename.msg" ]; then
      if [ ! -e "/tmp/mss-dead-$slavename" ]; then
        if [ "$SEND_ON_FIRST_FAILURE" = "TRUE" ]; then
          echo `date "+%a %b %e %T %Y"` MSSREP: \"Slave $slavename did not report in \(first failure\).\" >> $GLLOG
        fi
        touch /tmp/mss-dead-$slavename

        ## Update up/down file; mss-slavestatus.db
        if [ -z "`grep "^$slavename\=" $REPORTDIR/mss-slavestatus.db`" ]; then
          echo "$slavename=DOWN" >> $REPORTDIR/mss-slavestatus.db
        else
          grep -v "^$slavename\=" $REPORTDIR/mss-slavestatus.db > /tmp/mss-slavestatus.tmp
          echo "$slavename=DOWN" >> /tmp/mss-slavestatus.tmp
          cat /tmp/mss-slavestatus.tmp | sort > $REPORTDIR/mss-slavestatus.db
          rm -f /tmp/mss-slavestatus.tmp
        fi

      else
        if [ ! -e "/tmp/mss-dead2-$slavename" ]; then
          echo `date "+%a %b %e %T %Y"` MSSREP: \"Slave $slavename did not report in \(second failure\).\" >> $GLLOG
          touch /tmp/mss-dead2-$slavename
        else
          echo "Already reported $slavename as dead. Skipping report."
        fi
      fi
    else

      ## Slave isnt dead. Check if theres an "already reported" file and delete it.
      if [ -e "/tmp/mss-dead-$slavename" ]; then
        rm -f /tmp/mss-dead-$slavename
        ALIVE=TRUE
      fi
      if [ -e "/tmp/mss-dead2-$slavename" ]; then
        rm -f /tmp/mss-dead2-$slavename
        ALIVE=TRUE
        SECONDFAILED=TRUE
      fi

      SENDIT="FALSE"
      if [ "$ALIVE" = "TRUE" ] && [ "$SEND_ON_ALIVE" = "TRUE" ]; then
        ## If SEND_ON_FIRST_FAILURE isnt TRUE, we shouldnt announce if we got one fail only...
        if [ "$SEND_ON_FIRST_FAILURE" != "TRUE" ]; then
          if [ "$SECONDFAILED" = "TRUE" ]; then
            SENDIT="TRUE"
          fi
        else
          SENDIT="TRUE"
        fi
        unset SECONDFAILED
      fi

      ## Check if the slave is even in the list. If not, add it.
      if [ -z "`grep "^$slavename\=" $REPORTDIR/mss-slavestatus.db`" ]; then
        echo "$slavename=UP" >> $REPORTDIR/mss-slavestatus.db
      fi

      if [ "$ALIVE" = "TRUE" ]; then
        ## Update up/down file; mss-slavestatus.db
        grep -v "^$slavename\=" $REPORTDIR/mss-slavestatus.db > /tmp/mss-slavestatus.tmp
        echo "$slavename=UP" >> /tmp/mss-slavestatus.tmp
        cat /tmp/mss-slavestatus.tmp | sort > $REPORTDIR/mss-slavestatus.db
        rm -f /tmp/mss-slavestatus.tmp
        unset ALIVE
      fi

      if [ "$SENDIT" = "TRUE" ]; then
        echo `date "+%a %b %e %T %Y"` MSSREP: \"Slave $slavename reports back online!\" >> $GLLOG
      fi

      ## Remove ping file
      rm -f $REPORTDIR/$slavename.msg
    fi
  done
fi

exit 0
