#!/bin/bash
VER=2.19

## Remove the # from the below line to hard set your glftpd root.
## Otherwise, it will be read from mss-slave.id in the same folder
## as mss-core.sh (recomended)
# GLROOT=/glftpd

## Ignore this!
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same place as mss-core.sh (recomended)
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

#--[ GO ]--------------------------------------#

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi
if [ -r "$MSSSLAVECONFIG" ]; then
  . $MSSSLAVECONFIG
else
  echo "MSS error: Config file: $MSSSLAVECONFIG not found or no permissions to read it."
  exit 0
fi

if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    rm -f $LOCKFILE
    exit 0
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      rm -f $LOCKFILE
      exit 0
    fi
  fi
fi

if [ "$1" = "debug" -o "$2" = "debug" -o "$3" = "debug" -o "$4" = "debug" ]; then
  DEBUG=TRUE
fi

## Litte fix
if [ -z "$GL_VERSION" ]; then
  GL_VERSION=1
fi

## Function for outputting to screen and sending error report to hub.
proc_debug() {
  if [ "$DEBUG" = "TRUE" ]; then
    echo "$*"
  fi

  if [ "$REPORTLEVEL" != "0" -a "$REPORTLEVEL" != "" -a "$ERRORLEVEL" != "" ]; then
    if [ "$ERRORLEVEL" -le "$REPORTLEVEL" ]; then
      if [ -d "$REPORTDIR" ]; then
        echo `date "+%a %b %e %T %Y"` MSSERR: \"$*\" >> $REPORTDIR/$DESTNAME.msg
        proc_highdebug "Sending error to hub for it to pick up: $*"
      else
        proc_highdebug "Was going to sent this error to hub, but $REPORTDIR does not exist or is not a directory."
      fi
    fi
  fi
  unset ERRORLEVEL
}

## Used with 'actionfile' to send a ping-pong to hub so it knows were alive.
proc_pong() {
  if [ "$REPORTLIFE" = "TRUE" ]; then
    echo `date "+%a %b %e %T %Y"` PONG: \"$DESTNAME reports alive\" >> $REPORTDIR/$DESTNAME.msg
    proc_highdebug "Sending alive ping/pong to hub so it knows were alive."
  fi
  touch $LOCKFILE
}

## Function for writing to log.
proc_log() {
  if [ "$LOG" != "" ]; then
    if [ -z "$ACTIONFILE" ]; then
      echo `date "+%a %b %e %T %Y"` USYNC: \"$*\" >> $LOG
    else
      echo `date "+%a %b %e %T %Y"` USYNCA: \"$*\" >> $LOG
    fi
  fi
}

## Function for writing to statlog.
proc_statlog() {
  if [ ! -z "$STATLOG" ]; then
    if [ -z "$ACTIONFILE" ]; then
      echo `date "+%a %b %e %T %Y"` USYNC: \"$*\" >> $STATLOG
    else
      echo `date "+%a %b %e %T %Y"` USYNCA: \"$*\" >> $STATLOG
    fi
  fi
}

## MOD 2004-02-08 by Turranius
## Removed HIGHDEBUG. Check if HIGHDEBUGLOG is defined
## instead. If not, its pretty much off.
## Function for writing highdebug info to log.
proc_highdebug() {
   if [ "$HIGHDEBUGLOG" ]; then
     echo `date "+%a %b %e %T %Y"` USYNCDB: \"$*\" >> $HIGHDEBUGLOG
   fi
}

## NEW: 2003-01-21
## Function for writing to msspost log. 
## Mostly used for integritycheck
proc_msslog() {
  if [ ! -z "$FETCHLOGSDIR" ]; then
    if [ ! -e "$FETCHLOGSDIR" ]; then
      mkdir $FETCHLOGSDIR >/dev/null 2>&1
      chmod $PERMS $FETCHLOGSDIR >/dev/null 2>&1
    fi
    if [ ! -w "$FETCHLOGSDIR/" ]; then      
      proc_log "Error: Cannot write to $FETCHLOGSDIR so no logs copied."
      proc_debug "Error: Fetchlog: Cannot write to $FETCHLOGSDIR so no logs copied."
    else
      if [ "$DELMSSLOG" = "TRUE" ]; then
        echo `date "+%a %b %e %T %Y"` CLEAR: \"$*\" > $FETCHLOGSDIR/$DESTNAME.report
        unset DELMSSLOG
      elif [ "$REPORTUPDATE" = "YES" ]; then
        echo `date "+%a %b %e %T %Y"` UPDATE: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
      elif [ "$RUNCMDSEND" = "YES" ]; then
        echo `date "+%a %b %e %T %Y"` RUNCMD: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
      elif [ "$VERSIONSEND" = "YES" ]; then
        echo `date "+%a %b %e %T %Y"` VER: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
      else
        echo `date "+%a %b %e %T %Y"` INTEGCK: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
      fi
    fi
  else
    proc_log "Error: FETCHLOGSDIR is undefined in config."
    proc_debug "Error: FETCHLOGSDIR is undefined in config."
  fi
}

## Procedure for writing to the logfile.
proc_transferlog() {
  if [ "$TRANSFERLOG" ]; then
    echo `date "+%a %b %e %T %Y"` TRANS: \"Actionfile: $*\" >> $TRANSFERLOG
  fi
}

if [ "$1" = "actionfile" ]; then
  proc_debug "Delaying actionfile run for 5 seconds to allow full or other syncs to run from crontab."
  sleep 5
fi

if [ -e "$LOCKFILE" ]; then
  if [ "`find \"$LOCKFILE\" -type f -mmin -1440`" ]; then
    proc_debug "Lockfile $LOCKFILE exists and is not 24 hours old yet. Quitting."
    proc_highdebug "Lockfile $LOCKFILE exists and is not 24 hours old yet. Quitting."
    exit 0
  else
    proc_debug "Lockfile exists, but its older then 24 hours. Removing lockfile."
    proc_highdebug "Lockfile exists, but its older then 24 hours. Removing lockfile."
    rm -f "$LOCKFILE"
  fi
fi

proc_highdebug "----------------------------------------------"
proc_highdebug "Starting MSS v$VER with command: $1"

## Create lockfile.
if [ "$LOCKFILE" ]; then
  proc_highdebug "Creating lockfile: $LOCKFILE"
  touch $LOCKFILE
fi

## Check existans of required files.
if [ -z "`which bc`" ]; then
  ERRORLEVEL=3
  proc_debug "Binary 'bc' not found in path. Quitting."
  proc_highdebug "Binary 'bc' not found in path. Quitting."
  rm -f $LOCKFILE
  exit 0
fi

if [ -z "$EXCLUDE" ]; then
  EXCLUDE="FEu38ru38fj"
else
  EXCLUDETMP="`echo "$EXCLUDE" | tr '|' ' '`"
  for temp in $EXCLUDETMP; do
    if [ -z "$NEWEXCLUDE" ]; then
      NEWEXCLUDE="/$temp$"
    else
      NEWEXCLUDE="$NEWEXCLUDE|/$temp$"
    fi
  done
  EXCLUDE="$NEWEXCLUDE"
  unset EXCLUDETMP; unset temp
fi

if [ "$PINGTEST" = "TRUE" ]; then
  if [ -z "$DNSHUB" ]; then
    DNSHUB="`grep "$PASSWDSOURCE" /etc/fstab | cut -d':' -f1`"
  fi
  if [ -z "$DNSHUB" ]; then
    ERRORLEVEL=1
    proc_debug "PINGTEST is TRUE, but I could not get the hostname for the NFS server."
    ERRORLEVEL=1
    proc_debug "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server. Quitting PINGTEST"
    proc_log "PINGTEST is TRUE, but I could not get the hostname for the NFS server."
    proc_log "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server. Quitting PINGTEST"
  else
    if [ -z "$PINGOPTIONS" ]; then
      ERRORLEVEL=1
      proc_debug "Error: No PINGOPTIONS set in mss-slave.conf. Did you upgrade correctly?"
      ERRORLEVEL=1
      proc_debug "Check the README for PINGOPTIONS instructions. Quitting now."
      proc_log "Error: No PINGOPTIONS set in mss-slave.conf. Did you upgrade correctly?"
      proc_log "Check the README for PINGOPTIONS instructions. Quitting now."
      rm -f $LOCKFILE
      exit 0
    fi
    PINGLIST="`ping "$DNSHUB" $PINGOPTIONS | tr -s ' ' '^' | egrep 'packets|received'`"
    if [ -z "$PINGTEST" ]; then
      ERRORLEVEL=1
      proc_debug "PINGTEST failed. $DNSHUB was not resolved."
      proc_log "PINGTEST failed. $DNSHUB was not resolved."
      PINGFAIL="TRUE"
    else
      PINGSENT="`echo "$PINGLIST" | cut -d'^' -f1`"
      PINGRECI="`echo "$PINGLIST" | cut -d'^' -f4`"
      if [ "$PINGRECI" = "0" ]; then
        ERRORLEVEL=1
        proc_debug "PINGTEST failed. $PINGSENT sent, $PINGRECI received."
        proc_log "PINGTEST failed. $PINGSENT sent, $PINGRECI received from $DNSHUB."
        PINGFAIL="TRUE"
      else
        if [ "$PINGRECI" = "1" ]; then
          proc_highdebug "PINGTEST warning. Only 1 of 2 packets recived. Continuing on lagged lines."
        fi
      fi
    fi
  fi
  if [ "$PINGFAIL" = "TRUE" ]; then
    if [ "`mount | grep "$FTP_DATA_EXT" | cut -d' ' -f3`" = "$FTP_DATA_EXT" ]; then
      proc_debug "MSS will now try to umount FTP_DATA_EXT ( $FTP_DATA_EXT ) since its mounted."
      proc_log "MSS will now try to umount FTP_DATA_EXT ( $FTP_DATA_EXT ) since its mounted."
      umount -f $FTP_DATA_EXT >/dev/null 2>&1
      umount -l $FTP_DATA_EXT >/dev/null 2>&1
      umount $FTP_DATA_EXT >/dev/null 2>&1
    fi
    if [ "`mount | grep "$PASSWDSOURCE" | cut -d' ' -f3`" = "$PASSWDSOURCE" ]; then
      proc_debug "MSS will now try to umount PASSWDSOURCE since its mounted."
      proc_log "MSS will now try to umount PASSWDSOURCE since its mounted."
      umount -f $PASSWDSOURCE >/dev/null 2>&1
      umount -l $PASSWDSOURCE >/dev/null 2>&1
      umount $PASSWDSOURCE >/dev/null 2>&1
    fi
    rm -f $LOCKFILE
    exit 0
  fi
fi

## Extra hub-up verification for NFS usage.
if [ "$USENFS" ] && [ "$USENFS" != "FALSE" ]; then
  if [ -z "$DNSHUB" ]; then
    DNSHUB="`grep "$PASSWDSOURCE" /etc/fstab | cut -d':' -f1`"
  fi
  if [ -z "$DNSHUB" ]; then
    ERRORLEVEL=1
    proc_debug "USENFS is TRUE, but I could not get the hostname for the NFS server."
    ERRORLEVEL=1
    proc_debug "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the hub."
    proc_log "USENFS is TRUE, but I could not get the hostname for the NFS server."
    proc_log "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the hub."
  else
    if [ ! -e $RPCINFO ]; then
      ERRORLEVEL=1
      proc_debug "USENFS is true, but I cant execute the binary 'rpcinfo' used to check connection. Check RPCINFO= in mss-slave.conf to make it sure it points to the right place."
      ERRORLEVEL=1
      proc_debug "Not doing the NFS-up check.."
      proc_log "USENFS is true, but I cant execute the binary 'rpcinfo' used to check connection. Check RPCINFO= in mss-slave.conf to make sure it points to the right place."
      proc_log "Not doing the NFS-up check.."
    else
      RPCLIST="`$RPCINFO -p $DNSHUB | tr -s ' ' '^'`"
      for nfsservice in $USENFS; do
        if [ -z "`echo $RPCLIST | grep -w "$nfsservice"`" ]; then
          proc_debug "NFS check failed. Service $nfsservice not seen on $DNSHUB."
          proc_debug "Note: Do: rpcinfo -p $DNSHUB"
          proc_debug "The following services are configured as must be shown: $USENFS"
          proc_log "NFS check failed. Service $nfsservice not seen on $DNSHUB. Checks are: $USENFS"
          NFSERROR="TRUE"
          break
        fi
      done
      if [ "$NFSERROR" = "TRUE" ]; then
        if [ "`mount | grep "$FTP_DATA_EXT" | cut -d ' ' -f3`" = "$FTP_DATA_EXT" ]; then
          ERRORLEVEL=1
          proc_debug "MSS will now try to umount FTP_DATA_EXT ( $FTP_DATA_EXT ) since its mounted."
          proc_log "MSS will now try to umount FTP_DATA_EXT ( $FTP_DATA_EXT ) since its mounted."
          umount -f $FTP_DATA_EXT >/dev/null 2>&1
          umount -l $FTP_DATA_EXT >/dev/null 2>&1
          umount $FTP_DATA_EXT >/dev/null 2>&1
        fi
        if [ "`mount | grep "$PASSWDSOURCE" | cut -d ' ' -f3`" = "$PASSWDSOURCE" ]; then
          ERRORLEVEL=1
          proc_debug "MSS will now try to umount PASSWDSOURCE ( $PASSWDSOURCE ) since its mounted."
          proc_log "MSS will now try to umount PASSWDSOURCE ( $PASSWDSOURCE ) since its mounted."
          umount -f $PASSWDSOURCE >/dev/null 2>&1
          umount -l $PASSWDSOURCE >/dev/null 2>&1
          umount $PASSWDSOURCE >/dev/null 2>&1
        fi
        rm -f $LOCKFILE
        exit 0
      fi
      unset RPCLIST
    fi
  fi
fi

if [ ! -e $USERSOURCE/$VERIFYUSER ]; then
  if [ "$REMOUNT" = "TRUE" ]; then
    if [ -z "`grep -w "$FTP_DATA_EXT" /etc/fstab`" ]; then
      ERRORLEVEL=1
      proc_debug "REMOUNT is TRUE, but no entry in /etc/fstab for $FTP_DATA_EXT. Quitting."
      echo "REMOUNT is TRUE, but no entry in /etc/fstab for $FTP_DATA_EXT. Quitting."
      rm -f $LOCKFILE
      exit 0 
    fi
    proc_highdebug "Attempting to remount FTP_DATA_EXT ( $FTP_DATA_EXT )."
    proc_debug "Attempting to remount FTP_DATA_EXT ( $FTP_DATA_EXT )."
    umount -f $FTP_DATA_EXT >/dev/null 2>&1
    umount -l $FTP_DATA_EXT >/dev/null 2>&1
    umount $FTP_DATA_EXT >/dev/null 2>&1
    sleep 1
    if [ "`mount | grep "$FTP_DATA_EXT" | cut -d' ' -f3`" = "$FTP_DATA_EXT" ]; then
      proc_debug "Error. Seems I couldnt unmount $FTP_DATA_EXT. Quitting."
      proc_log "Error: Seems I couldnt unmount $FTP_DATA_EXT. Quitting."
      rm -f $LOCKFILE
      exit 0
    else
      mount $FTP_DATA_EXT >/dev/null 2>&1
      sleep 2
      if [ -e $USERSOURCE/$VERIFYUSER ]; then
        proc_debug "Verify user $VERIFYUSER found again so remount successful."
        proc_log "Verify user $VERIFYUSER found again so remount successful."
      else
        proc_debug "Verify user $VERIFYUSER does not exist. Remount failed."
        proc_log "Verify user $VERIFYUSER does not exist. Remount failed."
        rm -f $LOCKFILE
        exit 0
      fi
    fi
  else
    ERRORLEVEL=1
    echo "Cant find $USERSOURCE/$VERIFYUSER, defined as VERIFYUSER in mss-slave.conf - Link down?"
    rm -f $LOCKFILE
    exit 0
  fi
fi

if [ ! -e "$PASSWDSOURCE/passwd" ]; then
  if [ "$REMOUNT" = "TRUE" ]; then
    if [ -z "`grep -w "$PASSWDSOURCE" /etc/fstab`" ]; then
      ERRORLEVEL=1
      proc_debug "REMOUNT is TRUE, but no entry in /etc/fstab for $USERSOURCE. Quitting."
      proc_highdebug "REMOUNT is TRUE, but no entry in /etc/fstab for $USERSOURCE. Quitting."
      rm -f $LOCKFILE
      exit 0 
    fi
    proc_highdebug "Attempting to remount PASSWDSOURCE ( $PASSWDSOURCE )."
    ERRORLEVEL=1
    proc_debug "Attempting to remount PASSWDSOURCE ( $PASSWDSOURCE )."
    umount -f $PASSWDSOURCE >/dev/null 2>&1
    umount -l $PASSWDSOURCE >/dev/null 2>&1
    umount $PASSWDSOURCE >/dev/null 2>&1
    sleep 2
    if [ "`mount | grep "$PASSWDSOURCE" | cut -d' ' -f3`" = "$PASSWDSOURCE" ]; then
      ERRORLEVEL=1
      proc_debug "Error. Seems I couldnt unmount $PASSWDSOURCE. Quitting."
      proc_log "Error: Seems I couldnt unmount $PASSWDSOURCE. Quitting."
      rm -f $LOCKFILE
      exit 0
    else
      mount $PASSWDSOURCE >/dev/null 2>&1
      sleep 2
      if [ -e "$PASSWDSOURCE/passwd" ]; then
        ERRORLEVEL=1
        proc_debug "Found $PASSWDSOURCE/passwd - Remount successful."
        proc_log "Found $PASSWDSOURCE/passwd - Remount successful."
      else
        ERRORLEVEL=1
        proc_debug "Cant find $PASSWDSOURCE/passwd - Remount failed."
        proc_log "Cant find $PASSWDSOURCE/passwd - Remount failed."
        rm -f $LOCKFILE
        exit 0
      fi
    fi
  else
    ERRORLEVEL=1
    proc_debug "Cant find PASSWDSOURCE/passwd ( $PASSWDSOURCE/passwd ) - Link down?"
    rm -f $LOCKFILE
    exit 0
  fi
fi

if [ ! -r "$PASSWDSOURCE/passwd" ]; then
  ERRORLEVEL=1
  echo "Cant read $PASSWDSOURCE/passwd - Wrong perms? Quitting."
  rm -f $LOCKFILE
  exit 0
fi

if [ ! -r "$PASSWDSOURCE/group" ]; then
  ERRORLEVEL=1
  echo "Cant read $PASSWDSOURCE/group - Wrong perms? Quitting."
  exit 0
fi

if [ "$LOG" ]; then
  if [ ! -e $LOG ]; then
    proc_highdebug "Creating $LOG"
    touch $LOG
    proc_highdebug "Setting chmod $PERMS on $LOG"
    chmod $PERMS $LOG >/dev/null 2>&1
  fi
fi

if [ -z "$REPORTLEVEL" ]; then
  echo "Error. Reportlevel not defined. Set to 0 in mss-slave.conf to disable."
  exit 0
fi

## Check that REPORTDIR exists if enabled.
if [ "$REPORTLEVEL" -gt "0" -o "$REPORTLIFE" = "TRUE" ]; then
  if [ ! -e "$REPORTDIR" ]; then
    echo "Error. $REPORTDIR, defined as REPORTDIR in mss-slave.conf, does not exist."
    echo "Create it and set adiquate permissions on it so I can write in it."
    echo "Setting REPORTLEVEL=0 and REPORTLIFE=FALSE - Nothing will be reported."
    echo "----------------------------------------------------------------------"
    echo ""
    REPORTLEVEL=0
    REPORTLIFE=FALSE
  fi
fi

proc_debug "Network seems fine."

## Check for ERROR.TEMPSTATS and warn if there.
unset verify
if [ "`ls -1 "$TMP" | grep "^ERROR\.TEMPSTATS\."`" ]; then
  verify="error"
fi
if [ "$verify" ]; then
  if [ "$1" = "" ]; then
    echo "Warning. There are failed userfiles in $TMP."
    echo "         These are called ERROR.TEMPSTATS.*"
    echo "         Have a look. If nothing is wrong, delete them."
    echo "-------------------------------------------------------"
  else
    proc_debug "Warning. There are failed userfiles in $TMP."
    proc_debug "         These are called ERROR.TEMPSTATS.*"
    proc_debug "         Have a look. If nothing is wrong, delete them."
    proc_debug "-------------------------------------------------------"
  fi
  proc_highdebug "Warning. There are failed ERROR.TEMPSTATS.* files in $TMP. Examine those and"
  proc_highdebug "         if there is nothing wrong with the user(s), delete them."
fi
unset verify

## Verify permissions everywhere..
if [ ! -d "$TMP" ]; then
  proc_highdebug "Notice: TMP dir ( $TMP ) does not exist. Creating it and setting 777 on it."
  mkdir -m777 $TMP
else
  for each in `ls -al $TMP | grep " \."`; do
    if [ "$each" != "drwxrwxrwx" ]; then
      proc_highdebug "Notice: TMP dir ( $TMP ) is not drwxrwxrwx - Running chmod -R 777 on it."
      chmod 777 $TMP
      chmod 666 $TMP/*
    fi
    break
  done
fi
FIX_LIST="$PASSWDSOURCE $PASSWDDEST"
for path in $FIX_LIST; do
  if [ "`ls -al $path | grep "\ \.$" | cut -d ' ' -f1`" != "drwxrwxrwx" ]; then
    proc_highdebug "Notice: $path is not set to drwxrwxrwx. Running chmod 777 on it."
    chmod 777 $path
  fi
done
unset FIX_LIST
if [ "$RLSCOMPLOG" ]; then
  curperms="`ls -al $RLSCOMPLOG | cut -d ' ' -f1`"
  if [ "$curperms" ]; then
    if [ "$curperms" != "-rw-rw-rw-" ]; then
      proc_highdebug "Notice. Permissions on $RLSCOMPLOG is $curperms. Setting chmod 666 on it."
      chmod 666 $RLSCOMPLOG
    fi
  fi
  unset curperms
fi


## Procedute for locking on source
proc_lock_src() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERSOURCE/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY=$[$RETRY-1]
    proc_debug "$USER seems locked at $USERSOURCE. Retries left: $RETRY."
    proc_highdebug "$USER seems locked at $USERSOURCE. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERSOURCE/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    ERRORLEVEL=2
    proc_debug "$USER seems locked at $USERSOURCE. Skipping."
    proc_highdebug "$USER Seems locked at $USERSOURCE. Skipping."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      proc_debug "Lock lifted. Locking him myself."
      proc_highdebug "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERSOURCE/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
  unset FOUNDLOCK
}

## Procedute for unlocking on source
proc_unlock_src() {
  if [ -e "$USERSOURCE/$USER.lock" ]; then
    rm -f $USERSOURCE/$USER.lock
  fi
}

## Procedute for locking on destination
proc_lock_dst() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERDEST/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY=$[$RETRY-1]
    proc_debug "$USER seems locked at $USERDEST. Retries left: $RETRY."
    proc_highdebug "$USER seems locked at $USERDEST. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERDEST/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    ERRORLEVEL=2
    proc_debug "$USER seems locked at $USERDEST. Skipping."
    proc_highdebug "$USER Seems locked at $USERDEST. Skipping."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      proc_debug "Lock lifted. Locking him myself."
      proc_highdebug "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERDEST/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
  unset FOUNDLOCK
}

## Procedute for unlocking on destination
proc_unlock_dst() {
  if [ -e "$USERDEST/$USER.lock" ]; then
    rm -f $USERDEST/$USER.lock
  fi
}

## Procedure for verifying userfile.
proc_userver() {
  unset VERERR
  if [ ! -e "$CHECKPATH/$USER" ]; then
    VERERR="Does_Not_Exist"
  else
    if [ -z "`grep "^USER " $CHECKPATH/$USER`" ]; then VERERR="$VERERR USER"; fi
    if [ -z "`grep "^GENERAL " $CHECKPATH/$USER`" ]; then VERERR="$VERERR GENERAL"; fi
    if [ -z "`grep "^LOGINS " $CHECKPATH/$USER`" ]; then VERERR="$VERERR LOGINS"; fi
    if [ -z "`grep "^TIMEFRAME " $CHECKPATH/$USER`" ]; then VERERR="$VERERR TIMEFRAME"; fi
    if [ -z "`grep "^FLAGS " $CHECKPATH/$USER`" ]; then VERERR="$VERERR FLAGS"; fi
    if [ -z "`grep "^TAGLINE " $CHECKPATH/$USER`" ]; then VERERR="$VERERR TAGLINE"; fi
    if [ -z "`grep "^DIR " $CHECKPATH/$USER`" ]; then VERERR="$VERERR DIR"; fi
    if [ -z "`grep "^CREDITS " $CHECKPATH/$USER`" ]; then VERERR="$VERERR CREDITS"; fi
    if [ -z "`grep "^RATIO " $CHECKPATH/$USER`" ]; then VERERR="$VERERR RATIO"; fi
    if [ -z "`grep "^ALLUP " $CHECKPATH/$USER`" ]; then VERERR="$VERERR ALLUP"; fi
    if [ -z "`grep "^ALLDN " $CHECKPATH/$USER`" ]; then VERERR="$VERERR ALLDN"; fi
    if [ -z "`grep "^WKUP " $CHECKPATH/$USER`" ]; then VERERR="$VERERR WKUP"; fi
    if [ -z "`grep "^WKDN " $CHECKPATH/$USER`" ]; then VERERR="$VERERR WKDN"; fi
    if [ -z "`grep "^DAYUP " $CHECKPATH/$USER`" ]; then VERERR="$VERERR DAYUP"; fi
    if [ -z "`grep "^DAYDN " $CHECKPATH/$USER`" ]; then VERERR="$VERERR DAYDN"; fi
    if [ -z "`grep "^MONTHUP " $CHECKPATH/$USER`" ]; then VERERR="$VERERR MONTHUP"; fi
    if [ -z "`grep "^MONTHDN " $CHECKPATH/$USER`" ]; then VERERR="$VERERR MONTHDN"; fi
    if [ -z "`grep "^NUKE " $CHECKPATH/$USER`" ]; then VERERR="$VERERR NUKE"; fi
    if [ -z "`grep "^TIME " $CHECKPATH/$USER`" ]; then VERERR="$VERERR TIME"; fi

    if [ "$GL_VERSION" -lt "2" ]; then
      if [ -z "`grep "^SLOTS " $CHECKPATH/$USER`" ]; then VERERR="$VERERR SLOTS"; fi
    elif [ "$GL_VERSION" -ge "2" ]; then
      if [ -z "`grep "^ADDED " $CHECKPATH/$USER`" ]; then VERERR="$VERERR ADDED"; fi
      if [ -z "`grep "^EXPIRES " $CHECKPATH/$USER`" ]; then VERERR="$VERERR EXPIRES"; fi
    fi

    if [ "$VERERR" ]; then
      VERERR="`echo $VERERR | tr -s ' '`"
    fi
  fi
}

## Procedure for syncing user.
proc_syncuser() {
  unset EXISTS
  if [ -e $USERDEST/$USER ]; then
    proc_debug "Syncing: $USER"
    EXISTS="YES"
  else
    proc_highdebug "Syncing NEW user $USER"
    proc_debug "Syncing new user: $USER"
    EXISTS="NO"
  fi

  if [ ! -e "$USERSOURCE/$USER" ]; then
    ERRORLEVEL=2
    proc_debug "$USER not found in $USERSOURCE on $SOURCENAME."
    proc_log "$USER not found in $USERSOURCE on $SOURCENAME."
    SKIP="YES"
  fi

  if [ "$BACKUPDEST" != "" ]; then
    if [ -e "$BACKUPDEST/deleted/$USER" ]; then
      ERRORLEVEL=2
      proc_debug "Warning: Found previosly deleted userfile for: $USER - Mistakenly deleted? Delete $BACKUPDEST/deleted/$USER if OK."
      proc_highdebug "Warning: Found previosly deleted userfile for: $USER - Mistakenly deleted? Delete $BACKUPDEST/deleted/$USER if OK."
    fi
  fi

  ## Check that this user did not previously fail sync and skip if so.
  if [ -e $TMP/ERROR.$USER ]; then
    ERRORLEVEL=2
    proc_debug "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    proc_log "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    SKIP="YES"
  fi

  if [ "$SKIP" != "YES" ]; then
    ## Verify integrity of userfile from source.
    CHECKPATH="$USERSOURCE"
    proc_highdebug "Verifying integrity of user: $USER from $SOURCENAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      ERRORLEVEL=2
      proc_debug "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      proc_log "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      SKIP="YES"
    fi
    unset CHECKPATH
  fi

  ## If the user exists, verify integrity on destination too.
  if [ "$EXISTS" = "YES" -a "$SKIP" != "YES" ]; then
    CHECKPATH="$USERDEST"
    proc_highdebug "Verifying integrity of user: $USER from $DESTNAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      ERRORLEVEL=2
      proc_debug "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      proc_log "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      SKIP="YES"
    fi
    unset CHECKPATH
  fi

  ## User did not exist before
  if [ "$EXISTS" = "NO" -a "$SKIP" != "YES" -a "$SKIPRES" != "YES" ]; then

    ## Do a clean copy and remove stats/creds

    cp -f $USERSOURCE/$USER $TMP/NEWUSER.$USER
    proc_debug "Resetting all stats on new user: $USER"
    proc_log "Resetting all stats on new user: $USER"

    ## Reset CREDITS
    sed -e "s/^CREDITS .*/CREDITS 0/" $TMP/NEWUSER.$USER > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset ALL UPLOAD stats
    sed -e "s/^ALLUP .*/ALLUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1
 
    ## Reset ALL DOWNLOAD stats
    sed -e "s/^ALLDN .*/ALLDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset WEEK UP stats
    sed -e "s/^WKUP .*/WKUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset WEEK DOWNLOAD stats
    sed -e "s/^WKDN .*/WKDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset DAY UPLOAD stats
    sed -e "s/^DAYUP .*/DAYUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset DAY DOWNLOAD stats
    sed -e "s/^DAYDN .*/DAYDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset MONTH UPLOAD stats
    sed -e "s/^MONTHUP .*/MONTHUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset MONTH DOWNLOAD stats
    sed -e "s/^MONTHDN .*/MONTHDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset NUKE counter
    sed -e "s/^NUKE .*/NUKE 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset TIME online
    sed -e "s/^TIME .*/TIME 0 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1

    ## Reset gadmin SLOTS
    if [ "$GL_VERSION" -lt "2" ]; then
      sed -e "s/^SLOTS .*/SLOTS 0 0 /" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
      mv -f "$TMP/NEWUSER.$USER.NEW.TMP" "$TMP/NEWUSER.$USER.NEW" >/dev/null 2>&1
    fi

    ## Verify new userfile:
    CHECKPATH="$TMP"
    USERTMP="$USER"
    USER="NEWUSER.$USER.NEW"
    proc_highdebug "Verifying integrity of new userfile for $USER ment for $DESTNAME"
    proc_userver
    if [ "$VERERR" ]; then
      ERRORLEVEL=2
      proc_debug "Error: Newly created userfile $CHECKPATH/$USER have problems with the following fields: $VERERR. User not added."
      proc_log "Error: Newly created userfile $CHECKPATH/$USER have problems with the following fields: $VERERR. User not added."
      SKIP="YES"
      USER="$USERTMP"
      unset USERTMP
    else
      USER="$USERTMP"
      unset USERTMP
      proc_lock_dst
      if [ "$SKIP" != "YES" ]; then
        mv -f "$TMP/NEWUSER.$USER.NEW" "$USERDEST/$USER" >/dev/null 2>&1
        if [ "$PERMS" ]; then
          chmod $PERMS $USERDEST/$USER >/dev/null 2>&1
          proc_highdebug "Setting chmod $PERMS on new user $USER"
        fi
      fi
      proc_unlock_dst
    fi
    unset CHECKPATH
  fi
  SKIPRES="NO"

  ## User already existed. Lets sync the users info.

  if [ "$EXISTS" = "YES" -a "$SKIP" != "YES" ]; then

    ## Lets make sure theres no temp file for this user.
    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
      rm -f $TMP/TEMPSTATS.$USER.NEW
      proc_highdebug "Warning: Previous file from earlier sync found. Clearing it. File was: $TMP/TEMPSTATS.$USER.NEW"
    fi

    ## Sync FLAGS
    if [ "$SKIP" != "YES" -a "$SYNCFLAGS" = "TRUE" ]; then
      unset DESTFLAGS; unset SOURCEFLAGS
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTFLAGS="`grep "^FLAGS " $CURRENTFILE | cut -d ' ' -f2`"
      if [ -z "$DESTFLAGS" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read FLAGS from $USERDEST/$USER"
        proc_debug "Error: Cant read RATIO from $USERDEST/$USER"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCEFLAGS="`grep "^FLAGS " $USERSOURCE/$USER | cut -d ' ' -f2`"
      else
        unset SOURCEFLAGS
        ERRORLEVEL=2
        proc_debug "Error: Cant read FLAGS from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read FLAGS from $USERSOURCE/$USER"
      fi
      if [ "$SOURCEFLAGS" != "" -a "$DESTFLAGS" != "" ]; then
        proc_highdebug "$USER - FLAGS = $DESTNAME $DESTFLAGS / $SOURCENAME $SOURCEFLAGS"
        if [ "$DESTFLAGS" != "$SOURCEFLAGS" ]; then
          if [ "$SKIP" != "YES" ]; then
            sed -e "s/^FLAGS .*/FLAGS $SOURCEFLAGS/" $CURRENTFILE > $TMP/TEMP.$USER.FLAGS
            mv -f "$TMP/TEMP.$USER.FLAGS" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - FLAGS changed from $DESTFLAGS to $SOURCEFLAGS"
            proc_log "$USER - FLAGS change from $DESTFLAGS to $SOURCEFLAGS"
          fi
        fi
      fi
    fi

    ## Sync RATIO
    if [ "$SKIP" != "YES" -a "$SYNCRATIO" = "TRUE" ]; then
      unset DESTRATIO; unset SOURCERATIO
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTRATIO="`grep "^RATIO " $CURRENTFILE | cut -d ' ' -f2`"
      if [ -z "$DESTRATIO" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read RATIO from $USERDEST/$USER"
        proc_debug  "Error: Cant read RATIO from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCERATIO="`grep "^RATIO" $USERSOURCE/$USER | cut -d ' ' -f2`"
      else
        unset SOURCERATIO
        ERRORLEVEL=2
        proc_debug "Error: Cant read RATIO from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read RATIO from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCERATIO" != "" -a "$DESTRATIO" != "" ]; then
        proc_highdebug "$USER - RATIO = $DESTNAME $DESTRATIO / $SOURCENAME $SOURCERATIO"
        if [ "$DESTRATIO" != "$SOURCERATIO" ]; then
          if [ "$SKIP" != "YES" ]; then
            sed -e "s/^RATIO [0-9]* /RATIO $SOURCERATIO /" $CURRENTFILE > $TMP/TEMP.$USER.RATIO
            mv -f "$TMP/TEMP.$USER.RATIO" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - RATIO changed from $DESTRATIO to $SOURCERATIO"
            proc_log "$USER - RATIO change from $DESTRATIO to $SOURCERATIO"
          fi
        fi
      fi
    fi

    ## Sync GENERAL
    if [ "$SKIP" != "YES" -a "$SYNCGENERAL" = "TRUE" ]; then
      unset DESTGENERAL; unset SOURCEGENERAL; unset ALLOTMENTNR
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTGENERAL="`grep "^GENERAL " $CURRENTFILE`"
      if [ -z "$DESTGENERAL" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read GENERAL from $USERDEST/$USER"
        proc_debug "Error: Cant read GENERAL from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCEGENERAL="`grep "^GENERAL " $USERSOURCE/$USER`"
      else
        unset SOURCEGENERAL
        ERRORLEVEL=2
        proc_debug "Error: Cant read GENERAL from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read GENERAL from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCEGENERAL" != "" -a "$DESTGENERAL" != "" ]; then
        proc_highdebug "$USER - GENERAL = $DESTNAME $DESTGENERAL / $SOURCENAME $SOURCEGENERAL"

        if [ "$SHAREALLOTMENT" = "FALSE" ]; then
          ALLOTMENTNR="$( echo "$SOURCEGENERAL" | cut -d ',' -f2 | cut -d ' ' -f1 )"
          if [ "$ALLOTMENTNR" != "0" ]; then
            ALLOTMENT="YES"
          else
            ALLOTMENT="NO"
          fi
          if [ "$ALLOTMENT" = "YES" ]; then
            SOURCEGENFIRST="`echo "$SOURCEGENERAL" | cut -d ',' -f1 | cut -d ' ' -f2`"
            SOURCEGENTHIRD="`echo "$SOURCEGENERAL" | cut -d ' ' -f3`"
            SOURCEGENFOURTH="`echo "$SOURCEGENERAL" | cut -d ' ' -f4`"
            SOURCEGENFIFTH="`echo "$SOURCEGENERAL" | cut -d ' ' -f5`"
            SOURCEGENERAL="GENERAL $SOURCEGENFIRST,1000 $SOURCEGENTHIRD $SOURCEGENFOURTH $SOURCEGENFIFTH"
            proc_highdebug "$USER have $ALLOTMENTNR allotment on $SOURCENAME - Faking 1000 kb."
            unset SOURCEGENFIRST; unset SOURCEGENTHIRD; unset SOURCEGENFOURTH; unset SOURCEGENFIFTH
          fi
        fi

        if [ "$DESTGENERAL" != "$SOURCEGENERAL" ]; then
          ## Sync general from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^GENERAL " $CURRENTFILE > $TMP/TEMP.$USER.GENERAL
            echo "$SOURCEGENERAL" >> $TMP/TEMP.$USER.GENERAL
            mv -f "$TMP/TEMP.$USER.GENERAL" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - GENERAL changed from $DESTGENERAL to $SOURCEGENERAL"
            proc_log "$USER - GENERAL change from $DESTGENERAL to $SOURCEGENERAL"
          fi
        fi
      fi
    fi

    ## Sync LOGINS
    if [ "$SKIP" != "YES" -a "$SYNCLOGINS" = "TRUE" ]; then
      unset DESTLOGINS; unset SOURCELOGINS
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTLOGINS="`grep "^LOGINS " $CURRENTFILE`"
      if [ -z "$DESTLOGINS" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read LOGINS from $USERDEST/$USER"
        proc_debug "Error: Cant read LOGINS from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCELOGINS="`grep "^LOGINS " $USERSOURCE/$USER`"
      else
        unset SOURCELOGINS
        ERRORLEVEL=2
        proc_debug "Error: Cant read LOGINS from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read LOGINS from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCELOGINS" != "" -a "$DESTLOGINS" != "" ]; then
        proc_highdebug "$USER - LOGINS = $DESTNAME $DESTLOGINS / $SOURCENAME $SOURCELOGINS"
        if [ "$DESTLOGINS" != "$SOURCELOGINS" ]; then
          ## Sync login from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^LOGINS " $CURRENTFILE > $TMP/TEMP.$USER.LOGINS
            echo "$SOURCELOGINS" >> $TMP/TEMP.$USER.LOGINS
            mv -f "$TMP/TEMP.$USER.LOGINS" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - LOGINS changed from $DESTLOGINS to $SOURCELOGINS"
            proc_log "$USER - LOGINS changed from $DESTLOGINS to $SOURCELOGINS"
          fi
        fi
      fi
    fi

    ## Sync TIMEFRAME
    if [ "$SKIP" != "YES" -a "$SYNCTIMEFRAME" = "TRUE" ]; then
      unset DESTTIMEFRAME; unset SOURCETIMEFRAME
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTTIMEFRAME="`grep "^TIMEFRAME " $CURRENTFILE`"
      if [ -z "$DESTTIMEFRAME" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read TIMEFRAME from $USERDEST/$USER"
        proc_debug "Error: Cant read TIMEFRAME from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCETIMEFRAME="`grep "^TIMEFRAME " $USERSOURCE/$USER`"
      else
        unset SOURCETIMEFRAME
        ERRORLEVEL=2
        proc_debug "Error: Cant read TIMEFRAME from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read TIMEFRAME from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCETIMEFRAME" != "" -a "$DESTTIMEFRAME" != "" ]; then
        proc_highdebug "$USER - TIMEFRAME = $DESTNAME $DESTTIMEFRAME / $SOURCENAME $SOURCETIMEFRAME"
        if [ "$DESTTIMEFRAME" != "$SOURCETIMEFRAME" ]; then
          ## Sync login from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^TIMEFRAME " $CURRENTFILE > $TMP/TEMP.$USER.TIMEFRAME
            echo "$SOURCETIMEFRAME" >> $TMP/TEMP.$USER.TIMEFRAME
            mv -f "$TMP/TEMP.$USER.TIMEFRAME" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - TIMEFRAME changed from $DESTTIMEFRAME to $SOURCETIMEFRAME"
            proc_log "$USER - TIMEFRAME changed from $DESTTIMEFRAME to $SOURCETIMEFRAME"
          fi
        fi
      fi
    fi

    ## Sync EXPIRES (if GL_VERSION = 2)
    if [ "$SKIP" != "YES" -a "$SYNCEXPIRES" = "TRUE" ]; then
      if [ "$GL_VERSION" -ge "2" ]; then
        unset DESTEXPIRES; unset SOURCEEXPIRES
        if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
          CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
        else
          CURRENTFILE="$USERDEST/$USER"
        fi
        DESTEXPIRES="`grep "^EXPIRES " $CURRENTFILE`"
        if [ -z "$DESTEXPIRES" ]; then
          ERRORLEVEL=2
          proc_log "Error: Cant read EXPIRES from $USERDEST/$USER"
          proc_debug "Error: Cant read EXPIRES from $USERDEST/$USER"
          SKIP="YES"
        fi
        if [ -r $USERSOURCE/$USER ]; then
          SOURCEEXPIRES="`grep "^EXPIRES " $USERSOURCE/$USER`"
        else
          unset SOURCEEXPIRES
          ERRORLEVEL=2
          proc_debug "Error: Cant read EXPIRES from $USERSOURCE/$USER"
          proc_highdebug "Error: Cant read EXPIRES from $USERSOURCE/$USER"
          SKIP="YES"
        fi
        if [ "$SOURCEEXPIRES" != "" -a "$DESTEXPIRES" != "" ]; then
          proc_highdebug "$USER - EXPIRES = $DESTNAME $DESTEXPIRES / $SOURCENAME $SOURCEEXPIRES"
          if [ "$DESTEXPIRES" != "$SOURCEEXPIRES" ]; then
            if [ "$SKIP" != "YES" ]; then
              grep -v "^EXPIRES " $CURRENTFILE > $TMP/TEMP.$USER.EXPIRES
              echo "$SOURCEEXPIRES" >> $TMP/TEMP.$USER.EXPIRES
              mv -f "$TMP/TEMP.$USER.EXPIRES" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
              proc_debug "$USER - EXPIRES changed from $DESTEXPIRES to $SOURCEEXPIRES"
              proc_log "$USER - EXPIRES changed from $DESTEXPIRES to $SOURCEEXPIRES"
            fi
          fi
        fi
      fi
    fi

    ## Sync SLOTS
    if [ "$SKIP" != "YES" -a "$SYNCSLOTS" = "TRUE" ]; then
      unset DESTSLOTS; unset SOURCESLOTS
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTSLOTS="`grep "^SLOTS " $CURRENTFILE`"
      if [ -z "$DESTSLOTS" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read SLOTS from $USERDEST/$USER"
        proc_debug "Error: Cant read SLOTS from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCESLOTS="`grep "^SLOTS " $USERSOURCE/$USER`"
      else
        unset SOURCESLOTS
        ERRORLEVEL=2
        proc_debug "Error: Cant read SLOTS from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read SLOTS from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCESLOTS" != "" -a "$DESTSLOTS" != "" ]; then
        proc_highdebug "$USER - SLOTS = $DESTNAME $DESTSLOTS / $SOURCENAME $SOURCESLOTS"
        if [ "$DESTSLOTS" != "$SOURCESLOTS" ]; then
          ## Sync login from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^SLOTS " $CURRENTFILE > $TMP/TEMP.$USER.SLOTS
            echo "$SOURCESLOTS" >> $TMP/TEMP.$USER.SLOTS
            mv -f "$TMP/TEMP.$USER.SLOTS" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - SLOTS changed from $DESTSLOTS to $SOURCESLOTS"
            proc_log "$USER - SLOTS changed from $DESTSLOTS to $SOURCESLOTS"
          fi
        fi
      fi
    fi

    ## Sync TAGLINE
    if [ "$SKIP" != "YES" -a "$SYNCTAGLINE" = "TRUE" ]; then
      unset DESTTAG; unset SOURCETAG
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTTAG="`grep "^TAGLINE " $CURRENTFILE`"
      if [ -z "$DESTTAG" ]; then
        ERRORLEVEL=2
        proc_log "Error: Cant read TAGLINE from $USERDEST/$USER"
        proc_debug "Error: Cant read TAGLINE from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCETAG="`grep "^TAGLINE " $USERSOURCE/$USER`"
      else
        unset SOURCETAG
        ERRORLEVEL=2
        proc_debug "Error: Cant read TAGLINE from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read TAGLINE from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCETAG" != "" -a "$DESTTAG" != "" ]; then
        proc_highdebug "$USER - TAGLINE = $DESTNAME $DESTTAG / $SOURCENAME $SOURCETAG"
        if [ "$DESTTAG" != "$SOURCETAG" ]; then
          ## Sync tagline from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^TAGLINE " $CURRENTFILE > $TMP/TEMP.$USER.TAGLINE
            echo "$SOURCETAG" >> $TMP/TEMP.$USER.TAGLINE  
            mv -f "$TMP/TEMP.$USER.TAGLINE" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
            proc_debug "$USER - TAGLINE changed from $DESTTAG to $SOURCETAG"
            proc_log "$USER - TAGLINE change from $DESTTAG to $SOURCETAG"
          fi
        fi
      fi
    fi

    ## Sync Primary group
    if [ "$SKIP" != "YES" ]; then
      unset SOURCEPRI; unset DESTPRI
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTPRI="`grep "^GROUP " $CURRENTFILE | head -n1`"
      if [ -z "$DESTPRI" ]; then
        DESTPRI="NONE"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCEPRI="`grep "^GROUP " $USERSOURCE/$USER | head -n1`"
      else
        unset SOURCEPRI
        ERRORLEVEL=2
        proc_debug "Error: Cant read primary GROUP from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read primary GROUP from $USERSOURCE/$USER"
        SKIP="YES"
      fi

      if [ "$SOURCEPRI" != "" -a "$DESTPRI" != "" ]; then
        proc_highdebug "$USER - PRIGRoup = $DESTNAME $DESTPRI / $SOURCENAME $SOURCEPRI"
        if [ "$DESTPRI" != "$SOURCEPRI" ]; then
          ## Remove pri group if its elsewhere.
          if [ "$SKIP" != "YES" ]; then
            grep -vx "^$SOURCEPRI" $CURRENTFILE > $TMP/TEMP.$USER.PRIGROUP1
            if [ "$DESTPRI" != "NONE" ]; then
              sed -e "s/^$DESTPRI/$SOURCEPRI/" $TMP/TEMP.$USER.PRIGROUP1 > $TMP/TEMP.$USER.PRIGROUP
              mv -f "$TMP/TEMP.$USER.PRIGROUP" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
              proc_debug "$USER - Primary group changed to $SOURCEPRI"
              proc_log "$USER - Primary group changed to $SOURCEPRI"
            else
              proc_debug "$USER - Primary group no existant. Normal group sync will add it."
              proc_log "$USER - Primary group no existant. Normal group sync will add it."
            fi
            rm -f $TMP/TEMP.$USER.PRIGROUP1 >/dev/null 2>&1
          fi
        fi
      else
        proc_highdebug "Warning: $USER has no primary group on $SOURCENAME?"
      fi
    fi

    ## Add new groups.
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        unset group
        for group in `grep "^GROUP " $USERSOURCE/$USER | cut -d ' ' -f2-3 | tr ' ' '^'`; do
          group="`echo "$group" | tr '^' ' '`"
          proc_highdebug "$USER - Checking GROUP $group"
          if [ ! -r $USERDEST/$USER ]; then
            ERRORLEVEL=2
            proc_debug "Error: cant read from $USERDEST/$USER."
            proc_log "Error: cant read from $USERDEST/$USER."
          else
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            if [ -z "`grep "^GROUP " $CURRENTFILE | grep "^GROUP $group$"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "GROUP $group" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - added GROUP $group"
                proc_log "$USER - added GROUP $group"
              fi
            fi
          fi
        done
      else
        ERRORLEVEL=2
        proc_debug "Error: Cant read GROUP from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read GROUP from $USERSOURCE/$USER"
        SKIP="YES"
      fi
    fi

    ## Removing redundant groups
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
       if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          unset group
          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
            CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
          else
            CURRENTFILE="$USERDEST/$USER"
          fi
          for group in `grep "^GROUP " $CURRENTFILE | cut -d ' ' -f2-3 | tr ' ' '^'`; do
            group="`echo "$group" | tr '^' ' '`"
            proc_highdebug "$USER - Checking GROUP $group -redundant groups-"
            if [ -z "`grep "^GROUP " $USERSOURCE/$USER | grep "^GROUP $group$" | cut -d ' ' -f2-3`" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v "^GROUP $group$" $CURRENTFILE > $TMP/TEMP.$USER.GRPDEL
                mv -f "$TMP/TEMP.$USER.GRPDEL" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
                proc_debug "$USER - removing GROUP $group"
                proc_log "$USER - removing GROUP $group"
              fi
            fi
          done
        fi
      else
        ERRORLEVEL=2
        proc_debug "Error: Cant read GROUP from $USERSOURCE/$USER -redundant groups-"
        proc_highdebug "Error: Cant read GROUP from $USERSOURCE/$USER -redundant groups-"
        SKIP="YES"
      fi
    fi

    ## Add new private groups.
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for privgroup in `grep "^PRIVATE " $USERSOURCE/$USER | cut -d ' ' -f2`; do
            proc_highdebug "$USER - Checking PRIVATE group $privgroup"
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            if [ -z "`grep "^PRIVATE " $CURRENTFILE | grep " $privgroup$"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "PRIVATE $privgroup" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - added PRIVATE GROUP $privgroup"
                proc_log "$USER - added PRIVATE GROUP $privgroup"
              fi
            fi
          done
          unset privgroup
        fi
      else
        ERRORLEVEL=2
        proc_debug "Error: Cant read PRIVATE groups from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read PRIVATE groups from $USERSOURCE/$USER"
        SKIP="YES"
      fi
    fi

    ## Removing redundant private groups
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
            CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
          else
            CURRENTFILE="$USERDEST/$USER"
          fi
          for privgroup in `grep "^PRIVATE " $CURRENTFILE | cut -d ' ' -f2`; do
            proc_highdebug "$USER - Checking PRIVATE group $privgroup -redundant groups-"
            if [ -z "`grep "PRIVATE " $USERSOURCE/$USER | grep -w $privgroup`" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v "^PRIVATE $privgroup" $CURRENTFILE > $TMP/TEMP.$USER.GRPDEL
                mv -f "$TMP/TEMP.$USER.GRPDEL" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
                proc_debug "$USER - removed PRIVATE GROUP $privgroup"
                proc_log "$USER - removed PRIVATE GROUP $privgroup"
              fi
            fi
          done
        fi
        unset privgroup
      else
        SKIP="YES"
        ERRORLEVEL=2
        proc_debug "Error: Cant read PRIVATE group from $USERSOURCE/$USER -redundant groups-"
        proc_highdebug "Error: Cant read PRIVATE group from $USERSOURCE/$USER -redundant groups-"
      fi
    fi

    ## Add new IP's
    if [ "$SKIP" != "YES" -a "$SYNCIP" = "TRUE" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for ip in `grep "^IP " $USERSOURCE/$USER | cut -d ' ' -f2`; do
            proc_highdebug "$USER - Checking add IP: $ip"
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            if [ -z "`grep "^IP " $CURRENTFILE | grep -F "IP $ip"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "IP $ip" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - Adding IP $ip"
                proc_log "$USER - Adding IP $ip"
              fi
            fi
            unset CHECK
          done
          unset ip
        fi
      else
       ERRORLEVEL=2
       proc_debug "Error: Cant read IPs from $USERSOURCE/$USER"
       proc_highdebug "Error: Cant read IPs from $USERSOURCE/$USER"
       SKIP="YES"
      fi
    fi 
 
    ## Removing redundant ip's
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for ip in `grep "^IP " $CURRENTFILE | cut -d ' ' -f2`; do
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            proc_highdebug "$USER - Checking remove IP: $ip"
            if [ -z "`grep "^IP " $USERSOURCE/$USER | grep -x -F -- "IP $ip"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v -x -F -- "IP $ip" $CURRENTFILE > $TMP/TEMP.$USER.IPDEL
                mv -f $TMP/TEMP.$USER.IPDEL $TMP/TEMPSTATS.$USER.NEW >/dev/null 2>&1
                proc_debug "$USER - Removed IP $ip"
                proc_log "$USER - Removed IP $ip"
              fi
            fi
            unset CHECK
          done
          unset ip
        fi
      else
        SKIP="YES"
        ERRORLEVEL=2
        proc_debug "Error: Cant read IPs -remove- from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read IPs -remove- from $USERSOURCE/$USER"
      fi
    fi

    ## Add new DNS's
    if [ "$SKIP" != "YES" -a "$SYNCIP" = "TRUE" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for dns in `grep "^DNS " $USERSOURCE/$USER | cut -d ' ' -f2`; do
            proc_highdebug "$USER - Checking add DNS: $dns"
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            if [ -z "`grep "^DNS " $CURRENTFILE | grep -F "DNS $dns"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "DNS $dns" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - Adding DNS $dns"
                proc_log "$USER - Adding DNS $dns"
              fi
            fi
            unset CHECK
          done
          unset dns
        fi
      else
       ERRORLEVEL=2
       proc_debug "Error: Cant read DNSs from $USERSOURCE/$USER"
       proc_highdebug "Error: Cant read DNSs from $USERSOURCE/$USER"
       SKIP="YES"
      fi
    fi 

    ## Removing redundant DNS's
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          ERRORLEVEL=2
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for dns in `grep "^DNS " $CURRENTFILE | cut -d ' ' -f2`; do
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            proc_highdebug "$USER - Checking remove DNS: $dns"
            if [ -z "`grep "^DNS " $USERSOURCE/$USER | grep -x -F -- "DNS $dns"`" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v -x -F -- "DNS $dns" $CURRENTFILE > $TMP/TEMP.$USER.DNSDEL
                mv -f $TMP/TEMP.$USER.DNSDEL $TMP/TEMPSTATS.$USER.NEW >/dev/null 2>&1
                proc_debug "$USER - Removed DNS $dns"
                proc_log "$USER - Removed DNS $dns"
              fi
            fi
            unset CHECK
          done
          unset dns
        fi
      else
        SKIP="YES"
        ERRORLEVEL=2
        proc_debug "Error: Cant read DNSs -remove- from $USERSOURCE/$USER"
        proc_highdebug "Error: Cant read DNSs -remove- from $USERSOURCE/$USER"
      fi
    fi



    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
      ## Check newly created file ment for destination.
      CHECKPATH="$TMP"
      TMPUSER="$USER"
      USER="TEMPSTATS.$USER.NEW"
      proc_highdebug "Checking integrity of new destination file $CHECKPATH/$USER"
      proc_userver
      if [ "$VERERR" ]; then
        ERRORLEVEL=2
        proc_debug "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
        proc_log "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
        SKIP="YES"
        SCRIPTNAME="$( basename $0 )"
        echo "" >> $TMP/$USER
        echo "---New file that $SCRIPTNAME created above. Old one from $USERDEST/$TMPUSER below---" >> $TMP/$USER
        echo "-- This file was created on "`date` >> $TMP/$USER
        echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
        echo "-- Part of $SCRIPTNAME that got the error: Syncing user info." >> $TMP/$USER
        echo "" >> $TMP/$USER
        cat $USERDEST/$TMPUSER >> $TMP/$USER
        if [ ! -e $TMP/ERROR.$USER ]; then
          mv -f "$TMP/$USER" "$TMP/ERROR.$USER" >/dev/null 2>&1
        else
          rm -f $TMP/$USER
        fi
        unset SCRIPTNAME
      fi
      ## Restore arguments
      USER="$TMPUSER"
      unset TMPUSER
      unset CHECKPATH
      ## Move the new userfile...
      if [ "$SKIP" != "YES" ]; then
        proc_lock_dst
        if [ "$SKIP" != "YES" ]; then
          mv -f "$TMP/TEMPSTATS.$USER.NEW" "$USERDEST/$USER" >/dev/null 2>&1
          proc_unlock_dst
        else
          ERRORLEVEL=2
          proc_log "After syncing $USER on $DESTNAME, I cant update his userfile because its locked. Skipping."
          proc_debug "After syncing $USER on $DESTNAME, I cant update his userfile because its locked. Skipping."
        fi
      fi
    fi
    sleep $SLOWTIME
  fi
  SKIP="NO"
  unset CURRENTFILE

  if [ ! -r "$USERSOURCE/$VERIFYUSER" ]; then
    sleep 5
    if [ ! -r "$USERSOURCE/$VERIFYUSER" ]; then
      ERRORLEVEL=2
      proc_debug "Seems I lost link? Stopping"
      proc_log "Lost link? Quitting."
      proc_exit
    fi
  fi

  proc_synctime
}


## Copy the userfile when moving stats. Verify that it works and retry up to 10 times.
proc_moveverify() {
  unset SOURCEMD5; unset DESTMD5
  retries=10
  cp -f "$SOURCEFILE" "$DESTFILE"

  SOURCEMD5="`$MD5BIN $SOURCEFILE | cut -d ' ' -f1`"
  DESTMD5="`$MD5BIN $DESTFILE | cut -d ' ' -f1`"

  while [ "$retries" -gt "1" ] && [ "$SOURCEMD5" != "$DESTMD5" ]; do
    proc_debug "Warning: After copying $SOURCEFILE to $DESTFILE, the md5sum does not match up. Retries left: $retries"
    proc_highdebug "Warning: After copying $SOURCEFILE to $DESTFILE, the md5sum does not match up. Retries left: $retries"

    cp -f "$SOURCEFILE" "$DESTFILE"
    SOURCEMD5="`$MD5BIN $SOURCEFILE | cut -d ' ' -f1`"
    DESTMD5="`$MD5BIN $DESTFILE | cut -d ' ' -f1`"
    retries=$[$retries-1]
  done

  if [ "$SOURCEMD5" != "$DESTMD5" ]; then
    SKIP="YES"
    rm -f "$SOURCEFILE"
    proc_debug "Error: Can not verify that the copy is ok. Userfiles differ after copy. Skipping."
    proc_log "Error. Can not verify that the copy from $SOURCEFILE -> $DESTFILE is ok ($SOURCEMD5 - $DESTMD5) Skipping."
  else
    proc_highdebug "Copied $SOURCEFILE to $DESTFILE OK!"
    rm -f "$SOURCEFILE"    
  fi
}

## Procedure for moving stats.
proc_movestats() {
  ACTIVEMODE="STATS"

  unset SKIP; unset SKIPUP
  unset NEWHUBVALUES; unset NEWSLAVEVALUES; unset NEWVAL1; unset NEWVAL2
  unset last_hub_section; unset last_section

  ## Verify integrity of userfile on source, unless this is a full sync, in which 
  ## case it has already been by the sync.
  if [ "$FULL" != "YES" ]; then
    CHECKPATH="$USERSOURCE"
    proc_highdebug "Checking integrity of $USER on $SOURCENAME"
    proc_userver
    if [ "$VERERR" ]; then
      ERRORLEVEL=2
      proc_debug "Error. Userfile $USER on $SOURCENAME have problems with fields: $VERERR. Skipping."
      ERRORLEVEL=2
      proc_debug "This is usually caused by line lag or nfs timeouts if theres nothing wrong with the userfile."
      proc_statlog "Error. Userfile $USER on $SOURCENAME have problems with fields: $VERERR. Skipping."
      SKIP="YES"
    fi

    ## Verify integrity of userfile on destination..
    if [ "$SKIP" != "YES" ]; then
      CHECKPATH="$USERDEST"
      proc_highdebug "Checking integrity of $USER on $DESTNAME"
      proc_userver
      if [ "$VERERR" ]; then
        ERRORLEVEL=2
        proc_statlog "Error. Userfile $USER on $DESTNAME have problems with fields: $VERERR. Skipping."
        proc_debug "Error. Userfile $USER on $DESTNAME have problems with fields: $VERERR. Skipping."
        SKIP="YES"
      fi
    fi
  fi

  if [ -e $TMP/ERROR.$USER ]; then
    ERRORLEVEL=2
    proc_debug "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    proc_log "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    SKIP="YES"
  fi

  if [ -e "$TMP/TEMPSTATS.$USER.NEW" ]; then
    rm -f "$TMP/TEMPSTATS.$USER.NEW"
    proc_highdebug "Warning. Old temp file detected and deleted: $TMP/TEMPSTATS.$USER.NEW"
  fi
  if [ -e "$TMP/TEMPSTATS.$USER.DEST.NEW" ]; then
    rm -f "$TMP/TEMPSTATS.$USER.DEST.NEW"
    proc_highdebug "Warning. Old temp file detected and deleted: $TMP/TEMPSTATS.$USER.DEST.NEW"
  fi

  if [ "$SKIP" != "YES" ]; then
    proc_debug "Moving Stats from $USER"
    if [ "$RUNLOCAL" = "TRUE" ] && [ "$USERSOURCEORG" ]; then
      ## Set USERSOURCE to the real folder since it shouldnt read stats from
      ## the copied version.
      USERSOURCESTATS="$USERSOURCE"
      USERSOURCE="$USERSOURCEORG"
    fi
  fi

  ## If KEEPSTATS is TRUE, Read DAYUP and DAYDN values to use for adding.
  if [ "$KEEPSTATS" = "TRUE" ]; then
    unset DESTSTATSDN; unset DESTSTATSDN1; unset DESTSTATSDN2; unset DESTSTATSDN3
    unset DESTSTATSUP; unset DESTSTATSUP1; unset DESTSTATSUP2; unset DESTSTATSUP3
    unset SKIPDNSTATS; unset SKIPUPSTATS; unset KEEPSTATS_NEW_SLAVE

    ## Grab the stats from DAYDN on the slave which to add to the other sections on the hub.
    DESTSTATSDN="`grep "^DAYDN " $USERDEST/$USER`"
    if [ -z "$DESTSTATSDN" ]; then
      ERRORLEVEL=2
      proc_debug "Error: Can not read DAYDN from $USERDEST/$USER. Skipping *DN stats"
      proc_highdebug "Error: Can not read DAYDN from $USERDEST/$USER. Skipping *DN stats"
      SKIPDNSTATS="TRUE"
    fi

    ## Grab it for DAYUP too.
    DESTSTATSUP="`grep "^DAYUP " $USERDEST/$USER`"
    if [ -z "$DESTSTATSUP" ]; then
      ERRORLEVEL=2
      proc_debug "Error: Can not read DAYUP from $USERDEST/$USER. Skipping *UP stats"
      proc_highdebug "Error: Can not read DAYUP from $USERDEST/$USER. Skipping *UP stats"
      SKIPUPSTATS="TRUE"
    fi

    ## Make the 0 0 0 we need to put in the userfile instead.
    if [ "$SKIPDNSTATS" != "TRUE" ]; then
      TEMPDEST="`echo "$DESTSTATSDN" | cut -d ' ' -f2-`"
      for TESTDEST2 in $TEMPDEST; do
        KEEPSTATS_NEW_SLAVE="0 $KEEPSTATS_NEW_SLAVE"
      done
    elif [ "$SKIPUPSTATS" != "TRUE" ]; then
      TEMPDEST="`echo "$DESTSTATSUP" | cut -d ' ' -f2-`"
      for TESTDEST2 in $TEMPDEST; do
        KEEPSTATS_NEW_SLAVE="0 $KEEPSTATS_NEW_SLAVE"
      done
    fi
  fi


  ## Move the stats for each defined section in MOVESTATS.

  for CUR_STAT_NAME in $MOVESTATS; do
    unset SKIPUP

    ## Dont do *UP sections if SKIPUPSTATS is TRUE (Can only be set if KEEPSTATS is TRUE, above).
    if [ "$SKIPUPSTATS" = "TRUE" ]; then
      if [ "`echo "$CUR_STAT_NAME" | grep "UP$"`" ]; then
        SKIPUP="YES"
      else
        SKIPUP="NO"
      fi
    fi
      
    if [ "$SKIP" != "YES" -a "$SKIPUP" != "YES" ]; then
      if [ -w $USERSOURCE/$USER ]; then

        if [ "$KEEPSTATS" = "TRUE" ]; then
          if [ "`echo "$CUR_STAT_NAME" | grep "UP$"`" ]; then
            proc_highdebug "This is a UP section ($CUR_STAT_NAME) - Using $DESTSTATSUP"
            DESTVAL="$DESTSTATSUP"
          elif [ "`echo "$CUR_STAT_NAME" | grep "DN$"`" ]; then
            proc_highdebug "This is a DN section ($CUR_STAT_NAME) - Using $DESTSTATSDN"
            DESTVAL="$DESTSTATSDN"
          else
            proc_log "Internal error. Cant see if $CUR_STAT_NAME is UP or DN stats..."
            unset DESTVAL
          fi
        else
          DESTVAL="`grep "^$CUR_STAT_NAME " $USERDEST/$USER`"
        fi

        if [ "$DESTVAL" ]; then

          for CUR_STAT_SECTION in $STAT_SECTIONS; do

            slave_section="`echo "$CUR_STAT_SECTION" | cut -d '>' -f1`"
            hub_section="`echo "$CUR_STAT_SECTION" | cut -d '>' -f2`"
            case $hub_section in
              0) SNUM1=2; SNUM2=3; SNUM3=4; SSED=1 ;;
              1) SNUM1=5; SNUM2=6; SNUM3=7; SSED=2 ;;
              2) SNUM1=8; SNUM2=9; SNUM3=10; SSED=3 ;;
              3) SNUM1=11; SNUM2=12; SNUM3=13; SSED=4 ;;
              4) SNUM1=14; SNUM2=15; SNUM3=16; SSED=5 ;;
              6) SNUM1=17; SNUM2=18; SNUM3=19; SSED=6 ;;
              6) SNUM1=20; SNUM2=21; SNUM3=22; SSED=7 ;;
              7) SNUM1=23; SNUM2=24; SNUM3=25; SSED=8 ;;
              8) SNUM1=26; SNUM2=27; SNUM3=28; SSED=9 ;;
              *) proc_debug "Error in STAT_SECTION ($CUR_STAT_SECTION). Unspecified or wrong hub section ($hub_section). \
Can only be 0-8."; proc_exit ;;
            esac

            case $slave_section in
              0) DNUM1=2; DNUM2=3; DNUM3=4; DSED=1 ;;
              1) DNUM1=5; DNUM2=6; DNUM3=7; DSED=2 ;;
              2) DNUM1=8; DNUM2=9; DNUM3=10; DSED=3 ;;
              3) DNUM1=11; DNUM2=12; DNUM3=13; DSED=4 ;;
              4) DNUM1=14; DNUM2=15; DNUM3=16; DSED=5 ;;
              5) DNUM1=17; DNUM2=18; DNUM3=19; DSED=6 ;;
              6) DNUM1=20; DNUM2=21; DNUM3=22; DSED=7 ;;
              7) DNUM1=23; DNUM2=24; DNUM3=25; DSED=8 ;;
              8) DNUM1=26; DNUM2=27; DNUM3=28; DSED=9 ;;
              *) proc_debug "Error in STAT_SECTION ($CUR_STAT_SECTION). Unspecified or wrong slave section ($slave_section\
). Can only be 0-8."; proc_exit ;;
            esac

            DESTVAL1="`echo $DESTVAL | cut -d ' ' -f$DNUM1`"
            DESTVAL2="`echo $DESTVAL | cut -d ' ' -f$DNUM2`"
            DESTVAL3="`echo $DESTVAL | cut -d ' ' -f$DNUM3`"
            if [ -z "$DESTVAL1" ]; then DESTVAL1="0"; fi
            if [ -z "$DESTVAL2" ]; then DESTVAL2="0"; fi
            if [ -z "$DESTVAL3" ]; then DESTVAL3="0"; fi

            if [ "$DESTVAL1" != "0" -a "$DESTVAL2" != "0" -a "$DESTVAL3" != "0" ]; then
              SOURCEVAL="`grep "^$CUR_STAT_NAME " $USERSOURCE/$USER`"

              if [ "$SOURCEVAL" ]; then

                ## Get total lines of numbers which we will then sed. Dont re-read if we moved another section already.
                ## If we did, use the previously added values.
                if [ "$SLAVENEWVALUES" ]; then
                  DESTTOTAL="`echo $SLAVENEWVALUES`"
                else
                  DESTTOTAL="`echo $DESTVAL | cut -d ' ' -f2-`"
                fi
                if [ "$NEWHUBVALUES" ]; then
                  SOURCETOTAL="$NEWHUBVALUES"
                else
                  SOURCETOTAL="`echo $SOURCEVAL | cut -d ' ' -f2-`"
                fi

                SOURCEVAL1="`echo $SOURCEVAL | cut -d ' ' -f$SNUM1`"
                SOURCEVAL2="`echo $SOURCEVAL | cut -d ' ' -f$SNUM2`"
                SOURCEVAL3="`echo $SOURCEVAL | cut -d ' ' -f$SNUM3`"
                if [ -z "$SOURCEVAL1" ]; then SOURCEVAL1="0"; fi
                if [ -z "$SOURCEVAL2" ]; then SOURCEVAL2="0"; fi
                if [ -z "$SOURCEVAL3" ]; then SOURCEVAL3="0"; fi

                ## Count first and second stat together.
                if [ "$last_hub_section" = "$hub_section" ] && [ "$last_section" = "$CUR_STAT_NAME" ] && [ "$NEWVAL1" ] && [ "$NEWVAL2" ]; then
                  proc_highdebug "Last section on the hub ($last_hub_section) is the same as this one ($hub_section). Adding to previously calculated numbers"
                  NEWVAL1="`echo "$NEWVAL1 + $DESTVAL1" | bc -l | cut -d '.' -f1`"
                  NEWVAL2="`echo "$NEWVAL2 + $DESTVAL2" | bc -l | cut -d '.' -f1`"
                  NEWVAL3="`echo "$NEWVAL3 + $DESTVAL3" | bc -l | cut -d '.' -f1`"
                else
                  NEWVAL1="`echo "$SOURCEVAL1 + $DESTVAL1" | bc -l | cut -d '.' -f1`"
                  NEWVAL2="`echo "$SOURCEVAL2 + $DESTVAL2" | bc -l | cut -d '.' -f1`"
                  NEWVAL3="`echo "$SOURCEVAL3 + $DESTVAL3" | bc -l | cut -d '.' -f1`"
                fi

                if [ "$CUR_STAT_NAME" = "NUKE" ]; then
                  ## NUKE STATS. 1st number shouldnt be merged. Just use the highest number (last time nuked).
                  if [ "$SOURCEVAL1" -gt "$DESTVAL1" ]; then
                    NEWVAL1="$SOURCEVAL1"
                  else
                    NEWVAL1="$DESTVAL1"
                  fi
                else
                  ## Normal STATS. 3rd number shouldnt be merged. Just use the highest number (speed).
                  if [ "$SOURCEVAL3" -gt "$DESTVAL3" ]; then
                    NEWVAL3="$SOURCEVAL3"
                  else
                    NEWVAL3="$DESTVAL3"
                  fi
                fi

                ## Clean it up or it might add another space at the end.
                SOURCETOTAL="`echo $SOURCETOTAL`"

                NEWHUBVALUES="`echo "$SOURCETOTAL " | sed -e "s/[0-9]* [0-9]* [0-9]* /$NEWVAL1 $NEWVAL2 $NEWVAL3 /$SSED"`"
                ## Dont do the slave calculation unless KEEPSTATS=TRUE
                if [ "$KEEPSTATS" != "TRUE" ]; then
                  SLAVENEWVALUES="`echo "$DESTTOTAL " | sed -e "s/[0-9]* [0-9]* [0-9]* /0 0 0 /$DSED"`"
                else
                  ## If KEEPSTATS = TRUE, reset stats if current stat starts with DAY
                  if [ "$KEEPSTATS" = "TRUE" -a "`echo "$CUR_STAT_NAME" | cut -c1-3`" = "DAY" ]; then                  
                    SLAVENEWVALUES="`echo "$DESTTOTAL " | sed -e "s/[0-9]* [0-9]* [0-9]* /0 0 0 /$DSED"`"
                  fi
                fi

                if [ "$NEWVAL1" -a "$NEWVAL2" -a "$NEWVAL3" ]; then
                  proc_debug "$USER $CUR_STAT_NAME Stats for section $hub_section NEW : $NEWVAL1 $NEWVAL2 $NEWVAL3"
                  proc_highdebug "$USER $DESTNAME $CUR_STAT_NAME ($slave_section): $DESTVAL1 $DESTVAL2 $DESTVAL3"
                  proc_highdebug "$USER $SOURCENAME $CUR_STAT_NAME ($hub_section): $SOURCEVAL1 $SOURCEVAL2 $SOURCEVAL3"
                  proc_highdebug "$USER $SOURCENAME NEW $CUR_STAT_NAME ($hub_section): $NEWVAL1 $NEWVAL2 $NEWVAL3"
                  proc_statlog "$USER got new $CUR_STAT_NAME stats: ($DESTNAME($slave_section): $DESTVAL1 $DESTVAL2)+($SOURCENAME($hub_section): $SOURCEVAL1 $SOURCEVAL2)=(NEW($hub_section): $NEWVAL1 $NEWVAL2) SPD: $NEWVAL3"

                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $NEWHUBVALUES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f "$TMP/TEMPSTATS.$USER.1" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
                    else
                      sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $NEWHUBVALUES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi

                    ## Reset stats if KEEPSTATS = TRUE and the stat name starts with DAY. Use KEEPSTATS_NEW_SLAVE
                    if [ "$KEEPSTATS" = "TRUE" -a "`echo "$CUR_STAT_NAME" | cut -c1-3`" = "DAY" ]; then
                      if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                        sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $KEEPSTATS_NEW_SLAVE/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                        mv -f "$TMP/TEMPSTATS.$USER.DEST.1" "$TMP/TEMPSTATS.$USER.DEST.NEW" >/dev/null 2>&1
                      else
                        sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $KEEPSTATS_NEW_SLAVE/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                      fi
                    fi

                    ## Dont reset values on this slave if KEEPSTATS is TRUE (see above).
                    if [ "$KEEPSTATS" != "TRUE" ]; then
                      if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                        sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $SLAVENEWVALUES/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                        mv -f "$TMP/TEMPSTATS.$USER.DEST.1" "$TMP/TEMPSTATS.$USER.DEST.NEW" >/dev/null 2>&1
                      else
                        sed -e "s/^$CUR_STAT_NAME .*/$CUR_STAT_NAME $SLAVENEWVALUES/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                      fi
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"
  
                else
                  proc_highdebug "Warning: Calculating new $CUR_STAT_NAME stats in section $CUR_STAT_SECTION for $USER failed!"
                fi
              else
                proc_highdebug "Error: Can not read $CUR_STAT_NAME from $USERSOURCE/$USER on $DESTNAME - section $CUR_STAT_SECTION"
              fi
            else
              proc_highdebug "Not touching $CUR_STAT_NAME on $USER, section $slave_section - Some stats are empty or 0"
            fi
            last_hub_section="$hub_section"
            last_section="$CUR_STAT_NAME"
          done
        else
          ERRORLEVEL=1
          proc_debug "Error: Can not read $CUR_STAT_NAME from $USERDEST/$USER"
          proc_highdebug "Error: Can not read $CUR_STAT_NAME from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## Unset all values.
    unset DESTVAL1; unset DESTVAL2; unset DESTVAL3; unset DESTVAL
    unset SOURCEVAL1; unset SOURCEVAL2; unset SOURCEVAL3; unset SOURCEVAL
    unset NEWVAL1; unset NEWVAL2; unset NEWVAL3
    unset SLAVENEWVALUES; unset NEWHUBVALUES
  done

  ## NUKE -> THIS ONE MUST BE LAST OF THE STAT SYNCS DUE TO NUKE MB VALUE BUG !!!
  ##
  if [ "$MOVENUKE" = "TRUE" -a "$SKIP" != "YES" ]; then
    unset DESTNUKE1; unset DESTNUKE2; unset DESTNUKE3; unset DESTNUKE
    unset SOURCENUKE1; unset SOURCENUKE2; unset SOURCENUKE3; unset SOURCENUKE
    unset NEWNUKE1; unset NEWNUKE2; unset NEWNUKE3
    if [ -w "$USERSOURCE/$USER" ]; then
      DESTNUKE="`grep "^NUKE " $USERDEST/$USER`"
      if [ "$DESTNUKE" ]; then
        DESTNUKE1="`echo $DESTNUKE | cut -d ' ' -f2`"
        DESTNUKE2="`echo $DESTNUKE | cut -d ' ' -f3`"
        DESTNUKE3="`echo $DESTNUKE | cut -d ' ' -f4`"
        if [ -z "$DESTNUKE1" ]; then
          DESTNUKE1="0"
        fi
        if [ -z "$DESTNUKE2" ]; then
          DESTNUKE2="0"
        fi
        if [ -z "$DESTNUKE3" ]; then
          DESTNUKE3="0"
        fi

        if [ "`echo $DESTNUKE3 | grep "........"`" ]; then
          if [ "$AUTONUKERESET" != "TRUE" ]; then
            proc_log "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right. Aborting."
            proc_log "I have seen glftpd fuck up this number when nuking someone, thats why I added this check here so his stats does not go into the negative on the hub."
            proc_log "Set this users nuke stats to 0 0 0 on the slave or set AUTONUKERESET to TRUE in the config."
            ERRORLEVEL=2
            proc_debug "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right. Aborting."
            proc_debug "I have seen glftpd fuck up this number when nuking someone, thats why I added this check here so his stats does not go into the negative on the hub."
            proc_debug "Set this users nuke stats to 0 0 0 on the slave."
            SKIP="YES"
          else
            ERRORLEVEL=2
            proc_log "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right."
            proc_debug "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right."

            ## OK, So we have a bugged userfile. If there are other stuff to move to hub, reset values.
            ## If not, dont. The moving process at the end requires 2 userfiles, and just a reset on
            ## the slave will cause a problem because it needs a userfile to go with the source too ( which it dosnt ).

            if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
              ERRORLEVEL=2
              proc_log "AUTONUKERESET is TRUE so resetting this users NUKE values to 0 0 0."
              proc_debug "AUTONUKERESET is TRUE so resetting this users NUKE values to 0 0 0."
              sed -e "s/^NUKE [0-9]* [0-9]* [0-9]*/NUKE 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
              mv -f "$TMP/TEMPSTATS.$USER.DEST.1" "$TMP/TEMPSTATS.$USER.DEST.NEW" >/dev/null 2>&1
              NEWEXISTS="TRUE"
            else
              ERRORLEVEL=2
              proc_debug "Nothing to move to source it seems. Resetting NUKE value on $DESTNAME when we have something to move"
              proc_log "Nothing to move to source it seems. Resetting NUKE value on $DESTNAME when we do have something to move."
              SKIP="YES"
            fi
            DESTNUKE1=0
            DESTNUKE2=0
            DESTNUKE3=0
            sleep $SLOWTIME
          fi
        fi

        if [ "$DESTNUKE1" != "0" -a "$DESTNUKE2" != "0" -a "$DESTNUKE3" != "0" -a "$SKIP" != "YES" ]; then
          SOURCENUKE="`grep "^NUKE " $USERSOURCE/$USER`"
          if [ "$SOURCENUKE" ]; then
            SOURCENUKE1="`echo $SOURCENUKE | cut -d ' ' -f2`"
            SOURCENUKE2="`echo $SOURCENUKE | cut -d ' ' -f3`"
            SOURCENUKE3="`echo $SOURCENUKE | cut -d ' ' -f4`"
            if [ -z "$SOURCENUKE1" ]; then
              SOURCENUKE1="0"
            fi
            if [ -z "$SOURCENUKE2" ]; then
              SOURCENUKE2="0"
            fi
            if [ -z "$SOURCENUKE3" ]; then
              SOURCENUKE3="0"
            fi

            ## First number is how long ago. Highest number counts.
            if [ "$SOURCENUKE1" -gt "$DESTNUKE1" ]; then
              NEWNUKE1="$SOURCENUKE1"
            else
              NEWNUKE1="$DESTNUKE1"
            fi

            NEWNUKE2="`echo "$SOURCENUKE2 + $DESTNUKE2" | bc -l | cut -d '.' -f1`"
            NEWNUKE3="`echo "$SOURCENUKE3 + $DESTNUKE3" | bc -l | cut -d '.' -f1`"

            if [ "$NEWNUKE1" != "" -a "$NEWNUKE2" != "" -a "$NEWNUKE3" != "" ]; then
              proc_debug "$USER NUKE Stats NEW : $NEWNUKE1 $NEWNUKE2 $NEWNUKE3"
              proc_highdebug "$USER $DESTNAME NUKE : $DESTNUKE1 $DESTNUKE2 $DESTNUKE3"
              proc_highdebug "$USER $SOURCENAME NUKE : $SOURCENUKE1 $SOURCENUKE2 $SOURCENUKE3"
              proc_statlog "$USER got new NUKE stats: ($DESTNAME: $DESTNUKE2 $DESTNUKE3)+($SOURCENAME: $SOURCENUKE2 $SOURCENUKE3)=(NEW: $NEWNUKE2 $NEWNUKE3) TIME: $NEWNUKE1"
              if [ -r $USERSOURCE/$USER ]; then
                if [ -r $USERDEST/$USER ]; then
                  if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                    sed -e "s/^NUKE [0-9]* [0-9]* [0-9]*/NUKE $NEWNUKE1 $NEWNUKE2 $NEWNUKE3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                    mv -f "$TMP/TEMPSTATS.$USER.1" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
                  else
                    sed -e "s/^NUKE [0-9]* [0-9]* [0-9]*/NUKE $NEWNUKE1 $NEWNUKE2 $NEWNUKE3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                  fi
                  if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                    sed -e "s/^NUKE [0-9]* [0-9]* [0-9]*/NUKE 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                    mv -f "$TMP/TEMPSTATS.$USER.DEST.1" "$TMP/TEMPSTATS.$USER.DEST.NEW" >/dev/null 2>&1
                  else
                    sed -e "s/^NUKE [0-9]* [0-9]* [0-9]*/NUKE 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                  fi
                  sleep $SLOWTIME
                  NEWEXISTS="TRUE"

                  ## NEW 2003-01-24 by turranius. 
                  ## Withdraw nuke bytes from stats on hub.
                  ## Files are not stored in NUKE field so cant subtract that.

                  ## GO with nuke withdraw
                  if [ "$WITHDRAWNUKE" -a "$SKIP" != "YES" ]; then
                    ## Nuke amount is in MB. Convert to KB to match stats.
                    NUKEBYTES="`echo "$DESTNUKE3 * 1024" | bc -l | cut -d '.' -f1`"
                    proc_highdebug "Got nuke. Starting to withdraw $NUKEBYTES bytes from $USER."
                  fi

                  for CUR_STAT_NAME in $WITHDRAWNUKE; do
                    if [ "`echo "$CUR_STAT_NAME" | grep "DN$"`" ]; then
                      ERRORLEVEL=2
                      proc_debug "Error in WITHDRAWNUKE. Do NOT specify *DN sections. Nukes should only be subtraced to *UP"
                      proc_statlog "Error in WITHDRAWNUKE. Do NOT specify *DN sections. Nukes should only be subtraced to *UP"
                    fi

                    unset SOURCEVAL; unset SOURCEVALFILES; unset SOURCEVALBYTES; unset SOURCEVALTIMES; unset NEWVALBYTES
                    ## Does a .NEW file exist for this user? If so, read the stats for ALUP from there.
                    ## If not, read from source userfile. If we dont do this, it will read unmodified values
                    ## which might have been changed by the move we do above this one.
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      SOURCEVAL="`grep "^$CUR_STAT_NAME " $TMP/TEMPSTATS.$USER.NEW`"
                    else
                      SOURCEVAL="`grep "^$CUR_STAT_NAME " $USERSOURCE/$USER`"
                    fi
                    if [ ! -z "$SOURCEVAL" ]; then
                      SOURCEVALFILES="`echo $SOURCEVAL | cut -d ' ' -f2`"
                      SOURCEVALBYTES="`echo $SOURCEVAL | cut -d ' ' -f3`"
                      SOURCEVALTIMES="`echo $SOURCEVAL | cut -d ' ' -f4`"
                      if [ -z "$SOURCEVALBYTES" ]; then SOURCEVALBYTES="0"; fi

                      if [ "$SOURCEVALBYTES" = "0" ]; then
                        proc_highdebug "Nuke Discount: $CUR_STAT_NAME bytes are already at 0 on hub. Wont go below that."
                      else
                        proc_highdebug "$USER $SOURCENAME $CUR_STAT_NAME : $SOURCEVALFILES $SOURCEVALBYTES $SOURCEVALTIMES"
                        NEWVALBYTES="`echo "$SOURCEVALBYTES - $NUKEBYTES" | bc -l | cut -d '.' -f1`"
                        if [ "$NEWVALBYTES" -lt "0" ]; then
                          proc_highdebug "Warning. New $CUR_STAT_NAME bytes would go below 0 ($NEWVALBYTES). Setting it at 0."
                          NEWVALBYTES="0"
                        fi
                        if [ ! -z "$NEWVALBYTES" ] && [ ! -z "$SOURCEVALFILES" ] && [ ! -z "$SOURCEVALTIMES" ]; then
                          proc_statlog "$USER got new $CUR_STAT_NAME stats after nuke subtract of $NUKEBYTES KB: $SOURCEVALFILES $NEWVALBYTES $SOURCEVALTIMES"
                          proc_debug "$USER got new $CUR_STAT_NAME stats after nuke subtract of $NUKEBYTES KB: $SOURCEVALFILES $NEWVALBYTES $SOURCEVALTIMES"
                          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                            sed -e "s/^$CUR_STAT_NAME [0-9]* [0-9]* [0-9]*/$CUR_STAT_NAME $SOURCEVALFILES $NEWVALBYTES $SOURCEVALTIMES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                            mv -f "$TMP/TEMPSTATS.$USER.1" "$TMP/TEMPSTATS.$USER.NEW" >/dev/null 2>&1
                          else
                            sed -e "s/^$CUR_STAT_NAME [0-9]* [0-9]* [0-9]*/$CUR_STAT_NAME $SOURCEVALFILES $NEWVALBYTES $SOURCEVALTIMES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                          fi
                        else
                          ERRORLEVEL=2
                          proc_log "Error when withdrawing $CUR_STAT_NAME stats on $SOURCENAME from nuke. Some variables empty."
                          proc_debug "Error when withdrawing $CUR_STAT_NAME stats on $SOURCENAME from nuke. Some variables empty."
                          SKIP="YES"
                        fi
                      fi
                    else
                      ERRORLEVEL=2
                      proc_log "Nuke Withdraw: Error getting current $CUR_STAT_NAME line from source userfile."
                      proc_debug "Nuke Withdraw: Error getting current $CUR_STAT_NAME line from source userfile."
                      SKIP="YES"
                    fi
                  done ## End loop of move nuke.

                else
                  proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                fi
              else
                proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
              fi
            else
              proc_highdebug "Warning: Calculating new NUKE stats for $USER failed!"
            fi
          else
            proc_highdebug "Error: Can not read NUKE from $USERSOURCE/$USER"
          fi
        else
          proc_highdebug "Not touching NUKE on $USER - Some stats are empty or 0"
        fi
      else
        proc_highdebug "Error: Can not read NUKE from $USERDEST/$USER"
      fi
    else
      proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
    fi
  fi

  ## Verify new file integrity and copy to destinations if ok.
  if [ "$NEWEXISTS" = "TRUE" ]; then
    if [ "$USERSOURCEORG" ]; then
      if [ -w "$USERSOURCEORG/$USER" ]; then
        SOURCEOK="YES"
        SOURCEPATH="$USERSOURCEORG"
      fi
    else
      if [ -w "$USERSOURCE/$USER" ]; then
        SOURCEOK="YES"
        SOURCEPATH="$USERSOURCE"
      fi
    fi
    if [ -w "$USERDEST/$USER" ]; then
      if [ "$SOURCEOK" = "YES" ]; then
        ## Check newly created file ment for source.
        CHECKPATH="$TMP"
        TMPUSER="$USER"
        USER="TEMPSTATS.$USER.NEW"
        proc_highdebug "Checking integrity of new source file $CHECKPATH/$USER"
        proc_userver
        if [ "$VERERR" ]; then
          SKIP="YES"
          ERRORLEVEL=2
          proc_debug "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
          proc_log "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
          SCRIPTNAME="$( basename $0 )"
          echo "" >> $TMP/$USER
          echo "---New file that $SCRIPTNAME created above. Old one from $SOURCEPATH/$TMPUSER below---" >> $TMP/$USER
          echo "-- This file was created on "`date` >> $TMP/$USER
          echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
          echo "" >> $TMP/$USER
          cat $SOURCEPATH/$TMPUSER >> $TMP/$USER
          if [ ! -e $TMP/ERROR.$USER ]; then
            mv -f "$TMP/$USER" "$TMP/ERROR.$USER" >/dev/null 2>&1
          else
            rm -f $TMP/$USER
          fi
        fi
        ## Restore arguments
        USER="$TMPUSER"
        unset TMPUSER
        unset CHECKPATH

        ## Check newly created file ment for destination, if there is one..
        if [ -e "TEMPSTATS.$USER.DEST.NEW" ]; then
          CHECKPATH="$TMP"
          TMPUSER="$USER"
          USER="TEMPSTATS.$USER.DEST.NEW"
          proc_highdebug "Checking integrity of new destination file $CHECKPATH/$USER"
          proc_userver
          if [ "$VERERR" != "" ]; then
            ERRORLEVEL=2
            proc_debug "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
            proc_log "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
            SKIP="YES"
            SCRIPTNAME="$( basename $0 )"
            echo "" >> $TMP/$USER
            echo "---New file that $SCRIPTNAME created above. Old one from $USERDEST/$TMPUSER below---" >> $TMP/$USER
            echo "-- This file was created on "`date` >> $TMP/$USER
            echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
            echo "" >> $TMP/$USER
            cat $USERDEST/$TMPUSER >> $TMP/$USER
            if [ ! -e $TMP/ERROR.$USER ]; then
              mv -f "$TMP/$USER" "$TMP/ERROR.$USER" >/dev/null 2>&1
            else
              rm -f $TMP/$USER
            fi
          fi
          ## Restore arguments
          USER="$TMPUSER"
          unset TMPUSER
          unset CHECKPATH
        fi

        if [ "$SKIP" != "YES" ]; then
          ## Lock both userfiles. If one fails, dont move any stats.
          proc_lock_src
          if [ "$SKIP" != "YES" ]; then
            proc_lock_dst
            if [ "$SKIP" = "YES" ]; then
              proc_unlock_src
            fi
          fi
          if [ "$USERSOURCEORG" ]; then
            if [ "$SKIP" != "YES" ]; then
              SOURCEFILE="$TMP/TEMPSTATS.$USER.NEW"
              DESTFILE="$USERSOURCEORG/$USER"
              proc_moveverify
              proc_unlock_src
            fi
          else
            if [ "$SKIP" != "YES" ]; then
              SOURCEFILE="$TMP/TEMPSTATS.$USER.NEW"
              DESTFILE="$USERSOURCE/$USER"
              proc_moveverify
              proc_unlock_src
            fi
          fi
          if [ "$SKIP" != "YES" ]; then
            if [ -e "$TMP/TEMPSTATS.$USER.DEST.NEW" ]; then
              SOURCEFILE="$TMP/TEMPSTATS.$USER.DEST.NEW"
              DESTFILE="$USERDEST/$USER"
              proc_moveverify
#              mv -f "$TMP/TEMPSTATS.$USER.DEST.NEW" "$USERDEST/$USER" >/dev/null 2>&1
            fi
          fi
          proc_unlock_dst
        fi
      else
        ERRORLEVEL=2
        proc_debug "Error: Can not write to $SOURCEPATH/$USER - No stats moved for this user."
        proc_highdebug "Error: Can not write to $SOURCEPATH/$USER"
      fi
    else
      ERRORLEVEL=2
      proc_debug "Error: Can not write to $USERDEST/$USER - No stats moved for this user."
      proc_highdebug "Error: Can not write to $USERDEST/$USER"
    fi
    SOURCEOK="NO"
    NEWEXISTS="FALSE"
    unset SOURCEPATH
  fi

  SKIP="NO"
  if [ "$SLOWTIME" != "" ]; then
    sleep $SLOWTIME
  fi
  unset ACTIVEMODE

  ## Setting back USERSOURCE to point at where it was before
  ## we started moving stats.
  if [ "$USERSOURCESTATS" ]; then
    USERSOURCE="$USERSOURCESTATS"
    unset USERSOURCESTATS
  fi
}

## Copy files to local computer if its on.
proc_copylocal() {
  unset BFILE
  if [ "$RUNLOCAL" = "TRUE" ]; then
    if [ ! -e $TMP/autosync.source.users ]; then
      mkdir $TMP/autosync.source.users
      chmod $PERMS $TMP/autosync.source.users >/dev/null 2>&1
    fi
    proc_highdebug "Removing all old files in $TMP/autosync.source.users"
    rm -f $TMP/autosync.source.users/*

    proc_debug "Copying $USERSOURCE files to $TMP/autosync.source.users to run from there."
    proc_highdebug "Copying $USERSOURCE files to $TMP/autosync.source.users"
    if [ "$DEBUG" = "TRUE" ]; then
      cp -f -v $USERSOURCE/* $TMP/autosync.source.users
    else
      cp -f $USERSOURCE/* $TMP/autosync.source.users >/dev/null 2>&1
    fi
    proc_highdebug "Copy complete. Setting USERSOURCE to $TMP/autosync.source.users"
    USERSOURCEORG="$USERSOURCE"
    USERSOURCE=$TMP/autosync.source.users
  fi  
}

## Backup files.
proc_backup() {
  if [ "$BACKUPDEST" ]; then
    proc_verify_backup_dir
    if [ -w "$BACKUPDEST" ]; then
      if [ -z "$BFILE" ]; then
        BFILE="$( date +%m%d%y"-"%H%M )"
      fi

      ## Backup source files.
      if [ "$RUNLOCAL" = "TRUE" ]; then
        if [ "$BACKUPDEST" != "" ]; then
          BFILE="$( date +%m%d%y"-"%H%M )"
          proc_highdebug "Backing up userfiles from $SOURCENAME to $BACKUPDEST/autosync.source.$BFILE.tar.gz"
          proc_debug "Backing up userfiles from $SOURCENAME to $BACKUPDEST/autosync.source.$BFILE.tar.gz"
          tar -zcf $BACKUPDEST/autosync.source.$BFILE".tar.gz" $TMP/autosync.source.users >/dev/null 2>&1
        fi
      fi

      ## Backup destination files.
      proc_highdebug "Backing up userfiles from $DESTNAME to $BACKUPDEST/autosync.$BFILE.tar.gz"
      proc_debug "Backing up userfiles from $DESTNAME to $BACKUPDEST/autosync.$BFILE.tar.gz"
      tar -zcf $BACKUPDEST/autosync.$BFILE".tar.gz" $USERDEST/* $PASSWDDEST/group $PASSWDDEST/passwd >/dev/null 2>&1
      amount="$( ls $BACKUPDEST | wc -l | tr -d ' ' )"
      if [ -e $BACKUPDEST/deleted ]; then
        MAXBACKUPS="$( echo "$MAXBACKUPS + 1" | bc -l | cut -d '.' -f1 )"
      fi
      if [ "$amount" -gt "$MAXBACKUPS" ]; then
        del="$( echo "$amount - $MAXBACKUPS" | bc -l | cut -d '.' -f1  )"
        if [ "$del" -gt "0" ]; then
          ## Saving old way just incase..
          ## for old in `ls -tl $BACKUPDEST | grep -v deleted | tail -n $del | cut -d ' ' -f9`; do
          for old in `ls -t $BACKUPDEST | grep -v deleted | tail -n $del`; do
            if [ "$old" != "" ]; then
              rm -f $BACKUPDEST/$old
              proc_highdebug "More then $MAXBACKUPS backups. Deleting old backup: $old"
              proc_debug "Deleting old backup: $old"
            fi
          done
        fi
      fi
    fi
  fi
}

## Verify that the verifyuser can be read.
proc_verifylink() {
  proc_highdebug "Verifying that link is up by reading user $VERIFYUSER on $SOURCENAME"
  if [ ! -r $USERSOURCE/$VERIFYUSER ]; then
    ERRORLEVEL=1
    echo "Verify user $VERIFYUSER on source does not exist - Link down?"
    proc_exit
  else
    verify="$( grep "^FLAGS " $USERSOURCE/$VERIFYUSER )"
    if [ "$verify" = "" ]; then
      ERRORLEVEL=1
      echo "Verify user $VERIFYUSER on source exists but cant read FLAGS field - Link down?"
      proc_exit
    fi
  fi
}

## Set permissions.
proc_setperms() {
  if [ "$PERMS" != "" ]; then
    proc_highdebug "Setting $PERMS on $USERSOURCE"
    proc_debug "Settings permissions on $USERSOURCE."
    chmod $PERMS $USERSOURCE/* >/dev/null 2>&1

    if [ "$USERSOURCEORG" != "" ]; then
      proc_highdebug "Setting $PERMS on $USERSOURCEORG"
      proc_debug "Settings permissions on $USERSOURCEORG."
      chmod $PERMS $USERSOURCEORG/* >/dev/null 2>&1
    fi

    proc_highdebug "Setting $PERMS on $USERDEST"
    proc_debug "Settings permissions on $USERDEST."
    chmod $PERMS $USERDEST/* >/dev/null 2>&1

#    proc_highdebug "Setting $PERMS on $TMP"
#    proc_debug "Settings permissions on $TMP"
#    chmod -R $PERMS $TMP >/dev/null 2>&1
  fi  
}

## Send logs from slave to hub. Only ment as an actionfile action. Not from shell.
proc_fetchlog() {
  if [ ! -z "$FETCHLOGSDIR" ]; then
    proc_verifylink
    if [ -w "$FETCHLOGSDIR" ]; then
      if [ "$LOG" != "" ]; then
        LOGNAME="$( basename $LOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $LOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
      if [ "$STATLOG" != "" -a "$STATLOG" != "$LOG" ]; then
        LOGNAME="$( basename $STATLOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $STATLOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
      if [ "$HIGHDEBUGLOG" != "" -a "$HIGHDEBUGLOG" != "$LOG" -a "$HIGHDEBUGLOG" != "$STATLOG" ]; then
        LOGNAME="$( basename $HIGHDEBUGLOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $HIGHDEBUGLOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
    else
      mkdir $FETCHLOGSDIR >/dev/null 2>&1
      chmod $PERMS $FETCHLOGSDIR >/dev/null 2>&1
      if [ ! -w $FETCHLOGSDIR/ ]; then      
        ERRORLEVEL=3
        proc_log "Error: Cannot write to $FETCHLOGSDIR so no logs copied."
        proc_debug "Error: Fetchlog: Cannot write to $FETCHLOGSDIR so no logs copied."
      fi
    fi
  else
    ERRORLEVEL=3
    proc_log "Error: FETCHLOGSDIR is empty in config so cant fetch logs."
    proc_debug "Error: Fetchlog: FETCHLOGSDIR is empty in config. Cant fetch logs."
  fi
}

## Check if group file is up to date.
proc_groupsync() {
  if [ -w $PASSWDDEST/group ]; then
    destsum="`$MD5BIN $PASSWDDEST/group | cut -d ' ' -f1`"
    sourcesum="`$MD5BIN $PASSWDSOURCE/group | cut -d ' ' -f1`"
    if [ "$destsum" != "$sourcesum" ]; then
      cp -f $PASSWDSOURCE/group $TMP/group.tmp
      newsum="`$MD5BIN $TMP/group.tmp | cut -d ' ' -f1`"
      if [ "$newsum" = "$sourcesum" ]; then
        mv -f "$TMP/group.tmp" "$PASSWDDEST/group" >/dev/null 2>&1
        proc_debug "group file synced with source"
        proc_log "group file synced with source"
      else
        ERRORLEVEL=1
        proc_debug "Error: After copy, the md5sum on group does not match the original. Not syncing."
        ERRORLEVEL=1
        proc_debug " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        proc_log "Error: After copy, the md5sum on group does not match the original. Not syncing."
        proc_log " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        rm -f $TMP/group.tmp
      fi
    else
      proc_debug "group file do not need syncing. md5sum: $destsum"
      proc_highdebug "group file is up to date."
    fi
    unset destsum; unset sourcesum
  else
    ERRORLEVEL=3
    proc_debug "group file non existing on destination. Grabbing it"
    proc_log "group file non existing on destination. Grabbing it"
    cp -f $PASSWDSOURCE/group $PASSWDDEST/group
  fi

  ## For glftpd 2.0. Sync group files too here.
#  if [ "$ACTIONFILE" ]; then
#    proc_syncgroupfiles
#  fi
}

## Check if passwd is up to date
proc_passwdsync() {
  if [ -w $PASSWDDEST/passwd ]; then
    destsum="`$MD5BIN $PASSWDDEST/passwd | cut -d ' ' -f1`"
    sourcesum="`$MD5BIN $PASSWDSOURCE/passwd | cut -d ' ' -f1`"
    if [ "$destsum" != "$sourcesum" ]; then
      cp -f $PASSWDSOURCE/passwd $TMP/passwd.tmp
      newsum="`$MD5BIN $TMP/passwd.tmp | cut -d ' ' -f1`"
      if [ "$newsum" = "$sourcesum" ]; then
        mv -f "$TMP/passwd.tmp" "$PASSWDDEST/passwd" >/dev/null 2>&1
        proc_debug "passwd file synced with source"
        proc_log "passwd file synced with source"
      else
        ERRORLEVEL=3
        proc_debug "Error: After copy, the md5sum on passwd does not match the original. Not syncing."
        proc_debug " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        proc_log "Error: After copy, the md5sum on passwd does not match the original. Not syncing."
        proc_log " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        rm -f $TMP/passwd.tmp
      fi
    else
      proc_debug "passwd file do not need syncing. md5sum: $destsum"
      proc_highdebug "passwd file is up to date."
    fi
    unset destsum; unset sourcesum; unset newsum
  else
    ERRORLEVEL=3
    proc_debug "passwd file non existing on destination. Grabbing it"
    proc_log "passwd file non existing on destination. Grabbing it."
    cp -f $PASSWDSOURCE/passwd $PASSWDDEST/passwd
  fi
}

## Proc for verifying hub files integrity.
proc_sourceuserscheck() {
  proc_highdebug "Verifying that all users have an entry in passwd on $SOURCENAME"
  proc_debug "Verifying that all users have an entry in passwd on $SOURCENAME"

  for USER in `grep "^FLAGS " $USERSOURCE/* | cut -d ' ' -f1 | cut -d ':' -f1 | egrep -v $EXCLUDE`; do

    proc_countpong

    USER="`basename "$USER"`"
    unset PASSWDCHECK
    PASSWDCHECK="`grep "^$USER:" $PASSWDSOURCE/passwd`"
    if [ -z "$PASSWDCHECK" ]; then
      ERRORLEVEL=3
      proc_debug "Error: $USERSOURCE/$USER does not have an entry in the passwd on $SOURCENAME!"
      proc_log "Error: $USERSOURCE/$USER does not have an entry in the passwd on $SOURCENAME!"
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: $USERSOURCE/$USER does not have an entry in the passwd on $SOURCENAME!"
      fi
      GOTERROR="YES"
    fi
  done

  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All users have an entry in passwd."
    proc_log "All users have an entry in passwd on $SOURCENAME."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All users have an entry in passwd on $SOURCENAME."
    fi
  else
    unset GOTERROR
  fi
  proc_highdebug "Verifying that all users in passwd exists and are correct on $SOURCENAME"
  proc_debug "Verifying that all users in passwd exists and are correct on $SOURCENAME"

  for USER in `cat $PASSWDSOURCE/passwd | cut -d ':' -f1`; do

    proc_countpong

    if [ -e "$USERSOURCE/$USER" ]; then
      CHECKPATH="$USERSOURCE"
      proc_userver
      if [ "$VERERR" != "" ]; then
        ERRORLEVEL=3
        proc_debug "Error: User $USERSOURCE/$USER have a problem with the fields: $VERERR."
        proc_log "Error: User $USERSOURCE/$USER have a problem with the fields: $VERERR."
        if [ ! -z "$ACTIONFILE" ]; then
          proc_msslog "Error: User $USERSOURCE/$USER have a problem with the fields: $VERERR."
        fi
        GOTERROR="YES"
      fi
    else
      ERRORLEVEL=3
      proc_debug "Error: User $USERSOURCE/$USER exists in passwd but no userfile found on $SOURCENAME."
      proc_log "Error: User $USERSOURCE $USER exists in passwd but no userfile found on $SOURCENAME."
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: User $USERSOURCE $USER exists in passwd but no userfile found on $SOURCENAME."
      fi
      GOTERROR="YES"
    fi
  done
  
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All passwd entries match a userfile. No corrupt userfiles detected."
    proc_log "All passwd entries match a userfile on $SOURCENAME. No corrupt userfiles detected."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All passwd entries match a userfile on $SOURCENAME."
    fi
  else
    unset GOTERROR
  fi
}

## Proc for verifying slave files integrity.
proc_destuserscheck() {
  DELMSSLOG="FALSE" ## This is done with another proc.
  proc_highdebug "Verifying that all users have an entry in passwd on $DESTNAME"
  proc_debug "Verifying that all users have an entry in passwd on $DESTNAME"
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Verifying that all users have an entry in passwd on $DESTNAME"
  fi

  for USER in `grep "^FLAGS " $USERDEST/* | cut -d ' ' -f1 | cut -d ':' -f1 | egrep -v "$EXCLUDE"`; do

    proc_countpong

    USER="`basename "$USER"`"
    unset PASSWDCHECK
    PASSWDCHECK="`grep "^$USER:" $PASSWDDEST/passwd`"
    if [ -z "$PASSWDCHECK" ]; then
      ERRORLEVEL=3
      proc_debug "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      proc_log "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      fi
      GOTERROR="YES"
    fi
  done
  
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All users have an entry in passwd."
    proc_log "All users have an entry in passwd on $DESTNAME."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All users have an entry in passwd on $DESTNAME."
    fi
  else
    unset GOTERROR
  fi
  proc_highdebug "Verifying that all users in passwd exists and are correct on $DESTNAME"
  proc_debug "Verifying that all users in passwd exists and are correct on $DESTNAME"
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Verifying that all users in passwd exists and are correct on $DESTNAME"
  fi

  for USER in `cat $PASSWDDEST/passwd | cut -d ':' -f1`; do

    proc_countpong

    if [ -e "$USERDEST/$USER" ]; then
      CHECKPATH="$USERDEST"
      proc_userver
      if [ "$VERERR" ]; then
        ERRORLEVEL=3
        proc_debug "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        proc_log "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        if [ ! -z "$ACTIONFILE" ]; then    
          proc_msslog "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        fi
        GOTERROR="YES"
      fi
    else
      ERRORLEVEL=3
      proc_debug "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      proc_log "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      fi
      GOTERROR="YES"
    fi
  done
  
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All passwd entries match a userfile. No corrupt userfiles detected."
    proc_log "All passwd entries match a userfile on $DESTNAME. No corrupt userfiles detected."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All passwd entries match a userfile on $DESTNAME. No corrupt userfiles detected."
    fi
  else
    unset GOTERROR
  fi
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Report complete."
    chmod $PERMS $FETCHLOGSDIR/$DESTNAME.report >/dev/null 2>&1
  fi
}

## Clear out this slaves reportfile on the hub.
proc_delreport() {
  DELMSSLOG="TRUE"
  proc_msslog "Report cleared"
  proc_highdebug "Got command to clear report file on the hub... doing that."
  proc_debug "DELREPORT activated. Clearing out reportfile."
}

## Delete users from destination, if they are not on source.
proc_deluser() {

  if [ "$USERSOURCEORG2" != "" ]; then
    USERSOURCE="$USERSOURCEORG2"
    proc_debug "Switching to $USERSOURCEORG2 to continue checking."
    proc_highdebug "Switching to $USERSOURCEORG2 to continue checking."
    USERSOURCEORG2=""
  fi

  unset EXISTS
  if [ -e $USERSOURCE/$USER ]; then
    EXISTS="YES"
    proc_highdebug "Delete user?: $USER = NO."
  else
    EXISTS="NO"
    if [ "$USERSOURCEORG" ]; then
      proc_highdebug "Delete user?: $USER = YES. Cant see it on $SOURCENAME. Checking more."
      proc_highdebug "Switching back to $USERSOURCEORG to run more checks."
      USERSOURCEORG2="$USERSOURCE"
      USERSOURCE="$USERSOURCEORG"
    else
      proc_highdebug "Delete user?: $USER = YES. Cant see it on $SOURCENAME. Running more checks."
    fi
  fi
  if [ "$EXISTS" = "NO" ]; then
    sleep 1
    if [ -r "$USERSOURCE/$VERIFYUSER" ]; then
      proc_highdebug "Delete user: $VERIFYUSER can be read. Link must be up."
      if [ ! -e "$USERSOURCE/$USER" ]; then
        proc_highdebug "Delete user: $USER cant be read on $SOURCENAME - Verifying with passwd."
        PASSWDCHECK=""
        if [ -r "$PASSWDSOURCE/passwd" ]; then
          PASSWDCHECK="$( grep "^$USER:" $PASSWDSOURCE/passwd )"
          if [ -z "$PASSWDCHECK" ]; then
            proc_highdebug "Delete user: $USER not found in $PASSWDSOURCE/passwd either."
            if [ "$BACKUPDEST" ]; then
              proc_verify_backup_dir
              mv -f "$USERDEST/$USER" "$BACKUPDEST/deleted" >/dev/null 2>&1
              proc_highdebug "$USER - Moved to $BACKUPDEST/deleted/$SUER"
            else
              proc_highdebug "$USER - No backuppath defined. Deleting userfile."
              rm -f $USERDEST/$USER
            fi
            proc_debug "$USER - Deleted. Not on source anymore"
            proc_log "$USER - Deleted"
            SKIPPING="$USER"
          else
            ## CHG: 2003-01-20 void0
            ## Added the restoreuser check if the deleted user exists in passwd.
            proc_highdebug "Delete user: $USER FOUND in $PASSWDSOURCE/passwd - No delete on $DESTNAME!"
            proc_restoreuser $USER
            if [ ! -z "$BACKUPFILE" ]; then
              proc_highdebug "Restoring $USER from $BACKUPFILE"
              ERRORLEVEL=1
              proc_debug "Restoring $USER from $BACKUPFILE"

              TMPDIR="$TMP/unpack"
              mkdir "$TMPDIR"
              tar zxf "$BACKUPFILE" -C "$TMPDIR"
              if [ -e "$TMPDIR/$TMP/autosync.source.users/$USER" ]; then
                cp -f "$TMPDIR/$TMP/autosync.source.users/$USER" "$USERSOURCE/$USER"
                if [ -e "$USERSOURCE/$USER" ]; then
                  ERRORLEVEL=1
                  proc_log "Success! $USER restored from backup on $SOURCENAME"
                  proc_debug "Success! $USER restored from backup on $SOURCENAME"
                else
                  ERRORLEVEL=1
                  proc_log "Error! $USER was restored, but he still is not found on $SOURCENAME"
                  proc_debug "Error! $USER was restored, but he still is not found on $SOURCENAME"
                  SKIP="YES"
                fi
              else
                SKIP="YES"
                proc_debug "$USER not found in latest backup from hub.. skipping him."
                ERRORLEVEL=1
                proc_log "Error. $USER exists in passwd from hub, but no userfile on hub."
                ERRORLEVEL=1
                proc_log "He is neither found in the backups from this slave. You should either"
                ERRORLEVEL=1
                proc_log "remove him from the passwd or make a new userfile..."
              fi
              rm -rf "$TMPDIR"
            else
              proc_highdebug "Delete user: Note - Above might mean the passwd and userfiles are not in sync at source site"
            fi
          fi
        else
          proc_highdebug "Link lost? Cant read $PASSWDSOURCE/passwd anymore."
        fi
      else
        proc_highdebug "Delete user: $USER found now. No delete!"
      fi
    else
      ERRORLEVEL=1
      proc_debug "Seems I lost contact. Not deleting $USER"
      proc_log "Lost link I think. Not deleting $USER"
    fi
  fi
}

## Stat log proc
proc_statlogsetup() {
  if [ "$STATSLOG" != "" ]; then
    if [ ! -w "$STATLOG" ]; then
      touch $STATLOG
      chmod 777 $STATLOG >/dev/null 2>&1
    fi
  fi
}

## Quitting procedure.
## MOD: 2003-01-20 by void0
## MOD: 2003-01-22 by Turranius
## cat and rm instead of mv -f
## Quitting procedure.
proc_exit() {
  ## CHG: 2003-01-20 void0
  ## Changed all $PASSWDDEST/$DESTNAME.actions* to $PASSWDSOURCE/$DESTNAME.actions*
  ## Changed back so it moves the actionfile to the slave anyway :)
  if [ -e "$PASSWDSOURCE/$DESTNAME.actions.locked" ]; then
    cat $PASSWDSOURCE/$DESTNAME.actions.locked >> $PASSWDDEST/$DESTNAME.actions.notdone
    rm -f $PASSWDSOURCE/$DESTNAME.actions.locked
    proc_log "Quitting before finished with actionfile. Saving it to $PASSWDDEST/$DESTNAME.actions.notdone."
    proc_debug "Quitting before finished with actionfile. Saving it to $PASSWDDEST/$DESTNAME.actions.notdone."
  fi
  proc_highdebug "Done! Clearing $LOCKFILE and quitting."
  rm -f $LOCKFILE
  exit 0
}

## Just used to checking if the backupdir is OK.
proc_verify_backup_dir() {
  if [ ! -d "$BACKUPDEST" ]; then
    proc_highdebug "Warning: Cant find $BACKUPDEST. Creating it."
    mkdir $BACKUPDEST
  fi
  if [ ! -d "$BACKUPDEST/deleted" ]; then
    proc_highdebug "Warning: Cant find $BACKUPDEST/deleted. Creating it."
    mkdir $BACKUPDEST/deleted
  fi
  if [ "$GL_VERSION" -ge "2" ]; then
    if [ ! -d "$BACKUPDEST/deleted/groups" ]; then
      proc_highdebug "Warning: Cant find $BACKUPDEST/deleted/groups. Creating it."
      mkdir "$BACKUPDEST/deleted/groups"
    fi
  fi
}

## Show help.
proc_help() {
  echo "Welcome to MSS-CORE $VER - Help"
  echo "Commands are:"
  echo "full (debug)      - Do the full sync (everything)."
  echo "fullsync (debug)  - Do the full sync of users & group/passwd file."
  echo "fullstats (debug) - Do the full stat move back to the hub."
  echo ""
  echo "singlefull <user> (debug) - singlesync and singlestat combined."
  echo "singlesync <user> (debug) - Sync a single user."
  echo "singlestat <user> (debug) - Move stats from a single user."
  echo "synctime <user> (debug)   - Sync the 'lastseen' value from this"
  echo "                            slave to the hub, should it be of a"
  echo "                            later time."
  echo ""
  if [ "$GL_VERSION" -le "1" ]; then
    echo "syncfiles debug           - Sync group/passwd files & any defined in"
    echo "                            FILES_TO_SYNC."
  else
    echo "syncfiles debug           - Sync group/passwd files, any defined in"
    echo "                            FILES_TO_SYNC & all group files."
  fi
  echo "setperms debug            - Fix permissions only."
  echo "backup debug              - Set COPYLOCAL to TRUE and run backup."
  echo "delete debug              - Check for deleted users on the HUB."
  echo "singledel <user> debug    - Check a single user for delete."
  echo ""
  echo "actionfile debug          - Process the action file from the hub."
  echo "integrity debug           - Check that all userfiles are in shape."
  echo "report                    - Report settings. Good for new installations."
  echo "cleanup debug             - Incase of actionfile loop or if it refuses to"
  echo "                            finish on an actionfile (bad RUNCMD?), this"
  echo "                            will clear up and reset any actionfiles."
  echo ""
  echo "movecreds                 - Will move creds from this slave back to"
  echo "                            the hub. Run it for options."
  echo "-----------------------------------------------------------------"
  echo "Note that full, fullsys and fullstats will do syncfiles, setperms"
  echo "and backup as well, as long as SETPERMS and BACKUP are not empty"
  echo "in the config file. full & fullsync will also do 'delete' at the"
  echo "end. Note2: Without debug, it will not say anything to screen, "
  echo "except any critical errors."
  proc_exit
}

#### Start commands

## Sync group/passwd file only
proc_syncfiles() {
  ## Sync group file
  proc_groupsync

  ## Sync passwd file.
  proc_passwdsync

  ## Sync group files
  proc_syncgroupfiles

  ## Sync other selected files
  proc_files_to_sync
}

## Procedure for sync group files.
proc_syncgroupfiles() {
  if [ "$GL_VERSION" -ge "2" -a "$GROUPSSOURCE" != "" -a "$GROUPSDEST" != "" ]; then
    if [ ! -d "$GROUPSSOURCE" ]; then
      ERRORLEVEL=3
      proc_debug "Error. GROUPSSOURCE ( $GROUPSSOURCE ) defined but cant find that dir. Skipping."
      SKIPGROUPSYNC="TRUE"
    elif [ ! -d "$GROUPSDEST" ]; then
      proc_debug "Error. GROUPSDEST ( $GROUPSDEST ) defined but cant find that dir. Skipping."
      SKIPGROUPSYNC="TRUE"
    fi
    if [ "$SKIPGROUPSYNC" != "TRUE" ]; then
      proc_highdebug "Syncing groupfiles..."

      ## Removing redundant group files.
      for groupsfile in `ls -1 "$GROUPSDEST" `; do
        if [ ! -e "$GROUPSSOURCE/$groupsfile" ]; then
          ## groupsfile dosnt exist on the hub. Remove from hub. Move it if BACKUPDEST is enabled.
          if [ "$BACKUPDEST" ]; then
            proc_verify_backup_dir
            mv -f "$GROUPSDEST/$groupsfile" "$BACKUPDEST/deleted/groups" >/dev/null 2>&1
            proc_debug "Moving groupfile $groupsfile to $BACKUPDEST/deleted/groups. Dosnt exist on $SOURCENAME."
            proc_log "Moving groupfile $groupsfile to $BACKUPDEST/deleted/groups. Dosnt exist on $SOURCENAME."
          else
            proc_debug "Removing groupfile $groupsfile. Dosnt exist on $SOURCENAME."
            proc_log "Removing groupfile $groupsfile. Dosnt exist on $SOURCENAME."
            rm -f "$GROUPSDEST/$groupsfile"
          fi
        fi
      done

      ## Adding new group files and/or check if they changed.
      for groupsfile in `ls -1 "$GROUPSSOURCE" `; do
        if [ ! -e "$GROUPSDEST/$groupsfile" ]; then
          proc_debug "Syncing new groupfile $groupsfile."
          proc_log "Syncing new groupfile $groupsfile."
          cp -f "$GROUPSSOURCE/$groupsfile" "$GROUPSDEST/"
        else
          if [ "`$MD5BIN "$GROUPSSOURCE/$groupsfile" | cut -d ' ' -f1`" != "`$MD5BIN "$GROUPSDEST/$groupsfile" | cut -d ' ' -f1`" ]; then
            proc_debug "Syncing groupfile $groupsfile. Its different on $SOURCENAME."
            proc_log "Syncing groupfile $groupsfile. Its different on $SOURCENAME."
            cp -f "$GROUPSSOURCE/$groupsfile" "$GROUPSDEST/"
          fi
        fi
      done
    fi
  fi
}

## Procedure for syncing manually added files in FILES_TO_SYNC
proc_files_to_sync() {
  for rawdata in `echo $FILES_TO_SYNC`; do
    unset FROM_FILE; unset TO_FILE; unset destsum; unset sourcesum

    if [ "`echo "$rawdata" | grep ">"`" ]; then
      FROM_FILE="`echo "$rawdata" | cut -d '>' -f1 | sed -e 's/\[\:space\:\]/ /g'`"
      TO_FILE="`echo "$rawdata" | cut -d '>' -f2 | sed -e 's/\[\:space\:\]/ /g'`"
    elif [ "`echo "$rawdata" | grep "<"`" ]; then
      TO_FILE="`echo "$rawdata" | cut -d '<' -f1 | sed -e 's/\[\:space\:\]/ /g'`"
      FROM_FILE="`echo "$rawdata" | cut -d '<' -f2 | sed -e 's/\[\:space\:\]/ /g'`"
    else
      ERRORLEVEL=3
      proc_debug "Error in FILES_TO_SYNC. Line $rawdata. Does not contain a < or >"
      proc_log "Error in FILES_TO_SYNC. Line $rawdata. Does not contain a < or >"
    fi

    if [ "$TO_FILE" ] && [ "$FROM_FILE" ]; then
      if [ ! -e "$FROM_FILE" ]; then
        ERRORLEVEL=3
        proc_debug "Error in FILES_TO_SYNC. Line $rawdata. $FROM_FILE does not exist."
        proc_log "Error in FILES_TO_SYNC. Line $rawdata. $FROM_FILE does not exist."
      else
        if [ ! -e "$TO_FILE" ]; then
          ERRORLEVEL=3
          proc_debug "FILES_TO_SYNC. Line $rawdata. $TO_FILE does not exist. Making a new copy."
          proc_log "FILES_TO_SYNC. Line $rawdata. $TO_FILE does not exist. Making a new copy."
          cp -f "$FROM_FILE" "$TO_FILE"
        else
          destsum="`$MD5BIN "$TO_FILE" | cut -d ' ' -f1`"
          sourcesum="`$MD5BIN "$FROM_FILE" | cut -d ' ' -f1`"
          if [ "$destsum" != "$sourcesum" ]; then
            if [ ! -w "$TO_FILE" ]; then
              ERRORLEVEL=3
              proc_debug "Error. Cant sync $TO_FILE - No permissions to write to it."
              proc_log "Error. Cant sync $TO_FILE - No permissions to write to it."
            else
              ERRORLEVEL=2
              proc_debug "Syncing $FROM_FILE to $TO_FILE"
              proc_highdebug "FILES_TO_SYNC: Syncing $FROM_FILE to $TO_FILE"
              cp -f "$FROM_FILE" "$TO_FILE"
            fi
          else
            proc_debug "$TO_FILE does not need syncing. md5sum: $destsum"
          fi
        fi
      fi
    fi
  done
}

## MOD 2003-01-21 by Turranius
## If user isnt found on hub it dosnt quit. It checks if hes on the slave.
## If he is, it will run the proc_singledel so it can restore him if found in backups.
## Sync a single user.
proc_singlesync() {
  if [ "$USER" = "" ]; then 
    proc_debug "Enter a single username to sync too."
  else
    proc_verifylink
    proc_countpong
    if [ -e "$USERSOURCE/$USER" ]; then
      proc_syncuser
    else
      if [ -e "$USERDEST/$USER" ]; then
        proc_singledel
      else
        ERRORLEVEL=1
        proc_debug "Can not find $USER in $USERSOURCE. Misspelled? (Thats usually the case)"
        proc_debug "If $USER is deleted on the hub and you want to sync that, run mss-core.sh delete instead."
        proc_log "Syncuser Error: $USER in $USERSOURCE not found."
      fi
    fi
  fi
}

## MOD: 2003-01-26 by Turranius
## Moved checking of actionfile into proc_actionfilecheck
## Do the full sync
proc_fullsync() {
  ## Verify link.
  proc_verifylink

  ## Send pong to hub
  proc_pong

  if [ "$REPORTFULL" ]; then
    if [ "$REPORTFULL" -ge "1" ]; then
      echo `date "+%a %b %e %T %Y"` MSSERR: \"Starting a full sync.\" >> $REPORTDIR/$DESTNAME.msg
    fi
  fi

  ## Make a local copy if on
  proc_copylocal

  ## Backing up users 
  proc_backup
  ## Verify link again..
  proc_verifylink
  ## Set any perms required.
  proc_setperms

  ## Sync files
  proc_syncfiles

  ## Syncronise users.
  if [ "$FULL" = "YES" ]; then
    proc_statlogsetup
  fi

  for USER in `grep "^FLAGS " $USERSOURCE/* | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do

    proc_countpong

    USER="$( basename "$USER" )"
    proc_actionfilecheck

    if [ "$SKIPPING" != "$USER" ]; then
      proc_syncuser
      if [ "$FULL" = "YES" ]; then
        proc_movestats
      fi
    fi
  done
  for USER in `grep "^FLAGS " $USERDEST/* | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do
    USER="$( basename "$USER" )"
    proc_singledel
  done

  if [ "$REPORTFULL" ]; then
    if [ "$REPORTFULL" -ge "2" ]; then
      echo `date "+%a %b %e %T %Y"` MSSERR: \"Completed a full sync.\" >> $REPORTDIR/$DESTNAME.msg
    fi
  fi
}

## Check for deleted users, start.
proc_delusers() {
  ## Delete any leftover users.
  proc_verifylink
  proc_highdebug "Entering 'delete users' phase."
  proc_debug "Checking for deleted users."

  for USER in `grep "^FLAGS " $USERDEST/* | cut -d ' ' -f1 | cut -d ':' -f1 | egrep -v $EXCLUDE`; do
    USER="$( basename "$USER" )"
    proc_singledel
  done
}


## MOD 2003-01-21 by Turranius
## Added full path to: if [ ! -r "$USER" ]; then
## Deleting single user.
proc_singledel() {
  if [ "$USER1" ]; then
    USER="$USER1"
    unset USER1
  fi
  if [ -z "$USER" ]; then
    echo "Purge: I need a username to check for delete on a single user..."
  else
    if [ ! -r "$USERDEST/$USER" ]; then
      proc_debug "Singledel: Can not find $USER in $USERDEST. Already deleted?"
      proc_log "Singledel: Can not find $USER in $USERDEST. Already deleted?"
    else
      ## Check if we should delete user.
      proc_deluser
    fi
  fi
}

## NEW: 2003-01-20 by void0
## Restore a user from the backup archives
## MOD: 2003-01-20 by Turranius - Changed putlog to proc_log
proc_restoreuser() {
  CURUSER="$1"
  if [ -z "$CURUSER" ]; then
    proc_log "Function 'proc_restoreuser' was called without the <username> argument."
    proc_debug "Function 'proc_restoreuser' was called without the <username> argument."
  fi

  proc_log "Warning: $USER exists in passwd on $SOURCENAME, but no userfile exists there."
  proc_log "Searching for user '$CURUSER' in backup-archives ..."
  ERRORLEVEL=1
  proc_debug "Warning: $USER exists in passwd on $SOURCENAME, but no userfile exists there."
  ERRORLEVEL=1
  proc_debug "Searching for user '$CURUSER' in backup-archives ..."
  unset BACKUPFILE
  for CURFILE in `ls -1t $BACKUPDEST/autosync.source.*.tar.gz`; do
    if [ -f "$CURFILE" ] && [ ! -z "$( tar ztf "$CURFILE" | grep "/$CURUSER" )" ]; then
      proc_log "Found user '$1' in archive '$CURFILE'."
      ERRORLEVEL=1
      proc_debug "Found user '$1' in archive '$CURFILE'."
      BACKUPFILE="$CURFILE"
      return 1
    fi
  done
  proc_log "User '$1' not found in backupfiles."
  ERRORLEVEL=1
  proc_debug "User '$1' not found in backupfiles."
  unset BACKUPFILE
  HARDSKIP="$USER"
  return 0
}

## Send pong to hub every 10 action taken.
proc_countpong() {
 if [ -z "$counted" ]; then
   counted=0
 fi
 counted=$[$counted+1]
 if [ "$counted" -ge "10" ]; then
   proc_pong
   counted=0
 fi
}

## NEW: 2003-01-20 by Turranius
## Do a full sync on single user.
proc_singlefull() {
  proc_singlesync
  if [ "$HARDSKIP" != "$USER" ]; then
    proc_singlestat
  else
    unset HARDSKIP
  fi
}

proc_singlestat() {
  if [ -z "$USER" ]; then
    proc_debug "Enter a single username to sync too."
    proc_exit
  fi
  if [ ! -r "$USERSOURCE/$USER" ]; then
    proc_debug "Can not read $USER in $USERSOURCE. Misspelled?"
    proc_log "Syncuser Error: $USER in $USERSOURCE cant be read."
    SKIP="YES"
  fi

  ## Sync user..
  if [ "$SKIP" != "YES" ]; then
    proc_countpong
    proc_movestats
  fi
}

## MOD: 2004-02-08 by Turranius
## For every 5th user checked, send a pong to the hub so it knows were still in
## business (if on).
proc_fullstats() {

  ## Verify link.
  proc_verifylink

  ## Send alive to hub
  proc_pong

  proc_actionfilecheck

  if [ "$REPORTFULL" ]; then
    if [ "$REPORTFULL" -ge "1" ]; then
      echo `date "+%a %b %e %T %Y"` MSSERR: \"Starting a full stat sync.\" >> $REPORTDIR/$DESTNAME.msg
    fi
  fi

  ## Make a local copy if on
  proc_copylocal

  ## Send alive to hub
  proc_pong

  ## Backing up users 
  proc_backup
  ## Verify link again..
  proc_verifylink
  ## Set any perms requeired.
  # proc_setperms

  ## Set permissions on statlog.
  SKIP="NO"
  proc_statlogsetup

  ## Log and lets go!
  proc_highdebug "Starting to move stats. Output will be to $STATLOG"

  for USER in `grep "^FLAGS " $USERSOURCE/* | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do

    USER="`basename "$USER"`"
    proc_actionfilecheck
    proc_singlestat
  done

  if [ "$REPORTFULL" ]; then
    if [ "$REPORTFULL" -ge "2" ]; then
      echo `date "+%a %b %e %T %Y"` MSSERR: \"Completed a full stat sync.\" >> $REPORTDIR/$DESTNAME.msg
    fi
  fi
}

## NEW: 2003-01-26 by Turranius
## Check if there is an actionfile and run if so. Ment for stat/sync
proc_actionfilecheck() {
    if [ -e "$PASSWDSOURCE/$DESTNAME.actions" ] && [ -z "$ACTIONFILE" ]; then
      OLDUSER="$USER"
      if [ "$USERSOURCEORG" ]; then
        USERSOURCEORG3=$USERSOURCE
        USERSOURCE="$USERSOURCEORG"
      fi
      proc_debug "Action file $PASSWDSOURCE/$DESTNAME.actions found. Processing it now."
      proc_log "Action file $PASSWDSOURCE/$DESTNAME.actions found. Processing it before continuing."
      proc_actionfileread
      if [ -e "$USERDEST/$USER" ]; then
        if [ "$RUNLOCAL" = "TRUE" ]; then
          proc_highdebug "RUNLOCAL is TRUE. Making a new copy of this userfile."
          proc_debug "RUNLOCAL is TRUE. Making a new copy of this userfile."
          if [ "$DEBUG" = "TRUE" ]; then
            cp -f -v $USERSOURCE/$USER $TMP/autosync.source.users
          else
            cp -f $USERSOURCE/$USER $TMP/autosync.source.users >/dev/null 2>&1
          fi
        fi
      fi
      USER="$OLDUSER"; unset OLDUSER
      if [ "$USERSOURCEORG3" ]; then
        USERSOURCE=$USERSOURCEORG3
        unset USERSOURCEORG3
      fi
    fi
}

## NEW: 2003-01-16 by void0
## MOD: 2003-01-18 by Turranius
## MOD: 2003-01-20 by Turranius
## Removed USER1 and NEWUSER1 variables. No purpose. Also change them in the general case at the end of script.
## Also, added check for 'if [ "$USER" != "$NEWUSER" ]; then' since anyone can run this from hub.
## Should be pretty secure anyway, right? Cant do crap unless they are actually renamed on hub, but will
## generate errors in log here.
## Rename a user
proc_renuser() {
  proc_verifylink
  if [ "$USER" != "" -a "$NEWUSER" != "" ]; then
    ## NEW: 2003-01-20 by turranius
    if [ "$USER" != "$NEWUSER" ]; then
      if [ ! -e $USERDEST/$NEWUSER ]; then
        if [ -e $USERDEST/$USER ]; then
          if [ -e $USERSOURCE/$NEWUSER ]; then
             mv -f "$USERDEST/$USER" "$USERDEST/$NEWUSER" >/dev/null 2>&1
             proc_debug "Renamed user $USER to $NEWUSER"
             proc_log "Renaming $USER to $NEWUSER"
           else
             ERRORLEVEL=1
             proc_debug "Should rename $USER to $NEWUSER, but I fail to see $NEWUSER on $SOURCENAME. Not renaming."
             proc_log "Should rename $USER to $NEWUSER, but I fail to see $NEWUSER on $SOURCENAME. Not renaming."
          fi
        else
          if [ "$BACKUPDEST" != "" -a -e "$BACKUPDEST/deleted/$USER" ]; then
            ERRORLEVEL=1
            proc_debug "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. I did found $USER deleted though. Readding that as $NEWUSER."
            proc_log "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. I did found $USER deleted though. Readding that as $NEWUSER."
            mv -f "$BACKUPDEST/deleted/$USER" "$USERDEST/$NEWUSER" >/dev/null 2>&1
            mv -f "$USERDEST/$USER" "$BACKUPDEST/deleted/$USER.oldname" >/dev/null 2>&1
          else
            ERRORLEVEL=1
            proc_debug "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. Not renaming."
            proc_log "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. Not renaming."
          fi
        fi
      else
        ERRORLEVEL=1
        proc_debug "Should rename $USER to $NEWUSER, but $NEWUSER already exists on $DESTNAME."
        proc_log "Should rename $USER to $NEWUSER, but $NEWUSER already exists on $DESTNAME."
      fi
    else
      ## NEW: 2003-01-20 by turranius
      ERRORLEVEL=1
      proc_debug "Rename error: USER: $USER. NEWUSER: $NEWUSER. They are the same."
      proc_log "Rename error: USER: $USER. NEWUSER: $NEWUSER. They are the same."
    fi
  else
    ERRORLEVEL=1
    proc_debug "Error: Value USER is ($USER) and NEWUSER is ($NEWUSER). They cant be empty."
    proc_log "Error, rename: Value USER is ($USER) and NEWUSER is ($NEWUSER). They cant be empty."
  fi
}

## Read the actionfile.
proc_actionfile() {
  ## We up or not?
  proc_verifylink

  ## Send Alive back to hub.
  proc_pong

  ## Go read actionfile.
  proc_actionfileread

  ## Sync other selected files
  proc_files_to_sync

  ## Check groups files
  proc_syncgroupfiles
}

## Parse action-file
proc_actionfileread() {
  ACTIONFILE="$PASSWDSOURCE/$DESTNAME.actions"
  NOTDONEFILE="$PASSWDDEST/$DESTNAME.actions.notdone"

  ## CHG: 2003-01-20 void0
  ## Changed all $PASSWDSOURCE/$DESTNAME.actions* and $PASSWDDEST/$DESTNAME.actions* to $ACTIONFILE
  ## Verify action-file
  if [ ! -r "$ACTIONFILE" ] && [ ! -r "$NOTDONEFILE" ]; then
    proc_highdebug "No actionfile currently exists (not an error)."
    proc_debug "No actionfile currently exists (not an error)."
  else
    ## Are we already processing another actions file?
    if [ -e "$ACTIONFILE.locked" ]; then
      proc_debug "Already processing an action file."
      proc_log "Already processing an actions file."
    else

      ## If a .notdone file exists, delete it and run a full sync instead.
      if [ -e "$NOTDONEFILE" ]; then
#        proc_highdebug "Found a previous actionfile: $NOTDONEFILE. Doing a full sync instead."
#        proc_debug "Found a previous actionfile: $NOTDONEFILE. Doing a full sync instead."
#        rm -f "$NOTDONEFILE" > /dev/null 2>&1
#        FULL="YES"
#        proc_fullsync
#        proc_exit

        proc_highdebug "Found a local action file: $NOTDONEFILE. Doing that one first."
        proc_debug "Found a local action file: $NOTDONEFILE. Doing that one first."
        mv -f "$NOTDONEFILE" "$ACTIONFILE.locked" >/dev/null 2>&1

        ## ADD: 2003-01-20 void0
        ## Append the .actions file to the .notdone so that we can process it all at once.
        ## ADD: 2003-01-20 Turran
        ## If -e needed incase there is a .notdone file but no new actionfile.
        if [ -e "$ACTIONFILE" ]; then
          cat "$ACTIONFILE" >> "$ACTIONFILE.locked"
          rm -f "$ACTIONFILE"
          proc_highdebug "Appending current actionfile to the .locked file so it gets processed too now."
        fi

      else
        mv -f "$ACTIONFILE" "$ACTIONFILE.locked" >/dev/null 2>&1

        ## Save the actionfile as .notdone on the slave
	cp -f "$ACTIONFILE.locked" "$NOTDONEFILE"
      fi

      ORG_ACTIONFILE="$ACTIONFILE"
      ACTIONFILE="$ACTIONFILE.locked"
      cp -f "$ACTIONFILE" "$NOTDONEFILE"

      ## CHG: 2003-02-09 Turranius
      ## CHG: 2003-01-20 void0
      ## First parse the actionfile to get all actions and then process them.
      ## Action commands:
      ##   SYNC BASIC [*] <user> [<user> ...]
      ##   SYNC STATS [*] <user> [<user> ...]
      ##   SYNC FULL [*] <user> [<user> ...]
      ##   SYNC PASSWD
      ##   SYNC GROUP
      ##   RENUSER <user> <newuser>
      ##   PURGE <user>
      ##   FETCHLOG
      ##   TRIM <size>
      ##   DELREPORTS
      ##   UPDATE <scriptname> (destinationdir)
      ##   GIVECREDS <user> <MB Creds>
      ##   RUNCMD <command>
      ##   VERSION <script to check>

      ## Parse action-file for the rest.
      ACT_PASSWD=0
      ACT_GROUP=0
      ACT_FETCHLOG=0
      ACT_INTEGRITY=0
      ACT_TRIM=0
      ACT_UPDATE=0
      ACT_DELREPORT=0
      ACT_BACKUP=0
      ACT_GIVECREDS=0
      ACT_CREDMOVE=0
      LIST_BASIC=" "
      LIST_STATS=" "
      LIST_FULL=" "

      while read; do
        HEAD_COUNT=$[HEAD_COUNT + 1]
        TAIL_COUNT=$[TAIL_COUNT + 1]
        ACTION="$( echo "$REPLY" | cut -d' ' -f1 )"
        case "$ACTION" in
          CLEANUP)
            proc_cleanup
            RUNCMDSEND="YES"
            proc_msslog "Cleaned out any old actionfiles not processed and quitting this session."
            proc_exit
          ;;
          DELREPORTS)
            proc_delreport
          ;;
          SYNC)
            TYPE="$( echo "$REPLY" | cut -d' ' -f2 )"
            ARGS="$( echo "$REPLY" | cut -d' ' -f3- )"
            case "$TYPE" in
              BASIC)
                if [ "$ARGS" == "*" ]; then
                  LIST_BASIC="*"
                else
                  if [ "$LIST_BASIC" != "*" ] && [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        if [ -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                          if [ -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                            LIST_BASIC="$LIST_BASIC$CURUSER "
                          fi
                        else
                          LIST_FULL="$LIST_FULL$CURUSER "
                          LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $CURUSER / /g" )"
                        fi
                      fi
                    done
                  fi
                fi
              ;;
              STATS)
                if [ "$ARGS" == "*" ]; then
                  LIST_STATS="*"
                else
                  if [ "$LIST_STATS" != "*" ] && [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        if [ -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                          if [ -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                            LIST_STATS="$LIST_STATS$CURUSER "
                          else
                             LIST_FULL="$LIST_FULL$CURUSER "
                             LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $CURUSER / /g" )"
                          fi
                        fi
                      fi
                    done
                  fi
                fi
              ;;
              FULL)
                ## FULL is just here for laziness and looks really, since it would
                ## be the same to just use "SYNC BASIC *" and "SYNC STATS *"
                if [ "$ARGS" == "*" ]; then
                  LIST_FULL="*"
                  LIST_BASIC="*"
                  LIST_STATS="*"
                else
                  if [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        LIST_FULL="$LIST_FULL$CURUSER "
                      fi
                      if [ ! -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                        LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $CURUSER / /g" )"
                      fi
                      if [ ! -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                        LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $CURUSER / /g" )"
                      fi
                    done
                  fi
                fi
              ;;
              PASSWD)
                ACT_PASSWD=1
              ;;
              GROUP)
                ACT_GROUP=1
              ;;
              *)
                ERRORLEVEL=3
                proc_debug "Actionfile warning. Action $ACTION, type $TYPE not recognized."
                proc_log "Actionfile warning. Action $ACTION, type $TYPE not recognized."
              ;;
            esac
          ;;
          ## End of case TYPE.

          RENUSER)
            USER="$( echo "$REPLY" | cut -d' ' -f2 )"
            NEWUSER="$( echo "$REPLY" | cut -d' ' -f3 )"
            LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $USER / $NEWUSER /g" )"
            LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $USER / $NEWUSER /g" )"
            LIST_FULL="$( echo "$LIST_FULL" | sed "s/ $USER / $NEWUSER /g" )"
            proc_renuser
          ;;
          PURGE)
            USER="$( echo "$REPLY" | cut -d' ' -f2 )"
            LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $USER / /g" )"
            LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $USER / /g" )"
            LIST_FULL="$( echo "$LIST_FULL" | sed "s/ $USER / /g" )"
            proc_singledel
          ;;
          FETCHLOG)
             ACT_FETCHLOG=1
          ;;
          INTEGRITY)
            ACT_INTEGRITY=1
          ;;
          BACKUP)
            ACT_BACKUP=1
          ;;
          TRIM)
            SIZE="$( echo "$REPLY" | cut -d' ' -f2 )"
            if [ "$SIZE" ]; then
              ACT_TRIM=1
            fi
          ;;
          UPDATE)
            UPDSCRIPT="$( echo "$REPLY" | cut -d' ' -f2 )"
            TOPATH="$( echo "$REPLY" | cut -d' ' -f3 )"
            UPDSCRIPTS="$UPDSCRIPT:$TOPATH $UPDSCRIPTS"
            if [ "$UPDSCRIPTS" ]; then
              proc_updatescripts
            fi
          ;;
          RUNCMD)
            COMMAND="$( echo "$REPLY" | cut -d' ' -f2- )"
            if [ "$COMMAND" ]; then
              proc_runcommand
            fi
          ;;
          VERSION)
            CHECK_SCRIPT="$( echo "$REPLY" | cut -d' ' -f2 )"
            if [ "$CHECK_SCRIPT" ]; then
              proc_versioncheck
            fi
          ;;
          GIVECREDS)
            unset GIVE_CREDS_USER; unset GIVE_CREDS_MB
            GIVE_CREDS_USER="$( echo "$REPLY" | cut -d' ' -f2 )"
            GIVE_CREDS_MB="$( echo "$REPLY" | cut -d' ' -f3 )"
            if [ "$GIVE_CREDS_USER" = "" -o "$GIVE_CREDS_MB" = "" ]; then
              ERRORLEVEL=3
              proc_log "Actionfile error. Supposed to give credits, but user is '$GIVE_CREDS_USER' & amount is '$GIVE_CREDS_MB' - Both needs to be set"
              proc_debug "Actionfile error. Supposed to give credits, but user is '$GIVE_CREDS_USER' & amount is '$GIVE_CREDS_MB' - Both needs to be set"
            else
              proc_givecreds
            fi
          ;;
          CREDMOVE)
            MOVE_CREDS_USERS="$( echo "$REPLY" | cut -d' ' -f2- )"
            for CURUSER in $MOVE_CREDS_USERS; do
              if [ -z "`echo "$CREDMOVE_LIST" | grep " $CURUSER "`" ]; then
                CREDMOVE_LIST="$CREDMOVE_LIST $CURUSER "
              fi
              ACT_CREDMOVE=1
            done
          ;;

          *)
            ERRORLEVEL=3
            proc_debug "Actionfile Warning. Action $ACTION not recognized."
            proc_log "Actionfile Warning. Action $ACTION not recognized."
          ;;
        esac
      done < "$ACTIONFILE"

      ## Process remaining actions
      if [ $ACT_PASSWD -eq 1 ]; then
        proc_passwdsync
      fi
      if [ $ACT_GROUP -eq 1 ]; then
        proc_groupsync
      fi
      if [ $ACT_INTEGRITY -eq 1 ]; then
        proc_destuserscheck
      fi
      if [ $ACT_BACKUP -eq 1 ]; then
        COPYLOCAL="TRUE"
        proc_copylocal
        proc_backup
      fi

      ## Remove leading, ending and multiple spaces
      LIST_BASIC="$( echo "$LIST_BASIC" | tr -s ' ' )"
      LIST_STATS="$( echo "$LIST_STATS" | tr -s ' ' )"
      LIST_FULL="$( echo "$LIST_FULL" | tr -s ' ' )"
      if [ "$LIST_BASIC" == "*" ] && [ "$LIST_STATS" == "*" ]; then
	  LIST_FULL="*"
      fi
      if [ "$LIST_FULL" == "*" ]; then
          FULL="YES"
	  proc_fullsync
      else
        ## Process basic sync's
        if [ "$LIST_BASIC" == "*" ]; then
          proc_fullsync
        elif [ "$LIST_BASIC" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_BASIC"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlesync
          done
        fi
  
        ## Process stats sync's
        if [ "$LIST_STATS" == "*" ]; then
          proc_fullstats
        elif [ "$LIST_STATS" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_STATS"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlestat
          done
        fi
       
        ## Process full user sync's
        if [ "$LIST_FULL" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_FULL"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlefull
          done
        fi
      fi

      if [ $ACT_TRIM -eq 1 ]; then
        proc_trimlogs
      fi

      if [ $ACT_CREDMOVE -eq 1 ]; then
        for USER in $CREDMOVE_LIST; do
          proc_movecredsrace
        done
      fi

      ## FETCHLOG runs here so that we will get all this newly logged stuff aswell
      if [ $ACT_FETCHLOG -eq 1 ]; then
        proc_fetchlog
      fi

      ## Remove action-file
      rm -f "$ACTIONFILE"
      rm -f "$NOTDONEFILE"
      rm -f "$ORG_ACTIONFILE"
      unset ACTIONFILE
    fi
  fi
}

## Run a command on the slave. RUNCMD from the actionfile system.
proc_runcommand() {
  RUNCMDSEND=YES
  if [ "$ALLOW_RUNCMD" != "FALSE" ]; then
    if [ -z "$COMMAND" ]; then
      proc_log "Error. Got RUNCMD but no command to process."
      proc_debug "Error. Got RUNCMD but no command to process."
    else
      proc_debug "Response to $COMMAND:"
      proc_log "Executing command: $COMMAND"
      proc_msslog "Response to $COMMAND:"
      proc_highdebug "Response to $COMMAND:"          
      RESPONSE=`$COMMAND >$TMP/mss-tempresp.tmp 2>&1` 
      if [ "`cat "$TMP/mss-tempresp.tmp"`" ]; then
        for res_line in `cat $TMP/mss-tempresp.tmp | tr ' ' ';'`; do
          res_line="`echo "$res_line" | tr ';' ' '`"
          proc_debug "$res_line"
          proc_highdebug "$res_line"
          proc_msslog "$res_line"
        done
        rm -f "$TMP/mss-tempresp.tmp"
      else
        proc_debug "No response for that command (no error either for that matter)."
        proc_highdebug "No response for that command (no error either for that matter)."
        proc_msslog "No response for that command (no error either for that matter)."
      fi
      proc_debug "----"
      proc_msslog "----"
    fi
  else
    proc_log "Got a RUNCMD, but ignoring it as ALLOW_RUNCMD is FALSE."
    proc_debug "Got a RUNCMD, but ignoring it as ALLOW_RUNCMD is FALSE."
    proc_msslog "Access Denied for RUNCMD on this slave, sorry."
  fi
  unset RUNCMDSEND; unset RESPONSE
}

## Check a version on a script. VERSION from the actionfile system.
proc_versioncheck() {
  VERSIONSEND=YES
  if [ -z "$CHECK_SCRIPT" ]; then        
    proc_highdebug "Got VERSION check, but no script to check."
  else
    ## If theres no slashes in the script, check same dir as mss-core.sh is in.
    if [ -z "`echo "$CHECK_SCRIPT" | grep "\/"`" ]; then
      CHECK_SCRIPT="`dirname $0`/$CHECK_SCRIPT"
    fi
    if [ ! -e "$CHECK_SCRIPT" ]; then
      proc_log "Got VERSION command on $CHECK_SCRIPT, but cant find that file."
      proc_debug "Got VERSION command on $CHECK_SCRIPT, but cant find that file."
      proc_msslog "Didnt find $CHECK_SCRIPT to check version on."
    else
      proc_highdebug "Got VERSION command on $CHECK_SCRIPT - File found - Checking it."
      SCRIPT_VERSION="`head -n3 "$CHECK_SCRIPT" | grep "^VER" | cut -d '=' -f2 | tr -d '"'`"
      if [ -z "$SCRIPT_VERSION" ]; then
        proc_log "Got VERSION command on $CHECK_SCRIPT but failed to exctract the version from it."
        proc_debug "Got VERSION command on $CHECK_SCRIPT but failed to exctract the version from it."
        proc_msslog "No version found for $CHECK_SCRIPT, but file was found."
      else          
        proc_log "Got VERSION $SCRIPT_VERSION for $CHECK_SCRIPT"
        proc_debug "Got VERSION $SCRIPT_VERSION for $CHECK_SCRIPT"
        proc_msslog "$CHECK_SCRIPT reporting version: $SCRIPT_VERSION"
      fi
    fi
  fi
  unset CHECK_SCRIPT; unset VERSIONSEND; unset SCRIPT_VERSION
}

## Procedure for giving credits to a user (used in actionfile as GIVECREDS
proc_givecreds() {
  unset GC_CURCREDS; unset GC_CURCREDSKB; unset GC_CURCREDSMB
  unset SKIP
  proc_debug "Got command to give creds to '$GIVE_CREDS_USER' amount '$GIVE_CREDS_MB' MB"
  proc_highdebug "Got command to give creds to '$GIVE_CREDS_USER' amount '$GIVE_CREDS_MB' MB"
  
  ## Verify that the user exists
  if [ ! -e "$USERDEST/$GIVE_CREDS_USER" ]; then
    ERRORLEVEL=2
    proc_debug "Actionfile error. Got command to give $GIVE_CREDS_MB mb credits to $GIVE_CREDS_USER, but that user dosnt exist."
    proc_log "Actionfile error. Got command to give $GIVE_CREDS_MB mb credits to $GIVE_CREDS_USER, but that user dosnt exist."
    proc_transferlog "Error. Got command to give $GIVE_CREDS_MB mb credits to $GIVE_CREDS_USER, but that user dosnt exist."

  else
    ## Grab his current creds and verify it.
    GC_CURCREDS="`grep "^CREDITS " $USERDEST/$GIVE_CREDS_USER | cut -d ' ' -f2`"
    if [ -z "$GC_CURCREDS" ]; then
      ERRORLEVEL=2
      proc_debug "Actionfile error. Supposed to give $GIVE_CREDS_MB mb creds to $GIVE_CREDS_USER but cant read current creds."
      proc_log "Actionfile error. Supposed to give $GIVE_CREDS_MB mb creds to $GIVE_CREDS_USER but cant read current creds."
      proc_transferlog "Error. Supposed to give $GIVE_CREDS_MB mb creds to $GIVE_CREDS_USER but cant read current creds."
    else
      ## Make sure creds are valid.
      if [ "`echo "$GIVE_CREDS_MB" | tr -d '[:digit:]'`" ]; then
        ERRORLEVEL=2
        proc_debug "Actionfile error. Supposed to give $GIVE_CREDS_MB to $GIVE_CREDS_USER, but the amount is invalid."
        proc_log "Actionfile error. Supposed to give $GIVE_CREDS_MB to $GIVE_CREDS_USER, but the amount is invalid."
        proc_transferlog "Error. Supposed to give $GIVE_CREDS_MB to $GIVE_CREDS_USER, but the amount is invalid."
      else
        ## Recalc values to MB and KB.
        GC_CURCREDSKB="$GC_CURCREDS"
        GC_CURCREDSMB="`echo "$GC_CURCREDSKB / 1024" | bc -l | cut -d '.' -f1`"
        if [ -z "$GC_CURCREDSMB" ]; then
          GC_CURCREDSMB="0"
        fi
        GC_ADDCREDSMB="$GIVE_CREDS_MB"
        GC_ADDCREDSKB="`echo "$GC_ADDCREDSMB * 1024" | bc -l | cut -d '.' -f1`"
        GC_NEWCREDSMB="`echo "$GC_CURCREDSMB + $GC_ADDCREDSMB" | bc -l | cut -d '.' -f1`"
        GC_NEWCREDSKB="`echo "$GC_CURCREDSKB + $GC_ADDCREDSKB" | bc -l | cut -d '.' -f1`"

        proc_transferlog "$GIVE_CREDS_USER - Current: $GC_CURCREDSMB MB/$GC_CURCREDSKB KB - Add: $GC_ADDCREDSMB MB/$GC_ADDCREDSKB KB - New: $GC_NEWCREDSMB MB/$GC_NEWCREDSKB KB"
        proc_highdebug "Creds: $GIVE_CREDS_USER - Current: $GC_CURCREDSMB MB/$GC_CURCREDSKB KB - Add: $GC_ADDCREDSMB MB/$GC_ADDCREDSKB KB - New: $GC_NEWCREDSMB MB/$GC_NEWCREDSKB KB"

        ## Lock the userfile and make sure it went ok!
        USER="$GIVE_CREDS_USER"
        proc_lock_dst
        if [ "$SKIP" = "YES" ]; then
          ERRORLEVEL=2
          proc_debug "Error: Going to give $GIVE_CREDS_MB MB creds to $GIVE_CREDS_USER but userfile is locked on $DESTNAME."
          proc_log "Error: Going to give $GIVE_CREDS_MB MB creds to $GIVE_CREDS_USER but userfile is locked on $DESTNAME."
          proc_transferlog "Error: Going to give $GIVE_CREDS_MB MB creds to $GIVE_CREDS_USER but userfile is locked on $DESTNAME."
        else
          ## Change users credits to a temporary file.
          sed -e "s/^CREDITS [-|0-9]*/CREDITS $GC_NEWCREDSKB/" $USERDEST/$GIVE_CREDS_USER > $TMP/$GIVE_CREDS_USER.NEW.CREDITS

          ## Verify the integrity of the newly created file.
          USER="$TMP/$GIVE_CREDS_USER.NEW.CREDITS"
          proc_userver
          if [ "$VERERR" ]; then
            ERRORLEVEL=2
            proc_debug "Error: Was going to give $GIVE_CREDS_USER $GIVE_CREDS_MB MB creds but problems with the fields in temp file, $TMP/$GIVE_CREDS_USER.NEW.CREDITS, are: $VERERR." 
            proc_log "Error: Was going to give $GIVE_CREDS_USER $GIVE_CREDS_MB MB creds but problems with the fields in temp file, $TMP/$GIVE_CREDS_USER.NEW.CREDITS, are: $VERERR." 
            proc_transferlog "Error: Was going to give $GIVE_CREDS_USER $GIVE_CREDS_MB MB creds but problems with the fields in temp file, $TMP/$GIVE_CREDS_USER.NEW.CREDITS, are: $VERERR." 
          else

            ## No errors on temp file. Log it and overwrite current userfile.
            proc_transferlog "$GIVE_CREDS_USER - Automatic give of $GIVE_CREDS_MB MB is all ok."
            proc_debug "$GIVE_CREDS_USER - Automatic give of $GIVE_CREDS_MB MB is all ok."
            cp -f $TMP/$GIVE_CREDS_USER.NEW.CREDITS $USERDEST/$GIVE_CREDS_USER
            rm -f $TMP/$GIVE_CREDS_USER.NEW.CREDITS
          fi

          ## Unlock the userfile again.
          USER="$GIVE_CREDS_USER"
          proc_unlock_dst
        fi          
      fi
    fi
  fi
}

## Check passwd/userfiles integrity.
proc_userpasswdintegrity() {
  proc_verifylink
  proc_sourceuserscheck
  proc_destuserscheck
}

## This will move ALL credits from the slave back to the hub.
proc_movecreds() {

  COMMAND="$( echo $COMMAND | cut -d" " -f2- )"

  if [ "$COMMAND" = "" -o "$COMMAND" = "movecreds" ]; then
    echo "Specify user or users (with a space in between) to move creds for."
    echo "Specify ALL for all users."
    proc_exit
  fi

  if [ "$( echo $COMMAND | cut -d' ' -f1 )" = "ALL" ]; then
    if [ "$( echo $COMMAND | cut -d' ' -f2 )" != "YES!" ]; then
      echo "Are you absolutely SURE you want to do this? It will move all creds for this slave, back to the hub."
      echo "I will make a backup first if you got the path set for it."
      echo "It is recomended that you shut down this slave (shutdown 1) and do a full sync first (mss-core.sh full) to"
      echo "not leave anything behind."
      echo ""
      echo "If you are sure, add 'YES!' as an argument."
      proc_exit
    else
      proc_log "Initiating move of all credits back to $SOURCENAME."
      echo "This will move all credits back to the hub for everyone. Press ctrl-c within 5 seconds to abort."
      sleep 5
      echo "Oki, setting DEBUG to TRUE, cause you will want to see this."
      sleep 1
      MOVEALL=TRUE
    fi
  fi

  proc_verifylink

  ## Copying files here..
  echo "Copying userfiles before backup.. hold"
  DEBUG="FALSE"
  proc_copylocal
  if [ "$USERSOURCEORG" ]; then
    USERSOURCE="$USERSOURCEORG"
    unset USERSOURCEORG
  fi
  DEBUG="TRUE"

  ## Backing up users 
  proc_backup

  ## Verify link again..
  proc_verifylink

  ## Move from all users:
  if [ "$MOVEALL" = "TRUE" ]; then
    for each in `grep "^CREDITS " $USERDEST/* | cut -d':' -f1`; do
      USER="$( basename $each )"
      proc_movecredsdata
    done
  else
    for USER in $COMMAND; do
      if [ -e "$USERDEST/$each" ]; then
        proc_movecredsdata
      else
        echo "$USER does not exist on $DESTNAME..."
      fi
    done
  fi
}  

## Used to move creds automatically after race. Gets command from mss-rlscomp.sh
proc_movecredsrace() {
  if [ -e "$PASSWDSOURCE/mss-automove.db" ]; then
    if [ "`grep "$DESTNAME:$USER:ON" $PASSWDSOURCE/mss-automove.db`" ]; then
      proc_movecredsdata
    else
      proc_highdebug "Not automoving creds from $USER. Not enabled on hub."
      proc_debug "Not automoving creds from $USER. Not enabled on hub."
    fi
  else
    proc_highdebug "Not automoving creds for $USER. $PASSWDSOURCE/mss-automove.db dosnt exist."
    proc_debug "Not automoving creds for $USER. $PASSWDSOURCE/mss-automove.db dosnt exist."
  fi
}

## Used by movecreds() and when moving creds after race.
proc_movecredsdata() {
    proc_log "Moving creds for $USER back to $SOURCENAME"
    proc_debug "Moving creds for $USER back to $SOURCENAME"

    if [ ! -r $USERDEST/$USER ]; then
      proc_debug "Error. Could not read userfile $USER in $USERDEST - Perms? Something whacky cause I could read it a second ago. Skipping."
      proc_log "Error. Could not read userfile $USER in $USERDEST - Perms? Something whacky cause I could read it a second ago. Skipping."
      SKIP="YES"
    fi
    if [ ! -r $USERSOURCE/$USER ]; then
      proc_debug "Error. Could not read userfile $USER in $USERSOURCE - Perms? Skipping."
      proc_log "Error. Could not read userfile $USER in $USERSOURCE - Perms? Skipping."
      SKIP="YES"
    fi
    if [ "$SKIP" != "YES" ]; then
      DESTCREDS="$( grep "^CREDITS " $USERDEST/$USER | cut -d' ' -f2 )"
      SOURCECREDS="$( grep "^CREDITS " $USERSOURCE/$USER | cut -d' ' -f2 )"
      if [ "$DESTCREDS" -lt "1024" ]; then
        proc_debug "$DESTNAME: $USER has less than 1MB creds. Skipping."
        proc_highdebug "$DESTNAME: $USER has less than 1MB creds. Skipping."
      else
        if [ -z "$SOURCECREDS" ]; then
          proc_debug "Error: Cant read credits from $USER on $SOURCENAME. Skipping."
          proc_log "Error: Cant read credits from $USER on $SOURCENAME. Skipping."
        else
          if [ -z "$DESTCREDS" ]; then
            proc_debug "Error: Cant read credits from $USER on $DESTNAME. Skipping."
            proc_log "Error: Cant read credits from $USER on $DESTNAME. Skipping."
          else
            NEWCREDS="$( echo "$SOURCECREDS + $DESTCREDS" | bc -l )"
            if [ -z "$NEWCREDS" ]; then
              proc_debug "Error: Calculcated NEWCREDS went wrong. bc not installed? Skipping $USER."
              proc_highdebug "Error: Calculcated NEWCREDS went wrong. bc not installed? Skipping $USER."
            else
              ## Run check
              NEWCREDSCHECK="$( echo $NEWCREDS / 1024 | bc -l | cut -d '.' -f1 )"
              SOURCECREDSCHECK="$( echo $SOURCECREDS / 1024 | bc -l | cut -d '.' -f1 )"

              if [ "$NEWCREDSCHECK" -lt "$SOURCECREDSCHECK" ]; then
                proc_debug "Warning: Calculated NEWCREDS for $USER are LESS then the creds on $SOURCENAME. Check this one so its correct:"
                proc_debug "Warning: Creds on $DESTNAME:$DESTCREDS. Creds on $SOURCENAME:$SOURCECREDS. New creds:$NEWCREDS"
                proc_debug "We'll sync that one anyway but make sure I didnt screw up."
              fi
              unset NEWCREDSCHECK; unset SOURCECREDSCHECK
              if [ ! -w "$USERSOURCE/$USER" ]; then
                proc_debug "Error: No write permissions for $USER on $SOURCENAME in $USERSOURCE. Skipping."
                proc_log "Error: No write permissions for $USER on $SOURCENAME in $USERSOURCE. Skipping."
              else
                if [ ! -w "$USERDEST/$USER" ]; then
                  proc_debug "Error: No write permissions for $USER on $DESTENAME in $USERDEST. Skipping."
                  proc_log "Error: No write permissions for $USER on $DESTENAME in $USERDEST. Skipping."
                else
                  proc_lock_src
                  if [ "$SKIP" != "YES" ]; then
                    proc_lock_dst
                    if [ "$SKIP" != "YES" ]; then
                      sed -e "s/^CREDITS [-|0-9]*/CREDITS $NEWCREDS/" $USERSOURCE/$USER > $TMP/$USER.TMP
                      cp -f $TMP/$USER.TMP $USERSOURCE/$USER
                      rm -f $TMP/$USER.TMP
                      proc_unlock_src
                      sed -e "s/^CREDITS [-|0-9]*/CREDITS 0/" $USERDEST/$USER > $TMP/$USER.TMP2
                      cp -f $TMP/$USER.TMP2 $USERDEST/$USER
                      rm -f $TMP/$USER.TMP2
                      proc_unlock_dst
                      DESTCREDSMB="`echo "$DESTCREDS / 1024" | bc -l | cut -d '.' -f1`"
                      if [ -z "$DESTCREDSMB" ]; then
                        DESTCREDSMB="0"
                      fi
                      SOURCECREDSMB="`echo "$SOURCECREDS / 1024" | bc -l | cut -d '.' -f1`"
                      if [ -z "$SOURCECREDSMB" ]; then
                        SOURCECREDSMB="0"
                      fi
                      NEWCREDSMB="`echo "$NEWCREDS / 1024" | bc -l | cut -d '.' -f1`"
                      proc_debug "AfterRaceMove: $DESTNAME: $USER - $DESTCREDS + $SOURCENAME: $SOURCECREDS = NEW: $NEWCREDS"
                      proc_highdebug "AfterRaceMove: $DESTNAME: $USER - $DESTCREDS + $SOURCENAME: $SOURCECREDS = NEW: $NEWCREDS"
                      proc_transferlog "(AfterRaceMove) $DESTNAME: $USER - $DESTCREDSMB MB ($DESTCREDS KB) + $SOURCENAME: $SOURCECREDSMB MB ($SOURCECREDS KB) = NEW: $NEWCREDSMB MB ($NEWCREDS KB)"
                    else
                      proc_unlock_src
                      proc_unlock_dst
                    fi
                  fi
                fi
              fi
            fi         
          fi
        fi
      fi
    else
      unset SKIP
    fi
    unset DESTCREDS
    unset SOURCECREDS
    unset NEWCREDS
}

## NEW 2003-01-25 by Turranius
## Selects which logs to trim.
proc_trimlogs() {
  if [ "$LOG" ]; then
    TRIMLOG="$LOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
  if [ "$STATLOG" ] && [ "$STATLOG" != "$LOG" ] && [ "$STATLOG" != "$HIGHDEBUGLOG" ]; then 
    TRIMLOG="$STATLOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
  if [ "$HIGHDEBUGLOG" ] && [ "$HIGHDEBUGLOG" != "$LOG" ] && [ "$HIGHDEBUGLOG" != "$STATLOG" ]; then
    TRIMLOG="$HIGHDEBUGLOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
}

## NEW 2003-01-22 by Turranius
## Used to trim size of logs. From actionfile only !
## MOD 2003-01-25 by Turranius
## Renamed to proc_trimlogsdata
## Uses proc_trimlogs above to sync any log you wish, as long as TRIMLOG is defined.
proc_trimlogsdata() {
  ## Trim usersync.log
  if [ ! -z "$TRIMLOG" ]; then
    if [ -e "$TRIMLOG" ]; then
      if [ ! -z "$SIZE" ]; then
        BEFORESIZE="$( du -b "$TRIMLOG" | cut -f1 )"
        if [ "$SIZE" != "CLEAR" ]; then
          if [ "$SIZE" -lt "$BEFORESIZE" ]; then
            LOGNAME="$( basename $TRIMLOG )"
            proc_highdebug "Starting to trim $LOGNAME from $BEFORESIZE bytes to $SIZE bytes."
            proc_debug "Starting to trim $LOGNAME from $BEFORESIZE to $SIZE."
            BEFORESIZE="$( du -m $TRIMLOG | cut -f1 )"
            tail -c$SIZE $TRIMLOG > $TMP/NEW.LOG.tmp
            if [ -e $TMP/NEW.LOG.tmp ]; then
              mv -f "$TMP/NEW.LOG.tmp" "$TRIMLOG" >/dev/null 2>&1
              if [ ! -z "PERMS" ]; then
                chmod $PERMS $TRIMLOG >/dev/null 2>&1
              fi
              AFTERSIZE="$( du -m $TRIMLOG | cut -f1 )"
              proc_debug "Trimmed $TRIMLOG from $BEFORESIZE MB to ~$AFTERSIZE MB"
              proc_log "Trimmed $TRIMLOG from $BEFORESIZE MB to ~$AFTERSIZE MB"
              unset BEFORESIZE; unset AFTERSIZE
            else
              ERRORLEVEL=3
              proc_debug "Something went wrong with trimmming. Not moving anything."
              proc_log "Trim: Something went wrong with trimmming $TRIMLOG. Not moving anything."
            fi
            unset LOGNAME
          else
            ERRORLEVEL=3
            proc_debug "Trim not needed. $TRIMLOG is only $BEFORESIZE bytes. Trim command was $SIZE."
            proc_log "Trim not needed. $TRIMLOG is only $BEFORESIZE bytes. Trim command was $SIZE."
          fi
        else
          echo "" > $TRIMLOG
          proc_debug "Trimmed $TRIMLOG to 0 bytes."
          proc_log "Trimmed $TRIMLOG to 0 bytes."
        fi
      else
        ERRORLEVEL=3
        proc_debug "Error: Got TRIM command, but no byte count..."
        proc_log "Error: Got TRIM command, but no byte count..."
      fi
    else
      ERRORLEVEL=3
      proc_debug "Trim Error: $TRIMLOG does not exist."
      proc_log "Trim Error: $TRIMLOG does not exist."
    fi
  else
    proc_debug "Error: proc_trimlogdata was called but no TRIMLOG defined (by proc_trimlog)."
    proc_log "Error: proc_trimlogdata was called but no TRIMLOG defined (by proc_trimlog)."
  fi
}

## NEW 2003-02-08 By Turranius
## Replication procedure from mss-site.sh on the hub.
proc_updatescripts() {
  ## REPORTUPDATE causes proc_msslog() to use another 'bottrigger'.
  REPORTUPDATE="YES"
  if [ -z "$MSSREPL" ]; then
    proc_log "Error in update. Got update command but MSSREPL is undefined in config."
    ERRORLEVEL=3
    proc_debug "Error in update. Got update command but MSSREPL is undefined in config."
    proc_msslog "Error in update. Got update command but MSSREPL is undefined in config."
  else
    for each in $UPDSCRIPTS; do
      UPDSCRIPT="$( echo $each | cut -d ':' -f1 )"
      TOPATH="$( echo $each | cut -d ':' -f2 )"
      if [ -z "$UPDSCRIPT" ]; then
        proc_highdebug "Error. Got UPDATE command but no script defined."
        proc_msslog "Error. Got UPDATE command but no script defined."
      else
        if [ "$TOPATH" = "" ]; then
          LOCALBINDIR="$( dirname $0 )"
        else
          LOCALBINDIR="$TOPATH"
        fi
        BACKUPDIR="$( dirname $0 )"
        if [ -w $LOCALBINDIR ]; then
          if [ -r "$MSSREPL/$UPDSCRIPT" ]; then
            if [ ! -e $BACKUPDIR/mss_oldfiles ]; then
              proc_highdebug "Creating $BACKUPDIR/mss_oldfiles to store backup in."
              mkdir $BACKUPDIR/mss_oldfiles
            fi
            if [ -e $LOCALBINDIR/$UPDSCRIPT ]; then
              proc_highdebug "Backing up $LOCALBINDIR/$UPDSCRIPT to $BACKUPDIR/mss_oldfiles"
              if [ -w $BACKUPDIR/$UPDSCRIPT ]; then
                cp -fp $LOCALBINDIR/$UPDSCRIPT $BACKUPDIR/mss_oldfiles/
              fi
            fi
            proc_highdebug "Copying $MSSREPL/$UPDSCRIPT from $SOURCENAME to $LOCALBINDIR on $DESTNAME"
            proc_debug "Copying $MSSREPL/$UPDSCRIPT from $SOURCENAME to $LOCALBINDIR on $DESTNAME"
            cp -fp $MSSREPL/$UPDSCRIPT $LOCALBINDIR

            ## If this is mss-core.sh, make sure it has 700 afterwards...
            if [ "$UPDSCRIPT" = "mss-core.sh" ]; then
              proc_log "Forcing chmod 700 on newly replicated file: mss-core.sh"
              proc_debug "Forcing chmod 700 on newly replicated file: mss-core.sh"
              chmod 700 $LOCALBINDIR/$UPDSCRIPT
            fi

            if [ "$FETCHLOGSDIR" ]; then
              unset NEWVERSION
              NEWVERSION="$( head -n 2 $LOCALBINDIR/$UPDSCRIPT | egrep "^VER=|^VERSION=" | cut -d '=' -f2 )"
              if [ "$LOCALBINDIR" = "/" ]; then
                unset LOCALBINDIR
              fi
              if [ "$NEWVERSION" ]; then
                proc_msslog "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
                proc_log "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
                proc_debug "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
              else
                proc_msslog "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
                proc_log "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
                proc_debug "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
              fi
            else
              proc_highdebug "Ment to send a report back to $SOURCENAME but FETCHLOGSDIR is undefined in config."
            fi
          else
            proc_log "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
            ERRORLEVEL=3
            proc_debug "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
            proc_msslog "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
          fi
        else
          proc_log "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
          ERRORLEVEL=3
          proc_debug "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
          proc_msslog "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
        fi
      fi
    done
    unset each
    unset TOPATH
    unset UPDSCRIPT
    unset UPDSCRIPTS
    unset BACKUPDIR
  fi
  unset REPORTUPDATE
}

proc_synctime() {
  if [ "$SYNCTIME" = "TRUE" ]; then
    if [ -z "$USER" ]; then
      echo "Specify a user to manually sync time for."
      exit 0
    fi

    if [ ! -e "$USERDEST/$USER" ] || [ ! -e "$USERSOURCE/$USER" ]; then
      echo "User $USER does not exist on one or both sites.. skipping."
    else
      slave_time="`grep "^TIME\ " "$USERDEST/$USER" | cut -d ' ' -f3`"
      hub_time_raw="`grep "^TIME\ " "$USERSOURCE/$USER"`"

      if [ -z "$hub_time_raw" ] || [ -z "$slave_time" ]; then
        proc_log "Error when syncing TIME for $USER. Slave: $slave_time - Hub: $hub_time_raw."
        proc_debug "Error when syncing TIME for $USER. Slave: $slave_time - Hub: $hub_time_raw."
      else
        hub_time="`echo "$hub_time_raw" | cut -d ' ' -f3`"
        if [ -z "$hub_time" ]; then
          proc_log "Error when syncing TIME for $USER. Could not get hub_time from $hub_time_raw"
          proc_debug "Error when syncing TIME for $USER. Could not get hub_time from $hub_time_raw"
        else
          proc_highdebug "$USER - TIME = $SOURCENAME $hub_time / $DESTNAME $slave_time"

          if [ "$slave_time" -gt "$hub_time" ]; then
            if [ "$SKIP" != "YES" ]; then
              new_hub_time="`echo "$hub_time_raw" | sed -e "s/[0-9]* [0-9]*/ $slave_time/2"`"
              proc_highdebug "Old TIME for $USER on $SOURCENAME: $hub_time - NEW: $slave_time"
              proc_log "$USER - Updating TIME value on $SOURCENAME from $hub_time to $slave_time"
              proc_debug "Updating TIME value for $USER on $SOURCENAME from $hub_time to $slave_time"
              grep -v "^TIME\ " "$USERSOURCE/$USER" > $TMP/timesync.$USER.tmp
              echo "$new_hub_time" >> $TMP/timesync.$USER.tmp

              ## Check newly created file ment for source.
              CHECKPATH="$TMP"
              TMPUSER="$USER"
              USER="timesync.$USER.tmp"
              proc_highdebug "Checking integrity of new source file $CHECKPATH/$USER"
              proc_userver
              if [ "$VERERR" ]; then
                SKIP="YES"
                ERRORLEVEL=2
                proc_debug "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
                proc_log "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
                SCRIPTNAME="$( basename $0 )"
                echo "" >> $TMP/$USER
                echo "---New file that $SCRIPTNAME created above. Old one from $SOURCEPATH/$TMPUSER below---" >> $TMP/$USER
                echo "-- This file was created on "`date` >> $TMP/$USER
                echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
                echo "" >> $TMP/$USER
                cat $SOURCEPATH/$TMPUSER >> $TMP/$USER
                if [ ! -e $TMP/ERROR.$USER ]; then
                  mv -f "$TMP/$USER" "$TMP/ERROR.$USER" >/dev/null 2>&1
                else
                  rm -f $TMP/$USER
                fi
              fi

              ## Restore arguments
              USER="$TMPUSER"
              unset TMPUSER
              unset CHECKPATH
 
              if [ "$SKIP" != "YES" ]; then
                proc_lock_src
                if [ "$SKIP" != "YES" ]; then
                  if [ "$USERSOURCEORG" ]; then
                    cp -f "$TMP/timesync.$USER.tmp" "$USERSOURCEORG/$USER"
                  else
                    cp -f "$TMP/timesync.$USER.tmp" "$USERSOURCE/$USER"
                  fi
                  rm -f "$TMP/timesync.$USER.tmp"
                fi
                proc_unlock_src
              fi
            fi
          fi
        fi
      fi
    fi
  fi
}

## Clean up incase of broken actionfiles..
proc_cleanup() {
  unset GOTCLEANED
  if [ -e "$PASSWDSOURCE/$DESTNAME.actions.locked" ]; then
    rm -f "$PASSWDSOURCE/$DESTNAME.actions.locked"
    proc_debug "Cleaning up $PASSWDSOURCE/$DESTNAME.actions.locked"
    proc_log "Cleaning up $PASSWDSOURCE/$DESTNAME.actions.locked"
    GOTCLEANED="TRUE"
  fi
  if [ -e "$PASSWDSOURCE/$DESTNAME.actions" ]; then
    rm -f "$PASSWDSOURCE/$DESTNAME.actions"
    proc_debug "Cleaning up $PASSWDSOURCE/$DESTNAME.actions"
    proc_log "Cleaning up $PASSWDSOURCE/$DESTNAME.actions"
    GOTCLEANED="TRUE"
  fi
  if [ -e "$PASSWDDEST/$DESTNAME.actions.notdone" ]; then
    rm -f "$PASSWDDEST/$DESTNAME.actions.notdone"
    proc_debug "Cleaning up $PASSWDDEST/$DESTNAME.actions.notdone"
    proc_log "Cleaning up $PASSWDDEST/$DESTNAME.actions.notdone"
    GOTCLEANED="TRUE"
  fi
  if [ -z "$GOTCLEANED" ]; then
    proc_debug "No old actionfiles found to clean.."
  fi
}

## NEW 2003-07-13 by Turranius
## Proc for reporting settings in shell.
proc_report() {
  echo "Settings report for MSS v$VER"
  echo ""

  echo "General settings:"
  echo "- Name of the hub server: $SOURCENAME"
  echo "- Name of this slave    : $DESTNAME"
  if [ "$GL_VERSION" ]; then
    echo "- Defined glftpd version: $GL_VERSION"
  else
    echo "- Defined glftpd version: NONE. Will assume this is the 1+ series."
  fi
  echo ""
  echo "- Users will be synced from : $USERSOURCE"
  echo "- Users will be synced to   : $USERDEST"
  echo "- passwd & group will be synced from : $PASSWDSOURCE"
  echo "- passwd & group will be synced to   : $PASSWDDEST"
  echo "- passwd & group will be compared using $MD5BIN"
  echo "- group files will be synced from : $GROUPSSOURCE"
  echo "- group files will be synced to   : $GROUPSDEST"
  echo ""
  if [ "$BACKUPDEST" ]; then
    echo "- On full syncs, it will backup to   : $BACKUPDEST"
    echo "- And it will keep $MAXBACKUPS old backups."
  else
    echo "- BACKUPDEST is empty. No backups will be made. This isnt to good really."
  fi
  echo "- The root dir is set to $GLROOT"
  echo "- Temporary dir set to $TMP. Crap will be written here while processed."
  if [ "$EXCLUDE" = "FEu38ru38fj" ]; then
    echo "- EXCLUDE is empty. No users will be excluded from the sync."
  else
    echo "- EXCLUDE is set to not sync $EXCLUDE. Note that this does not mean that you"
    echo "  can have users that are on the slave but not on the hub."
  fi
  echo "- The lockfile, so it dosnt run twice, is set to $LOCKFILE."
  if [ "$PERMS" ]; then
    echo "- PERMS is set to $PERMS. This is what the userfiles will be chmod'ed too each run."
  else
    echo "- PERMS is empty. We will not chmod the users in any way."
  fi
  echo ""
  
  echo "Connection settings:"
  if [ "$PINGTEST" = "TRUE" ]; then
    echo "- PINGTEST is TRUE, meaning it will try to ping the hub first to check if its up."
    echo "- It will try to ping $DNSHUB with 'ping $PINGOPTIONS'"
  else
    echo "- PINGTEST is FALSE, meaning it will not check a ping to the hub first."
  fi
  if [ "$USENFS" != "FALSE" -o "$USENFS" != "" ]; then
    echo "- USENFS is ON. This means it will check with $RPCINFO if $DNSHUB is up"
    echo "  It will do this by checking the following services: $USENFS"
  else
    echo "- USENFS is FALSE. No checking with rpcinfo if the hub is up first."
  fi
  if [ "$REMOUNT" = "TRUE" ]; then
    echo "- REMOUNT is TRUE. If $USERSOURCE/$VERIFYUSER or $PASSWDSOURCE/passwd is not found, it will try and remount them."
  else
    echo "- REMOUNT is FALSE. Will not try and remount $USERSOURCE or $PASSWDSOURCE."
  fi
  echo "- We will see if we can read user > $VERIFYUSER < to detirmine if the hub is up."
  if [ "$RUNLOCAL" ]; then
    echo "- RUNLOCAL is TRUE. Userfiles will be copied and backup up from the hub before running. Good !"
  else
    echo "- RUNLOCAL is FALSE. Userfiles will not be copied or backed up from the hub. Bad !"
  fi
  echo ""

  echo "Log settings:"
  if [ "$LOG" ]; then
    echo "- Normal sync LOG set to $LOG."
  else
    echo "- Normal sync LOG is empty. No logging will take place."
  fi
  if [ "$STATLOG" ]; then
    echo "- STATLOG is $STATLOG. All moved stats will go to that one."
  else
    echo "- STATLOG is empty. No logging will be done when moving stats."
  fi
  if [ "$HIGHDEBUGLOG" ]; then
    echo "- HIGHDEBUGLOG set to $HIGHDEBUGLOG. Basically everything it does goes here."
  else
    echo "- HIGHDEBUGLOG is not defined. Debug information will not be logged."
  fi
  echo ""

  echo "Actionfile settings:"
  echo "- When sending reports to the hub, these will land in $FETCHLOGSDIR."
  echo "- When replicating scripts from the hub to here, it will look in $MSSREPL for them."
  echo "- The actionfile itself will be read from $PASSWDSOURCE."
  echo "" 

  echo "Syncing options:"
  if [ "$SHAREALLOTMENT" = "FALSE" ]; then
    echo "- SHAREALLOTMENT is FALSE. Credits for allotment users will be set to 1MB on this slave. Good."
  else
    echo "- SHAREALLOTMENT is FALSE. Users will get weekly allotment on this slave too (double credits) !"
  fi
  if [ -z "$SLOWTIME" ]; then
    echo "- WARNING: SLOWTIME is not set. You will get sleep errors. Set it to 0."
  else
    echo "- Between each synced user, we will sleep for $SLOWTIME seconds to be safe."
  fi

  if [ "$KEEPSTATS" != "TRUE" ]; then
    echo "- KEEPSTATS is not TRUE. All enabled stats will be moved from their respective fields."
  else
    echo "- KEEPSTATS is TRUE. All enabled stats will be added with DAYUP/DAYDN from this slave."
  fi
  if [ "$MOVESTATS" ]; then
    echo "- The following stats will be moved back to $SOURCENAME: $MOVESTATS"
  else
    echo "- MOVESTATS is not defined. No stats will be moved."
  fi
  echo ""
  echo "NUKE settings:"
  if [ "$MOVENUKE" = "TRUE" ]; then
    echo "- NUKE stats will be moved back to the hub."
  else
    echo "- NUKE stats will NOT be moved back to the hub."
  fi
  if [ "$WITHDRAWNUKE" ]; then
    echo "- The following fields will be deducted from nuke values: $WITHDRAWNUKE"
  else
    echo "- WITHDRAWNUKE is not defined. No nuke values will be deducted from stats on the hub."
  fi
}

## Fix for running from shell without any set $USER.
if [ "$USER" = "root" ]; then
  unset USER
fi

if [ "$1" = "" ]; then
  proc_help
else
  case $1 in
    full) FULL="YES"; proc_fullsync; proc_exit;;
    fullsync) proc_fullsync; proc_exit;;
    fullstats) proc_fullstats; proc_exit;;
    singlefull) USER="$2"; proc_singlefull; proc_exit;;
    singlesync) USER="$2"; proc_singlesync; proc_exit;;
    singlestat) USER="$2"; proc_singlestat; proc_exit;;
    synctime) SYNCTIME="TRUE"; USER="$2"; proc_synctime; proc_exit;;
    syncfiles) proc_syncfiles; proc_exit;;
    setperms) proc_setperms; proc_exit;;
    backup) COPYLOCAL="TRUE"; proc_copylocal; proc_backup; proc_exit;;
    delete) proc_delusers;proc_exit ;;
    renuser) USER="$2"; NEWUSER="$3"; proc_renuser; proc_exit;;
    singledel) USER="$2"; proc_singledel; proc_exit;;
    actionfile) proc_actionfile; proc_exit;;
    fetchlog) proc_fetchlog; proc_exit; proc_exit;;
    integrity) proc_userpasswdintegrity; proc_exit;;
    report) proc_report; proc_exit;;
    movecreds) DEBUG="TRUE"; COMMAND="$*"; proc_movecreds; proc_exit;;
    cleanup) proc_cleanup; proc_exit;;
    *) proc_help;;
  esac
fi

proc_exit
