#!/bin/bash
VER=1.1

#----------------------------------------------------------------------
# Note. This script is NOT required. mss-core.sh does the same thing
# when running 'actionfile' etc, but if you get a lot of false alarms,
# you might want to crontab this script every minute as well.
# REPORTLIFE must be TRUE for this one to do anything. Same as for
# mss-core.sh
#
# * * * * *       /glftpd/bin/mss-pong.sh
# is a good crontab line
#----------------------------------------------------------------------

## Remove the # from the below line to hard set your glftpd root.
## Otherwise, it will be read from mss-slave.id in the same folder
## as mss-core.sh (recomended)
# GLROOT=/glftpd

## Ignore this!
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same place as mss-core.sh (recomended)
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

#--[ GO ]--------------------------------------#

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi
if [ -r "$MSSSLAVECONFIG" ]; then
  . $MSSSLAVECONFIG
else
  echo "MSS error: Config file: $MSSSLAVECONFIG not found or no permissions to read it."
  exit 0
fi

if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    rm -f $LOCKFILE
    exit 0
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      rm -f $LOCKFILE
      exit 0
    fi
  fi
fi

proc_pong() {
  if [ "$REPORTLIFE" = "TRUE" ]; then
    if [ -d "$REPORTDIR" ]; then
      echo `date "+%a %b %e %T %Y"` PONG: \"$DESTNAME reports alive\" >> $REPORTDIR/$DESTNAME.msg
    else
      if [ "$HIGHDEBUGLOG" ]; then
        echo `date "+%a %b %e %T %Y"` PONG: \"Cant find $REPORTDIR. Quitting\" >> $HIGHDEBUGLOG
      fi
    fi
  fi
}

proc_pong

exit 0
