#!/bin/bash
VER=2.1
##############################################################
# IdleBotKick - Kick Idlers or a specific User               #
#------------------------------------------------------------#
# A script for kicking all idlers, or a specific user.       #
# This is done from irc, usally by @ only.                   #
#                                                            #
# Running this with !kick only (default trigger) will kick   #
# everyone in the state of Idle. A verify time can be        #
# specified so that it verifies that they are still idle.    #
# You may also do !kick <username> and it will kick only     #
# that user from site (no verify time).                      #
#                                                            #
#--[ Thanks ]------------------------------------------------#
#                                                            #
# 2.0 decoy- for suggesting verify timer/skipping killbin.   #
#     zio/psxc for helping me with getting ncftp to work.    #
# 2.1 _qarf for suggesting GEXCLUDE ( exclude on groups ).   #
#                                                            #
#--[ Installation ]------------------------------------------#
# Copy idlebotkick.sh to /glftpd/bin                         #
# Copy idlebotkick.tcl to your bots "config" folder.         #
# Edit idlebotkick.tcl to see some short instructions.       #
# Add idlebotkick.tcl to your bots config file and rehash it.#
#  The tcl is set to only allow this to ops by default.      #
#                                                            #
# This script uses tur-ftpwho to list idlers etc. Its just a #
# modified ftpwho binary. The binary included is compiled on #
# Mandrake, and should work for debian, redhat etc. If you   #
# must/would rather recompile your own, the source is        #
# included. ( gcc -o tur-ftpwho tur-ftpwho.c ).              #
# You need to edit the source if you run glftpd on another   #
# ipc_key as well.                                           #
#                                                            #
# Copy tur-ftpwho to /glftpd/bin (same as for KTMF, so if    #
# you use that one already, you're fine.)                    #
# Try running it from shell and it should show some info.    #
# Make sure it is executable by the user who runs the bot.   #
#  ( chmod 755 /glftpd/bin/tur-ftpwho )                      #
#  ( chmod 755 /glftpd/bin/idlebotkick.sh )                  #
#                                                            #
# It also uses ncftpls, so that must be installed as well.   #
# Tested with version 3.1.5 of the nCFTP Client package.     #
# ncftpls must be executable by the user who runs the bot as #
# it will log in and actually run 'site kill' on the idlers  #
# pid numbers. http://www.ncftp.com                          #
#                                                            #
# To test it, su to the user running the bot and do this:    #
# ncftpls -u<user> -p<pw> -P<port> ftp://host                #
# It should list the files in / of the ftp. You might have   #
# specify full path to ncftpls.                              #
#                                                            #
# Some notes about some settings.                            #
# VERIFYTIME is the time between finding a idle user and     #
# verifying that he is still idle. This is a delay in the    #
# script and the problem is that it halts the bot during     #
# this time. So.. Dont set this too high. 4-15 seconds       #
# should be fine.                                            #
#                                                            #
# FTPUSER is the user that will log in and do 'site kill'.   #
# This user must have access to this command. By default, he #
# must have flag E for 'site kill/swho'. <- MAKE SURE !      #
# You should give him flag 4 as well, so he can log in even  #
# if site is full.                                           #
#                                                            #
# Now then. Change the settings below.                       #
#                                                            #
#-[ Settings ]-----------------------------------------------#

WHOBIN=/glftpd/bin/tur-ftpwho  # Full path to tur-ftpwho
USERDIR=/glftpd/ftp-data/users # Path to users
SHOWKICKS="TRUE"               # Show who we kick, etc? 
                               # TRUE/FALSE

EXCLUDE="turranius ostnisse"   # Excluded users, space delimited.

GEXCLUDE="SiTEOPS NUKER"       # Excluded groups, space delimited.

VERIFYTIME="10"                # Time to delay for verify.

## ncftpls settings.
NCFTPLS=/usr/local/bin/ncftpls
FTPUSER=glftpd                 # <- MUST EXIST AND HAVE FLAG E!
FTPPASS=ChangeMe
FTPHOST=localhost
FTPPORT=21

BOLD=""                      # Dont change this one :)

## Some text for you to edit, if you have SHOWKICKS on TRUE.
## Start and stop bold with $BOLD

# Idlers kick (no argument given).
SHOWHEAD="Kicking idle user(s) $BOLD"
SHOWFOOT="$BOLD, byyye!"
SHOWNOIDLERS="No idlers online, leech later"

# User kick (argument given).
USERKICK="Username:$BOLD $1$BOLD kixxored."
NOUSERKICK="Username:$BOLD $1$BOLD was not found online."
USEREXCLUDED="$BOLD$1$BOLD is way to leet to be kicked."


#################################################
# No changes below here                         #
#################################################

if [ -z "$EXCLUDE" ]; then
  EXCLUDE="R3j3jr3l3r"
fi

if [ ! -x $NCFTPLS ]; then
  echo "Cant execute ncftpls. Check path and perms for user running the bot."
  exit 1
fi

if [ -z "$1" ]; then
  SEXCLUDE="$( echo "$EXCLUDE" | tr -s ' ' '|' )"
  for rawdata in `$WHOBIN | grep -w "Idle:" | sed -e 's/-NEW-/NotLoggedIn/' | egrep -v "$SEXCLUDE" | tr -d ' '`; do
    user="$( echo $rawdata | cut -d '^' -f1 )"
    unset EXCLUDEDBYGROUP
    for egroup in $GEXCLUDE; do
      if [ "$( grep -x "GROUP $egroup" $USERDIR/$user )" ]; then
        EXCLUDEDBYGROUP="TRUE"
      fi
    done
    
    if [ "$EXCLUDEDBYGROUP" != "TRUE" ]; then
      upid="$( echo $rawdata | cut -d '^' -f2 )"
      if [ -z "$VERIFYTIME" ]; then
        if [ -z "$USERS" ]; then
          USERS="$user"
          KUSERS="$user"
        else
          USERS="$USERS $user"
          KUSERS="$USERS|$user"
        fi
        if [ -z "$PIDS" ]; then
          PIDS="$upid"
        else
          PIDS="$PIDS $upid"
        fi
      else
        if [ -z "$KUSERS" ]; then
          KUSERS="$user"
        else
          KUSERS="$KUSERS|$user"
        fi
      fi
    fi
  done

  if [ "$VERIFYTIME" != "" -a "$KUSERS" != "" ]; then
    if [ "$SHOWKICKS" = "TRUE" ]; then
      NUSERS="$( echo "$KUSERS" | tr -s '|' ' ' )"
      echo "Kept an eye on $BOLD$NUSERS$BOLD for the past $VERIFYTIME seconds."
      FOUND="TRUE"
    fi
    sleep $VERIFYTIME

    for rawdata in `$WHOBIN | grep -w "Idle:" | sed -e 's/-NEW-/NotLoggedIn/' | egrep "$KUSERS" | egrep -v "$SEXCLUDE" | tr -d ' '`; do
      user="$( echo $rawdata | cut -d '^' -f1 )"
      upid="$( echo $rawdata | cut -d '^' -f2 )"
      if [ -z "$USERS" ]; then
        USERS="$user"
      else
        USERS="$USERS $user"
      fi
      if [ -z "$PIDS" ]; then
        PIDS="$upid"
      else
        PIDS="$PIDS $upid"
      fi
    done   
  fi

  if [ "$SHOWKICKS" = "TRUE" ]; then
    if [ -z "$USERS" ]; then
      if [ "$FOUND" = "TRUE" ]; then
        echo "No users idling anymore."
      else
        echo "$SHOWNOIDLERS"
      fi
    else
      echo "$SHOWHEAD$USERS$SHOWFOOT"
    fi
  fi

  if [ "$PIDS" ]; then
    for pid in $PIDS; do
      $NCFTPLS -u$FTPUSER -p$FTPPASS -P$FTPPORT -Y"site kill $pid" ftp://$FTPHOST 2> /dev/null > /dev/null
    done
  fi
fi

## A user was specified.
if [ "$1" ]; then
  SEXCLUDE="$( echo $EXCLUDE | tr -s ' ' '|' )"

  ## Check on group
  for egroup in $GEXCLUDE; do
    if [ "$( grep "GROUP $egroup" $USERDIR/$1 )" ]; then
      echo "$USEREXCLUDED"
      exit 0
    fi
  done

  CHECKEXCLUDE="$( echo "$EXCLUDE" | grep -w $1 )"
  if [ "$CHECKEXCLUDE" ]; then
    echo "$USEREXCLUDED"
    exit 0
  fi
  for rawdata in `$WHOBIN | grep -w -- "$1" | tr -d ' '`; do
    user="$( echo $rawdata | cut -d '^' -f1 )"
    upid="$( echo $rawdata | cut -d '^' -f2 )"
    if [ -z "$PIDS" ]; then
      PIDS="$upid"
    else
      PIDS="$PIDS $upid"
    fi
  done
  if [ "$SHOWKICKS" = "TRUE" ]; then
    if [ -z "$PIDS" ]; then
      echo "$NOUSERKICK"
    else
      echo "$USERKICK"
    fi
  fi
  if [ "$PIDS" ]; then
    for pid in $PIDS; do
      $NCFTPLS -u$FTPUSER -p$FTPPASS -P$FTPPORT -Y"site kill $pid" ftp://$FTPHOST 2> /dev/null > /dev/null
    done
  fi
fi


