#!/bin/bash
VER=1.0
##################################################################
# SCRIPTNAME : MSSPOST
# AUTHOR     : void0 (void0@mail.com) / Turranius
# VERSION    : 1.0
# DESCRPTION : This script creates MSS action-files for glFTPd
#              SITE commands that affect the passwd, group and/or
#              userfiles, and is to be run a POST cscript from
#              the glFTPd configuration file.
#
# INSTALLATION 
# Put in same dir as mss-hub.conf ( /glftpd/bin ? )
#
# Add the following to /etc/glftpd.conf
#   cscript SITE[:space:]ADDIP POST /bin/mss-post.sh
#   cscript SITE[:space:]DELIP POST /bin/mss-post.sh
#   cscript SITE[:space:]DELUSER POST /bin/mss-post.sh
#   cscript SITE[:space:]READD POST /bin/mss-post.sh
#   cscript SITE[:space:]TAGLINE POST /bin/mss-post.sh
#   cscript SITE[:space:]ADDUSER POST /bin/mss-post.sh
#   cscript SITE[:space:]CHGRP POST /bin/mss-post.sh
#   cscript SITE[:space:]CHPASS POST /bin/mss-post.sh
#   cscript SITE[:space:]PURGE PRE /bin/mss-post.sh
#   cscript SITE[:space:]GADDUSER POST /bin/mss-post.sh
#   cscript SITE[:space:]CHANGE POST /bin/mss-post.sh
#   cscript SITE[:space:]PASSWD POST /bin/mss-post.sh
#   cscript SITE[:space:]RENUSER POST /bin/mss-post.sh
#   cscript SITE[:space:]GRPDEL POST /bin/mss-post.sh
#   cscript SITE[:space:]GRPREN POST /bin/mss-post.sh
#   cscript SITE[:space:]GRPADD POST /bin/mss-post.sh
#   cscript SITE[:space:]GRPLOG POST /bin/mss-post.sh
#   cscript SITE[:space:]GRPNFO POST /bin/mss-post.sh
#
#   If you use glftpd 2+, you'll want these as well.
#
#   cscript SITE[:space:]GRPCHANGE POST /bin/mss-post.sh
#   cscript SITE[:space:]CHGADMIN POST /bin/mss-post.sh
#
# -> Note that PURGE should be PRE. All others POST. <-
#
# Make sure you have the following binaries in glftpd's bin dir:
# dirname, cut, grep.
#
# HISTORY
#   1.0  - Chg: Added support for glftpd 2.0 (works fine for 1.3+ too).
#               Two new cscript settings for GRPCHANGE and CHGADMIN.
#
#   0.9  - Fix: If you hardset GLROOT=, it most likely didnt work too well.
#               Added a small check below that which you shouldnt touch. /Turranius
#   0.8  - Fix: Another PURGE problem fixed. Could fix it in mss-core.sh
#               but felt it was easier for everyone if I did it in here.
#               It will now write one 'PURGE username' for each user purged
#               instead of 'PURGE username1 username2 etc'. 
#   0.7  - Fix: cscript PURGE should be PRE, not POST. /Turranius
#          CHG: Rewrote how it handles all purged users (when issuing
#               'site purge' without any arguments). /Turranius
#   0.6  - Fix: Fixed so it works on fbsd too. /Turranius
#   0.5  - Fix: When doing 'site purge username' it would add all
#               users with flag 6 to the purge list. It never detected
#               that you specified a user due to a spelling error. /Turranius
#   0.4  - Add: Now uses mss-hub.id                                /Turranius
#          Add: Will look for mss-hub.id in the same dir
#               as it is in itself. Config can be hardcoded too.   /Turranius
#   0.3  - CHG: SYNC USER and SYNC FULL to SYNC BASIC
#   0.2  - CHG: Moved PURGE to its own case since ACT_PURGE were
#               not set.
#          CHG: Removed the USERLIST="$2" from PASSWD since only
#               passwd needs updating.
#   0.1  - First release! :)
#
# THANKS
#   Turranius for listening and implementing my ideas in MSS and
#   for making useful scripts for the public. Keep up the good!
#
##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-hub.id in the same dir as mss-post.sh
## Recomended you leave it with a # infront.
# GLROOT="/glftpd"

## Ignore this!
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

## Remove the # from the below line to hard set where mss-hub.conf is.
## Otherwise, it will be read from the same dir as mss-post.sh is in.
## Recomended you leave it with a # infront.
# MSSHUBCONFIG=$GLROOT/bin/mss-hub.conf

##################################################################
# READ CONFIG FILE
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="`dirname $0`/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "GLROOT not set. Either create a file called mss-hub.id and add 'GLROOT=/glftpd'"
    echo "or add that line to mss-hub.conf."
    echo "This can also mean I do not have permission to read mss-hub.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 1
    fi
  fi
fi
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

if [ -z $MSSHUBCONFIG ]; then
  MSSHUBCONFIG="`dirname $0`/mss-hub.conf"
fi

if [ ! -r $MSSHUBCONFIG ]; then
  echo "Error. Cant not read $MSSHUBCONFIG"
  exit 1
else
  . $MSSHUBCONFIG
fi

if [ -z "$SOURCENAME" ]; then
  IDENTFILE="`dirname $0`/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "SOURCENAME not set. Either create a file called mss-slave.id and add 'SOURCENAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$SOURCENAME" ]; then
      echo "Error. Cant read SOURCENAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

##################################################################
# FUNCTIONS
##################################################################
putlog()
{
    if [ "$VERBOSE" == "TRUE" ]; then
	echo "$*"
    fi
    if [ ! -z "$LOG" ]; then
	echo `date +'%a %b %e %T %Y'` "MSSPOST:" "$*" >> $LOG
    fi
}

##################################################################
write_action()
{
    putlog "Writing '$*' to slave(s) actionfile."
    for CURSLAVE in $SLAVES; do
	echo "$*" >> "$GLETC/$CURSLAVE.actions"
    done
}

##################################################################
# CORE
##################################################################
SCRIPTNAME="MSSPOST"
AUTHOR="void0 (void0@mail.com)"

##################################################################
## Verify logfile
if [ -e "$LOG" ]; then
    if [ ! -f "$LOG" ]; then
	putlog "Logfile exists but is not a file."
    fi
fi

## You can # this line if you dont want the spam in the logs.
putlog "$SCRIPTNAME v$VER by $AUTHOR - Start"

## Verify actions-directory
if [ -e "$GLETC" ]; then
    if [ ! -d "$GLETC" ]; then
	putlog "Actions-directory exists ($GLETC) but is not a directory."
	exit
    fi
fi
if [ ! -w "$GLETC" ]; then
    putlog "Actions-directory ($GLETC) is not writeable."
    exit
fi

## Begin parsing the command (if any)
GLCMD="`echo "$1" | tr -s ' '`"
if [ "`echo "$GLCMD" | cut -d' ' -f1`" == "SITE" ]; then
    putlog "Got command '$GLCMD'"

    TYPE="`echo "$GLCMD" | cut -d' ' -f2 | tr '[:lower:]' '[:upper:]'`"
    ARGS="`echo "$GLCMD" | cut -d' ' -f3-`"

    ACT_PASSWD=0
    ACT_GROUP=0
    ACT_FULLSYNC=0
    ACT_RENUSER=0
    ACT_PURGE=0
    USERLIST=""

    putlog "Command type is '$TYPE'"
    case "$TYPE" in
	## Userfile affectors
	ADDIP | DELIP | DELUSER | READD)
	    USERLIST="`echo "$ARGS" | cut -d' ' -f1`"
	;;
	TAGLINE)
	    USERLIST="$2"
	;;
	## Userfile and passwd affectors
	ADDUSER | CHGRP | CHPASS)
	    ACT_PASSWD=1
	    USERLIST="`echo "$ARGS" | cut -d' ' -f1`"
	;;
	GADDUSER)
	    ACT_PASSWD=1
	    USERLIST="`echo "$ARGS" | cut -d' ' -f2`"
	;;
	CHANGE)
	    ACT_PASSWD=1
	    case "$ARGS" in
		=*)
		    MATCHGRP="`echo $ARGS | cut -d' ' -f1 | cut -c2-`"
		    putlog "Fetching users in group '$MATCHGRP'"
		    for CURUSER in `grep -i "^GROUP[:space:]*MATCHGRP" $GLUSERS/* | cut -d':' -f1`
		    do
			USERLIST="$USERLIST `basename "$CURUSER"`"
		    done
		;;
		{*)
		    MATCHUSR="`echo $ARGS | sed "s/{ //g"`"
		    for CURUSER in $MATCHUSR
		    do
			if [ "`echo $CURUSER | cut -c1`" == "}" ]; then break; fi
			if [ "`echo $CURUSER | cut -c1`" != "*" ] && [ -f "$GLUSERS/$CURUSER" ]; then
			    if [ -z "`echo $USERLIST | grep "$CURUSER"`" ]; then
				USERLIST="$USERLIST $CURUSER"
			    fi
			fi
		    done
		;;
		*)
		    if [ "`echo "$ARGS" | cut -c1`" == "*" ]; then
			ACT_FULLSYNC=1
		    else
			CURUSER="`echo "$ARGS" | cut -d' ' -f1`"
			if [ -f "$GLUSERS/$CURUSER" ] && [ -r "$GLUSERS/$CURUSER" ]; then
			    USERLIST="$USERLIST $CURUSER"
			fi
		    fi
		;;
	    esac
	;;    
	RENUSER)
	    ACT_PASSWD=1
	    ACT_RENUSER=1
	    USERLIST="`echo "$ARGS" | cut -d' ' -f1` `echo "$ARGS" | cut -d' ' -f2`"
	;;
	PURGE)
	    ACT_PASSWD=1
	    ACT_PURGE=1
	    USERLIST="`echo "$ARGS" | cut -d' ' -f1`"
	    if [ -z "$USERLIST" ]; then
		putlog "Fetching all deleted users for PURGE'ing"
		for CURUSER in `grep "^FLAGS .*6.*" $GLUSERS/* | cut -d':' -f1`
		do
		    USERLIST="$USERLIST `basename "$CURUSER"`"
		done
	    fi
	;;
	## passwd affectors
	PASSWD)
	    ACT_PASSWD=1
	;;
	## Userfile and group affectors
	GRPREN)
	    ACT_GROUP=1
	    MATCHGRP="`echo $ARGS | cut -d' ' -f1`"
	    putlog "Fetching users in group '$MATCHGRP'"
	    for CURUSER in `grep -i "^GROUP[:space:]*MATCHGRP" $GLUSERS/* | cut -d':' -f1`
	    do
		USERLIST="$USERLIST `basename "$CURUSER"`"
	    done
	;;
        CHGADMIN)
            ACT_GROUP=1
            USERLIST="`echo $ARGS | cut -d' ' -f1`"
        ;;
	## group affectors
	GRPADD | GRPLOG | GRPNFO | GRPDEL | GRPCHANGE)
	    ACT_GROUP=1
	;;
	## Default
	*)
	    putlog "SITE command '$TYPE' is not supported."
	    exit
	;;
    esac   

    USERLIST="`echo $USERLIST | tr -s ' '`"

    if [ "$ACT_PASSWD" == "1" ]; then write_action "SYNC PASSWD"; fi
    if [ "$ACT_GROUP" == "1" ]; then write_action "SYNC GROUP"; fi
    if [ "$ACT_FULLSYNC" == "1" ]; then write_action "SYNC BASIC *"; fi
    if [ ! -z "$USERLIST" ]; then
	if [ "$ACT_RENUSER" == "1" ]; then write_action "RENUSER $USERLIST";
	elif [ "$ACT_PURGE" == "1" ]; then for username in $USERLIST; do write_action "PURGE $username"; done
	else
	    putlog "Affected users: $USERLIST"
	    write_action "SYNC BASIC $USERLIST"
	fi
    fi
fi

##################################################################
# END OF SCRIPT
##################################################################
