#!/bin/sh
VER=0.1
##################################################################
# SCRIPTNAME : MSS-CUSTOM
# AUTHOR     : Turranius
# DESCRPTION : This script creates a MSS .notdone action-file on
#              the slave to do various things on various commands.
#              Loosly Based on mss-rlscomp.sh by void0
#
#
# INSTALLATION:
#
# Well, basically this script is ment to be used as a
# post script to any other command. What it writes to the
# actionfile can be defined with the SEND setting below.
#
# Make sure your actionfile system works before playing with
# this one.
#
# For instance: You want it to sync full stats when someone
# does a pre? Add this to glftpd.conf
#  cscript  site[:space:]pre post /bin/mss-custom.sh
# Then set SEND below to 'SYNC STATS *'
#
# That will send SYNC STATS * to the actionfile whenever
# someone does a site pre.
#
# You can use it as a pre command as well.
#
# *-[ IMPORTANT ]-********************************************************
# You can use it as a post command, but that does not appear to be
# working on custom scripts, only glftpd internal commands or something.
# Havent had time to determine which works and which dosnt yet.
# *-[ IMPORTANT ]-********************************************************
#
# $2 can be used in SEND for the username of the person
# giving the command and $3 can be given for the users primary
# group (although no functions exist for groups in mss-core.sh).
# Use a * to execute it on all users.
#
# Commands you can use in SEND, accepted by mss-core.sh.
# SYNC STATS <user/*>   = Move stats back to hub.
# SYNC BASIC <user/*>   = Sync userinfo.
# SYNC FULL <user/*>    = Sync userinfo and move stats.
# FETCHLOG              = Move this slaves logs back to hub.
# INTEGRITY             = Check integrity of userfiles/passwd
# DELREPORTS            = Remove all reports on the hub from this slave.
# DELLOGS               = Delete all logs on the hub from this slave.
# BACKUP                = Run a userbackup.
#
# If you want another function for another command, just copy this
# script to another name, set in SEND what it should do and add a 
# cscript in glftpd.conf, with the command that you want it to trigger on.
# 
# Logging from this script will go to the same log as mss-rlscomp.sh
# uses. You set that in mss-slave.conf.
#
# mss-core.sh will complain to the LOG (defined in mss-slave.conf) if you
# set commands here that is not accepted by mss-core.sh.
#
# HISTORY
#   0.1  - First release!
#
# THANKS
#   [Acido] for suggesting this for prees. Since I cant make it
#   fetch the usernames of people who got creds, I made it so it
#   can be used for any command you want something to sync on.
#
##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-slave.id in the same folder as mss-rlscomp.sh
# GLROOT="/glftpd"

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same folder as mss-rlscomp.sh is in.
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

## What to send to the actionfile. $2 = user. * = all users.
SEND="SYNC STATS *"

##################################################################
# READ CONFIG
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  GLROOT=""
fi

if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi

if [ ! -r $MSSSLAVECONFIG ]; then
  echo "Error. Cant not read $MSSSLAVECONFIG"
  exit 0
else
  . $MSSSLAVECONFIG
fi

if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      exit 0
    fi
  fi
fi

##################################################################
# FUNCTIONS
##################################################################
putlog()
{
    if [ "$VERBOSE" == "TRUE" ]; then
	echo "$*"
    fi
    if [ ! -z "$RLSCOMPLOG" ]; then
	echo `date +'%a %b %e %T %Y'` "MSSCUSTOM:" "$*" >> $RLSCOMPLOG
    fi
}

##################################################################
write_action()
{
    putlog "$username/$group executed: $command - Writing '$SEND' to actionfile."
    echo "$SEND" >> "$PASSWDDEST/$DESTNAME.actions.notdone"
}

##################################################################
# CORE
##################################################################

## Verify logfile
if [ -e "$RLSCOMPLOG" ]; then
    if [ ! -f "$RLSCOMPLOG" ]; then
	putlog "Logfile exists but is not a file."
    fi
fi

putlog "MSS-POSTPRE v$VER by Turranius - Start"

## Verify DESTNAME
if [ -z "$DESTNAME" ]; then
    putlog "DESTNAME is not set!"
    exit
fi

## Verify actions-directory
if [ -e "$PASSWDDEST" ]; then
    if [ ! -d "$PASSWDDEST" ]; then
	putlog "Actions-directory exists but is not a directory."
	exit
    fi
fi
if [ ! -w "$PASSWDDEST" ]; then
    putlog "Actions-directory is not writeable."
    exit
fi

if [ ! "$1" ]; then
  putlog "Warning. No argument after command."
  exit 0
else
  command="$1"
  username="$2"
  group="$3"
  write_action 
fi

##################################################################
# END OF SCRIPT
##################################################################
