#!/bin/bash
VER=2.5.2

## Remove the # from the below line to hard set your glftpd root.
## Otherwise, it will be read from mss-slave.id in the same folder
## as transfercredits.sh/mss-core.sh
# GLROOT=/glftpd

## Ignore this part.
if [ "$GLROOT" ]; then if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi; fi

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same place as transfercredits.sh/mss-core.sh
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

##############################################
# GO                                         #
##############################################

## Read GLROOT from mss-slave.id if its not hardcoded above.
if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

## Read DESTNAME from mss-slave.id
if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -d "$GLROOT" ] && [ "$FLAGS" ]; then unset GLROOT; fi

## Read mss-slave.conf
if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi
if [ -r "$MSSSLAVECONFIG" ]; then
  . $MSSSLAVECONFIG
else
  echo "MSS error: Config file: $MSSSLAVECONFIG not found or no permissions to read it."
  exit 0
fi

## Verify that we got all the settings.
if [ "$COMMAND" -a "$TMP" -a "$BIN" -a "$MINAMOUNT" -a "$MAXAMOUNT" -a "$AUTOMATICSTATUS" ]; then
  GOODTOGO="TRUE"
else
  echo "Error: One of the settings is empty or not set. Needed settings in mss-slave.conf are:"
  echo "COMMAND, TMP, BIN, MINAMOUNT, MAXAMOUNT and AUTOMATICSTATUS"
  echo "Include TRANSFERLOG if you want a log as well."
  echo "If you just upgraded, make sure you read the CHANGELOG for how to upgrade."
  exit 1
fi

################################################################
# Finished reading config.                                     #
################################################################

## Running from Shell or glftpd?
if [ -z "$FLAGS" ]; then
  MODE="SHELL"
  SHELLUSER="$USER"
  TAKE="$1"
  USER="$2"
  CREDS="$3"
  DESTSLAVE="$4"
  unset TRANSFERTAX
else
  ## Verify existance of required binaries
  if [ ! -x "$BIN/sed" ]; then
    echo "Seems you do not have 'sed' in $GLROOT$BIN. Copy sed there."
    exit 1
  fi
  if [ ! -x "$BIN/tr" ]; then
    echo "Seems you do not have 'tr' in $GLROOT$BIN. Copy tr there."
    exit 1
  fi
  if [ ! -x "$BIN/cut" ]; then
    echo "Seems you do not have 'cut' in $GLROOT$BIN. Copy cut there."
    exit 1
  fi
  if [ ! -x "$BIN/bc" ]; then
    echo "Seems you do not have 'bc' in $GLROOT$BIN. Copy bc there."
    exit 1
  fi
  if [ ! -x "$BIN/expr" ]; then
    echo "Seems you do not have 'expr' in $GLROOT$BIN. Copy expr there."
    exit 1
  fi
  if [ ! -x "$BIN/sleep" ]; then
    echo "Seems you do not have 'sleep' in $GLROOT$BIN. Copy sleep there."
    exit 1
  fi
  if [ ! -x "$BIN/grep" ]; then
    echo "Seems you do not have 'grep' in $GLROOT$BIN. Copy grep there."
    exit 1
  fi

  MODE="GL"
  TAKE="$1"
  CREDS="$2"
  DESTSLAVE="$3"
fi

## Procedure for writing to the logfile.
proc_log() {
  if [ "$TRANSFERLOG" ]; then
    echo `date "+%a %b %e %T %Y"` TRANS: \"$*\" >> $TRANSFERLOG
  fi
}

## Verify log and tmp.
proc_verifylog() {
if [ "$TRANSFERLOG" != "" ]; then
  if [ ! -w "$TRANSFERLOG" ]; then
    echo "Error. No write permissions to logfile. Ask siteops to fix that."
    exit 1
  fi
fi

if [ ! -w "$TMP" ]; then
  echo "Error. No write permissions to TMP dir $TMP. Ask siteops to fix that."
  exit 1
fi
}

## Some aliases for fun.
if [ "$TAKE" = "put" -o "$TAKE" = "throw" ]; then
  TAKE="give"
fi
if [ "$TAKE" = "get" -o "$TAKE" = "fetch" ]; then
  TAKE="take"
fi

## Make test calculation
TESTING="$( echo 100 + 100 | bc -l )"
if [ -z "$TESTING" ]; then
  echo "-[ Error information ]-----------------------------------------------------"
  echo ""
  echo "Seems like you are missing the binary bc in the glftpd bin dir"
  echo "Copy that there. If it complains about libraries, do a 'locate libname.lib'"
  echo "and copy that to your glftpd lib dir."
  echo ""
  echo "-[ End Error information ]-------------------------------------------------"
  exit 1
fi
unset TESTING

## Procedute for locking on source
proc_lock_src() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERSOURCE/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY=$[$RETRY-1]
    echo "$USER seems locked at $SOURCENAME. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERSOURCE/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    echo "$USER seems locked at $SOURCENAME. Aborting."
    echo "Try again in a few minutes. If the error persists, contact a siteop."
    proc_log "$USER seems locked at $SOURCENAME. Aborting."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      echo "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERSOURCE/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on source
proc_unlock_src() {
  if [ -e "$USERSOURCE/$USER.lock" ]; then
    rm -f $USERSOURCE/$USER.lock
  fi
}

## Procedure for producing a slave list.
proc_slavelist() {
  if [ "$DENY_SLAVES" ]; then
    for rawdata in $SLAVES; do
      unset MATCH
      for denyslave in $DENY_SLAVES; do
        if [ "`echo "$rawdata" | grep -i "^$denyslave$"`" ]; then
          MATCH="TRUE"
        fi
      done
      if [ -z "$MATCH" ]; then
        SLAVELIST="$SLAVELIST $rawdata"
      else
        unset MATCH
      fi
    done
    if [ "$SLAVELIST" ]; then
      SLAVELIST="`echo $SLAVELIST`"
    fi
  else
    SLAVELIST="$SLAVES"
  fi
}

## Procedute for locking on destination
proc_lock_dst() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERDEST/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY=$[$RETRY-1]
    echo "$USER seems locked at $DESTNAME. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERDEST/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    echo "$USER seems locked at $DESTNAME. Aborting."
    echo "Try again in a few minutes. If the error persists, contact a siteop."
    proc_log "$USER seems locked at $DESTNAME. Aborting."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      echo "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERDEST/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on destination
proc_unlock_dst() {
  if [ -e "$USERDEST/$USER.lock" ]; then
    rm -f $USERDEST/$USER.lock
  fi
}

## Procedure for verifying userfile integrity.
proc_userver() {
  unset VERERR
  if [ ! -e "$CHECKPATH/$USER" ]; then
    VERERR="User_Does_Not_Exist"
  else
    if [ -z "$( grep "^USER " $CHECKPATH/$USER )" ]; then VERERR="$VERERR USER"; fi
    if [ -z "$( grep "^GENERAL " $CHECKPATH/$USER )" ]; then VERERR="$VERERR GENERAL"; fi
    if [ -z "$( grep "^LOGINS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR LOGINS"; fi
    if [ -z "$( grep "^TIMEFRAME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIMEFRAME"; fi
    if [ -z "$( grep "^FLAGS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR FLAGS"; fi
    if [ -z "$( grep "^TAGLINE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TAGLINE"; fi
    if [ -z "$( grep "^DIR " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DIR"; fi
    if [ -z "$( grep "^CREDITS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR CREDITS"; fi
    if [ -z "$( grep "^RATIO " $CHECKPATH/$USER )" ]; then VERERR="$VERERR RATIO"; fi
    if [ -z "$( grep "^ALLUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLUP"; fi
    if [ -z "$( grep "^ALLDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLDN"; fi
    if [ -z "$( grep "^WKUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKUP"; fi
    if [ -z "$( grep "^WKDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKDN"; fi
    if [ -z "$( grep "^DAYUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYUP"; fi
    if [ -z "$( grep "^DAYDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYDN"; fi
    if [ -z "$( grep "^MONTHUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHUP"; fi
    if [ -z "$( grep "^MONTHDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHDN"; fi
    if [ -z "$( grep "^NUKE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR NUKE"; fi
    if [ -z "$( grep "^TIME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIME"; fi

    if [ "$GL_VERSION" -lt "2" ]; then
      if [ -z "`grep "^SLOTS " $CHECKPATH/$USER`" ]; then VERERR="$VERERR SLOTS"; fi
    elif [ "$GL_VERSION" -ge "2" ]; then
      if [ -z "`grep "^ADDED " $CHECKPATH/$USER`" ]; then VERERR="$VERERR ADDED"; fi
      if [ -z "`grep "^EXPIRES " $CHECKPATH/$USER`" ]; then VERERR="$VERERR EXPIRES"; fi
    fi

    if [ "$VERERR" ]; then
      VERERR="$( echo $VERERR | tr -s ' ' )"
    fi
  fi
}

echo "Please wait. Verifying network. - Running from: $MODE"

## Procedure for checking it the destination slave is up.
proc_slave2slavecheck() {
  if [ "$SLAVE2SLAVE" != "TRUE" ]; then
    echo "Error. Slave to Slave transfers are not enabled. Dont specify anything after the credits."
    proc_log "$USER tried to move to another slave, but that is disabled. Command was: $FULLCOMMAND"
    exit 1
  else

    if [ ! -w "$PASSWDSOURCE" ]; then
      echo "Error. SLAVE2SLAVE transfer is TRUE, but I cant write to the actionfile"
      echo "directory on the hub. Ask your siteop to set write perms on PASSWDSOURCE."
      proc_log "$USER tried to move to another slave, but cant write to $PASSWDSOURCE. Command was: $FULLCOMMAND"
      exit 1
    fi

    ## Can we read mss-slavestatus.db from the hub?
    if [ ! -e "$REPORTDIR/mss-slavestatus.db" ]; then
      echo "Error. SLAVE2SLAVE transfers are TRUE, but cant find $REPORTDIR/mss-slavestatus.db."
      echo "Is mss-report.sh running on the hub?"
      proc_log "$USER tried to move to another slave, but $REPORTDIR/mss-slavestatus.db was not found? Command was: $FULLCOMMAND"
      proc_log "Is mss-report.sh running on the hub?"
      exit 1
    else

      ## Get a list of the slaves and verify that we really got something.
      SLAVES="`grep "^\*\*SLAVES\=" $REPORTDIR/mss-slavestatus.db | cut -d '=' -f2`"
      if [ -z "$SLAVES" ]; then
        echo "Error: SLAVE2SLAVE is TRUE, but can not read slavenames from mss-slavestatus.db on the hub. Try again."
        proc_log "$USER tried to move to another slave, but cant read **SLAVES= from mss-slavestatus.db on the hub. Command was: $FULLCOMMAND"
        exit 1
      fi
      SLAVES=" $SLAVES "

      ## Verify that this defined slave is valid.
      if [ -z "`echo "$SLAVES" | grep -i "\ $DESTSLAVE \"`" ]; then
        echo "Error. Slave $DESTSLAVE is not a valid slave server. Valid ones are:"

        proc_slavelist
        if [ -z "$SLAVELIST" ]; then      
          echo "Hm, all slaves seems disabled. Wonder why slave2slave transfers is enabled then..."
          proc_log "Warning: SLAVE2SLAVE is TRUE, but all slaves seems disabled in DENY_SLAVES. Not too good."
        else
          echo "> $SLAVELIST <"
        fi
         
        proc_log "$USER tried to move to another slave, but $DESTSLAVE is not a valid slave. Command was: $FULLCOMMAND"
        exit 1
      fi

      ## Chech that its not THIS slave. hehe. Idiot user.
      if [ "`echo "$DESTNAME" | grep -wi "$DESTSLAVE"`" ]; then
        echo "Error. This IS $DESTNAME. What are you up to?"
        proc_log "$USER tried to move to another slave, but $DESTSLAVE is THIS slave. Moron. Command was: $FULLCOMMAND"
        exit 1
      fi

      ## Get exact name...
      for rawdata in $SLAVES; do
        if [ "`echo "$rawdata" | grep -wi "$DESTSLAVE"`" ]; then

          ## Make sure transfer to this other slave isnt disabled.
          if [ "$DENY_SLAVES" ]; then
            for each in $DENY_SLAVES; do
              if [ "`echo "$rawdata" | grep -i "^$each$"`" ]; then
                echo "Sorry. Transfer to $each is disabled."
                exit 1
              fi
            done
          fi

          GIVENAME="$rawdata"
          DESTSLAVE="$rawdata"
        fi
      done  

      ## Check that it isnt reported as DOWN.
      SLAVESTATUS="`grep "^$DESTSLAVE\=" $REPORTDIR/mss-slavestatus.db | cut -d '=' -f2`"
      case $SLAVESTATUS in
        UP) echo "$DESTSLAVE reports UP." ;;
        DOWN) echo "$DESTSLAVE reports DOWN. Can not transfer credits to it right now."
              proc_log "$DESTSLAVE reports DOWN. Aborting."
              exit 1
        ;;
        *) echo "$DESTSLAVE has never reported its status to the hub. Aborting."
           proc_log "$DESTSLAVE has never reported its status to the hub. Aborting."
           exit 1
        ;;
      esac

      if [ -z "$GIVENAME" -o -z "$DESTSLAVE" ]; then
        echo "Error in getting slavename to send to. Try again with different case structure."
        proc_log "$USER tried to move to another slave, but GIVENAME or DESTSLAVE vars arent set. Error. Command was: $FULLCOMMAND"
        exit 1
      fi
       
    fi
  fi
}

## Procedure to verify that userfiles exists.  
proc_checklinksimple() {
  if [ ! -e "$USERDEST/$USER" ]; then
    echo "User $USER does not exist on $DESTNAME or permissions are wrong."
    proc_log "User $USER does not exist on $DESTNAME or permissions are wrong. Command was: $FULLCOMMAND"
    exit 1
  fi

  if [ ! -e "$USERSOURCE/$USER" ]; then
    echo "Error: Link is down or $USER does not exist on $SOURCENAME."
    proc_log "$USER tried to transfer creds but does not exist on $SOURCENAME or link is down. Command was: $FULLCOMMAND"
    exit 1 
  fi
}

## Procedure for advanced userfile checking
proc_checklinkadvanced() {
  if [ ! -w "$USERSOURCE" ]; then
    echo "Error. No write permissions to users directory on $SOURCENAME."
    exit 1
  fi

  if [ ! -w "$USERDEST" ]; then
    echo "Error. No write permissions to users directory on $DESTNAME."
    exit 1
  fi

  ## Verify network link
  if [ ! -w "$USERSOURCE/$USER" ]; then
    echo "Transfer failed. Link to $SOURCENAME failed or the userfile is not writable."
    echo "Please wait up to one minute and try again. If that does not help, contact a siteop."
    proc_log "Transfer failed for $USERSOURCE/$USER. Link to $SOURCENAME failed or the userfile is not writable. Command was: $FULLCOMMAND"
    exit 1
  fi

  if [ ! -w "$USERDEST/$USER" ]; then
    echo "Transfer failed. Cant write to current userfile on $DESTNAME."
    proc_log "Transfer failed. Cant write to $USER on $DESTNAME. Command was: $FULLCOMMAND"
    exit 0
  fi

  ## Verify userfile integrity on hub
  CHECKPATH="$USERSOURCE"
  proc_userver
  if [ ! -z "$VERERR" ]; then
    echo "Warning. Userfile $USER on $SOURCENAME have problems with the following fields: $VERERR"
    proc_log "Warning. Userfile $USERSOURCE/$USER on $SOURCENAME have problems with the following fields: $VERERR"
    exit 1
  fi
  unset CHECKPATH

  ## Verify userfile integrity on slave
  CHECKPATH="$USERDEST"
  proc_userver
  if [ ! -z "$VERERR" ]; then
    echo "Warning. Userfile $USER on $DESTNAME have problems with the following fields: $VERERR"
    proc_log "Warning. Userfile $USERDEST/$USER on $DESTNAME have problems with the following fields: $VERERR"
    exit 1
  fi
  unset CHECKPATH
}

## Procedure for showing status.
proc_status() {
  if [ "$MODE" = "SHELL" -a "$USER" = "" ]; then
    proc_help
  fi

  if [ "$MODE" = "SHELL" -a "$SHELLUSER" != "" ]; then
    HEAD="$SHELLUSER@shell -> $USER"
  else
    HEAD="$USER"
  fi

  SOURCECREDSKB="$( grep "^CREDITS " $USERSOURCE/$USER | cut -d ' ' -f2 )"
  if [ -z "$SOURCECREDSKB" ]; then
    echo "Can not read $SOURCENAME credits for $USER"
    proc_log "Can not read $SOURCENAME credits for $USER. Command was: $FULLCOMMAND"
    exit 0
  else
    SOURCECREDSMB="$( echo "$SOURCECREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ -z "$SOURCECREDSMB" ]; then
      SOURCECREDSMB="0"
    fi
  fi
  DESTCREDSKB="$( grep "^CREDITS " $USERDEST/$USER | cut -d ' ' -f2 )"
  if [ -z "$DESTCREDSKB" ]; then
    echo "Can not read $DESTNAME credits for $USER"
    proc_log "Can not read $DESTNAME credits for $USER. Command was: $FULLCOMMAND"
    exit 0
  else
    DESTCREDSMB="$( echo "$DESTCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ -z "$DESTCREDSMB" ]; then
      DESTCREDSMB="0"
    fi
  fi
  if [ "$status" = "TRUE" ]; then
    echo "-[ Current Credits ]---------------------"
    echo "$SOURCENAME : $SOURCECREDSMB MB"

    echo "$DESTNAME : $DESTCREDSMB MB"
    if [ "$TRANSFERTAX" -a "$TRANSFERTAX" != "0" ]; then
      echo "-> The tax level for transfers is $TRANSFERTAX%. <-"
    fi
    echo "---------------------------------[ $VER ]-"
    proc_log "$HEAD checks status. $SOURCENAME: $SOURCECREDSMB <-> $DESTNAME: $DESTCREDSMB"
    exit 0
  else
    if [ -z "$DESTSLAVE" ]; then
      SITECREDS="$SOURCENAME: $SOURCECREDSMB MB. $DESTNAME: $DESTCREDSMB MB."
    else
      SITECREDS="$DESTSLAVE: ? MB. $DESTNAME: $DESTCREDSMB MB."
    fi
  fi
}

## Display help.
proc_help() {
  echo "-------------------------------------------------"
  echo "Welcome to the Credits Transfer System $VER      "

  ## Show current link. Change arrow if transfer is disabled in any direction.
  if [ "$TRANSFERTOHUB" != "FALSE" ] || [ "$TRANSFERTOSLAVE" != "FALSE" ]; then
    if [ "$TRANSFERTOHUB" = "FALSE" ]; then
      ARROW="->"
    elif [ "$TRANSFERTOSLAVE" = "FALSE" ]; then
      ARROW="<-"
    else
      ARROW="<->"
    fi
    echo "Current link is between $SOURCENAME $ARROW $DESTNAME"
  fi

  ## Show if automatic credit move is enabled.
  if [ "$SLAVE2SLAVE" = "TRUE" ]; then
    echo "Slave to Slave transfer is ENABLED"
  fi
  if [ -r "$PASSWDSOURCE/mss-automove.db" ]; then
    if [ "`grep "^$DESTNAME:$USER:ON" "$PASSWDSOURCE/mss-automove.db"`" ]; then
       echo "Automatic move of credits after each race is ON"
    else
       echo "Automatic move of credits after each race is OFF"
    fi
    echo "Note: You change automatic moving from the hub."
  fi

  echo "-------------------------------------------------"
  echo "Usage :"
  if [ "$MODE" = "GL" ]; then
    echo "site $COMMAND status"
    if [ "$TRANSFERTOSLAVE" != "FALSE" ]; then
      echo "Send credits to here  : site $COMMAND take <Mb_Amount>"
    fi
    if [ "$SLAVE2SLAVE" = "TRUE" ]; then
      echo "Send credits from here: site $COMMAND give <Mb_Amount> <Slave>"
    else
      if [ "$TRANSFERTOHUB" != "FALSE" ]; then
        echo "Send credits from here: site $COMMAND give <Mb_Amount>"
      fi
    fi
  else
    echo "transfercredits.sh take/give <username> Mb_Amount"
    echo "transfercredits.sh stats <username>"
  fi

  if [ "$TRANSFERTOSLAVE" != "FALSE" ]; then
    echo "take = $SOURCENAME -> $DESTNAME"
  fi
  if [ "$SLAVE2SLAVE" = "TRUE" ]; then
    echo "give = $DESTNAME -> $SOURCENAME, if <Slave> is not specified"
    SLAVES="`grep "^\*\*SLAVES\=" $REPORTDIR/mss-slavestatus.db | cut -d '=' -f2`"

    ## Make sure transfer to this other slave isnt disabled.
    proc_slavelist
    if [ "$SLAVELIST" ]; then
      echo "Current slaves are: $SLAVELIST"
    else
      echo ""
      echo "Warning. SLAVE2SLAVE transfers is TRUE, but all slaves seems disabled in DENY_SLAVES."
      echo "This is pretty idiotic."
      proc_log "Warning: SLAVE2SLAVE is TRUE, but all slaves seems disabled on DENY_SLAVES. Not too good."
    fi

  else
    if [ "$TRANSFERTOHUB" != "FALSE" ]; then
      echo "give = $DESTNAME -> $SOURCENAME"
    fi
  fi
  echo " "
  echo "Min amount to move is $MINAMOUNT MB."
  echo "Max amount to move is $MAXAMOUNT MB."
  echo "Specifying 'all' instead of amount will move all"
  echo "your credits between sites, but not over max"
  echo "allowed amount though."
  echo ""
  
  if [ "$TRANSFERTAX" -a "$TRANSFERTAX" != "0" ]; then
    echo "Important: You will be taxed $TRANSFERTAX% when transfering."
    echo "This will be deducted from your specified amount automatically."
    echo ""
  fi
  
  if [ "$MODE" = "GL" ]; then
    if [ "$TRANSFERTOSLAVE" != "FALSE" ]; then
      echo "Example:"
      echo "site $COMMAND take 500"
      echo "would move 500 meg creds from $SOURCENAME to $DESTNAME"
    elif [ "$TRANSFERTOSLAVE" != "FALSE" ]; then
      echo "Example:"
      echo "site $COMMAND give 500"
      echo "would move 500 meg creds from $DESTNAME to $SOURCENAME"
    else
      proc_slavelist
      if [ -z "$SLAVELIST" ]; then 
        echo "Error. SLAVE2SLAVE is TRUE but all slaves are disabled in DENY_SLAVE."
        proc_log "Error. SLAVE2SLAVE is TRUE but all slaves are disabled in DENY_SLAVE."
      else
        for each in $SLAVELIST; do
          if [ "$each" != "$DESTNAME" ]; then
            SLAVE="$each"
            break
          fi
        done
        if [ "$SLAVE" ]; then
          echo "Example:"
          echo "site $COMMAND give 500 $SLAVE"
          echo "would move 500 meg creds from $DESTNAME to $SLAVE."
        fi
      fi
    fi
  else
    echo "transfercredits.sh take turranius 500"
    echo "would move 500 meg of turranius's creds from $SOURCENAME to $DESTNAME"
  fi
  echo "----------------------[ Turranius 2002-2003 ]----"
  exit 0
}


## Procedure for validating amount of credits.
proc_validate() {
  case $CREDS in
    [aA][lL][lL]) CREDS="666"; ALL="TRUE" ;;
    *) ALL="FALSE" ;;
  esac

  ## Make sure bet is not over 6 chars long
  MAX="$( echo "$CREDS" | wc -c | tr -d ' ' )"
  if [ "$MAX" -gt "6" ]; then
    echo "Nice try to overflow, but max in $MAXAMOUNT Mb, sucka."
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi
  unset MAX

  ## Check that creds is only containing numbers.
  ## ( If we remove everything but digits, CREDS should be emppty. If not... )
  if [ "$( echo "$CREDS" | tr -d [:digit:] )" ]; then
    echo "Only use pure numbers in amount of credits."
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi

  ## User tried to transfer minus credits.
  if [ "$CREDS" -lt "0" ]; then
    echo "Nice try, jackass"
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi

  ## User tried to transfer below minumum limit.
  if [ "$CREDS" -lt "$MINAMOUNT" ]; then
    echo "Minimum amount to transfer is $MINAMOUNT MB"
    proc_log "$USER tried to transfer less then $MINAMOUNT MB. Command was: $FULLCOMMAND"
    exit 1
  fi 

  ## User tried to transfer above max limit.
  if [ "$CREDS" -gt "$MAXAMOUNT" ]; then
    echo "Maximum amount to transfer in one go is $MAXAMOUNT MB"
    proc_log "$USER tried to transfer more then $MAXAMOUNT MB. Command was: $FULLCOMMAND"
    exit 1
  fi 
}

## Procedure for actually moving credits.
proc_go() {
 
  ## Convert upper case to lowercase in $TAKE
  TAKE="`echo "$TAKE" | tr '[:upper:]' '[:lower:]'`"

  if [ "$SLAVE2SLAVE" = "TRUE" ]; then
    if [ "$TAKE" = "give" ] && [ "$DESTSLAVE" ]; then
      proc_slave2slavecheck
    else
      if [ "$DESTSLAVE" ]; then
        echo "Error. Cant specify a slave when taking credits, only on give!"
        echo "Log on to the other slave and use 'give' instead."
        exit 1
      fi
    fi
  else
    unset DESTSLAVE
  fi

  ## v2.2 - Check if any of the modes are set to FALSE. Dont allow transfer if so.
  if [ "$TRANSFERTOHUB" = "FALSE" -a "$TAKE" = "give" -o "$TRANSFERTOSLAVE" = "FALSE" -a "$TAKE" = "take" ]; then
    if [ -z "$DESTSLAVE" ]; then
      echo "You are not allowed to transfer credits from $TAKENAME to $GIVENAME."
      proc_log "$USER tried to move from $TAKENAME to $GIVENAME but that is disabled."
      echo ""
      exit 1
    fi
  fi

  ## Put amount in variable $CREDSMB and make a KiloByte calculation on it.
  CREDSMB="$CREDS"
  CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"

  ## Try and read credits from source site.
  SOURCECREDSKB="$( grep "^CREDITS " $TAKEFROM/$USER | cut -d ' ' -f2 )"

  ## Make sure its only digits that we read.
  if [ "$( echo "$SOURCECREDSKB" | tr -d [:digit:] | tr -d '-' )" ]; then
    echo "I think I read your credits on $TAKENAME wrong somehow. I got $SOURCECREDSKB"
    proc_log "Error: I got $SOURCECREDSKB when reading credits from $TAKEFROM/$USER on $TAKENAME."
    exit 1
  fi

  ## Make sure we got something...
  if [ -z "$SOURCECREDSKB" ]; then
    echo "Can not read credits on $TAKENAME."
    proc_log "Can not read CREDITS field on $TAKENAME. Command was: $FULLCOMMAND"
    exit 1
  fi

  if [ "$SOURCECREDSKB" -lt "0" ]; then
    echo "You have negative credits on $TAKENAME ( $SOURCECREDSKB kb). No go bud."
    proc_log "$USER has negative creds on $TAKENAME ( $SOURCECREDSKB kb ). No go."
    exit 1
  fi

  if [ "$SOURCECREDSKB" -le "1024" ]; then
    echo "You have less then 1024 KB credits on $TAKENAME. No go!."
    proc_log "$USER only has $SOURCECREDSKB credits on $TAKENAME. No go."
    exit 1
  fi

  SOURCECREDSMB="$( echo "$SOURCECREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
  
  ## Try and read credits from destination site.
  DESTCREDSKB="$( grep "^CREDITS " $GIVETO/$USER | cut -d ' ' -f2 )"

  ## Make sure its only digits that we read.
  if [ "$( echo "$DESTCREDSKB" | tr -d [:digit:] | tr -d '-' )" ]; then
    echo "I think I read your credits on $GIVENAME wrong somehow. I got $DESTCREDSKB"
    proc_log "Error: I got $DESTCREDSKB when reading credits from $GIVETO/$USER on $GIVENAME."
    exit 0
  fi

  ## Make sure we got something...
  if [ -z "$DESTCREDSKB" ]; then
    echo "Can not read credits on $GIVENAME."
    proc_log "Can not read CREDITS field on $GIVENAME. Command was: $FULLCOMMAND"
    exit 0
  fi

  DESTCREDSMB="$( echo "$DESTCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"

  if [ "$ALL" = "TRUE" -a "$CREDS" = "666" ]; then
    CREDSMB="$SOURCECREDSMB"
    if [ "$CREDSMB" = "" -o "$CREDSMB" = "0" ]; then
      echo "Error. You got no creds left to move?"
      proc_log "$USER tries to move all his creds, but its not enough?! (CREDSMB=$CREDSMB). Command was: $FULLCOMMAND"
      exit 1
    fi

    CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"
    if [ "$CREDSMB" -lt "$MINAMOUNT" ]; then
      echo "You must have atleast $MINAMOUNT Mb credits to move."
      proc_log "$USER did not have atleast $MINAMOUNT credits to move. Command was: $FULLCOMMAND"
      exit 1
    else
      if [ "$CREDSMB" -gt "$MAXAMOUNT" ]; then
        echo "Max amount is $MAXAMOUNT Mb. Setting it to that amount."
        proc_log "$USER moves ALL creds, but has more then the max: $MAXAMOUNT MB. Setting it to that amount. Command was: $FULLCOMMAND"
        CREDSMB="$MAXAMOUNT"
        CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"
      else
        echo "Moving ALL credits ($SOURCECREDSMB Mb) from $TAKENAME to $GIVENAME."
        proc_log "$USER starts to move ALL credits ($SOURCECREDSMB Mb) from $TAKENAME to $GIVENAME. Command was: $FULLCOMMAND"
       fi
    fi
  fi  

  ## Check if user is trying to move more then he has.
  if [ "$CREDSKB" -gt "$SOURCECREDSKB" ]; then
    echo "You do not have $CREDSMB MB on $TAKENAME - Only $SOURCECREDSMB MB"
    proc_log "$USER tried to move $CREDSMB MB from $TAKENAME but only have $SOURCECREDSMB MB. Command was: $FULLCOMMAND"
    exit 1
  else

    echo "Transfering credits. Do NOT log out."

    ## Calculate tax if that is enabled.
    if [ "$TRANSFERTAX" -a "$TRANSFERTAX" != "0" ]; then

      ## Make a quick check to check the setup.
      if [ "$TRANSFERTAX" -lt "1" -o "$TRANSFERTAX" -gt "99" ]; then
        echo "Error. TRANSFERTAX set to $TRANSFERTAX. It should be between 1-99. Tell a siteop to fix"
        exit 1
      fi

      ## Calculate how much the current tax will deduct.
      TAXAMOUNTKB="`echo "$CREDSKB * 0.$TRANSFERTAX" | bc -l | cut -d '.' -f1`"
      TAXAMOUNTMB="`echo "$CREDSMB * 0.$TRANSFERTAX" | bc -l | cut -d '.' -f1`"
      if [ -z "$TAXAMOUNTKB" ]; then TAXAMOUNTKB="0"; fi
      if [ -z "$TAXAMOUNTMB" ]; then TAXAMOUNTMB="0"; fi

      ## Deduct the tax from the amount to give.
      TAXEDCREDSKB="`echo "$CREDSKB - $TAXAMOUNTKB" | bc -l | cut -d '.' -f1`"
      TAXEDCREDSMB="`echo "$CREDSMB - $TAXAMOUNTMB" | bc -l | cut -d '.' -f1`"
    fi 

    if [ "$TAXEDCREDSKB" ]; then
      ## Tax is enabled. Use that value.
      NEWCREDSDESTKB="$( echo "$DESTCREDSKB + $TAXEDCREDSKB" | bc -l | cut -d '.' -f1 )"
    else
      ## Tax is not enabled. Just give the selected amount.
      NEWCREDSDESTKB="$( echo "$DESTCREDSKB + $CREDSKB" | bc -l | cut -d '.' -f1 )"
    fi
    
    NEWCREDSDESTMB="$( echo "$NEWCREDSDESTKB / 1024" | bc -l | cut -d '.' -f1 )"

    NEWCREDSSOURCEKB="$( echo "$SOURCECREDSKB - $CREDSKB" | bc -l | cut -d '.' -f1 )"
    NEWCREDSSOURCEMB="$( echo "$NEWCREDSSOURCEKB / 1024" | bc -l | cut -d '.' -f1 )"

    if [ "$MODE" = "SHELL" -a "$SHELLUSER" != "" ]; then
      HEAD="$SHELLUSER$shell -> $USER"
    else
      HEAD="$USER"
    fi
    if [ "$ALL" != "TRUE" ]; then
      echo "Transfering $CREDSKB Kb ($CREDSMB Mb) from $TAKENAME to $GIVENAME"
      proc_log "$HEAD starting transfer of $CREDSKB KB ($CREDSMB MB) from $TAKENAME to $GIVENAME. Command was: $FULLCOMMAND"
      if [ "$TAXEDCREDSKB" ]; then
        echo "You were taxed $TRANSFERTAX% ($TAXAMOUNTMB MB) for this transfer."
        proc_log "$USER was taxed $TAXAMOUNTMB MB ($TAXAMOUNTKB KB) credits for this transfer."
      fi
    fi
    if [ -w "$TAKEFROM/$USER" ]; then
      if [ -w "$GIVETO/$USER" ]; then
        ## Take credits from source.
        sed -e "s/^CREDITS [-|0-9]*/CREDITS $NEWCREDSSOURCEKB/" $TAKEFROM/$USER > $TMP/TEMP.$USER.CREDITS
        ## Give credits to destination.
        sed -e "s/^CREDITS [-|0-9]*/CREDITS $NEWCREDSDESTKB/" $GIVETO/$USER > $TMP/TEMP.$USER.DEST.CREDITS

        ## Verify new file ment for hub.
        OLDUSERNAME="$USER"
        USER="TEMP.$USER.CREDITS"
        CHECKPATH="$TMP"
        proc_userver
        if [ ! -z "$VERERR" ]; then
          echo "Warning. Userfile corruption during editing. Problem with: $VERERR. Aborting. Please try again."
          proc_log "Warning. Edited userfile for $OLDUSERNAME, ment for $TAKENAME has a problem with: $VERERR. Aboring."
          rm -f $TMP/TEMP.$USER.CREDITS
          rm -f $TMP/TEMP.$USER.DEST.CREDITS
          exit 1
        else
          USER="$OLDUSERNAME"
          unset OLDUSERNAME
          unset CHECKPATH
        fi

        ## Verify new file ment for slave
        OLDUSERNAME="$USER"
        USER="TEMP.$USER.DEST.CREDITS"
        CHECKPATH="$TMP"
        proc_userver
        if [ ! -z "$VERERR" ]; then
          echo "Warning. Userfile corruption duing editing to the following fields: $VERERR. Aborting. Please try again."
          proc_log "Warning. Edited userfile for $OLDUSERNAME, ment for $GIVENAME has a problem with: $VERERR. Aboring."
          rm -f $TMP/TEMP.$USER.CREDITS
          rm -f $TMP/TEMP.$USER.DEST.CREDITS
          exit 1
        else
          USER="$OLDUSERNAME"
          unset OLDUSERNAME
          unset CHECKPATH
        fi

        ## Log it.
        if [ "$ALL" = "TRUE" ]; then
          proc_log "$HEAD transfers ALL his creds, $CREDSMB Mb, from $TAKENAME to $GIVENAME - Moving userfiles"
        else
           proc_log "$HEAD transfers $CREDSMB Mb from $TAKENAME to $GIVENAME - Moving userfiles"
        fi

        ## Load beforecreds if that is enabled in config.
        if [ "$AUTOMATICSTATUS" = "TRUE" ]; then
          proc_status
        fi

        proc_lock_dst
        proc_lock_src

        if [ "$SKIP" != "YES" ]; then
          if [ -w "$TMP/TEMP.$USER.CREDITS" ] && [ -w "$TMP/TEMP.$USER.DEST.CREDITS" ]; then
            if [ "$DESTSLAVE" ]; then
              if [ "$TAXEDCREDSMB" ]; then
                echo "GIVECREDS $USER $TAXEDCREDSMB" >> $PASSWDSOURCE/$DESTSLAVE.actions
              else
                echo "GIVECREDS $USER $CREDSMB" >> $PASSWDSOURCE/$DESTSLAVE.actions
              fi
              if [ ! -e "$PASSWDSOURCE/$DESTSLAVE.actions" ]; then
                echo "Hm, couldnt create actionfile for this. Try again please."
                proc_log "Error. Could not create actionfile $PASSWDSOURCE/$DESTSLAVE.actions. Nothing done."
                proc_unlock_dst
                proc_unlock_src
                exit 1
              fi
              cp -f $TMP/TEMP.$USER.CREDITS $TAKEFROM/$USER
              rm -f $TMP/TEMP.$USER.CREDITS
            else
              cp -f $TMP/TEMP.$USER.CREDITS $TAKEFROM/$USER
              cp -f $TMP/TEMP.$USER.DEST.CREDITS $GIVETO/$USER
              rm -f $TMP/TEMP.$USER.CREDITS
              rm -f $TMP/TEMP.$USER.DEST.CREDITS
            fi
          else
            echo "Error: For some reason I dont have access to do this.."
            proc_log "Error: No read access to temp files in $TMP for $USER. Check perms"
            proc_unlock_dst
            proc_unlock_src
            exit 1
          fi
        else
          sleep 1
          proc_unlock_dst
          proc_unlock_src
          exit 0
        fi
        proc_unlock_dst
        proc_unlock_src
      else
        echo "Cant write userfile on $GIVENAME - Quitting" 
        proc_log "Cant write destination file $GIVETO/$USER - Quitting. Command was: $FULLCOMMAND" 
        exit 1
      fi
    else
      echo "Cant write userfile on $TAKENAME - Quitting"
        proc_log "Cant write source file $TAKEFROM/$USER - Quitting. Command was: $FULLCOMMAND"
        exit 1
      fi
    fi

    echo " "
    if [ -z "$DESTSLAVE" ]; then
      echo "All done. Note that it might not show in the stat line at once, but it is there."
    else
      echo "All done. Please allow a few minutes to pass before checking on $DESTSLAVE."
    fi

    ## Display before and after creds if that is enabled.
    if [ "$AUTOMATICSTATUS" = "TRUE" ]; then
      echo "------------[ Credits Comparison ]-----------"
      echo "Credits before: $SITECREDS"
      BEFORESITECREDS="$SITECREDS"
      proc_status
      echo "Credits after : $SITECREDS"
      echo "---------------------------------------------"
      proc_log "$USER Before> $BEFORESITECREDS - After> $SITECREDS"
    else
      echo "Verify with 'site $COMMAND status' or relogin."
    fi

  exit 0
}

## Procedure for initiating the move.
proc_gocommand() {
  ## If no credits was defined, show help and exit.
  if [ -z "$CREDS" ]; then
    proc_help
  fi

  ## Run procedure to verify write access to log
  proc_verifylog

  ## Run procedure to validate the credits desired to move.
  proc_validate

  ## Run procedure to make sure user exists and all that.
  proc_checklinksimple

  ## Run procedure to make sure we can write to userfile.
  proc_checklinkadvanced

  ## Run procedure to actually move the credits if we got this far.
  proc_go

  exit 0
}

## Set the whole command to $FULLCOMMAND ( proccess remove $* functionality ).
FULLCOMMAND="$*"

## Main internal menu. Depending on what TAKE is set to.
case $TAKE in
  [sS][tT][aA][tT][uU][sS]) status="TRUE"; proc_checklinksimple; proc_status; exit 0 ;;
  [tT][aA][kK][eE]) TAKEFROM="$USERSOURCE"; GIVETO="$USERDEST"; TAKENAME="$SOURCENAME"; GIVENAME="$DESTNAME"; proc_gocommand; exit 0 ;;
  [gG][iI][vV][eE]) TAKEFROM="$USERDEST"; GIVETO="$USERSOURCE"; TAKENAME="$DESTNAME"; GIVENAME="$SOURCENAME"; proc_gocommand; exit 0 ;;
  *) proc_help; exit 0;;
esac
