#!/bin/sh
VER=0.1
##################################################################
# SCRIPTNAME : MSS-CUSTOMHUB
# AUTHOR     : Turranius
# DESCRPTION : This script creates a MSS action-file on
#              the hub to do various things on various commands.
#              Loosly Based on mss-rlscomp.sh by void0 and ofcourse
#              on mss-custom.sh for the slave.
#
#
# INSTALLATION:
#
# Well, basically this script is ment to be used as a
# post script to any other command. What it writes to the
# actionfile can be defined with the SEND setting below.
#
# Make sure your actionfile system works before playing with
# this one.
#
# For instance: You want it to sync the user when he executes
# site vacation? Add this to glftpd.conf
#  cscript site[:space:]vacation pre /bin/mss-customhub.sh
# Then set SEND below to 'SYNC BASIC $2'
#
# That will send SYNC BASIC username to the actionfile whenever
# someone does a site vacation.
#
# *-[ IMPORTANT ]-********************************************************
# You can use it as a post command as well, but that does not appear to be
# working on custom scripts, only glftpd internal commands, or so.
# Havent had time to check which post works on and which dosnt.
# *-[ IMPORTANT ]-********************************************************
#
# Note that the above command will force a sync on the user even if he is
# only doing a 'site vacation status' or something, but if we do:
#  cscript site[:space:]vacation[:space:]on[:space:]yes pre /bin/mss-customhub.sh
# It will not run again when he issues 'site vacation off'.
#
# $2 can be used in SEND for the username of the person giving
# the command and $3 can be given for the users primary group
# (although no functions exist for groups in mss-core.sh).
# Use a * to execute it on all users.
#
# Commands you can use in SEND, accepted by mss-core.sh.
# SYNC STATS <user/*>   = Move stats back to hub.
# SYNC BASIC <user/*>   = Sync userinfo.
# SYNC FULL <user/*>    = Sync userinfo and move stats.
#
# If you want another function for another command, just copy this
# script to another name, set in SEND what it should do and add a 
# cscript in glftpd.conf, with the command that you want it to trigger on.
# 
# Logging from this script will go to the same log as mss-post.sh
# uses. You set that in mss-hub.conf (LOG setting).
#
# mss-core.sh will complain to the LOG (defined in mss-slave.conf) if you
# set commands here that is not accepted by mss-core.sh on the slave.
#
# HISTORY
#   0.1  - First release!
#
##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-hub.id in the same folder as mss-post.sh
# GLROOT="/glftpd"

## Remove the # from the below line to hard set where mss-hub.conf is.
## Otherwise, it will be read from the same folder as mss-post.sh is in.
# MSSHUBCONFIG=$GLROOT/bin/mss-hub.conf

## What to send to the actionfile. $2 = user. * = all users.
SEND="SYNC BASIC $2"

##################################################################
# READ CONFIG
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "GLROOT not set. Either create a file called mss-hub.id and add 'GLROOT=/glftpd'"
    echo "or add that line to mss-hub.conf."
    echo "This can also mean I do not have permission to read mss-hub.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  GLROOT=""
fi

if [ -z $MSSHUBCONFIG ]; then
  MSSHUBCONFIG="$( dirname $0 )/mss-hub.conf"
fi

if [ ! -r $MSSHUBCONFIG ]; then
  echo "Error. Cant not read $MSSHUBCONFIG"
  exit 1
else
  . $MSSHUBCONFIG
fi

if [ -z "$SOURCENAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "SOURCENAME not set. Either create a file called mss-slave.id and add 'SOURCENAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$SOURCENAME" ]; then
      echo "Error. Cant read SOURCENAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

##################################################################
# FUNCTIONS
##################################################################
putlog()
{
    if [ ! -z "$LOG" ]; then
      echo `date +'%a %b %e %T %Y'` "MSSCUSTOMHUB:" "$*" >> $LOG
    fi
}

##################################################################
write_action()
{
    putlog "$username/$group executed: $command - Writing '$SEND' to actionfile."
    for CURSLAVE in $SLAVES; do
      echo "$SEND" >> "$GLETC/$CURSLAVE.actions"
    done
}

##################################################################
# CORE
##################################################################

## Verify logfile
if [ -e "$LOG" ]; then
    if [ ! -f "$LOG" ]; then
	putlog "Logfile exists but is not a file."
    fi
fi

putlog "MSS-CUSTOMHUB v$VER by Turranius - Start"

## Verify SOURCENAME
if [ -z "$SOURCENAME" ]; then
    putlog "SOURCENAMENAME is not set!"
    exit
fi

## Verify actions-directory
if [ -e "$GLETC" ]; then
    if [ ! -d "$GLETC" ]; then
	putlog "Actions-directory exists but is not a directory."
	exit
    fi
fi
if [ ! -w "$GLETC" ]; then
    putlog "Actions-directory is not writeable."
    exit
fi

if [ ! "$1" ]; then
  putlog "Warning. No argument after command."
  exit 0
else
  command="$1"
  username="$2"
  group="$3"
  write_action 
fi

##################################################################
# END OF SCRIPT
##################################################################
