#!/bin/sh
VER=0.8
##################################################################
# SCRIPTNAME : MSS-SITE
# AUTHOR     : Turranius (turranius@hotmail.com)
# DESCRPTION : This script creates MSS action-files for glFTPd
#              SITE commands that affect the passwd, group and/or
#              userfiles, and is to be run a SITE command from
#              the glFTPd configuration file.
#
# INSTALLATION (added to glftpd.conf)
#              site_cmd mss EXEC /bin/mss-site.sh
#              custom-mss   1
#
#              Make sure you have the following binaries in glftpds
#              /bin dir:
#              dirname, basename, cat, cut, ls, tail, tr, bc
#
#              Make sure script is executable (chmod 755 or so).
#
#   0.8  - Add: Command backup to tell all slaves to run
#               mss-core.sh backup
#          Add: Command dellogs to clear out *.log
#
#   0.7  - Add: Uses mss-hub.id
#               Tries to locate mss-hub.conf and mss-hub.id in
#               the same folder as it is in itself, if not hardcoded.
#   0.6  - Add: Replicate functions for pushing stuff to slave(s).
#          Add: Delreports function to clear out reports.
#   0.5  - Add: Action: countaction (mss-numacts.sh)
#   0.4  - Some actions didnt exit correctly when finished.
#   0.3  - Add: '{ user1 user2 user3 }' support.
#          Add: 'cancel' command to clear actionfiles.
#          Add: 'readaction' to see current que for slaves.
#          Add: so that if the user does not exist, /force will
#               force a write_action anyway.
#   0.2  - Add: ... lots.
#   0.1  - First release! :)
#
##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-hub.id in the same folder as mss-post.sh
# GLROOT="/glftpd"

## Remove the # from the below line to hard set where mss-hub.conf is.
## Otherwise, it will be read from the same folder as mss-post.sh is in.
# MSSHUBCONFIG=$GLROOT/bin/mss-hub.conf


##################################################################
# READ CONFIG FILE
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "GLROOT not set. Either create a file called mss-hub.id and add 'GLROOT=/glftpd'"
    echo "or add that line to mss-hub.conf."
    echo "This can also mean I do not have permission to read mss-hub.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 1
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  GLROOT=""
fi

if [ -z $MSSHUBCONFIG ]; then
  MSSHUBCONFIG="$( dirname $0 )/mss-hub.conf"
fi

if [ ! -r $MSSHUBCONFIG ]; then
  echo "Error. Cant not read $MSSHUBCONFIG"
  exit 1
else
  . $MSSHUBCONFIG
fi

if [ -z "$SOURCENAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-hub.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "SOURCENAME not set. Either create a file called mss-slave.id and add 'SOURCENAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$SOURCENAME" ]; then
      echo "Error. Cant read SOURCENAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

##################################################################
# FUNCTIONS
##################################################################
putlog()
{
    if [ ! -z "$LOG" ]; then
	echo `date +'%a %b %e %T %Y'` "MSSPOST:" "$*" >> $LOG
    fi
}

##################################################################
write_action()
{
    putlog "Writing '$*' to slave(s) actionfile."
    echo "Writing '$*' to slave(s) actionfile."
    for CURSLAVE in $SLAVES; do
	echo "$*" >> "$GLETC/$CURSLAVE.actions"
    done
}

##################################################################
## Verify logfile
if [ -e "$LOG" ]; then
  if [ ! -f "$LOG" ]; then
    echo "Logfile exists but is not a file."
    exit 0
  fi
fi

## Verify actions-directory
if [ -e "$GLETC" ]; then
  if [ ! -d "$GLETC" ]; then
    putlog "Actions-directory exists but is not a directory."
    echo "Actions-directory exists but is not a directory."
    exit 0
  fi
fi
if [ ! -w "$GLETC" ]; then
  putlog "Actions-directory is not writeable."
  echo "Actions-directory is not writeable."
  exit
fi

## Function for showing help.
proc_help() {
  if [ -z "$COMMAND" ]; then
    echo "MSS-SITE $VER by Turranius"
    echo "Supported commands are:"
    echo "sync  <all>/<user>  - Sync user or all users"
    echo "stats <all>/<user>  - Move stats from user or all users"
    echo "full  <all>/<user>  - Full (sync & stats) from user or all users"
    echo "For above commands, { <user1> <user2> }, can be used to trigger"
    echo "multiple people at once."
    echo ""
    echo "fetchlogs           - Sends mss logs from slaves."
    echo "integcheck          - Checks integrity of all userfiles"
    echo "                      and reports back to the FETCHLOGSDIR." 
    echo "delreports          - Tell slaves to clear its reportfile."
    echo "dellogs             - Delete all logs from FETCHLOGSDIR."
    echo "list                - Get a list of current logs."
    echo ""
    echo "readlog <file> <searchword> <lines>"
    echo "   ^--------------> - Read logs. Default # of lines is 50."
    echo "                      Use '-all' to search on all words."
    echo "                      Hint: To get all logs from Jan 22, use 'Jan.22 50000'"
    echo "                      To see warning, search for 'warning'. Same for 'error'"
    echo "                      Searchword is not case sensitive."
    echo ""
    echo "readreports         - Read reports obtained from integcheck cmd."
    echo "                      This will display reports from all slaves, where as"
    echo "                      from 'readlog' you have to specify a file."
    echo ""
    echo "readsitelog <lines> - Read log from mss-post and mss-site."
    echo "                      Default # of lines is 50."
    echo ""
    echo "readaction          - Display actionfile from all slaves."
    echo ""
    echo "backup              - Tells all slaves to run 'mss-core.sh backup'"
    echo "                      Good to do before any major upgrades."
    echo ""
    echo "countaction         - Count number of existing actionfiles."
    echo "                      Mostly ment from shell incase some other script shouldnt"
    echo "                      run until all actionfiles are processed."
    echo ""
    echo "cancel <slave/all>  - Clears out the actionfile(s) incase you made a mistake."
    echo "                      Observe that once the slave start on them, it's too late."
    echo ""
    echo "trim <size>         - Tell the slave to trim its LOG, STATLOG and HIGHDEBUGLOG down to"
    echo "                      the defined MB level, ie 'trim 2' makes then about 2MB large."
    echo "                      You can also use CLEAR as <size> to wipe the logs totally."
    echo "--------------------------------------------------------------------------------------"
    echo "Replication settings:"
    echo ""
    echo "repllist            - List contents of replication dir."
    echo ""
    echo "replicate <script> <slave/-all> (destinationdir)"
    echo "   ^--------------> - Replicate a script for a slave. Enter -all for all slaves."
    echo "                      If no destinationdir is entered, it will be put in the same"
    echo "                      folder as mss-core.sh on the slave."
    echo "                      Files will be read from $MSSREPL on this hub (seen chrooted)."
    echo ""
    echo "See results of 'replicate' with 'readreports'. When you can do this is depending on how"
    echo "often you crontab 'mss-core.sh actionfile' on the slaves."
    exit 0
  fi
}

## Make replication dir unless disabled.
if [ "$MSSREPL" ]; then
  if [ ! -e $MSSREPL ]; then
    mkdir $MSSREPL
  fi
fi

if [ -z "$1" ]; then
  COMMAND="$1"
  proc_help
fi

if [ ! -e $GLROOT/bin/tail ]; then
  echo "You need 'tail' in your /glftpd/bin directory."; exit 0
elif [ ! -e $GLROOT/bin/cat ]; then
  echo "You need 'cat' in your /glftpd/bin directory."; exit 0
elif [ ! -e $GLROOT/bin/tr ]; then
  echo "You need 'tr' in your /glftpd/bin directory."; exit 0
fi

## NEW 2003-01-23 by Turranius 
## Procedure for checking command for {,} and split up if so.
## Also check if '(' or ')' is in it and quit.
proc_splitusers() {
  if [ ! -z "$( echo $GLCMDFULL | grep '{' | grep '}' )" ]; then
    CURUSERS="$( echo $GLCMDFULL | cut -d'{' -f2- | cut -d'}' -f1 )"
    if [ "$( echo "$GLCMDFULL" | cut -d'}' -f2 | tr '[:lower:]' '[:upper:]' | tr -d ' ' )" == "/FORCE" ]; then
      FORCE="YES"
    fi
  else
    ## Verify that there isnt any single { or } in it."
    if [ ! -z "$( echo $GLCMDFULL | grep '{' )" ]; then
      echo "Error: If '{' is used, it must be ended with a '}'"; exit 0
    elif [ ! -z "$( echo $GLCMDFULL | grep '}' )" ]; then
      echo "Error: Endpoint '}' found but not startpoint '{'"; exit 0
    ## Verify ( or ) existance. Error if so.
    elif [ ! -z "$( echo $GLCMDFULL | grep '(' )" ]; then
      echo "Error: Char ( not recognised. Did you mean { ?"; exit 0
    elif [ ! -z "$( echo $GLCMDFULL | grep ')' )" ]; then
      echo "Error: Char ) not recognised. Did you mean ) ?"; exit 0
    else
      if [ ! -z "$( echo "$GLCMDFULL" | grep -i "/FORCE" )" ]; then
        if [ ! -z "$( echo "$CURUSER" | grep -i "/FORCE" )" ]; then
          CURUSER="$( echo $CURUSER | cut -d'/' -f1 )"
        fi
        FORCE="YES"
      fi
      CURUSERS="$CURUSER"
    fi
  fi
}

## Begin parsing the command (if any)
GLCMDFULL="$*"
GLCMD="$( echo "$1" | tr -s ' ' )"
if [ ! -z "$2" ]; then
  CURUSER="$( echo "$2" )"
fi

## SYNC
if [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "SYNC" ]; then
    putlog "Got command: $* from $USER"
    if [ "$CURUSER" = "ALL" -o "$CURUSER" = "all" ]; then
      write_action "SYNC BASIC *"; exit 0
    else
      if [ -z "$CURUSER" ]; then
        echo "Select a user to sync too, or ALL for a full basic sync."; exit 0
      else
        proc_splitusers
        for CURUSER in $CURUSERS; do
          if [ ! -e "$GLUSERS/$CURUSER" ]; then
            if [ "$FORCE" = "YES" ]; then
              echo "Warning: $CURUSER does not exist. Forcing write anyway."
              write_action "SYNC BASIC $CURUSER"
            else
              echo "Warning: $CURUSER does not exist. Issue /force at the end to write anyway."
            fi
          else
            write_action "SYNC BASIC $CURUSER"
          fi
        done; exit 0
      fi
    fi

## STATS
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "STATS" ]; then
    putlog "Got command: $* from $USER"
    if [ "$CURUSER" = "ALL" -o "$CURUSER" = "all" ]; then
      write_action "SYNC STATS *"; exit 0
    else
      if [ -z "$CURUSER" ]; then
        echo "Select a user to move stats from too, or ALL for a full stats move."; exit 0
      else
        proc_splitusers
        for CURUSER in $CURUSERS; do
          if [ ! -e "$GLUSERS/$CURUSER" ]; then
            if [ "$FORCE" = "YES" ]; then
              echo "Warning: $CURUSER does not exist. Forcing write anyway."
              write_action "SYNC STATS $CURUSER"
            else
              echo "Warning: $CURUSER does not exist. Issue /force at the end to write anyway."
            fi
          else
            write_action "SYNC STATS $CURUSER"
          fi
        done; exit 0
      fi
    fi

## FULL
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "FULL" ]; then
    putlog "Got command: $* from $USER"
    if [ "$CURUSER" = "ALL" -o "$CURUSER" = "all" ]; then
      write_action "SYNC FULL *" ; exit 0
    else
      if [ -z "$CURUSER" ]; then
        echo "Select a user to do a full sync on, or ALL for a full sync of info and stats."; exit 0
      else
        proc_splitusers
        for CURUSER in $CURUSERS; do
          if [ ! -e "$GLUSERS/$CURUSER" ]; then
            if [ "$FORCE" = "YES" ]; then
              echo "Warning: $CURUSER does not exist. Forcing write anyway."
              write_action "SYNC FULL $CURUSER"
            else
              echo "Warning: $CURUSER does not exist. Issue /force at the end to write anyway."
            fi
          else
            write_action "SYNC FULL $CURUSER"
          fi
        done; exit 0
      fi
    fi

## FETCHLOGS
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "FETCHLOGS" ]; then
    putlog "Got command: '$*' from $USER"
    write_action "FETCHLOG"; exit 0

## INTEGCHECK
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "INTEGCHECK" ]; then
    putlog "Got command: $* from $USER"
    write_action "INTEGRITY"; exit 0

## DELREPORTS
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "DELREPORTS" ]; then
    putlog "Got command: $* from $USER"
    write_action "DELREPORTS"; exit 0

## DELLOGS
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "DELLOGS" ]; then
    putlog "Got command: $* from $USER"
    rm -f $GLROOT$MSSLOGS/*.log
    echo "All logs deleted from $MSSLOGS"
    echo ""
    exit 0

## BACKUP
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "BACKUP" ]; then
    putlog "Got command: $* from $USER"
    write_action "BACKUP"; exit 0
    exit 0

## LIST
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "LIST" ]; then
    putlog "Got command: $* from $USER"
    echo "Listing of $GLROOT$MSSLOGS dir:"
    echo "Note that dates are when they were last fetched."
    ls -l $GLROOT$MSSLOGS | cut -d' ' -f15-
    echo ""
    exit 0

## READLOG
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "READLOG" ]; then
    putlog "Got command: $* from $USER"
    FILE="$2"
    if [ -z "$FILE" ]; then
      echo "Specify a file to read. Do 'list' to show them."
      exit 0
    fi
    SEARCHWORD="$3"
    if [ -z "$SEARCHWORD" ]; then
      SEARCHWORD=.
    elif [ "$SEARCHWORD" = "-all" ]; then
      SEARCHWORD=.
    else
      MSG=", containing $SEARCHWORD"
    fi
    LINES="$4"
    if [ -z "$LINES" ]; then
      LINES=50
    fi
    if [ ! -r "$GLROOT$MSSLOGS/$FILE" ]; then
      echo "Logfile not readable/found: $GLROOT$MSSLOGS/$FILE"
      echo "do 'list' to see available logfiles."
      exit 0
    else
      echo "Displaying $LINES lines from $FILE$MSG"
      grep -i "$SEARCHWORD" "$GLROOT$MSSLOGS/$FILE" | tail -n $LINES
    fi
    exit 0

## READREPORTS
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "READREPORTS" ]; then
    putlog "Got command: $* from $USER"
    echo "Currently defined slaves: $SLAVES"
    for SLAVE in $SLAVES; do
      echo ""
      echo "Reading report from $SLAVE."
      if [ ! -r "$GLROOT$MSSLOGS/$SLAVE.report" ]; then
        echo "No report exists or file is not readable. Try again in a while."
        exit 0
      else
        cat "$GLROOT$MSSLOGS/$SLAVE.report"
      fi
      echo ""
    done
    exit 0

## READSITELOG
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "READSITELOG" ]; then
    putlog "Got command: $* from $USER"
    LINES="$2"
    if [ ! -z "$( echo $LINES | tr -d '[:digit:]' )" ]; then
      echo "Lines can only be numerical, not $LINES"; exit 0
    fi
    if [ -z "$LINES" ]; then
      LINES="50"
    fi
    if [ ! -r "$LOG" ]; then
      echo "Error. Log does not exist or is not readable."
    else
      cat $LOG | tail -n $LINES
    fi; exit 0

## READACTION
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "READACTION" ]; then
    putlog "Got command: $* from $USER"
    for CURSLAVE in $SLAVES; do
        echo ""
        echo "Reading actionfile for slave: $CURSLAVE"
        if [ -e "$GLETC/$CURSLAVE.actions" ]; then
          cat "$GLETC/$CURSLAVE.actions"
        else
          echo "Actionfile for $CURSLAVE not found. You were too late."
        fi
    done; exit 0

## CANCEL
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "CANCEL" ]; then
    putlog "Got command: $* from $USER"
    SLAVE="$2"
    if [ -z "$SLAVE" ]; then
      echo "Specify a slave or 'all' for all slaves."
      echo "Current slaves are: $SLAVES"
      exit 0
    fi
    if [ "$( echo "$SLAVE" | tr '[:lower:]' '[:upper:]' )" == "ALL" ]; then
      for CURSLAVE in $SLAVES; do
        echo "Removing actionfile for $CURSLAVE"
        if [ -e "$GLETC/$CURSLAVE.actions" ]; then
          rm -f "$GLETC/$CURSLAVE.actions"
          if [ ! -e "$GLETC/$CURSLAVE.actions" ]; then
            echo "* Cleared successfully."
          else
            echo "* Clear failed! Permissions might be wrong."
          fi
        else
          echo "Actionfile for $CURSLAVE not found. You were too late."
        fi
      done; exit 0
    else
      if [ -z "$( echo "$SLAVES" | grep "^$SLAVE" )" ]; then
        echo "$SLAVE is undefined. Valid slaves are $SLAVES."; exit 0
      else
        CURSLAVE="$SLAVE"
        echo "Removing actionfile for $CURSLAVE"
        if [ -e "$GLETC/$CURSLAVE.actions" ]; then
          rm -f "$GLETC/$CURSLAVE.actions"
          if [ ! -e "$GLETC/$CURSLAVE.actions" ]; then
            echo "* Cleared successfully."
          else
            echo "* Clear failed! Permissions might be wrong."; exit 0
          fi
        else
          echo "Actionfile for $CURSLAVE not found. You were too late."; exit 0
        fi
      fi
    fi; exit 0

## TRIM
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "TRIM" ]; then
    putlog "Got command: $* from $USER"
    SIZE="$2"
    if [ -z "$SIZE" ]; then
      echo "Select a size in MB to trim the logs down to or 'CLEAR' to empty totally."; exit 0
    fi
    if [ ! -x "$GLROOT/bin/bc" ]; then
      echo "Error: You need 'bc' in your /glftpd/bin folder for this."
      echo "Do a 'which bc' from shell and copy it to /glftpd/bin/"
      echo "If it is already there, the permissions are wrong cause I cant execute it."; exit 0
    fi
    if [ ! -x "$GLROOT/bin/tr" ]; then
      echo "Error: You need 'tr' in your /glftpd/bin folder for this."
      echo "Do a 'which tr' from shell and copy it to /glftpd/bin/"
      echo "If it is already there, the permissions are wrong cause I cant execute it."; exit 0
    fi
    if [ ! -z "$( echo "$SIZE" | tr -d '[:digit:]' )" ]; then
      if [ "$( echo "$SIZE" | tr '[:lower:]' '[:upper:]' )" != "CLEAR" ]; then
        echo "Only use digits in MB parameter!"; exit 0
      fi
    fi
    if [ "$( echo "$SIZE" | tr '[:lower:]' '[:upper:]' )" != "CLEAR" ]; then
      if [ "$SIZE" -lt "1" ]; then
        echo "Size can not be below 1MB!"; exit 0
      fi
    else
      SIZE="$( echo $SIZE | tr '[:lower:]' '[:upper:]' )"
    fi
    if [ "$( echo "$SIZE" | tr '[:lower:]' '[:upper:]' )" != "CLEAR" ]; then
      SIZE="$( echo "$SIZE * 1024 * 1024" | bc -l | awk -F"." '{print $1}' )"
      if [ -z "$SIZE" -o "$SIZE" = " " ]; then
        echo ""
        echo "Error: Either that was not a number or you are missing some libs."
        echo "If you are getting 'blabla.lib, no such file or directory', then, from shell, do:"
        echo "locate blabla.lib"
        echo "Then copy the file to your /glftpd/lib folder and try again. Do that for each file"
        echo "that you get the error on."; exit 0
      fi
    fi
    write_action "TRIM $SIZE"; exit 0

## COUNTACTION
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "COUNTACTION" ]; then
  COUNT=$( ls -1 $GLETC/*.actions* 2> /dev/null | wc -l | awk '{ print $1 }' )
  echo $COUNT; exit 0

## REPLLIST
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "REPLLIST" ]; then
    putlog "Got command: $* from $USER"
    echo "NOTE: Make sure perms are correct before pushing files out to slaves !!"
    echo "Listing of $MSSREPL dir:"
    ls -l $MSSREPL
    echo ""
    exit 0

## REPLICATE
elif [ "$( echo "$GLCMD" | tr '[:lower:]' '[:upper:]' )" == "REPLICATE" ]; then
    putlog "Got command: $* from $USER"
    FILENAME="$2"
    TOSLAVE="$3"
    TOPATH="$4"
    if [ "$FILENAME" = "" -o "$TOSLAVE" = "" ]; then
      echo "replicate <script> <slave/-all>"
      echo "   ^--------------> - Replicate a script for a slave. Enter -all for all slaves."
      exit 0
    fi
    if [ -z "$( echo "$SLAVES" | grep -w -- "$TOSLAVE" )" -a "$TOSLAVE" != "-all" ]; then
      echo "$TOSLAVE is undefined in config. Current slaves are: $SLAVES"
      exit 0
    fi
    if [ ! -e "$MSSREPL/$FILENAME" ]; then
      echo "$FILENAME was not found. Use 'site mss repllist' to see contents"
      exit 0
    fi
    if [ "$TOSLAVE" != "-all" ]; then
      SLAVES="$TOSLAVE"
    fi
    write_action "UPDATE $FILENAME $TOPATH"; exit 0

## End parse command
fi

echo "Error. Command $GLCMD is not implemented."
proc_help

##################################################################
# END OF SCRIPT
##################################################################
