#!/bin/bash
VER=2.2.1

## Remove the # from the below line to hard set your glftpd root.
## Otherwise, it will be read from mss-slave.id in the same folder
## as mss-core.sh
# GLROOT=/glftpd

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same place as mss-core.sh
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

##############################################
# GO                                         #
##############################################

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi
if [ -r "$MSSSLAVECONFIG" ]; then
  . $MSSSLAVECONFIG
else
  echo "MSS error: Config file: $MSSSLAVECONFIG not found or no permissions to read it."
  exit 0
fi

if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    rm -f $LOCKFILE
    exit 0
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      rm -f $LOCKFILE
      exit 0
    fi
  fi
fi

if [ "$1" = "debug" -o "$2" = "debug" -o "$3" = "debug" -o "$4" = "debug" ]; then
  DEBUG=TRUE
fi

## Function for outputting to screen.
proc_debug() {
  if [ "$DEBUG" = "TRUE" ]; then
    echo "$*"
  fi
}

## Function for writing to log.
proc_log() {
  if [ "$LOG" != "" ]; then
    if [ -z "$ACTIONFILE" ]; then
      echo `date "+%a %b %e %T %Y"` USYNC: \"$*\" >> $LOG
    else
      echo `date "+%a %b %e %T %Y"` USYNCA: \"$*\" >> $LOG
    fi
  fi
}

## Function for writing to statlog.
proc_statlog() {
  if [ ! -z "$STATLOG" ]; then
    if [ -z "$ACTIONFILE" ]; then
      echo `date "+%a %b %e %T %Y"` USYNC: \"$*\" >> $STATLOG
    else
      echo `date "+%a %b %e %T %Y"` USYNCA: \"$*\" >> $STATLOG
    fi
  fi
}

## MOD 2003-01-25 by Turranius
## Changed from $LOG to $HIGHDEBUGLOG
## If HIGHDEBUGLOG is undefined in conf, use $LOG.
## Function for writing highdebug info to log.
if [ -z "$HIGHDEBUGLOG" ]; then HIGHDEBUGLOG="$LOG"; fi
proc_highdebug() {
   if [ "$HIGHDEBUG" = "TRUE" ]; then
     echo `date "+%a %b %e %T %Y"` USYNCDB: \"$*\" >> $HIGHDEBUGLOG
   fi
}

## NEW: 2003-01-21
## Function for writing to msspost log. 
## Mostly used for integritycheck
proc_msslog() {
  if [ ! -z "$FETCHLOGSDIR" ]; then
    if [ ! -e "$FETCHLOGSDIR" ]; then
      mkdir $FETCHLOGSDIR >/dev/null 2>&1
      chmod $PERMS $FETCHLOGSDIR >/dev/null 2>&1
      if [ ! -w "$FETCHLOGSDIR/" ]; then      
        proc_log "Error: Cannot write to $FETCHLOGSDIR so no logs copied."
        proc_debug "Error: Fetchlog: Cannot write to $FETCHLOGSDIR so no logs copied."
      fi
    else
      if [ "$DELMSSLOG" = "TRUE" ]; then
        echo `date "+%a %b %e %T %Y"` CLEAR: \"$*\" > $FETCHLOGSDIR/$DESTNAME.report
        unset DELMSSLOG
      else
        if [ "$REPORTUPDATE" = "YES" ]; then
          echo `date "+%a %b %e %T %Y"` UPDATE: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
        else
          echo `date "+%a %b %e %T %Y"` INTEGCK: \"$*\" >> $FETCHLOGSDIR/$DESTNAME.report
        fi
      fi
    fi
  else
    proc_log "Error: FETCHLOGSDIR is undefined in config."
    proc_debug "Error: FETCHLOGSDIR is undefined in config."
  fi
}

## If lockfile exists, then quit.
# sleep 0.$RANDOM
if [ -e "$LOCKFILE" ]; then
  if [ "$UNLOCK" != "TRUE" ]; then
    RESULT="$( ps -A -o "pid args" )"
    RESULT="$( echo "$RESULT" | grep "^[[:space:][:digit:]]\{5\} /bin/[ba]*sh $0.*" | grep -v "^[:space:]\{0,5\}$$ " )"
    SCRIPTNAME="$( basename $0 )"
    if [ -z "$RESULT" ]; then
      proc_log "Lockfile exists, but cant find $SCRIPTNAME running. Removing lockfile."
      proc_debug "Lockfile exists, but cant find $SCRIPTNAME running. Removing lockfile."
      rm -f $LOCKFILE
    else
      proc_debug "Lockfile $LOCKFILE exists and $SCRIPTNAME running. Quitting."
      proc_highdebug "Lockfile exists and $SCRIPTNAME running. Quitting."
      exit 0
    fi
  fi
fi

## Create lockfile.
if [ "$LOCKFILE" != "" ]; then
  proc_highdebug "Creating lockfile: $LOCKFILE"
  touch $LOCKFILE
fi

proc_highdebug "-----------------------------------"
proc_highdebug "Starting MSS v$VER with command: $1"

## Check existans of required files.
if [ -z "$( which bc )" ]; then
  echo "Binary 'bc' not found in path. Quitting."
  proc_highdebug "Binary 'bc' not found in path. Quitting."
  rm -f $LOCKFILE
  exit 0
fi

if [ -z "$EXCLUDE" ]; then
  EXCLUDE="FEu38ru38fj"
fi

if [ "$PINGTEST" = "TRUE" ]; then
  if [ -z "$DNSHUB" ]; then
    DNSHUB="$( grep $USERSOURCE /etc/fstab | cut -d':' -f1 )"
  fi
  if [ -z "$DNSHUB" ]; then
    proc_debug "PINGTEST is TRUE, but I could not get the hostname for the NFS server."
    proc_debug "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server. Quitting PINGTEST"
    proc_log "PINGTEST is TRUE, but I could not get the hostname for the NFS server."
    proc_log "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server. Quitting PINGTEST"
  else
    if [ -z "$PINGOPTIONS" ]; then
      proc_debug "Error: No PINGOPTIONS set in mss-slave.conf. Did you upgrade correctly?"
      proc_debug "cont.: Check the README for PINGOPTIONS instructions. Quitting now."
      proc_log "Error: No PINGOPTIONS set in mss-slave.conf. Did you upgrade correctly?"
      proc_log "cont.: Check the README for PINGOPTIONS instructions. Quitting now."
      rm -f $LOCKFILE
      exit 0
    fi
    PINGLIST="$( ping $DNSHUB $PINGOPTIONS | tr -s ' ' '^' | egrep 'packets|received' )"
    if [ -z "$PINGTEST" ]; then
      proc_debug "PINGTEST failed. $DNSHUB was not resolved."
      proc_log "PINGTEST failed. $DNSHUB was not resolved."
      PINGFAIL="TRUE"
    else
      PINGSENT="$( echo "$PINGLIST" | cut -d'^' -f1 )"
      PINGRECI="$( echo "$PINGLIST" | cut -d'^' -f4 )"
      if [ "$PINGRECI" = "0" ]; then
        proc_debug "PINGTEST failed. $PINGSENT sent, $PINGRECI received."
        proc_log "PINGTEST failed. $PINGSENT sent, $PINGRECI received from $DNSHUB."
        PINGFAIL="TRUE"
      else
        if [ "$PINGRECI" = "1" ]; then
          proc_highdebug "PINGTEST warning. Only 1 of 2 packets recived."
        fi
      fi
    fi
  fi
  if [ "$PINGFAIL" = "TRUE" ]; then
    if [ "$( mount | grep "$USERSOURCE" | cut -d' ' -f3 )" = "$USERSOURCE" ]; then
      proc_debug "MSS will now try to umount USERSOURCE since its mounted."
      proc_log "MSS will now try to umount USERSOURCE since its mounted."
      umount -f $USERSOURCE >/dev/null 2>&1
      umount -l $USERSOURCE >/dev/null 2>&1
      umount $USERSOURCE >/dev/null 2>&1
    fi
    if [ "$( mount | grep "$PASSWDSOURCE" | cut -d' ' -f3 )" = "$PASSWDSOURCE" ]; then
      proc_debug "MSS will now try to umount PASSWDSOURCE since its mounted."
      proc_log "MSS will now try to umount PASSWDSOURCE since its mounted."
      umount -f $PASSWDSOURCE >/dev/null 2>&1
      umount -l $PASSWDSOURCE >/dev/null 2>&1
      umount $PASSWDSOURCE >/dev/null 2>&1
    fi
    rm -f $LOCKFILE
    exit 0
  fi
fi

## Extra hub-up verification for NFS usage.
if [ "$USENFS" = "TRUE" ]; then
  if [ -z "$DNSHUB" ]; then
    DNSHUB="$( grep $USERSOURCE /etc/fstab | cut -d':' -f1 )"
  fi
  if [ -z "$DNSHUB" ]; then
    proc_debug "USENFS is TRUE, but I could not get the hostname for the NFS server."
    proc_debug "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server."
    proc_log "USENFS is TRUE, but I could not get the hostname for the NFS server."
    proc_log "Its probably not in fstab. Use DNSHUB to hardset the name or IP for the server."
  else
    if [ ! -e $RPCINFO ]; then
      proc_debug "USENFS is true, but I cant execute the binary 'rpcinfo' used to check connection. Check RPCINFO"
      proc_debug "Not doing the NFS-up check.."
      proc_log "USENFS is true, but I cant execute the binary 'rpcinfo' used to check connection. Check RPCINFO"
      proc_log "Not doing the NFS-up check.."
    else
      RPCLIST="$( $RPCINFO -p $DNSHUB | tr -s ' ' '^' )"
      if [ -z "$( echo $RPCLIST | grep -w "rquotad" )" ]; then
        proc_debug "NFS check failed. Service 'rquotad' not seen on $DNSHUB. Note: do a"
        proc_debug "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        proc_log "NFS check failed. Service 'rquotad' not seen on $DNSHUB. Note: do a"
        proc_log "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        NFSERROR="TRUE"
      fi
      if [ -z "$( echo $RPCLIST | grep -w "nfs" )" ] && [ "$NFSERROR" != "TRUE" ]; then
        proc_debug "NFS check failed. Service 'nfs' not seen on $DNSHUB. Note: do a"
        proc_debug "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        proc_log "NFS check failed. Service 'nfs' not seen on $DNSHUB. Note: do a"
        proc_log "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        NFSERROR="TRUE"
      fi
      if [ -z "$( echo $RPCLIST | grep "nlock" )" ] && [ "$NFSERROR" != "TRUE" ]; then
        proc_debug "NFS check failed. Service 'nlock' not seen on $DNSHUB. Note: do a"
        proc_debug "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        proc_log "NFS check failed. Service 'nlock' not seen on $DNSHUB. Note: do a"
        proc_log "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        NFSERROR="TRUE"
      fi
      if [ -z "$( echo $RPCLIST | grep -w "mountd" )" ] && [ "$NFSERROR" != "TRUE" ]; then
        proc_debug "NFS check failed. Service 'mountd' not seen on $DNSHUB. Note: do a"
        proc_debug "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        proc_log "NFS check failed. Service 'mountd' not seen on $DNSHUB. Note: do a"
        proc_log "'rpcinfo -p $DNSHUB'. It should display atleast 4 services (nfs, mountd, nlock & rquotad )."
        NFSERROR="TRUE"
      fi
      if [ "$NFSERROR" = "TRUE" ]; then
        if [ "$( mount | grep "$USERSOURCE" | cut -d' ' -f3 )" = "$USERSOURCE" ]; then
          proc_debug "MSS will now try to umount USERSOURCE since its mounted."
          proc_log "MSS will now try to umount USERSOURCE since its mounted."
          umount -f $USERSOURCE >/dev/null 2>&1
          umount -l $USERSOURCE >/dev/null 2>&1
          umount $USERSOURCE >/dev/null 2>&1
        fi
        if [ "$( mount | grep "$PASSWDSOURCE" | cut -d' ' -f3 )" = "$PASSWDSOURCE" ]; then
          proc_debug "MSS will now try to umount PASSWDSOURCE since its mounted."
          proc_log "MSS will now try to umount PASSWDSOURCE since its mounted."
          umount -f $PASSWDSOURCE >/dev/null 2>&1
          umount -l $PASSWDSOURCE >/dev/null 2>&1
          umount $PASSWDSOURCE >/dev/null 2>&1
        fi
        rm -f $LOCKFILE
        exit 0
      fi
      unset RPCLIST
    fi
  fi
fi

if [ ! -e $USERSOURCE/$VERIFYUSER ]; then
  if [ "$REMOUNT" = "TRUE" ]; then
    VERFSTAB="$( grep -w "$USERSOURCE" /etc/fstab )"
    if [ "$VERFSTAB" = "" ]; then
      echo "REMOUNT is TRUE, but no entry in /etc/fstab for $USERSOURCE. Quitting."
      rm -f $LOCKFILE
      exit 0 
    fi
    unset VERFSTAB
    proc_highdebug "Attempting to remount $USERSOURCE"
    proc_debug "Attempting to remount $USERSOURCE."
    umount -f $USERSOURCE >/dev/null 2>&1
    umount -l $USERSOURCE >/dev/null 2>&1
    umount $USERSOURCE >/dev/null 2>&1
    sleep 1
    if [ "$( mount | grep "$USERSOURCE" | cut -d' ' -f3 )" = "$USERSOURCE" ]; then
      proc_log "Error: Seems I couldnt unmount $USERSOURCE."
      proc_debug "Error. Seems I couldnt unmount $USERSOURCE."
      rm -f $LOCKFILE
      exit 0
    else
      mount $USERSOURCE >/dev/null 2>&1
      sleep 1
      if [ -e $USERSOURCE/$VERIFYUSER ]; then
        proc_log "Verify user $VERIFYUSER did not exist. Remount successfull."
      else
        echo "Verify user $VERIFYUSER does not exist. Remount failed."
        proc_log "Verify user $VERIFYUSER does not exist. Remount failed."
        rm -f $LOCKFILE
        exit 0
      fi
    fi
  else
    echo "Cant find $USERSOURCE/$VERIFYUSER - Link down?"
    rm -f $LOCKFILE
    exit 0
  fi
fi

if [ ! -e $PASSWDSOURCE/passwd ]; then
  if [ "$REMOUNT" = "TRUE" ]; then
    VERFSTAB="$( grep -w "$PASSWDSOURCE" /etc/fstab )"
    if [ "$VERFSTAB" = "" ]; then
      echo "REMOUNT is TRUE, but no entry in /etc/fstab for $USERSOURCE. Quitting."
      proc_highdebug "REMOUNT is TRUE, but no entry in /etc/fstab for $USERSOURCE. Quitting."
      rm -f $LOCKFILE
      exit 0 
    fi
    proc_highdebug "Attempting to remount $PASSWDSOURCE"
    proc_debug "Attempting to remount $PASSWDSOURCE."
    umount -f $PASSWDSOURCE >/dev/null 2>&1
    umount -l $PASSWDSOURCE >/dev/null 2>&1
    umount $PASSWDSOURCE >/dev/null 2>&1
    sleep 1
    if [ "$( mount | grep "$PASSWDSOURCE" | cut -d' ' -f3 )" = "$PASSWDSOURCE" ]; then
      proc_log "Error: Seems I couldnt unmount $PASSWDSOURCE."
      proc_debug "Error. Seems I couldnt unmount $PASSWDSOURCE."
      rm -f $LOCKFILE
      exit 0
    else
      mount $PASSWDSOURCE >/dev/null 2>&1
      sleep 1
      if [ -e $PASSWDSOURCE/passwd ]; then
        proc_log "Couldnt find $PASSWDSOURCE/passwd - Remount successfull."
      else
        echo "Cant find $PASSWDSOURCE/passwd - Remount failed."
        proc_log "Cant find $PASSWDSOURCE/passwd - Remount failed."
        rm -f $LOCKFILE
        exit 0
      fi
    fi
  else
    echo "Cant find $PASSWDSOURCE/passwd - Link down?"
    rm -f $LOCKFILE
    exit 0
  fi
fi

if [ ! -r $PASSWDSOURCE/passwd ]; then
  echo "Cant read $PASSWDSOURCE/passwd - Wrong perms? Quitting."
  rm -f $LOCKFILE
  exit 0
fi

if [ ! -r $PASSWDSOURCE/group ]; then
  echo "Cant read $PASSWDSOURCE/group - Wrong perms? Quitting."
  exit 0
fi

if [ "$LOG" != "" ]; then
  if [ -e $LOG ]; then
    if [ "$PERMS" != "" ]; then
      proc_highdebug "Setting $PERMS on $LOG"
      chmod $PERMS $LOG >/dev/null 2>&1
    fi
  else
    proc_highdebug "Creating $LOG"
    touch $LOG
    proc_highdebug "Setting $PERMS on $LOG"
    chmod $PERMS $LOG >/dev/null 2>&1
  fi
fi

proc_debug "Network seems fine."

## Check for ERROR.TEMPSTATS and warn if there.
unset verify
if [ -e $TMP/ERROR.TEMPSTATS.*.DEST.NEW ]; then
  verify="error"
fi
if [ -e $TMP/ERROR.TEMPSTATS.*.NEW ]; then
  verify="error"
fi
if [ "$verify" != "" ]; then
  if [ "$1" = "" ]; then
    echo "Warning. There are failed userfiles in $TMP."
    echo "         These are called ERROR.TEMPSTATS.*"
    echo "         Have a look. If nothing is wrong, delete them."
    echo "-------------------------------------------------------"
  else
    proc_debug "Warning. There are failed userfiles in $TMP."
    proc_debug "         These are called ERROR.TEMPSTATS.*"
    proc_debug "         Have a look. If nothing is wrong, delete them."
    proc_debug "-------------------------------------------------------"
  fi
  proc_highdebug "Warning. There are failed ERROR.TEMPSTATS.* files in $TMP. Examine those and"
  proc_highdebug "         if there is nothing wrong with the user(s), delete them."
fi
unset verify

## Procedute for locking on source
proc_lock_src() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERSOURCE/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY="$( expr $RETRY \- 1 )"
    proc_debug "$USER seems locked at $USERSOURCE. Retries left: $RETRY."
    proc_highdebug "$USER seems locked at $USERSOURCE. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERSOURCE/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    proc_debug "$USER seems locked at $USERSOURCE. Skipping."
    proc_highdebug "$USER Seems locked at $USERSOURCE. Skipping."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      proc_debug "Lock lifted. Locking him myself."
      proc_highdebug "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERSOURCE/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on source
proc_unlock_src() {
  if [ -e "$USERSOURCE/$USER.lock" ]; then
    rm -f $USERSOURCE/$USER.lock
  fi
}

## Procedute for locking on destination
proc_lock_dst() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERDEST/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY="$( expr $RETRY \- 1 )"
    proc_debug "$USER seems locked at $USERDEST. Retries left: $RETRY."
    proc_highdebug "$USER seems locked at $USERDEST. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERDEST/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    proc_debug "$USER seems locked at $USERDEST. Skipping."
    proc_highdebug "$USER Seems locked at $USERDEST. Skipping."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      proc_debug "Lock lifted. Locking him myself."
      proc_highdebug "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERDEST/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on destination
proc_unlock_dst() {
  if [ -e "$USERDEST/$USER.lock" ]; then
    rm -f $USERDEST/$USER.lock
  fi
}

## Procedure for verifying userfile.
proc_userver() {
  unset VERERR
  if [ ! -e "$CHECKPATH/$USER" ]; then
    VERERR="Does_Not_Exist"
  else
    if [ -z "$( grep "^USER " $CHECKPATH/$USER )" ]; then VERERR="$VERERR USER"; fi
    if [ -z "$( grep "^GENERAL " $CHECKPATH/$USER )" ]; then VERERR="$VERERR GENERAL"; fi
    if [ -z "$( grep "^LOGINS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR LOGINS"; fi
    if [ -z "$( grep "^TIMEFRAME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIMEFRAME"; fi
    if [ -z "$( grep "^FLAGS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR FLAGS"; fi
    if [ -z "$( grep "^TAGLINE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TAGLINE"; fi
    if [ -z "$( grep "^DIR " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DIR"; fi
    if [ -z "$( grep "^CREDITS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR CREDITS"; fi
    if [ -z "$( grep "^RATIO " $CHECKPATH/$USER )" ]; then VERERR="$VERERR RATIO"; fi
    if [ -z "$( grep "^ALLUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLUP"; fi
    if [ -z "$( grep "^ALLDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLDN"; fi
    if [ -z "$( grep "^WKUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKUP"; fi
    if [ -z "$( grep "^WKDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKDN"; fi
    if [ -z "$( grep "^DAYUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYUP"; fi
    if [ -z "$( grep "^DAYDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYDN"; fi
    if [ -z "$( grep "^MONTHUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHUP"; fi
    if [ -z "$( grep "^MONTHDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHDN"; fi
    if [ -z "$( grep "^NUKE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR NUKE"; fi
    if [ -z "$( grep "^TIME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIME"; fi
    if [ -z "$( grep "^SLOTS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR SLOTS"; fi
    if [ "$VERERR" != "" ]; then
      VERERR="$( echo $VERERR | tr -s ' ' )"
    fi
  fi
}

## Procedure for syncing user.
proc_syncuser() {
  EXISTS=""
  if [ -e $USERDEST/$USER ]; then
    proc_debug "Syncing: $USER"
    EXISTS="YES"
  else
    proc_highdebug "Syncing NEW user $USER"
    proc_debug "Syncing new user: $USER"
    EXISTS="NO"
  fi

  ## MOD 2003-01-21 by Turranius
  ## Added check if user exists.
  ## MOD 2003-02-26 by Turranius
  ## Removed size check on userfile. Not really needed and only caused problems.
  if [ ! -e "$USERSOURCE/$USER" ]; then
    proc_debug "$USER not found in $USERSOURCE on $SOURCENAME."
    proc_log "$USER not found in $USERSOURCE on $SOURCENAME."
    SKIP="YES"
  fi

  ## MOD 2003-01-21 by Turranius
  ## Changed proc_debug and proc_log output ( deleted \user\ userfile for )
  ## Check if he was previously deleted from destination server.
  ## If so, restore that file instead of resetting stats.
  ## MOD 2003-01-26 by Turranius
  ## Rewrote so it does all changes to a temp file which it then checks integ on before moving over.
  if [ "$BACKUPDEST" != "" ]; then
    if [ -e "$BACKUPDEST/deleted/$USER" ]; then
      proc_debug "Warning: Found previosly deleted userfile for: $USER - Mistakenly deleted? Not touching."
      proc_log "Warning: Found previosly deleted userfile for: $USER - Mistakenly deleted? Not touching."
    fi
  fi

  ## Check that this user did not previously fail sync and skip if so.
  if [ -e $TMP/ERROR.$USER ]; then
    proc_debug "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    proc_log "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    SKIP="YES"
  fi

  if [ "$SKIP" != "YES" ]; then
    ## Verify integrity of userfile from source.
    CHECKPATH="$USERSOURCE"
    proc_highdebug "Verifying integrity of user: $USER from $SOURCENAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      proc_debug "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      proc_log "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      SKIP="YES"
    fi
    unset CHECKPATH
  fi

  ## If the user exists, verify integrity on destination too.
  if [ "$EXISTS" = "YES" -a "$SKIP" != "YES" ]; then
    CHECKPATH="$USERDEST"
    proc_highdebug "Verifying integrity of user: $USER from $DESTNAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      proc_debug "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      proc_log "Error: User $CHECKPATH/$USER have problems with the following fields: $VERERR"
      SKIP="YES"
    fi
    unset CHECKPATH
  fi

  ## User did not exist before
  if [ "$EXISTS" = "NO" -a "$SKIP" != "YES" -a "$SKIPRES" != "YES" ]; then

    ## Do a clean copy and remove stats/creds

    cp -f $USERSOURCE/$USER $TMP/NEWUSER.$USER
    proc_debug "Resetting all stats on new user: $USER"
    proc_log "Resetting all stats on new user: $USER"

    ## Reset CREDITS
    sed -e "s/^CREDITS .*/CREDITS 0/" $TMP/NEWUSER.$USER > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset ALL UPLOAD stats
    sed -e "s/^ALLUP .*/ALLUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW
 
    ## Reset ALL DOWNLOAD stats
    sed -e "s/^ALLDN .*/ALLDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset WEEK UP stats
    sed -e "s/^WKUP .*/WKUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset WEEK DOWNLOAD stats
    sed -e "s/^WKDN .*/WKDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset DAY UPLOAD stats
    sed -e "s/^DAYUP .*/DAYUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset DAY DOWNLOAD stats
    sed -e "s/^DAYDN .*/DAYDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset MONTH UPLOAD stats
    sed -e "s/^MONTHUP .*/MONTHUP 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset MONTH DOWNLOAD stats
    sed -e "s/^MONTHDN .*/MONTHDN 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset NUKE counter
    sed -e "s/^NUKE .*/NUKE 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset TIME online
    sed -e "s/^TIME .*/TIME 0 0 0 0/" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Reset NUKE counter
    sed -e "s/^SLOTS .*/SLOTS 0 0 /" $TMP/NEWUSER.$USER.NEW > $TMP/NEWUSER.$USER.NEW.TMP
    mv -f $TMP/NEWUSER.$USER.NEW.TMP $TMP/NEWUSER.$USER.NEW

    ## Verify new userfile:
    CHECKPATH="$TMP"
    USERTMP="$USER"
    USER="NEWUSER.$USER.NEW"
    proc_highdebug "Verifying integrity of new userfile for $USER ment for $DESTNAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      proc_debug "Error: Newly created userfile $CHECKPATH/$USER have problems with the following fields: $VERERR. User not added."
      proc_log "Error: Newly created userfile $CHECKPATH/$USER have problems with the following fields: $VERERR. User not added."
      SKIP="YES"
      USER="$USERTMP"
      unset USERTMP
    else
      USER="$USERTMP"
      unset USERTMP
      proc_lock_dst
      if [ "$SKIP" != "YES" ]; then
        mv -f $TMP/NEWUSER.$USER.NEW $USERDEST/$USER
        if [ "$PERMS" != "" ]; then
          chmod $PERMS $USERDEST/$USER >/dev/null 2>&1
          proc_highdebug "Setting chmod $PERMS on new user $USER"
        fi
      fi
      proc_unlock_dst
    fi
    unset CHECKPATH
  fi
  SKIPRES="NO"

  ## User already existed. Lets sync the ips/groups etc
  if [ "$EXISTS" = "YES" -a "$SKIP" != "YES" ]; then

    ## Lets make sure theres no temp file for this user.
    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
      rm -f $TMP/TEMPSTATS.$USER.NEW
      proc_highdebug "Warning: Previous file from earlier sync found. Clearing it. File was: $TMP/TEMPSTATS.$USER.NEW"
    fi

    ## Sync FLAGS
    if [ "$SKIP" != "YES" ]; then
      unset DESTFLAGS; unset SOURCEFLAGS
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTFLAGS="$( grep "^FLAGS " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | awk '{print $2}' )"
      if [ "$DESTFLAGS" = "" ]; then
        proc_log "Error: Cant read FLAGS from $USERDEST/$USER"
        proc_debug "Error: Cant read RATIO from $USERDEST/$USER"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        if [ "$NOGADMINS" = "TRUE" ]; then
          SOURCEFLAGS="$( grep "^FLAGS " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}' | tr -d '2' )"
        else
          SOURCEFLAGS="$( grep "^FLAGS " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}' )"
        fi
      else
        unset SOURCEFLAGS
        proc_highdebug "Error: Cant read FLAGS from $USERSOURCE/$USER"
      fi
      if [ "$SOURCEFLAGS" != "" -a "$DESTFLAGS" != "" ]; then
        proc_highdebug "$USER - FLAGS = $DESTNAME $DESTFLAGS / $SOURCENAME $SOURCEFLAGS"
        if [ "$DESTFLAGS" != "$SOURCEFLAGS" ]; then
          if [ "$SKIP" != "YES" ]; then
            sed -e "s/^FLAGS .*/FLAGS $SOURCEFLAGS/" $CURRENTFILE > $TMP/TEMP.$USER.FLAGS
            mv -f $TMP/TEMP.$USER.FLAGS $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - FLAGS changed from $DESTFLAGS to $SOURCEFLAGS"
            proc_log "$USER - FLAGS change from $DESTFLAGS to $SOURCEFLAGS"
            sleep $SLOWTIME
          fi
        fi
      fi
    fi

    ## Sync RATIO
    if [ "$SKIP" != "YES" ]; then
      unset DESTRATIO; unset SOURCERATIO
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTRATIO="$( grep "^RATIO " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | awk '{print $2}' )"
      if [ "$DESTRATIO" = "" ]; then
        proc_log "Error: Cant read RATIO from $USERDEST/$USER"
        proc_debug  "Error: Cant read RATIO from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCERATIO="$( grep "^RATIO" $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}' )"
      else
        unset SOURCERATIO
        proc_highdebug "Error: Cant read RATIO from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCERATIO" != "" -a "$DESTRATIO" != "" ]; then
        proc_highdebug "$USER - RATIO = $DESTNAME $DESTRATIO / $SOURCENAME $SOURCERATIO"
        if [ "$DESTRATIO" != "$SOURCERATIO" ]; then
          if [ "$SKIP" != "YES" ]; then
            sed -e "s/^RATIO .*/RATIO $SOURCERATIO/" $CURRENTFILE > $TMP/TEMP.$USER.RATIO
            mv -f $TMP/TEMP.$USER.RATIO $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - RATIO changed from $DESTRATIO to $SOURCERATIO"
            proc_log "$USER - RATIO change from $DESTRATIO to $SOURCERATIO"
            sleep $SLOWTIME
          fi
        fi
      fi
    fi

    ## Sync GENERAL
    if [ "$SKIP" != "YES" ]; then
      unset DESTGENERAL; unset SOURCEGENERAL; unset ALLOTMENTNR
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTGENERAL="$( grep "^GENERAL " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTGENERAL" = "" ]; then
        proc_log "Error: Cant read GENERAL from $USERDEST/$USER"
        proc_debug "Error: Cant read GENERAL from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCEGENERAL="$( grep "^GENERAL " $USERSOURCE/$USER )"
      else
        SOURCEGENERAL=""
        proc_highdebug "Error: Cant read GENERAL from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCEGENERAL" != "" -a "$DESTGENERAL" != "" ]; then
        proc_highdebug "$USER - GENERAL = $DESTNAME $DESTGENERAL / $SOURCENAME $SOURCEGENERAL"

        if [ "$SHAREALLOTMENT" = "FALSE" ]; then
          ALLOTMENTNR="$( echo "$SOURCEGENERAL" | awk -F"," '{print $2}' | awk '{print $1}' )"
          if [ "$ALLOTMENTNR" != "0" ]; then
            ALLOTMENT="YES"
          else
            ALLOTMENT="NO"
          fi
          if [ "$ALLOTMENT" = "YES" ]; then
            SOURCEGENFIRST="$( echo "$SOURCEGENERAL" | awk -F"," '{print $1}' | awk '{print $2}' )"
            SOURCEGENTHIRD="$( echo "$SOURCEGENERAL" | awk '{print $3}' )"
            SOURCEGENFOURTH="$( echo "$SOURCEGENERAL" | awk '{print $4}' )"
            SOURCEGENFIFTH="$( echo "$SOURCEGENERAL" | awk '{print $5}' )"
            SOURCEGENERAL="GENERAL $SOURCEGENFIRST,1000 $SOURCEGENTHIRD $SOURCEGENFOURTH $SOURCEGENFIFTH"
            proc_highdebug "$USER have $ALLOTMENTNR allotment on $SOURCENAME - Faking 1000 kb."
            unset SOURCEGENFIRST; unset SOURCEGENTHIRD; unset SOURCEGENFOURTH; unset SOURCEGENFIFTH
          fi
        fi

        if [ "$DESTGENERAL" != "$SOURCEGENERAL" ]; then
          ## Sync general from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^GENERAL " $CURRENTFILE > $TMP/TEMP.$USER.GENERAL
            echo "$SOURCEGENERAL" >> $TMP/TEMP.$USER.GENERAL
            mv -f $TMP/TEMP.$USER.GENERAL $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - GENERAL changed from $DESTGENERAL to $SOURCEGENERAL"
            proc_log "$USER - GENERAL change from $DESTGENERAL to $SOURCEGENERAL"
            sleep $SLOWTIME
          fi
        fi
      fi
    fi

    ## Sync LOGINS
    if [ "$SKIP" != "YES" ]; then
      unset DESTLOGINS; unset SOURCELOGINS
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTLOGINS="$( grep "^LOGINS " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTLOGINS" = "" ]; then
        proc_log "Error: Cant read LOGINS from $USERDEST/$USER"
        proc_debug "Error: Cant read LOGINS from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCELOGINS="$( grep "^LOGINS " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
      else
        SOURCELOGINS=""
        proc_highdebug "Error: Cant read LOGINS from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCELOGINS" != "" -a "$DESTLOGINS" != "" ]; then
        proc_highdebug "$USER - LOGINS = $DESTNAME $DESTLOGINS / $SOURCENAME $SOURCELOGINS"
        if [ "$DESTLOGINS" != "$SOURCELOGINS" ]; then
          ## Sync login from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^LOGINS " $CURRENTFILE > $TMP/TEMP.$USER.LOGINS
            echo "$SOURCELOGINS" >> $TMP/TEMP.$USER.LOGINS
            mv -f $TMP/TEMP.$USER.LOGINS $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - LOGINS changed from $DESTLOGINS to $SOURCELOGINS"
            proc_log "$USER - LOGINS changed from $DESTLOGINS to $SOURCELOGINS"
            sleep $SLOWTIME
          fi
        fi
      fi
    fi

    ## Sync TAGLINE
    if [ "$SKIP" != "YES" ]; then
      unset DESTTAG; unset SOURCETAG
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTTAG="$( grep "^TAGLINE " $CURRENTFILE | grep -v "^USER " )"
      if [ "$DESTTAG" = "" ]; then
        proc_log "Error: Cant read TAGLINE from $USERDEST/$USER"
        proc_debug "Error: Cant read TAGLINE from $USERDEST/$USER"
        SKIP="YES"
      fi
      if [ -r $USERSOURCE/$USER ]; then
        SOURCETAG="$( grep "^TAGLINE " $USERSOURCE/$USER )"
      else
        SOURCETAG=""
        proc_highdebug "Error: Cant read TAGLINE from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCETAG" != "" -a "$DESTTAG" != "" ]; then
        proc_highdebug "$USER - TAGLINE = $DESTNAME $DESTTAG / $SOURCENAME $SOURCETAG"
        if [ "$DESTTAG" != "$SOURCETAG" ]; then
          ## Sync tagline from source
          if [ "$SKIP" != "YES" ]; then
            grep -v "^TAGLINE " $CURRENTFILE > $TMP/TEMP.$USER.TAGLINE
            echo "$SOURCETAG" >> $TMP/TEMP.$USER.TAGLINE  
            mv -f $TMP/TEMP.$USER.TAGLINE $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - TAGLINE changed from $DESTTAG to $SOURCETAG"
            proc_log "$USER - TAGLINE change from $DESTTAG to $SOURCETAG"
            sleep $SLOWTIME
          fi
        fi
      fi
    fi

    ## Sync Primary group.
    if [ "$SKIP" != "YES" ]; then
      unset SOURCEPRI; unset DESTPRI
      if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
        CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
      else
        CURRENTFILE="$USERDEST/$USER"
      fi
      DESTPRI="$( grep "^GROUP " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | head -n1 )"
      if [ -r $USERSOURCE/$USER ]; then
        SOURCEPRI="$( grep "^GROUP " $USERSOURCE/$USER |egrep -v '^USER |^TAGLINE ' | head -n1 )"
      else
        unset SOURCEPRI
        proc_highdebug "Error: Cant read primary GROUP from $USERSOURCE/$USER"
        SKIP="YES"
      fi
      if [ "$SOURCEPRI" != "" -a "$DESTPRI" != "" ]; then
        proc_highdebug "$USER - PRIGRoup = $DESTNAME $DESTPRI / $SOURCENAME $SOURCEPRI"
        if [ "$DESTPRI" != "$SOURCEPRI" ]; then
          ## Remove pri group if its elsewhere.
          if [ "$SKIP" != "YES" ]; then
            grep -vx "^$SOURCEPRI" $CURRENTFILE > $TMP/TEMP.$USER.PRIGROUP1
            sed -e "s/^$DESTPRI/$SOURCEPRI/" $TMP/TEMP.$USER.PRIGROUP1 > $TMP/TEMP.$USER.PRIGROUP
            mv -f $TMP/TEMP.$USER.PRIGROUP $TMP/TEMPSTATS.$USER.NEW
            proc_debug "$USER - Primary group changed to $SOURCEPRI"
            proc_log "$USER - Primary group changed to $SOURCEPRI"
            sleep $SLOWTIME
          fi
        fi
      else
        proc_highdebug "Warning: $USER has no primary group?"
      fi
    fi

    ## Add new groups.
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        unset group
        for group in `grep "^GROUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}'`; do
          proc_highdebug "$USER - Checking GROUP $group"
          if [ ! -r $USERDEST/$USER ]; then
            proc_debug "Error: cant read from $USERDEST/$USER."
            proc_log "Error: cant read from $USERDEST/$USER."
          else
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            CHECK="$( grep "^GROUP " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | grep -x "GROUP $group" )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "GROUP $group" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - added GROUP $group"
                proc_log "$USER - added GROUP $group"
                sleep $SLOWTIME
              fi
            fi
            unset CHECK
          fi
        done
      else
        proc_highdebug "Error: Cant read GROUP from $USERSOURCE/$USER"
        SKIP="YES"
      fi
    fi

    ## Removing redundant groups
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
       if [ ! -r $USERDEST/$USER ]; then
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          unset group
          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
            CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
          else
            CURRENTFILE="$USERDEST/$USER"
          fi
          for group in `grep "^GROUP " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | awk '{print $2}'`; do
            proc_highdebug "$USER - Checking GROUP $group -redundant groups-"
            CHECK="$( grep "^GROUP " $USERSOURCE/$USER | grep -x "GROUP $group" | awk '{print $2}' )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -xv "GROUP $group" $CURRENTFILE > $TMP/TEMP.$USER.GRPDEL
                mv -f $TMP/TEMP.$USER.GRPDEL $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - removing GROUP $group"
                proc_log "$USER - removing GROUP $group"
                sleep 1 ## leave this!
              fi
            fi
            unset CHECK
          done
        fi
      else
        proc_highdebug "Error: Cant read GROUP from $USERSOURCE/$USER -redundant groups-"
        SKIP="YES"
      fi
    fi

    ## Add new private groups.
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for privgroup in `grep "^PRIVATE " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}'`; do
            proc_highdebug "$USER - Checking PRIVATE group $privgroup"
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            CHECK="$( grep "^PRIVATE " $CURRENTFILE | grep -w $privgroup )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "PRIVATE $privgroup" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - added PRIVATE GROUP $privgroup"
                proc_log "$USER - added PRIVATE GROUP $privgroup"
                sleep $SLOWTIME
              fi
            fi
            unset CHECK
          done
          unset privgroup
        fi
      else
        proc_highdebug "Error: Cant read PRIVATE groups from $USERSOURCE/$USER"
        SKIP="YES"
      fi
    fi

    ## Removing redundant private groups
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
            CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
          else
            CURRENTFILE="$USERDEST/$USER"
          fi
          for privgroup in `grep "^PRIVATE " $CURRENTFILE | awk '{print $2}'`; do
            proc_highdebug "$USER - Checking PRIVATE group $privgroup -redundant groups-"
            CHECK="$( grep "PRIVATE " $USERSOURCE/$USER | grep -w $privgroup )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v "^PRIVATE $privgroup" $CURRENTFILE > $TMP/TEMP.$USER.GRPDEL
                mv -f $TMP/TEMP.$USER.GRPDEL $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - removed PRIVATE GROUP $privgroup"
                proc_log "$USER - removed PRIVATE GROUP $privgroup"
                sleep $SLOWTIME
              fi
            fi
            unset CHECK
          done
        fi
        unset privgroup
      else
        SKIP="YES"
        proc_highdebug "Error: Cant read PRIVATE group from $USERSOURCE/$USER -redundant groups-"
      fi
    fi

    ## Add new IP's
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          for ip in `grep "^IP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' | awk '{print $2}'`; do
            proc_highdebug "$USER - Checking add IP: $ip"
            if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
              CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
            else
              CURRENTFILE="$USERDEST/$USER"
            fi
            CHECK="$( grep "^IP " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | grep -F "IP $ip" )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                if [ ! -e $TMP/TEMPSTATS.$USER.NEW ]; then
                  cp -f $USERDEST/$USER $TMP/TEMPSTATS.$USER.NEW
                fi
                echo "IP $ip" >> $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - Adding IP $ip"
                proc_log "$USER - Adding IP $ip"
                sleep $SLOWTIME
              fi
            fi
            unset CHECK
          done
          unset ip
        fi
      else
       proc_highdebug "Error: Cant read IPs from $USERSOURCE/$USER"
       SKIP="YES"
      fi
    fi 
 
    ## Removing redundant ip's
    if [ "$SKIP" != "YES" ]; then
      if [ -r $USERSOURCE/$USER ]; then
        if [ ! -r $USERDEST/$USER ]; then
          proc_debug "Error: cant read from $USERDEST/$USER."
          proc_log "Error: cant read from $USERDEST/$USER."
          SKIP="YES"
        else
          if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
            CURRENTFILE="$TMP/TEMPSTATS.$USER.NEW"
          else
            CURRENTFILE="$USERDEST/$USER"
          fi
          for ip in `grep "^IP " $CURRENTFILE | egrep -v '^USER |^TAGLINE ' | awk '{print $2}'`; do
            proc_highdebug "$USER - Checking remove IP: $ip"
            CHECK="$( grep -w IP $USERSOURCE/$USER | grep -x -F -- "IP $ip" )"
            if [ "$CHECK" = "" ]; then
              if [ "$SKIP" != "YES" ]; then
                grep -v -x -F -- "IP $ip" $CURRENTFILE > $TMP/TEMP.$USER.IPDEL
                mv -f $TMP/TEMP.$USER.IPDEL $TMP/TEMPSTATS.$USER.NEW
                proc_debug "$USER - Removed IP $ip"
                proc_log "$USER - Removed IP $ip"
                sleep $SLOWTIME
              fi
            fi
            unset CHECK
          done
          unset ip
        fi
      else
        SKIP="YES"
        proc_highdebug "Error: Cant read IPs -remove- from $USERSOURCE/$USER"
      fi
    fi
  
    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
      ## Check newly created file ment for destination.
      CHECKPATH="$TMP"
      TMPUSER="$USER"
      USER="TEMPSTATS.$USER.NEW"
      proc_highdebug "Checking integrity of new destination file $CHECKPATH/$USER"
      proc_userver
      if [ "$VERERR" != "" ]; then
        proc_debug "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
        proc_log "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
        SKIP="YES"
        SCRIPTNAME="$( basename $0 )"
        echo "" >> $TMP/$USER
        echo "---New file that $SCRIPTNAME created above. Old one from $USERDEST/$TMPUSER below---" >> $TMP/$USER
        echo "-- This file was created on "`date` >> $TMP/$USER
        echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
        echo "-- Part of $SCRIPTNAME that got the error: Syncing user info." >> $TMP/$USER
        echo "" >> $TMP/$USER
        cat $USERDEST/$TMPUSER >> $TMP/$USER
        if [ ! -e $TMP/ERROR.$USER ]; then
          mv -f $TMP/$USER $TMP/ERROR.$USER
        else
          rm -f $TMP/$USER
        fi
        unset SCRIPTNAME
      fi
      ## Restore arguments
      USER="$TMPUSER"
      unset TMPUSER
      unset CHECKPATH
      ## Move the new userfile...
      if [ "$SKIP" != "YES" ]; then
        proc_lock_dst
        if [ "$SKIP" != "YES" ]; then
          mv -f $TMP/TEMPSTATS.$USER.NEW $USERDEST/$USER
          proc_unlock_dst
        else
          proc_log "After syncing $USER on $DESTNAME, I cant update his userfile because its locked. Skipping."
          proc_debug "After syncing $USER on $DESTNAME, I cant update his userfile because its locked. Skipping."
        fi
      fi
    fi
    sleep $SLOWTIME
  fi
  SKIP="NO"
  unset CURRENTFILE

  if [ ! -r "$USERSOURCE/$VERIFYUSER" ]; then
    sleep 5
    if [ ! -r "$USERSOURCE/$VERIFYUSER" ]; then
      proc_debug "Seems I lost link? Stopping"
      proc_log "Lost link? Quitting."
      proc_exit
    fi
  fi
}

## MOD 2003-04-08 by Turranius
## Changed so it checks with md5sum that files are good before moving.
## Procedure for moving stats.
proc_movestats() {
  ACTIVEMODE="STATS"
  cd $USERDEST
  ## Verify integrity of userfile on source, unless this is a full sync, in which 
  ## case it has already been by the sync.
  if [ "$FULL" != "YES" ]; then
    CHECKPATH="$USERSOURCE"
    proc_highdebug "Checking integrity of $USER on $SOURCENAME"
    proc_userver
    if [ "$VERERR" != "" ]; then
      proc_statlog "Error. Userfile $USER on $SOURCENAME have problems with fields: $VERERR. Skipping."
      proc_debug "Error. Userfile $USER on $SOURCENAME have problems with fields: $VERERR. Skipping."
      SKIP="YES"
    fi

    ## Verify integrity of userfile on destination..
    if [ "$SKIP" != "YES" ]; then
      CHECKPATH="$USERDEST"
      proc_highdebug "Checking integrity of $CHECKPATH/$USER"
      proc_userver
      if [ "$VERERR" != "" ]; then
        proc_statlog "Error. Userfile $USER on $DESTNAME have problems with fields: $VERERR. Skipping."
        proc_debug "Error. Userfile $USER on $DESTNAME have problems with fields: $VERERR. Skipping."
        SKIP="YES"
      fi
    fi
  fi

  if [ -e $TMP/ERROR.$USER ]; then
    proc_debug "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    proc_log "Warning. $USER had a previous error when syncing, leaving $TMP/ERROR.$USER - Skipping until resolved."
    SKIP="YES"
  fi

  if [ "$SKIP" != "YES" ]; then
    proc_debug "Moving Stats from $USER"
    if [ "$RUNLOCAL" = "TRUE" ] && [ "$USERSOURCEORG" ]; then
      ## Set USERSOURCE to the real folder since it shouldnt read stats from
      ## the copied version.
      USERSOURCESTATS="$USERSOURCE"
      USERSOURCE="$USERSOURCEORG"
    fi
  fi

  ## ALLUP
  if [ "$MOVEALLUP" = "TRUE" -a "$SKIP" != "YES" ]; then
    unset DESTALLUP1; unset DESTALLUP2; unset DESTALLUP3; unset DESTALLUP
    unset SOURCEALLUP1; unset SOURCEALLUP2; unset SOURCEALLUP3; unset SOURCEALLUP
    unset NEWALLUP1; unset NEWALLUP2; unset NEWALLUP3
    if [ -w $USERSOURCE/$USER ]; then
      DESTALLUP="$( grep "^ALLUP " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTALLUP" != "" ]; then
        DESTALLUP1="$( echo $DESTALLUP | awk '{print $2}' )"
        DESTALLUP2="$( echo $DESTALLUP | awk '{print $3}' )"
        DESTALLUP3="$( echo $DESTALLUP | awk '{print $4}' )"
        if [ "$DESTALLUP1" = "" ]; then 
        DESTALLUP1="0"
        fi
        if [ "$DESTALLUP2" = "" ]; then
          DESTALLUP2="0"
        fi
        if [ "$DESTALLUP3" = "" ]; then
          DESTALLUP3="0"
        fi
        if [ "$DESTALLUP1" != "0" -a "$DESTALLUP2" != "0" -a "$DESTALLUP3" != "0" ]; then
          SOURCEALLUP="$( grep "^ALLUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
          if [ "$SOURCEALLUP" != "" ]; then
            SOURCEALLUP1="$( echo $SOURCEALLUP | awk '{print $2}' )"
            SOURCEALLUP2="$( echo $SOURCEALLUP | awk '{print $3}' )"
            SOURCEALLUP3="$( echo $SOURCEALLUP | awk '{print $4}' )"
            if [ "$SOURCEALLUP1" = "" ]; then
              SOURCEALLUP1="0"
            fi
            if [ "$SOURCEALLUP2" = "" ]; then
              SOURCEALLUP2="0"
            fi
            if [ "$SOURCEALLUP3" = "" ]; then
              SOURCEALLUP3="0"
            fi
            NEWALLUP1="$( echo "$SOURCEALLUP1 + $DESTALLUP1" | bc -l | awk -F"." '{print $1}' )"
            NEWALLUP2="$( echo "$SOURCEALLUP2 + $DESTALLUP2" | bc -l | awk -F"." '{print $1}' )"
            NEWALLUP3="$( echo "$SOURCEALLUP3 + $DESTALLUP3" | bc -l | awk -F"." '{print $1}' )"
            if [ "$NEWALLUP1" != "" -a "$NEWALLUP2" != "" -a "$NEWALLUP3" != "" ]; then
              proc_debug "$USER ALLUP Stats NEW : $NEWALLUP1 $NEWALLUP2 $NEWALLUP3"
              proc_highdebug "$USER $DESTNAME ALLUP : $DESTALLUP1 $DESTALLUP2 $DESTALLUP3"
              proc_highdebug "$USER $SOURCENAME ALLUP : $SOURCEALLUP1 $SOURCEALLUP2 $SOURCEALLUP3"
              proc_statlog "$USER got new ALLUP stats: ($DESTNAME: $DESTALLUP1 $DESTALLUP2 $DESTALLUP3)=($SOURCENAME: $SOURCEALLUP1 $SOURCEALLUP2 $SOURCEALLUP3)=(NEW: $NEWALLUP1 $NEWALLUP2 $NEWALLUP3)"
              if [ -r $USERSOURCE/$USER ]; then
                if [ -r $USERDEST/$USER ]; then
                  if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                    sed -e "s/^ALLUP.*/ALLUP $NEWALLUP1 $NEWALLUP2 $NEWALLUP3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                    mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                  else
                    sed -e "s/^ALLUP.*/ALLUP $NEWALLUP1 $NEWALLUP2 $NEWALLUP3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                  fi
                  if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                    sed -e "s/^ALLUP.*/ALLUP 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                    mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                  else
                    sed -e "s/^ALLUP.*/ALLUP 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                  fi
                  sleep $SLOWTIME
                  NEWEXISTS="TRUE"
                else
                  proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                fi
              else
                proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
              fi
            else
              proc_highdebug "Warning: Calculating new ALLUP stats for $USER failed!"
            fi
          else
            proc_highdebug "Error: Can not read ALLUP from $USERSOURCE/$USER"
          fi
        else
          proc_highdebug "Not touching ALLUP on $USER - Some stats are empty or 0"
        fi
      else
        proc_highdebug "Error: Can not read ALLUP from $USERDEST/$USER"
      fi
    else
      proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
    fi
  fi

  ## ALLDN
  if [ "$MOVEALLDN" = "TRUE" -a "$SKIP" != "YES" ]; then
    unset DESTALLDN1; unset DESTALLDN2; unset DESTALLDN3; unset DESTALLDN
    unset SOURCEALLDN1; unset SOURCEALLDN2; unset SOURCEALLDN3; unset SOURCEALLDN
    unset NEWALLDN1; unset NEWALLDN2; unset NEWALLDN3
    if [ -w "$USERSOURCE/$USER" ]; then
      DESTALLDN="$( grep "^ALLDN " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTALLDN" != "" ]; then
        DESTALLDN1="$( echo $DESTALLDN | awk '{print $2}' )"
        DESTALLDN2="$( echo $DESTALLDN | awk '{print $3}' )"
        DESTALLDN3="$( echo $DESTALLDN | awk '{print $4}' )"
        if [ "$DESTALLDN1" = "" ]; then
          DESTALLDN1="0"
        fi
        if [ "$DESTALLDN2" = "" ]; then
          DESTALLDN2="0"
        fi
        if [ "$DESTALLDN3" = "" ]; then
          DESTALLDN3="0"
        fi
        if [ "$DESTALLDN1" != "0" -a "$DESTALLDN2" != "0" -a "$DESTALLDN3" != "0" ]; then
          SOURCEALLDN="$( grep "^ALLDN " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
          if [ "$SOURCEALLDN" != "" ]; then
            SOURCEALLDN1="$( echo $SOURCEALLDN | awk '{print $2}' )"
            SOURCEALLDN2="$( echo $SOURCEALLDN | awk '{print $3}' )"
            SOURCEALLDN3="$( echo $SOURCEALLDN | awk '{print $4}' )"
            if [ "$SOURCEALLDN1" = "" ]; then
              SOURCEALLDN1="0"
            fi
            if [ "$SOURCEALLDN2" = "" ]; then
              SOURCEALLDN2="0"
            fi
            if [ "$SOURCEALLDN3" = "" ]; then
              SOURCEALLDN3="0"
            fi
            NEWALLDN1="$( echo "$SOURCEALLDN1 + $DESTALLDN1" | bc -l | awk -F"." '{print $1}' )"
            NEWALLDN2="$( echo "$SOURCEALLDN2 + $DESTALLDN2" | bc -l | awk -F"." '{print $1}' )"
            NEWALLDN3="$( echo "$SOURCEALLDN3 + $DESTALLDN3" | bc -l | awk -F"." '{print $1}' )"
            if [ "$NEWALLDN1" != "" -a "$NEWALLDN2" != "" -a "$NEWALLDN3" != "" ]; then
              proc_debug "$USER ALLDN Stats NEW : $NEWALLDN1 $NEWALLDN2 $NEWALLDN3"
              proc_highdebug "$USER $DESTNAME ALLDN : $DESTALLDN1 $DESTALLDN2 $DESTALLDN3"
              proc_highdebug "$USER $SOURCENAME ALLDN : $SOURCEALLDN1 $SOURCEALLDN2 $SOURCEALLDN3"
              proc_statlog "$USER got new ALLDN stats: ($DESTNAME: $DESTALLDN1 $DESTALLDN2 $DESTALLDN3)+($SOURCENAME: $SOURCEALLDN1 $SOURCEALLDN2 $SOURCEALLDN3)=(NEW: $NEWALLDN1 $NEWALLDN2 $NEWALLDN3)"
              if [ -r $USERSOURCE/$USER ]; then
                if [ -r $USERDEST/$USER ]; then
                  if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                    sed -e "s/^ALLDN.*/ALLDN $NEWALLDN1 $NEWALLDN2 $NEWALLDN3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                    mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                  else
                    sed -e "s/^ALLDN.*/ALLDN $NEWALLDN1 $NEWALLDN2 $NEWALLDN3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                  fi
                  if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                    sed -e "s/^ALLDN.*/ALLDN 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                    mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                  else
                    sed -e "s/^ALLDN.*/ALLDN 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                  fi
                  sleep $SLOWTIME
                  NEWEXISTS="TRUE"
                else
                  proc_highdebug "Error: Can not read from to $USERDEST/$USER"
		fi
              else
                proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
              fi
            else
              proc_highdebug "Warning: Calculating new ALLDN stats for $USER failed!"
            fi
          else
            proc_highdebug "Error: Can not read ALLDN from $USERSOURCE/$USER"
          fi
        else
          proc_highdebug "Not touching ALLDN on $USER - Some stats are empty or 0"
        fi
      else
        proc_highdebug "Error: Can not read ALLDN from $USERDEST/$USER"
      fi
    else
      proc_highdebug  "Error: Can not write to $USERSOURCE/$USER"
    fi
  fi

  ## WKUP
  if [ "$MOVEWKUP" = "TRUE" -a "$SKIP" != "YES" ]; then
    unset DESTWKUP1; unset DESTWKUP2; unset DESTWKUP3; unset DESTWKUP
    unset SOURCEWKUP1; unset SOURCEWKUP2; unset SOURCEWKUP3; unset SOURCEWKUP
    unset NEWWKUP1; unset NEWWKUP2; unset NEWWKUP3
    if [ -w "$USERSOURCE/$USER" ]; then
      DESTWKUP="$( grep "^WKUP " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTWKUP" != "" ]; then
        DESTWKUP1="$( echo $DESTWKUP | awk '{print $2}' )"
        DESTWKUP2="$( echo $DESTWKUP | awk '{print $3}' )"
        DESTWKUP3="$( echo $DESTWKUP | awk '{print $4}' )"
        if [ "$DESTWKUP1" = "" ]; then
          DESTWKUP1="0"
        fi
        if [ "$DESTWKUP2" = "" ]; then
          DESTWKUP2="0"
        fi
        if [ "$DESTWKUP3" = "" ]; then
          DESTWKUP3="0"
        fi
        if [ "$DESTWKUP1" != "0" -a "$DESTWKUP2" != "0" -a "$DESTWKUP3" != "0" ]; then
          SOURCEWKUP="$( grep "^WKUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
          if [ "$SOURCEWKUP" != "" ]; then
            SOURCEWKUP1="$( echo $SOURCEWKUP | awk '{print $2}' )"
            SOURCEWKUP2="$( echo $SOURCEWKUP | awk '{print $3}' )"
            SOURCEWKUP3="$( echo $SOURCEWKUP | awk '{print $4}' )"
            if [ "$SOURCEWKUP1" = "" ]; then
              SOURCEWKUP1="0"
            fi
            if [ "$SOURCEWKUP2" = "" ]; then
              SOURCEWKUP2="0"
            fi
            if [ "$SOURCEWKUP3" = "" ]; then
              SOURCEWKUP3="0"
            fi
            NEWWKUP1="$( echo "$SOURCEWKUP1 + $DESTWKUP1" | bc -l | awk -F"." '{print $1}' )"
            NEWWKUP2="$( echo "$SOURCEWKUP2 + $DESTWKUP2" | bc -l | awk -F"." '{print $1}' )"
            NEWWKUP3="$( echo "$SOURCEWKUP3 + $DESTWKUP3" | bc -l | awk -F"." '{print $1}' )"
            if [ "$NEWWKUP1" != "" -a "$NEWWKUP2" != "" -a "$NEWWKUP3" != "" ]; then
              proc_debug "$USER WKUP Stats NEW : $NEWWKUP1 $NEWWKUP2 $NEWWKUP3"
              proc_highdebug "$USER $DESTNAME WKUP : $DESTWKUP1 $DESTWKUP2 $DESTWKUP3"
              proc_highdebug "$USER $SOURCENAME WKUP : $SOURCEWKUP1 $SOURCEWKUP2 $SOURCEWKUP3"
              proc_statlog "$USER got new WKUP stats: ($DESTNAME: $DESTWKUP1 $DESTWKUP2 $DESTWKUP3)+($SOURCENAME: $SOURCEWKUP1 $SOURCEWKUP2 $SOURCEWKUP3)=(NEW: $NEWWKUP1 $NEWWKUP2 $NEWWKUP3)"
              if [ -r $USERSOURCE/$USER ]; then
                if [ -r $USERDEST/$USER ]; then
                  if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                    sed -e "s/^WKUP.*/WKUP $NEWWKUP1 $NEWWKUP2 $NEWWKUP3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                    mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                  else
                    sed -e "s/^WKUP.*/WKUP $NEWWKUP1 $NEWWKUP2 $NEWWKUP3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                  fi
                  if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                    sed -e "s/^WKUP.*/WKUP 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                    mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                  else
                    sed -e "s/^WKUP.*/WKUP 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                  fi
                  sleep $SLOWTIME
                  NEWEXISTS="TRUE"
                else
                  proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                fi
              else
                proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
              fi
            else
              proc_highdebug "Warning: Calculating new WKUP stats for $USER failed!"
            fi
          else
            proc_highdebug "Error: Can not read WKUP from $USERSOURCE/$USER"
          fi
        else
          proc_highdebug "Not touching WKUP on $USER - Some stats are empty or 0"
        fi
      else
        proc_highdebug "Error: Can not read WKUP from $USERDEST/$USER"
      fi
    else
      proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
    fi
  fi


  ## WKDN
  if [ "$MOVEWKDN" = "TRUE" -a "$SKIP" != "YES" ]; then
    unset DESTWKDN1; unset DESTWKDN2; unset DESTWKDN3; unset DESTWKDN
    unset SOURCEWKDN1; unset SOURCEWKDN2; unset SOURCEWKDN3; unset SOURCEWKDN
    unset NEWWKDN1; unset NEWWKDN2; unset NEWWKDN3
    if [ -w "$USERSOURCE/$USER" ]; then
      DESTWKDN="$( grep "^WKDN " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
      if [ "$DESTWKDN" != "" ]; then
        DESTWKDN1="$( echo $DESTWKDN | awk '{print $2}' )"
        DESTWKDN2="$( echo $DESTWKDN | awk '{print $3}' )"
        DESTWKDN3="$( echo $DESTWKDN | awk '{print $4}' )"
        if [ "$DESTWKDN1" = "" ]; then
          DESTWKDN1="0"
        fi
        if [ "$DESTWKDN2" = "" ]; then
          DESTWKDN2="0"
        fi
        if [ "$DESTWKDN3" = "" ]; then
          DESTWKDN3="0"
        fi
        if [ "$DESTWKDN1" != "0" -a "$DESTWKDN2" != "0" -a "$DESTWKDN3" != "0" ]; then
          SOURCEWKDN="$( grep "^WKDN " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
          if [ "$SOURCEWKDN" != "" ]; then
            SOURCEWKDN1="$( echo $SOURCEWKDN | awk '{print $2}' )"
            SOURCEWKDN2="$( echo $SOURCEWKDN | awk '{print $3}' )"
            SOURCEWKDN3="$( echo $SOURCEWKDN | awk '{print $4}' )"
            if [ "$SOURCEWKDN1" = "" ]; then
              SOURCEWKDN1="0"
            fi
            if [ "$SOURCEWKDN2" = "" ]; then
              SOURCEWKDN2="0"
            fi
            if [ "$SOURCEWKDN3" = "" ]; then
              SOURCEWKDN3="0"
            fi
            NEWWKDN1="$( echo "$SOURCEWKDN1 + $DESTWKDN1" | bc -l | awk -F"." '{print $1}' )"
            NEWWKDN2="$( echo "$SOURCEWKDN2 + $DESTWKDN2" | bc -l | awk -F"." '{print $1}' )"
            NEWWKDN3="$( echo "$SOURCEWKDN3 + $DESTWKDN3" | bc -l | awk -F"." '{print $1}' )"
            if [ "$NEWWKDN1" != "" -a "$NEWWKDN2" != "" -a "$NEWWKDN3" != "" ]; then
              proc_debug "$USER WKDN Stats NEW : $NEWWKDN1 $NEWWKDN2 $NEWWKDN3"
              proc_highdebug "$USER $DESTNAME WKDN : $DESTWKDN1 $DESTWKDN2 $DESTWKDN3"
              proc_highdebug "$USER $SOURCENAME WKDN : $SOURCEWKDN1 $SOURCEWKDN2 $SOURCEWKDN3"
              proc_statlog "$USER got new WKDN stats: ($DESTNAME: $DESTWKDN1 $DESTWKDN2 $DESTWKDN3)+($SOURCENAME: $SOURCEWKDN1 $SOURCEWKDN2 $SOURCEWKDN3)=(NEW: $NEWWKDN1 $NEWWKDN2 $NEWWKDN3)"
              if [ -r $USERSOURCE/$USER ]; then
                if [ -r $USERDEST/$USER ]; then
                  if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                    sed -e "s/^WKDN.*/WKDN $NEWWKDN1 $NEWWKDN2 $NEWWKDN3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                    mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                  else
                    sed -e "s/^WKDN.*/WKDN $NEWWKDN1 $NEWWKDN2 $NEWWKDN3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                  fi
                  if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                    sed -e "s/^WKDN.*/WKDN 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                    mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                  else
                    sed -e "s/^WKDN.*/WKDN 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                  fi
                  sleep $SLOWTIME
                  NEWEXISTS="TRUE"
                else
                  proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                fi
              else
                proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
              fi
            else
              proc_highdebug "Warning: Calculating new WKDN stats for $USER failed!"
            fi
          else
            proc_highdebug "Error: Can not read WKDN from $USERSOURCE/$USER"
          fi
        else
          proc_highdebug "Not touching WKDN on $USER - Some stats are empty or 0"
        fi
      else
        proc_highdebug "Error: Can not read WKDN from $USERDEST/$USER"
      fi
    else
      proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
    fi
  fi

    ## DAYUP
    if [ "$MOVEDAYUP" = "TRUE" -a "$SKIP" != "YES" ]; then
      unset DESTDAYUP1; unset DESTDAYUP2; unset DESTDAYUP3; unset DESTDAYUP
      unset SOURCEDAYUP1; unset SOURCEDAYUP2; unset SOURCEDAYUP3; unset SOURCEDAYUP
      unset NEWDAYUP1; unset NEWDAYUP2; unset NEWDAYUP3
      if [ -w "$USERSOURCE/$USER" ]; then
        DESTDAYUP="$( grep "^DAYUP " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
        if [ "$DESTDAYUP" != "" ]; then
          DESTDAYUP1="$( echo $DESTDAYUP | awk '{print $2}' )"
          DESTDAYUP2="$( echo $DESTDAYUP | awk '{print $3}' )"
          DESTDAYUP3="$( echo $DESTDAYUP | awk '{print $4}' )"
          if [ "$DESTDAYUP1" = "" ]; then
            DESTDAYUP1="0"
          fi
          if [ "$DESTDAYUP2" = "" ]; then
            DESTDAYUP2="0"
          fi
          if [ "$DESTDAYUP3" = "" ]; then
            DESTDAYUP3="0"
          fi
          if [ "$DESTDAYUP1" != "0" -a "$DESTDAYUP2" != "0" -a "$DESTDAYUP3" != "0" ]; then
            SOURCEDAYUP="$( grep "^DAYUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
            if [ "$SOURCEDAYUP" != "" ]; then
              SOURCEDAYUP1="$( echo $SOURCEDAYUP | awk '{print $2}' )"
              SOURCEDAYUP2="$( echo $SOURCEDAYUP | awk '{print $3}' )"
              SOURCEDAYUP3="$( echo $SOURCEDAYUP | awk '{print $4}' )"
              if [ "$SOURCEDAYUP1" = "" ]; then
                SOURCEDAYUP1="0"
              fi
              if [ "$SOURCEDAYUP2" = "" ]; then
                SOURCEDAYUP2="0"
              fi
              if [ "$SOURCEDAYUP3" = "" ]; then
                SOURCEDAYUP3="0"
              fi
              NEWDAYUP1="$( echo "$SOURCEDAYUP1 + $DESTDAYUP1" | bc -l | awk -F"." '{print $1}' )"
              NEWDAYUP2="$( echo "$SOURCEDAYUP2 + $DESTDAYUP2" | bc -l | awk -F"." '{print $1}' )"
              NEWDAYUP3="$( echo "$SOURCEDAYUP3 + $DESTDAYUP3" | bc -l | awk -F"." '{print $1}' )"
              if [ "$NEWDAYUP1" != "" -a "$NEWDAYUP2" != "" -a "$NEWDAYUP3" != "" ]; then
                proc_debug "$USER DAYUP Stats NEW : $NEWDAYUP1 $NEWDAYUP2 $NEWDAYUP3"
                proc_highdebug "$USER $DESTNAME DAYUP : $DESTDAYUP1 $DESTDAYUP2 $DESTDAYUP3"
                proc_highdebug "$USER $SOURCENAME DAYUP : $SOURCEDAYUP1 $SOURCEDAYUP2 $SOURCEDAYUP3"
                proc_statlog "$USER got new DAYUP stats: ($DESTNAME: $DESTDAYUP1 $DESTDAYUP2 $DESTDAYUP3)+($SOURCENAME: $SOURCEDAYUP1 $SOURCEDAYUP2 $SOURCEDAYUP3)=(NEW: $NEWDAYUP1 $NEWDAYUP2 $NEWDAYUP3)"
                if [ -r $USERSOURCE/$USER ]; then
                  if [ -r $USERDEST/$USER ]; then
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^DAYUP.*/DAYUP $NEWDAYUP1 $NEWDAYUP2 $NEWDAYUP3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                    else
                      sed -e "s/^DAYUP.*/DAYUP $NEWDAYUP1 $NEWDAYUP2 $NEWDAYUP3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi
                    if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                      sed -e "s/^DAYUP.*/DAYUP 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                      mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                    else
                      sed -e "s/^DAYUP.*/DAYUP 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"
                  else
                    proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                  fi
                else
                  proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
                fi
              else
                proc_highdebug "Warning: Calculating new DAYUP stats for $USER failed!"
              fi
            else
              proc_highdebug "Error: Can not read DAYUP from $USERSOURCE/$USER"
            fi
          else
            proc_highdebug "Not touching DAYUP on $USER - Some stats are empty or 0"
          fi
        else
          proc_highdebug "Error: Can not read DAYUP from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## DAYDN
    if [ "$MOVEDAYDN" = "TRUE" -a "$SKIP" != "YES" ]; then
      unset DESTDAYDN1; unset DESTDAYDN2; unset DESTDAYDN3; unset DESTDAYDN
      unset SOURCEDAYDN1; unset SOURCEDAYDN2; unset SOURCEDAYDN3; unset SOURCEDAYDN
      unset NEWDAYDN1; unset NEWDAYDN2; unset NEWDAYDN3
      if [ -w "$USERSOURCE/$USER" ]; then
        DESTDAYDN="$( grep "^DAYDN " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
        if [ "$DESTDAYDN" != "" ]; then
          DESTDAYDN1="$( echo $DESTDAYDN | awk '{print $2}' )"
          DESTDAYDN2="$( echo $DESTDAYDN | awk '{print $3}' )"
          DESTDAYDN3="$( echo $DESTDAYDN | awk '{print $4}' )"
          if [ "$DESTDAYDN1" = "" ]; then
            DESTDAYDN1="0"
          fi
          if [ "$DESTDAYDN2" = "" ]; then
            DESTDAYDN2="0"
          fi
          if [ "$DESTDAYDN3" = "" ]; then
            DESTDAYDN3="0"
          fi
          if [ "$DESTDAYDN1" != "0" -a "$DESTDAYDN2" != "0" -a "$DESTDAYDN3" != "0" ]; then
            SOURCEDAYDN="$( grep "^DAYDN " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
            if [ "$SOURCEDAYDN" != "" ]; then
              SOURCEDAYDN1="$( echo $SOURCEDAYDN | awk '{print $2}' )"
              SOURCEDAYDN2="$( echo $SOURCEDAYDN | awk '{print $3}' )"
              SOURCEDAYDN3="$( echo $SOURCEDAYDN | awk '{print $4}' )"
              if [ "$SOURCEDAYDN1" = "" ]; then
                SOURCEDAYDN1="0"
              fi
              if [ "$SOURCEDAYDN2" = "" ]; then
                SOURCEDAYDN2="0"
              fi
              if [ "$SOURCEDAYDN3" = "" ]; then
                SOURCEDAYDN3="0"
              fi
              NEWDAYDN1="$( echo "$SOURCEDAYDN1 + $DESTDAYDN1" | bc -l | awk -F"." '{print $1}' )"
              NEWDAYDN2="$( echo "$SOURCEDAYDN2 + $DESTDAYDN2" | bc -l | awk -F"." '{print $1}' )"
              NEWDAYDN3="$( echo "$SOURCEDAYDN3 + $DESTDAYDN3" | bc -l | awk -F"." '{print $1}' )"
              if [ "$NEWDAYDN1" != "" -a "$NEWDAYDN2" != "" -a "$NEWDAYDN3" != "" ]; then
                proc_debug "$USER DAYDN Stats NEW : $NEWDAYDN1 $NEWDAYDN2 $NEWDAYDN3"
                proc_highdebug "$USER $DESTNAME DAYDN : $DESTDAYDN1 $DESTDAYDN2 $DESTDAYDN3"
                proc_highdebug "$USER $SOURCENAME DAYDN : $SOURCEDAYDN1 $SOURCEDAYDN2 $SOURCEDAYDN3"
                proc_statlog "$USER got new DAYDN stats: ($DESTNAME: $DESTDAYDN1 $DESTDAYDN2 $DESTDAYDN3)+($SOURCENAME: $SOURCEDAYDN1 $SOURCEDAYDN2 $SOURCEDAYDN3)=(NEW: $NEWDAYDN1 $NEWDAYDN2 $NEWDAYDN3)"
                if [ -r $USERSOURCE/$USER ]; then
                  if [ -r $USERDEST/$USER ]; then
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^DAYDN.*/DAYDN $NEWDAYDN1 $NEWDAYDN2 $NEWDAYDN3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                    else
                      sed -e "s/^DAYDN.*/DAYDN $NEWDAYDN1 $NEWDAYDN2 $NEWDAYDN3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi
                    if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                      sed -e "s/^DAYDN.*/DAYDN 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                      mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                    else
                      sed -e "s/^DAYDN.*/DAYDN 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"
                  else
                    proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                  fi
                else
                  proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
                fi
              else
                proc_highdebug "Warning: Calculating new DAYDN stats for $USER failed!"
              fi
            else
              proc_highdebug "Error: Can not read DAYDN from $USERSOURCE/$USER"
            fi
          else
            proc_highdebug "Not touching DAYDN on $USER - Some stats are empty or 0"
          fi
        else
          proc_highdebug "Error: Can not read DAYDN from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## MONTHUP
    if [ "$MOVEMONTHUP" = "TRUE" -a "$SKIP" != "YES" ]; then
      unset DESTMONTHUP1; unset DESTMONTHUP2; unset DESTMONTHUP3; unset DESTMONTHUP
      unset SOURCEMONTHUP1; unset SOURCEMONTHUP2; unset SOURCEMONTHUP3; unset SOURCEMONTHUP
      unset NEWMONTHUP1; unset NEWMONTHUP2; unset NEWMONTHUP3
      if [ -w "$USERSOURCE/$USER" ]; then
        DESTMONTHUP="$( grep "^MONTHUP " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
        if [ "$DESTMONTHUP" != "" ]; then
          DESTMONTHUP1="$( echo $DESTMONTHUP | awk '{print $2}' )"
          DESTMONTHUP2="$( echo $DESTMONTHUP | awk '{print $3}' )"
          DESTMONTHUP3="$( echo $DESTMONTHUP | awk '{print $4}' )"
          if [ "$DESTMONTHUP1" = "" ]; then
            DESTMONTHUP1="0"
          fi
          if [ "$DESTMONTHUP2" = "" ]; then
            DESTMONTHUP2="0"
          fi
          if [ "$DESTMONTHUP3" = "" ]; then
            DESTMONTHUP3="0"
          fi
          if [ "$DESTMONTHUP1" != "0" -a "$DESTMONTHUP2" != "0" -a "$DESTMONTHUP3" != "0" ]; then
            SOURCEMONTHUP="$( grep "^MONTHUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
            if [ "$SOURCEMONTHUP" != "" ]; then
              SOURCEMONTHUP1="$( echo $SOURCEMONTHUP | awk '{print $2}' )"
              SOURCEMONTHUP2="$( echo $SOURCEMONTHUP | awk '{print $3}' )"
              SOURCEMONTHUP3="$( echo $SOURCEMONTHUP | awk '{print $4}' )"
              if [ "$SOURCEMONTHUP1" = "" ]; then
                SOURCEMONTHUP1="0"
              fi
              if [ "$SOURCEMONTHUP2" = "" ]; then
                SOURCEMONTHUP2="0"
              fi
              if [ "$SOURCEMONTHUP3" = "" ]; then
                SOURCEMONTHUP3="0"
              fi
              NEWMONTHUP1="$( echo "$SOURCEMONTHUP1 + $DESTMONTHUP1" | bc -l | awk -F"." '{print $1}' )"
              NEWMONTHUP2="$( echo "$SOURCEMONTHUP2 + $DESTMONTHUP2" | bc -l | awk -F"." '{print $1}' )"
              NEWMONTHUP3="$( echo "$SOURCEMONTHUP3 + $DESTMONTHUP3" | bc -l | awk -F"." '{print $1}' )"
              if [ "$NEWMONTHUP1" != "" -a "$NEWMONTHUP2" != "" -a "$NEWMONTHUP3" != "" ]; then
                proc_debug "$USER MONTHUP Stats NEW : $NEWMONTHUP1 $NEWMONTHUP2 $NEWMONTHUP3"
                proc_highdebug "$USER $DESTNAME MONTHUP : $DESTMONTHUP1 $DESTMONTHUP2 $DESTMONTHUP3"
                proc_highdebug "$USER $SOURCENAME MONTHUP : $SOURCEMONTHUP1 $SOURCEMONTHUP2 $SOURCEMONTHUP3"
                proc_statlog "$USER got new MONTHUP stats: ($DESTNAME: $DESTMONTHUP1 $DESTMONTHUP2 $DESTMONTHUP3)+($SOURCENAME: $SOURCEMONTHUP1 $SOURCEMONTHUP2 $SOURCEMONTHUP3)=(NEW: $NEWMONTHUP1 $NEWMONTHUP2 $NEWMONTHUP3)"
                if [ -r $USERSOURCE/$USER ]; then
                  if [ -r $USERDEST/$USER ]; then
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^MONTHUP.*/MONTHUP $NEWMONTHUP1 $NEWMONTHUP2 $NEWMONTHUP3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                    else
                      sed -e "s/^MONTHUP.*/MONTHUP $NEWMONTHUP1 $NEWMONTHUP2 $NEWMONTHUP3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi
                    if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                      sed -e "s/^MONTHUP.*/MONTHUP 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                      mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                    else
                      sed -e "s/^MONTHUP.*/MONTHUP 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"
                  else
                    proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                  fi
                else
                  proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
                fi
              else
                proc_highdebug "Warning: Calculating new MONTHUP stats for $USER failed!"
              fi
            else
              proc_highdebug "Error: Can not read MONTHUP from $USERSOURCE/$USER"
            fi
          else
            proc_highdebug "Not touching MONTHUP on $USER - Some stats are empty or 0"
          fi
        else
          proc_highdebug "Error: Can not read MONTHUP from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## MONTHDN
    if [ "$MOVEMONTHDN" = "TRUE" -a "$SKIP" != "YES" ]; then
      unset DESTMONTHDN1; unset DESTMONTHDN2; unset DESTMONTHDN3; unset DESTMONTHDN
      unset SOURCEMONTHDN1; unset SOURCEMONTHDN2; unset SOURCEMONTHDN3; unset SOURCEMONTHDN
      unset NEWMONTHDN1; unset NEWMONTHDN2; unset NEWMONTHDN3
      if [ -w "$USERSOURCE/$USER" ]; then
        DESTMONTHDN="$( grep "^MONTHDN " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
        if [ "$DESTMONTHDN" != "" ]; then
          DESTMONTHDN1="$( echo $DESTMONTHDN | awk '{print $2}' )"
          DESTMONTHDN2="$( echo $DESTMONTHDN | awk '{print $3}' )"
          DESTMONTHDN3="$( echo $DESTMONTHDN | awk '{print $4}' )"
          if [ "$DESTMONTHDN1" = "" ]; then
            DESTMONTHDN1="0"
          fi
          if [ "$DESTMONTHDN2" = "" ]; then
            DESTMONTHDN2="0"
          fi
          if [ "$DESTMONTHDN3" = "" ]; then
            DESTMONTHDN3="0"
          fi
          if [ "$DESTMONTHDN1" != "0" -a "$DESTMONTHDN2" != "0" -a "$DESTMONTHDN3" != "0" ]; then
            SOURCEMONTHDN="$( grep "^MONTHDN " $USERSOURCE/$USER | grep -v "^TAGLINE" )"
            if [ "$SOURCEMONTHDN" != "" ]; then
              SOURCEMONTHDN1="$( echo $SOURCEMONTHDN | awk '{print $2}' )"
              SOURCEMONTHDN2="$( echo $SOURCEMONTHDN | awk '{print $3}' )"
              SOURCEMONTHDN3="$( echo $SOURCEMONTHDN | awk '{print $4}' )"
              if [ "$SOURCEMONTHDN1" = "" ]; then
                SOURCEMONTHDN1="0"
              fi
              if [ "$SOURCEMONTHDN2" = "" ]; then
                SOURCEMONTHDN2="0"
              fi
              if [ "$SOURCEMONTHDN3" = "" ]; then
                SOURCEMONTHDN3="0"
              fi
              NEWMONTHDN1="$( echo "$SOURCEMONTHDN1 + $DESTMONTHDN1" | bc -l | awk -F"." '{print $1}' )"
              NEWMONTHDN2="$( echo "$SOURCEMONTHDN2 + $DESTMONTHDN2" | bc -l | awk -F"." '{print $1}' )"
              NEWMONTHDN3="$( echo "$SOURCEMONTHDN3 + $DESTMONTHDN3" | bc -l | awk -F"." '{print $1}' )"
              if [ "$NEWMONTHDN1" != "" -a "$NEWMONTHDN2" != "" -a "$NEWMONTHDN3" != "" ]; then
                proc_debug "$USER MONTHDN Stats NEW : $NEWMONTHDN1 $NEWMONTHDN2 $NEWMONTHDN3"
                proc_highdebug "$USER $DESTNAME MONTHDN : $DESTMONTHDN1 $DESTMONTHDN2 $DESTMONTHDN3"
                proc_highdebug "$USER $SOURCENAME MONTHDN : $SOURCEMONTHDN1 $SOURCEMONTHDN2 $SOURCEMONTHDN3"
                proc_statlog "$USER got new MONTHDN stats: ($DESTNAME: $DESTMONTHDN1 $DESTMONTHDN2 $DESTMONTHDN3)+($SOURCENAME: $SOURCEMONTHDN1 $SOURCEMONTHDN2 $SOURCEMONTHDN3)=(NEW: $NEWMONTHDN1 $NEWMONTHDN2 $NEWMONTHDN3)"
                if [ -r $USERSOURCE/$USER ]; then
                  if [ -r $USERDEST/$USER ]; then
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^MONTHDN.*/MONTHDN $NEWMONTHDN1 $NEWMONTHDN2 $NEWMONTHDN3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                    else
                      sed -e "s/^MONTHDN.*/MONTHDN $NEWMONTHDN1 $NEWMONTHDN2 $NEWMONTHDN3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi
                    if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                      sed -e "s/^MONTHDN.*/MONTHDN 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                      mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                    else
                      sed -e "s/^MONTHDN.*/MONTHDN 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"
                  else
                    proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                  fi
                else
                  proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
                fi
              else
                proc_highdebug "Warning: Calculating new MONTHDN stats for $USER failed!"
              fi
            else
              proc_highdebug "Error: Can not read MONTHDN from $USERSOURCE/$USER"
            fi
          else
            proc_highdebug "Not touching MONTHDN on $USER - Some stats are empty or 0"
          fi
        else
          proc_highdebug "Error: Can not read MONTHDN from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## NUKE
    if [ "$MOVENUKE" = "TRUE" -a "$SKIP" != "YES" ]; then
      unset DESTNUKE1; unset DESTNUKE2; unset DESTNUKE3; unset DESTNUKE
      unset SOURCENUKE1; unset SOURCENUKE2; unset SOURCENUKE3; unset SOURCENUKE
      unset NEWNUKE1; unset NEWNUKE2; unset NEWNUKE3
      if [ -w "$USERSOURCE/$USER" ]; then
        DESTNUKE="$( grep "^NUKE " $USERDEST/$USER | egrep -v '^USER |^TAGLINE ' )"
        if [ "$DESTNUKE" != "" ]; then
          DESTNUKE1="$( echo $DESTNUKE | awk '{print $2}' )"
          DESTNUKE2="$( echo $DESTNUKE | awk '{print $3}' )"
          DESTNUKE3="$( echo $DESTNUKE | awk '{print $4}' )"
          if [ "$DESTNUKE1" = "" ]; then
            DESTNUKE1="0"
          fi
          if [ "$DESTNUKE2" = "" ]; then
            DESTNUKE2="0"
          fi
          if [ "$DESTNUKE3" = "" ]; then
            DESTNUKE3="0"
          fi

          if [ "$( echo $DESTNUKE3 | wc -L )" -gt "8" ]; then
            proc_log "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right. Aborting."
            proc_log "I have seen glftpd fuck up this number when nuking someone, thats why I added this check here so his stats does not go into the negative on the hub."
            proc_log "Set this users nuke stats to 0 0 0 on the slave."
            proc_debug "Warning. Nuke MB (third value on NUKE field) for user $USER on $DESTNAME is $DESTNUKE3 MB. That cant be right. Aborting."
            proc_debug "I have seen glftpd fuck up this number when nuking someone, thats why I added this check here so his stats does not go into the negative on the hub."
            proc_debug "Set this users nuke stats to 0 0 0 on the slave."
             SKIP="YES"
          fi

          if [ "$DESTNUKE1" != "0" -a "$DESTNUKE2" != "0" -a "$DESTNUKE3" != "0" -a "$SKIP" != "YES" ]; then
            SOURCENUKE="$( grep "^NUKE " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
            if [ "$SOURCENUKE" != "" ]; then
              SOURCENUKE1="$( echo $SOURCENUKE | awk '{print $2}' )"
              SOURCENUKE2="$( echo $SOURCENUKE | awk '{print $3}' )"
              SOURCENUKE3="$( echo $SOURCENUKE | awk '{print $4}' )"
              if [ "$SOURCENUKE1" = "" ]; then
                SOURCENUKE1="0"
              fi
              if [ "$SOURCENUKE2" = "" ]; then
                SOURCENUKE2="0"
              fi
              if [ "$SOURCENUKE3" = "" ]; then
                SOURCENUKE3="0"
              fi
              NEWNUKE1="$( echo "$SOURCENUKE1 + $DESTNUKE1" | bc -l | awk -F"." '{print $1}' )"
              NEWNUKE2="$( echo "$SOURCENUKE2 + $DESTNUKE2" | bc -l | awk -F"." '{print $1}' )"
              NEWNUKE3="$( echo "$SOURCENUKE3 + $DESTNUKE3" | bc -l | awk -F"." '{print $1}' )"
              if [ "$NEWNUKE1" != "" -a "$NEWNUKE2" != "" -a "$NEWNUKE3" != "" ]; then
                proc_debug "$USER NUKE Stats NEW : $NEWNUKE1 $NEWNUKE2 $NEWNUKE3"
                proc_highdebug "$USER $DESTNAME NUKE : $DESTNUKE1 $DESTNUKE2 $DESTNUKE3"
                proc_highdebug "$USER $SOURCENAME NUKE : $SOURCENUKE1 $SOURCENUKE2 $SOURCENUKE3"
                proc_statlog "$USER got new NUKE stats: ($DESTNAME: $DESTNUKE1 $DESTNUKE2 $DESTNUKE3)+($SOURCENAME: $SOURCENUKE1 $SOURCENUKE2 $SOURCENUKE3)=(NEW: $NEWNUKE1 $NEWNUKE2 $NEWNUKE3)"
                if [ -r $USERSOURCE/$USER ]; then
                  if [ -r $USERDEST/$USER ]; then
                    if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                      sed -e "s/^NUKE.*/NUKE $NEWNUKE1 $NEWNUKE2 $NEWNUKE3/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                      mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                    else
                      sed -e "s/^NUKE.*/NUKE $NEWNUKE1 $NEWNUKE2 $NEWNUKE3/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                    fi
                    if [ -e $TMP/TEMPSTATS.$USER.DEST.NEW ]; then
                      sed -e "s/^NUKE.*/NUKE 0 0 0/" $TMP/TEMPSTATS.$USER.DEST.NEW > $TMP/TEMPSTATS.$USER.DEST.1
                      mv -f $TMP/TEMPSTATS.$USER.DEST.1 $TMP/TEMPSTATS.$USER.DEST.NEW
                    else
                      sed -e "s/^NUKE.*/NUKE 0 0 0/" $USERDEST/$USER > $TMP/TEMPSTATS.$USER.DEST.NEW
                    fi
                    sleep $SLOWTIME
                    NEWEXISTS="TRUE"

                    ## NEW 2003-01-24 by turranius. 
                    ## Withdraw nuke bytes from stats on hub.
                    ## Files are not stored in NUKE field so cant subtract that.

                    ## Set up some crap for easy upgrading as void0 dosnt want to add this to all his .confs =))
                    if [ -z "$WITHDRAWNUKE" ]; then WITHDRAWNUKE="TRUE"; fi
                    if [ -z "$WITHDRAWALLUP" ]; then WITHDRAWALLUP="TRUE"; fi
                    if [ -z "$WITHDRAWMONTHUP" ]; then WITHDRAWMONTHUP="TRUE"; fi
                    if [ -z "$WITHDRAWWKUP" ]; then WITHDRAWWKUP="TRUE"; fi
                    if [ -z "$WITHDRAWDAYUP" ]; then WITHDRAWDAYUP="TRUE"; fi
  
                    ## GO with nuke withdraw
                    if [ "$WITHDRAWNUKE" = "TRUE" ] && [ "$SKIP" != "YES" ]; then
                      ## Nuke amount is in MB. Convert to KB to match stats.
                      NUKEBYTES="$( echo "$DESTNUKE3 * 1024" | bc -l | awk -F"." '{print $1}' )"
                      proc_highdebug "Got nuke. Starting to withdraw $NUKEBYTES bytes from $USER."

                      ## Withdraw nuke bytes from ALLUP
                      if [ "$WITHDRAWALLUP" = "TRUE" ]; then
                        unset SOURCEALLUP; unset SOURCEALLUPFILES; unset SOURCEALLUPBYTES; unset SOURCEALLUPTIMES; unset NEWALLUPBYTES
                        ## Does a .NEW file exist for this user? If so, read the stats for ALUP from there.
                        ## If not, read from source userfile. If we dont do this, it will read unmodified values
                        ## which might have been changed by the move we do above this one.
                        if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                          SOURCEALLUP="$( grep "^ALLUP " $TMP/TEMPSTATS.$USER.NEW | egrep -v '^USER |^TAGLINE ' )"
                        else
                          SOURCEALLUP="$( grep "^ALLUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
                        fi
                        if [ ! -z "$SOURCEALLUP" ]; then
                          SOURCEALLUPFILES="$( echo $SOURCEALLUP | awk '{print $2}' )"
                          SOURCEALLUPBYTES="$( echo $SOURCEALLUP | awk '{print $3}' )"
                          SOURCEALLUPTIMES="$( echo $SOURCEALLUP | awk '{print $4}' )"
                          if [ "$SOURCEALLUPBYTES" = "" ]; then SOURCEALLUPBYTES="0"; fi
                          if [ "$SOURCEALLUPBYTES" = "0" ]; then
                            proc_highdebug "Nuke Discount: ALLUP bytes are already at 0 on hub. Wont go below that."
                          else
                            proc_highdebug "$USER $SOURCENAME ALLUP : $SOURCEALLUPFILES $SOURCEALLUPBYTES $SOURCEALLUPTIMES"
                            NEWALLUPBYTES="$( echo "$SOURCEALLUPBYTES - $NUKEBYTES" | bc -l | awk -F"." '{print $1}' )"
                            if [ "$NEWALLUPBYTES" -lt "0" ]; then
                              proc_highdebug "Warning. New ALLUP bytes would go below 0 ($NEWALLUPBYTES). Setting it at 0."
                              NEWALLUPBYTES="0"
                            fi
                            if [ ! -z "$NEWALLUPBYTES" ] && [ ! -z "$SOURCEALLUPFILES" ] && [ ! -z "$SOURCEALLUPTIMES" ]; then
                              proc_statlog "$USER got new ALLUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEALLUPFILES $NEWALLUPBYTES $SOURCEALLUPTIMES"
                              proc_debug "$USER got new ALLUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEALLUPFILES $NEWALLUPBYTES $SOURCEALLUPTIMES"
                              if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                                sed -e "s/^ALLUP .*/ALLUP $SOURCEALLUPFILES $NEWALLUPBYTES $SOURCEALLUPTIMES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                                mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                                sleep 1 ## Leave this for safety.
                              else
                                sed -e "s/^ALLUP .*/ALLUP $SOURCEALLUPFILES $NEWALLUPBYTES $SOURCEALLUPTIMES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                              fi
                            else
                              proc_log "Error when withdrawing ALLUP stats on $SOURCENAME from nuke. Some variables empty."
                              proc_debug "Error when withdrawing ALLUP stats on $SOURCENAME from nuke. Some variables empty."
                              SKIP="YES"
                            fi
                          fi
                        else
                          proc_log "Nuke Withdraw: Error getting current ALLUP line from source userfile."
                          proc_debug "Nuke Withdraw: Error getting current ALLUP line from source userfile."
                          SKIP="YES"
                        fi
                      fi

                      ## Withdraw nuke bytes from MONTHUP
                      if [ "$WITHDRAWMONTHUP" = "TRUE" ] && [ "$SKIP" != "YES" ]; then
                        ## Does a .NEW file exist for this user? If so, read the stats for ALUP from there.
                        ## If not, read from source userfile. If we dont do this, it will read unmodified values
                        ## which might have been changed by the move we do above this one.
                        unset SOURCEMONTHUP; unset SOURCEMONTHUPFILES; unset SOURCEMONTHUPBYTES; unset SOURCEMONTHUPTIMES; unset NEWMONTHUPBYTES
                        if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                          SOURCEMONTHUP="$( grep "^MONTHUP " $TMP/TEMPSTATS.$USER.NEW | egrep -v '^USER |^TAGLINE ' )"
                        else
                          SOURCEMONTHUP="$( grep "^MONTHUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
                        fi
                        if [ ! -z "$SOURCEMONTHUP" ]; then
                          SOURCEMONTHUPFILES="$( echo $SOURCEMONTHUP | awk '{print $2}' )"
                          SOURCEMONTHUPBYTES="$( echo $SOURCEMONTHUP | awk '{print $3}' )"
                          SOURCEMONTHUPTIMES="$( echo $SOURCEMONTHUP | awk '{print $4}' )"
                          if [ "$SOURCEMONTHUPBYTES" = "" ]; then SOURCEMONTHUPBYTES="0"; fi
                          if [ "$SOURCEMONTHUPBYTES" = "0" ]; then
                            proc_highdebug "Nuke Discount: MONTHUP bytes are already at 0 on hub. Wont go below that."
                          else
                            proc_highdebug "$USER $SOURCENAME MONTHUP : $SOURCEMONTHUPFILES $SOURCEMONTHUPBYTES $SOURCEMONTHUPTIMES"
                            NEWMONTHUPBYTES="$( echo "$SOURCEMONTHUPBYTES - $NUKEBYTES" | bc -l | awk -F"." '{print $1}' )"
                            if [ "$NEWMONTHUPBYTES" -lt "0" ]; then
                              proc_highdebug "Warning. New MONTHUP bytes would go below 0 ($NEWMONTHUPBYTES). Setting it at 0."
                              NEWMONTHUPBYTES="0"
                            fi
                            if [ ! -z "$NEWMONTHUPBYTES" ] && [ ! -z "$SOURCEMONTHUPFILES" ] && [ ! -z "$SOURCEMONTHUPTIMES" ]; then
                              proc_statlog "$USER got new MONTHUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEMONTHUPFILES $NEWMONTHUPBYTES $SOURCEMONTHUPTIMES"
                              proc_debug "$USER got new MONTHUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEMONTHUPFILES $NEWMONTHUPBYTES $SOURCEMONTHUPTIMES"
                              if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                                sed -e "s/^MONTHUP .*/MONTHUP $SOURCEMONTHUPFILES $NEWMONTHUPBYTES $SOURCEMONTHUPTIMES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                                mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                                sleep 1 ## Leave this for safety.
                              else
                                sed -e "s/^MONTHUP .*/MONTHUP $SOURCEMONTHUPFILES $NEWMONTHUPBYTES $SOURCEMONTHUPTIMES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                              fi
                            else
                              proc_log "Error when withdrawing MONTHUP stats on $SOURCENAME from nuke. Some variables empty."
                              proc_debug "Error when withdrawing MONTHUP stats on $SOURCENAME from nuke. Some variables empty."
                              SKIP="YES"
                            fi
                          fi
                        else
                          proc_log "Nuke Withdraw: Error getting current MONTHUP line from source userfile."
                          proc_debug "Nuke Withdraw: Error getting current MONTHUP line from source userfile."
                          SKIP="YES"
                        fi
                      fi

                      ## Withdraw nuke bytes from WKUP
                      if [ "$WITHDRAWWKUP" = "TRUE" ] && [ "$SKIP" != "YES" ]; then
                        ## Does a .NEW file exist for this user? If so, read the stats for ALUP from there.
                        ## If not, read from source userfile. If we dont do this, it will read unmodified values
                        ## which might have been changed by the move we do above this one.
                        unset SOURCEWKUP; unset SOURCEWKUPFILES; unset SOURCEWKUPBYTES; unset SOURCEWKUPTIMES; unset NEWWKUPBYTES
                        if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                          SOURCEWKUP="$( grep "^WKUP " $TMP/TEMPSTATS.$USER.NEW | egrep -v '^USER |^TAGLINE ' )"
                        else
                          SOURCEWKUP="$( grep "^WKUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
                        fi
                        if [ ! -z "$SOURCEWKUP" ]; then
                          SOURCEWKUPFILES="$( echo $SOURCEWKUP | awk '{print $2}' )"
                          SOURCEWKUPBYTES="$( echo $SOURCEWKUP | awk '{print $3}' )"
                          SOURCEWKUPTIMES="$( echo $SOURCEWKUP | awk '{print $4}' )"
                          if [ "$SOURCEWKUPBYTES" = "" ]; then SOURCEWKUPBYTES="0"; fi
                          if [ "$SOURCEWKUPBYTES" = "0" ]; then
                            proc_highdebug "Nuke Discount: WKUP bytes are already at 0 on hub. Wont go below that."
                          else
                            proc_highdebug "$USER $SOURCENAME WKUP : $SOURCEWKUPFILES $SOURCEWKUPBYTES $SOURCEWKUPTIMES"
                            NEWWKUPBYTES="$( echo "$SOURCEWKUPBYTES - $NUKEBYTES" | bc -l | awk -F"." '{print $1}' )"
                            if [ "$NEWWKUPBYTES" -lt "0" ]; then
                              proc_highdebug "Warning. New WKUP bytes would go below 0 ($NEWWKUPBYTES). Setting it at 0."
                              NEWWKUPBYTES="0"
                            fi
                            if [ ! -z "$NEWWKUPBYTES" ] && [ ! -z "$SOURCEWKUPFILES" ] && [ ! -z "$SOURCEWKUPTIMES" ]; then
                              proc_statlog "$USER got new WKUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEWKUPFILES $NEWWKUPBYTES $SOURCEWKUPTIMES"
                              proc_debug "$USER got new WKUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEWKUPFILES $NEWWKUPBYTES $SOURCEWKUPTIMES"
                              if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                                sed -e "s/^WKUP .*/WKUP $SOURCEWKUPFILES $NEWWKUPBYTES $SOURCEWKUPTIMES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                                mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                                sleep 1 ## Leave this for safety.
                              else
                                sed -e "s/^WKUP .*/WKUP $SOURCEWKUPFILES $NEWWKUPBYTES $SOURCEWKUPTIMES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                              fi
                            else
                              proc_log "Error when withdrawing WKUP stats on $SOURCENAME from nuke. Some variables empty."
                              proc_debug "Error when withdrawing WKUP stats on $SOURCENAME from nuke. Some variables empty."
                              SKIP="YES"
                            fi
                          fi
                        else
                          proc_log "Nuke Withdraw: Error getting current WKUP line from source userfile."
                          proc_debug "Nuke Withdraw: Error getting current WKUP line from source userfile."
                          SKIP="YES"
                        fi
                      fi

                      ## Withdraw nuke bytes from DAYUP
                      if [ "$WITHDRAWDAYUP" = "TRUE" ] && [ "$SKIP" != "YES" ]; then
                        ## Does a .NEW file exist for this user? If so, read the stats for ALUP from there.
                        ## If not, read from source userfile. If we dont do this, it will read unmodified values
                        ## which might have been changed by the move we do above this one.
                        unset SOURCEDAYUP; unset SOURCEDAYUPFILES; unset SOURCEDAYUPBYTES; unset SOURCEDAYUPTIMES; unset NEWDAYUPBYTES
                        if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                          SOURCEDAYUP="$( grep "^DAYUP " $TMP/TEMPSTATS.$USER.NEW | egrep -v '^USER |^TAGLINE ' )"
                        else
                          SOURCEDAYUP="$( grep "^DAYUP " $USERSOURCE/$USER | egrep -v '^USER |^TAGLINE ' )"
                        fi
                        if [ ! -z "$SOURCEDAYUP" ]; then
                          SOURCEDAYUPFILES="$( echo $SOURCEDAYUP | awk '{print $2}' )"
                          SOURCEDAYUPBYTES="$( echo $SOURCEDAYUP | awk '{print $3}' )"
                          SOURCEDAYUPTIMES="$( echo $SOURCEDAYUP | awk '{print $4}' )"
                          if [ "$SOURCEDAYUPBYTES" = "" ]; then SOURCEDAYUPBYTES="0"; fi
                          if [ "$SOURCEDAYUPBYTES" = "0" ]; then
                            proc_highdebug "Nuke Discount: DAYUP bytes are already at 0 on hub. Wont go below that."
                          else
                            proc_highdebug "$USER $SOURCENAME DAYUP : $SOURCEDAYUPFILES $SOURCEDAYUPBYTES $SOURCEDAYUPTIMES"
                            NEWDAYUPBYTES="$( echo "$SOURCEDAYUPBYTES - $NUKEBYTES" | bc -l | awk -F"." '{print $1}' )"
                            if [ "$NEWDAYUPBYTES" -lt "0" ]; then
                              proc_highdebug "Warning. New DAYUP bytes would go below 0 ($NEWDAYUPBYTES). Setting it at 0."
                              NEWDAYUPBYTES="0"
                            fi
                            if [ ! -z "$NEWDAYUPBYTES" ] && [ ! -z "$SOURCEDAYUPFILES" ] && [ ! -z "$SOURCEDAYUPTIMES" ]; then
                              proc_statlog "$USER got new DAYUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEDAYUPFILES $NEWDAYUPBYTES $SOURCEDAYUPTIMES"
                              proc_debug "$USER got new DAYUP stats after nuke subtract of $NUKEBYTES KB: $SOURCEDAYUPFILES $NEWDAYUPBYTES $SOURCEDAYUPTIMES"
                              if [ -e $TMP/TEMPSTATS.$USER.NEW ]; then
                                sed -e "s/^DAYUP .*/DAYUP $SOURCEDAYUPFILES $NEWDAYUPBYTES $SOURCEDAYUPTIMES/" $TMP/TEMPSTATS.$USER.NEW > $TMP/TEMPSTATS.$USER.1
                                mv -f $TMP/TEMPSTATS.$USER.1 $TMP/TEMPSTATS.$USER.NEW
                                sleep 1 ## Leave this for safety.
                              else
                                sed -e "s/^DAYUP .*/DAYUP $SOURCEDAYUPFILES $NEWDAYUPBYTES $SOURCEDAYUPTIMES/" $USERSOURCE/$USER > $TMP/TEMPSTATS.$USER.NEW
                              fi
                            else
                              proc_log "Error when withdrawing DAYUP stats on $SOURCENAME from nuke. Some variables empty."
                              proc_debug "Error when withdrawing DAYUP stats on $SOURCENAME from nuke. Some variables empty."
                              SKIP="YES"
                            fi
                          fi
                        else
                          proc_log "Nuke Withdraw: Error getting current DAYUP line from source userfile."
                          proc_debug "Nuke Withdraw: Error getting current DAYUP line from source userfile."
                          SKIP="YES"
                        fi
                      fi

                    ## End of stats withdraw from NUKE with the if below.
                    fi
                   else
                    proc_highdebug "Error: Can not read from to $USERDEST/$USER"
                  fi
                else
                  proc_highdebug "Error: Can not read from to $USERSOURCE/$USER"
                fi
              else
                proc_highdebug "Warning: Calculating new NUKE stats for $USER failed!"
              fi
            else
              proc_highdebug "Error: Can not read NUKE from $USERSOURCE/$USER"
            fi
          else
            proc_highdebug "Not touching NUKE on $USER - Some stats are empty or 0"
          fi
        else
          proc_highdebug "Error: Can not read NUKE from $USERDEST/$USER"
        fi
      else
        proc_highdebug "Error: Can not write to $USERSOURCE/$USER"
      fi
    fi

    ## Verify new file integrity and copy to destinations if ok.
    if [ "$NEWEXISTS" = "TRUE" ]; then
      if [ "$USERSOURCEORG" != "" ]; then
        if [ -w "$USERSOURCEORG/$USER" ]; then
          SOURCEOK="YES"
          SOURCEPATH="$USERSOURCEORG"
        fi
      else
        if [ -w "$USERSOURCE/$USER" ]; then
          SOURCEOK="YES"
          SOURCEPATH="$USERSOURCE"
        fi
      fi
      if [ -w "$USERDEST/$USER" ]; then
        if [ "$SOURCEOK" = "YES" ]; then
          ## Check newly created file ment for source.
          CHECKPATH="$TMP"
          TMPUSER="$USER"
          USER="TEMPSTATS.$USER.NEW"
          proc_highdebug "Checking integrity of new source file $CHECKPATH/$USER"
          proc_userver
          if [ "$VERERR" != "" ]; then
            proc_debug "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
            proc_log "Error: New userfile for $SOURCENAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it. Examine the file!"
            SKIP="YES"
            SCRIPTNAME="$( basename $0 )"
            echo "" >> $TMP/$USER
            echo "---New file that $SCRIPTNAME created above. Old one from $SOURCEPATH/$TMPUSER below---" >> $TMP/$USER
            echo "-- This file was created on "`date` >> $TMP/$USER
            echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
            echo "" >> $TMP/$USER
            cat $SOURCEPATH/$TMPUSER >> $TMP/$USER
            if [ ! -e $TMP/ERROR.$USER ]; then
              mv -f $TMP/$USER $TMP/ERROR.$USER
            else
              rm -f $TMP/$USER
            fi
          fi
          ## Restore arguments
          USER="$TMPUSER"
          unset TMPUSER
          unset CHECKPATH

          ## Check newly created file ment for destination.
          CHECKPATH="$TMP"
          TMPUSER="$USER"
          USER="TEMPSTATS.$USER.DEST.NEW"
          proc_highdebug "Checking integrity of new destination file $CHECKPATH/$USER"
          proc_userver
          if [ "$VERERR" != "" ]; then
            proc_debug "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
            proc_log "Error: New userfile for $DESTNAME ($TMP/ERROR.$USER) have problems with $VERERR. Not using it."
            SKIP="YES"
            SCRIPTNAME="$( basename $0 )"
            echo "" >> $TMP/$USER
            echo "---New file that $SCRIPTNAME created above. Old one from $USERDEST/$TMPUSER below---" >> $TMP/$USER
            echo "-- This file was created on "`date` >> $TMP/$USER
            echo "-- Problem was field(s): $VERERR" >> $TMP/$USER
            echo "" >> $TMP/$USER
            cat $USERDEST/$TMPUSER >> $TMP/$USER
            if [ ! -e $TMP/ERROR.$USER ]; then
              mv -f $TMP/$USER $TMP/ERROR.$USER
            else
              rm -f $TMP/$USER
            fi
          fi
          ## Restore arguments
          USER="$TMPUSER"
          unset TMPUSER
          unset CHECKPATH

          if [ "$SKIP" != "YES" ]; then
            ## Lock both userfiles. If one fails, dont move any stats.
            proc_lock_src
            if [ "$SKIP" != "YES" ]; then
              proc_lock_dst
              if [ "$SKIP" = "YES" ]; then
                proc_unlock_src
              fi
            fi
            if [ "$USERSOURCEORG" != "" ]; then
              if [ "$SKIP" != "YES" ]; then
                proc_highdebug "Integrity ok. Moving new source file to $USERSOURCEORG/$USER"
                mv -f $TMP/TEMPSTATS.$USER.NEW $USERSOURCEORG/$USER
                proc_unlock_src
              fi
            else
              if [ "$SKIP" != "YES" ]; then
                proc_highdebug "Integrity ok. Moving new source file to $USERSOURCE/$USER"
                mv -f $TMP/TEMPSTATS.$USER.NEW $USERSOURCE/$USER
                proc_unlock_src
              fi
            fi
            if [ "$SKIP" != "YES" ]; then
              proc_highdebug "Integrity ok. Moving new dest file to $USERDEST/$USER"
              mv -f $TMP/TEMPSTATS.$USER.DEST.NEW $USERDEST/$USER
              proc_unlock_dst
            fi
           fi
        else
          proc_highdebug "Error: Can not write to $SOURCEPATH/$USER"
          proc_debug "Error: Can not write to $SOURCEPATH/$USER - No stats moved for this user."
        fi
      else
        proc_highdebug "Error: Can not write to $USERDEST/$USER"
        proc_debug "Error: Can not write to $USERDEST/$USER - No stats moved for this user."
      fi
      SOURCEOK="NO"
      NEWEXISTS="FALSE"
      unset SOURCEPATH
    fi

  SKIP="NO"
  if [ "$SLOWTIME" != "" ]; then
    sleep $SLOWTIME
  fi
  unset ACTIVEMODE

  ## Setting back USERSOURCE to point at where it was before
  ## we started moving stats.
  if [ "$USERSOURCESTATS" ]; then
    USERSOURCE="$USERSOURCESTATS"
    unset USERSOURCESTATS
  fi
}


## Copy files to local computer if its on.
proc_copylocal() {
  BFILE=""
  if [ "$RUNLOCAL" = "TRUE" ]; then
    if [ ! -e $TMP/autosync.source.users ]; then
      mkdir $TMP/autosync.source.users
      chmod $PERMS $TMP/autosync.source.users >/dev/null 2>&1
    fi
    proc_highdebug "Removing all old files in $TMP/autosync.source.users"
    rm -f $TMP/autosync.source.users/*

    proc_debug "Copying $USERSOURCE files to $TMP/autosync.source.users to run from there."
    proc_highdebug "Copying $USERSOURCE files to $TMP/autosync.source.users"
    if [ "$DEBUG" = "TRUE" ]; then
      cp -f -v $USERSOURCE/* $TMP/autosync.source.users
    else
      cp -f $USERSOURCE/* $TMP/autosync.source.users >/dev/null 2>&1
    fi
    proc_highdebug "Copy complete. Setting USERSOURCE to $TMP/autosync.source.users"
    USERSOURCEORG="$USERSOURCE"
    USERSOURCE=$TMP/autosync.source.users
  fi  
}

## Backup files.
proc_backup() {
  if [ "$BACKUPDEST" != "" ]; then
    if [ -w "$BACKUPDEST" ]; then
      if [ "$BFILE" = "" ]; then
        BFILE="$( date +%m%d%y"-"%H%M )"
      fi

      ## Backup source files.
      if [ "$RUNLOCAL" = "TRUE" ]; then
        if [ "$BACKUPDEST" != "" ]; then
          BFILE="$( date +%m%d%y"-"%H%M )"
          proc_highdebug "Backing up userfiles from $SOURCENAME to $BACKUPDEST/autosync.source.$BFILE.tar.gz"
          proc_debug "Backing up userfiles from $SOURCENAME to $BACKUPDEST/autosync.source.$BFILE.tar.gz"
          tar -zcf $BACKUPDEST/autosync.source.$BFILE".tar.gz" $TMP/autosync.source.users >/dev/null 2>&1
        fi
      fi

      ## Backup destination files.
      proc_highdebug "Backing up userfiles from $DESTNAME to $BACKUPDEST/autosync.$BFILE.tar.gz"
      proc_debug "Backing up userfiles from $DESTNAME to $BACKUPDEST/autosync.$BFILE.tar.gz"
      tar -zcf $BACKUPDEST/autosync.$BFILE".tar.gz" $USERDEST/* $PASSWDDEST/group $PASSWDDEST/passwd >/dev/null 2>&1
      amount="$( ls $BACKUPDEST | wc -l | tr -d ' ' )"
      if [ -e $BACKUPDEST/deleted ]; then
        MAXBACKUPS="$( echo "$MAXBACKUPS + 1" | bc -l | awk -F"." '{print $1}' )"
      fi
      if [ "$amount" -gt "$MAXBACKUPS" ]; then
        del="$( echo "$amount - $MAXBACKUPS" | bc -l | awk -F"." '{print $1}'  )"
        if [ "$del" -gt "0" ]; then
          ## Saving old way just incase..
          ## for old in `ls -tl $BACKUPDEST | grep -v deleted | tail -n $del | awk '{print $9}'`; do
          for old in `ls -t $BACKUPDEST | grep -v deleted | tail -n $del`; do
            if [ "$old" != "" ]; then
              rm -f $BACKUPDEST/$old
              proc_highdebug "More then $MAXBACKUPS backups. Deleting old backup: $old"
              proc_debug "Deleting old backup: $old"
            fi
          done
        fi
      fi
    fi
  fi
}

## Verify that the verifyuser can be read.
proc_verifylink() {
  proc_highdebug "Verifying that link is up by reading user $VERIFYUSER on $SOURCENAME"
  if [ ! -r $USERSOURCE/$VERIFYUSER ]; then
    echo "Verify user $VERIFYUSER on source does not exist - Link down?"
    proc_exit
  else
    verify="$( grep "^FLAGS " $USERSOURCE/$VERIFYUSER )"
    if [ "$verify" = "" ]; then
      echo "Verify user $VERIFYUSER on source exists but cant read FLAGS field - Link down?"
      proc_exit
    fi
  fi
}

## Set permissions.
proc_setperms() {
  if [ "$PERMS" != "" ]; then
    proc_highdebug "Setting $PERMS on $USERSOURCE"
    proc_debug "Settings permissions on $USERSOURCE."
    chmod $PERMS $USERSOURCE/* >/dev/null 2>&1

    if [ "$USERSOURCEORG" != "" ]; then
      proc_highdebug "Setting $PERMS on $USERSOURCEORG"
      proc_debug "Settings permissions on $USERSOURCEORG."
      chmod $PERMS $USERSOURCEORG/* >/dev/null 2>&1
    fi

    proc_highdebug "Setting $PERMS on $USERDEST"
    proc_debug "Settings permissions on $USERDEST."
    chmod $PERMS $USERDEST/* >/dev/null 2>&1

    proc_highdebug "Setting $PERMS on $TMP"
    proc_debug "Settings permissions on $TMP"
    chmod -R $PERMS $TMP >/dev/null 2>&1
  fi  
}

## Send logs from slave to hub. Only ment as an actionfile action. Not from shell.
proc_fetchlog() {
  if [ ! -z "$FETCHLOGSDIR" ]; then
    proc_verifylink
    if [ -w "$FETCHLOGSDIR" ]; then
      if [ "$LOG" != "" ]; then
        LOGNAME="$( basename $LOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $LOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
      if [ "$STATLOG" != "" -a "$STATLOG" != "$LOG" ]; then
        LOGNAME="$( basename $STATLOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $STATLOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
      if [ "$HIGHDEBUGLOG" != "" -a "$HIGHDEBUGLOG" != "$LOG" -a "$HIGHDEBUGLOG" != "$STATLOG" ]; then
        LOGNAME="$( basename $HIGHDEBUGLOG )"
        proc_log "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        proc_debug "Fetchlog: Copying $DESTNAME.$LOGNAME to $FETCHLOGSDIR/$DESTNAME.$LOGNAME"
        cp -f $HIGHDEBUGLOG $FETCHLOGSDIR/$DESTNAME.$LOGNAME
        unset LOGNAME
      fi
    else
      mkdir $FETCHLOGSDIR >/dev/null 2>&1
      chmod $PERMS $FETCHLOGSDIR >/dev/null 2>&1
      if [ ! -w $FETCHLOGSDIR/ ]; then      
        proc_log "Error: Cannot write to $FETCHLOGSDIR so no logs copied."
        proc_debug "Error: Fetchlog: Cannot write to $FETCHLOGSDIR so no logs copied."
      fi
    fi
  else
    proc_log "Error: FETCHLOGSDIR is empty in config so cant fetch logs."
    proc_debug "Error: Fetchlog: FETCHLOGSDIR is empty in config. Cant fetch logs."
  fi
}

## Check if group file is up to date.
proc_groupsync() {
  if [ -w $PASSWDDEST/group ]; then
    destsum="$( $MD5BIN $PASSWDDEST/group | awk '{print $1}' )"
    sourcesum="$( $MD5BIN $PASSWDSOURCE/group | awk '{print $1}' )"
    if [ "$destsum" != "$sourcesum" ]; then
      cp -f $PASSWDSOURCE/group $TMP/group.tmp
      newsum="$( $MD5BIN $TMP/group.tmp | awk '{print $1}' )"
      if [ "$newsum" = "$sourcesum" ]; then
        mv -f $TMP/group.tmp $PASSWDDEST/group
        proc_debug "group file synced with source"
        proc_log "group file synced with source"
      else
        proc_debug "Error: After copy, the md5sum on group does not match the original. Not syncing."
        proc_debug " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        proc_log "Error: After copy, the md5sum on group does not match the original. Not syncing."
        proc_log " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        rm -f $TMP/group.tmp
      fi
    else
      proc_debug "group file do not need syncing. md5sum: $destsum"
      proc_highdebug "group file does not need syncing. Dest:$destsum Source:$sourcesum"
    fi
    unset destsum; unset sourcesum
  else
    proc_debug "group file non existing on destination. Grabbing it"
    proc_log "group file non existing on destination. Grabbing it"
    cp -f $PASSWDSOURCE/group $PASSWDDEST/group
  fi
}

## Check if passwd is up to date
proc_passwdsync() {
  if [ -w $PASSWDDEST/passwd ]; then
    destsum="$( $MD5BIN $PASSWDDEST/passwd | awk '{print $1}' )"
    sourcesum="$( $MD5BIN $PASSWDSOURCE/passwd | awk '{print $1}' )"
    if [ "$destsum" != "$sourcesum" ]; then
      cp -f $PASSWDSOURCE/passwd $TMP/passwd.tmp
      newsum="$( $MD5BIN $TMP/passwd.tmp | awk '{print $1}' )"
      if [ "$newsum" = "$sourcesum" ]; then
        mv -f $TMP/passwd.tmp $PASSWDDEST/passwd
        proc_debug "passwd file synced with source"
        proc_log "passwd file synced with source"
      else
        proc_debug "Error: After copy, the md5sum on passwd does not match the original. Not syncing."
        proc_debug " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        proc_log "Error: After copy, the md5sum on passwd does not match the original. Not syncing."
        proc_log " $SOURCENAME: $sourcesum - $DESTNAME destsum - AfterCopy - newsum"
        rm -f $TMP/passwd.tmp
      fi
    else
      proc_debug "passwd file do not need syncing. md5sum: $destsum"
      proc_highdebug "passwd file does not need syncing. Dest:$destsum Source:$sourcesum"
    fi
    unset destsum; unset sourcesum; unset newsum
  else
    proc_debug "passwd file non existing on destination. Grabbing it"
    proc_log "passwd file non existing on destination. Grabbing it."
    cp -f $PASSWDSOURCE/passwd $PASSWDDEST/passwd
  fi
}

## Proc for verifying hub files integrity.
proc_sourceuserscheck() {
  cd $USERSOURCE
  proc_highdebug "Verifying that all users have an entry in passwd on $SOURCENAME"
  proc_debug "Verifying that all users have an entry in passwd on $SOURCENAME"
  for USER in `grep -w FLAGS * | awk '{print $1}' | awk -F":" '{print $1}' | egrep -v $EXCLUDE`; do
    unset PASSWDCHECK
    PASSWDCHECK="$( grep "^$USER:" $PASSWDSOURCE/passwd )"
    if [ -z "$PASSWDCHECK" ]; then
      proc_debug "Error: $USERSOURCE/$USER does not have an entry in the passwd on $SOURCENAME!"
      proc_log "Error: $USERSOURCE/$USER does not have an entry in the passwd on $SOURCENAME!"
      GOTERROR="YES"
    fi
  done
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All users have an entry in passwd."
    proc_log "All users have an entry in passwd on $SOURCENAME."
    proc_msslog "All users have an entry in passwd on $SOURCENAME."
  else
    unset GOTERROR
  fi
  proc_highdebug "Verifying that all users in passwd exists and are correct on $SOURCENAME"
  proc_debug "Verifying that all users in passwd exists and are correct on $SOURCENAME"
  for USER in `cat $PASSWDSOURCE/passwd | awk -F":" '{print $1}'`; do
    if [ -e "$USERSOURCE/$USER" ]; then
      CHECKPATH="$USERSOURCE"
      proc_userver
      if [ "$VERERR" != "" ]; then
        proc_debug "Error: User $USERSOURCE/$USER have a problem with the fields: $VERERR."
        proc_log "Error: User $USERSOURCE/$USER have a problem with the fields: $VERERR."
        GOTERROR="YES"
      fi
    else
      proc_debug "Error: User $USERSOURCE/$USER exists in passwd but no userfile found on $SOURCENAME."
      proc_log "Error: User $USERSOURCE $USER exists in passwd but no userfile found on $SOURCENAME."
      GOTERROR="YES"
    fi
  done
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All passwd entries match a userfile. No corrupt userfiles detected."
    proc_log "All passwd entries match a userfile on $SOURCENAME. No corrupt userfiles detected."
    proc_msslog "All passwd entries match a userfile on $SOURCENAME."
  else
    unset GOTERROR
  fi
}

## NEW 2003-02-09 by Turranius
## Clear out this slaves reportfile on the hub.
proc_delreport() {
  DELMSSLOG="TRUE"
  proc_msslog "Report cleared"
  proc_highdebug "Got command to clear report file on the hub... doing that."
  proc_debug "DELREPORT activated. Clearing out reportfile."
}

## MOD 2003-01-25 by Turranius
## CHECKPATH was set to $USERSOURCE instead of $USERDEST =)
## Proc for verifying slave files integrity.
proc_destuserscheck() {
  DELMSSLOG="FALSE" ## This is done with another proc.
  cd $USERDEST
  proc_highdebug "Verifying that all users have an entry in passwd on $DESTNAME"
  proc_debug "Verifying that all users have an entry in passwd on $DESTNAME"
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Verifying that all users have an entry in passwd on $DESTNAME"
  fi
  for USER in `grep -w FLAGS * | awk '{print $1}' | awk -F":" '{print $1}' | egrep -v $EXCLUDE`; do
    unset PASSWDCHECK
    PASSWDCHECK="$( grep "^$USER:" $PASSWDDEST/passwd )"
    if [ -z "$PASSWDCHECK" ]; then
      proc_debug "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      proc_log "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: $USERDEST/$USER does not have an entry in the passwd on $DESTNAME!"
      fi
      GOTERROR="YES"
    fi
  done
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All users have an entry in passwd."
    proc_log "All users have an entry in passwd on $DESTNAME."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All users have an entry in passwd on $DESTNAME."
    fi
  else
    unset GOTERROR
  fi
  proc_highdebug "Verifying that all users in passwd exists and are correct on $DESTNAME"
  proc_debug "Verifying that all users in passwd exists and are correct on $DESTNAME"
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Verifying that all users in passwd exists and are correct on $DESTNAME"
  fi
  for USER in `cat $PASSWDDEST/passwd | awk -F":" '{print $1}'`; do
    if [ -e "$USERDEST/$USER" ]; then
      CHECKPATH="$USERDEST"
      proc_userver
      if [ "$VERERR" != "" ]; then
        proc_debug "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        proc_log "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        if [ ! -z "$ACTIONFILE" ]; then    
          proc_msslog "Error: User $USERDEST/$USER have a problem with the fields: $VERERR."
        fi
        GOTERROR="YES"
      fi
    else
      proc_debug "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      proc_log "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      if [ ! -z "$ACTIONFILE" ]; then
        proc_msslog "Error: User $USERDEST $USER exists in passwd but no userfile found on $DESTNAME."
      fi
      GOTERROR="YES"
    fi
  done
  if [ "$GOTERROR" != "YES" ]; then
    proc_debug "All passwd entries match a userfile. No corrupt userfiles detected."
    proc_log "All passwd entries match a userfile on $DESTNAME. No corrupt userfiles detected."
    if [ ! -z "$ACTIONFILE" ]; then
      proc_msslog "All passwd entries match a userfile on $DESTNAME. No corrupt userfiles detected."
    fi
  else
    unset GOTERROR
  fi
  if [ ! -z "$ACTIONFILE" ]; then
    proc_msslog "Report complete."
    chmod $PERMS $FETCHLOGSDIR/$DESTNAME.report >/dev/null 2>&1
  fi
}

## MOD: 2003-01-20 by void0
## Added the restoreuser check if the deleted user exists in passwd.
## MOD: 2003-01-20 by Turranius
## Added cd $USERSOURCE at top.
## Delete users from destination, if they are not on source.
proc_deluser() {
  cd $USERSOURCE

  if [ "$USERSOURCEORG2" != "" ]; then
    USERSOURCE="$USERSOURCEORG2"
    proc_debug "Switching to $USERSOURCEORG2 to continue checking."
    proc_highdebug "Switching to $USERSOURCEORG2 to continue checking."
    USERSOURCEORG2=""
  fi

  unset EXISTS
  if [ -e $USERSOURCE/$USER ]; then
    EXISTS="YES"
    proc_highdebug "Delete user?: $USER = NO."
  else
    EXISTS="NO"
    if [ "$USERSOURCEORG" != "" ]; then
      proc_highdebug "Delete user?: $USER = YES. Cant see it on $SOURCENAME. Checking more."
      proc_highdebug "Switching back to $USERSOURCEORG to run more checks."
      USERSOURCEORG2="$USERSOURCE"
      USERSOURCE="$USERSOURCEORG"
    else
      proc_highdebug "Delete user?: $USER = YES. Cant see it on $SOURCENAME. Running more checks."
    fi
  fi
  if [ "$EXISTS" = "NO" ]; then
    sleep 1
    if [ -r "$USERSOURCE/$VERIFYUSER" ]; then
      proc_highdebug "Delete user: $VERIFYUSER can be read. Link must be up."
      if [ ! -e "$USERSOURCE/$USER" ]; then
        proc_highdebug "Delete user: $USER cant be read on $SOURCENAME - Verifying with passwd."
        PASSWDCHECK=""
        if [ -r "$PASSWDSOURCE/passwd" ]; then
          PASSWDCHECK="$( grep "^$USER:" $PASSWDSOURCE/passwd )"
          if [ "$PASSWDCHECK" = "" ]; then
            proc_highdebug "Delete user: $USER not found in $PASSWDSOURCE/passwd either."
            if [ "$BACKUPDEST" != "" ]; then
              if [ ! -e "$BACKUPDEST/deleted" ]; then
                proc_highdebug "Warning: Cant find $BACKUPDEST/deleted. Creating it."
                mkdir $BACKUPDEST/deleted
              fi
              mv -f $USERDEST/$USER $BACKUPDEST/deleted
              proc_highdebug "$USER - Moved to $BACKUPDEST/deleted/$SUER"
            else
              proc_highdebug "$USER - No backuppath defined. Deleting userfile."
              rm -f $USERDEST/$USER
            fi
            proc_debug "$USER - Deleted. Not on source anymore"
            proc_log "$USER - Deleted"
            SKIPPING="$USER"
          else
            ## CHG: 2003-01-20 void0
            ## Added the restoreuser check if the deleted user exists in passwd.
            proc_highdebug "Delete user: $USER FOUND in $PASSWDSOURCE/passwd - No delete on $DESTNAME!"
            proc_restoreuser $USER
            if [ ! -z "$BACKUPFILE" ]; then
              proc_highdebug "Restoring $USER from $BACKUPFILE"
              proc_debug "Restoring $USER from $BACKUPFILE"
              TMPDIR="$TMP/unpack"
              mkdir "$TMPDIR"
              tar zxf "$BACKUPFILE" -C "$TMPDIR"
              cp -f "$TMPDIR/$TMP/autosync.source.users/$USER" "$USERSOURCE/$USER"
              ## Not safe to do -rf ? We do add /unpack so it should be. - ## Should be ok.
              rm -rf "$TMPDIR"
              if [ -e "$USERSOURCE/$USER" ]; then
                proc_log "Success! $USER restored from backup on $SOURCENAME"
                proc_debug "Success! $USER restored from backup on $SOURCENAME"
              else
                proc_log "Error! $USER was restored, but he still is not found on $SOURCENAME"
                proc_debug "Error! $USER was restored, but he still is not found on $SOURCENAME"
                SKIP="YES"
              fi
            else
              proc_highdebug "Delete user: Note - Above might mean the passwd and userfiles are not in sync at source site"
            fi
          fi
        else
          proc_highdebug "Link lost? Cant read $PASSWDSOURCE/passwd anymore."
        fi
      else
        proc_highdebug "Delete user: $USER found now. No delete!"
      fi
    else
      proc_debug "Seems I lost contact. Not deleting $USER"
      proc_log "Lost link I think. Not deleting $USER"
    fi
  fi
}

## Stat log proc
proc_statlogsetup() {
  if [ "$STATSLOG" != "" ]; then
    if [ ! -w "$STATLOG" ]; then
      touch $STATLOG
      chmod 777 $STATLOG >/dev/null 2>&1
    fi
  fi
}

## Quitting procedure.
## MOD: 2003-01-20 by void0
## MOD: 2003-01-22 by Turranius
## cat and rm instead of mv -f
## Quitting procedure.
proc_exit() {
  ## CHG: 2003-01-20 void0
  ## Changed all $PASSWDDEST/$DESTNAME.actions* to $PASSWDSOURCE/$DESTNAME.actions*
  ## Changed back so it moves the actionfile to the slave anyway :)
  if [ -e "$PASSWDSOURCE/$DESTNAME.actions.locked" ]; then
    cat $PASSWDSOURCE/$DESTNAME.actions.locked >> $PASSWDDEST/$DESTNAME.actions.notdone
    rm -f $PASSWDSOURCE/$DESTNAME.actions.locked
    proc_log "Quitting before finished with actionfile. Saving it to $PASSWDDEST/$DESTNAME.actions.notdone."
    proc_debug "Quitting before finished with actionfile. Saving it to $PASSWDDEST/$DESTNAME.actions.notdone."
  fi
  proc_highdebug "Done! Clearing $LOCKFILE and quitting."
  rm -f $LOCKFILE
  exit 0
}

## Show help.
proc_help() {
  echo "Welcome to MSS $VER - Help"
  echo "Commands are:"
  echo "full (debug)      - Do the full sync (everything)."
  echo "fullsync (debug)  - Do the full sync of users & group/passwd file."
  echo "fullstats (debug) - Do the full stat move back to the hub."
  echo ""
  echo "singlefull <user> (debug) - singlesync and singlestat combined."
  echo "singlesync <user> (debug) - Sync a single user."
  echo "singlestat <user> (debug) - Move stats from a single user."
  echo ""
  echo "syncfiles debug           - Sync group/passwd file only."
  echo "setperms debug            - Fix permissions only."
  echo "backup debug              - Set COPYLOCAL to TRUE and run backup."
  echo "delete debug              - Check for deleted users on the HUB."
  echo "singledel <user> debug    - Check a single user for delete."
  echo ""
  echo "actionfile debug          - Process the action file from the hub."
  echo "integrity debug           - Check that all userfiles are in shape."
  echo ""
  echo "movecreds                 - Will move creds from this slave back to"
  echo "                            the hub. Run it for options."
  echo "-----------------------------------------------------------------"
  echo "Note that full, fullsys and fullstats will do syncfiles, setperms"
  echo "and backup as well, as long as SETPERMS and BACKUP are not empty"
  echo "in the config file. full & fullsync will also do 'delete' at the"
  echo "end. Note2: Without debug, it will not say anything to screen, "
  echo "except any critical errors."
  proc_exit
}

#### Start commands

## Sync group/passwd file only
proc_syncfiles() {
  ## Sync group file
  proc_groupsync

  ## Sync passwd file.
  proc_passwdsync
}

## MOD 2003-01-21 by Turranius
## If user isnt found on hub it dosnt quit. It checks if hes on the slave.
## If he is, it will run the proc_singledel so it can restore him if found in backups.
## Sync a single user.
proc_singlesync() {
  if [ "$USER" = "" ]; then 
    proc_debug "Enter a single username to sync too."
  else
    proc_verifylink
    if [ -e "$USERSOURCE/$USER" ]; then
      proc_syncuser
    else
      if [ -e "$USERDEST/$USER" ]; then
        proc_singledel
      else
        proc_debug "Can not find $USER in $USERSOURCE. Misspelled?"
        proc_debug "If $USER is deleted on the hub and you want to sync that, run mss.sh delete instead."
        proc_log "Syncuser Error: $USER in $USERSOURCE not found."
      fi
    fi
  fi
}

## MOD: 2003-01-26 by Turranius
## Moved checking of actionfile into proc_actionfilecheck
## Do the full sync
proc_fullsync() {
  ## Verify link.
  proc_verifylink

  ## Make a local copy if on
  proc_copylocal

  ## Backing up users 
  proc_backup
  ## Verify link again..
  proc_verifylink
  ## Set any perms required.
  proc_setperms

  ## Sync group file
  proc_groupsync

  ## Sync passwd file.
  proc_passwdsync

  ## Syncronise users.
  cd $USERDEST
  if [ "$FULL" = "YES" ]; then
    proc_statlogsetup
  fi
  for USER in `grep "^FLAGS " $USERSOURCE/* | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do
    USER="$( basename $USER )"
    proc_actionfilecheck

    if [ "$SKIPPING" != "$USER" ]; then
      proc_syncuser
      if [ "$FULL" = "YES" ]; then
        proc_movestats
      fi
    fi
  done
  for USER in `grep "^FLAGS " $USERDEST/* | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do
    USER="$( basename $USER )"
    proc_singledel
  done
}

## Check for deleted users, start.
proc_delusers() {
  ## Delete any leftover users.
  proc_verifylink
  proc_highdebug "Entering 'delete users' phase."
  proc_debug "Checking for deleted users."

  cd $USERDEST
  for USER in `grep -w FLAGS * | awk '{print $1}' | awk -F":" '{print $1}' | egrep -v $EXCLUDE`; do
    proc_singledel
  done
}


## MOD 2003-01-21 by Turranius
## Added full path to: if [ ! -r "$USER" ]; then
## Deleting single user.
proc_singledel() {
  if [ "$USER1" != "" ]; then
    USER="$USER1"
    unset USER1
  fi
  if [ "$USER" = "" ]; then
    echo "Purge: I need a username to check for delete on a single user..."
  else
    if [ ! -r "$USERDEST/$USER" ]; then
      proc_debug "Singledel: Can not find $USER in $USERDEST. Already deleted?"
      proc_log "Singledel: Can not find $USER in $USERDEST. Already deleted?"
    else
      ## Check if we should delete user.
      proc_deluser
    fi
  fi
}

## NEW: 2003-01-20 by void0
## Restore a user from the backup archives
## MOD: 2003-01-20 by Turranius - Changed putlog to proc_log
proc_restoreuser() {
  CURUSER="$1"
  if [ -z "$CURUSER" ]; then
    proc_log "Function 'proc_restoreuser' was called without the <username> argument."
    proc_debug "Function 'proc_restoreuser' was called without the <username> argument."
  fi

  proc_log "Warning: $USER exists in passwd on $SOURCENAME, but no userfile exists there."
  proc_log "Searching for user '$CURUSER' in backup-archives ..."
  proc_debug "Warning: $USER exists in passwd on $SOURCENAME, but no userfile exists there."
  proc_debug "Searching for user '$CURUSER' in backup-archives ..."
  unset BACKUPFILE
  for CURFILE in `ls -1t $BACKUPDEST/autosync.source.*.tar.gz`; do
    if [ -f "$CURFILE" ] && [ ! -z "$( tar ztf "$CURFILE" | grep "/$CURUSER" )" ]; then
      proc_log "Found user '$1' in archive '$CURFILE'."
      proc_debug "Found user '$1' in archive '$CURFILE'."
      BACKUPFILE="$CURFILE"
      return 1
    fi
  done
  proc_log "User '$1' not found in backupfiles."
  proc_debug "User '$1' not found in backupfiles."
  unset BACKUPFILE
  HARDSKIP="$USER"
  return 0
}

## NEW: 2003-01-20 by Turranius
## Do a full sync on single user.
proc_singlefull() {
  proc_singlesync
  if [ "$HARDSKIP" != "$USER" ]; then
    proc_singlestat
  else
    unset HARDSKIP
  fi
}

proc_singlestat() {
  if [ "$USER" = "" ]; then
    proc_debug "Enter a single username to sync too."
    proc_exit
  fi
  if [ ! -r "$USERSOURCE/$USER" ]; then
    proc_debug "Can not read $USER in $USERSOURCE. Misspelled?"
    proc_log "Syncuser Error: $USER in $USERSOURCE cant be read."
    SKIP="YES"
  fi

  ## Sync user..
  if [ "$SKIP" != "YES" ]; then
    proc_movestats
  fi
}

## MOD: 2003-01-26 by Turranius
## Moved checking of actionfile into proc_actionfilecheck
## Move stats from all users.
proc_fullstats() {
  ## Verify link.
  proc_verifylink

  proc_actionfilecheck

  ## Make a local copy if on
  proc_copylocal

  ## Backing up users 
  proc_backup
  ## Verify link again..
  proc_verifylink
  ## Set any perms requeired.
  proc_setperms

  ## Set permissions on statlog.
  SKIP="NO"
  proc_statlogsetup

  ## Log and lets go!
  proc_highdebug "Starting to move stats. Output will be to $STATLOG"
  cd $USERSOURCE
  for USER in `grep "^FLAGS " * | cut -d' ' -f1 | cut -d':' -f1 | egrep -v $EXCLUDE`; do
    proc_actionfilecheck
    proc_singlestat
  done
}

## NEW: 2003-01-26 by Turranius
## Check if there is an actionfile and run if so. Ment for stat/sync
proc_actionfilecheck() {
    if [ -e "$PASSWDSOURCE/$DESTNAME.actions" ] && [ -z "$ACTIONFILE" ]; then
      OLDUSER="$USER"
      if [ "$USERSOURCEORG" ]; then
        USERSOURCEORG3=$USERSOURCE
        USERSOURCE="$USERSOURCEORG"
      fi
      proc_debug "Action file $PASSWDSOURCE/$DESTNAME.actions found. Processing it first."
      proc_log "Action file $PASSWDSOURCE/$DESTNAME.actions found. Processing it before doing a full sync."
      proc_actionfileread
      if [ -e "$USERDEST/$USER" ]; then
        if [ "$RUNLOCAL" = "TRUE" ]; then
          proc_highdebug "RUNLOCAL is TRUE. Making a new copy of this userfile."
          proc_debug "RUNLOCAL is TRUE. Making a new copy of this userfile."
          if [ "$DEBUG" = "TRUE" ]; then
            cp -f -v $USERSOURCE/$USER $TMP/autosync.source.users
          else
            cp -f $USERSOURCE/$USER $TMP/autosync.source.users >/dev/null 2>&1
          fi
        fi
      fi
      USER="$OLDUSER"; unset OLDUSER
      USERSOURCE=$USERSOURCEORG3
      unset USERSOURCEORG3
    fi
}

## NEW: 2003-01-16 by void0
## MOD: 2003-01-18 by Turranius
## MOD: 2003-01-20 by Turranius
## Removed USER1 and NEWUSER1 variables. No purpose. Also change them in the general case at the end of script.
## Also, added check for 'if [ "$USER" != "$NEWUSER" ]; then' since anyone can run this from hub.
## Should be pretty secure anyway, right? Cant do crap unless they are actually renamed on hub, but will
## generate errors in log here.
## Rename a user
proc_renuser() {
  proc_verifylink
  if [ "$USER" != "" -a "$NEWUSER" != "" ]; then
    ## NEW: 2003-01-20 by turranius
    if [ "$USER" != "$NEWUSER" ]; then
      if [ ! -e $USERDEST/$NEWUSER ]; then
        if [ -e $USERDEST/$USER ]; then
          if [ -e $USERSOURCE/$NEWUSER ]; then
             mv -f $USERDEST/$USER $USERDEST/$NEWUSER
             proc_debug "Renamed user $USER to $NEWUSER"
             proc_log "Renaming $USER to $NEWUSER"
           else
             proc_debug "Should rename $USER to $NEWUSER, but I fail to see $NEWUSER on $SOURCENAME. Not renaming."
             proc_log "Should rename $USER to $NEWUSER, but I fail to see $NEWUSER on $SOURCENAME. Not renaming."
          fi
        else
          if [ "$BACKUPDEST" != "" -a -e "$BACKUPDEST/deleted/$USER" ]; then
            proc_debug "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. I did found $USER deleted though. Readding that as $NEWUSER."
            proc_log "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. I did found $USER deleted though. Readding that as $NEWUSER."
            mv -f $BACKUPDEST/deleted/$USER $USERDEST/$NEWUSER
            mv -f $USERDEST/$USER $BACKUPDEST/deleted/$USER.oldname
          else
            proc_debug "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. Not renaming."
            proc_log "Should rename $USER to $NEWUSER, but I fail to find $USER on $DESTNAME. Not renaming."
          fi
        fi
      else
        proc_debug "Should rename $USER to $NEWUSER, but $NEWUSER already exists on $DESTNAME."
        proc_log "Should rename $USER to $NEWUSER, but $NEWUSER already exists on $DESTNAME."
      fi
    else
      ## NEW: 2003-01-20 by turranius
      proc_debug "Rename error: USER: $USER. NEWUSER: $NEWUSER. They are the same."
      proc_log "Rename error: USER: $USER. NEWUSER: $NEWUSER. They are the same."
    fi
  else
    proc_debug "Error: Value USER is ($USER) and NEWUSER is ($NEWUSER). They cant be empty."
    proc_log "Error, rename: Value USER is ($USER) and NEWUSER is ($NEWUSER). They cant be empty."
  fi
}

## Read the actionfile.
proc_actionfile() {
  proc_verifylink
  proc_actionfileread
}

## NEW: 2003-01-16 by void0
## MOD: 2003-01-20 by Turranius
## MOD: 2003-01-20 by void0
## MOD: 2003-01-22 by Turranius
## Added TRIM as a valid action.
## Added 'FULL="YES"' below 'if [ "$LIST_FULL" == "*" ]; then'
##  If not, the script wouldnt do a full sync when calling proc_fullsync().
## MOD: 2003-02-01 by Turranius
## Changed text in "Found and old actionfile" and moved it from proc_log to proc_highdebug.
## MOD: 2003-02-07 by Turranius
## 
## Parse action-file
proc_actionfileread() {
  ACTIONFILE="$PASSWDSOURCE/$DESTNAME.actions"
  NOTDONEFILE="$PASSWDDEST/$DESTNAME.actions.notdone"

  ## CHG: 2003-01-20 void0
  ## Changed all $PASSWDSOURCE/$DESTNAME.actions* and $PASSWDDEST/$DESTNAME.actions* to $ACTIONFILE
  ## Verify action-file
  if [ ! -r "$ACTIONFILE" ] && [ ! -r "$NOTDONEFILE" ]; then
    proc_highdebug "Can not read action-file '$ACTIONFILE'."
    proc_debug "Action Error: File '$ACTIONFILE' not found. Perhaps none created?"
  else
    ## Are we already processing another actions file?
    if [ -e "$ACTIONFILE.locked" ]; then
      proc_debug "Already processing an actions-file."
      proc_log "Already processing an actions-file."
    else
      ## Rename the action-file so it does not get overwritten or something.
      ## If a .notdone file exists, run that one.
      if [ -e "$NOTDONEFILE" ]; then
        proc_highdebug "Found a local action file: $NOTDONEFILE. Doing that one first."
        proc_debug "Found a local action file: $NOTDONEFILE. Doing that one first."
        mv -f "$NOTDONEFILE" "$ACTIONFILE.locked"

	## ADD: 2003-01-20 void0
	## Append the .actions file to the .notdone so that we can process it all at once.
        ## ADD: 2003-01-20 Turran
        ## If -e needed incase there is a .notdone file but no new actionfile.
        if [ -e "$ACTIONFILE" ]; then
          cat "$ACTIONFILE" >> "$ACTIONFILE.locked"
          rm -f "$ACTIONFILE"
          proc_highdebug "Appending current actionfile to the .locked file so it gets processed too now."
        fi
      else
        mv -f "$ACTIONFILE" "$ACTIONFILE.locked"

        ## Save the actionfile as .notdone on the slave
	cp -f "$ACTIONFILE.locked" "$NOTDONEFILE"
      fi

      ACTIONFILE="$ACTIONFILE.locked"
      cp -f "$ACTIONFILE" "$NOTDONEFILE"

      ## CHG: 2003-02-09 Turranius
      ## CHG: 2003-01-20 void0
      ## First parse the actionfile to get all actions and the process them. (Old rename loop and process loop removed/modified)
      ## Action commands:
      ##   SYNC BASIC [*] <user> [<user> ...]
      ##   SYNC STATS [*] <user> [<user> ...]
      ##   SYNC FULL [*] <user> [<user> ...]
      ##   SYNC PASSWD
      ##   SYNC GROUP
      ##   RENUSER <user> <newuser>
      ##   PURGE <user>
      ##   FETCHLOG
      ##   TRIM <size>
      ##   DELREPORTS
      ##   UPDATE <scriptname> (destinationdir)
           
      ## Parse action-file for the rest.
      ACT_PASSWD=0
      ACT_GROUP=0
      ACT_FETCHLOG=0
      ACT_INTEGRITY=0
      ACT_TRIM=0
      ACT_UPDATE=0
      ACT_DELREPORT=0
      ACT_BACKUP=0
      LIST_BASIC=" "
      LIST_STATS=" "
      LIST_FULL=" "

      while read; do
        HEAD_COUNT=$[HEAD_COUNT + 1]
        TAIL_COUNT=$[TAIL_COUNT + 1]
        ACTION="$( echo "$REPLY" | cut -d' ' -f1 )"
        case "$ACTION" in
          SYNC)
            TYPE="$( echo "$REPLY" | cut -d' ' -f2 )"
            ARGS="$( echo "$REPLY" | cut -d' ' -f3- )"
            case "$TYPE" in
              BASIC)
                if [ "$ARGS" == "*" ]; then
                  LIST_BASIC="*"
                else
                  if [ "$LIST_BASIC" != "*" ] && [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        if [ -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                          if [ -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                            LIST_BASIC="$LIST_BASIC$CURUSER "
                          fi
                        else
                          LIST_FULL="$LIST_FULL$CURUSER "
                          LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $CURUSER / /g" )"
                        fi
                      fi
                    done
                  fi
                fi
              ;;
              STATS)
                if [ "$ARGS" == "*" ]; then
                  LIST_STATS="*"
                else
                  if [ "$LIST_STATS" != "*" ] && [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        if [ -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                          if [ -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                            LIST_STATS="$LIST_STATS$CURUSER "
                          else
                             LIST_FULL="$LIST_FULL$CURUSER "
                             LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $CURUSER / /g" )"
                          fi
                        fi
                      fi
                    done
                  fi
                fi
              ;;
              FULL)
                ## FULL is just here for laziness and looks really, since it would
                ## be the same to just use "SYNC BASIC *" and "SYNC STATS *"
                if [ "$ARGS" == "*" ]; then
                  LIST_FULL="*"
                  LIST_BASIC="*"
                  LIST_STATS="*"
                else
                  if [ "$LIST_FULL" != "*" ]; then
                    for CURUSER in $ARGS; do
                      if [ -z "$( echo "$LIST_FULL" | grep " $CURUSER " )" ]; then
                        LIST_FULL="$LIST_FULL$CURUSER "
                      fi
                      if [ ! -z "$( echo "$LIST_BASIC" | grep " $CURUSER " )" ]; then
                        LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $CURUSER / /g" )"
                      fi
                      if [ ! -z "$( echo "$LIST_STATS" | grep " $CURUSER " )" ]; then
                        LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $CURUSER / /g" )"
                      fi
                    done
                  fi
                fi
              ;;
              PASSWD)
                ACT_PASSWD=1
              ;;
              GROUP)
                ACT_GROUP=1
              ;;
              *)
                proc_log "Actionfile warning. Action $ACTION, type $TYPE not recognized."
              ;;
            esac
          ;;
            ## End of case TYPE.
          RENUSER)
            USER="$( echo "$REPLY" | cut -d' ' -f2 )"
            NEWUSER="$( echo "$REPLY" | cut -d' ' -f3 )"
            LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $USER / $NEWUSER /g" )"
            LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $USER / $NEWUSER /g" )"
            LIST_FULL="$( echo "$LIST_FULL" | sed "s/ $USER / $NEWUSER /g" )"
            proc_renuser
          ;;
          PURGE)
            USER="$( echo "$REPLY" | cut -d' ' -f2 )"
            LIST_BASIC="$( echo "$LIST_BASIC" | sed "s/ $USER / /g" )"
            LIST_STATS="$( echo "$LIST_STATS" | sed "s/ $USER / /g" )"
            LIST_FULL="$( echo "$LIST_FULL" | sed "s/ $USER / /g" )"
            proc_singledel
          ;;
          FETCHLOG)
             ACT_FETCHLOG=1
          ;;
          INTEGRITY)
            ACT_INTEGRITY=1
          ;;
          DELREPORTS)
            ACT_DELREPORT=1
          ;;
          BACKUP)
            ACT_BACKUP=1
          ;;
          TRIM)
            SIZE="$( echo "$REPLY" | cut -d' ' -f2 )"
            if [ "$SIZE" ]; then
              ACT_TRIM=1
            fi
          ;;
          UPDATE)
            UPDSCRIPT="$( echo "$REPLY" | cut -d' ' -f2 )"
            TOPATH="$( echo "$REPLY" | cut -d' ' -f3 )"
            UPDSCRIPTS="$UPDSCRIPT:$TOPATH $UPDSCRIPTS"
            if [ "$UPDSCRIPTS" ]; then
              ACT_UPDATE=1
            fi
          ;;
          *)
            proc_log "Actionfile Warning. Action $ACTION not recognized."
          ;;
        esac
      done < "$ACTIONFILE"

      ## Process remaining actions
      if [ $ACT_PASSWD -eq 1 ]; then
        proc_passwdsync
      fi
      if [ $ACT_GROUP -eq 1 ]; then
        proc_groupsync
      fi
      if [ $ACT_DELREPORT -eq 1 ]; then
        proc_delreport
      fi
      if [ $ACT_INTEGRITY -eq 1 ]; then
        proc_destuserscheck
      fi
      if [ $ACT_BACKUP -eq 1 ]; then
        COPYLOCAL="TRUE"
        proc_copylocal
        proc_backup
      fi

      ## Remove leading, ending and multiple spaces
      LIST_BASIC="$( echo "$LIST_BASIC" | tr -s ' ' )"
      LIST_STATS="$( echo "$LIST_STATS" | tr -s ' ' )"
      LIST_FULL="$( echo "$LIST_FULL" | tr -s ' ' )"
      if [ "$LIST_BASIC" == "*" ] && [ "$LIST_STATS" == "*" ]; then
	  LIST_FULL="*"
      fi
      if [ "$LIST_FULL" == "*" ]; then
          FULL="YES"
	  proc_fullsync
      else
        ## Process basic sync's
        if [ "$LIST_BASIC" == "*" ]; then
          proc_fullsync
        elif [ "$LIST_BASIC" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_BASIC"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlesync
          done
        fi
  
        ## Process stats sync's
        if [ "$LIST_STATS" == "*" ]; then
          proc_fullstats
        elif [ "$LIST_STATS" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_STATS"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlestat
          done
        fi
       
        ## Process full user sync's
        if [ "$LIST_FULL" != " " ]; then
          ## UPD 2003-01-20 by Turranius
          ## Need `echo "$LIST_BASIC"` for it to split them up. Added tr -d line too.
          for USER in `echo "$LIST_FULL"`; do
            USER="$( echo $USER | tr -d ' ' )"
            proc_singlefull
          done
        fi
      fi

      if [ $ACT_TRIM -eq 1 ]; then
        proc_trimlogs
      fi

      if [ $ACT_UPDATE -eq 1 ]; then
        proc_updatescripts
      fi

      ## FETCHLOG runs here so that we will get all this newly logged stuff aswell
      if [ $ACT_FETCHLOG -eq 1 ]; then
        proc_fetchlog
      fi

      ## Remove action-file
      rm -f "$ACTIONFILE"
      rm -f "$NOTDONEFILE"
      unset ACTIONFILE
    fi
  fi
}

## Check passwd/userfiles integrity.
proc_userpasswdintegrity() {
  proc_verifylink
  proc_sourceuserscheck
  proc_destuserscheck
}

## This will move ALL credits from the slave back to the hub.
proc_movecreds() {

  COMMAND="$( echo $COMMAND | cut -d" " -f2- )"

  if [ "$COMMAND" = "" -o "$COMMAND" = "movecreds" ]; then
    echo "Specify user or users (with a space in between) to move creds for."
    echo "Specify ALL for all users."
    proc_exit
  fi

  if [ "$( echo $COMMAND | cut -d' ' -f1 )" = "ALL" ]; then
    if [ "$( echo $COMMAND | cut -d' ' -f2 )" != "YES!" ]; then
      echo "Are you absolutely SURE you want to do this? It will move all creds for this slave, back to the hub."
      echo "I will make a backup first if you got the path set for it."
      echo "It is recomended that you shut down this slave (shutdown 1) and do a full sync first (mss-core.sh full) to"
      echo "not leave anything behind."
      echo ""
      echo "If you are sure, add 'YES!' as an argument."
      proc_exit
    else
      proc_log "Initiating move of all credits back to $SOURCENAME."
      echo "This will move all credits back to the hub for everyone. Press ctrl-c within 5 seconds to abort."
      sleep 5
      echo "Oki, setting DEBUG to TRUE, cause you will want to see this."
      sleep 1
      MOVEALL=TRUE
    fi
  fi

  proc_verifylink

  ## Copying files here..
  echo "Copying userfiles before backup.. hold"
  DEBUG="FALSE"
  proc_copylocal
  if [ "$USERSOURCEORG" ]; then
    USERSOURCE="$USERSOURCEORG"
    unset USERSOURCEORG
  fi
  DEBUG="TRUE"

  ## Backing up users 
  proc_backup

  ## Verify link again..
  proc_verifylink

  ## Move from all users:
  if [ "$MOVEALL" = "TRUE" ]; then
    for each in `grep "^CREDITS " $USERDEST/* | cut -d':' -f1`; do
      USER="$( basename $each )"
      proc_movecredsdata
    done
  else
    for USER in $COMMAND; do
      if [ -e "$USERDEST/$each" ]; then
        proc_movecredsdata
      else
        echo "$USER does not exist on $DESTNAME..."
      fi
    done
  fi

}  

## Used by movecreds()
proc_movecredsdata() {
    if [ ! -r $USERDEST/$USER ]; then
      echo "Error. Could not read userfile $USER in $USERDEST - Perms? Something whacky cause I could read it a second ago. Skipping."
      SKIP="YES"
    fi
    if [ ! -r $USERSOURCE/$USER ]; then
      echo "Error. Could not read userfile $USER in $USERSOURCE - Perms? Skipping."
      SKIP="YES"
    fi
    if [ "$SKIP" != "YES" ]; then
      DESTCREDS="$( grep "^CREDITS " $USERDEST/$USER | cut -d' ' -f2 )"
      SOURCECREDS="$( grep "^CREDITS " $USERSOURCE/$USER | cut -d' ' -f2 )"
      if [ "$DESTCREDS" = "0" ]; then
        echo "$DESTNAME: $USER has 0 creds. Skipping."
      else
        if [ -z "$SOURCECREDS" ]; then
          echo "Error: Cant read credits from $USER on $SOURCENAME. Skipping."
        else
          if [ -z "$DESTCREDS" ]; then
            echo "Error: Cant read credits from $USER on $DESTNAME. Skipping."
          else
            NEWCREDS="$( echo "$SOURCECREDS + $DESTCREDS" | bc -l )"
            if [ -z "$NEWCREDS" ]; then
              echo "Error: Calculcated NEWCREDS went wrong. bc not installed? Skipping $USER."
            else
              ## Run check
              NEWCREDSCHECK="$( echo $NEWCREDS / 1024 | bc -l | cut -d '.' -f1 )"
              SOURCECREDSCHECK="$( echo $SOURCECREDS / 1024 | bc -l | cut -d '.' -f1 )"

              if [ "$NEWCREDSCHECK" -lt "$SOURCECREDSCHECK" ]; then
                echo "Warning: Calculated NEWCREDS for $USER are LESS then the creds on $SOURCENAME. Check this one so its correct:"
                echo "Warning: Creds on $DESTNAME:$DESTCREDS. Creds on $SOURCENAME:$SOURCECREDS. New creds:$NEWCREDS"
                echo "We'll sync that one anyway but make sure I didnt screw up."
              fi
              unset NEWCREDSCHECK; unset SOURCECREDSCHECK
              if [ ! -w "$USERSOURCE/$USER" ]; then
                echo "Error: No write permissions for $USER on $SOURCENAME in $USERSOURCE. Skipping."
              else
                if [ ! -w "$USERDEST/$USER" ]; then
                  echo "Error: No write permissions for $USER on $DESTENAME in $USERDEST. Skipping."
                else
                  proc_lock_src
                  if [ "$SKIP" != "YES" ]; then
                    proc_lock_dst
                    if [ "$SKIP" != "YES" ]; then
                      sed -e "s/^CREDITS .*/CREDITS $NEWCREDS/" $USERSOURCE/$USER > $TMP/$USER.TMP
                      mv -f $TMP/$USER.TMP $USERSOURCE/$USER
                      proc_unlock_src
                      sed -e "s/^CREDITS .*/CREDITS 0/" $USERDEST/$USER > $TMP/$USER.TMP2
                      mv -f $TMP/$USER.TMP2 $USERDEST/$USER
                      echo "$DESTNAME: $USER - $DESTCREDS + $SOURCENAME: $SOURCECREDS = NEW: $NEWCREDS"
                      proc_unlock_dst
                    else
                      proc_unlock_src
                      proc_unlock_dst
                    fi
                  fi
                fi
              fi
            fi         
          fi
        fi
      fi
    else
      unset SKIP
    fi
    unset DESTCREDS
    unset SOURCECREDS
    unset NEWCREDS
}

## NEW 2003-01-25 by Turranius
## Selects which logs to trim.
proc_trimlogs() {
  if [ "$LOG" ]; then
    TRIMLOG="$LOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
  if [ "$STATLOG" ] && [ "$STATLOG" != "$LOG" ] && [ "$STATLOG" != "$HIGHDEBUGLOG" ]; then 
    TRIMLOG="$STATLOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
  if [ "$HIGHDEBUGLOG" ] && [ "$HIGHDEBUGLOG" != "$LOG" ] && [ "$HIGHDEBUGLOG" != "$STATLOG" ]; then
    TRIMLOG="$HIGHDEBUGLOG"
    proc_trimlogsdata
    unset TRIMLOG
  fi
}

## NEW 2003-01-22 by Turranius
## Used to trim size of logs. From actionfile only !
## MOD 2003-01-25 by Turranius
## Renamed to proc_trimlogsdata
## Uses proc_trimlogs above to sync any log you wish, as long as TRIMLOG is defined.
proc_trimlogsdata() {
  ## Trim usersync.log
  if [ ! -z "$TRIMLOG" ]; then
    if [ -e "$TRIMLOG" ]; then
      if [ ! -z "$SIZE" ]; then
        BEFORESIZE="$( du -b $TRIMLOG | awk '{print $1}' )"
        if [ "$SIZE" != "CLEAR" ]; then
          if [ "$SIZE" -lt "$BEFORESIZE" ]; then
            LOGNAME="$( basename $TRIMLOG )"
            proc_highdebug "Starting to trim $LOGNAME from $BEFORESIZE bytes to $SIZE bytes."
            proc_debug "Starting to trim $LOGNAME from $BEFORESIZE to $SIZE."
            BEFORESIZE="$( du -m $TRIMLOG | awk '{print $1}' )"
            tail -c$SIZE $TRIMLOG > $TMP/NEW.LOG.tmp
            if [ -e $TMP/NEW.LOG.tmp ]; then
              mv -f $TMP/NEW.LOG.tmp $TRIMLOG
              if [ ! -z "PERMS" ]; then
                chmod $PERMS $TRIMLOG >/dev/null 2>&1
              fi
              AFTERSIZE="$( du -m $TRIMLOG | awk '{print $1}' )"
              proc_debug "Trimmed $TRIMLOG from $BEFORESIZE MB to ~$AFTERSIZE MB"
              proc_log "Trimmed $TRIMLOG from $BEFORESIZE MB to ~$AFTERSIZE MB"
              unset BEFORESIZE; unset AFTERSIZE
            else
              proc_debug "Something went wrong with trimmming. Not moving anything."
              proc_log "Trim: Something went wrong with trimmming $TRIMLOG. Not moving anything."
            fi
            unset LOGNAME
          else
            proc_debug "Trim not needed. $TRIMLOG is only $BEFORESIZE bytes. Trim command was $SIZE."
            proc_log "Trim not needed. $TRIMLOG is only $BEFORESIZE bytes. Trim command was $SIZE."
          fi
        else
          echo "" > $TRIMLOG
          proc_debug "Trimmed $TRIMLOG to 0 bytes."
          proc_log "Trimmed $TRIMLOG to 0 bytes."
        fi
      else
        proc_debug "Error: Got TRIM command, but no byte count..."
        proc_log "Error: Got TRIM command, but no byte count..."
      fi
    else
      proc_debug "Trim Error: $TRIMLOG does not exist."
      proc_log "Trim Error: $TRIMLOG does not exist."
    fi
  else
    proc_debug "Error: proc_trimlogdata was called but no TRIMLOG defined (by proc_trimlog)."
    proc_log "Error: proc_trimlogdata was called but no TRIMLOG defined (by proc_trimlog)."
  fi
}

## NEW 2003-02-08 By Turranius
## Replication procedure from mss-site.sh on the hub.
proc_updatescripts() {
  ## REPORTUPDATE causes proc_msslog() to use another 'bottrigger'.
  REPORTUPDATE="YES"
  if [ -z "$MSSREPL" ]; then
    proc_log "Error in update. Got update command but MSSREPL is undefined in config."
    proc_debug "Error in update. Got update command but MSSREPL is undefined in config."
    proc_msslog "Error in update. Got update command but MSSREPL is undefined in config."
  else
    for each in $UPDSCRIPTS; do
      UPDSCRIPT="$( echo $each | awk -F":" '{print $1}' )"
      TOPATH="$( echo $each | awk -F":" '{print $2}' )"
      if [ -z "$UPDSCRIPT" ]; then
        proc_highdebug "Error. Got UPDATE command but no script defined."
        proc_msslog "Error. Got UPDATE command but no script defined."
      else
        if [ "$TOPATH" = "" ]; then
          LOCALBINDIR="$( dirname $0 )"
        else
          LOCALBINDIR="$TOPATH"
        fi
        BACKUPDIR="$( dirname $0 )"
        if [ -w $LOCALBINDIR ]; then
          if [ -r "$MSSREPL/$UPDSCRIPT" ]; then
            if [ ! -e $BACKUPDIR/mss_oldfiles ]; then
              proc_highdebug "Creating $BACKUPDIR/mss_oldfiles to store backup in."
              mkdir $BACKUPDIR/mss_oldfiles
            fi
            if [ -e $LOCALBINDIR/$UPDSCRIPT ]; then
              proc_highdebug "Backing up $LOCALBINDIR/$UPDSCRIPT to $BACKUPDIR/mss_oldfiles"
              if [ -w $BACKUPDIR/$UPDSCRIPT ]; then
                cp -fp $LOCALBINDIR/$UPDSCRIPT $BACKUPDIR/mss_oldfiles/
              fi
            fi
            proc_highdebug "Copying $MSSREPL/$UPDSCRIPT from $SOURCENAME to $LOCALBINDIR on $DESTNAME"
            proc_debug "Copying $MSSREPL/$UPDSCRIPT from $SOURCENAME to $LOCALBINDIR on $DESTNAME"
            cp -fp $MSSREPL/$UPDSCRIPT $LOCALBINDIR
            if [ "$FETCHLOGSDIR" ]; then
              unset NEWVERSION
              NEWVERSION="$( head -n 2 $LOCALBINDIR/$UPDSCRIPT | grep "^VER=" | awk -F"=" '{print $2}' )"
              if [ "$LOCALBINDIR" = "/" ]; then
                unset LOCALBINDIR
              fi
              if [ "$NEWVERSION" ]; then
                proc_msslog "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
                proc_log "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
                proc_debug "Got new file version of replicated file: $LOCALBINDIR/$UPDSCRIPT is now using version $NEWVERSION"
              else
                proc_msslog "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
                proc_log "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
                proc_debug "Got new file: $LOCALBINDIR/$UPDSCRIPT - No version detected in it (thats ok I guess )."
              fi
            else
              proc_highdebug "Ment to send a report back to $SOURCENAME but FETCHLOGSDIR is undefined in config."
            fi
          else
            proc_log "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
            proc_debug "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
            proc_msslog "Error in update: $MSSREPL/$UPDSCRIPT not found or no perms to read it."
          fi
        else
          proc_log "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
          proc_debug "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
          proc_msslog "Error in update: No write permissions in folder $LOCALBINDIR, or folder not found."
        fi
      fi
    done
    unset each
    unset TOPATH
    unset UPDSCRIPT
    unset UPDSCRIPTS
    unset BACKUPDIR
  fi
  unset REPORTUPDATE
}

## Fix for running from shell without any set $USER.
if [ "$USER" = "root" ]; then
  unset USER
fi

if [ "$1" = "" ]; then
  proc_help
else
  case $1 in
    full) FULL="YES"; proc_fullsync; proc_exit;;
    fullsync) proc_fullsync; proc_exit;;
    fullstats) proc_fullstats; proc_exit;;
    singlefull) USER="$2"; proc_singlefull; proc_exit;;
    singlesync) USER="$2"; proc_singlesync; proc_exit;;
    singlestat) USER="$2"; proc_singlestat; proc_exit;;
    syncfiles) proc_syncfiles; proc_exit;;
    setperms) proc_setperms; proc_exit;;
    backup) COPYLOCAL="TRUE"; proc_copylocal; proc_backup; proc_exit;;
    delete) proc_delusers;proc_exit ;;
    renuser) USER="$2"; NEWUSER="$3"; proc_renuser; proc_exit;;
    singledel) USER="$2"; proc_singledel; proc_exit;;
    actionfile) proc_actionfile; proc_exit;;
    fetchlog) proc_fetchlog; proc_exit; proc_exit;;
    integrity) proc_userpasswdintegrity; proc_exit;;
    movecreds) DEBUG="TRUE"; COMMAND="$*"; proc_movecreds; proc_exit;;
    *) proc_help;;
  esac
fi

proc_exit