#!/bin/sh
VER=0.3
##################################################################
# SCRIPTNAME : MSSRLSCOMP
# AUTHOR     : void0 (void0@mail.com)
# DESCRPTION : This script creates a MSS .notdoen action-file on
#              the slave to syncronize userstats after a release
#              is complete.              
#              It is to be used with Dark0n3s zs-c bu can probably
#              be modified to work with any other aswell.
#
# INSTALLATION (added/changed in zsconfig.h)
#  #define enable_complete_script TRUE
#  #define complete_script         "/bin/mss-rlscomp.sh"
#
# Apart from the standard binaries, make sure 'tac' is in your
# /glftpd/bin dir
#
# HISTORY
#   0.3  - Checks for mss-slave.conf in the same folder as mss-rls.comp.sh /Turranius
#          Checks for DESTNAME in mss-slave.id if its not in .conf. /Turranius
#   0.2  - Changed from EXCLUDE to EXCLUDEDIR in config / Turranius
#   0.1  - First release! :)
#
# THANKS
#   Turranius for listening and implementing my ideas in MSS and
#   for making useful scripts for the public. Keep up the good!
#
##################################################################
# CONFIGURATION
##################################################################

## Remove the # from the below line to hard set what GLROOT is.
## Otherwise, it will be read from mss-slave.id in the same folder as mss-rlscomp.sh
# GLROOT="/glftpd"


## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same folder as mss-rlscomp.sh is in.
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

##################################################################
# READ CONFIG
##################################################################

if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

if [ ! -d "$GLROOT" ]; then
  GLROOT=""
fi

if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi

if [ ! -r $MSSSLAVECONFIG ]; then
  echo "Error. Cant not read $MSSSLAVECONFIG"
  exit 0
else
  . $MSSSLAVECONFIG
fi

if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      exit 0
    fi
  fi
fi

##################################################################
# FUNCTIONS
##################################################################
putlog()
{
    if [ "$VERBOSE" == "TRUE" ]; then
	echo "$*"
    fi
    if [ ! -z "$RLSCOMPLOG" ]; then
	echo `date +'%a %b %e %T %Y'` "MSSRLSCOMP:" "$*" >> $RLSCOMPLOG
    fi
}

##################################################################
write_action()
{
    putlog "Writing '$*' to slave actionfile."
    echo "$*" >> "$PASSWDDEST/$DESTNAME.actions.notdone"
}

##################################################################
# CORE
##################################################################
SCRIPTNAME="MSSRLSCOMP"
AUTHOR="void0 (void0@mail.com)"
VERSION="0.3"

##################################################################
## Verify logfile
if [ -e "$RLSCOMPLOG" ]; then
    if [ ! -f "$RLSCOMPLOG" ]; then
	putlog "Logfile exists but is not a file."
    fi
fi

putlog "$SCRIPTNAME v$VERSION by $AUTHOR - Start"

## Verify DESTNAME
if [ -z "$DESTNAME" ]; then
    putlog "DESTNAME is not set!"
    exit
fi

## Verify actions-directory
if [ -e "$PASSWDDEST" ]; then
    if [ ! -d "$PASSWDDEST" ]; then
	putlog "Actions-directory exists but is not a directory."
	exit
    fi
fi
if [ ! -w "$PASSWDDEST" ]; then
    putlog "Actions-directory is not writeable."
    exit
fi

if [ ! -r "$PASSWDDEST/passwd" ]; then
    putlog "No permissions to read from $PASSWDDEST/passwd. Check both $PASSWDDEST perms and passwd perms."
    exit
fi

if [ "$EXCLUDEDIR" = "" ]; then
  EXCLUDEDIR="fdeiFfr3Ost"
fi

if [ "$1" ]; then
    FULLPATH="$( tac "$GLXFERLOG" | grep -i ".*/$1 [ab] _ i .*" | head -n1 | tr -s ' ' | cut -d' ' -f9 )"
    if [ -z "$FULLPATH" ]; then
	putlog "File '$1' not found in $GLXFERLOG"
	exit
    fi

    RLSPATH="$GLROOT$( dirname "$FULLPATH" )"
    if [ ! -d "$RLSPATH" ]; then
	putlog "Found '$RLSPATH' but is not a directory."
	exit
    fi

    if [ -z "$( echo "$RLSPATH" | egrep "$EXCLUDEDIR" )" ]; then
	putlog "Processing '$RLSPATH'"
	PROCESSED=""
	for CURUID in $( ls -ln $RLSPATH | tr -s ' ' | cut -d' ' -f3 ); do
	    if [ -z "$( echo "$PROCESSED" | grep "$CURUID " )" ]; then
		USERS="$( grep ":$CURUID:" $PASSWDDEST/passwd | cut -d':' -f1 )"
		if [ "$USERS" ]; then
		    for CURUSER in $USERS; do
			USERUID="$( grep "^$CURUSER:" $PASSWDDEST/passwd | cut -d':' -f3 )"
			if [ "$USERUID" ] && [ $CURUID -eq $USERUID ]; then
	    		    write_action "SYNC STATS $CURUSER"
			    PROCESSED="$PROCESSED$CURUID "
			    break
                        fi
		    done
		fi
	    fi
	done    
    else
	putlog "Release '$RLSPATH' was excluded. Found in '$EXCLUDEDIR'."
    fi
fi

##################################################################
# END OF SCRIPT
##################################################################
