#!/bin/bash
VER=2.0

## Remove the # from the below line to hard set your glftpd root.
## Otherwise, it will be read from mss-slave.id in the same folder
## as transfercredits.sh/mss-core.sh
# GLROOT=/glftpd

## Remove the # from the below line to hard set where mss-slave.conf is.
## Otherwise, it will be read from the same place as transfercredits.sh/mss-core.sh
# MSSSLAVECONFIG=$GLROOT/bin/mss-slave.conf

##############################################
# GO                                         #
##############################################

## Read GLROOT from mss-slave.id if its not hardcoded above.
if [ -z $GLROOT ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 0
  else
    . $IDENTFILE
    if [ -z "$GLROOT" ]; then
      echo "Error. Cant read GLROOT from $IDENTFILE"
      exit 0
    fi
  fi
fi

## Read mss-slave.conf
if [ -z $MSSSLAVECONFIG ]; then
  MSSSLAVECONFIG="$( dirname $0 )/mss-slave.conf"
fi
if [ -r "$MSSSLAVECONFIG" ]; then
  . $MSSSLAVECONFIG
else
  echo "MSS error: Config file: $MSSSLAVECONFIG not found or no permissions to read it."
  exit 0
fi

## Read DESTNAME from mss-slave.id
if [ -z "$DESTNAME" ]; then
  IDENTFILE="$( dirname $0 )/mss-slave.id"
  if [ ! -r "$IDENTFILE" ]; then
    echo "DESTNAME not set. Either create a file called mss-slave.id and add 'DESTNAME="SlaveName"'"
    echo "or add that line to mss-slave.conf."
    echo "This can also mean I do not have permission to read mss-slave.id..."
    exit 1
  else
    . $IDENTFILE
    if [ -z "$DESTNAME" ]; then
      echo "Error. Cant read DESTNAME from $IDENTFILE"
      exit 1
    fi
  fi
fi

## Verify that we got all the settings.
if [ "$COMMAND" -a "$TRANSFERTMP" -a "$BIN" -a "$MINAMOUNT" -a "$MAXAMOUNT" -a "$AUTOMATICSTATUS" ]; then
  GOODTOGO="TRUE"
else
  echo "Error: One of the settings is empty or not set. Needed settings in mss-slave.conf are:"
  echo "COMMAND, TRANSFERTMP, BIN, MINAMOUNT, MAXAMOUNT and AUTOMATICSTATUS"
  echo "Include TRANSFERLOG if you want a log as well."
  echo "If you just upgraded, make sure you read the CHANGELOG for how to upgrade."
  exit 1
fi

################################################################
# Finished reading config.                                     #
################################################################

## Running from Shell or glftpd?
if [ -z "$FLAGS" ]; then
  MODE="SHELL"
  TRANSFERLOG="$GLROOT$TRANSFERLOG"
  TRANSFERTMP="$GLROOT$TRANSFERTMP"
  BIN="$GLROOT$BIN"
  SHELLUSER="$USER"
  TAKE="$1"
  USER="$2"
  CREDS="$3"
else
  ## Verify existance of required binaries
  if [ ! -x "$BIN/sed" ]; then
    echo "Seems you do not have 'sed' in $GLROOT$BIN. Copy sed there."
    exit 1
  fi
  if [ ! -x "$BIN/tr" ]; then
    echo "Seems you do not have 'tr' in $GLROOT$BIN. Copy tr there."
    exit 1
  fi
  if [ ! -x "$BIN/cut" ]; then
    echo "Seems you do not have 'cut' in $GLROOT$BIN. Copy cut there."
    exit 1
  fi
  if [ ! -x "$BIN/bc" ]; then
    echo "Seems you do not have 'bc' in $GLROOT$BIN. Copy bc there."
    exit 1
  fi
  if [ ! -x "$BIN/expr" ]; then
    echo "Seems you do not have 'expr' in $GLROOT$BIN. Copy expr there."
    exit 1
  fi
  if [ ! -x "$BIN/sleep" ]; then
    echo "Seems you do not have 'sleep' in $GLROOT$BIN. Copy sleep there."
    exit 1
  fi
  if [ ! -x "$BIN/grep" ]; then
    echo "Seems you do not have 'grep' in $GLROOT$BIN. Copy grep there."
    exit 1
  fi
  GLROOTCHECK="$( echo "$GLROOT" | tr -s '/' '~' )"
  USERSOURCE="$( echo "$USERSOURCE" | tr -s '/' '~' | sed -e "s/$GLROOTCHECK//" | tr -s '~' '/' )"
  USERDEST="$( echo "$USERDEST" | tr -s '/' '~' | sed -e "s/$GLROOTCHECK//" | tr -s '~' '/' )"
  MODE="GL"
  TAKE="$1"
  CREDS="$2"
fi

## Procedure for writing to the logfile.
proc_log() {
  if [ "$TRANSFERLOG" ]; then
    echo `date "+%a %b %e %T %Y"` TRANS: \"$*\" >> $TRANSFERLOG
  fi
}

## Verify log and tmp.
proc_verifylog() {
if [ "$TRANSFERLOG" != "" ]; then
  if [ ! -w "$TRANSFERLOG" ]; then
    echo "Error. No write permissions to logfile. Ask siteops to fix that."
    exit 1
  fi
fi

if [ ! -w "$TRANSFERTMP" ]; then
  echo "Error. No write permissions to TMP dir $TRANSFERTMP. Ask siteops to fix that."
  exit 1
fi
}

## Some aliases for fun.
if [ "$TAKE" = "put" -o "$TAKE" = "throw" ]; then
  TAKE="give"
fi
if [ "$TAKE" = "get" -o "$TAKE" = "fetch" ]; then
  TAKE="take"
fi

## Make test calculation
TESTING="$( echo 100 + 100 | bc -l )"
if [ -z "$TESTING" ]; then
  echo "-[ Error information ]-----------------------------------------------------"
  echo ""
  echo "Seems like you are missing the binary bc in the glftpd bin dir"
  echo "Copy that there. If it complains about libraries, do a 'locate libname.lib'"
  echo "and copy that to your glftpd lib dir."
  echo ""
  echo "-[ End Error information ]-------------------------------------------------"
  exit 1
fi
unset TESTING

## Procedute for locking on source
proc_lock_src() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERSOURCE/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY="$( expr $RETRY \- 1 )"
    echo "$USER seems locked at $SOURCENAME. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERSOURCE/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    echo "$USER seems locked at $SOURCENAME. Aborting."
    echo "Try again in a few minutes. If the error persists, contact a siteop."
    proc_log "$USER seems locked at $SOURCENAME. Aborting."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      echo "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERSOURCE/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on source
proc_unlock_src() {
  if [ -e "$USERSOURCE/$USER.lock" ]; then
    rm -f $USERSOURCE/$USER.lock
  fi
}

## Procedute for locking on destination
proc_lock_dst() {
  RETRY=10
  SLEEP=1 
  while [ -e $USERDEST/$USER.lock ] && [ "$RETRY" -gt "0" ]; do
    FOUNDLOCK="YES"
    sleep $SLEEP
    RETRY="$( expr $RETRY \- 1 )"
    echo "$USER seems locked at $DESTNAME. Retries left: $RETRY."
  done
  LOCKED="YES"
  if [ ! -e $USERDEST/$USER.lock ]; then
    LOCKED="NO"
  fi
  if [ "$LOCKED" = "YES" ]; then
    echo "$USER seems locked at $DESTNAME. Aborting."
    echo "Try again in a few minutes. If the error persists, contact a siteop."
    proc_log "$USER seems locked at $DESTNAME. Aborting."
    SKIP=YES
  else
    if [ ! -z "$FOUNDLOCK" ]; then
      echo "Lock lifted. Locking myself."
      unset FOUNDLOCK
    fi
    touch $USERDEST/$USER.lock
  fi
  unset RETRY
  unset SLEEP
  unset LOCKED
}

## Procedute for unlocking on destination
proc_unlock_dst() {
  if [ -e "$USERDEST/$USER.lock" ]; then
    rm -f $USERDEST/$USER.lock
  fi
}

## Procedure for verifying userfile integrity.
proc_userver() {
  unset VERERR
  if [ ! -e "$CHECKPATH/$USER" ]; then
    VERERR="User_Does_Not_Exist"
  else
    if [ -z "$( grep "^USER " $CHECKPATH/$USER )" ]; then VERERR="$VERERR USER"; fi
    if [ -z "$( grep "^GENERAL " $CHECKPATH/$USER )" ]; then VERERR="$VERERR GENERAL"; fi
    if [ -z "$( grep "^LOGINS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR LOGINS"; fi
    if [ -z "$( grep "^TIMEFRAME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIMEFRAME"; fi
    if [ -z "$( grep "^FLAGS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR FLAGS"; fi
    if [ -z "$( grep "^TAGLINE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TAGLINE"; fi
    if [ -z "$( grep "^DIR " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DIR"; fi
    if [ -z "$( grep "^CREDITS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR CREDITS"; fi
    if [ -z "$( grep "^RATIO " $CHECKPATH/$USER )" ]; then VERERR="$VERERR RATIO"; fi
    if [ -z "$( grep "^ALLUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLUP"; fi
    if [ -z "$( grep "^ALLDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR ALLDN"; fi
    if [ -z "$( grep "^WKUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKUP"; fi
    if [ -z "$( grep "^WKDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR WKDN"; fi
    if [ -z "$( grep "^DAYUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYUP"; fi
    if [ -z "$( grep "^DAYDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR DAYDN"; fi
    if [ -z "$( grep "^MONTHUP " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHUP"; fi
    if [ -z "$( grep "^MONTHDN " $CHECKPATH/$USER )" ]; then VERERR="$VERERR MONTHDN"; fi
    if [ -z "$( grep "^NUKE " $CHECKPATH/$USER )" ]; then VERERR="$VERERR NUKE"; fi
    if [ -z "$( grep "^TIME " $CHECKPATH/$USER )" ]; then VERERR="$VERERR TIME"; fi
    if [ -z "$( grep "^SLOTS " $CHECKPATH/$USER )" ]; then VERERR="$VERERR SLOTS"; fi
    if [ "$VERERR" ]; then
      VERERR="$( echo $VERERR | tr -s ' ' )"
    fi
  fi
}

echo "Please wait. Verifying network. - Running from: $MODE"

## Procedure to verify that userfiles exists.  
proc_checklinksimple() {
  if [ ! -e "$USERDEST/$USER" ]; then
    echo "User $USER does not exist on $DESTNAME or permissions are wrong."
    proc_log "User $USER does not exist on $DESTNAME or permissions are wrong. Command was: $FULLCOMMAND"
    exit 1
  fi

  if [ ! -e "$USERSOURCE/$USER" ]; then
    echo "Error: Link is down or $USER does not exist on $SOURCENAME."
    proc_log "$USER tried to transfer creds but does not exist on $SOURCENAME or link is down. Command was: $FULLCOMMAND"
    exit 1 
  fi
}

## Procedure for advanced userfile checking
proc_checklinkadvanced() {
  if [ ! -w "$USERSOURCE" ]; then
    echo "Error. No write permissions to users directory on $SOURCENAME."
    exit 1
  fi

  if [ ! -w "$USERDEST" ]; then
    echo "Error. No write permissions to users directory on $DESTNAME."
    exit 1
  fi

  ## Verify network link
  if [ ! -w "$USERSOURCE/$USER" ]; then
    echo "Transfer failed. Link to $SOURCENAME failed or the userfile is not writable."
    echo "Please wait up to one minute and try again. If that does not help, contact a siteop."
    proc_log "Transfer failed for $USERSOURCE/$USER. Link to $SOURCENAME failed or the userfile is not writable. Command was: $FULLCOMMAND"
    exit 1
  fi

  if [ ! -w "$USERDEST/$USER" ]; then
    echo "Transfer failed. Cant write to current userfile on $DESTNAME."
    proc_log "Transfer failed. Cant write to $USER on $DESTNAME. Command was: $FULLCOMMAND"
    exit 0
  fi

  ## Verify userfile integrity on hub
  CHECKPATH="$USERSOURCE"
  proc_userver
  if [ ! -z "$VERERR" ]; then
    echo "Warning. Userfile $USER on $SOURCENAME have problems with the following fields: $VERERR"
    proc_log "Warning. Userfile $USERSOURCE/$USER on $SOURCENAME have problems with the following fields: $VERERR"
    exit 1
  fi
  unset CHECKPATH

  ## Verify userfile integrity on slave
  CHECKPATH="$USERDEST"
  proc_userver
  if [ ! -z "$VERERR" ]; then
    echo "Warning. Userfile $USER on $DESTNAME have problems with the following fields: $VERERR"
    proc_log "Warning. Userfile $USERDEST/$USER on $DESTNAME have problems with the following fields: $VERERR"
    exit 1
  fi
  unset CHECKPATH
}

## Procedure for showing status.
proc_status() {
  if [ "$MODE" = "SHELL" -a "$USER" = "" ]; then
    proc_help
  fi

  if [ "$MODE" = "SHELL" -a "$SHELLUSER" != "" ]; then
    HEAD="$SHELLUSER@shell -> $USER"
  else
    HEAD="$USER"
  fi

  SOURCECREDSKB="$( grep "^CREDITS " $USERSOURCE/$USER | cut -d ' ' -f2 )"
  if [ -z "$SOURCECREDSKB" ]; then
    echo "Can not read $SOURCENAME credits for $USER"
    proc_log "Can not read $SOURCENAME credits for $USER. Command was: $FULLCOMMAND"
    exit 0
  else
    SOURCECREDSMB="$( echo "$SOURCECREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ -z "$SOURCECREDSMB" ]; then
      SOURCECREDSMB="0"
    fi
  fi
  DESTCREDSKB="$( grep "^CREDITS " $USERDEST/$USER | cut -d ' ' -f2 )"
  if [ -z "$DESTCREDSKB" ]; then
    echo "Can not read $DESTNAME credits for $USER"
    proc_log "Can not read $DESTNAME credits for $USER. Command was: $FULLCOMMAND"
    exit 0
  else
    DESTCREDSMB="$( echo "$DESTCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ -z "$DESTCREDSMB" ]; then
      DESTCREDSMB="0"
    fi
  fi
  if [ "$status" = "TRUE" ]; then
    echo "-[ Current Credits ]---------------------"
    echo "$SOURCENAME : $SOURCECREDSMB MB"
    echo "$DESTNAME : $DESTCREDSMB MB"
    echo "---------------------------------[ $VER ]-"
    proc_log "$HEAD checks status. $SOURCENAME: $SOURCECREDSMB <-> $DESTNAME: $DESTCREDSMB"
    exit 0
  else
    SITECREDS="$SOURCENAME: $SOURCECREDSMB MB. $DESTNAME: $DESTCREDSMB MB."
  fi
}

## Display help.
proc_help() {
  echo "-------------------------------------------------"
  echo "Welcome to the Credits Transfer System $VER      "
  echo "Current link is between $SOURCENAME<->$DESTNAME"
  echo "-------------------------------------------------"
  echo "Usage :"
  if [ "$MODE" = "GL" ]; then
    echo "site $COMMAND status"
    echo "site $COMMAND <take/give> <Mb_Amount>"
   else
    echo "transfercredits.sh take/give <username> Mb_Amount"
    echo "transfercredits.sh stats <username>"
  fi
  echo "take = $SOURCENAME -> $DESTNAME"
  echo "give = $DESTNAME -> $SOURCENAME"
  echo " "
  echo "Min amount to move is $MINAMOUNT MB."
  echo "Max amount to move is $MAXAMOUNT MB."
  echo "Specifying 'all' instead of amount will move all"
  echo "your credits between sites, but not over max"
  echo "allowed amount though."
  echo ""
  echo "Example:"
  if [ "$MODE" = "GL" ]; then
    echo "site $COMMAND take 500"
    echo "would move 500 meg creds from $SOURCENAME to $DESTNAME"
  else
    echo "transfercredits.sh take turranius 500"
    echo "would move 500 meg of turranius's creds from $SOURCENAME to $DESTNAME"
  fi
  echo "----------------------[ Turranius 2002-2003 ]----"
  exit 0
}


## Procedure for validating amount of credits.
proc_validate() {
  case $CREDS in
    [aA][lL][lL]) CREDS="666"; ALL="TRUE" ;;
    *) ALL="FALSE" ;;
  esac

  ## Make sure bet is not over 6 chars long
  MAX="$( echo "$CREDS" | wc -c | tr -d ' ' )"
  if [ "$MAX" -gt "6" ]; then
    echo "Nice try to overflow, but max in $MAXAMOUNT Mb, sucka."
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi
  unset MAX

  ## Check that bet is only containing numbers.
  ## ( If we remove everything but digits, CREDS should be emppty. If not... )
  if [ "$( echo "$CREDS" | tr -d [:digit:] )" ]; then
    echo "Only use pure numbers in amount of credits."
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi

  ## User tried to transfer minus credits.
  if [ "$CREDS" -lt "0" ]; then
    echo "Nice try, jackass"
    proc_log "$USER tried to fuck something up! Command was: $FULLCOMMAND"
    exit 1
  fi

  ## User tried to transfer below minumum limit.
  if [ "$CREDS" -lt "$MINAMOUNT" ]; then
    echo "Minimum amount to transfer is $MINAMOUNT MB"
    proc_log "$USER tried to transfer less then $MINAMOUNT MB. Command was: $FULLCOMMAND"
    exit 1
  fi 

  ## User tried to transfer above max limit.
  if [ "$CREDS" -gt "$MAXAMOUNT" ]; then
    echo "Maximum amount to transfer in one go is $MAXAMOUNT MB"
    proc_log "$USER tried to transfer more then $MAXAMOUNT MB. Command was: $FULLCOMMAND"
    exit 1
  fi 
}

## Procedure for actually moving credits.
proc_go() {
 
  ## Put amount in variable $CREDSMB and make a KiloByte calculation on it.
  CREDSMB="$CREDS"
  CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"

  ## Try and read credits from source site.
  SOURCECREDSKB="$( grep "^CREDITS " $TAKEFROM/$USER | cut -d ' ' -f2 )"

  ## Make sure its only digits that we read.
  if [ "$( echo "$SOURCECREDSKB" | tr -d [:digit:] )" ]; then
    echo "I think I read your credits on $TAKENAME wrong somehow. I got $SOURCECREDSKB"
    proc_log "Error: I got $SOURCECREDSKB when reading credits from $TAKEFROM/$USER on $TAKENAME."
    exit 0
  fi

  ## Make sure we got something...
  if [ -z "$SOURCECREDSKB" ]; then
    echo "Can not read credits on $TAKENAME."
    proc_log "Can not read CREDITS field on $TAKENAME. Command was: $FULLCOMMAND"
    exit 0
  fi

  SOURCECREDSMB="$( echo "$SOURCECREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
  
  ## Try and read credits from destination site.
  DESTCREDSKB="$( grep "^CREDITS " $GIVETO/$USER | cut -d ' ' -f2 )"

  ## Make sure its only digits that we read.
  if [ "$( echo "$DESTCREDSKB" | tr -d [:digit:] )" ]; then
    echo "I think I read your credits on $GIVENAME wrong somehow. I got $DESTCREDSKB"
    proc_log "Error: I got $DESTCREDSKB when reading credits from $GIVETO/$USER on $GIVENAME."
    exit 0
  fi

  ## Make sure we got something...
  if [ -z "$DESTCREDSKB" ]; then
    echo "Can not read credits on $GIVENAME."
    proc_log "Can not read CREDITS field on $GIVENAME. Command was: $FULLCOMMAND"
    exit 0
  fi

  DESTCREDSMB="$( echo "$DESTCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"

  if [ "$ALL" = "TRUE" -a "$CREDS" = "666" ]; then
    CREDSMB="$SOURCECREDSMB"
    CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"
    if [ "$CREDSMB" -lt "$MINAMOUNT" ]; then
      echo "You must have atleast $MINAMOUNT Mb credits to move."
      proc_log "$USER did not have atleast $MINAMOUNT credits to move. Command was: $FULLCOMMAND"
      exit 1
    else
      if [ "$CREDSMB" -gt "$MAXAMOUNT" ]; then
        echo "Max amount is $MAXAMOUNT Mb. Setting it to that amount."
        proc_log "$USER moves ALL creds, but has more then the max: $MAXAMOUNT MB. Setting it to that amount. Command was: $FULLCOMMAND"
        CREDSMB="$MAXAMOUNT"
        CREDSKB="$( echo "$CREDSMB * 1024" | bc -l | cut -d '.' -f1 )"
      else
        echo "Moving ALL credits ($SOURCECREDSMB Mb) from $TAKENAME to $GIVENAME."
        proc_log "$USER starts to move ALL credits ($SOURCECREDSMB Mb) from $TAKENAME to $GIVENAME. Command was: $FULLCOMMAND"
       fi
    fi
  fi  

  ## Check if user is trying to move more then he has.
  if [ "$CREDSKB" -gt "$SOURCECREDSKB" ]; then
    echo "You do not have $CREDSMB MB on $TAKENAME - Only $SOURCECREDSMB MB"
    proc_log "$USER tried to move $CREDSMB MB from $TAKENAME but only have $SOURCECREDSMB MB. Command was: $FULLCOMMAND"
    exit 1
  else

    echo "Transfering credits. Do NOT log out."

    NEWCREDSDESTKB="$( echo "$DESTCREDSKB + $CREDSKB" | bc -l | cut -d '.' -f1 )"
    NEWCREDSDESTMB="$( echo "$NEWCREDSDESTKB / 1024" | bc -l | cut -d '.' -f1 )"
    NEWCREDSSOURCEKB="$( echo "$SOURCECREDSKB - $CREDSKB" | bc -l | cut -d '.' -f1 )"
    NEWCREDSSOURCEMB="$( echo "$NEWCREDSSOURCEKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ "$MODE" = "SHELL" -a "$SHELLUSER" != "" ]; then
      HEAD="$SHELLUSER$shell -> $USER"
    else
      HEAD="$USER"
    fi
    if [ "$ALL" != "TRUE" ]; then
      echo "Transfering $CREDSKB Kb ($CREDSMB Mb) from $TAKENAME to $GIVENAME"
      proc_log "$HEAD starting transfer of $CREDSKB KB ($CREDSMB MB) from $TAKENAME to $GIVENAME. Command was: $FULLCOMMAND"
    fi
    if [ -w "$TAKEFROM/$USER" ]; then
      if [ -w $GIVETO/$USER ]; then
        ## Take credits from source.
        sed -e "s/^CREDITS .*/CREDITS $NEWCREDSSOURCEKB/" $TAKEFROM/$USER > $TRANSFERTMP/TEMP.$USER.CREDITS
        ## Take credits from destination.
        sed -e "s/^CREDITS .*/CREDITS $NEWCREDSDESTKB/" $GIVETO/$USER > $TRANSFERTMP/TEMP.$USER.DEST.CREDITS

        ## Verify new file ment for hub.
        OLDUSERNAME="$USER"
        USER="TEMP.$USER.CREDITS"
        CHECKPATH="$TRANSFERTMP"
        proc_userver
        if [ ! -z "$VERERR" ]; then
          echo "Warning. Userfile corruption during editing. Problem with: $VERERR. Aborting"
          proc_log "Warning. Edited userfile for $OLDUSER, ment for $TAKENAME has a problem with: $VERERR. Aboring."
          rm -f $TRANSFERTMP/TEMP.$USER.CREDITS
          rm -f $TRANSFERTMP/TEMP.$USER.DEST.CREDITS
          exit 1
        else
          USER="$OLDUSERNAME"
          unset OLDUSERNAME
          unset CHECKPATH
       fi

       ## Verify new file ment for slave
       OLDUSERNAME="$USER"
       USER="TEMP.$USER.DEST.CREDITS"
       CHECKPATH="$TRANSFERTMP"
       proc_userver
       if [ ! -z "$VERERR" ]; then
         echo "Warning. Userfile corruption duing editing to the following fields: $VERERR. Aborting"
         proc_log "Warning. Edited userfile for $OLDUSER, ment for $GIVENAME has a problem with: $VERERR. Aboring."
         rm -f $TRANSFERTMP/TEMP.$USER.CREDITS
         rm -f $TRANSFERTMP/TEMP.$USER.DEST.CREDITS
         exit 1
       else
         USER="$OLDUSERNAME"
         unset OLDUSERNAME
         unset CHECKPATH
       fi

       ## Log it.
       if [ "$ALL" = "TRUE" ]; then
         proc_log "$HEAD transfers ALL his creds, $CREDSMB Mb, from $TAKENAME to $GIVENAME - Moving userfiles"
       else
          proc_log "$HEAD transfers $CREDSMB Mb from $TAKENAME to $GIVENAME - Moving userfiles"
       fi

       ## Load beforecreds if that is enabled in config.
       if [ "$AUTOMATICSTATUS" = "TRUE" ]; then
         proc_status
       fi

       proc_lock_dst
       proc_lock_src

       if [ "$SKIP" != "YES" ]; then
         if [ -w "$TRANSFERTMP/TEMP.$USER.CREDITS" ] && [ -w "$TRANSFERTMP/TEMP.$USER.DEST.CREDITS" ]; then
           mv -f $TRANSFERTMP/TEMP.$USER.CREDITS $TAKEFROM/$USER
           mv -f $TRANSFERTMP/TEMP.$USER.DEST.CREDITS $GIVETO/$USER
         else
           echo "Error: For some reason I dont have access to do this.."
           proc_log "Error: No read access to temp files in $TRANSFERTMP for $USER. Check perms"
           proc_unlock_dst
           proc_unlock_src
           exit 1
         fi
       else
         sleep 1
         proc_unlock_dst
         proc_unlock_src
         exit 0
       fi
       proc_unlock_dst
       proc_unlock_src
     else
       echo "Cant write userfile on $GIVENAME - Quitting" 
       proc_log "Cant write destination file $GIVETO/$USER - Quitting. Command was: $FULLCOMMAND" 
       exit 1
     fi
    else
      echo "Cant write userfile on $TAKENAME - Quitting"
        proc_log "Cant write source file $TAKEFROM/$USER - Quitting. Command was: $FULLCOMMAND"
        exit 1
      fi
    fi

    echo " "
    echo "All done. Note that it might not show in the stat line at once, but it is there."

    ## Display before and after creds if that is enabled.
    if [ "$AUTOMATICSTATUS" = "TRUE" ]; then
      echo "------------[ Credits Comparison ]-----------"
      echo "Credits before: $SITECREDS"
      BEFORESITECREDS="$SITECREDS"
      proc_status
      echo "Credits after : $SITECREDS"
      echo "---------------------------------------------"
      proc_log "$USER Before> $BEFORESITECREDS - After> $SITECREDS"
    else
      echo "Verify with 'site $COMMAND status' or relogin."
    fi

    exit 0
}

## Procedure for initiating the move.
proc_gocommand() {
  ## If no credits was defined, show help and exit.
  if [ -z "$CREDS" ]; then
    proc_help
  fi

  ## Run procedure to verify write access to log
  proc_verifylog

  ## Run procedure to validate the credits desired to move.
  proc_validate

  ## Run procedure to make sure user exists and all that.
  proc_checklinksimple

  ## Run procedure to make sure we can write to userfile.
  proc_checklinkadvanced

  ## Run procedure to actually move the credits if we got this far.
  proc_go

  exit 0
}

## Set the whole command to $FULLCOMMAND ( proccess remove $* functionality ).
FULLCOMMAND="$*"

## Main internal menu. Depending on what TAKE is set to.
case $TAKE in
  [sS][tT][aA][tT][uU][sS]) status="TRUE"; proc_checklinksimple; proc_status; exit 0 ;;
  [tT][aA][kK][eE]) TAKEFROM="$USERSOURCE"; GIVETO="$USERDEST"; TAKENAME="$SOURCENAME"; GIVENAME="$DESTNAME"; proc_gocommand; exit 0 ;;
  [gG][iI][vV][eE]) TAKEFROM="$USERDEST"; GIVETO="$USERSOURCE"; TAKENAME="$DESTNAME"; GIVENAME="$SOURCENAME"; proc_gocommand; exit 0 ;;
  *) proc_help; exit 0;;
esac
