#!/bin/bash
VER=1.1

#---------------------------------------------------------------#
#                                                               #
# Extra script for those using Tur-DayStats and MSS.            #
#                                                               #
# This will save todays data from glftpd.log and login.log and  #
# send it back to a file on a directory on the hub.             #
# tur-daystats.sh, running on the hub, will then merge this     #
# data with the data grabbed from the logs on the hub.          #
#                                                               #
# These are all tempfiles, so it wont do anything to your       #
# real logs.                                                    #
#                                                               #
# Note that if you count the number of prees, you need the same #
# pre announce setup on the slave as you do on the hub.         #
#                                                               #
#-[ Setup ]-----------------------------------------------------#
#                                                               #
# Put this script in /glftpd/bin on the slave(s) and edit the   #
# settings below. It dosnt read mss-slave.conf since its stand- #
# alone, so you'll have to add the slavename again here.        #
# Anyway, should be fairly straight forward.                    #
#                                                               #
# One note on 'checkfile' though. This is a file/dir that must  #
# exist in the destdir. If not, it will assume its not mounted  #
# correctly and quit. Since we use the /glftpd/etc.ext dir, the #
# default checkfile is passwd since its in there.               #
#                                                               #
# chmod 700 /glftpd/bin/mss-daystats.sh                         #
#                                                               #
# Next, run it and make sure it outputs today data from         #
# glftpd.log and login.log to the                               #
# $destdir/slavename.daystats.log file                          #
#                                                               #
# Lastly, make sure the clocks on the hub and slave are synced  #
# and crontab this script 2-3 minutes before tur-daystats.sh    #
# runs on the hub. One minute is probably enough but..          #
#                                                               #
#-[ tur-daystats.sh setup ]-------------------------------------#
#                                                               #
# In tur-daystats.conf on the hub, there are two options.       #
# MSS_SLAVES=""                                                 #
# MSS_DAYSTATS_DIR="/glftpd/etc"                                #
#                                                               #
# In MSS_SLAVES, you should add all slaves, space seperated.    #
# The names must match that which you set in 'slavename' here.  #
#                                                               #
# The MSS_DAYSTATS_DIR should match 'destdir' here, but seen    #
# from the hub of course.                                       #
# Example:                                                      #
# destdir=/glftpd/etc.ext                                       #
# MSS_DAYSTATS_DIR="/glftpd/etc"                                #
#                                                               #
#-[ How does it work? ]-----------------------------------------#
#                                                               #
# tur-daystats.sh works in almost the same way it always did.   #
# When executed, it grabs todays data from glftpd.log and       #
# login.log and puts that in a temporary file which it then     #
# processes. Now, it will also look for any tempfiles from      #
# slaves defined in MSS_SLAVES and merge that to the temp file. #
# It will then process as it was one big site.                  #
#                                                               #
#-[ Settings ]--------------------------------------------------#

gllog=/glftpd/ftp-data/logs/glftpd.log
login=/glftpd/ftp-data/logs/login.log
destdir=/glftpd/etc.ext
slavename=xXx

checkfile=passwd


#-[ Script Start ]----------------------------------------------#

if [ ! -e "$destdir/$checkfile" ]; then
  echo "Error on mss-daystats.sh - $destdir not mounted? $checkfile not found in it."
  exit 1
fi

day1=`date +%e | tr -d ' '`
if [ "`echo "$day1" | grep "^.$"`" ]; then
  day="[ 0]$day1"
fi

case `date +%m` in
  01) month="Jan";;
  02) month="Feb";;
  03) month="Mar";;
  04) month="Apr";;
  05) month="May";;
  06) month="Jun";;
  07) month="Jul";;
  08) month="Aug";;
  09) month="Sep";;
  10) month="Oct";;
  11) month="Nov";;
  12) month="Dec";;
esac

today="`date +"... $month $day ..:..:.. "%Y`"
today2="`date +"... $month $day1 ..:..:.. "%Y`"

egrep -i "^$today|^$today2" $gllog > $destdir/$slavename.daystats.log
egrep -i "^$today|^$today2" $login >> $destdir/$slavename.daystats.log
