#!/bin/bash
VER=2.0

## Remove # below to hardset config location
## If not, it will be read from the same dir as tur-daystats.sh is in.
# config=/glftpd/bin/tur-daystats.conf

#--[ Script Start ]------------------------------#

## Load config file
if [ -z "$config" ]; then
  config="$( dirname $0 )/tur-daystats.conf"
fi

. $config

## Write output
proc_out() {
  if [ "$test" = "yes" ]; then
    echo "$@"
  else
    echo `date "+%a %b %e %T %Y"` TURGEN: \""$@\"" >> $gllog
  fi
}

if [ -z "$exclude_from_logins" ]; then
  exclude_from_logins="jfkejfkej"
fi
if [ -z "exclude_from_nukes" ]; then
  exclude_from_nukes="fejfkej"
fi

BOLD=""

if [ "$1" = "test" ] || [ "$1" = "debug" ]; then
  test="yes"
fi

day1=`date +%e | tr -d ' '`
if [ "$( echo "$day1" | grep "^.$" )" ]; then
  day="[ 0]$day1"
fi

case `date +%m` in
  01) month="Jan";;
  02) month="Feb";;
  03) month="Mar";;
  04) month="Apr";;
  05) month="May";;
  06) month="Jun";;
  07) month="Jul";;
  08) month="Aug";;
  09) month="Sep";;
  10) month="Oct";;
  11) month="Nov";;
  12) month="Dec";;
esac

today="$( date +"... $month $day ..:..:.. "%Y )"
today2="$( date +"... $month $day1 ..:..:.. "%Y )"

egrep -i "^$today|^$today2" $gllog > $tmp/daystats.tmp
egrep -i "^$today|^$today2" $login >> $tmp/daystats.tmp

for slave in $MSS_SLAVES; do
  if [ -e "$MSS_DAYSTATS_DIR/$slave.daystats.log" ]; then
    if [ "$test" = "yes" ]; then
      echo "Adding $MSS_DAYSTATS_DIR/$slave.daystats.log to todays stats."
    fi
    cat "$MSS_DAYSTATS_DIR/$slave.daystats.log" >> $tmp/daystats.tmp
    if [ "$test" != "yes" ]; then
      rm -f "$MSS_DAYSTATS_DIR/$slave.daystats.log"
    fi
  fi
done

weekname="$( date +%A )"

logins="$( egrep " LOGIN: " $tmp/daystats.tmp | wc -l | tr -d ' ' )"
if [ -z "logins" ]; then
  logins="0"
fi
logout="$( egrep " LOGOUT: " $tmp/daystats.tmp | wc -l | tr -d ' ' )"
if [ -z "logout" ]; then
  logout="0"
fi
timeout="$( egrep " TIMEOUT: " $tmp/daystats.tmp | wc -l | tr -d ' ' )"
if [ -z "timeout" ]; then
  timeout="0"
fi


nukes="$( egrep " NUKE: " $tmp/daystats.tmp | grep -v "UNKNOWN" | wc -l | tr -d ' ' )"
if [ -z "$nukes" ]; then
  nukes="0"
fi
pres="$( egrep "$pregrepline" $tmp/daystats.tmp | wc -l | tr -d ' ' )"
if [ -z "$pres" ]; then
  pres="0"
fi

newdir="$( egrep " NEWDIR: " $tmp/daystats.tmp | egrep -vi $exclude | wc -l | tr -d ' ' )"
if [ -z "$newdir" ]; then
  newdir="0"
fi
deldir="$( egrep " DELDIR: " $tmp/daystats.tmp | wc -l | tr -d ' ' )"
if [ -z "$deldir" ]; then
  deldir="0"
fi

for rawdata in $sections; do
  section="`echo "$rawdata" | cut -d ':' -f1`"
  section_name="`echo "$rawdata" | cut -d ':' -f2`"
  ## Translator
  if [ "`echo "$section" | grep "\:"`" ]; then
    secname="`echo "$section" | cut -d ':' -f2`"
    section="`echo "$section" | cut -d ':' -f1`"
  else
    secname="$section"
  fi

  if [ "$FULLINFO" ]; then
    FULLINFO="$FULLINFO $separator"
  fi
  if [ "$FULLINFO" ]; then
    FULLINFO="$FULLINFO $secname: `grep " NEWDIR: " $tmp/daystats.tmp | grep -F -- "/$section/" | egrep -vi "$exclude" | wc -l | tr -d ' '`"
  else
    FULLINFO="$secname: `grep " NEWDIR: " $tmp/daystats.tmp | grep -F -- "/$section/" | egrep -vi "$exclude" | wc -l | tr -d ' '`"
  fi
done

for section in $sectionspre; do

  ## Translator
  if [ "`echo "$section" | grep "\:"`" ]; then
    secname="`echo "$section" | cut -d ':' -f2`"
    section="`echo "$section" | cut -d ':' -f1`"
  else
    secname="$section"
  fi

  if [ "$FULLPRE" ]; then
    FULLPRE="$FULLPRE $separator"
  fi
  if [ "$FULLPRE" ]; then
    FULLPRE="$FULLPRE $secname: `grep "$pregrepline" $tmp/daystats.tmp | grep "$section" | wc -l | tr -d ' ' | tr -d '"'`"
  else
    FULLPRE="$secname: `grep "$pregrepline" $tmp/daystats.tmp | grep "$section" | wc -l | tr -d ' ' | tr -d '"'`"
  fi
done

if [ "$groupnameinpreline" ]; then
  new="1"
  highest="0"
  for pre in `grep "$pregrepline" $tmp/daystats.tmp | cut -d ' ' -f$groupnameinpreline | tr -d "$removefromgroup" | tr -d '"' | sort`; do
    if [ "$pre" ]; then
      if [ "$last" != "$pre" ]; then
        new="1"
      fi
      if [ "first" = "" -o "$last" = "$pre" ]; then
        new="$( expr $new + 1 )"
      fi

      if [ "$new" = "$highest" ]; then
        top="$top & $pre"
        highest="$new"
      else
        if [ "$new" -gt "$highest" ]; then
          top="$pre"
          highest="$new"
        fi
      fi
      last="$pre"
      first="no"
    fi
  done
  if [ "$top" ]; then
    top="$( echo "$top" | tr -d '[:cntrl:]' )"
  fi
fi

nukenr="0"
highestnuke="0"

for nuke in `grep " NUKE: " $tmp/daystats.tmp | cut -d '"' -f10- | cut -d ' ' -f1 | grep -v "UNKNOWN" | egrep -v "$exclude_from_logins" | sort`; do
  if [ -z "$ost" ]; then
    lastnuke="$nuke"
    ost="set"
  fi

  if [ "$nuke" ]; then
    if [ "$lastnuke" != "$nuke" ]; then
      nukenr="1"
    fi
    if [ "$firstnuke" = "" -o "$lastnuke" = "$nuke" ]; then
      nukenr=$[$nukenr+1]
    fi

    if [ "$nukenr" -gt "$highestnuke" ]; then
      topnuke="$nuke"
      topnukenr="$nukenr"
      highestnuke="$nukenr"
    elif [ "$nukenr" = "$highestnuke" ]; then
      topnuke="$nuke & $topnuke"
      topnukenr="$nukenr"
      highestnuke="$nukenr"
    fi
    lastnuke="$nuke"
    firstnuke="no"
  fi
done

loginnr="0"
highestlogin="0"

for login in `grep " LOGIN: " $tmp/daystats.tmp | cut -d '"' -f2 | grep -v "UNKNOWN" | egrep -v "$exclude_from_logins" | sort`; do
  if [ "$login" ]; then
    if [ "$lastlogin" != "$login" ]; then
      loginnr="1"
    fi
    if [ "$firstlogin" = "" -o "$lastlogin" = "$login" ]; then
      loginnr=$[$loginnr+1]
    fi

    if [ "$loginnr" -gt "$highestlogin" ]; then
      toplogin="$login"
      toploginnr="$loginnr"
      highestlogin="$loginnr"
    fi
    lastlogin="$login"
    firstlogin="no"
  fi
done

## MAIN OUTPUT
proc_out "At the end of this $weekname here at $BOLD$sitename$BOLD, we had:"
proc_out "$logins Logins. Of those, $logout logged out and $timeout timed out."

if [ "$loginnr" != "0" ]; then
  proc_out "Logging on a fierce $BOLD$toploginnr$BOLD times is $BOLD$toplogin$BOLD - Trigger happy!"
fi

if [ "$nukes" != "0" -a "$deldir" != "0" ]; then
  proc_out "$nukes users were nuked and $deldir dirs were deleted."
fi

proc_out "Total New dirs: $BOLD$newdir$BOLD - $FULLINFO"

if [ "$top" ]; then
  proc_out "Most Prees were made by $top with $highest fine releases."
fi

if [ "$pres" != "0" ]; then
  proc_out "Total Pred : $BOLD$pres$BOLD - $FULLPRE"
fi

if [ "$topnuke" -a "$topnukenr" ]; then
  proc_out "$topnuke LOVES the cock! Got nuked $BOLD$topnukenr$BOLD times."
fi

## STATS OUTPUT
for rawdata in $statsections; do
  unset gotstats
  section_num="`echo "$rawdata" | cut -d ':' -f1`"
  section_name="`echo "$rawdata" | cut -d ':' -f2`"
  rawstats="`$statsbin -t -u -s$section_num -x$users_to_show | egrep "^\ ##\ \ Username|\[" | tr ' ' '^' | grep -v "\^0MB\^Unknown\^$" | tr '[' '(' | tr ']' ')'`"
  if [ "$rawstats" ]; then
    gotstats="true"
    proc_out "Todays stats for section $BOLD$section_name$BOLD"
    for each in $rawstats; do
      OUTPUT="`echo "$each" | tr '^' ' '`"
      if [ -z "`echo "$each" | grep "^\^##\^\^Username"`" ]; then
        if [ "`echo "$OUTPUT" | grep "^(01)"`" ]; then
          OUTPUT="${BOLD}UP:${BOLD} ${OUTPUT}"
        else
          OUTPUT="UP: $OUTPUT"
        fi
      else
        OUTPUT="U/D $OUTPUT"
        if [ "$announced_sep" = "true" ]; then
          unset OUTPUT
        else
          announced_sep="true"
        fi
      fi
      if [ "$OUTPUT" ]; then
        proc_out "$OUTPUT"
      fi
    done
  fi

  if [ -z "$gotstats" ]; then
    rawstats="`$statsbin -t -d -s$section_num -x$users_to_show | egrep "^\ ##\ \ Username|\[" | tr ' ' '^' | grep -v "\^0MB\^Unknown\^$" | tr '[' '(' | tr ']' ')'`"
  else
    rawstats="`$statsbin -t -d -s$section_num -x$users_to_show | egrep "\[" | tr ' ' '^' | grep -v "\^0MB\^Unknown\^$" | tr '[' '(' | tr ']' ')'`"
  fi
  if [ "$rawstats" ]; then
    if [ -z "$gotstats" ]; then
      proc_out "Todays Download stats for section $BOLD$section_name$BOLD"
    fi
    for each in $rawstats; do
      OUTPUT="`echo "$each" | tr '^' ' '`"
      if [ -z "`echo "$each" | grep "^\^##\^\^Username"`" ]; then
        if [ "`echo "$OUTPUT" | grep "^(01)"`" ]; then
          OUTPUT="${BOLD}DL:${BOLD} ${OUTPUT}"
        else
          OUTPUT="DL: $OUTPUT"
        fi
      else
        OUTPUT="U/D $OUTPUT"
        if [ "$announced_sep" = "true" ]; then
          unset OUTPUT
        else
          announced_sep="true"
        fi
      fi
      if [ "$OUTPUT" ]; then
        proc_out "$OUTPUT"
      fi
    done
  fi

done

if [ -e "$tmp/daystats.output.tmp" ]; then
  rm -f "$tmp/daystats.output.tmp"
fi

exit 0
