#!/bin/bash
VER=1.0

GLLOGFILE="/ftp-data/logs/games.log"

echo "------[ Bank Status for Tur-Games ]-------"
echo " "

proc_output() {
  echo `date "+%a %b %e %T %Y"` TURGEN: \""$@\"" >> $GLLOGFILE
}

BOLD=""
ULINE=""

# Slots Below
SLOTSTAKE="0"
SLOTSGIVE="0"
for i in `cat /ftp-data/logs/slots.log | awk -F" " '{print $2}'`; do
  MINUS="$( echo $i | grep - )"
  if [ "$MINUS" = "" ]; then
    SLOTSGIVE="$(expr $SLOTSGIVE \+ $i)"
  else
    SLOTSTAKE="$(expr $SLOTSTAKE \+ $i)"
  fi
done
SLOTSTAKE="$( echo $SLOTSTAKE | tr -d - )"
SLOTSTAKE="$(expr $SLOTSTAKE \/ 1024)"
SLOTSGIVE="$(expr $SLOTSGIVE \/ 1024)"
echo "Slots: Bank took $SLOTSTAKE GB,  Bank gave $SLOTSGIVE GB."

# BlackJack Below
BJTAKE="0"
BJGIVE="0"
for i in `cat /ftp-data/logs/bj.log | awk -F" " '{print $2}'`; do
  MINUS="$( echo $i | grep - )"
  if [ "$MINUS" = "" ]; then
    BJGIVE="$(expr $BJGIVE \+ $i)"
  else
    BJTAKE="$(expr $BJTAKE \+ $i)"
  fi
done
BJTAKE="$( echo $BJTAKE | tr -d - )"
BJTAKE="$(expr $BJTAKE \/ 1024)"
BJGIVE="$(expr $BJGIVE \/ 1024)"
echo "BJack: Bank took $BJTAKE GB,  Bank gave $BJGIVE GB."

# 50-50 Below
PLAYTAKE="0"
PLAYGIVE="0"
for i in `cat /ftp-data/logs/play.log | awk -F" " '{print $2}'`; do
  MINUS="$( echo $i | grep - )"
  if [ "$MINUS" = "" ]; then
    PLAYGIVE="$(expr $PLAYGIVE \+ $i)"
  else
    PLAYTAKE="$(expr $PLAYTAKE \+ $i)"
  fi
done
PLAYTAKE="$( echo $PLAYTAKE | tr -d - )"
PLAYTAKE="$(expr $PLAYTAKE \/ 1024)"
PLAYGIVE="$(expr $PLAYGIVE \/ 1024)"
echo "50-50: Bank took $PLAYTAKE GB,  Bank gave $PLAYGIVE GB."

# Jack Vegas below
JVTAKE="0"
JVGIVE="0"
# 50-50 Below
JVTAKE="0"
JVGIVE="0"
for i in `cat /ftp-data/logs/jv.log | awk -F" " '{print $2}'`; do
  MINUS="$( echo $i | grep - )"
  if [ "$MINUS" = "" ]; then
    JVGIVE="$(expr $JVGIVE \+ $i)"
  else
    JVTAKE="$(expr $JVTAKE \+ $i)"
  fi
done
JVTAKE="$( echo $JVTAKE | tr -d - )"
JVTAKE="$(expr $JVTAKE \/ 1024)"
JVGIVE="$(expr $JVGIVE \/ 1024)"
echo "JVegas: Bank took $JVTAKE GB,  Bank gave $JVGIVE GB."

TOTALGIVE="$(expr $SLOTSGIVE \+ $BJGIVE \+ $PLAYGIVE \+ $JVGIVE)"
TOTALTAKE="$(expr $SLOTSTAKE \+ $BJTAKE \+ $PLAYTAKE \+ $JVTAKE)"

echo "Total Taken: $TOTALTAKE GB"
echo "Total Given: $TOTALGIVE GB"

proc_output "${BOLD}-(SCORES for Bank)${BOLD} (Slots - Given: ${BOLD}$SLOTSGIVE GB${BOLD} Taken: ${BOLD}$SLOTSTAKE GB${BOLD}) - (BlackJack - Given: ${BOLD}$BJGIVE GB${BOLD} Taken: ${BOLD}$BJTAKE GB${BOLD}) - (50-50 - Given: ${BOLD}$PLAYGIVE GB${BOLD} Taken: ${BOLD}$PLAYTAKE GB${BOLD}) (Jack Vegas - Given: ${BOLD}$JVGIVE GB${BOLD} Taken: ${BOLD}$JVTAKE GB${BOLD}) (GiveTotal: ${BOLD}$TOTALGIVE GB${BOLD} TakeTotal: ${BOLD}$TOTALTAKE GB${BOLD})"

exit 0
