#!/bin/bash
VER=1.0

GLLOGFILE="/ftp-data/logs/games.log"

#--[ Script Start ]--#

proc_output() {
  echo `date "+%a %b %e %T %Y"` TURGEN: \""$@\"" >> $GLLOGFILE
}

BOLD=""
ULINE=""

SLOTS="0"
PLAY="0"
BJ="0"

SLOTS="$(cat /ftp-data/logs/slots.log | grep $USER | awk -F" " '{print $2}')"
PLAY="$(cat /ftp-data/logs/play.log | grep $USER | awk -F" " '{print $2}')"
BJ="$(cat /ftp-data/logs/bj.log | grep $USER | awk -F" " '{print $2}')"
#RR="$(cat /ftp-data/logs/fights.log | grep $USER | awk -F" " '{print $2}')"
JV="$(cat /ftp-data/logs/jv.log | grep $USER | awk -F" " '{print $2}')"
FLIGHT="$(cat /ftp-data/logs/fragslight.log | grep $USER | awk -F" " '{print $2}')"
NEWRR="$(cat /ftp-data/logs/rr.log | grep $USER | awk -F" " '{print $2}')"
NEWRRCRED="$(cat /ftp-data/logs/rr.log | grep $USER | awk -F" " '{print $3}')"

if [ "$SLOTS" = "" ]; then
  SLOTS="0"
fi

if [ "$PLAY" = "" ]; then
  PLAY="0"
fi

if [ "$BJ" = "" ]; then
  BJ="0"
fi

if [ "$JV" = "" ]; then
  JV="0"
fi

TOTAL="$(expr $SLOTS \+ $PLAY \+ $BJ \+ $JV)" 

#if [ "$RR" = "" ]; then
#  RR="Never played"
#fi

if [ "$FLIGHT" = "" ]; then
  FLIGHT="Never played"
fi

if [ "$NEWRR" = "" ]; then
  NEWRR="Never played"
fi

if [ "$NEWRRCRED" = "" ]; then
  NEWRR="0"
fi

echo "---------------------------------------------------------------"
echo "This script only shows the highscores from the scripts that is"
echo "created by Turranius, and Russian Roulette."
echo $USER in SLOTS: $SLOTS MB
echo $USER in 50-50: $PLAY MB
echo $USER in BJack: $BJ MB
echo $USER in JackV: $JV MB
echo $USER Total in the above 4: $TOTAL MB
#echo "$USER's ratio in Russian Roulette: $RR"
echo "$USER's ratio in Frags Light: $FLIGHT"
echo "$USER's ratio in NiA's RR: $NEWRR. Creds: $NEWRRCRED"
echo "---------------------------------------------------------------"

proc_output "${BOLD}-(SCORES for $USER)${BOLD} ${BOLD}Slots:${BOLD} $SLOTS MB | ${BOLD}50-50:${BOLD} $PLAY MB | ${BOLD}BJ:${BOLD} $BJ MB | ${BOLD}JV:${BOLD} $JV MB | ${BOLD}Total:${BOLD} $TOTAL | ${BOLD}FLIGHT:${BOLD} $FLIGHT | ${BOLD}NiA-RR${BOLD} $NEWRR Cred:$NEWRRCRED"