#!/bin/bash
VER=1.0

USERPATH=/ftp-data/users
BACKUPPATH=/ftp-data/users/backup
LOCKFILE=/tmp/frags.lock
LOGFILE=/ftp-data/logs/frags.log
GLLOGFILE=/ftp-data/logs/games.log
NODELAYPASS=onlycoolppl
USERDATA=/bin/frags  ## Make sure this dir exists and is 777.
TEMPPATH=/tmp
USERFILETMP=/tmp/$USER.fragstmp
LOGFILETMP=/tmp/log.fragstmp
BINFOLDER=/bin
MSGDIR=/ftp-data/msgs

##--[ Script Start ]--#


proc_output() {
  echo `date "+%a %b %e %T %Y"` TURGEN: \""$@\"" >> $GLLOGFILE
}

BOLD=""
ULINE=""

## Random generator. Set LOW and HIGH first.
proc_random() {
  ## If the numbers are the same, just set it to the HIGH one...
  if [ "$LOW" = "$HIGH" ]; then
    number=$HIGH
  else
    number="-1"
    while [ "$number" -lt "$LOW" ]; do
      number="$RANDOM"
      if [ "$number" -gt "$HIGH" ]; then
        temphigh=$[$HIGH+1]
        let "number %= $temphigh"  # Scales $number down within $HIGH range.
      fi
    done
  fi
}

if [ -z $1 ]; then
  echo "         Welcome to FRAGS! An entirely new concept in gaming!"
  echo "----------------[ General information and rules ] -------------------"
  echo "Usage: site frags rules ------- Speaks for itself.                   "
  echo "Usage: site frags highscores -- Highscores of best and worst users.  "
  echo "                                                                     " 
  echo "----------------------[ Shopping Section ]---------------------------"
  echo "Usage: site frags newuser ----- Sign up for frags.                   " 
  echo "Usage: site frags inv --------- Check your arsenal and HP.           "
  echo "Usage: site frags inv <user> -- Check that persons arsenal.          "
  echo "Usage: site frags buy --------- Check whats in the shop.             "
  echo "Usage: site frags buy <1-12> -- Buy something from the shop.         "
  echo "Usage: site frags sell -------- See what the shop wishes to buy back."
  echo "Usage: site frags sell <1-10> - Sell something back to the store.    "
  echo "Usage: site frags snipe ------- Rent a sniper rifle. Read the rules! "
  echo "                                                                     "
  echo "------------------------[ Fight Section ]----------------------------"
  echo "Usage: site frags attack ------ Challenge someone to fight!          "
  echo "Usage: site frags accept ------ Check if anyone has challenged you.  "
  echo "Usage: site frags chal -------- See all waiting challenges.          "
  echo "Usage: site frags decline ----- Decline any current challenge on you."
  echo "Usage: site frags cancel ------ Cancel all of challenges by you.     "
  echo "--------------------------------------------------by-Turranius-v0.4B-"
  exit 0
fi

## Create the user file.
if [ "$1" = "newuser" ]; then
  if [ -e $USERDATA/$USER.frags ]; then
    echo "You have already signed up once."
    exit 0
  else
    ## Check that the user does not have leech
    RATIO=$(grep RATIO $USERPATH/$USER | awk -F" " '{print $2}')
    if [ $RATIO = "0" ]; then
      echo "You are immortal. You cant sign up for FRAGS."
      exit 0
    fi
    echo "HITPOINTS 100" > $USERDATA/$USER.frags
    echo "SLINGSHOT=YES" >> $USERDATA/$USER.frags
    echo "COLT22=NO" >> $USERDATA/$USER.frags
    echo "COLT45=NO" >> $USERDATA/$USER.frags
    echo "GLOC=NO" >> $USERDATA/$USER.frags
    echo "44MAGNUM=NO" >> $USERDATA/$USER.frags
    echo "SHOTGUN=NO" >> $USERDATA/$USER.frags
    echo "UZI=NO" >> $USERDATA/$USER.frags
    echo "AK45=NO" >> $USERDATA/$USER.frags
    echo "MINIGUN=NO" >> $USERDATA/$USER.frags
    echo "ROCKETLAUNCHER=NO" >> $USERDATA/$USER.frags
    echo "NUKELAUNCHER=NO" >> $USERDATA/$USER.frags
    echo "INSURANCE=NO" >> $USERDATA/$USER.frags
    echo "You have successfully signed up to Frags! Here is your free Slingshot."
    proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} signed up for ${BOLD}FRAGS${BOLD}"
    exit 0
  fi
fi

## Decline any challenge
if [ "$1" = "decline" ]; then
  if [ -f $USERDATA/$USER.frags ]; then
    CHALNAME="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $1}')"
    CHALGUN="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $2}')"
    CHALMB="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $3}')"  
    if [ "$CHALNAME" = "" ]; then
      echo "Can't see that you got any current challenges."
      exit 0
    else
      rm -f $TEMPPATH/frags_$USER
      echo "You decline the challenge from $CHALNAME"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} declines $CHALNAME's challenge"
      exit 0
    fi
  else
    echo "You havent signed up yet [site frags newuser]"
    exit 0
  fi
fi

## Check Rules
if [ "$1" = "rules" ]; then
  echo ""
  echo "----------------------------------------------------------------"
  echo " Welcome to FRAGS. The exiting game of guns and guts.           "
  echo " What is FRAGS? Well, frags is like Quake in a way. You have HP "
  echo " (HitPoints). Instead of picking up weapons though, you have to "
  echo " buy them. Buying is done with credits, and each Dollar counts  "
  echo " as one Megabyte credit.                                        "
  echo "                                                                "
  echo " Minimum amount to gamble for is 500 Dollar. There is no upper  "
  echo " limit, other than what you and your opponent currently have.   "
  echo "                                                                "
  echo " In order to play FRAGS, you need to sign up. Do this with      "
  echo " 'site frags newuser'.                                          "
  echo " For general information or guidelines on the commands that     "
  echo " appear if you type 'site frags', just try and type them.       "
  echo " Most things are easy to understand, but starting a fight can   "
  echo " be annoying since you have to type who to fight, what gun to   "
  echo " use, and how much you want to bet.                             "
  echo " Simply typing 'site frags attack' will lead you through it.    "
  echo "                                                                "
  echo " Once a fight starts, you will take one turn each trying to hit "
  echo " the opponent with whatever weapon you both selected.           "
  echo " You have 100 HP to start with, and once it reaches 0, you are  "
  echo " dead. Judges will cut in if the fight should become too long.  "
  echo "                                                                "
  echo " You have 11 different weapons to choose from, each doing       "
  echo " different damage. In the shop (site frags buy), you see the    "
  echo " minimum and maximum damage of each weapon.                     "
  echo "                                                                "
  echo " Weapons can be sold back to the store for 50% of they're price."
  echo " Type 'site frags sell' to see what the store offers.           "
  echo " You can not sell the initial Slingshot weapon.                 "
  echo "                                                                "
  echo " You can also buy HitPoints in the store. You start with 100 HP "
  echo " but can buy your way up to 300. Each time you loose a fight   "
  echo " you will loose 5 HP, unless you are already at 100 HP total.   "
  echo "                                                                "
  echo " Snipe those bastards! Using 'site frags snipe', you can rent   "
  echo " a sniper rifle and do 30-80 damage to a target of your choise. "
  echo " This does only work if the fightbet is no more than 1GB and    " 
  echo " you can't snipe anyone you are fighting yourself (obviously).  "
  echo " If you are fast, you can even snipe someone when they are in   "
  echo " the middle of the fight.                                       "
  echo "                                                                "
  echo " There is also an insurance to buy. This will protect you if    "
  echo " you should die in the next fight by letting the store pay for  "
  echo " between 10 and 80% of the amount you would otherwise have lost "
  echo " Please note that the insurance will only last for the next     "
  echo " fight, no matter if you win or loose.                          "
  echo "                                                                "
  echo " All challenges and sniper orders are reset at midnight.        "
  echo " ---------------------------------------------------------------"
  echo " Please note. Anything about this game can change at any minute."
  echo " We reserve the right to deluser anyone for misconduct within   "
  echo " FRAGS (or otherwise).                                          "
  echo " We will NOT restore credits for crapped out userfiles, but     "
  echo " there are backups.                                             "
  echo " -------------[ FRAGS was created by Turranius ]----------------"
  exit 0
fi

## SNIPER SECTION
if [ "$1" = "snipe" ]; then
  if [ "$2" = "$USER" ]; then
    echo "Try putting a gun to your face and hit the trigger instead"
    exit 0
  fi  
    if [ -z $2 ]; then
      echo "Also state who you want to snipe."
      echo "NOTE: The sniper rifle rent is 500 Dollars."
      echo "You will only snipe if the fight bet is less than 1GB"
      echo "and you cant snipe someone you are fighting yourself."
      echo "All sniper rifles are returned at midnight, used or not."
      exit 0
    else
      if [ -f $USERDATA/$2.frags ]; then
        USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
        USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
        if [ "$USERCREDSMB" -gt "500" ]; then
          COSTKB="$(expr 500 \* 1024)"
          NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"

          sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
          mv -f $USERFILETMP $USERPATH/$USER
          echo "Ok, if $2 gets into a fight, you'll snipe his ass for 30-80 damage."
          echo "$USER" > $TEMPPATH/fragssnipe_$2
          exit 0
        else
          echo "You cant afford the sniper bullet chump."
          exit 0
        fi
      else
        echo "Cant snipe him cause I cant see that he's signed up."
        exit 0
      fi
    fi
fi
  
## Check inventory
if [ "$1" = "inv" ]; then
  if [ -z $2 ]; then
    echo ""
  else
    if [ -e $USERDATA/$2.frags ]; then
      USER=$2
    else
      echo "That user does not exist, or have not signed up."
      exit 0
    fi
  fi

  if [ -e $USERDATA/$USER.frags ]; then
    INVHP="$(cat $USERDATA/$USER.frags | grep HITPOINTS | awk -F" " '{print $2}')"
    INVG1="$(cat $USERDATA/$USER.frags | grep SLINGSHOT | awk -F"=" '{print $2}')"
    INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
    INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
    INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
    INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
    INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
    INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
    INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
    INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
    INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
    INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"
    INVIN="$(cat $USERDATA/$USER.frags | grep INSURANCE | awk -F"=" '{print $2}')"

    echo "-------[ FRAGS ]--------"
    echo "Inventory for $USER"
    echo "Hitpoints  : $INVHP"
    echo "Insurance  : $INVIN"
    echo "------------------------" 
    echo "Arsenal:"

    if [ "$INVG1" = "YES" ]; then
      echo "Slingshot [5-20]"
    fi
    if [ "$INVG2" = "YES" ]; then
      echo "Colt22 [9-25]"
    fi
    if [ "$INVG3" = "YES" ]; then
      echo "Colt45 [10-35]"
    fi
    if [ "$INVG4" = "YES" ]; then
      echo "GLOC [20-45]"
    fi
    if [ "$INVG5" = "YES" ]; then
      echo "44Magnum [25-50]"
    fi
    if [ "$INVG6" = "YES" ]; then
      echo "Shotgun [30-60]"
    fi
    if [ "$INVG7" = "YES" ]; then
      echo "UZI [40-70]"
    fi
    if [ "$INVG8" = "YES" ]; then
      echo "AK45 [45-80]"
    fi
    if [ "$INVG9" = "YES" ]; then
      echo "Minigun [55-90]"
    fi
    if [ "$INVG10" = "YES" ]; then
      echo "RocketLauncher [80-100]"
    fi
    if [ "$INVG11" = "YES" ]; then
      echo "NukeLauncher [?-?]"
    fi
    echo "------------------------"

    currenttime=`date +%s`
    if [ -e /tmp/fragstime_$USER ]; then
      lasttime=`cat /tmp/fragstime_$USER`
      lasttime=`expr $lasttime / 60`
      currenttime=`expr $currenttime / 60`
      delayedtime=`expr $currenttime - $lasttime`
      if [ `expr $delayedtime "<=" 59` = 1 ] ; then
        x=60
        delayedtime=$[x - $delayedtime ]
        echo "$USER's reservation in the arena isnt for another $delayedtime minutes."
        exit 0
      else
        echo "$USER's reservation to the arena is open anytime."
        exit 0
      fi
    else
      echo "$USER's reservation is open anytime."
      exit 0
    fi
  else
    echo "You need to sign up first. Read through the rules."
    exit 0
  fi
fi

## If the user gives the nodelaypass, delete his timer file.
if [ "$1" = "$NODELAYPASS" ]; then
  ## If a second variable is set, check if that is a user, and if so, reset that users timer.
  if [ "$2" != "" ]; then
    if [ -e $USERPATH/$2 ]; then
      echo "Admin password detected. Clearing timer for $2"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER's${BOLD} grants ${BOLD}$2${BOLD} another round in the arena!"
      rm -f /tmp/fragstime_$2
      exit 0
    else
      echo "Cant clear timer for $2. No such user."
      exit 0
    fi
  else
    echo "Admin password detected. Clearing your timer."
    rm -f /tmp/fragstime_$USER
    exit 0
  fi
fi


## User selected to see highscores.
if [ "$1" = "highscores" ]; then
  echo "-----[ Highscore for FRAGS ]------"
  echo "User:    Win/Loose Ratio:         "
  cat $LOGFILE | sort -k 2,2 -n -r
  echo "----------------------------------"
  exit 0
fi

## Cancel your challenges.
if [ "$1" = "cancel" ]; then
  for i in `ls $TEMPPATH/frags_* -f -A`
  do
    CHALNAME="$(cat $i | awk -F" " '{print $1}')"
    NAME="$(echo $i | awk -F"_" '{print $2}')"
    if [ "$CHALNAME" = "$USER" ]; then
      echo "Cancelling you challenge to $NAME"
      rm -f $i
    fi
  done
  exit 0
fi


## Current awaiting challenges.
if [ "$1" = "chal" ]; then
  echo "-------------------[ Current Awaiting Challenges ]-----------------"
  for i in `ls $TEMPPATH/frags_* -f -A`
  do
    CHALNAME="$(cat $i | awk -F" " '{print $1}')"
    CHALGUN="$(cat $i | awk -F" " '{print $2}')"
    CHALMB="$(cat $i | awk -F" " '{print $3}')"
    i="$(echo $i | awk -F"_" '{print $2}')"
    if [ "$CHALNAME" != "DUMMY" ]; then
      echo "$CHALNAME has challenged $i, for $CHALMB Dollars."
    fi
  done
  echo "-----[ Note: All challenges are removed at midnight each day ]-----"
  exit 0
fi


## Check the shop, or buy something.
if [ "$1" = "buy" ]; then
  if [ -z $2 ]; then
    echo "-------------------[ Frags Shop ]-------------------"
    echo "Welcome to the lonely Archives gun and utility shop!"
    echo "Everything you need, and beyond."
    echo "Please, have a look at our nice selection."
    echo " 0: Slingshot      - Damage: 5-20   - Price: N/A"
    echo " 1: Colt 22        - Damage: 9-25   - Price: 750"
    echo " 2: Colt 45        - Damage: 10-35  - Price: 1500"
    echo " 3: GLOC           - Damage: 20-45  - Price: 2000"
    echo " 4: 44 Magnum      - Damage: 25-50  - Price: 3000"
    echo " 5: Shotgun        - Damage: 30-60  - Price: 4000"
    echo " 6: UZI            - Damage: 40-70  - Price: 6000"
    echo " 7: AK45           - Damage: 45-80  - Price: 7000"
    echo " 8: Minigun        - Damage: 55-90  - Price: 8000"
    echo " 9: RocketLauncher - Damage: 80-100 - Price: 9000"
    echo "10: NukeLauncher   - Damage: ?-?    - Price: 15.000"
    echo "-----------------------------------------------------"
    echo "11: Healthpack. Will raise HP by 20 - Price: 700"
    echo "12: Insurance. The insurance will ensure that if you "
    echo "    should loose the next fight, the shop will "
    echo "    pay some of the penalties."
    echo "    The insurance only lasts the next fight."
    echo "                                    - Price: 300"
    echo "-----------------------------------------------------"
    exit 0
  fi

  if [ -e $USERDATA/$USER.frags ]; then
    echo "You go into the shop!"
  else
    echo "You dont have a gun license yet. Sign up for one."
    echo "(site frags newuser)"
    exit 0
  fi
  
  if [ -e $USERDATA/$USER.frags ]; then
    USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
    USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
  else
    echo "Hmm, I can't seem to find your licence. You need to sign up first!".
    exit 0
  fi

  if [ "$2" = "1" ]; then
    if [ "$USERCREDSMB" -lt "750" ]; then
      echo "Hehe, you better earn some money first, punk."
      exit 0
    fi
    echo "Ahh, the Colt 22mm is a nice gun to close quarters. Let me get one for you."
    INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
    if [ "$INVG2" = "YES" ]; then
      echo "Hmm, seems you already have one. You can only use one Colt 22."
      exit 0
    else
      echo "Here you go sir. A bright new gun for you."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} picks up a nice ${BOLD}Colt 22${BOLD} from the store"
      $(perl -p -i -e 's/COLT22=NO'/'COLT22=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 750 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "2" ]; then
    if [ "$USERCREDSMB" -lt "1500" ]; then
      echo "Nah, you're too poor, suka!"
      exit 0
    fi
    echo "Good choise! The Colt 45 packs a nice punch! Lemme get it."
    INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
    if [ "$INVG3" = "YES" ]; then
      echo "Hmm, seems you already have one. You can only use one Colt 45."
      exit 0
    else
      echo "Here you go sir. A bright new gun for you."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} goes and buys a ${BOLD}Colt 45${BOLD} from the store"
      $(perl -p -i -e 's/COLT45=NO'/'COLT45=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 1500 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "3" ]; then
    if [ "$USERCREDSMB" -lt "2000" ]; then
      echo "Bwaaahaha, get the fuck out of here."
      exit 0
    fi
    echo "Ah yes, the GLOC. A fine mediocre weapon. Just one second."
    INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
    if [ "$INVG4" = "YES" ]; then
      echo "Hmm, seems you already have one. You can only use one GLOC."
      exit 0
    else
      echo "Here you go sir. A bright new gun for you."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} wanna make a mess with his new ${BOLD}GLOC${BOLD}"
      $(perl -p -i -e 's/GLOC=NO'/'GLOC=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 2000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "4" ]; then
    if [ "$USERCREDSMB" -lt "3000" ]; then
      echo "Sorry, no way you can afford that."
      exit 0
    fi
    echo "Do you feel lucky Punk??. Always wanted to say that. Lemme go get it."
    INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
    if [ "$INVG5" = "YES" ]; then
      echo "Hmm, seems you already have one. I think that's enough for you."
      exit 0
    else
      echo "Here you go sir. A bright new gun for you. Dont shoot yourself now, ya hear?"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} feels like Dirty Harry when he's polishing his new ${BOLD}44 Magnum${BOLD}!"
      $(perl -p -i -e 's/44MAGNUM=NO'/'44MAGNUM=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 3000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "5" ]; then
    if [ "$USERCREDSMB" -lt "4000" ]; then
      echo "NO CAN DO! Come back when you have more money!"
      exit 0
    fi
    echo "Well why not? You can afford it. A nice Shotgun does wonders."
    INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
    if [ "$INVG6" = "YES" ]; then
      echo "And I'd love to sell you one, but you already have one."
      exit 0
    else
      echo "Here you go sir. A bright new gun for you. Now remember, dont look into the barrel when cleaning it."
      proc_output "${BOLD}-(FRAGS-FULL)-${BOLD} Banks close early today because ${BOLD}$USER${BOLD} got himself a ${BOLD}Shotgun!${BOLD}"
      $(perl -p -i -e 's/SHOTGUN=NO'/'SHOTGUN=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 4000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "6" ]; then
    if [ "$USERCREDSMB" -lt "6000" ]; then
      echo "I should shoot you with this UZI for trying to cheat me!"
      exit 0
    fi
    echo "Always loved this peice. The UZI splats brain like no other gun."
    INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
    if [ "$INVG7" = "YES" ]; then
      echo "But you know that.. I see you already got one."
      exit 0
    else
      echo "Here you go sir. A bright new UZI for you. Take this ammo too."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sprays his name in the wall with his new ${BOLD}UZI${BOLD}"
      $(perl -p -i -e 's/UZI=NO'/'UZI=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 6000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "7" ]; then
    if [ "$USERCREDSMB" -lt "7000" ]; then
      echo "Now, the AK45 isn't cheap! Infact, you can't even afford one."
      exit 0
    fi
    echo "Famous for its fast led spraying abilites, the AK45 will rock your world."
    INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
    if [ "$INVG8" = "YES" ]; then
      echo "Your world already seems rocked though. You got one hanging from your shoulders."
      exit 0
    else
      echo "Here you go sir. A bright new AK45 for you. Enjoy the carnage!"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} makes love to his new ${BOLD}AK45${BOLD}"
      $(perl -p -i -e 's/AK45=NO'/'AK45=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 7000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "8" ]; then
    if [ "$USERCREDSMB" -lt "8000" ]; then
      echo "Arnold would say 'I'll be back' right about now, but you wont, cause you can't afford it!"
      exit 0
    fi
    echo "Rich guy eh? Well, lemme just dismount it from the Apache attackhelicopter..."
    INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
    if [ "$INVG9" = "YES" ]; then
      echo "Wait a second.. Isn't that a minigun sticking out of your coat already? You can't handle two!"
      exit 0
    else
      echo "Here you go sir. Go find Sarah Connor, muhahaha."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} IS Arnold Swarzenegger now! Whaaaaaaaa"
      $(perl -p -i -e 's/MINIGUN=NO'/'MINIGUN=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 8000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "9" ]; then
    if [ "$USERCREDSMB" -lt "9000" ]; then
      echo "You make me cry, you know that?"
      exit 0
    fi
    echo "Hmm, I think those are out of stock...."
    INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
    if [ "$INVG10" = "YES" ]; then
      echo "Yepp, all out. Sorry."
      exit 0
    else
      echo "No wait, theres one. Here you go sir. Have fun."
      proc_output "${BOLD}-(FRAGS-FULL)-${BOLD} Time to kick ass and chew bubble gum, and I'm all out of ass.. err. Or something. Well atleast ${BOLD}$USER${BOLD} has a ${BOLD}Rocket Launcher${BOLD} now"
      $(perl -p -i -e 's/ROCKETLAUNCHER=NO'/'ROCKETLAUNCHER=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 9000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "10" ]; then
    if [ "$USERCREDSMB" -lt "15000" ]; then
      echo "no No NO! Only one I got is reserverd for Saddam.. Err I mean..."
      exit 0
    fi
    echo "Time for action! Lemme arm it for you!"
    INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"
    if [ "$INVG11" = "YES" ]; then
      echo "Hm, What on earth could you want with 2 Nuke Launchers???"
      exit 0
    else
      echo "There you go. I'll just move to a neutral country now."
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} is planning to commit genocide with his new ${BOLD}Nuke Launcher${BOLD}"
      $(perl -p -i -e 's/NUKELAUNCHER=NO'/'NUKELAUNCHER=YES/gi' `ls $USERDATA/$USER.frags`)
      COSTKB="$(expr 15000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "11" ]; then
    if [ "$USERCREDSMB" -lt "700" ]; then
      echo "Sorry, you can not afford that!"
      exit 0
    fi
    echo "Healthpacks are a great way to stay alive longer. Just a second."
    INVHP="$(cat $USERDATA/$USER.frags | grep HITPOINTS | awk -F" " '{print $2}')"
    if [ "$INVHP" -gt "299" ]; then
      echo "Im Sorry, but you are already at maximum health."
      exit 0
    else
      NEWHP="$(expr $INVHP \+ 20)"
      $(perl -p -i -e 's/HITPOINTS '$INVHP'/HITPOINTS '$NEWHP'/gi' `ls $USERDATA/$USER.frags`)
      echo "Congratulations. Your total hitpoints are now $NEWHP"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} buys a little boost to his HP ($NEWHP)"
      COSTKB="$(expr 700 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  if [ "$2" = "12" ]; then
    if [ "$USERCREDSMB" -lt "300" ]; then
      echo "Sorry. We don't insure bums like you. Now get out!"
      exit 0
    fi
    echo "Good choise. We'll pay part of your loss."
    INVIN="$(cat $USERDATA/$USER.frags | grep INSURANCE | awk -F"=" '{print $2}')"
    if [ "$INVIN" = "YES" ]; then
      echo "Wise as you are, I see you already got an insurance from us."
      exit 0
    else
      $(perl -p -i -e 's/INSURANCE=NO'/'INSURANCE=YES/gi' `ls $USERDATA/$USER.frags`)
      echo "Here you go sir."
      echo "We will pay for 10 to 80% if you loose in your next fight."
      echo "This ensurance is ONLY valid for you next fight, so choose wisely!"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} is scared. Gets a wussy insurance."
      COSTKB="$(expr 300 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \- $COSTKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    fi
  fi

  echo "Hm, thats not on my list. Please check the shop again."
  exit 0
fi  


if [ "$1" = "sell" ]; then
  if [ -e $USERDATA/$USER.frags ]; then
    USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
    USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
  else
    echo "You dont even have a license. How can you have anything to sell?"
    exit 0
  fi

  INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
  INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
  INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
  INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
  INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
  INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
  INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
  INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
  INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
  INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"
  if [ -z $2 ]; then
    echo "Please select a weapon to sell."
    if [ "$INVG2" = "YES" ]; then
      echo "1: Colt22    - Offer: 375"
    fi
    if [ "$INVG3" = "YES" ]; then
      echo "2: Colt45    - Offer: 750"
    fi
    if [ "$INVG4" = "YES" ]; then
      echo "3: GLOC      - Offer: 1000"
    fi
    if [ "$INVG5" = "YES" ]; then
      echo "4: 44Magnum  - Offer: 1500"
    fi
    if [ "$INVG6" = "YES" ]; then
      echo "5: Shotgun   - Offer: 2000"
    fi
    if [ "$INVG7" = "YES" ]; then
      echo "6: UZI       - Offer: 3000"
    fi
    if [ "$INVG8" = "YES" ]; then
      echo "7: AK45      - Offer: 3500"
    fi 
    if [ "$INVG9" = "YES" ]; then
      echo "8: Minigun   - Offer: 4000"
    fi
    if [ "$INVG10" = "YES" ]; then
      echo "9: RocketLauncher - Offer: 4500"
    fi
    if [ "$INVG11" = "YES" ]; then
      echo "10: NukeLauncher  - Offer: 7500"
    fi    
    echo "-------------------------------------------"
    exit 0
  fi 

  ## Backup that userfile
  if [ "$BACKUPPATH" ]; then
    cp -f $USERPATH/$USER $BACKUPPATH/$USER.frags
  fi

  if [ "$2" = "1" ]; then
    if [ "$INVG2" = "YES" ]; then
      echo "Thanks for the Colt22. Here are your 375 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} Colt 22 ${BOLD}"
      $(perl -p -i -e 's/COLT22=YES'/'COLT22=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 375 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a Colt22, moron."
      exit 0
    fi
  fi

  if [ "$2" = "2" ]; then
    if [ "$INVG3" = "YES" ]; then
      echo "Thanks for the Colt45. Here are your 750 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} Colt 45 ${BOLD}"
      $(perl -p -i -e 's/COLT45=YES'/'COLT45=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 750 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a Colt45, moron."
      exit 0
    fi
  fi

  if [ "$2" = "3" ]; then
    if [ "$INVG4" = "YES" ]; then
      echo "Thanks for the GLOC. Here are your 1000 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} GLOC ${BOLD}"
      $(perl -p -i -e 's/GLOC=YES'/'GLOC=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 1000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a GLOC, moron."
      exit 0
    fi
  fi

  if [ "$2" = "4" ]; then
    if [ "$INVG5" = "YES" ]; then
      echo "Thanks for the 44Magnum. Here are your 1500 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} 44 Magnum ${BOLD}"
      $(perl -p -i -e 's/44MAGNUM=YES'/'44MAGNUM=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 1500 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a 44Magnum, moron."
      exit 0
    fi
  fi

  if [ "$2" = "5" ]; then
    if [ "$INVG6" = "YES" ]; then
      echo "Thanks for the Shotgun. Here are your 2000 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} Shotgun ${BOLD}"
      $(perl -p -i -e 's/SHOTGUN=YES'/'SHOTGUN=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 2000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a shotgun, moron."
      exit 0
    fi
  fi

  if [ "$2" = "6" ]; then
    if [ "$INVG7" = "YES" ]; then
      echo "Thanks for the UZI. Here are your 3000 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} UZI ${BOLD}"
      $(perl -p -i -e 's/UZI=YES'/'UZI=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 3000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a UZI, moron."
      exit 0
    fi
  fi

  if [ "$2" = "7" ]; then
    if [ "$INVG8" = "YES" ]; then
      echo "Thanks for the AK45. Here are your 3500 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} AK45 ${BOLD}"
      $(perl -p -i -e 's/AK45=YES'/'AK45=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 3500 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a AK45, moron."
      exit 0
    fi
  fi

  if [ "$2" = "8" ]; then
    if [ "$INVG9" = "YES" ]; then
      echo "Thanks for the Minigun. Here are your 4000 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} Minigun ${BOLD}"
      $(perl -p -i -e 's/MINIGUN=YES'/'MINIGUN=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 4000 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a Minigun, moron."
      exit 0
    fi
  fi

  if [ "$2" = "9" ]; then
    if [ "$INVG10" = "YES" ]; then
      echo "Thanks for the RocketLauncher. Here are your 4500 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} RocketLauncher ${BOLD}"
      $(perl -p -i -e 's/ROCKETLAUNCHER=YES'/'ROCKETLAUNCHER=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 4500 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a RocketLauncher, moron."
      exit 0
    fi
  fi

  if [ "$2" = "10" ]; then
    if [ "$INVG11" = "YES" ]; then
      echo "Thanks for the NukeLauncher. Here are your 7500 dollars"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} sells his${BOLD} NukeLauncher ${BOLD}"
      $(perl -p -i -e 's/NUKELAUNCHER=YES'/'NUKELAUNCHER=NO/gi' `ls $USERDATA/$USER.frags`)
      SELLKB="$(expr 7500 \* 1024)"
      NEWCREDSKB="$(expr $USERCREDSKB \+ $SELLKB)"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      exit 0
    else
      echo "You don't own a NukeLauncher, moron."
      exit 0
    fi
  fi
  echo "What are you trying to do???"
  echo "There is no hacking in Turranius's scripts! [DELUSER!]"
  exit 0
fi


## Challenge sequence

if [ "$1" = "attack" ]; then
  if [ -e $USERDATA/$USER.frags ]; then
    USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
    USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
  else
    echo "You dont even have a gunlicense, lamo. Sign up for one."
    exit 0
  fi

  INVG1="$(cat $USERDATA/$USER.frags | grep SLINGSHOT | awk -F"=" '{print $2}')"
  INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
  INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
  INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
  INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
  INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
  INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
  INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
  INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
  INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
  INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"

  if [ "$2" = "" ]; then
    echo "You must specify who you want to attack!"
    exit 0
  else
    if [ "$2" = "$USER" ]; then
      echo "You challenge yourself and win and loose at the same time."
      echo "Good work!"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} attacks himself.. and looses."
      exit 0
    fi
 
    if [ -f $TEMPPATH/frags_$2 ]; then
      echo "That user has already been challenged. Get in line."
      exit 0
    fi

    if [ -e $USERDATA/$2.frags ]; then
      if [ "$3" = "" ]; then
        echo "Please also specify what weapon you wish to use."
        if [ "$INVG1" = "YES" ]; then
          echo "0: Slingshot"
        fi
        if [ "$INVG2" = "YES" ]; then
          echo "1: Colt 22mm"
        fi
        if [ "$INVG3" = "YES" ]; then
          echo "2: Colt45mm"
        fi
        if [ "$INVG4" = "YES" ]; then
          echo "3: GLOC"
        fi
        if [ "$INVG5" = "YES" ]; then
          echo "4: 44 Magnum"
        fi
        if [ "$INVG6" = "YES" ]; then
          echo "5: Shotgun"
        fi
        if [ "$INVG7" = "YES" ]; then
          echo "6: UZI"
        fi
        if [ "$INVG8" = "YES" ]; then
          echo "7: AK45"
        fi
        if [ "$INVG9" = "YES" ]; then
          echo "8: Minigun"
        fi
        if [ "$INVG10" = "YES" ]; then
          echo "9: RocketLauncher"
        fi
        if [ "$INVG11" = "YES" ]; then
          echo "10: NukeLauncher"
        fi
        exit 0
      else
        if [ "$3" = "0" ]; then
          if [ "$INVG1" = "YES" ]; then
            echo "Gun selected: Slingshot"
            GUN="Slingshot"
          else
            echo "You dont own a Slingshot, moron."
            exit 0
          fi          
        fi 
        if [ "$3" = "1" ]; then
          if [ "$INVG2" = "YES" ]; then
            echo "Gun selected: Colt 22mm"
            GUN="Ccolt22"
          else
            echo "You dont own a Colt 22mm, moron."
            exit 0
          fi          
        fi 
        if [ "$3" = "2" ]; then
          if [ "$INVG3" = "YES" ]; then
            echo "Gun selected: Colt 45mm"
            GUN="Colt45"
          else
            echo "You dont own a Colt 45mm, moron."
            exit 0
          fi          
        fi 
        if [ "$3" = "3" ]; then
          if [ "$INVG4" = "YES" ]; then
            echo "Gun selected: GLOC"
            GUN="GLOC"
          else
            echo "You dont own a GLOC, moron."
            exit 0
          fi          
        fi 
        if [ "$3" = "4" ]; then
          if [ "$INVG5" = "YES" ]; then
            echo "Gun selected: 44 Magnum"
            GUN="44Magnum"
          else
            echo "You dont own a 44 Magnum, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "5" ]; then
          if [ "$INVG6" = "YES" ]; then
            echo "Gun selected: Shotgun"
            GUN="Shotgun"
          else
            echo "You dont own a Shotgun, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "6" ]; then
          if [ "$INVG7" = "YES" ]; then
            echo "Gun selected: UZI"
            GUN="UZI"          
          else
            echo "You dont own a UZI, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "7" ]; then
          if [ "$INVG8" = "YES" ]; then
            echo "Gun selected: AK45"
            GUN="AK45"
          else
            echo "You dont own a AK45, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "8" ]; then
          if [ "$INVG9" = "YES" ]; then
            echo "Gun selected: Minigun"
            GUN="Minigun"
          else
            echo "You dont own a Minigun, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "9" ]; then
          if [ "$INVG10" = "YES" ]; then
            echo "Gun selected: Rocket Launcher"
            GUN="RocketLauncher"
          else
            echo "You dont own a Rocket Launcher, moron."
            exit 0
          fi          
        fi
        if [ "$3" = "10" ]; then
          if [ "$INVG11" = "YES" ]; then
            echo "Gun selected: Nuke Launcher"
            GUN="NukeLauncher"
          else
            echo "You dont own a Nuke Launcher, moron."
            exit 0
          fi          
        fi
        if [ "$GUN" = "" ]; then
          echo "Gun selected: Your penis!! Now get out. Screw you guys. I'm going home!"
          exit 0
        fi

        if [ "$4" = "" ]; then
          echo "You must also choose how many dollars you wish to challenge him for."
          USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
          USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
          OPCREDSKB="$(cat $USERPATH/$2 | grep CREDITS | awk -F" " '{print $2}')"
          OPCREDSMB="$(expr $OPCREDSKB \/ 1024)"
          echo "You have $USERCREDSMB dollars"
          echo "Your opponent has $OPCREDSMB dollars"
          exit 0
        else
          if [ "$4" -lt "500" ]; then
            echo "Sorry, minimum amount to fight for is 500 dollars."
            exit 0
          fi
          # echo "checking if both have creds, then go"
          USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
          USERCREDSMB="$(expr $USERCREDSKB \/ 1024)"
          OPCREDSKB="$(cat $USERPATH/$2 | grep CREDITS | awk -F" " '{print $2}')"
          OPCREDSMB="$(expr $OPCREDSKB \/ 1024)"
          if [ $4 -gt $USERCREDSMB ]; then
            echo "Heh, you can't afford that fight, shithead."
            exit 0
          fi
          if [ $4 -gt $OPCREDSMB ]; then
            echo "Pick on someone your own size! That poor jerkoff can't afford it."
            exit 0
          fi
          echo "$USER pulls out his $GUN and tells $2 '$4 dollars says I'll kick yo ass!'"
          #MESSAGE="$($BINFOLDER/randomit 1 5)"

          LOW=1
          HIGH=5
          proc_random
          MESSAGE="$number"


          if [ "$MESSAGE" = "1" ]; then
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} wants a shootout with ${BOLD}$2${BOLD} for ${BOLD}$4${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "2" ]; then
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} has ${BOLD}$4${BOLD} Dollars that says he can beat ${BOLD}$2${BOLD} to a bloody pulp!"
          fi
          if [ "$MESSAGE" = "3" ]; then
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} tells ${BOLD}$2${BOLD}: 'Yo moma!', then slaps him with ${BOLD}$4${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "4" ]; then
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} suggests a friendly match against ${BOLD}$2${BOLD} for ${BOLD}$4${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "5" ]; then
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} cocks his gun and gets ready for a fight with ${BOLD}$2${BOLD} for ${BOLD}$4${BOLD} Dollars."
          fi

          echo "$USER $GUN $4" >> $TEMPPATH/frags_$2

          echo "From: Frags Fight System (`date "+%a %b %e %T %Y"`)" >> $MSGDIR/$2
          echo "--------------------------------------------------------------------------" >> $MSGDIR/$2
          echo "$USER requested a fight for $4 Dollars" >> $MSGDIR/$2
          echo "To accept, type 'site frags accept $USER' and it will lead your through it." >> $MSGDIR/$2
          echo "To decline, type' site frags decline'." >> $MSGDIR/$2
          echo " " >> $MSGDIR/$2
          exit 0
        fi
      fi   
    fi
  fi
  echo "User does not exist, or havent signed up for FRAGS."
  exit 0
fi


## Accept challence section

if [ "$1" = "accept" ]; then
  if [ "$2" = "$USER" ]; then
    echo "You accept yourself and win and loose at the same time."
    echo "Good work!"
    exit 0
  fi

  if [ -f $TEMPPATH/frags_$USER ]; then
    CHALNAME="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $1}')"
    CHALGUN="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $2}')"
    CHALMB="$(cat $TEMPPATH/frags_$USER | awk -F" " '{print $3}')"
    echo "$CHALNAME has challenged you to FRAGS for $CHALMB dollars!"
    if [ "$2" != $CHALNAME ]; then
      echo "Type site frags accept $CHALNAME"
      exit 0
    fi
    if [ "$3" = "" ]; then
      echo "To accept, type site frags accept $CHALNAME <Gun to use>."
      echo "possible guns are:"
      INVG1="$(cat $USERDATA/$USER.frags | grep SLINGSHOT | awk -F"=" '{print $2}')"
      INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
      INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
      INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
      INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
      INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
      INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
      INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
      INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
      INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
      INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"
      if [ "$INVG1" = "YES" ]; then
        echo "0: Slingshot"
      fi
      if [ "$INVG2" = "YES" ]; then
        echo "1: Colt 22mm"
      fi
      if [ "$INVG3" = "YES" ]; then
        echo "2: Colt45mm"
      fi
      if [ "$INVG4" = "YES" ]; then
        echo "3: GLOC"
      fi
      if [ "$INVG5" = "YES" ]; then
        echo "4: 44 Magnum"
      fi
      if [ "$INVG6" = "YES" ]; then
        echo "5: Shotgun"
      fi
      if [ "$INVG7" = "YES" ]; then
        echo "6: UZI"
      fi
      if [ "$INVG8" = "YES" ]; then
        echo "7: AK45"
      fi
      if [ "$INVG9" = "YES" ]; then
        echo "8: Minigun"
      fi
      if [ "$INVG10" = "YES" ]; then
        echo "9: RocketLauncher"
      fi
      if [ "$INVG11" = "YES" ]; then
        echo "10: NukeLauncher"
      fi
      exit 0
    else
      INVG1="$(cat $USERDATA/$USER.frags | grep SLINGSHOT | awk -F"=" '{print $2}')"
      INVG2="$(cat $USERDATA/$USER.frags | grep COLT22 | awk -F"=" '{print $2}')"
      INVG3="$(cat $USERDATA/$USER.frags | grep COLT45 | awk -F"=" '{print $2}')"
      INVG4="$(cat $USERDATA/$USER.frags | grep GLOC | awk -F"=" '{print $2}')"
      INVG5="$(cat $USERDATA/$USER.frags | grep 44MAGNUM | awk -F"=" '{print $2}')"
      INVG6="$(cat $USERDATA/$USER.frags | grep SHOTGUN | awk -F"=" '{print $2}')"
      INVG7="$(cat $USERDATA/$USER.frags | grep UZI | awk -F"=" '{print $2}')"
      INVG8="$(cat $USERDATA/$USER.frags | grep AK45 | awk -F"=" '{print $2}')"
      INVG9="$(cat $USERDATA/$USER.frags | grep MINIGUN | awk -F"=" '{print $2}')"
      INVG10="$(cat $USERDATA/$USER.frags | grep ROCKETLAUNCHER | awk -F"=" '{print $2}')"
      INVG11="$(cat $USERDATA/$USER.frags | grep NUKELAUNCHER | awk -F"=" '{print $2}')"
      if [ "$3" = "0" ]; then
        if [ "$INVG1" = "YES" ]; then
          echo "Gun selected: Slingshot"
          GUN="Slingshot"
        else
          echo "You dont own a Slingshot, moron."
          exit 0
        fi          
      fi 
      if [ "$3" = "1" ]; then
        if [ "$INVG2" = "YES" ]; then
          echo "Gun selected: Colt 22mm"
          GUN="Colt22"
        else
          echo "You dont own a Colt 22mm, moron."
          exit 0
        fi          
      fi 
      if [ "$3" = "2" ]; then
        if [ "$INVG3" = "YES" ]; then
          echo "Gun selected: Colt 45mm"
          GUN="Colt45"
        else
          echo "You dont own a Colt 45mm, moron."
          exit 0
        fi          
      fi 
      if [ "$3" = "3" ]; then
        if [ "$INVG4" = "YES" ]; then
          echo "Gun selected: GLOC"
          GUN="GLOC"
        else
          echo "You dont own a GLOC, moron."
          exit 0
        fi          
      fi 
      if [ "$3" = "4" ]; then
        if [ "$INVG5" = "YES" ]; then
          echo "Gun selected: 44 Magnum"
          GUN="44Magnum"
        else
          echo "You dont own a 44 Magnum, moron."
          exit 0
        fi          
      fi
      if [ "$3" = "5" ]; then
        if [ "$INVG6" = "YES" ]; then
          echo "Gun selected: Shotgun"
          GUN="Shotgun"
        else
          echo "You dont own a Shotgun, moron."
         exit 0
        fi          
      fi
      if [ "$3" = "6" ]; then
        if [ "$INVG7" = "YES" ]; then
          echo "Gun selected: UZI"
          GUN="UZI"          
        else
          echo "You dont own a UZI, moron."
          exit 0
        fi          
      fi
      if [ "$3" = "7" ]; then
        if [ "$INVG8" = "YES" ]; then
          echo "Gun selected: AK45"
          GUN="AK45"
        else
          echo "You dont own a AK45, moron."
          exit 0
        fi          
      fi
      if [ "$3" = "8" ]; then
        if [ "$INVG9" = "YES" ]; then
          echo "Gun selected: Minigun"
          GUN="Minigun"
        else
          echo "You dont own a Minigun, moron."
          exit 0
        fi          
      fi
      if [ "$3" = "9" ]; then
        if [ "$INVG10" = "YES" ]; then
          echo "Gun selected: Rocket Launcher"
          GUN="RocketLauncher"
        else
          echo "You dont own a Rocket Launcher, moron."
          exit 0
        fi          
      fi
      if [ "$3" = "10" ]; then
        if [ "$INVG11" = "YES" ]; then
          echo "Gun selected: Nuke Launcher"
          GUN="NukeLauncher"
        else
          echo "You dont own a Nuke Launcher, moron."
          exit 0
        fi          
      fi
      if [ "$GUN" = "" ]; then
        echo "Gun selected: Your penis!! Now get out. Screw you guys. I'm going home!"
        exit 0
      fi
 
      if [ -f $LOCKFILE ]; then
        echo "Someone else is already being killed. Please wait your turn!"
        exit 0
      fi
      CHALHP="$(cat $USERDATA/$CHALNAME.frags | grep HITPOINTS | awk -F" " '{print $2}')"
      USERHP="$(cat $USERDATA/$USER.frags | grep HITPOINTS | awk -F" " '{print $2}')"     
      #checkdamageonguns
      CHALDMG="error"
      USERDMG="error"
      if [ $CHALGUN = "Slingshot" ]; then
        CHALDMG="5 20"
      fi
      if [ $CHALGUN = "Colt22" ]; then
        CHALDMG="9 25"
      fi
      if [ $CHALGUN = "Colt45" ]; then
        CHALDMG="10 35"
      fi
      if [ $CHALGUN = "GLOC" ]; then
        CHALDMG="20 45"
      fi
      if [ $CHALGUN = "44Magnum" ]; then
        CHALDMG="25 50"
      fi
      if [ $CHALGUN = "Shotgun" ]; then
        CHALDMG="30 60"
      fi
      if [ $CHALGUN = "UZI" ]; then
        CHALDMG="40 70"
      fi
      if [ $CHALGUN = "AK45" ]; then
        CHALDMG="45 80"
      fi
      if [ $CHALGUN = "Minigun" ]; then
        CHALDMG="55 90"
      fi
      if [ $CHALGUN = "RocketLauncher" ]; then
        CHALDMG="80 100"
      fi
      if [ $CHALGUN = "NukeLauncher" ]; then
        CHALDMG="120 400"
      fi
      if [ "$CHALDMG" = "error" ]; then
        echo "Hm, bug. Cant check CHALDMG."
        exit 0
      fi
      #echo "$CHALNAME's damage is $CHALDMG"
      if [ $GUN = "Slingshot" ]; then
        USERDMG="5 20"
      fi
      if [ $GUN = "Colt22" ]; then
        USERDMG="9 25"
      fi
      if [ $GUN = "Colt45" ]; then
        USERDMG="10 35"
      fi
      if [ $GUN = "GLOC" ]; then
        USERDMG="20 45"
      fi
      if [ $GUN = "44Magnum" ]; then
        USERDMG="25 50"
      fi
      if [ $GUN = "Shotgun" ]; then
        USERDMG="30 60"
      fi
      if [ $GUN = "UZI" ]; then
        USERDMG="40 70"
      fi
      if [ $GUN = "AK45" ]; then
        USERDMG="45 80"
      fi
      if [ $GUN = "Minigun" ]; then
        USERDMG="55 90"
      fi
      if [ $GUN = "RocketLauncher" ]; then
        USERDMG="80 100"
      fi
      if [ $GUN = "NukeLauncher" ]; then
        USERDMG="120 400"
      fi
      if [ "$DMG" = "error" ]; then
        echo "Hm, bug. Cant check USERDMG."
        exit 0
      fi
      touch $LOCKFILE

      ## Check the time since it was last run.
      currenttime=`date +%s`
      if [ -e /tmp/fragstime_$USER ]; then
      lasttime=`cat /tmp/fragstime_$USER`
      lasttime=`expr $lasttime / 60`
      currenttime=`expr $currenttime / 60`
      delayedtime=`expr $currenttime - $lasttime`
        if [ `expr $delayedtime "<=" 59` = 1 ] ; then
          x=60
          delayedtime=$[x - $delayedtime ]
          echo "You can only book the arena once every 60 minutes. You reservation isnt for another $delayedtime minutes."
          echo "Use 'site frags inv' to keep updated."
          rm -f $LOCKFILE
          exit 0
        fi
      fi

      USERGUN=$GUN
      USERNAME=$USER
      echo "Get ready for FRAGS! -$CHALNAME- [$CHALHP HitPoints, $CHALGUN - $CHALDMG] vs -$USER- [$USERHP HitPoints, $USERGUN - $USERDMG] for $CHALMB Dollar!"
      proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} pulls out his $USERGUN and tells $CHALNAME to bring it on!"
      sleep 2
      proc_output "${BOLD}-(FRAGS-FULL)- $CHALNAME${BOLD} ($CHALHP HP, $CHALGUN) vs ${BOLD}$USER${BOLD} ($USERHP HP, $USERGUN) for ${BOLD}$CHALMB${BOLD} Dollars!"
      sleep 3
      
      WINNER="0"
      ROUND="0"
 
      while [ "$WINNER" = "0" ]; do
           
        if [ "$USERHP" -lt "1" ]; then
          WINNER=$CHALNAME
          LOOSER=$USER
          LOOSERHP=$USERHP
        else
          #USERMISS="$($BINFOLDER/randomit 0 100)"

          LOW=0
          HIGH=100
          proc_random
          USERMISS="$number"

          if [ "$USERMISS" -gt "70" ]; then
            echo "$USER tries to shoot $CHALNAME, but $CHALNAME ducks!"
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} tries to shoot $CHALNAME, but $CHALNAME ducks!"
          else
            #CHALHIT="$($BINFOLDER/randomit $USERDMG)"

            LOW="`echo "$USERDMG" | cut -d ' ' -f1`"
            HIGH="`echo "$USERDMG" | cut -d ' ' -f2`"
            proc_random
            CHALHIT="$number"

            CHALHP="$(expr $CHALHP \- $CHALHIT)"
            echo "$USER shoots $CHALNAME for $CHALHIT Damage! $CHALNAME is at $CHALHP HitPoints."
            proc_output "${BOLD}-(FRAGS-FULL)- $USER${BOLD} shoots $CHALNAME for ${BOLD}$CHALHIT${BOLD} Damage. $CHALNAME has $CHALHP HP left"
          fi
        fi

        if [ "$WINNER" = "0" ]; then   
          sleep 2

          if [ "$CHALHP" -lt "1" ]; then
            WINNER=$USER
            LOOSER=$CHALNAME
            LOOSERHP=$CHALHP
          else
            #CHALMISS="$($BINFOLDER/randomit 0 100)"

            LOW="0"
            HIGH="100"
            proc_random
            CHALMISS="$number"

            if [ "$CHALMISS" -gt "70" ]; then
              echo "$CHALNAME tries to shoot $USER, but missed!"
              proc_output "${BOLD}-(FRAGS-FULL)- $CHALNAME${BOLD} tries to shoot $USER, but misses badly."
            else
              #USERHIT="$($BINFOLDER/randomit $CHALDMG)"
        
              LOW="`echo "$CHALDMG" | cut -d ' ' -f1`"
              HIGH="`echo "$CHALDMG" | cut -d ' ' -f2`"
              proc_random
              USERHIT="$number"

              USERHP="$(expr $USERHP \- $USERHIT)"
              echo "$CHALNAME shoots $USER for $USERHIT Damage! $USER is at $USERHP HitPoints."
              proc_output "${BOLD}-(FRAGS-FULL)- $CHALNAME${BOLD} shoots $USER for ${BOLD}$USERHIT${BOLD} Damage. $USER has $USERHP HP left"
            fi
          fi
          sleep 2
        fi

        if [ "$ROUND" = "6" ]; then
          if [ "$USERHP" -gt "$CHALHP" ]; then
            WINNER=$USER
            LOOSER=$CHALNAME
            LOOSERHP=$CHALHP
          else
            WINNER=$CHALNAME
            LOOSER=$USER
            LOOSERHP=$USERHP
          fi
        echo "Judges break off the fight and claims $WINNER to be the winner."
        proc_output "${BOLD}-(FRAGS-FULL)-${BOLD} Judges cuts this fight short and proclaims ${BOLD}$WINNER${BOLD} to be the winner."
        else     
          ROUND="$(expr $ROUND \+ 1)"
        fi

        if [ -f $TEMPPATH/fragssnipe_$USER ]; then
          if [ "$CHALMB" -lt "1001" ]; then
            SNIPER="$(cat $TEMPPATH/fragssnipe_$USER)"
            if [ "$SNIPER" != "$CHALNAME" ]; then
              rm -f $TEMPPATH/fragssnipe_$USER
              SNIPED="1"
              #SNIPEDMG="$($BINFOLDER/randomit 30 80)"

              LOW="30"
              HIGH="80"
              proc_random
              SNIPEDMG="$number"

              echo "You never see $SNIPER on the hill. Too bad for you! Blammo"
              proc_output "${BOLD}-(FRAGS-FULL)- ${BOLD}Suddenly ${BOLD}$SNIPER${BOLD} crawls up from a hole and SNIPES ${BOLD}$USER${BOLD} for ${BOLD}$SNIPEDMG${BOLD} damage."
              USERHP="$(expr $USERHP \- $SNIPEDMG)"
              if [ "$USERHP" -lt "1" ]; then
                WINNER=$CHALNAME
                LOOSER=$USER
                LOOSERHP=$USERHP
              fi              
            fi
          fi
        fi

        if [ -f $TEMPPATH/fragssnipe_$CHALNAME ]; then
          if [ "$CHALMB" -lt "1001" ]; then
            SNIPER="$(cat $TEMPPATH/fragssnipe_$CHALNAME)"
            if [ "$SNIPER" != "$USER" ]; then
              sleep 2
              #SNIPEDMG="$($BINFOLDER/randomit 30 80)"

              LOW="30"
              HIGH="80"
              proc_random
              SNIPEDMG="$number"

              rm -f $TEMPPATH/fragssnipe_$CHALNAME
              if [ "$SNIPED" = "1" ]; then
                echo "Another sniper jumps up! $SNIPER snipes $CHALNAME too!"
                proc_output "${BOLD}-(FRAGS-FULL)- ${BOLD}A second later, ${BOLD}$CHALNAME${BOLD} is sniped by ${BOLD}$SNIPER${BOLD} for ${BOLD}$SNIPEDMG${BOLD} damage"
                CHALHP="$(expr $CHALHP \- $SNIPEDMG)"
                if [ "$CHALHP" -lt "1" ]; then
                  if [ "$USERHP" -lt "1" ]; then
                    echo "Both fighters down. Game ends in a draw!"
                    proc_output "${BOLD}-(FRAGS-FULL)- ${BOLD}Both fighters are dead. Game ends in a draw!"
                    rm -f $TEMPPATH/frags_$USER
                    rm -f $LOCKFILE
                    exit 0
                  fi
                fi
              else
                echo "You notice $SNIPER on the hill. He snipes $CHALNAME! Blammo"
                proc_output "${BOLD}-(FRAGS-FULL)- ${BOLD}Suddenly ${BOLD}$SNIPER${BOLD} crawls up from behind a hill and SNIPES ${BOLD}$CHALNAME for $SNIPEDMG damage"
                CHALHP="$(expr $CHALHP \- $SNIPEDMG)"
                if [ "$CHALHP" -lt "1" ]; then
                  WINNER=$USER
                  LOOSER=$CHALNAME
                  LOOSERHP=$CHALHP
                fi
              fi
            fi
          fi
        fi

      done

      echo "$WINNER WINS!"
        if [ $LOOSERHP -lt "-40" ]; then
          echo "$LOOSER's body vaporizes from the blast!"
          proc_output "${BOLD}-(FRAGS-FULL)- $WINNER WINS!${BOLD} $LOOSER is FRAGGED! "
          SPLAT="1"
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "-20" ]; then
            echo "$LOOSER's brain splatters all over the site!"
            proc_output "${BOLD}-(FRAGS-FULL)- $WINNER WINS!${BOLD} $LOOSER's brain splatters all over the chan."
            SPLAT="1"
          fi
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "-10" ]; then
            echo "$LOOSER lost his life, and a few limbs there!"
            proc_output "${BOLD}-(FRAGS-FULL)- $WINNER WINS!${BOLD} $LOOSER lost one or two limbs there."
            SPLAT="1"
          fi
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "1" ]; then
            echo "$LOOSER falls down and bleeds to death."
            proc_output "${BOLD}-(FRAGS-FULL)- $WINNER WINS!${BOLD} $LOOSER drowns in a pool of his own blood."
          fi
        fi

        ## Update the time when frags was last run. Comment out this line for no delay.
        echo `date +%s` > /tmp/fragstime_$USER

        CHALKB="$(expr $CHALMB \* 1024)"
        WINKB=$CHALKB
        WINMB=$CHALMB
        LOSKB=$CHALKB
        LOSMB=$CHALMB

        WINCREDSKB="$(cat $USERPATH/$WINNER | grep CREDITS | awk -F" " '{print $2}')"
        WINCREDSMB="$(expr $WINCREDSKB \/ 1024)"
        LOSCREDSKB="$(cat $USERPATH/$LOOSER | grep CREDITS | awk -F" " '{print $2}')"
        LOSCREDSMB="$(expr $LOSCREDSKB \/ 1024)"
        NEWWINCREDSKB="$(expr $CHALKB \+ $WINCREDSKB)"

        INSURANCE="$(cat $USERDATA/$LOOSER.frags | grep INSURANCE | awk -F"=" '{print $2}')"
        if [ "$INSURANCE" = "YES" ]; then
          sleep 2
          #INSURERATE="$($BINFOLDER/randomit 1 8)"

          LOW="1"
          HIGH="8"
          proc_random
          INSURERATE="$number"

          INSURERATEDISPLAY="$(expr $INSURERATE \* 10)"
          echo "Insurance kicks in for $LOOSER at $INSURERATEDISPLAY %"
          proc_output "${BOLD}-(FRAGS-FULL)- ${BOLD}Insurance kicks in for ${BOLD}$LOOSER${BOLD} at ${BOLD}$INSURERATEDISPLAY${BOLD} %"

          PERCENT="$(echo $LOSKB*0.$INSURERATE | $BINFOLDER/bc | awk -F"." '{print $1}')"
          LOSKB="$(expr $LOSKB \- $PERCENT)"
          LOSMB="$(expr $LOSKB \/ 1024)"        
          NEWLOSCREDSKB="$(expr $LOSCREDSKB \- $LOSKB)"
          $(perl -p -i -e 's/INSURANCE=YES'/'INSURANCE=NO/gi' `ls $USERDATA/$LOOSER.frags`)
        else
          NEWLOSCREDSKB="$(expr $LOSCREDSKB \- $CHALKB)"
        fi
        INSURANCE="$(cat $USERDATA/$WINNER.frags | grep INSURANCE | awk -F"=" '{print $2}')"
        if [ "$INSURANCE" = "YES" ]; then
          $(perl -p -i -e 's/INSURANCE=YES'/'INSURANCE=NO/gi' `ls $USERDATA/$WINNER.frags`)
        fi

        LOSSHP="$(cat $USERDATA/$LOOSER.frags | grep HITPOINTS | awk -F" " '{print $2}')"
        if [ "$LOSSHP" -gt "105" ]; then
          NEWLOSHP="$(expr $LOSSHP \- 5)"
          $(perl -p -i -e 's/HITPOINTS '$LOSSHP'/HITPOINTS '$NEWLOSHP'/gi' `ls $USERDATA/$LOOSER.frags`)          
        fi

        sed -e "s/^CREDITS.*/CREDITS $NEWWINCREDSKB/" $USERPATH/$WINNER > $USERFILETMP
        mv -f $USERFILETMP $USERPATH/$WINNER
        sleep 1
        sed -e "s/^CREDITS.*/CREDITS $NEWLOSREDSKB/" $USERPATH/$LOOSER > $USERFILETMP
        mv -f $USERFILETMP $USERPATH/$LOOSER
        #$(perl -p -i -e 's/CREDITS '$WINCREDSKB'/CREDITS '$NEWWINCREDSKB'/gi' `ls $USERPATH/$WINNER`)
        #$(perl -p -i -e 's/CREDITS '$LOSCREDSKB'/CREDITS '$NEWLOSCREDSKB'/gi' `ls $USERPATH/$LOOSER`)
        #echo "$WINNER's old creds: $WINCREDSKB - New creds: $NEWWINCREDSKB"
        #echo "$LOOSER's old creds: $LOSCREDSKB - New creds: $NEWLOSCREDSKB"
        touch $LOGFILE
        LOG="$(grep $WINNER $LOGFILE | awk -F" " '{print $2}')"
        if [ "$LOG" = "" ]; then
          echo "$WINNER 1" >> $LOGFILE
        else
          LOGNEW="$(expr $LOG + 1)"
          sed -e "s/^$WINNER.*/$WINNER $LOGNEW/" $LOGFILE > $LOGFILETMP
          mv -f $LOGFILETMP $LOGFILE
        fi
        LOG="$(grep $LOOSER $LOGFILE | awk -F" " '{print $2}')"
        if [ "$LOG" = "" ]; then
          echo "$LOOSER -1" >> $LOGFILE
        else
          LOGNEW="$(expr $LOG - 1)"
          sed -e "s/^$LOOSER.*/$LOOSER $LOGNEW/" $LOGFILE > $LOGFILETMP
          mv -f $LOGFILETMP $LOGFILE
        fi
        rm -f $TEMPPATH/frags_$USER
        rm -f $LOCKFILE
        exit 0
      fi
    else
      echo "You dont have anyone challenging you."
      exit 0
    fi
  exit 0
fi

echo "FRAGS: Unknown command $1"
exit 0
     