#!/bin/bash
VER=1.0

USERPATH=/ftp-data/users
LOCKFILE=/tmp/fragslight.lock
LOGFILE=/ftp-data/logs/fragslight.log
GLLOGFILE=/ftp-data/logs/games.log
NODELAYPASS=onlycoolppl
TEMPPATH=/tmp
USERFILETMP=/tmp/$USER.fragslighttmp
LOGFILETMP=/tmp/log.fragslighttmp
BINFOLDER=/bin
MSGDIR=/ftp-data/msgs

MINBET="500"

CHALHP="100"
USERHP="100"     
CHALDMGLOW="10"
CHALDMGHIGH="40"
USERDMGLOW="10"
USERDMGHIGH="40"

SNIPEDMGLOW="10"
SNIPEDMGHIGH="30"


#--[ Script Start ]--#

proc_output() {
  echo `date "+%a %b %e %T %Y"` TURGEN: \""$@\"" >> $GLLOGFILE
}

BOLD=""
ULINE=""

## Random generator. Set LOW and HIGH first.
proc_random() {
  ## If the numbers are the same, just set it to the HIGH one...
  if [ "$LOW" = "$HIGH" ]; then
    number=$HIGH
  else
    number="-1"
    while [ "$number" -lt "$LOW" ]; do
      number="$RANDOM"
      if [ "$number" -gt "$HIGH" ]; then
        temphigh=$[$HIGH+1]
        let "number %= $temphigh"  # Scales $number down within $HIGH range.
      fi
    done
  fi
}

if [ -z $1 ]; then
  echo "                       Welcome to FRAGS                               "
  echo "----------------[ General information and rules ] --------------------"
  echo "Usage: site frags rules ------- Speaks for itself.                   "
  echo "Usage: site frags highscores -- Highscores of best and worst users.  "
  echo "                                                                      " 
  echo "------------------------[ Fight Section ]-----------------------------"
  echo "Usage: site frags attack ------ Challenge someone to fight!          "
  echo "Usage: site frags accept ------ Check if anyone has challenged you.  "
  echo "Usage: site frags chal -------- See all waiting challenges.          "
  echo "Usage: site frags decline ----- Decline any current challenge on you."
  echo "Usage: site frags cancel ------ Cancel all of challenges by you.     "
  echo "--------------------------------------------------by-Turranius--------"
  exit 0
fi

# Decline any challenge
if [ "$1" = "decline" ]; then
  CHALNAME="$(cat $TEMPPATH/fragslight_$USER | awk -F" " '{print $1}')"
  CHALMB="$(cat $TEMPPATH/fragslight_$USER | awk -F" " '{print $3}')"  
  if [ "$CHALNAME" = "" ]; then
    echo "Can't see that you got any current challenges."
    exit 0
  else
    rm -f $TEMPPATH/fragslight_$USER
    echo "You decline the challenge from $CHALNAME"
    proc_output "${BOLD}-(FRAGS)- $USER${BOLD} declines $CHALNAME's challenge"
    exit 0
  fi
  exit 0
fi

## Check Rules
if [ "$1" = "rules" ]; then
  echo ""
  echo "----------------------------------------------------------------"
  echo " Welcome to FRAGS.                                              "
  echo " What is FRAGS? Well, frags is like Quake in a way.             "
  echo " Minimum amount to gamble for is $MINBET Dollar. There is no upper"
  echo " limit, other than what you and your opponent currently have.   "
  echo "                                                                "
  echo " Once a fight starts, you will take one turn each trying to hit "
  echo " the opponent with your Colt 22's.                              "
  echo " You have $CHALHP HP to start with, and once it reaches 0, you are  "
  echo " dead. Judges will cut in if the fight should become too long.  "
  echo "                                                                "
  echo " Snipe those bastards! Using 'site frags snipe', you can rent  "
  echo " a sniper rifle and do ${SNIPEDMGLOW}-${SNIPEDMGHIGH} damage to a target of your choice. "
  echo " This does only work if the fightbet is no more than 1GB and    " 
  echo " you can't snipe anyone you are fighting yourself (obviously).  "
  echo " If you are fast, you can even snipe someone when they are in   "
  echo " the middle of the fight.                                       "
  echo "                                                                "
  echo " ----------------[ FRAGS was created by Turranius ]-------------"
  exit 0
fi

if [ "`echo "100 + 100" | bc -l`" != "200" ]; then
  echo "The binary 'bc' is not installed? Its needed."
  exit 1
fi

## SNIPER SECTION
if [ "$1" = "snipe" ]; then
  if [ "$2" = "$USER" ]; then
    echo "Try putting a gun to your face and pull the trigger instead"
    exit 0
  fi  
  if [ -z $2 ]; then
    echo "Also state who you want to snipe."
    echo "NOTE: The sniper rifle rent is 500 Dollars."
    echo "You will only snipe if the fight bet is less than 1GB"
    echo "and you cant snipe someone you are fighting yourself."
    echo "All sniper rifles are returned at midnight, used or not."
    exit 0
  else
    USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
    USERCREDSMB="$( echo "$USERCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
    if [ "$USERCREDSMB" -gt "500" ]; then
      COSTKB="$( echo "500 * 1024" | bc -l | cut -d '.' -f1 )"
      NEWCREDSKB="$( echo "$USERCREDSKB - $COSTKB" | bc -l | cut -d '.' -f1 )"
      sed -e "s/^CREDITS.*/CREDITS $NEWCREDSKB/" $USERPATH/$USER > $USERFILETMP
      mv -f $USERFILETMP $USERPATH/$USER
      echo "Ok, if $2 gets into a fight, you'll snipe his ass for ${SNIPEDMGLOW}-${SNIPEDMGHIGH} damage."
      echo "$USER" > $TEMPPATH/fragslightsnipe_$2
      exit 0
    else
      echo "You cant afford the sniper bullet chump."
      exit 0
    fi
  fi
exit 0
fi
  
# If the user gives the nodelaypass, delete his timer file.
if [ "$1" = "$NODELAYPASS" ]; then
  ## If a second variable is set, check if that is a user, and if so, reset that users timer.
  if [ "$2" != "" ]; then
    if [ -e $USERPATH/$2 ]; then
      echo "Admin password detected. Clearing timer for $2"
      proc_output "${BOLD}-(FRAGS)- $USER's${BOLD} grants ${BOLD}$2${BOLD} another round in the arena!"
      rm -f /tmp/fragslighttime_$2
      exit 0
    else
      echo "Cant clear timer for $2. No such user."
      exit 0
    fi
  else
    echo "Admin password detected. Clearing your timer."
    rm -f /tmp/fragslighttime_$USER
    exit 0
  fi
fi

## User selected to see highscores.
if [ "$1" = "highscores" ]; then
  echo "-----[ Highscore for FRAGS ]------"
  echo "User:    Win/Loose Ratio:         "
  cat $LOGFILE | sort -k 2,2 -n -r
  echo "----------------------------------"
  exit 0
fi

## Cancel your challenges.
if [ "$1" = "cancel" ]; then
  for i in `ls $TEMPPATH/fragslight_* -f -A`
  do
    CHALNAME="$(cat $i | awk -F" " '{print $1}')"
    NAME="$(echo $i | awk -F"_" '{print $2}')"
    if [ "$CHALNAME" = "$USER" ]; then
      echo "Cancelling you challenge to $NAME"
      rm -f $i
    fi
  done
  exit 0
fi


## Current awaiting challenges.
if [ "$1" = "chal" ]; then
  echo "-------------------[ Current Awaiting Challenges ]-----------------"
  for i in `ls $TEMPPATH/fragslight_* -f -A`
  do
    CHALNAME="$(cat $i | awk -F" " '{print $1}')"
    CHALMB="$(cat $i | awk -F" " '{print $2}')"
    i="$(echo $i | awk -F"_" '{print $2}')"
    if [ "$CHALNAME" != "DUMMY" ]; then
      echo "$CHALNAME has challenged $i, for $CHALMB Dollars."
    fi
  done
  echo "-----[ Note: All challenges are removed at midnight each day ]-----"
  exit 0
fi

## Challenge sequence

if [ "$1" = "attack" ]; then
  USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
  USERCREDSMB="$( echo "$USERCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
 
  if [ "$2" = "" ]; then
    echo "You must specify who you want to attack!"
    exit 0
  else
    if [ "$2" = "$USER" ]; then
      echo "You challenge yourself and win and loose at the same time."
      echo "Good work!"
      proc_output "${BOLD}-(FRAGS)- $USER${BOLD} attacks himself.. and looses!"
      exit 0
    fi
 
    if [ ! -f $USERPATH/$2 ]; then
      echo "User $2 was not found"
      exit 0
    fi

    if [ -f $TEMPPATH/fragslight_$2 ]; then
      echo "That user has already been challenged. Get in line."
      exit 0
    fi

    if [ -f $USERPATH/$2 ]; then
        if [ "$3" = "" ]; then
          echo "You must also choose how many dollars you wish to challenge him for."
          USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
          USERCREDSMB="$( echo "$USERCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          OPCREDSKB="$(cat $USERPATH/$2 | grep CREDITS | awk -F" " '{print $2}')"
          OPCREDSMB="$( echo "$OPCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          echo "You have $USERCREDSMB dollars"
          echo "Your opponent has $OPCREDSMB dollars"
          exit 0
        else
          if [ "`echo "$3" | grep "......"`" ]; then
            echo "Too many chars in bet."
            exit 0
          fi

          if [ "$3" -lt "$MINBET" ]; then
            echo "Sorry, minimum amount to fight for is $MINBET dollars."
            exit 0
          fi
          
          VALIDATE=$[$3*2]
          if [ "$VALIDATE" = "" ]; then
            echo "Seems to be a problem with your bet. Did you use dots?"
            exit 0
          fi

          # echo "checking if both have creds, then go"
          USERCREDSKB="$(cat $USERPATH/$USER | grep CREDITS | awk -F" " '{print $2}')"
          USERCREDSMB="$( echo "$USERCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          OPCREDSKB="$(cat $USERPATH/$2 | grep CREDITS | awk -F" " '{print $2}')"
          OPCREDSMB="$( echo "$OPCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          if [ $3 -gt $USERCREDSMB ]; then
            echo "Heh, you can't afford that fight, shithead."
            exit 0
          fi
          if [ $3 -gt $OPCREDSMB ]; then
            echo "Pick on someone your own size! That poor jerkoff can't afford it."
            exit 0
          fi
          echo "$USER pulls out his gun and tells $2 '$3 dollars says I'll kick yo ass!'"
          #MESSAGE="$($BINFOLDER/randomit 1 5)"
          LOW=1
          HIGH=5
          proc_random
          MESSAGE="$number"

          if [ "$MESSAGE" = "1" ]; then
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} wants a shootout with ${BOLD}$2${BOLD} for ${BOLD}$3${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "2" ]; then
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} has ${BOLD}$3${BOLD} Dollars that says he can beat ${BOLD}$2${BOLD} to a bloody pulp!"
          fi
          if [ "$MESSAGE" = "3" ]; then
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} tells ${BOLD}$2${BOLD}: 'Yo moma!', then slaps him with ${BOLD}$3${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "4" ]; then
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} suggests a friendly match against ${BOLD}$2${BOLD} for ${BOLD}$3${BOLD} Dollars."
          fi
          if [ "$MESSAGE" = "5" ]; then
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} cocks his gun and gets ready for a fight with ${BOLD}$2${BOLD} for ${BOLD}$3${BOLD} Dollars."
          fi

          echo "$USER $3" >> $TEMPPATH/fragslight_$2

          echo "From: Frags Fight System (`date "+%a %b %e %T %Y"`)" >> $MSGDIR/$2
          echo "--------------------------------------------------------------------------" >> $MSGDIR/$2
          echo "$USER requested a fight for $3 Dollars" >> $MSGDIR/$2
          echo "To accept, type 'site frags accept $USER' and it will lead your through it." >> $MSGDIR/$2
          echo "To decline, type' site frags decline'." >> $MSGDIR/$2
          echo " " >> $MSGDIR/$2
          exit 0
        fi
      fi   
    fi
  exit 0
fi


## Accept challence section

if [ "$1" = "accept" ]; then
  if [ "$2" = "$USER" ]; then
    echo "You accept yourself and win and loose at the same time."
    echo "Good work!"
    exit 0
  fi

  if [ -f $TEMPPATH/fragslight_$USER ]; then
    CHALNAME="$(cat $TEMPPATH/fragslight_$USER | awk -F" " '{print $1}')"
    CHALMB="$(cat $TEMPPATH/fragslight_$USER | awk -F" " '{print $2}')"
    echo "$CHALNAME has challenged you to FRAGSLIGHT for $CHALMB dollars!"
    if [ "$2" != $CHALNAME ]; then
      echo "Type site frags accept $CHALNAME"
      exit 0
    fi

    if [ -f $LOCKFILE ]; then
      echo "Another game is currently in progress. Try later"
      exit 0
    fi

    touch $LOCKFILE

      ## Check the time since it was last run.
      currenttime=`date +%s`
      if [ -e /tmp/fragslighttime_$USER ]; then
      lasttime=`cat /tmp/fragslighttime_$USER`
      lasttime=$[$lasttime/60]
      currenttime=$[$currenttime/60]
      delayedtime=$[$currenttime-$lasttime]
        if [ `expr $delayedtime "<=" 59` = 1 ] ; then
          x=60
          delayedtime=$[x - $delayedtime ]
          echo "You can only book the arena once every 60 minutes. You reservation isnt for another $delayedtime minutes."
          echo "Use 'site frags inv' to keep updated."
          rm -f $LOCKFILE
          exit 0
        fi
      fi

     USERNAME=$USER

     echo "Get ready for FRAGSLIGHT! -$CHALNAME- [$CHALHP HitPoints - $CHALDMG] vs -$USER- [$USERHP HitPoints - $USERDMG] for $CHALMB Dollar!"
      proc_output "${BOLD}-(FRAGS)- $USER${BOLD} pulls out his gun and tells $CHALNAME to bring it on!"
      sleep 2
      proc_output "${BOLD}-(FRAGS)- $CHALNAME${BOLD} vs ${BOLD}$USER${BOLD} for ${BOLD}$CHALMB${BOLD} Dollars!"
      sleep 2
      
      WINNER="0"
      ROUND="0"
 
      while [ "$WINNER" = "0" ]; do
           
        if [ "$USERHP" -lt "1" ]; then
          WINNER=$CHALNAME
          LOOSER=$USER
          LOOSERHP=$USERHP
        else
          #USERMISS="$($BINFOLDER/randomit 0 100)"
          LOW=0
          HIGH=100
          proc_random
          USERMISS="$number"

          if [ "$USERMISS" -gt "80" ]; then
            echo "$USER tries to shoot $CHALNAME, but $CHALNAME ducks!"
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} tries to shoot $CHALNAME, but $CHALNAME ducks!"
          else
            #CHALHIT="$($BINFOLDER/randomit $USERDMG)"
            LOW="$USERDMGLOW"
            HIGH="$USERDMGHIGH"
            proc_random
            CHALHIT="$number"

            CHALHP=$[$CHALHP-$CHALHIT]
            echo "$USER shoots $CHALNAME for $CHALHIT Damage! $CHALNAME is at $CHALHP HitPoints."
            proc_output "${BOLD}-(FRAGS)- $USER${BOLD} shoots $CHALNAME for ${BOLD}$CHALHIT${BOLD} Damage. $CHALNAME has $CHALHP HP left"
          fi
        fi

        if [ "$WINNER" = "0" ]; then   
          sleep 2

          if [ "$CHALHP" -lt "1" ]; then
            WINNER=$USER
            LOOSER=$CHALNAME
            LOOSERHP=$CHALHP
          else
            LOW=0
            HIGH=100
            proc_random
            CHALMISS="$number"

            if [ "$CHALMISS" -gt "70" ]; then
              echo "$CHALNAME tries to shoot $USER, but missed!"
              proc_output "${BOLD}-(FRAGS)- $CHALNAME${BOLD} tries to shoot $USER, but misses badly."
            else
              #USERHIT="$($BINFOLDER/randomit $CHALDMG)"

              LOW="$CHALDMGLOW"
              HIGH="$CHALDMGHIGH"
              proc_random
              USERHIT="$number"

              USERHP=$[$USERHP-$USERHIT]
              echo "$CHALNAME shoots $USER for $USERHIT Damage! $USER is at $USERHP HitPoints."
              proc_output "${BOLD}-(FRAGS)- $CHALNAME${BOLD} shoots $USER for ${BOLD}$USERHIT${BOLD} Damage. $USER has $USERHP HP left"
            fi
          fi
          sleep 2
        fi

        if [ "$ROUND" = "8" ]; then
          if [ "$USERHP" -gt "$CHALHP" ]; then
            WINNER=$USER
            LOOSER=$CHALNAME
            LOOSERHP=$CHALHP
          else
            WINNER=$CHALNAME
            LOOSER=$USER
            LOOSERHP=$USERHP
          fi
        echo "Judges break off the fight and claims $WINNER to be the winner."
        proc_output "${BOLD}-(FRAGS)-${BOLD} Judges cuts this fight short and proclaims ${BOLD}$WINNER${BOLD} to be the winner."
        else     
          ROUND=$[$ROUND+1]
        fi

        if [ -f $TEMPPATH/fragslightsnipe_$USER ]; then
          if [ "$CHALMB" -lt "1001" ]; then
            SNIPER="$(cat $TEMPPATH/fragslightsnipe_$USER)"
            if [ "$SNIPER" != "$CHALNAME" ]; then
              rm -f $TEMPPATH/fragslightsnipe_$USER
              SNIPED="1"
              #SNIPEDMG="$($BINFOLDER/randomit 10 30)"

              LOW="$SNIPEDMGLOW"
              HIGH="$SNIPEDMGHIGH"
              proc_random
              SNIPEDMG="$number"

              echo "You never see $SNIPER on the hill. Too bad for you! Blammo"
              proc_output "${BOLD}-(FRAGS)- ${BOLD}Suddenly ${BOLD}$SNIPER${BOLD} crawls up from a hole and SNIPES ${BOLD}$USER${BOLD} for ${BOLD}$SNIPEDMG${BOLD} damage."
              USERHP=$[$USERHP-$SNIPEDMG]
              if [ "$USERHP" -lt "1" ]; then
                WINNER=$CHALNAME
                LOOSER=$USER
                LOOSERHP=$USERHP
              fi              
            fi
          fi
        fi

        if [ -f $TEMPPATH/fragslightsnipe_$CHALNAME ]; then
          if [ "$CHALMB" -lt "1001" ]; then
            SNIPER="$(cat $TEMPPATH/fragslightsnipe_$CHALNAME)"
            if [ "$SNIPER" != "$USER" ]; then
              sleep 2
              #SNIPEDMG="$($BINFOLDER/randomit 10 30)"
              LOW=10
              HIGH=30
              proc_random
              SNIPEDMG="$number"

              rm -f $TEMPPATH/fragslightsnipe_$CHALNAME
              if [ "$SNIPED" = "1" ]; then
                echo "Another sniper jumps up! $SNIPER snipes $CHALNAME too!"
                proc_output "${BOLD}-(FRAGS)- ${BOLD}A second later, ${BOLD}$CHALNAME${BOLD} is sniped by ${BOLD}$SNIPER${BOLD} for ${BOLD}$SNIPEDMG${BOLD} damage"
                CHALHP=$[$CHALHP-$SNIPEDMG]
                if [ "$CHALHP" -lt "1" ]; then
                  if [ "$USERHP" -lt "1" ]; then
                    echo "Both fighters down. Game ends in a draw!"
                    proc_output "${BOLD}-(FRAGS)- ${BOLD}Both fighters are dead. Game ends in a draw!"
                    rm -f $TEMPPATH/fragslight_$USER
                    rm -f $LOCKFILE
                    exit 0
                  fi
                fi
              else
                echo "You notice $SNIPER on the hill. He snipes $CHALNAME! Blammo"
                proc_output "${BOLD}-(FRAGS)- ${BOLD}Suddenly ${BOLD}$SNIPER${BOLD} crawls up from behind a hill and SNIPES ${BOLD}$CHALNAME for $SNIPEDMG damage"
                CHALHP=$[$CHALHP-$SNIPEDMG]
                if [ "$CHALHP" -lt "1" ]; then
                  WINNER=$USER
                  LOOSER=$CHALNAME
                  LOOSERHP=$CHALHP
                fi
              fi
            fi
          fi
        fi

      done

      echo "$WINNER defeats $LOOSER!"
        if [ $LOOSERHP -lt "-40" ]; then
          echo "$LOOSER's body vaporizes from the blast!"
          proc_output "${BOLD}-(FRAGS)- $WINNER WINS!${BOLD} $LOOSER is FRAGGED! "
          SPLAT="1"
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "-20" ]; then
            echo "$LOOSER's brain splatters all over the site!"
            proc_output "${BOLD}-(FRAGS)- $WINNER WINS!${BOLD} $LOOSER's brain splatters all over the chan."
            SPLAT="1"
          fi
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "-10" ]; then
            echo "$LOOSER lost his life, and a few limbs there!"
            proc_output "${BOLD}-(FRAGS)- $WINNER WINS!${BOLD} $LOOSER lost one or two limbs there."
            SPLAT="1"
          fi
        fi
        if [ "$SPLAT" != "1" ]; then
          if [ $LOOSERHP -lt "1" ]; then
            echo "$LOOSER falls down and bleeds to death."
            proc_output "${BOLD}-(FRAGS)- $WINNER WINS!${BOLD} $LOOSER drowns in a pool of his own blood."
          fi
        fi

        ## Update the time when frags was last run. Comment out this line for no delay.
        #echo `date +%s` > /tmp/fragstime_$USER

        CHALKB="$( echo "$CHALMB * 1024" | bc -l | cut -d '.' -f1 )"
        WINKB=$CHALKB
        WINMB=$CHALMB
        LOSKB=$CHALKB
        LOSMB=$CHALMB

        #COPS="$($BINFOLDER/randomit 0 100)"
        LOW=0
        HIGH=100
        proc_random
        COPS="$number"

        if [ "$COPS" -lt "15" ]; then
          echo "Cops raid and confiscates the winnings from $WINNER."
          proc_output "${BOLD}-(FRAGS)- ${BOLD}Cops raid the arena and confiscates the winnings from ${BOLD}$WINNER${BOLD}."
          LOSCREDSKB="$(cat $USERPATH/$LOOSER | grep CREDITS | awk -F" " '{print $2}')"
          LOSCREDSMB="$( echo "$LOSCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          NEWLOSCREDSKB="$( echo "$LOSCREDSKB - $CHALKB" | bc -l | cut -d '.' -f1 )"
          sed -e "s/^CREDITS.*/CREDITS $NEWLOSCREDSKB/" $USERPATH/$LOOSER > $USERFILETMP
          mv -f $USERFILETMP $USERPATH/$LOOSER
        else
          WINCREDSKB="$(cat $USERPATH/$WINNER | grep CREDITS | awk -F" " '{print $2}')"
          WINCREDSMB="$( echo "$WINCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          LOSCREDSKB="$(cat $USERPATH/$LOOSER | grep CREDITS | awk -F" " '{print $2}')"
          LOSCREDSMB="$( echo "$LOSCREDSKB / 1024" | bc -l | cut -d '.' -f1 )"
          NEWWINCREDSKB="$( echo "$CHALKB + $WINCREDSKB" | bc -l | cut -d '.' -f1 )"
  	  NEWLOSCREDSKB="$( echo "$LOSCREDSKB - $CHALKB" | bc -l | cut -d '.' -f1 )"
          sed -e "s/^CREDITS.*/CREDITS $NEWWINCREDSKB/" $USERPATH/$WINNER > $USERFILETMP
          mv -f $USERFILETMP $USERPATH/$WINNER
          sleep 1
          sed -e "s/^CREDITS.*/CREDITS $NEWLOSCREDSKB/" $USERPATH/$LOOSER > $USERFILETMP
          mv -f $USERFILETMP $USERPATH/$LOOSER
        fi
 
        touch $LOGFILE
        LOG="$(grep $WINNER $LOGFILE | awk -F" " '{print $2}')"
        if [ "$LOG" = "" ]; then
          echo "$WINNER 1" >> $LOGFILE
        else
          LOGNEW=$[$LOG+1]
          sed -e "s/^$WINNER.*/$WINNER $LOGNEW/" $LOGFILE > $LOGFILETMP
          mv -f $LOGFILETMP $LOGFILE
        fi
        LOG="$(grep $LOOSER $LOGFILE | awk -F" " '{print $2}')"
        if [ "$LOG" = "" ]; then
          echo "$LOOSER -1" >> $LOGFILE
        else
          LOGNEW=$[$LOG-1]
          sed -e "s/^$LOOSER.*/$LOOSER $LOGNEW/" $LOGFILE > $LOGFILETMP
          mv -f $LOGFILETMP $LOGFILE
        fi
        rm -f $TEMPPATH/fragslight_$USER
        rm -f $LOCKFILE
        exit 0
      fi
    else
      echo "You dont have anyone challenging you."
      exit 0
    fi
  exit 0
fi

echo "FRAGSLIGHT: Unknown command $1"
exit 0
     