#!/bin/bash
VER=1.2.1

# zipdatadir="/ftp-data/zipscript/" # <- Set to "" if you do NOT use zipscript-c !
zipdatadir="/ftp-data/pzs-ng"       # <- Set this one instead if you use pzs-ng's zipscript-c !

ALLOWED="\.r[a0-9][r0-9]$ \.0[0-9][0-9]$ \.zip$ \.mp[g2-3]$ \.vob$ \.avi$ \.jpg$ \.nfo$ \.diz$ \.sfv$"

BANNED="^5a\.nfo$ ^aks\.nfo$ ^atl\.nfo$ ^atlvcd\.nfo$ ^bar\.nfo$ ^cas\-pre\.jpg$ ^cmt\.nfo$ ^coke\.nfo$ ^dim\.nfo$ ^dkz\.nfo$ ^echobase\.nfo$ ^firesite\.nfo$ ^fireslut\.nfo$ ^ifk\.nfo$ ^lips\.nfo$ ^magfields\.nfo$ ^mfmfmfmf\.nfo$ ^mm\.nfo$ ^mob\.nfo$ ^mod\.nfo$ ^pbox\.nfo$ ^ph\.nfo$ ^pike\.nfo$ ^pre\.nfo$ ^release\.nfo$ ^sexy\.nfo$ ^tf\.nfo$ ^twh\.nfo$ ^valhalla\.nfo$ ^zn\.nfo$ ^imdb\.nfo$ ^vdrlake\.nfo$ ^dm\.nfo$ ^nud\.nfo$ ^dtsiso21\.jpg$ ^dagger\.jpg$"

NODOUBLESFV="TRUE"
NOSAMENAME="TRUE"

NODOUBLENFO="TRUE"
NOFTPRUSHNFOS="TRUE"
GLLOG="/ftp-data/logs/glftpd.log"

EXCLUDEDDIRS="/REQUESTS/ /Archive/ /GROUPS/"

ERROR1="This file does not match any allowed file extentions. Skipping."
ERROR2="This filename is BANNED. Add it to your skiplists. Wanker."
ERROR3="There is already a .sfv in this dir. You must delete that one first."
ERROR4="This file is already there with a different case."
ERROR5="There is already a .nfo in this dir. You must delete that one first."
ERROR6="This nfo file format is not allowed ($1)"

#--[ Script Start ]--------------------------------#

if [ "$EXCLUDEDDIRS" ]; then
  EXCLUDEDDIRS=`echo "$EXCLUDEDDIRS" | tr -s ' ' '|'`
  if [ "`echo "$2" | egrep -i "$EXCLUDEDDIRS"`" ]; then
    exit 0
  fi
fi

### START OF ZIPSCRIPTS-C's precheck.sh
if [ "$zipdatadir" ]; then
  case "$1" in

   *.[rR0-9][aA0-9][rR0-9]|*.[mM][pP]3)
    if ls $2 | grep -i .sfv &> /dev/null ; then
     if [ -z "`grep -aie $1 "$zipdatadir/$2/sfvdata" | tr -s ' ' | tr [:cntrl:] '\n' | cut -d' ' -f1 | grep -iae $1`" ] ; then
      echo -e "File does not exist in sfv!\n"
      exit 2
     fi
    else
     if [ -e "$zipdatadir/$2/sfvdata" ] ; then
      if [ -z "`grep -aie $1 "$zipdatadir/$2/sfvdata" | tr -s ' ' | tr [:cntrl:] '\n' | cut -d' ' -f1 | grep -iae $1`" ] ; then
       echo -e "File does not exist in sfv!\n"
       exit 2
      fi
     else
      echo -e "You must upload .sfv first!\n"
      exit 2
     fi
    fi
   ;;

   *.[dD][iI][zZ])
    exit 2
   ;;

   *.[zZ][iI][pP])
    if [ "`ls -1 | grep -i \.zip$`" ]; then
     searchstr=`echo "$1" | cut -c-3`
     if [ -z "`ls -1 | cut -c-3 | grep -i $searchstr`" ] ; then
      echo -e "Filename does not match with existing disks"
      exit 2
     fi
    fi
   ;;

  esac
fi
### END OF ZIPSCRIPTS-C's precheck.sh

if [ "$ALLOWED" ]; then
  ALLOWED=`echo "$ALLOWED" | tr -s ' ' '|'`
  if [ -z "`echo "$1" | egrep -i "$ALLOWED"`" ]; then
    echo -e "$ERROR1\n"
    exit 2
  fi
fi

if [ "$BANNED" ]; then
  BANNED=`echo "$BANNED" | tr -s ' ' '|'`
  if [ "`echo "$1" | egrep -i "$BANNED"`" ]; then
    echo -e "$ERROR2\n"
    exit 2
  fi
fi

if [ "$NOSAMENAME" = "TRUE" ]; then
  if [ "`ls -1 "$2" | grep -i "^$1$"`" ]; then
    if [ -z "`ls -1 "$2" | grep "^$1$"`" ]; then
      echo -e "$ERROR4\n"
      exit 2
    fi
  fi
fi

if [ "$NODOUBLESFV" = "TRUE" ]; then
  if [ "`echo "$1" | grep -i "\.sfv$"`" ]; then
    if [ -e $2/*.[sS][fF][vV] ]; then
      echo -e "$ERROR3\n"
      if [ "$GLLOG" ]; then
        DIR=`basename $2`

        # $1 = Filename. $2 = Full path. $DIR = Only the dir were currently in. $USER = duh
        echo `date "+%a %b %e %T %Y"` TURGEN: \"[WANKER] - $USER tried to upload $1 into $DIR where there already is a sfv!\" >> $GLLOG

      fi
      exit 2
    fi
  fi
fi

if [ "$NODOUBLENFO" = "TRUE" ]; then
  if [ "`echo "$1" | grep "\.[nN][fF][oO]$"`" ]; then
    if [ -e $2/*.[nN][fF][oO] ]; then
      echo -e "$ERROR5\n"
      if [ "$GLLOG" ]; then
        DIR=`basename $2`

        # $1 = Filename. $2 = Full path. $DIR = Only the dir were currently in. $USER = duh
        echo `date "+%a %b %e %T %Y"` TURGEN: \"[WANKER] - $USER tried to upload $1 into $DIR where there already is a nfo!\" >> $GLLOG

      fi
      exit 2
    fi
  fi
fi

if [ "$NOFTPRUSHNFOS" = "TRUE" ]; then
  if [ "`echo "$1" | grep "\.[nN][fF][oO]$"`" ]; then
    if [ "`echo "$1" | grep "([0-9999])\.[nN][fF][oO]$"`" ]; then
      echo -e "$ERROR6\n"
      exit 2      
    fi
  fi
fi

exit 0
