#!/bin/bash
VER=1.0

#--[ Intro ]--------------------------------------------------#
#                                                             #
# Tur-ReqDel. For those using glftpd's internal request and   #
# want to be able to just delete a request without filling it #
#                                                             #
# Note that this is ONLY for that request system. Its not for #
# Tur-Request or anyone elses scripts.                        #
#                                                             #
# This script was made by request from turbo.                 #
#                                                             #
#--[ Installation ]-------------------------------------------#
#                                                             #
# Copy tur-reqdel.sh to /glftpd/bin. chmod 755 tur-reqdel.sh  #
# Make sure the requests file is writeable by everyone, so:   #
# chmod 777 /glftpd/ftp-data/misc/requests                    #
# If you havent got one, create a 'tmp' dir inside /glftpd    #
# and; chmod 777 /glftpd/tmp                                  #
#                                                             #
# Next, load it as a custom command in glftpd.conf:           #
# site_cmd reqdel EXEC /bin/tur-reqdel.sh                     #
# custom-reqdel 1                                             #
#                                                             #
#--[ Settings ]-----------------------------------------------#
#                                                             #
# requestsfile     = Path to requests file, chrooted.         #
#                                                             #
# ShowReqsOnNoArgs = Do you want to show current requests if  #
#                    a user does not give any args, selects a #
#                    request number that does not exist and   #
#                    if he specifies something non numeric as #
#                    argument? Set this to TRUE if so.        #
#                                                             #
# TMP              = Temporary location, seen chrooted. This  #
#                    dir MUST exist and users must have full  #
#                    perms in it.                             #
#                                                             #
#--[ Problems ]-----------------------------------------------#
#                                                             #
# If it lists something strange as a request, such as:        #
# turranius               1065561790                          #
# Then you fucked up your requests file somehow. glftpd writes#
# it in a specific format. What you are seeing is who did the #
# request and at what time (secs since 1970). Its supposed to #
# be 14 spaces after the time. This script requires atleast 1 #
# space after it, so try and just adding a space after the    #
# time. Might help.                                           #
#                                                             #
# In other words; do not edit the file left and right or this #
# script will not work.                                       #
#                                                             #
#--[ Contact ]------------------------------------------------#
#                                                             #
# http://www.grandis.nu/glftpd <-> http://grandis.mine.nu     #
# Support in the forums. Bugs can be reported to turranius on #
# efnet. Check #glftpd but dont ask script questions in there.#
#                                                             #
#--[ Configuration ]------------------------------------------#

requestsfile=/ftp-data/misc/requests
ShowReqsOnNoArgs=TRUE
TMP=/glftpd/tmp


#--[ Script Start ]-------------------------------------------#

## Check that we can read and write to requestsfile.
if [ ! -r "$requestsfile" ]; then
  echo "Error. Cant read $requestsfile. Check paths and perms."
  exit 1
elif [ ! -w "$requestsfile" ]; then
  echo "Error. Cant write to $requestsfile. Check perms."
  exit 1
fi

## Check that the TMP dir exists.
if [ ! -d "$TMP" ]; then
  echo "Error. Cant find TMP dir $TMP. Make sure it exists and is 777."
  exit 1
fi

## Is the requestsfile empty?
if [ -z "`grep . $requestsfile`" ]; then
  echo "Requestsfile seems empty already. What are you trying to del?"
  exit 1
fi

## Shows requests if its supposed to do that.
proc_showreqs() {
  if [ "$ShowReqsOnNoArgs" = "TRUE" ]; then
    num=0
    echo "Current requests are:"
    for each in `cat $requestsfile | tr -s ' ' '^' | grep -v "\^10[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\^"`; do
      num=$[$num+1]
      if [ -z "`echo "$num" | grep ".."`" ]; then
        num=" $num"
      fi
      echo "($num) $each" | tr -s '^' ' '
    done
  fi
}

## No argument given.
if [ -z "$1" ]; then
  echo "Tur-ReqDel $VER"
  echo "Please specify a request number to delete."
  proc_showreqs
  exit 0
fi

## If we remove all digits from selection and its not empty, it cant be numbers only.
if [ "`echo "$1" | tr -d '[:digit:]'`" ]; then
  echo "Only use the number please."
  proc_showreqs
  exit 1
fi

## Get selection from requestsfile and put in arg.
num=0
for rawdata in `cat $requestsfile | tr ' ' '^' | grep -v "\^10[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\^"`; do
  num=$[$num+1]
  if [ "$num" = "$1" ]; then
    SELECTIONRAW=`echo "$rawdata" | tr -d '[:cntrl:]'`
    break
  fi
done

## If SELECTIONRAW is not set, the user selected a number that isnt requested.
if [ -z "$SELECTIONRAW" ]; then
  echo "Error. No such request number."
  proc_showreqs
  exit 1
fi

## Remake selection a bit for both visual output and what to remove from file-
SELECTION=`echo "$SELECTIONRAW" | tr -s '^' ' '`
SELECTIONRAW=`echo "$SELECTIONRAW" | tr '^' ' '`

## Echo what is about to be deleted.
echo "Deleting request $num - $SELECTION"

## Delete requested release.
grep -F -v -- "$SELECTIONRAW" $requestsfile > $TMP/request.tmp

## Delete datalines that appear above another data line (user time)
## Since we deleted the request already, there should be 2 datalines above each other.
## We just remove the top one of those two.

for rawdata in `cat $TMP/request.tmp | tr -s '[:cntrl:]' | tr ' ' '^'`; do
  if [ "`echo "$rawdata" | grep "\^10[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]\^"`" ]; then
    if [ -z "$DATA" ]; then
      DATA="$rawdata"
    else
      SELECTIONRAW=`echo "$DATA" | tr '^' ' '`
      grep -F -v -- "$SELECTIONRAW" $TMP/request.tmp > $TMP/request2.tmp
      cp -f $TMP/request2.tmp $requestsfile
      rm -f $TMP/request.tmp
      break
    fi
  else
    unset DATA
  fi
done

exit 0
