#!/bin/bash
VER=2.1.1

## See README for detailed instructions, changelog and contact information

## Remove # below to hardset config location
## If not, it will be read from the same dir as tur-trial.sh is in.
# config=/glftpd/bin/tur-trial.conf

###############################################################################
# No changes should be needed under here.                                     #
###############################################################################

## Load config file
if [ -z "$config" ]; then
  config="$( dirname $0 )/tur-trial.conf"
fi

. $config

USER="$1"

proc_cookies() {
  if [ "$USER" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%USER%/$USER/g" )"
  fi
  if [ "$SHOWL" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%SHOWL%/$SHOWL/g" )"
  fi
  if [ "$RATIO" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%RATIO%/$RATIO/g" )"
  fi
  if [ "$DURNAME" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DURNAME%/$DURNAME/g" )"
  fi
  if [ "$g" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%GROUP%/$g/g" )"
  fi
  if [ "$EG" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%EGROUP%/$EG/g" )"
  fi
  if [ "$DAY" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAY%/$DAY/g" )"
  fi
  if [ "$SITENAME" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%SITENAME%/$SITENAME/g" )"
  fi
  if [ "$PERDAY" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%PERDAY%/$PERDAY/g" )"
  fi
  if [ "$PERDAYNAME" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%PERDAYNAME%/$PERDAYNAME/g" )"
  fi
  OUTPUT="$( echo $OUTPUT | sed -e "s/%BOLD%//g" )"
  OUTPUT="$( echo $OUTPUT | sed -e "s/%ULINE%//g" )"
}

## Make sure we dont go into a infinite loop..
if [ -z "$C_PASSED_TRIALTOT" ]; then
  C_PASSED_TRIALTOT=0
fi
if [ -z "$C_NOTPASSED_TRIALTOT" ]; then
  C_NOTPASSED_TRIALTOT=0
fi
if [ -z "$C_PASSED_NEXTDURTOT" ]; then
  C_PASSED_NEXTDURTOT=0
fi
if [ -z "$C_NOTPASSED_NEXTDURTOT" ]; then
  C_NOTPASSED_NEXTDURTOT=0
fi
if [ -z "$C_PASSED_NOTRIALTOT" ]; then
  C_PASSED_NOTRIALTOT=0
fi
if [ -z "$C_NOTPASSED_NOTRIALTOT" ]; then
  C_NOTPASSED_NOTRIALTOT=0
fi
if [ -z "$C_QUOTA_EX_PASSEDTOT" ]; then
  C_QUOTA_EX_PASSEDTOT=0
fi
if [ -z "$C_QUOTA_EX_NOTPASSEDTOT" ]; then
  C_QUOTA_EX_NOTPASSEDTOT=0
fi
if [ -z "$C_QUOTA_PASSEDTOT" ]; then
  C_QUOTA_PASSEDTOT=0
fi
if [ -z "$C_QUOTA_NOTPASSEDTOT" ]; then
  C_QUOTA_NOTPASSEDTOT=0
fi
if [ -z "$C_FIRST_QUOTA_PASSEDTOT" ]; then
  C_FIRST_QUOTA_PASSEDTOT=0
fi
if [ -z "$C_FIRST_QUOTA_NOTPASSEDTOT" ]; then
  C_FIRST_QUOTA_NOTPASSEDTOT=0
fi

proc_vacation() {
  ## Read vacationdata if its on.
  if [ "$VACATIONDATA" != "" -a "$NOTRIALDURATION" = "M" ]; then
    if [ ! -r "$VACATIONDATA" ]; then
      echo "Error. VACATIONDATA set to $VACATIONDATA, but I cant read that file."
    else
      VACATIONTIME="$( grep -w "^$USER" $VACATIONDATA | cut -d '^' -f2 )"
      if [ "$VACATIONTIME" ]; then

        if [ "$AUTOQUOTA" = "TRUE" -a "$DEBUG" = "TRUE" ]; then
          echo "DEBUG: $USER is on vacation ($VACATIONTIME). Lowering limit."
        fi

        LIMIT="$NOTRIALLIMIT"

        VACATIONTIMENOW="$( date +%s )"

        TIMETHEN="$( expr $VACATIONTIME \/ 60 )"
        TIMETHEN="$( expr $TIMETHEN \/ 60 )"
        TIMETHEN="$( expr $TIMETHEN \/ 24 )"
        TIMENOW="$( expr $VACATIONTIMENOW \/ 60 )"
        TIMENOW="$( expr $TIMENOW \/ 60 )"
        TIMENOW="$( expr $TIMENOW \/ 24 )"
        unset VACATIONTIME; unset VACATIONTIMENOW

        DIFFERENCE="$( expr $TIMENOW \- $TIMETHEN )"

        MONTHNOW="$( date +%b )"
        case $MONTHNOW in
          Jan) MONTHTOTAL="31" ;;
          Feb) MONTHTOTAL="28" ;;
          Mar) MONTHTOTAL="31" ;;
          Apr) MONTHTOTAL="30" ;;
          May) MONTHTOTAL="31" ;;
          Jun) MONTHTOTAL="30" ;;
          Jul) MONTHTOTAL="31" ;;
          Aug) MONTHTOTAL="31" ;;
          Sep) MONTHTOTAL="30" ;;
          Oct) MONTHTOTAL="31" ;;
          Nov) MONTHTOTAL="30" ;;
          Dec) MONTHTOTAL="31" ;;
          *) MONTHTOTAL="31" ;;   
        esac

        if [ "$DIFFERENCE" != "0" ]; then
          if [ "$DIFFERENCE" -gt "$MONTHTOTAL" ]; then
            echo "Warning. Time in VACATIONDATA does not seem to be reset at last month. Tell siteop to fix."
            exit 0
          fi

          DAYSOFF=$[$MONTHTOTAL-DIFFERENCE]

          PERDAY=$[$LIMIT/MONTHTOTAL]
          DEDUCT=$[$DIFFERENCE*$PERDAY]
          LIMIT=$[$LIMIT-$DEDUCT]
        else
          if [ "$AUTOQUOTA" = "TRUE" ]; then
            unset LIMIT
          fi
        fi
      else
        if [ "$AUTOQUOTA" = "TRUE" ]; then
          unset LIMIT
        fi
      fi
    fi
  fi
}

proc_vacationreset() {
  if [ "$VACATIONDATA" ]; then
    if [ ! -w "$VACATIONDATA" ]; then
      echo "DEBUG: Error. Cant write to $VACATIONDATA to reset vacationtimes."
    else
      TIMENOW="$( date +%s )"
      for each in `cat $VACATIONDATA`; do
        username=`echo "$each" | cut -d '^' -f1`

        if [ "$( grep "^GROUP $VACATIONGROUP" $USERSLOCATION/$username )" ]; then
          GOTONE="TRUE"
          echo "$username^$TIMENOW" >> $TMP/vacationdata.tmp
        else
          if [ "$DEBUG" = "TRUE" ]; then
            echo "DEBUG: $username, while in $VACATIONDATA, is not in group $VACATIONGROUP. Removing from DB file." >> $TMP/quota_exclude.tmp
          fi
        fi      

      done
      if [ "$username" != "" -a "$GOTONE" != "TRUE" ]; then
        echo "" > $VACATIONDATA
      fi

      if [ -e "$TMP/vacationdata.tmp" ]; then
        cp -f "$TMP/vacationdata.tmp" "$VACATIONDATA"
        rm -f "$TMP/vacationdata.tmp"
      fi
    fi
  fi
}

if [ "$2" = "quota" ]; then
  if [ "$3" = "test" -o "$3" = "debug" ]; then
    echo "Test mode on. Setting TEST=TRUE and QANNOUNCE=FALSE"
    DEBUG="TRUE"
    TEST="TRUE"
    QANNOUNCE="FALSE"
  fi

  if [ "$EXCLUDEDUSERS" ]; then
    EXCLUDEDUSERS="$( echo $EXCLUDEDUSERS | tr -s ' ' '|' )"
  fi

  ## Do we want weekly or monthly trials?
  case $NOTRIALDURATION in
   W)
     DUR="WKUP"
     DURNAME="week"
     ;;
   M)
     DUR="MONTHUP"
     DURNAME="month"
     ;;
   *)
     echo "NOTRIALDURATION not set right. Either W or M"
     exit 0
     ;;
  esac
  
  if [ "$NOTRIALDURATION" = "M" ]; then
    MONTHNOW="$( date +%b )"
    case $MONTHNOW in
      Jan) MONTHTOTAL="31" ;;
      Feb) MONTHTOTAL="28" ;;
      Mar) MONTHTOTAL="31" ;;
      Apr) MONTHTOTAL="30" ;;
      May) MONTHTOTAL="31" ;;
      Jun) MONTHTOTAL="30" ;;
      Jul) MONTHTOTAL="31" ;;
      Aug) MONTHTOTAL="31" ;;
      Sep) MONTHTOTAL="30" ;;
      Oct) MONTHTOTAL="31" ;;
      Nov) MONTHTOTAL="30" ;;
      Dec) MONTHTOTAL="31" ;;
      *) MONTHTOTAL="31" ;;   
    esac
    
    DAYOFMONTH="$( date +%d )"   
    if [ "$MONTHTOTAL" != "$DAYOFMONTH" ]; then
      if [ "$DEBUG" = "TRUE" ]; then
        echo "Not the end of the month. Since this is a test I'm gonna run anyway."
      else
        exit 0
      fi
    fi
  fi
  
  if [ "$NOTRIALDURATION" = "W" ]; then
    DAYNOW="$( date +%w )"
    if [ "$EUROWEEK" = "FALSE" ]; then
      if [ "$DAYNOW" != "6" ]; then
        if [ "$DEBUG" = "TRUE" ]; then
          echo "Not the end of the week. Since this is a test I'm gonna run anyway."
        else
          exit 0
        fi
      fi
    else
      if [ "$DAYNOW" != "0" ]; then
        if [ "$DEBUG" = "TRUE" ]; then
          echo "Not the end of the week. Since this is a test I'm gonna run anyway."
        else
          exit 0
        fi
      fi
    fi
  fi
  
  MONTH="$(date +%m)"
  YEAR="$(date +%y)"
  MONTHNOW="$MONTH-$YEAR"

  if [ "$QANNOUNCE" = "TRUE" ]; then
    echo `date "+%a %b %e %T %Y"` TURTRIAL: \"Quota $DURNAME has reached the end.\" >> $GLLOG
  fi

  date=`date +%m%d`
  if [ "$DEBUG" = "TRUE" ]; then
    echo "-- Quota $DURNAME ended $date. Limit is $NOTRIALLIMIT MB / $DURNAME --"
  else
    echo "" >> $QLOGFILE
    echo "-- Quota $DURNAME ended $date. Limit is $NOTRIALLIMIT MB / $DURNAME --" >> $QLOGFILE
  fi

  if [ "$AFFILSFOLDER" != "" ]; then
    for folder in `echo $AFFILSFOLDER`; do
      cd $folder
      for affils in `ls`; do
        GAFFILS="$affils $GAFFILS"
      done
    done
    if [ "$GAFFILS" = "" ]; then
      GAFFILS="$AFFILS"
    else
      GAFFILS="$AFFILS $GAFFILS"
    fi
  else
    GAFFILS="$AFFILS"
  fi

  if [ -e "$TMP/quota_exclude.tmp" ]; then
    rm -f $TMP/quota_exclude.tmp
  fi
  if [ -e "$TMP/quota_finito.tmp" ]; then
    rm -f $TMP/quota_finito.tmp
  fi

  ## Making a dummy here incase EXCLUDEDUSERS is empty in conf..
  if [ "$EXCLUDEDUSERS" = "" ]; then
    EXCLUDEDUSERS="KFJekFFjek38"
  fi
  
  cd $USERSLOCATION
  for user in `grep -w "FLAGS" * | grep -v "default.user" | egrep -v $EXCLUDEDUSERS | awk -F":" '{print $1}'`; do
    unset DELLED
    MATCH="NOPE"
    EX="NO"
    GROUP="$( grep -w GROUP $user | awk '{printf $2 " "}' )"
    for eachgroup in $GROUP; do
      if [ "$MATCH" != "YEPP" ]; then
        EXCLUDEDG2="$( echo $GAFFILS | grep -w $eachgroup )"
        if [ "$EXCLUDEDG2" != "" ]; then
          MATCH="YEPP"
          EX="YES"
          if [ "$DEBUG" = "TRUE" ]; then
            echo "DEBUG: Group Exclude Match for $eachgroup on $user" >> $TMP/quota_exclude.tmp
          fi
        fi
      fi
    done
   
    if [ "$EX" != "YES" ]; then
      if [ "$EXCLUDELEECH" = "TRUE" ]; then
        if [ "$DEBUG" = "TRUE" ]; then
          if [ "$EXCLUDESAID" != "YEPP" ]; then
            echo "DEBUG: Excluding users with leech." >> $TMP/quota_exclude.tmp
            EXCLUDESAID="YEPP"
          fi
        fi
        RATIO="$( grep -w RATIO $user | awk -F" " '{print $2}')"
        if [ "$RATIO" = "0" ]; then
          EX="YES"
          if [ "$DEBUG" = "TRUE" ]; then
            echo "DEBUG: Leech Exclude Match for $user" >> $TMP/quota_exclude.tmp
          fi
        fi
      fi
    fi

    if [ "$EX" != "YES" ]; then
      ## Check if the user has been on site for more then one month.
      MONTHADDED="$( grep -w $user $PASSWD | awk -F":" '{print $5}' | awk -F"-" '{print $1"-"$3}')"
      if [ "$MONTHADDED" = "$MONTHNOW" ]; then
        EX="YES"
        if [ "$DEBUG" = "TRUE" ]; then
          echo "DEBUG: Auto Excluding $user. User added this month." >> $TMP/quota_exclude.tmp
        fi
      fi
    fi

    if [ "$EX" != "YES" ]; then
      MONTH="$( grep $DUR $user | awk '{print $3}')"

      ## Check for other stats sections.
      MONTH2="$( grep $DUR $user | awk '{print $6}')"
      if [ "$MONTH2" != "" ]; then
        MONTH3="$( grep $DUR $user | awk '{print $9}')"
        if [ "$MONTH3" != "" ]; then
          MONTH4="$( grep $DUR $user | awk '{print $12}')"
          if [ "$MONTH4" != "" ]; then
            MONTH5="$( grep $DUR $user | awk '{print $15}')"
            if [ "$MONTH5" != "" ]; then
              MONTH6="$( grep $DUR $user | awk '{print $18}')"
              if [ "$MONTH6" != "" ]; then
                MONTH7="$( grep $DUR $user | awk '{print $21}')"
                if [ "$MONTH7" != "" ]; then
                  MONTH8="$( grep $DUR $user | awk '{print $24}')"
                  if [ "$MONTH8" != "" ]; then
                    MONTH9="$( grep $DUR $user | awk '{print $27}')"
                    if [ "$MONTH9" != "" ]; then
                      if [ "$DEBUG" = "TRUE" ]; then
                        echo "DEBUG: Nine stat sections found for $user" >> $TMP/quota_exclude.tmp
                      fi
                      MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" \+ "$MONTH5" \+ "$MONTH6" \+ "$MONTH7" \+ "$MONTH8" \+ "$MONTH9" )"
                    else
                      if [ "$DEBUG" = "TRUE" ]; then
                        echo "DEBUG: Eight stat sections found for $user" >> $TMP/quota_exclude.tmp
                      fi
                      MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" \+ "$MONTH5" \+ "$MONTH6" \+ "$MONTH7" \+ "$MONTH8" )"
                    fi
                  else
                    if [ "$DEBUG" = "TRUE" ]; then
                      echo "DEBUG: Seven stat sections found for $user" >> $TMP/quota_exclude.tmp
                    fi
                    MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" \+ "$MONTH5" \+ "$MONTH6" \+ "$MONTH7" )"
                  fi
                else
                  if [ "$DEBUG" = "TRUE" ]; then
                    echo "DEBUG: Six stat sections found for $user" >> $TMP/quota_exclude.tmp
                  fi
                  MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" \+ "$MONTH5" \+ "$MONTH6" )"
                fi
              else
                if [ "$DEBUG" = "TRUE" ]; then
                  echo "DEBUG: Five stat sections found for $user" >> $TMP/quota_exclude.tmp
                fi
                MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" \+ "$MONTH5" )"
              fi
            else
              if [ "$DEBUG" = "TRUE" ]; then
                echo "DEBUG: Four stat sections found for $user" >> $TMP/quota_exclude.tmp
              fi
              MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" \+ "$MONTH4" )"
            fi
          else
            if [ "$DEBUG" = "TRUE" ]; then
              echo "DEBUG: Three stat sections found for $user" >> $TMP/quota_exclude.tmp
            fi
            MONTH="$( expr "$MONTH" \+ "$MONTH2" \+ "$MONTH3" )"
          fi
        else
          if [ "$DEBUG" = "TRUE" ]; then
            echo "DEBUG: Two stat sections found for $user" >> $TMP/quota_exclude.tmp
          fi
          MONTH="$( expr "$MONTH" \+ "$MONTH2" )"
        fi
        NADA="Yepp"
      else
        if [ "$DEBUG" = "TRUE" ]; then
          echo "DEBUG: One stat section found for $user" >> $TMP/quota_exclude.tmp
        fi        
      fi
    fi

    if [ "$EX" != "YES" ]; then

      AUTOQUOTA=TRUE

      #--[ VACATION SETTINGS ]--#
      if [ "$VACATIONDATA" ]; then
        USER=$user
        proc_vacation
        if [ "$LIMIT" ]; then
          OLDNOTRIALLIMIT="$NOTRIALLIMIT"
          NOTRIALLIMIT="$LIMIT"
        fi
        unset USER
      fi
      #--[ END VACATION SETTINGS ]--#

      MONTHUP="$( expr $MONTH \/ 1024 )"

      if [ "$MONTHUP" -gt "$NOTRIALLIMIT" ]; then
        echo "$user - $MONTHUP MB - $GROUP- Safe ($NOTRIALLIMIT)" >> $TMP/quota_finito.tmp
      else
        if [ "$MONTH" -lt "1024" ]; then
           MSG="Idle?"
        else
           MSG="Below limit"
           MSG="Below limit ($NOTRIALLIMIT)"
        fi

        ## FLAGDEL is TRUE. Lets put some 6 flags on users.
        if [ "$FLAGDEL" = "TRUE" ]; then
          FLAGS="$( grep -w FLAGS $user | awk -F" " '{print $2}')"
          CHECK="$( echo $FLAGS | grep 6 )"
          if [ "$CHECK" != "" ]; then
            DELLED="YES"
            if [ "$DEBUG" = "TRUE" ]; then
              echo "DEBUG: $user - $MONTHUP MB - $GROUP- $MSG . Already delled though." >> $TMP/quota_exclude.tmp
            fi
          fi
          if [ "$DELLED" != "YES" ]; then
            if [ "$TEST" != "TRUE" ]; then
              sed -e "s/^FLAGS $FLAGS.*/FLAGS "$FLAGS"6/" $USERSLOCATION/$user > $TMP/$USER.TMP
              mv -f $TMP/$USER.TMP $USERSLOCATION/$user
            else
              if [ "$DEBUG" = "TRUE" ]; then
                if [ "$YESYES" != "TRUE" ]; then
                  echo "DEBUG: Test mode activated. No users actually delled." >> $TMP/quota_exclude.tmp
                  YESYES="TRUE"
                fi
              fi
            fi
            FLAGSAFTER="$( grep -w FLAGS $user | awk -F" " '{print $2}')"
            echo "$user - $MONTHUP MB - $GROUP- $MSG - Putting flag 6 on him!" >> $TMP/quota_finito.tmp
          fi
        else
          ## FLAGDEL isnt TRUE. Lets see..
          FLAGS="$( grep -w FLAGS $user | awk '{print $2}')"
          CHECK="$( echo $FLAGS | grep 6 )"
          if [ "$CHECK" != "" -a "$FLAGDEL" != "TESTING" ]; then
            if [ "$DEBUG" = "TRUE" ]; then
              echo "$user - $MONTHUP MB - $GROUP- $MSG , but hes already delled. Not touching." >> $TMP/quota_exclude.tmp
            fi
          else
            if [ "$ADDTOGROUP" != "" ]; then
              if [ "$DEBUG" != "TRUE" ]; then
                echo "GROUP $ADDTOGROUP" >> $user
                echo "$user - $MONTHUP MB - $GROUP- $MSG - Adding to group $ADDTOGROUP" >> $TMP/quota_finito.tmp
              else
                echo "$user - $MONTHUP MB - $GROUP- $MSG - Adding to group $ADDTOGROUP (test)" >> $TMP/quota_finito.tmp
              fi
            else
              echo "$user - $MONTHUP MB - $GROUP- $MSG" >> $TMP/quota_finito.tmp
            fi
            if [ "$SETCREDS" != "" ]; then
              if [ "$DEBUG" != "TRUE" ]; then
                sed -e "s/^CREDITS.*/CREDITS $SETCREDS/" $USERSLOCATION/$user > $TMP/$USER.TMP2
                mv -f $TMP/$USER.TMP2 $USERSLOCATION/$user
              else
                echo "$user - Setting credits to $SETCREDS" >> $TMP/quota_exclude.tmp
              fi
            fi
          fi
        fi

        if [ "$QANNOUNCE" = "TRUE" ]; then
          if [ "$failedusers" = "" ]; then
            failedusers="$user/$MONTHUP"
          else
            failedusers="$user/$MONTHUP -=- $failedusers"
          fi
        fi
      fi
    fi

    #--[ VACATION SETTINGS ]--#
    if [ "$VACATIONDATA" -a "$EX" != "YES" ]; then
      if [ "$LIMIT" ]; then
        NOTRIALLIMIT="$OLDNOTRIALLIMIT"
        unset LIMIT; unset OLDNOTRIALLIMIT
      fi
    fi
    #--[ END VACATION SETTINGS ]--#

  done

  if [ "$VACATIONDATA" ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      echo "DEBUG: Resetting times in $VACATIONDATA (test)" >> $TMP/quota_exclude.tmp
    else
      proc_vacationreset
    fi
  fi

  if [ -e "$TMP/quota_exclude.tmp" ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      cat $TMP/quota_exclude.tmp | sort
    else
      cat $TMP/quota_exclude.tmp | sort >> $QLOGFILE
    fi
 
  fi
  if [ -e "$TMP/quota_finito.tmp" ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      cat $TMP/quota_finito.tmp | sort -k3 -n -r
    else
      cat $TMP/quota_finito.tmp | sort -k3 -n -r >> $QLOGFILE
    fi
  fi
  if [ "$QANNOUNCE" = "TRUE" ]; then
    if [ "$ADDTOGROUP" != "" -a "$FLAGDEL" = "FALSE" ]; then
      echo `date "+%a %b %e %T %Y"` TURTRIAL: \"Failed users added to group $ADDTOGROUP: $failedusers\" >> $GLLOG
    else
      echo `date "+%a %b %e %T %Y"` TURTRIAL: \"Failed users: $failedusers\" >> $GLLOG
    fi
  fi

exit 0
fi

if [ "$2" = "triallist" ]; then
  if [ "$3" = "test" ]; then
    echo "Test mode on. Setting ANNOUNCE=FALSE, AUTOCHANGE=FALSE and DELFAIL=FALSE"
    DEBUG="TRUE"
    ANNOUNCE="FALSE"
    AUTOCHANGE="FALSE"
    DELFAIL="FALSE"
  fi

  ## Do we want weekly or monthly trials?
  case $DURATION in
   W)
     DUR="WKUP"
     DURNAME="week"
     ;;
   M)
     DUR="MONTHUP"
     DURNAME="month"
     ;;
   *)
     echo "Duration not set right. Either W or M"
     exit 0
     ;;
  esac
  
  if [ "$DURATION" = "M" ]; then
    MONTHNOW="$( date +%b )"
    case $MONTHNOW in
      Jan) MONTHTOTAL="31" ;;
      Feb) MONTHTOTAL="28" ;;
      Mar) MONTHTOTAL="31" ;;
      Apr) MONTHTOTAL="30" ;;
      May) MONTHTOTAL="31" ;;
      Jun) MONTHTOTAL="30" ;;
      Jul) MONTHTOTAL="31" ;;
      Aug) MONTHTOTAL="31" ;;
      Sep) MONTHTOTAL="30" ;;
      Oct) MONTHTOTAL="31" ;;
      Nov) MONTHTOTAL="30" ;;
      Dec) MONTHTOTAL="31" ;;
      *) MONTHTOTAL="31" ;;   
    esac
    
    DAYOFMONTH="$( date +%d )"   
    if [ "$MONTHTOTAL" != "$DAYOFMONTH" ]; then
      if [ "$DEBUG" = "TRUE" ]; then
        echo "Not the end of the month. Test mode, so running anyway."
      else
        exit 0
      fi
    fi
  fi
  
  if [ "$DURATION" = "W" ]; then
    DAYNOW="$( date +%w )"
    if [ "$EUROWEEK" = "FALSE" ]; then
      if [ "$DAYNOW" != "6" ]; then
        if [ "$DEBUG" = "TRUE" ]; then
          echo "Not the end of the month. Test mode, so running anyway."
        else
          exit 0
        fi
      fi
    else
      if [ "$DAYNOW" != "0" ]; then
        if [ "$DEBUG" = "TRUE" ]; then
          echo "Not the end of the month. Test mode, so running anyway."
        else
          exit 0
        fi
      fi
    fi
  fi

  if [ "$ANNOUNCE" = "TRUE" ]; then
    echo `date "+%a %b %e %T %Y"` TURTRIAL: \"Trial $DURNAME has reached the end.\" >> $GLLOG
  fi

  cd $USERSLOCATION
  for user in `grep -i "GROUP $TRIALGROUP" * | grep -v "default.user" | awk -F":" '{print $1}'`; do
    group="$( grep -w "GROUP $TRIALGROUP" $user | awk '{print $2}' )"

    UP="$( grep $DUR $user | awk -F" " '{print $3}')"
    ## Check for other stat sections.
    UP2="$( grep -w $DUR $user | awk -F" " '{print $6}')"
    if [ "$UP2" != "" ]; then
      UP3="$(grep -w $DUR $user | awk -F" " '{print $9}')"
      if [ "$UP3" != "" ]; then
        UP4="$(grep -w $DUR $user | awk -F" " '{print $12}')"
        if [ "$UP4" != "" ]; then
          UP5="$(grep -w $DUR $user | awk -F" " '{print $15}')"
          if [ "$UP5" != "" ]; then
            UP6="$(grep -w $DUR $user | awk -F" " '{print $18}')"
            if [ "$UP6" != "" ]; then
            UP7="$(grep -w $DUR $user | awk -F" " '{print $21}')"
              if [ "$UP7" != "" ]; then
                UP8="$(grep -w $DUR $user | awk -F" " '{print $24}')"
                if [ "$UP8" != "" ]; then
                  UP9="$(grep -w $DUR $user | awk -F" " '{print $27}')"
                  if [ "$UP9" != "" ]; then
                    UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" \+ "$UP8" \+ "$UP9" )"
                  else
                    UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" \+ "$UP8" )"
                  fi
                else
                  UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" )"
                fi
              else
                UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" )"
              fi
            else
              UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" )"
            fi
          else
            UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" )"
          fi
        else
          UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" )"
        fi
      else
        UP="$( expr "$UP" \+ "$UP2" )"
      fi
    fi
    UP="$( expr $UP \/ 1024 )"

    if [ "$UP" -gt "$LIMIT" ]; then
      ## User passed trial.
      if [ "$group" = "$TRIALGROUP" ]; then
        ## User is in the TRiAL group.
        if [ "$AUTOCHANGE" = "TRUE" ]; then
          grep -v "GROUP $TRIALGROUP" $user > $TMP/$user.new
          mv -f $TMP/$user.new $user
          INOTHERGROUP="$( grep -w GROUP $user )"
          if [ "$INOTHERGROUP" = "" ]; then
            echo "GROUP $PASSGROUP" >> $user
          fi
          echo "$user / $group Passed with: $UP"MB" - Changing group to $PASSGROUP" >> $TMP/trial.tmp
        else
          echo "$user / $group Passed with: $UP"MB" - No automatic action taken." >> $TMP/trial.tmp
        fi
        if [ "$ANNOUNCE" = "TRUE" ]; then
          echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Congratulations on passing with $UP MB. Well done.\" >> $GLLOG
        fi
      else
        ## User is in the TRiAL-2 group.
        if [ "$AUTOCHANGE" = "TRUE" ]; then
          grep -v "GROUP $TRIALGROUPN" $user > $TMP/$user.new
          mv -f $TMP/$user.new $user
          if [ "$PASSEARLY" = "TRUE" ]; then
            INOTHERGROUP="$( grep -w GROUP $user )"
            if [ "$INOTHERGROUP" = "" ]; then
              echo "GROUP $PASSGROUP" >> $user
              echo "$user / $group Passed with: $UP"MB" - PASSEARLY kicked in. Changing group to $PASSGROUP" >> $TMP/trial-2.tmp
            else
              echo "$user / $group Passed with: $UP"MB" - PASSEARLY kicked in. Just removing from $TRIALGROUPN" >> $TMP/trial-2.tmp
            fi
            if [ "$ANNOUNCE" = "TRUE" ]; then
              echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Congratulations on passing early with $UP MB. Well done.\" >> $GLLOG
            fi
          else
            echo "GROUP $TRIALGROUP" >> $user
            if [ "$ANNOUNCE" = "TRUE" ]; then
              echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Trial starts NOW. Gogogo.\" >> $GLLOG
            fi
            echo "$user / $group Passed with: $UP"MB" - Changing group to $TRIALGROUP" >> $TMP/trial-2.tmp
          fi
        else
          if [ "$ANNOUNCE" = "TRUE" ]; then
            echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Congratulations on passing with $UP MB. Well done.\" >> $GLLOG
          fi
          echo "$user / $group Passed with: $UP"MB" - No automatic action taken." >> $TMP/trial-2.tmp
        fi
      fi
    else
      ## User FAILED trial.
      if [ "$group" = "$TRIALGROUP" ]; then
        ## User is in the TRiAL group.
        if [ "$AUTOCHANGE" = "TRUE" ]; then
          if [ "$DELFAIL" = "TRUE" ]; then
            FLAGS="$( grep -w FLAGS $user | awk -F" " '{print $2}' )"
            CHECK="$( echo $FLAGS | grep 6 )"
            if [ "$CHECK" != "" ]; then
              CHECK=""
              if [ "$ANNOUNCE" = "TRUE" ]; then
                echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Failed with $UP MB. He/She already delled though, tihi.\" >> $GLLOG
              fi
              echo "$user / $group Failed with: $UP"MB" - User already deleted." >> $TMP/trial.tmp
            else
              sed -e "s/^FLAGS $FLAGS.*/FLAGS "$FLAGS"6/" $user > $TMP/$user.new
              mv -f $TMP/$user.new $user
              if [ "$ANNOUNCE" = "TRUE" ]; then
                echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Failed with $UP MB. Better luck next time, poof.\" >> $GLLOG
              fi
              echo "$user / $group Failed with: $UP"MB" - Deleting user." >> $TMP/trial.tmp
            fi
            sleep 0.1
            grep -v "GROUP $TRIALGROUP" $user > $TMP/$user.new
            mv -f $TMP/$user.new $user
          else
            grep -v "GROUP $TRIALGROUP" $user > $TMP/$user.new
            mv -f $TMP/$user.new $user
            echo "GROUP $FAILGROUP" >> $user
            if [ "$ANNOUNCE" = "TRUE" ]; then
              echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Failed with $UP MB. Better luck next time.\" >> $GLLOG
            fi
            echo "$user / $group Failed with: $UP"MB" - Changing group to $FAILGROUP" >> $TMP/trial.tmp
          fi
        else
          if [ "$ANNOUNCE" = "TRUE" ]; then
            echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Failed with $UP MB.\" >> $GLLOG
          fi
          echo "$user / $group Failed with: $UP"MB" - No automatic action taken." >> $TMP/trial.tmp
        fi
      else
        ## User is in the TRiAL-2 group.
        if [ "$AUTOCHANGE" = "TRUE" ]; then
          grep -v "GROUP $TRIALGROUPN" $user > $TMP/$user.new
          mv -f $TMP/$user.new $user
          echo "GROUP $TRIALGROUP" >> $user
          echo "$user / $group Failed with: $UP"MB" - Changing group to $TRIALGROUP" >> $TMP/trial-2.tmp
        else
          echo "$user / $group Failed with: $UP"MB" - No automatic action taken." >> $TMP/trial-2.tmp
        fi
        if [ "$ANNOUNCE" = "TRUE" ]; then
          echo `date "+%a %b %e %T %Y"` TURTRIAL: \"$user - Your trial starts NOW. Good luck.\" >> $GLLOG
        fi
      fi
    fi
  done

  date=`date +%m%d`
  if [ -e "$TMP/trial.tmp" -o -e "$TMP/trial-2.tmp" ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      echo "-- Trial $DURNAME ended $date. Limit is $LIMIT MB / $DURNAME --"
    else
      echo "" >> $LOGFILE
      echo "-- Trial $DURNAME ended $date. Limit is $LIMIT MB / $DURNAME --" >> $LOGFILE
    fi
  fi

  if [ -e $TMP/trial.tmp ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      echo "-- This $DURNAME trials:"
      cat "$TMP/trial.tmp" | sort
      rm -f "$TMP/trial.tmp"
    else
      echo "-- This $DURNAME trials:" >> $LOGFILE
      cat "$TMP/trial.tmp" | sort >> $LOGFILE
      rm -f "$TMP/trial.tmp"
    fi
  fi
  if [ -e $TMP/trial-2.tmp ]; then
    if [ "$DEBUG" = "TRUE" ]; then
      echo "-- Next $DURNAME trials:"
      cat "$TMP/trial-2.tmp" | sort
      rm -f "$TMP/trial-2.tmp"
    else
      echo "-- Next $DURNAME trials:" >> $LOGFILE
      cat "$TMP/trial-2.tmp" | sort >> $LOGFILE
      rm -f "$TMP/trial-2.tmp"
    fi
  fi

  exit 0
fi

## If no argument is given after trigger:
if [ "$1" = "" ]; then
  echo "$SITENAME Specify a user to check too."
  exit 0
fi

if [ "$1" = "--status" ]; then
  echo "Tur-Trial $VER by Turranius"
  exit 0
fi

## Check if the user really exists.
if [ ! -e $USERSLOCATION/$1 ]; then
  OUTPUT="$NOTEXISTS"
  proc_cookies
  echo $OUTPUT
  exit 0
fi

if [ "$DISABLETRIAL" = "TRUE" ]; then
  if [ ! -z "$( grep "^GROUP $TRIALGROUP" $USERSLOCATION/$1 )" ]; then echo "$DISTEXT"; exit 0; fi
fi

## Check if the user is delled!
FLAGS="$( grep -w FLAGS $USERSLOCATION/$1 | awk '{print $2}' )"
FLAGS="$( echo $FLAGS | grep "6" )"
if [ "$FLAGS" != "" ]; then
  if [ "$DELETEDTEXT" != "" ]; then
    echo "$DELETEDTEXT"
  fi
  exit 0
fi

## Check if the group is TRiAL on the user specified.
GROUP="$(grep "GROUP $TRIALGROUP" $USERSLOCATION/$1 | grep -iv "$TRIALGROUPN")"
  if [ "$GROUP" != "" ]; then
    WHEN="NOW"
  fi

## If he wasnt, check if its TRiAL-2 for next trial period.
if [ -z "$WHEN" ]; then
  GROUP="$( grep "GROUP $TRIALGROUPN" $USERSLOCATION/$1 )"
  if [ "$GROUP" != "" ]; then
    WHEN="NEXT"
  else
    # not on trial
    WHEN="NOT"
    if [ "$NOTRIALLIMIT" ]; then
      LIMIT="$NOTRIALLIMIT"
      DURATION="$NOTRIALDURATION"
    else
      QUOTA=DISABLED
    fi
  fi
fi


## Do we want weekly or monthly trials?
case $DURATION in
 W) 
   DUR="WKUP"
   DURNAME="week"
   ;;
 M)
   DUR="MONTHUP"
   DURNAME="month"
   ;;
 *)
   echo "Duration not set right. Either W or M"
   exit 0
   ;;
esac

proc_vacation

## How much did the user upload this period? 
UP="$( cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $3}')"
if [ -z "$UP" ]; then
  UP="0"
fi

## Check for other stat sections.
UP2="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $6}')"
if [ "$UP2" != "" ]; then
  UP3="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $9}')"
  if [ "$UP3" != "" ]; then
    UP4="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $12}')"
    if [ "$UP4" != "" ]; then
      UP5="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $15}')"
      if [ "$UP5" != "" ]; then
        UP6="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $18}')"
        if [ "$UP6" != "" ]; then
          UP7="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $21}')"
          if [ "$UP7" != "" ]; then
            UP8="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $24}')"
            if [ "$UP8" != "" ]; then
              UP9="$(cat $USERSLOCATION/$1 | grep -w $DUR | awk -F" " '{print $27}')"
              if [ "$UP9" != "" ]; then
                UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" \+ "$UP8" \+ "$UP9" )"
              else
                UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" \+ "$UP8" )"
              fi
            else
              UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" \+ "$UP7" )"
            fi
          else
            UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" \+ "$UP6" )"
          fi
        else
          UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" \+ "$UP5" )"
        fi
      else
        UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" \+ "$UP4" )"
      fi
    else
      UP="$( expr "$UP" \+ "$UP2" \+ "$UP3" )"
    fi
  else
    UP="$( expr "$UP" \+ "$UP2" )"
  fi
fi

## Split the uploaded number with 1024 to get MB.
UP="$( expr $UP \/ 1024 )"

## Is the user over the limit?
if [ "$UP" -gt "$LIMIT" ]; then
  PASSED="YES"
else
  PASSED="NO"
fi

## Calculate how much under or over the limit the user is.
RATIO="$( expr $UP \- $LIMIT )"

## If the number is negative, remove the - 
RATIO="$( echo $RATIO | tr -d "-" )"

if [ "$DURATION" = "M" ]; then
  MONTHNOW="$( date +%b )"
  case $MONTHNOW in
    Jan) MONTHTOTAL="31" ;;
    Feb) MONTHTOTAL="28" ;;
    Mar) MONTHTOTAL="31" ;;
    Apr) MONTHTOTAL="30" ;;
    May) MONTHTOTAL="31" ;;
    Jun) MONTHTOTAL="30" ;;
    Jul) MONTHTOTAL="31" ;;
    Aug) MONTHTOTAL="31" ;;
    Sep) MONTHTOTAL="30" ;;
    Oct) MONTHTOTAL="31" ;;
    Nov) MONTHTOTAL="30" ;;
    Dec) MONTHTOTAL="31" ;;
    *) MONTHTOTAL="31" ;;   
  esac

  DAYNOW="$( date +%d )"
  if [ "$MONTHTOTAL" = "$DAYNOW" ]; then
    DURATION="W"
    MONTHMOVE="TRUE"
  else
    DAYSLEFT="$( expr $MONTHTOTAL \- $DAYNOW )"
    if [ "$DAYNOW" = "01" ]; then
      DAY="the whole month"
    else
      if [ "$DAYSLEFT" = "1" ]; then
        DAY="$DAYSLEFT day"
      else
        DAY="$DAYSLEFT days"
      fi
    fi
    PERDAY="$( expr $RATIO \/ $DAYSLEFT )"
    PERDAYNAME="day" 
  fi
fi

if [ "$DURATION" = "W" ]; then
  DAYNOW="$( date +%w )"
  if [ "$EUROWEEK" = "FALSE" ]; then
    case $DAYNOW in
      0) DAY="7 days"
         SPLIT="7" ;;
      1) DAY="6 days"
         SPLIT="6" ;;
      2) DAY="5 days"
         SPLIT="5" ;;
      3) DAY="4 days"
         SPLIT="4" ;;
      4) DAY="3 days"
         SPLIT="3" ;;
      5) DAY="2 days"
         SPLIT="2" ;;
      6) DAY="1 day"
         SPLIT="1" ;;
      *) DAY="-Hell if I know what day it is-"
         SPLIT="1" ;;
    esac
  else
    case $DAYNOW in
      1) DAY="7 days"
         SPLIT="7" ;;
      2) DAY="6 days"
         SPLIT="6" ;;
      3) DAY="5 days"
         SPLIT="5" ;;
      4) DAY="4 days"
         SPLIT="4" ;;
      5) DAY="3 days"
         SPLIT="3" ;;
      6) DAY="2 days"
         SPLIT="2" ;;
      0) DAY="1 day"
         SPLIT="1" ;;
      *) DAY="-Hell if I know what day it is-"
         SPLIT="1" ;;
    esac
  fi

  if [ "$SPLIT" = "1" -o "$MONTHMOVE" = "TRUE" ]; then
    HOURNOW="$( date +%k )"
    HLEFT="$( expr 24 \- $HOURNOW )"
    if [ "$HLEFT" = "1" ]; then
      MINUTENOW="$( date +%M )"
      MINLEFT="$( expr 60 \- $MINUTENOW )"
      if [ "$MINLEFT" = "1" ]; then
        DAY="$MINLEFT minute"
      else
        DAY="$MINLEFT minutes"
      fi
      PERDAY="$( expr $RATIO \/ $MINLEFT )"
      PERDAYNAME="minute" 
    else
      DAY="$HLEFT hours"
      PERDAY="$( expr $RATIO \/ $HLEFT )"
      PERDAYNAME="hour" 
    fi
  else
    PERDAY="$( expr $RATIO \/ $SPLIT )"
    PERDAYNAME="day" 
  fi
fi

if [ "$WHEN" = "NOT" -a "$NOTRIALLIMIT" != "" ]; then
  if [ "$AFFILSFOLDER" != "" ]; then
    for folder in `echo $AFFILSFOLDER`; do
      cd $folder
      for affils in `ls`; do
        GAFFILS="$affils $GAFFILS"
      done
    done
    if [ "$GAFFILS" = "" ]; then
      GAFFILS="$AFFILS"
    else
      GAFFILS="$AFFILS $GAFFILS"
    fi
  else
    GAFFILS="$AFFILS"
  fi

  VERIFY=""
  for g in `grep -w GROUP $USERSLOCATION/$1`; do
    if [ "$EXCLUDED" != "YES" ]; then
      VERIFY="$( echo $GAFFILS | grep -w $g )"
      if [ "$VERIFY" != "" ]; then
        EG="$g"
        EXCLUDED="YES"
      fi
    fi
  done

  if [ "$DURNAME" = "month" ]; then
    MONTH="$(date +%m)"
    YEAR="$(date +%y)"
    MONTHNOW=$MONTH"-"$YEAR
    if [ "$EXCLUDED" != "YES" ]; then
      ## Check if the user has been on site for more then one month.
      MONTHADDED="$(grep -w $1 $PASSWD | awk -F":" '{print $5}' | awk -F"-" '{print $1"-"$3}')"
      if [ "$MONTHADDED" = "$MONTHNOW" ]; then
        EXCLUDED="YES"
        NOTONLONGENOUGH="TRUE"
      fi
    fi
  fi

fi

## Is the user excluded?
EXCLUDED2="$( echo "$EXCLUDE" | grep -w $1 )"
if [ "$EXCLUDED2" != "" ]; then
  if [ "$EXCLUDEDTEXT" = "" ]; then
    if [ -z "$CUSTOMSET" ]; then
      exit 0
    fi
  else
    if [ -z "$CUSTOMSET" ]; then
      echo "$SITENAME $EXCLUDEDTEXT"
      exit 0
    fi
  fi
fi  

SHOWL="$LIMIT"

if [ -z "$g" ]; then
  g="NoGroup"
fi

listnr="0"

proc_fetchtext() {
  TMPARG="$( grep -F "$USETEXT[$listnr]" $config | head -n 1)"
  hituser="$( echo $TMPARG | cut -d':' -f1 | cut -d'"' -f2 )"
  msg2="$( echo $TMPARG | cut -d':' -f2- | tr -d '"' )"

  if [ "$hituser" = "" -o "$msg2" = "" ]; then
    echo "Error with config "$USETEXT[$listnr]" - No user or text. Result was: USER=$hituser - TEXT=$msg2"
    exit 0
  fi

  if [ "$( echo "$hituser" | cut -c1 )" = "=" ]; then
    hitgroup="$( echo $hituser | cut -c2- )"
    for searchgroup in `grep "^GROUP " $USERSLOCATION/$USER | cut -d' ' -f2`; do
      if [ "$searchgroup" = "$hitgroup" ]; then
        OUTPUT="$msg2"
      fi
    done
  else
    if [ "$hituser" = "$USER" ]; then
      OUTPUT="$msg2"
    fi
  fi
  listnr="$( expr $listnr \+ 1 )"
  unset TMPARG
}

if [ "$WHEN" != "NOT" -o "$NOTRIALLIMIT" = "" ]; then
  ## Say what we want to say, depending on if the user passed the limit or not, for users in TRiAL or TRiAL-2
  case $PASSED in
    YES)
      if [ "$WHEN" = "NOT" ]; then

        ## Custom text for user who passed trial limit but isnt on trial. 
        USETEXT="C_PASSED_NOTRIAL"
        while [ "$C_PASSED_NOTRIALTOT" != "$listnr" ]; do
          proc_fetchtext
        done
        if [ -z "$OUTPUT" ]; then
          ## No custom text found. Using standard output.
          OUTPUT="$PASSED_NOTRIAL"
        fi
        proc_cookies
        echo $OUTPUT
        exit 0

      else
        if [ "$WHEN" = "NEXT" ]; then

          ## Custom text for user on trial next duration and has passed (early).
          USETEXT="C_PASSED_NEXTDUR"
          while [ "$C_PASSED_NEXTDURTOT" != "$listnr" ]; do
            proc_fetchtext
          done
          if [ -z "$OUTPUT" ]; then
            ## No custom text found. Using standard output.
            OUTPUT="$PASSED_NEXTDUR"
          fi
          proc_cookies
          echo $OUTPUT
          exit 0

        else

          ## Custom text for users whos on trial and passed.
          USETEXT="C_PASSED_TRIAL"
          while [ "$C_PASSED_TRIALTOT" != "$listnr" ]; do
            proc_fetchtext
          done
          if [ -z "$OUTPUT" ]; then
            ## No custom text found. Using standard output.
            OUTPUT="$PASSED_TRIAL"
          fi
          proc_cookies
          echo $OUTPUT   
          exit 0

        fi
      fi
      ;;
    NO)
      if [ "$WHEN" = "NOT" ]; then

        ## Custom text for user who isnt on trial and havent passed (with quota disabled).
        USETEXT="C_NOTPASSED_NOTRIAL"
        while [ "$C_NOTPASSED_NOTRIALTOT" != "$listnr" ]; do
          proc_fetchtext
        done
        if [ -z "$OUTPUT" ]; then
           ## No custom text found. Using standard output.
          OUTPUT="$NOTPASSED_NOTRIAL"
        fi
        proc_cookies
        echo $OUTPUT   
        exit 0

      else
        if [ "$WHEN" = "NEXT" ]; then

          ## Custom text for user who is on trial next duration and didnt pass yet.
          USETEXT="C_NOTPASSED_NEXTDUR"
          while [ "$C_NOTPASSED_NEXTDURTOT" != "$listnr" ]; do
            proc_fetchtext
          done
          if [ -z "$OUTPUT" ]; then
            ## No custom text found. Using standard output.
            OUTPUT="$NOTPASSED_NEXTDUR"
          fi
          proc_cookies
          echo $OUTPUT            
          exit 0

        else

          ## Custom text for user who did not pass trial.. yet
          USETEXT="C_NOTPASSED_TRIAL"
          while [ "$C_NOTPASSED_TRIALTOT" != "$listnr" ]; do
            proc_fetchtext
          done
          if [ -z "$OUTPUT" ]; then
            ## No custom text found. Using standard output.
            OUTPUT="$NOTPASSED_TRIAL"
          fi
          proc_cookies
          echo $OUTPUT   
          exit 0

        fi
      fi
      ;;
    *)
      echo "Error in script. User neither passed or failed trial."
      exit 1
      ;;
  esac
else
  ## Users on Quota.
  case $PASSED in
    YES)
      if [ "$FULLMSG" = "TRUE" ]; then
        echo "$SITENAME $MSG"
      else
        if [ "$EXCLUDED" = "YES" ]; then

          if [ "$NOTONLONGENOUGH" = "TRUE" ]; then

            ## Custom text for excluded user who havent been on long enough and passed.
            USETEXT="C_FIRST_QUOTA_PASSED"
            while [ "$C_FIRST_QUOTA_PASSEDTOT" != "$listnr" ]; do
              proc_fetchtext
            done

          else

            ## Custom text for excluded quota user who passed.
            USETEXT="C_QUOTA_EX_PASSED"
            while [ "$C_QUOTA_EX_PASSEDTOT" != "$listnr" ]; do
              proc_fetchtext
            done

          fi

          if [ -z "$OUTPUT" ]; then
            if [ "$NOTONLONGENOUGH" = "TRUE" ]; then
              ## No custom text found. Use normal output for user who havent been on long enough.
              OUTPUT="$FIRST_QUOTA_PASSED"
            else
              ## No custom text found. Use normal output for user on quota
              OUTPUT="$QUOTA_EX_PASSED"
            fi
          fi

          proc_cookies
          echo $OUTPUT
          exit 0
        else

          ## Custom text for user on quota who passed.
          USETEXT="C_QUOTA_PASSED"
          while [ "$C_QUOTA_PASSEDTOT" != "$listnr" ]; do
            proc_fetchtext
          done

          if [ -z "$OUTPUT" ]; then
            ## No custom text found. Use normal output.
            OUTPUT="$QUOTA_PASSED"
          fi

          proc_cookies
          echo $OUTPUT
          exit 0
        fi
      fi
      ;;
    NO)
      if [ "$FULLMSG" = "TRUE" ]; then
        echo "$SITENAME $MSG"
      else
        if [ "$EXCLUDED" = "YES" ]; then
          if [ "$NOTONLONGENOUGH" = "TRUE" ]; then
 
            ## Custom text for excluded quota user who havent been on site for a month yet and have not passed.
            USETEXT="C_FIRST_QUOTA_NOTPASSED"
            while [ "$C_FIRST_QUOTA_NOTPASSEDTOT" != "$listnr" ]; do
              proc_fetchtext
            done

          else

            ## Custom text for excluded quota user who have not passed.
            USETEXT="C_QUOTA_EX_NOTPASSED"
            while [ "$C_QUOTA_EX_NOTPASSEDTOT" != "$listnr" ]; do
              proc_fetchtext
            done

          fi

          if [ -z "$OUTPUT" ]; then
            if [ "$NOTONLONGENOUGH" = "TRUE" ]; then
              OUTPUT="$FIRST_QUOTA_NOTPASSED"
            else
              OUTPUT="$QUOTA_EX_NOTPASSED"
            fi
          fi

          proc_cookies
          echo $OUTPUT
          exit 0
        else

          ## Custom text for user on quota and havent passed.
          USETEXT="C_QUOTA_NOTPASSED"
          while [ "$C_QUOTA_NOTPASSEDTOT" != "$listnr" ]; do
            proc_fetchtext
          done

          if [ -z "$OUTPUT" ]; then
            ## No custom text set. Use normal output.
            OUTPUT="$QUOTA_NOTPASSED"
          fi

          proc_cookies
          echo $OUTPUT
          exit 0
        fi
      fi
      ;;
    *)
      echo "Error in script. User neither passed or failed trial."
      exit 1
      ;;
  esac
fi

exit 0
