#!/bin/bash
VER=1.3

#--[ Intro ]----------------------------------------------------------------#
#                                                                           #
# This is a script for users to transfer credits to other users. It can be  #
# set to use a "tax" in percentage for how much will be deducted from the   #
# amount the recipient gets.                                                #
#                                                                           #
# It can also be locked to users in their own groups, so they can transfer  #
# all they want between eachother, but not to other groups.                 #
# That was the idea from the start, hence the name "grouptransfer" although #
# it does not have to be that way.                                          #
#                                                                           #
# It only works in the DEFAULT creditsection (if you have multiples) but it #
# wont touch the other values so dont worry (iik).                          #
#                                                                           #
#--[ Installation ]---------------------------------------------------------#
#                                                                           #
# Copy tur-grouptransfer.sh to /glftpd/bin and chmod it to 755.             #
#                                                                           #
# Make sure you have some required binaries in /glftpd/bin as well. It will #
# look and complain for them, so you can skip that for the first test.      #
# Those are: bc, grep, egrep, cut, sed & tr                                 #
#                                                                           #
# Add it as a custom command in glftpd.conf. Use whatever command you wish. #
# site_cmd gtrans EXEC /bin/tur-grouptransfer.sh                            #
# custom-gtrans *                                                           #
#                                                                           #
#--[ Settings ]-------------------------------------------------------------#
#                                                                           #
# usersdir      = The directory holding your userfiles.                     #
#                                                                           #
#                 Note that glftpd has a bad habit of changing chmod on the #--#
#                 userfiles. The best solution I came up with was to add       #
#                 * * * * * chmod 777 /glftpd/ftp-data/users/* >/dev/null 2>&1 #
#                 to the crontab.                                              #
#                                                                           #--#
# msgs          = The path to your msgs dir if you want messages to be sent #
#                 to the recipient on a successful transfer. Otherwise, set #
#                 it to "" to disable sending messages.                     #
#                 FYI: Messages are not sent in test mode.                  #
#                 Set chmod 777 on the msgs dir to be safe.                 #
#                                                                           #
# owngrouponly  = true/false. If true, you can only transfer credits to     #
#                 users that are in one of your own groups. Checks all      #
#                 groups the user is in.                                    #
#                                                                           #
# blockleech    = true/false. If true, users with ratio 0 can not send or   #
#                 recieve credits with from this script. Suggest you leave  #
#                 it at true.                                               #
#                                                                           #
# glver         = Set to 1 if you use glftpd 1.3* or 2 if you use glftpd 2+ #
#                 NOTE on glftpd2. If you find that you can not transfer    #
#                 creds to people in your own group, make sure their        #
#                 userfile is correct. Each group in it should look like    #
#                 GROUP groupname 0/1                                       #
#                 If you are missing the final 0 or 1, it wont work.        #
#                                                                           #
# allowedgroups = Specify a number of groups who DO have access to this     #
#                 command. By default its disabled with "". Seperate them   #
#                 with a space, ie "iND FRiENDS SiTEOPS" etc.               #
#                                                                           #
#                 If you set owngrouponly to false above and this is not    #
#                 disabled then users in these groups can transfer to       #
#                 anyone.                                                   #
#                                                                           #
#                 If you set owngrouponly to true, users in the             #
#                 allowedgroups can only transfer in their own group.       #
#                                                                           #
#                 ( No, I cant make a predir check because this is run      #
#                   inside glftpd and users dont have access to each others #
#                   predirs. )                                              #
#                                                                           #
# setcommand    = This is just for the help part. Which command did you add #
#                 it as? I used 'site_cmd gtrans' in the example, so thats  #
#                 what this says per default.                               #
#                                                                           #
# minamount     = The minumum amount of MB to transfer. Set to 0 to disable #
#                                                                           #
# maxamount     = The maximum amount to transfer. The script is hardcoded   #
#                 to use max 10 characters max due to bash limitations, so  #
#                 set it to 999999999 to disable.                           #
#                                                                           #
# tmp           = A temporary directory. Note that this is inside /glftpd   #
#                 and /tmp does not exist per default. Create and set 777   #
#                                                                           #
# keeptmpfiles  = After copying the modified userfiles back to $usersdir,   #
#                 do you want to keep a copy of them in the $tmp dir?       #
#                 true = yes. false = No delete them.                       #
#                                                                           #
# log           = If you want to log transfers, heres the file it does that #
#                 to. Set to "" to disable. Otherwise, create the file and  #
#                 set chmod 777 on it.                                      #
#                 To change log format, search for proc_log. $* is the msg. #
#                                                                           #
# test          = true/false. With true, it will show you the calculations  #
#                 it makes and NOT move anything. Use this to test it, then #
#                 set it to false when satisfied.                           #
#                                                                           #
# tax           = Heres the tax setting in percent. Set to 1-99 or 0 to     #
#                 disable. Setting this to 10 and someone tries to give 500 #
#                 MB to someone will deduct 500 MB from that user and give  #
#                 450 MB to the recipient.                                  #
#                                                                           #
#--[ Changelog ]------------------------------------------------------------#
#                                                                           #
# 1.3   : Fixed for glftpd 2, for real this time ( I hope ).                #
#                                                                           #
# 1.2   : Added option glver=1 or 2 to define which version of glftpd you   #
#         use.                                                              #
#                                                                           #
# 1.1   : When using tax below 10%, it messed up. 5% got 50% etc.           #
#                                                                           #
#--[ Contact ]--------------------------------------------------------------#
#                                                                           #
# http://www.grandis.nu/glftpd                                              #
#                                                                           #
#--[ Settings ]-------------------------------------------------------------#

usersdir="/ftp-data/users"
msgs="/ftp-data/msgs"
owngrouponly=true
blockleech=true
glver=1

allowedgroups=""

setcommand="gtrans"
minamount="500"
maxamount="50000"

tmp="/tmp"
keeptmpfiles=true

log="/ftp-data/logs/tur-grouptransfer.log"
test=true

tax="10"


#--[ Script Start ]---------------------------------------------------------#

proc_help() {
  echo ""
  echo "#-[ Help ]---------------------------------#"
  echo "# Group Transfer $VER by Turranius - 2004"
  echo "# Usage:"
  echo "# $setcommand <giveuser> <amount in MB. $minamount-$maxamount>"
  echo "#"
  if [ "$tax" -a "$tax" != "0" ]; then
    echo "# NOTE: A tax of $tax% will be deducted from the transfer."
  fi
  if [ "$owngrouponly" = "true" ]; then
    echo "# You can only transfer internally in your own groups."
  fi
  if [ "$blockleech" = "true" ]; then
    echo "# You can not transfer credits to users with ratio 0. Neither"
    echo "# can you send credits if you have ratio 0."
  fi

  echo "#-[ End Help ]-----------------------------#"
}

proc_log() {
  if [ "$log" ]; then
    echo `date "+%a %b %e %T %Y"` \"$*\" >> $log
  fi
}

proc_sendmsg() {
  if [ "$msgs" ]; then
    echo "--------------------------------------------------------------------------" >> $msgs/$user2

    if [ "$tax" -a "$tax" != "0" ]; then
      echo "$USER transfered $newamountmb MB credits to you" >> $msgs/$user2
      echo "A $tax% tax was deducted from the original amount of $amount (-$taxedmb MB)" >> $msgs/$user2
    else
      echo "$USER transfered $amount MB to you. Be sure to say thanks." >> $msgs/$user2
    fi

    echo "!HThis message was generated by Tur-GroupTransfer $VER!0" >> $msgs/$user2
    echo " " >> $msgs/$user2
  fi
}

raw="$@"
if [ -z "$1" -o -z "$2" ]; then
  proc_help
  exit 0
else
  user2="$1"
  amount="$2"
fi

## Check for required binaries.
if [ "`echo "10 + 20" | bc -l`" != "30" ]; then
  echo "Error: Seems like 'bc' is not installed in glftpd's bin dir."
  echo "We cant continue without it. Once copied there, you'll get some"
  echo "lib errors. Simply locate those libs and copy them to the"
  echo "same position as you found them, but inside /glftpd."
  exit 1
elif [ ! -e "/bin/egrep" ]; then
  echo "Error: We need the binary 'egrep' in glftpd's bin dir. Copy it there."
  exit 1
elif [ ! -x "/bin/egrep" ]; then
  echo "Error: While egrep is in the bin dir, it is not executable. Set 755 perms on it."
  exit 1
elif [ ! -x "/bin/cut" ]; then
  echo "Error. cut binary needs to be in glftpd's bin dir. Copy and set 755 on it."
  exit 1
elif [ ! -d "$tmp" ]; then
  echo "Error. tmp dir $tmp does not exist or is not a directory."
  exit 1
elif [ ! -x "/bin/sed" ]; then
  echo "Error. You need the binary sed in glftpd's bin dir. Copy it and set 755 on it."
  exit 1
elif [ ! -x "/bin/tr" ]; then
  echo "Error. You need the binary tr in glftpd's bin dir. Copy it and set 755 on it."
  exit 1
fi
  
if [ "$log" ]; then
  if [ ! -e "$log" ]; then
    touch "$log"
    if [ ! -e "$log" ]; then
      echo "Error. $log does not exist and I cant create it for you."
      echo "Create it and set chmod 777 on it."
      exit 1
    else
      echo "The log has been created for you, but you need to run chmod 777 $log"
      exit 1
    fi
  elif [ ! -w "$log" ]; then
    echo "Error. $log exists but I cant write to it. Set chmod 777 on it."
    exit 1
  fi
fi

if [ "$msgs" ]; then
  if [ ! -d "$msgs" ]; then
    echo "Error. msgs dir defined as $msgs, but thats not found or not a dir - Aborting."
    exit 1
  fi
fi

proc_log "--[ Start v$VER by $USER/$GROUP - $raw ]--"
  
## Check that the selected user exists
## and that the user didnt select himself.
if [ ! -e "$usersdir/$user2" ]; then
  echo "User $user2 does not exist. Aborting."
  proc_log "User $user2 does not exist. Aborting"
  exit 1
fi
if [ "$USER" = "$user2" ]; then
  echo "Yeah, real clever."
  proc_log "Tried to use himself as recipient. Abort."
  exit 1
fi

## Check that neither the sender or recipient has leech, if check is enabled.
if [ "$blockleech" = "true" ]; then
  if [ "`grep "^RATIO " "$usersdir/$USER" | cut -d ' ' -f2`" = "0" ]; then
    echo "You have RATIO 0 and can therefor not transfer credits to others."
    exit 1
  elif [ "`grep "^RATIO " "$usersdir/$user2" | cut -d ' ' -f2`" = "0" ]; then
    echo "You can not transfer credits to $user2 due to him having RATIO 0."
    exit 1
  fi
fi

## Verify tax setting if its enabled.
if [ "$tax" -a "$tax" != "0" ]; then
  if [ "`echo "$tax" | tr -d [:digit:]`" ]; then
    echo "Error. tax argument can only be digits. Not $tax"
    exit 1
  elif [ "$tax" -lt "0" -o "$tax" -gt "99" ]; then
    echo "Error. tax argument can be between 1 and 99 only."
    exit 1
  fi
fi

## Check that the amount is made out of digits only.
if [ "`echo "$amount" | tr -d [:digit:]`" ]; then
  proc_help 
  echo ""
  echo "--> No go! Only use numbers as amount and only use full MB values <--"
  proc_log "Tried to use $amount as amount. Aborting."
  exit 1
fi

## Check that amount isnt more then the max allowed.
if [ "`echo "$amount" | grep ".........."`" ]; then
  proc_help
  echo ""
  echo "Error. amount can not be more then 10 chars long."
  proc_log "Tried to use a too big amount argument - $amount."
  exit 1
elif [ "`echo "$maxamount" | grep ".........."`" ]; then
  echo "Error. The maxamount argument can not be larger then 999999999"
  exit 1
fi

if [ "$amount" -gt "$maxamount" ]; then
  proc_help
  echo ""
  echo "Maximum amount of credits to transfer is $maxamount MB."
  echo "Aborting."
  proc_log "Tried to move $amount MB when $maxamount is the max."
  exit 1
fi

if [ "$amount" -lt "$minamount" ]; then
  proc_help
  echo ""
  echo "Minumum amount of credits to transfer is $minamount MB."
  echo "Aborting."
  proc_log "Tried to move $amount MB when $minamount is the minimum."
  exit 1
fi

if [ "$allowedgroups" ]; then
  for agroup in $allowedgroups; do
    if [ "$glver" = "1" ]; then
      if [ "$agroups" ]; then
        agroups="$agroups|^GROUP $agroup$"
      else
       agroups="^GROUP $agroup$"
      fi
    else
      if [ "$agroups" ]; then
        agroups="$agroups|^GROUP $agroup [0|1]"
      else
       agroups="^GROUP $agroup [0|1]"
      fi
    fi
  
  done
  if [ -z "`egrep "$agroups" $usersdir/$USER`" ]; then
    echo "You do not have access to this command."
    proc_log "Not in any allowed group - Access Denied."
    proc_log "Found out by grepping for $agroups"
    exit 1
  fi
fi

## Check if were in the same group, if thats enabled.
if [ "$owngrouponly" = "true" ]; then
  if [ -z "`grep "^GROUP " $usersdir/$USER`" ]; then
    echo "You are not in any groups so you can not transfer to anyone."
    proc_log "$USER isnt in any groups and owngrouponly is true. Aborting."
    exit 1
  fi

  for groupname in `grep "^GROUP " $usersdir/$USER | cut -d ' ' -f2`; do
    if [ "$owngroups" ]; then
      if [ "$glver" = "1" ]; then
        owngroups="$owngroups|^GROUP $groupname$"
      else
        owngroups="$owngroups|^GROUP $groupname\ [0|1]"
      fi
    else
      if [ "$glver" = "1" ]; then
        owngroups="^GROUP $groupname$"
      else
        owngroups="^GROUP $groupname\ [0|1]"
      fi
    fi
  done
  if [ -z "`egrep "$owngroups" $usersdir/$user2`" ]; then
    echo "Error. $user2 is not in any of your groups. Cant transfer credits to him."
    proc_log "$user2 isnt in any groups that $USER is in. Aborting."    
    exit 1
  fi
fi

## Remake the amount into kb, since the userfiles is in that format.
amountkb="`echo "$amount * 1024" | bc -l | cut -d '.' -f1`"

## Read current users credits.
usercredkb="`grep "^CREDITS " $usersdir/$USER | cut -d ' ' -f2`"
usercredmb="`echo "$usercredkb / 1024" | bc -l | cut -d '.' -f1`"

if [ -z "$usercredkb" ]; then
  echo "Error. Could not read your current CREDITS."
  proc_log "Cant read $USER's CREDITS field in $usersdir/$USER - Aborting."
  exit 1
fi

## Read destination users credits.
destusercredkb="`grep "^CREDITS " $usersdir/$user2 | cut -d ' ' -f2`"
destusercredmb="`echo "$destusercredkb / 1024" | bc -l | cut -d '.' -f1`"

if [ -z "$destusercredkb" ]; then
  echo "Error. Could not $user2's CREDITS."
  proc_log "Cant read $user2's CREDITS field in $usersdir/$user2 - Aborting."
  exit 1
fi

## Check that the user really has this much.
if [ "$amountkb" -gt "$usercredkb" ]; then
  echo "You do not have $amount MB credits, only $usercredmb MB."
  proc_log "Tried to move $amount MB but only have $usercredmb MB."
  exit 1
fi

## Deduct the tax from transfer, if its on.
if [ "$tax" -a "$tax" != "0" ]; then

  if [ "`echo "$tax" | grep "^.$"`" ]; then
    tax="0${tax}"
  fi

  ## KB
  taxedkb="`echo "$amountkb * 0.$tax" | bc -l | cut -d '.' -f1`"
  if [ -z "$taxedkb" ]; then taxedkb="0"; fi
  newamountkb="`echo "$amountkb - $taxedkb" | bc -l | cut -d '.' -f1`"

  ## MB
  taxedmb="`echo "$amount * 0.$tax" | bc -l | cut -d '.' -f1`"
  if [ -z "$taxedmb" ]; then taxedmb="0"; fi
  newamountmb="`echo "$amount - $taxedmb" | bc -l | cut -d '.' -f1`"

else
  newamountkb="$amountkb"
  newamountmb="$amount"
  taxedkb=0
  taxedmb=0
fi

## Count new credits values for source user ($USER)
newcredskb="`echo "$usercredkb - $amountkb" | bc -l | cut -d '.' -f1`"
newcredsmb="`echo "$usercredmb - $amount" | bc -l | cut -d '.' -f1`"

## Count new credits values for destination user ($user2) with taxed values.
destnewcredskb="`echo "$destusercredkb + $newamountkb" | bc -l | cut -d '.' -f1`"
destnewcredsmb="`echo "$destusercredmb + $newamountmb" | bc -l | cut -d '.' -f1`"

if [ ! -w "$usersdir/$USER" ]; then
  echo "Error. Can not write to your userfile. Tell siteops to fix perms."
  proc_log "Cant not write to $usersdir/$USER - Fix perms - Aborting."
  exit 1
elif [ ! -w "$usersdir/$user2" ]; then
  echo "Error. Can not write to $user2's userfile. Tell siteops to fix perms."
  proc_log "Cant not write to $usersdir/$user2 - Fix perms - Aborting."
  exit 1
fi

if [ -e "$usersdir/$USER.lock" ]; then
  echo "Your userfile seems locked. Try again (.lock file exists)."
  proc_log "$USER.lock exists. Aborting."
  exit 1
elif [ -e "$usersdir/$user2.lock" ]; then
  echo "$user2's userfile seems locked. Try agian (.lock file exists)."
  proc_log "$user2.lock exists. Aborting."
  exit 1
fi

if [ "$test" = "true" ]; then
  
  echo "#---------------------------------------------------#"
  echo "--Source user $USER"
  echo "--[ KB amounts ]--"
  echo "amountkb   : $amountkb  (amount set to move)"
  echo "newamountkb: $newamountkb  (after tax)"
  echo "usercredkb : $usercredkb  (current creds)"
  echo "newcredskb : $newcredskb  (new creds after move)"
  echo "--[ MB amounts ]--"
  echo "amount     : $amount  (amount set to move)"
  echo "newamountmb: $newamountmb  (after tax)"
  echo "usercredmb : $usercredmb  (current creds)"
  echo "newcredsmb : $newcredsmb  (new creds after move)"
  echo ""
  echo "--Destination user $user2"
  echo "--[ KB amounts ]--"
  echo "destusercredkb : $destusercredkb  (current creds)"
  echo "destnewcredskb : $destnewcredskb  (new creds after move)"
  echo "taxedkb        : $taxedkb  (KB taxed)"
  echo "--[ MB amounts ]--"
  echo "destusercredmb : $destusercredmb  (current creds)"
  echo "destnewcredsmb : $destnewcredsmb  (new creds after move)"
  echo "taxedmb        : $taxedmb  (MB taxed)"
  echo ""
  echo "#---------------------------------------------------#"

  proc_log "Test transsfer complete. $USER gave $user2 $newamountmb MB ($amount minus $taxedmb tax at $tax%)."

else

  ## Take creds.
  sed -e "s/^CREDITS [0-9]*/CREDITS $newcredskb/" $usersdir/$USER > $tmp/gtrans.tmp.$USER
  if [ "`grep "^CREDITS " $tmp/gtrans.tmp.$USER | cut -d ' ' -f2`" != "$newcredskb" ]; then
    echo "Error. Could not change your userfile to CREDITS $newcredskb."
    echo "Tell a siteop to fix perms in tmp and to look at your file there, called gtrans.tmp.$USER"
    proc_log "Error. Could not change $USER's userfile to CREDITS $newcredskb."
    proc_log "Tried to do it in the temp file $tmp/gtrans.tmp.$USER but when I check that now"
    proc_log "the CREDITS should be $newcredskb, which it isnt - Aborting."
    exit 1
  fi
  ## Give creds
  sed -e "s/^CREDITS [0-9]*/CREDITS $destnewcredskb/" $usersdir/$user2 > $tmp/gtrans.tmp.$user2
  if [ "`grep "^CREDITS " $tmp/gtrans.tmp.$user2 | cut -d ' ' -f2`" != "$destnewcredskb" ]; then
    echo "Error. Could not change $user2's userfile to CREDITS $destnewcredskb."
    echo "Tell a siteop to fix perms in tmp and to look at the file there, called gtrans.tmp.$user2"
    proc_log "Error. Could not change $user2's userfile to CREDITS $destnewcredskb."
    proc_log "Tried to do it in the temp file $tmp/gtrans.tmp.$user2 but when I check that now"
    proc_log "the CREDITS should be $destnewcredskb, which it isnt - Aborting."
    exit 1
  fi

  ## Copy source user back to $usersdir and verify that he has the creds he's supposed to.
  cp -f $tmp/gtrans.tmp.$USER $usersdir/$USER
  if [ "`grep "^CREDITS " $usersdir/$USER | cut -d ' ' -f2`" != "$newcredskb" ]; then
    echo "Error. After copying your new userfile, I cant verify that your credits are $newcredskb"
    echo "as they should be by now. I'll abort. Are you possibly trading at the same time?"
    proc_log "ERROR! After copying $USER's userfile back to $usersdir/$USER, hes CREDITS are not"
    proc_log "$newcredskb as they should be. He had $usercredskb KB ($usercredsmb MB) credits before."
    proc_log "Might want to check that out as I'm not giving any credits to $user2 right now."
    proc_log "Hes temporary userfile with modified values are in $tmp/gtrans.tmp.$USER - Aborting."
    exit 1
  fi

  ## Copy destination user back to $usersdir and verify that he has the creds he's supposed to.
  cp -f $tmp/gtrans.tmp.$user2 $usersdir/$user2
  if [ "`grep "^CREDITS " $usersdir/$user2 | cut -d ' ' -f2`" != "$destnewcredskb" ]; then
    echo "Error. After copying $user2's new userfile, I cant verify that the credits are $destnewcredskb"
    echo "as they should be by now. Too late to abort now though."
    proc_log "ERROR! After copying $user2's (recipient) userfile, I cant verify that he got the credits"
    proc_log "that he should have gotten. He had $destusercredkb KB ($destusercredmb MB) credits before"
    proc_log "and should have gotten newaboutkb KB ($newamountmb MB) credits."
    proc_log "$USER had $usercredskb KB ($usercredsmb MB) credits before and now newcredskb KB ($newcredsmb MB)"
    proc_log "credits (that seemed to have gone ok)."
    exit 1
  fi

  if [ "keeptmpfiles" != "true" ]; then
    rm -f $tmp/gtrans.tmp.$user2
    rm -f $tmp/gtrans.tmp.$USER
  fi

  ## Send a msg if enabled.
  proc_sendmsg

  ## Talk
  if [ "$tax" -a "$tax" != "0" ]; then
    echo "You give $newamountmb MB ($amount minus $taxedmb tax at $tax%) to $user2"
    proc_log "Transfer complete. $USER gave $user2 $newamountmb MB ($amount minus $taxedmb tax at $tax%)."
  else
    echo "You give $newamountmb MB to $user2"
    proc_log "Transfer complete. $USER gave $user2 $newamountmb MB credits."
  fi
fi
