#!/bin/bash
VER=1.0

#--[ Intro ]-------------------------------------------------#
#                                                            #
# Tur-SymLinksCleaner. A script to keep your existing syms   #
# on track as they move through your filesystem becuase of   #
# spacemaker scripts etc etc.                                #
# It does not create new symlinks, only keep track of your   #
# existing ones.                                             #
#                                                            #
#--[ Installation ]------------------------------------------#
#                                                            #
# Copy tur-symlinkcleaner.sh to /glftpd/bin and chmod it to  #
# 700 or something (root executable).                        #
#                                                            #
# Edit the settings as follows:                              #
#                                                            #
# TULS     = This script requires tuls. A standalone ls bin  #
#            available at http://www.grandis.nu/glftpd.      #
#            Read the installation for that one. Once working#
#            you specify the path to it here.                #
#                                                            #
# GLROOT   = Path to your glftpd directory.                  #
#                                                            #
# SYMDIRS  = This is where you specify WHERE to look for     #
#            symlinks. You can specify several directories   #
#            and it will go through them all, space seperated#
#                                                            #
# ENTER_SUBDIRS = TRUE/FALSE. With this one TRUE, it will    #
#                 enter each subdir in the SYMDIRS before    #
#                 starting to look for symlinks.             #
#                 If you have one big dir containing syms,   #
#                 you can set this to FALSE. However, if you #
#                 have one dir containing multiple other     #
#                 dirs, which contains the symlinks, set it  #
#                 to TRUE and just define the top level dir. #
#                                                            #
# DESTDIRS = When it finds a symlink that points to a non    #
#            existant directory, this is the directories it  #
#            will start to search in. It will go through     #
#            them all and see if the directory is in there.  #
#            If it finds it in any of them, the symlink will #
#            be updated. If it does not, the symlink will be #
#            removed.                                        #
#            Seperate directories with a space or a newline. #
#                                                            #
# ENTER_DESTSUBDIRS = TRUE/FALSE. Same as with ENTER_SUBDIRS #
#                     With this on TRUE, it will enter each  #
#                     subdir of the defined DESTDIR before   #
#                     looking for the releases.              #
#                                                            #
# DEBUG    = TRUE/FALSE. Will tell you on screen what its    #
#            doing all the time. It will still do everything #
#            as it would with it set to FALSE too.           #
#                                                            #
# TEST     = TRUE/FALSE. With this one TRUE, it will act as  #
#            if it was running for real, but it wont actually#
#            update or delete any symlinks.                  #
#            Really only useful if DEBUG is TRUE too.        #
#                                                            #
# BASE_RELEASENAME_ON_SYMLINK =                              #
#            TRUE/FALSE. This is a tricky one to explain.    #
#            What to base the releasename on? The symlink    #
#            name itself or the directory it is pointing to. #
#            For most people, this dosnt matter as your      #
#            symlinks normally are named exactly the same as #
#            the directory its pointing to.                  #
#            However, if you have a symlink named "Movie"    #
#            and it points to the dir: /site/movie/Great.One #
#            you might want to set this to FALSE as it will  #
#            then look for the directory Great.One instead   #
#            of the directory "Movie".                       #
#                                                            #
#--[ Running it ]--------------------------------------------#
#                                                            #
# The first time, run it with DEBUG=TRUE and TEST=TRUE.      #
# After you've tested it enough, crontab it to run as often  #
# as you see fit.                                            #
# Something like:                                            #
# */120 * * * * /glftpd/bin/tur-symlinkcleaner.sh            #
# to run it every 2 hours perhaps?                           #
#                                                            #
#--[ Contact ]-----------------------------------------------#
#                                                            #
# http://www.grandis.nu/glftpd & http://grandis.mine.nu      #
#                                                            #
#--[ Configuration ]-----------------------------------------#


TULS=/glftpd/bin/tuls
GLROOT=/glftpd

SYMDIRS="
/site/Sorted.Movies/By.Group
"

ENTER_SUBDIRS=TRUE

DESTDIRS="
/site/Archive/DIVX
/site/Archive/DVDR
"

ENTER_DESTSUBDIRS=TRUE

DEBUG=TRUE
TEST=TRUE

BASE_RELEASENAME_ON_SYMLINK=TRUE


#--[ Script Start ]------------------------------------------#

if [ ! -x "$TULS" ]; then
  echo "Error. Can not execute tuls at $TULS - Check path and permission."
  exit 1 
fi

proc_debug() {
  if [ "$DEBUG" = "TRUE" ]; then
    echo "$*"
  fi
}

proc_findit() {
  if [ -e "$GLROOT$search_path/$release" ]; then
    proc_debug "Found $release in $search_path"
    NEW_PATH="$search_path"
    break
  fi
}

proc_find_dir() {
  unset NEW_PATH
  for destdir in $DESTDIRS; do
    cd $GLROOT$destdir
    if [ "$ENTER_DESTSUBDIRS" = "TRUE" ]; then
      for subdir in `$TULS | grep "^d" | egrep -v "\:\:\.\:\:|\:\:\.\.\:\:" | awk -F"::::" '{print $4}'`; do
        if [ "$NEW_PATH" ]; then
          break
        fi        
        proc_debug " Looking in $destdir/$subdir"
        search_path="$destdir/$subdir"
        proc_findit
      done
    else
      proc_debug " Looking in $destdir"
      search_path="$destdir"
      proc_findit
    fi
  done

  if [ "$NEW_PATH" ]; then
    proc_debug " Removing old and making new symlink to $NEW_PATH/$release"
    if [ "$TEST" != "TRUE" ]; then
      rm -f "$source_dir/$release"
      ln -s -f "$NEW_PATH/$release" "$source_dir/$release"
    fi
  else
    proc_debug " Removing $symlink - not found anywhere"
    if [ "$TEST" != "TRUE" ]; then
      rm -f "$source_dir/$release"
    fi
  fi
  proc_debug " "
}

proc_fixsyms() {
  for symlink in `$TULS | grep "^l" | awk -F"::::" '{print $4}'`; do
    cd $cur_symdir
    sym_dest=`ls -al | grep "\ $symlink\ " | cut -d '>' -f2 | tr -d ' '`
    if [ ! -e "$GLROOT$sym_dest" ]; then
      proc_debug "Symlink not found $GLROOT$sym_dest"
      source_dir="$PWD"
      if [ "$BASE_RELEASENAME_ON_SYMLINK" = "TRUE" ]; then
        release="$symlink"
      else
        release="`basename $sym_dest`"
      fi
      proc_find_dir
    fi
  done
}

## Enter each symdir
for symdir in $SYMDIRS; do
  if [ ! -d "$GLROOT$symdir" ]; then
    proc_debug "$GLROOT$symdir does not exist. Skipping."
  else
    cd $GLROOT$symdir
    if [ "$ENTER_SUBDIRS" = "TRUE" ]; then
      for subdir in `$TULS | grep "^d" | egrep -v "\:\:\.\:\:|\:\:\.\.\:\:" | awk -F"::::" '{print $4}'`; do
        cur_symdir="$GLROOT$symdir/$subdir"
        cd $GLROOT$symdir/$subdir
        proc_debug "Checking symlinks in $GLROOT$symdir/$subdir"
        proc_fixsyms
      done
    else
      cur_symdir="$GLROOT$symdir"
      proc_debug "Checking symlinks in $GLROOT$symdir"
      proc_fixsyms
    fi
  fi
done

exit 0