#!/bin/bash
VER=1.1
#-------------------------------------------------------------------#
# Tur-UserInfo by Turranius.                                        #
# Useless script to show info about a user in irc. What it          #
# shows and how is entirely up to you.                              #
# Also works as a totally configurable !ginfo from irc.             #
#                                                                   #
#-[ Installation ]--------------------------------------------------#
#                                                                   #
# Put tur-userinfo.sh in /glftpd/bin and make it executable         #
# ( chmod 755 tur-userinfo.sh )                                     #
# Put tur-userinfo.tcl in your bots 'scripts' folder, load it in    #
# bots config folder and rehash the bot.                            #
#                                                                   #
# Configure the settings below.                                     #
#                                                                   #
# GLROOT     = Rootpath to glftpd. All paths below are relative to  #
#              this one.                                            #
# USERDIR    = Path to users                                        #
# PASSWD     = Path to passwd file                                  #
# STATSBIN   = This script requires the binary 'stats' which comes  #
#              with glftpd. This is the path to it.                 #
#              If your glftpd.conf is not in /etc, change it to     #
#              STATSBIN="/path/to/stats -r /path/to/glftpd.conf"    #
#                                                                   #
#              If you do not plan to use any of the stats cookies,  #
#              set this to "" to disable the function. This will    #
#              speed up the script quite a bit.                     #
#                                                                   #
# MB2GBAT=   = This is for the %CREDITS%, %NUKEDMB% and the up/down #
#              MB stats cookies. By default, this                   #
#              is in MB. If you set this to, say, 10000, it will    #
#              convert all MB to GB above that number. Easier to    #
#              read. Set to "" to always show MB.                   #
#                                                                   #
# EXCLUDEDUSERS=  These users can not be checked. Space seperated.  #
# EXCLUDEDGROUPS= These groups can not be checked. Space seperated. #
# AFFILSDIRS=     Like some of my other scripts, this is the pre-   #
#                 folders you have. If you like to exclude every    #
#                 affil you have from both user check and ginfo,    #
#                 set this to a folder containing predirs. If a     #
#                 user or group match what you are trying to check  #
#                 it will be denied.                                #
#                 You can add as many folders as you like, space    #
#                 seperated.                                        #
#                                                                   #
# DATEBIN    = Shouldnt need to change this. See 'Note' below       #
# SITENAME   = Name of your site                                    #
# NOUSER     = What to say if no user is specified                  #
#              %USER%, %BOLD% and %ULINE% cookies only.             #
# NOEXISTS   = What to say if the user specified does not exist     #
#              %SITENAME%, %USER%, %BOLD% and %ULINE% cookies only. #
#                                                                   #
# EXCLUDEDUSERTEXT=  What to say incase user is excluded. Set to "" #
#                    to simply ignore that request. %SITENAME%,     #
#                    %USER%, %BOLD% and %ULINE% cookies only.       #
#                                                                   #
# EXCLUDEDGROUPTEXT= What to say if the group is excluded. Set to   #
#                    "" to ignore the request. %SITENAME%, %GROUP%, #
#                    %BOLD% and %ULINE% cookies only.               #
#                                                                   #
# Ok, next are some cookie explanations for what you can use in the #
# output. Below that is a 'proc_output() {' line. Everything within #
# those { } is what will be said in the output for single users.    #
# You can change this as you wish. If you want just one line, just  #
# make one big OUTPUT. Every OUTPUT must be followed by the         #
# proc_cookies; echo "$OUTPUT"                                      #
# (proc_cookies translates cookes to real values and echo $OUTPUT   #
# does the outputting to screen/chan).                              #
#                                                                   #
# This script also has a ginfo type output. Thats right below the   #
# proc_output() and is called proc_groupoutput. When doing a        #
# !ginfo GROUP from irc, this like will be displayed for each user  #
# in that group. You can use the same cookies here as in the one    #
# for users. Its locked for ops only per default.                   #
# Per default, its one line per user, but change it as you like...  #
#                                                                   #
# Play around with this all you want.                               #
#                                                                   #
# Try running it from shell. If it works from shell, it should work #
# from bot.                                                         #
#                                                                   #
# Note: This has been tested on RedHat and Mandrake.                #
#       FBSD users wont get this to work out of the box. You need   #
#       to compile sh-utils and use 'gdate' instead of 'date'.      #
#       The FBSD guru silicon^ informs me that you should be able   #
#       to:                                                         #
#       cd /usr/ports/misc/sh-utils                                 #
#       make && make install                                        #
#       Then change DATEBIN to ="/usr/local/bin/gdate"              #
#                                                                   #
# Hint: If you wish, you can use this script as a custom command in #
#       glftpd. The stats binary does not work there though, so you #
#       must set STATSBIN to ="" and not use any ALUP stats etc in  #
#       the output.                                                 #
#       To add it as a custom command called 'turstats', do this:   #
#       edit /etc/glftpd.conf and add:                              #
#       site_cmd turstats           EXEC    /bin/tur-userinfo.sh    #
#       custom-turstats             *                               #
#                                                                   #
#       To check groups, do: site turstats groupname CheckGroup     #
#                                                                   #
#-[ Contact info ]--------------------------------------------------#
#                                                                   #
# Contact Turranius on efnet. Usually in #glftpd                    #
# Web: http://www.grandis.nu/glftpd or http://grandis.mine.nu       #
#                                                                   #
#-[ Changelog ]-----------------------------------------------------#
#                                                                   #
# 1.1  : Add: Added !ginfo output for checking ginfo from irc.      #
#             Replace the .tcl if you wish to use this function.    #
#                                                                   #
#        Add: Added ability to exclude users, groups as well as add #
#             your prefolders for automatic exclude of those users. #
#                                                                   #
#        Add: Added cookie %CREDITS% to display credits as well as  #
#             the setting MB2GBAT so you can set at which limit it  #
#             should convert it to GB. The %CREDITS% cookie always  #
#             adds either MB or GB after the number.                #
#             The MB2GBAT also works on NUKEDMB and all the stats   #
#             up/down MB.                                           #
#                                                                   #
#        Add: Added ability to set STATSBIN="" for those that do    #
#             not use any ALUP etc stats. This speeds the script up #
#             a whole lot!                                          #
#                                                                   #
#        Add: Added the ability to run it as a custom command in    #
#             glftpd. STATSBIN must be blank for this to work !     #
#                                                                   #
# 1.0  : Initial release                                            #
#                                                                   #
#-[ Settings ]------------------------------------------------------#

GLROOT=/glftpd
USERDIR=/ftp-data/users
PASSWD=/etc/passwd
STATSBIN=/bin/stats
DATEBIN=date
MB2GBAT=10000

EXCLUDEDUSERS=""
EXCLUDEDGROUPS=""
AFFILSDIRS=""

SITENAME="-xXx-"
NOUSER="Specify a user to check too"
NOEXISTS="%BOLD%%SITENAME% [STATS] %USER%%BOLD% does %ULINE%not%ULINE% exist on $SITENAME"
EXCLUDEDUSERTEXT="%SITENAME% [STATS]%BOLD% User %BOLD%%USER%%BOLD% can not be checked"
EXCLUDEDGROUPTEXT="%SITENAME% [STATS]%BOLD% Group %BOLD%%GROUP%%BOLD% can not be checked"

## Cookies:
# %BOLD%          = Start and stop bold text
# %ULINE%         = Start and stop underlined text
#
# %USER%          = Username checked
# %GROUP%         = Primary group of user
# %RATIO%         = Users ratio
# %FLAGS%         = Users flags
# %CREDITS%       = Users credits
# %DATEADDED%     = The date the user was added
# %DAYSAGO%       = How many days since user was added
# %ADDEDBY%       = Who added this user
# %TIMESNUKED%    = How many times user got nuked
# %MBNUKED%       = How much in MB was nuked
# %TIMESLOGIN%    = How many times the user logged in
# %LOGINTIMERANK% = Rank users on how many times they logged in
# %LASTON%        = How long since user was last logged on
# %ONTODAY%       = How many minutes the users been online today
#
# %ALUPRANK%      = Users rank on All Uploads
# %ALUPMB%        = Users alltime upload in MB
# %ALUPFILE%      = Users alltime upload in files
# %ALUPSPD%       = Users speed on alltime up.
#
## Other cookies are ALDN, MNUP, MNDN, WKUP, WKDN, DAUP, DADN

## Below is what it will say on single user check. Its:
## OUTPUT="Text to say"
## proc_cookies; echo "$OUTPUT"
##
## etc
proc_output() {

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% was added on %DATEADDED% (%DAYSAGO% days ago) by %ADDEDBY%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% has logged in a total of %TIMESLOGIN% times putting %USER% at %BOLD%# %LOGINTIMESRANK%%BOLD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% was last seen logging on %LASTON% ago. Time on today: %ULINE%%ONTODAY%%ULINE% minutes"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% Times nuked: %TIMESNUKED% - MB Nuked: %MBNUKED% - Last nuke was %LASTNUKED% ago"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% ALUP %BOLD%#%ALUPRANK%%BOLD% - %ALUPFILE% files in %ALUPMB% at %ALUPSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% ALDN %BOLD%#%ALDNRANK%%BOLD% - %ALDNFILE% files in %ALDNMB% at %ALDNSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% MNUP %BOLD%#%MNUPRANK%%BOLD% - %MNUPFILE% files in %MNUPMB% at %MNUPSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% MNDN %BOLD%#%MNDNRANK%%BOLD% - %MNDNFILE% files in %MNDNMB% at %MNDNSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% WKUP %BOLD%#%WKUPRANK%%BOLD% - %WKUPFILE% files in %WKUPMB% at %WKUPSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% WKDN %BOLD%#%WKDNRANK%%BOLD% - %WKDNFILE% files in %WKDNMB% at %WKDNSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% DAUP %BOLD%#%DAUPRANK%%BOLD% - %DAUPFILE% files in %DAUPMB% at %DAUPSPD%"
  proc_cookies; echo "$OUTPUT"

  OUTPUT="%BOLD%%SITENAME% [STATS] %USER%%BOLD%/%GROUP% DADN %BOLD%#%DADNRANK%%BOLD% - %DADNFILE% files in %DADNMB% at %DADNSPD%"
  proc_cookies; echo "$OUTPUT"

}


## Below is what it will say when doing a !ginfo from irc. This will be displayed for each user in that group
## so per default its one line only. All the cookies work here too.
proc_groupoutput() {

  OUTPUT="%BOLD%%SITENAME% [GINFO %GROUP%] %USER%%BOLD% [ALL UP:%ALUPRANK% DN:%ALDNRANK%] [MN UP:%MNUPRANK% DN:%MNDNRANK%] [WK UP:%WKUPRANK% DN: %WKDNRANK%] [DAY UP:%DAUPRANK% DN:%DADNRANK%] [Credits: %CREDITS%] [Added %DATEADDED% -%DAYSAGO% by %ADDEDBY% ] "
  proc_cookies; echo "$OUTPUT"

}


##################################################################################
# No changes below here.                                                         #
##################################################################################

USER="$1"

if [ -z "$FLAGS" ]; then
  USERDIR=$GLROOT$USERDIR
  PASSWD=$GLROOT$PASSWD
  STATSBIN=$GLROOT$STATSBIN
else
  if [ "$STATSBIN" ]; then
    echo "Error. When running from glftpd, STATSBIN must be ="" and stats cant be used in cookies."
    exit 0
  fi
fi

proc_cookies() {
  if [ "$USER" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%USER%/$USER/g" )"
  fi
  if [ "$RATIO" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%RATIO%/$RATIO/g" )"
  fi
  if [ "$FLAGS" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%FLAGS%/$FLAGS/g" )"
  fi
  if [ "$GROUP" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%GROUP%/$GROUP/g" )"
  fi
  if [ "$CREDITS" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%CREDITS%/$CREDITS/g" )"
  fi
  if [ "$DAYSAGO" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAYSAGO%/$DAYSAGO/g" )"
  fi
  if [ "$USERADDED" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DATEADDED%/$USERADDED/g" )"
  fi
  if [ "$ADDEDBY" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ADDEDBY%/$ADDEDBY/g" )"
  fi
  if [ "$TIMESLOGIN" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%TIMESLOGIN%/$TIMESLOGIN/g" )"
  fi
  if [ "$LOGINTIMESRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%LOGINTIMESRANK%/$LOGINTIMESRANK/g" )"
  fi
  if [ "$TIMESNUKED" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%TIMESNUKED%/$TIMESNUKED/g" )"
  fi
  if [ "$MBNUKED" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MBNUKED%/$MBNUKED/g" )"
  fi
  if [ "$LASTNUKED" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%LASTNUKED%/$LASTNUKED/g" )"
  fi
  if [ "$LASTON" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%LASTON%/$LASTON/g" )"
  fi
  if [ "$ONTODAY" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ONTODAY%/$ONTODAY/g" )"
  fi
  if [ "$SITENAME" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%SITENAME%/$SITENAME/g" )"
  fi
  if [ "$ALUPRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALUPRANK%/$ALUPRANK/g" )"
  fi
  if [ "$ALUPFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALUPFILE%/$ALUPFILE/g" )"
  fi
  if [ "$ALUPMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALUPMB%/$ALUPMB/g" )"
  fi
  if [ "$ALUPSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALUPSPD%/$ALUPSPD/g" )"
  fi
  if [ "$ALDNRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALDNRANK%/$ALDNRANK/g" )"
  fi
  if [ "$ALDNFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALDNFILE%/$ALDNFILE/g" )"
  fi
  if [ "$ALDNMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALDNMB%/$ALDNMB/g" )"
  fi
  if [ "$ALDNSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%ALDNSPD%/$ALDNSPD/g" )"
  fi
  if [ "$MNUPRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNUPRANK%/$MNUPRANK/g" )"
  fi
  if [ "$MNUPFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNUPFILE%/$MNUPFILE/g" )"
  fi
  if [ "$MNUPMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNUPMB%/$MNUPMB/g" )"
  fi
  if [ "$MNUPSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNUPSPD%/$MNUPSPD/g" )"
  fi
  if [ "$MNDNRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNDNRANK%/$MNDNRANK/g" )"
  fi
  if [ "$MNDNFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNDNFILE%/$MNDNFILE/g" )"
  fi
  if [ "$MNDNMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNDNMB%/$MNDNMB/g" )"
  fi
  if [ "$MNDNSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%MNDNSPD%/$MNDNSPD/g" )"
  fi
  if [ "$WKUPRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKUPRANK%/$WKUPRANK/g" )"
  fi
  if [ "$WKUPFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKUPFILE%/$WKUPFILE/g" )"
  fi
  if [ "$WKUPMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKUPMB%/$WKUPMB/g" )"
  fi
  if [ "$WKUPSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKUPSPD%/$WKUPSPD/g" )"
  fi
  if [ "$WKDNRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKDNRANK%/$WKDNRANK/g" )"
  fi
  if [ "$WKDNFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKDNFILE%/$WKDNFILE/g" )"
  fi
  if [ "$WKDNMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKDNMB%/$WKDNMB/g" )"
  fi
  if [ "$WKDNSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%WKDNSPD%/$WKDNSPD/g" )"
  fi
  if [ "$DAUPRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAUPRANK%/$DAUPRANK/g" )"
  fi
  if [ "$DAUPFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAUPFILE%/$DAUPFILE/g" )"
  fi
  if [ "$DAUPMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAUPMB%/$DAUPMB/g" )"
  fi
  if [ "$DAUPSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DAUPSPD%/$DAUPSPD/g" )"
  fi
  if [ "$DADNRANK" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DADNRANK%/$DADNRANK/g" )"
  fi
  if [ "$DADNFILE" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DADNFILE%/$DADNFILE/g" )"
  fi
  if [ "$DADNMB" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DADNMB%/$DADNMB/g" )"
  fi
  if [ "$DADNSPD" ]; then
    OUTPUT="$( echo $OUTPUT | sed -e "s/%DADNSPD%/$DADNSPD/g" )"
  fi
  OUTPUT="$( echo $OUTPUT | sed -e "s/%BOLD%//g" )"
  OUTPUT="$( echo $OUTPUT | sed -e "s/%ULINE%//g" )"
}

if [ "$2" = "GROUPOUTPUT" ]; then
  GROUPOUTPUT="TRUE"
fi

proc_checkexclude() {
  if [ "$AFFILSDIRS" ]; then
    for affilsdirs in $AFFILSDIRS; do
      if [ -d "$affilsdirs" ]; then
        cd $affilsdirs
        for affilsdir in `ls`; do
          if [ ! -z "GEXCLUDEDONE" ]; then
            if [ "$EXCLUDEDGROUPS" ]; then
              EXCLUDEDGROUPS="$affilsdir $EXCLUDEDGROUPS"
            else
              EXCLUDEDGROUPS="$affilsdir"
            fi
          fi
        done
        GEXCLUDEDONE="TRUE"
      else
        echo "Error. Path $affilsdirs in AFFILSDIRS does not exist."
        exit 0
      fi
    done
  fi

  if [ -z "$EXCLUDEDONE" ]; then
    if [ "$EXCLUDEDGROUPS" ]; then
      CHECKGROUPS="$( echo "$EXCLUDEDGROUPS" | tr -s ' ' '|' )"
      for each in `egrep -w "$CHECKGROUPS" $USERDIR/* | cut -d':' -f1`; do
        EXCLUDETHISONE="$( basename $each)"
        if [ -z "$EXCLUDEDUSERS" ]; then
          EXCLUDEDUSERS="$EXCLUDETHISONE"
        else
          EXCLUDEDUSERS="$EXCLUDETHISONE $EXCLUDEDUSERS"
        fi
        EXCLUDEDONE="TRUE"
      done
    fi
  fi
}

if [ "$( echo "$USER" | tr -d [:alnum:] | tr -d [=_=] | tr -d [=_=] )" != "" ]; then
  echo "Only use alphanumerical characters please [ Tried to check $USER ]."
  exit 0
fi

proc_checkexclude

if [ "$2" = "CheckGroup" ]; then
  SCRIPTNAME="$0"
  GROUP="$1"

  if [ "$EXCLUDEDGROUPS" ]; then
    CHECKEXCLUDE="$( echo "$EXCLUDEDGROUPS" | grep -w "$GROUP" )"
    if [ "$CHECKEXCLUDE" ]; then
      OUTPUT="$EXCLUDEDGROUPTEXT"
      proc_cookies
      echo "$OUTPUT"
      exit 0
    fi
  fi

  for USER in `grep -i "^GROUP $GROUP" $USERDIR/* | cut -d':' -f1`; do  
    FOUNDONE=TRUE
    USER="$( basename $USER )"
    $SCRIPTNAME $USER GROUPOUTPUT
  done
  if [ "$FOUNDONE" != "TRUE" ]; then
    echo "Group $GROUP not found.."
  fi
  exit 0
fi

if [ -z "$USER" ]; then
  OUTPUT="$NOUSER"
  proc_cookies
  echo "$OUTPUT"
  exit 0
fi

## Check if user is excluded.
if [ "$EXCLUDEDUSERS" ]; then
  CHECKEXCLUDE="$( echo "$EXCLUDEDUSERS" | grep -w "$USER" )"
  if [ "$CHECKEXCLUDE" ]; then
    OUTPUT="$EXCLUDEDUSERTEXT"
    proc_cookies
    echo "$OUTPUT"
    exit 0
  fi
  unset $CHECKEXCLUDE
fi

if [ ! -e "$USERDIR/$USER" ]; then
  OUTPUT="$NOEXISTS"
  proc_cookies
  echo "$OUTPUT"
  exit 0
fi

if [ "$STATSBIN" ]; then
  if [ ! -x $STATSBIN ]; then
    echo "Error: Cant execute STATSBIN: $STATSBIN - Check path and permissions."
    exit 0
  fi
fi

GROUP="$( grep "^GROUP " $USERDIR/$USER | cut -d' ' -f2 | head -n1 )"
if [ -z "$GROUP" ]; then
  GROUP="NoGroup"
fi

RATIO="$( grep "^RATIO " $USERDIR/$USER | cut -d' ' -f2 | head -n1 )"
if [ -z "$RATIO" ]; then
  RATIO="?"
fi

FLAGS="$( grep "^FLAGS " $USERDIR/$USER | cut -d' ' -f2 | head -n1 )"
if [ -z "$FLAGS" ]; then
  FLAGS="?"
fi

CREDITS="$( grep "^CREDITS " $USERDIR/$USER | cut -d' ' -f2 | head -n1 )"
if [ -z "$CREDITS" ]; then
  CREDITS="?"
else
  CREDITS="$( expr "$CREDITS" \/ "1024" )"
  if [ "$MB2GBAT" ]; then
    if [ "$CREDITS" -gt "$MB2GBAT" ]; then
      CREDITS="$( expr "$CREDITS" \/ "1024" )"
      CREDITS=$CREDITS"GB"
    else
      CREDITS=$CREDITS"MB"
    fi
  else
    CREDITS=$CREDITS"MB"
  fi
fi

num=0
for rawdata in `grep "^TIME " $USERDIR/* | sort -k2 -n -r | tr -s ' ' '^'`; do
  let num=$num+1
  username="$( echo $rawdata | cut -d':' -f1 )"
  username="$( basename $username )"
  TIMESLOGIN="$( echo $rawdata | cut -d'^' -f2 )"
  if [ "$username" = "$USER" ]; then
    LOGINTIMESRANK="$num"
    break
  fi
done
if [ -z "$LOGINTIMESRANK" ]; then
  TIMESLOGINRANK="?"
fi
if [ -z "$TIMESLOGIN" ]; then
  TIMESLOGIN="?"
fi

TIMESNUKED="$( grep "^NUKE " $USERDIR/$USER | cut -d' ' -f3 | head -n1 )"
if [ -z "$TIMESNUKED" ]; then
  FLAGS="?"
fi

MBNUKED="$( grep "^NUKE " $USERDIR/$USER | cut -d' ' -f4 | head -n1 )"
if [ -z "$MBNUKED" ]; then
  FLAGS="?"
else
  if [ "$MBNUKED" != "0" ]; then
    if [ "$MBNUKED" -gt "$MB2GBAT" ]; then
      MBNUKED="$( expr "$MBNUKED" \/ "1024" )"
      MBNUKED="$MBNUKED GB"
    else
      MBNUKED="$MBNUKED MB"
    fi
  else
    MBNUKED="$MBNUKED MB"
  fi
fi
ADDEDBYRAW="$( grep "^USER " $USERDIR/$USER )"
if [ "$( echo $ADDEDBYRAW | cut -d' ' -f2 )" = "Added" ]; then
  ADDEDBY="$( echo $ADDEDBYRAW | cut -d' ' -f4 )"
else
  ADDEDBY="?"
fi

ONTODAY="$( grep "^TIME " $USERDIR/$USER | cut -d' ' -f5 )"
if [ "$ONTODAY" ]; then
  ONTODAY="$( expr "$ONTODAY" \/ "60" | cut -d'.' -f1 )"
else
  ONTODAY="0"
fi

if [ "$STATSBIN" ]; then
  RAWDATA="$( $STATSBIN -a -u -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    ALUPRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    ALUPFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      ALUPMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      ALUPMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$ALUPMB" != "0" ]; then
        if [ "$ALUPMB" -gt "$MB2GBAT" ]; then
          ALUPMB="$( expr "$ALUPMB" \/ "1024" )"
          ALUPMB=$ALUPMB"GB"
        else
          ALUPMB=$ALUPMB"MB"
        fi
      else
        ALUPMB=$ALUPMB"MB"
      fi
    fi
    ALUPSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    ALUPRANK="--"
    ALUPFILE="0"
    ALUPMB="0MB"
    ALUPDPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -a -d -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    ALDNRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    ALDNFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      ALDNMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      ALDNMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$ALDNMB" != "0" ]; then
        if [ "$ALDNMB" -gt "$MB2GBAT" ]; then
          ALDNMB="$( expr "$ALDNMB" \/ "1024" )"
          ALDNMB=$ALDNMB"GB"
        else
          ALDNMB=$ALDNMB"MB"
        fi
      else
        ALDNMB=$ALDNMB"MB"
      fi
    fi
    ALDNSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    ALDNRANK="--"
    ALDNFILE="0"
    ALDNMB="0MB"
    ALDNSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -m -u -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    MNUPRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    MNUPFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      MNUPMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      MNUPMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$MNUPMB" != "0" ]; then
        if [ "$MNUPMB" -gt "$MB2GBAT" ]; then
          MNUPMB="$( expr "$MNUPMB" \/ "1024" )"
          MNUPMB=$MNUPMB"GB"
        else
          MNUPMB=$MNUPMB"MB"
        fi
      else
        MNUPMB=$MNUPMB"MB"
      fi
    fi
    MNUPSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    MNUPRANK="--"
    MNUPFILE="0"
    MNUPMB="0MB"
    MNUPSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -m -d -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    MNDNRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    MNDNFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      MNDNMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      MNDNMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$MNDNMB" != "0" ]; then
        if [ "$MNDNMB" -gt "$MB2GBAT" ]; then
          MNDNMB="$( expr "$MNDNMB" \/ "1024" )"
          MNDNMB=$MNDNMB"GB"
        else
          MNDNMB=$MNDNMB"MB"
        fi
      else
        MNDNMB=$MNDNMB"MB"
      fi
    fi
    MNDNSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    MNDNRANK="--"
    MNDNFILE="0"
    MNDNMB="0MB"
    MNDNSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -w -u -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    WKUPRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    WKUPFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      WKUPMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      WKUPMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$WKUPMB" != "0" ]; then
        if [ "$WKUPMB" -gt "$MB2GBAT" ]; then
          WKUPMB="$( expr "$WKUPMB" \/ "1024" )"
          WKUPMB=$WKUPMB"GB"
        else
          WKUPMB=$WKUPMB"MB"
        fi
      else
        WKUPMB=$WKUPMB"MB"
      fi
    fi
    WKUPSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    WKUPRANK="--"
    WKUPFILE="0"
    WKUPMB="0MB"
    WKUPSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -w -d -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    WKDNRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    WKDNFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      WKDNMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      WKDNMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$WKDNMB" != "0" ]; then
        if [ "$WKDNMB" -gt "$MB2GBAT" ]; then
          WKDNMB="$( expr "$WKDNMB" \/ "1024" )"
          WKDNMB=$WKDNMB"GB"
        else
          WKDNMB=$WKDNMB"MB"
        fi
      else
        WKDNMB=$WKDNMB"MB"
      fi
    fi
    WKDNSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    WKDNRANK="--"
    WKDNFILE="0"
    WKDNMB="0MB"
    WKDNSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -t -u -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    DAUPRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    DAUPFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      DAUPMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      DAUPMB="$( echo $RAWDATA | cut -d' ' -f4 | tr -d [:alpha:] )"
      if [ "$DAUPMB" != "0" ]; then
        if [ "$DAUPMB" -gt "$MB2GBAT" ]; then
          DAUPMB="$( expr "$DAUPMB" \/ "1024" )"
          DAUPMB=$DAUPMB"GB"
        else
          DAUPMB=$DAUPMB"MB"
        fi
      else
        DAUPMB=$DAUPMB"MB"
      fi
    fi
    DAUPSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    DAUPRANK="--"
    DAUPFILE="0"
    DAUPMB="0MB"
    DAUPSPD="0KBs"
  fi

  RAWDATA="$( $STATSBIN -t -d -x 500 | cut -b 1-16,47-80 | grep -w $USER )"
  if [ "$RAWDATA" ]; then
    DADNRANK="$( echo $RAWDATA | cut -d' ' -f1 | tr -d '[' | tr -d ']' )"
    DADNFILE="$( echo $RAWDATA | cut -d' ' -f3 )"
    if [ -z "$MB2GBAT" ]; then
      DADNMB="$( echo $RAWDATA | cut -d' ' -f4 )"
    else
      DADNMB="$( echo $RAWDATA | cut -d' ' -f4| tr -d [:alpha:] )"
      if [ "$DADNMB" != "0" ]; then
        if [ "$DADNMB" -gt "$MB2GBAT" ]; then
          DADNMB="$( expr "$DADNMB" \/ "1024" )"
          DADNMB=$DADNMB"GB"
        else
          DADNMB=$DADNMB"MB"
        fi
      else
        DADNMB=$DADNMB"MB"
      fi
    fi
    DADNSPD="$( echo $RAWDATA | cut -d' ' -f5 )"
  else
    DADNRANK="--"
    DADNFILE="0"
    DADNMB="0MB"
    DADNSPD="0KBs"
  fi
fi

proc_timediff() {
  ## NOTE: Parts on timediff taken from timediff.sh by Mihly Gyulai (2000-03-04)

  DATENOW="$( $DATEBIN +%m/%d/%y )"
  USERADDED="$( grep "^$USER:" $PASSWD | cut -d':' -f5 )"
  USERADDED2="$( echo $USERADDED | tr -s '-' '/' )"

  datum_1=`$DATEBIN -d "$USERADDED2" +%s`
  datum_2=`$DATEBIN -d "$DATENOW" +%s`

  let DIFF=$datum_2-$datum_1;
 
  if [ $DIFF -lt 0 ]; then 
    let DIFF=DIFF*-1
  fi

  let PERC=$DIFF/60;
  let ORA=$PERC/60;
  let DAYSAGO=$ORA/24;
}

proc_nukediff() {
  ## NOTE: Parts on timediff taken from timediff.sh by Mihly Gyulai (2000-03-04)

  datum_1="$( $DATEBIN +%s )"
  datum_2="$( grep "^NUKE " $USERDIR/$USER | cut -d ' ' -f2 )" 

  let DIFF=$datum_2-$datum_1;
 
  if [ $DIFF -lt 0 ]; then 
    let DIFF=DIFF*-1
  fi

  let PERC=$DIFF/60;
  let ORA=$PERC/60;
  let NAP=$ORA/24;
  let ORA_DIFF=$ORA-24*$NAP;
  let PERC_DIFF=$PERC-60*$ORA
  let MP_DIFF=$DIFF-60*$PERC

  if [ "$NAP" -gt "365" ]; then
    LASTNUKED="more than a year"
  else
    LASTNUKED="$NAP days, $ORA_DIFF hours"
    if [ "$PERC_DIFF" -gt "1" ]; then
      LASTNUKED="$LASTNUKED, $PERC_DIFF minutes"
    else
      LASTNUKED="$LASTNUKED, $PERC_DIFF minute"
    fi
    if [ "$MP_DIFF" -gt "1" ]; then
      LASTNUKED="$LASTNUKED, $MP_DIFF seconds"
    else
      LASTNUKED="$LASTNUKED, $MP_DIFF second"
    fi
  fi
}

proc_laston() {
  ## NOTE: Parts on timediff taken from timediff.sh by Mihly Gyulai (2000-03-04)

  datum_1="$( $DATEBIN +%s )"
  datum_2="$( grep "^TIME " $USERDIR/$USER | cut -d ' ' -f3 )" 

  let DIFF=$datum_2-$datum_1;
 
  if [ $DIFF -lt 0 ]; then 
    let DIFF=DIFF*-1
  fi

  let PERC=$DIFF/60;
  let ORA=$PERC/60;
  let NAP=$ORA/24;
  let ORA_DIFF=$ORA-24*$NAP;
  let PERC_DIFF=$PERC-60*$ORA
  let MP_DIFF=$DIFF-60*$PERC

  if [ "$NAP" -gt "365" ]; then
    LASTON="more than a year"
  else
    LASTON="$NAP days, $ORA_DIFF hours"
    if [ "$PERC_DIFF" -gt "1" ]; then
      LASTON="$LASTON, $PERC_DIFF minutes"
    else
      LASTON="$LASTON, $PERC_DIFF minute"
    fi
    if [ "$MP_DIFF" -gt "1" ]; then
      LASTON="$LASTON, $MP_DIFF seconds"
    else
      LASTON="$LASTON, $MP_DIFF second"
    fi
  fi
}

proc_laston
proc_nukediff
proc_timediff

if [ "$GROUPOUTPUT" = "TRUE" ]; then
  proc_groupoutput
else
  proc_output
fi