#!/bin/bash
VER=1.0

#----------------------------------------------------------#
#                                                          #
# This script is used to import your xferlog into a mysql  #
# database so you can do other fun stuff with it.          #
#                                                          #
# I've used this script for over 3 years so if some        #
# functions seem "dumb", thats why.                        #
# Works fine for both glftpd 1/2.                          #
#                                                          #
#-[ Setup ]------------------------------------------------#
#                                                          #
# * Setup the database and table using the                 #
#   /mysql_stuff/setup_database.sh script.                 #
#                                                          #
# * Copy xferlog-import.sh to /glftpd/bin. Chmod to 700.   #
#                                                          #
# * Setup the options below.                               #
#                                                          #
# * IMPORTANT:                                             #
#   Make a backup of your xferlog. If you want to be sure  #
#   nothing bad happens, set this script to use your       #
#   copy instead, so you can test it. Once satisfied that  #
#   the script works as it should, clear out the database  #
#   using the clear_table.sh script and recreate it.       #
#   Remove the xferlog.archived.                           #
#   Specify your real xferlog instead.                     #
#   Do NOT forget to empty the table first or you'll end   #
#   up with tons of duplicate entries.                     #
#                                                          #
# * Run it once from shell, as ./xferlog-import.sh debug   #
#   The first time you run it, it WILL be slow since it    #
#   will go through your entire xferlog file.              #
#                                                          #
# * Crontab every 5 minutes or so. Up to you.              #
#   Example: */5 * * * * /glftpd/bin/xferlog-import.sh     #
#                                                          #
# The xferlog will be MOVED into xferlog.archived, so if   #
# you have other scripts reading it, point them to that    #
# file instead (except for scripts that read the xferlog   #
# right after a race. They can still read xferlog, like    #
# mss-rlscomp.sh. You dont have to change that.            #
#                                                          #
# Specify 'debug' when running it to see whats its doing.  #
#                                                          #
# If you should somehow mess up your database, you can     #
# always clear out the database, recreate it, MOVE         #
# xferlog.archived to xferlog and restart from scratch.    #
#                                                          #
# Note that the first time its executed, it WILL take a    #
# LONG time to index your xferlog. This is normal and will #
# be much better once its finished. Expect 1-2 days        #
# depending on the size of the log.                        #
# The more often you run it afterwards, the fast it is.    #
#                                                          #
# Explanation of database fields:                          #
# ID        = Autoincrementing ID number.                  #
# datum     = Stores the date in YYYY-MM-DD format.        #
# ttime     = Seconds it took for file to transfer.        #
# size      = Size in bytes.                               #
# section   = Section as set in SECTIONS.                  #
# name      = Release name.                                #
# file      = Filename transfered.                         #
# direction = i/o. Input/Output.                           #
# username  = Guess.                                       #
# groupname = ^ primary group.                             #
#                                                          #
# IP is not stored and I dont recomend you change it so it #
# does.                                                    #
#                                                          #
#----------------------------------------------------------#
 
## Path to mysql binary. Leave as "mysql" if in path.
SQLBIN="mysql"

## Hostname of MySQL server. Try localhost if 127.0.0.1 gives you problems.
SQLHOST="localhost"

## MySQL user.
SQLUSER="root"

## MySQL users password.
SQLPASS="password"

## Database to use.
SQLDB="transfers"

## Table to use.
SQLTB="transfers"

## Path to a GNU complaint date binary. Linux distros can leave this 
## at "" and it will simply use 'date' from your path.
## FBSD users will need to compile the sh-utils package (or something)
## and specify the path to gdate here instead.
datebin=""

## Path to current xferlog.
xferlog=/glftpd/ftp-data/logs/xferlog

## Path where it will be stored instead.
archive=/glftpd/ftp-data/logs/xferlog.archived

## Lockfile to use. 
lockfile=/tmp/xferlog-import.lock

## Temporary path to store stuff. Make sure it exists.
tmp=/glftpd/tmp

## If the last part of the path in the xferlog contains this, it will jump up one level
## and store that in the database instead. This is a good thing.
## Specify any subdirs of releases that you can think of here, non case sensitive.
## It will also look for either . - _ and jump up one level until found, so in theory, you can
## leave this as is.. Better safe then sorry!
## If, in the database, you notice its storing subdirs as "name", you need to add that subdir here.
jumpup="^CD[1-9]$|^Subs$|^Sample$|^Vobsub$|^Extras$|^Part.$|^Part..$|^Part...$|^Dvd[1-9]$|^Disk.$|^Cover$|^Covers$"

## Sections to store in the database.
## Example, if the path contains /DIVX it will be stored as section DIVX in the database.
## Setup for the example above: /DIVX~DIVX
##
## If the section in the xferlog does NOT contain ANY of these, it will NOT be added.
## Thats good if you run 0days for example, but do not want that info to clutter up the
## database. Just do not specify 0DAY or whatever here, and it will be skipped.
##
## As you can see from the example, /GROUPS is added as a seperate section. This is neat
## since you can then grab info on how much your affils utilizes their predirs, etc.
## It does not mean it has to be presented to the public later.
##
## Specify such sections FIRST as it will not keep looking at the others once it has found
## a match, kinda like glftpd.conf. First match wins.

sections="
/GROUPS~GROUPS
/DVDR~DVDR
/TRAILERS~TRAILER
/ISO-UTILS~ISO-UTILS
/XBOX~XBOX
/XXX~XXX
/VCD~VCD
/SVCD~SVCD
/DIVX~DIVX
"


#--[ Script Start ]----------------------------------------------------#

SQL="$SQLBIN -u $SQLUSER -p"$SQLPASS" -h $SQLHOST -D $SQLDB -N -s -e"

if [ -z "$datebin" ]; then
  datebin="date"
fi

if [ "$1" = "debug" -o "$1" = "test" ]; then
  DEBUG="TRUE"
fi
proc_debug() {
  if [ "$DEBUG" = "TRUE" ]; then
    echo "$*"
  fi
}

if [ -e "$lockfile" ]; then
  if [ "`find \"$lockfile\" -type f -mmin -60`" ]; then
    echo "Lockfile $lockfile exists and is not 60 minutes old yet. Quitting."
    exit 0
  else
    echo "Lockfile exists, but its older then 60 minutes. Removing lockfile."
    rm -f "$LOCKFILE"
  fi
fi

if [ ! -r "$xferlog" ]; then
  proc_debug "Cant read xferlog. Quitting."
  exit 1
fi

proc_sqlconnecttest() {
  sqldata="`$SQL "show table status" | tr -s '\t' '^' | cut -d '^' -f1`"
  if [ -z "$sqldata" ]; then
    unset ERRORLEVEL
    echo "Mysql error. Check server"
    exit 0
  fi
}

touch $lockfile

proc_sqlconnecttest

if [ -e "$tmp/xferlog.processing" ]; then
  proc_debug "Seems I couldnt finish last time. Doing old file instead."
  xferlog="$tmp/xferlog.processing"
else
  ## Lets go. Move xferlog before we start so nothing new is written to it.
  mv -f $xferlog $tmp/xferlog.processing
fi

for rawdata in `cat $tmp/xferlog.processing | tr -s ' ' '^'`; do
  unset SKIP
  unset section
  unset tosection

  day="$( echo "$rawdata" | cut -d '^' -f1 )"
  month="$( echo "$rawdata" | cut -d '^' -f2 )"
  date="$( echo "$rawdata" | cut -d '^' -f3 )"
  time="$( echo "$rawdata" | cut -d '^' -f4 )"
  year="$( echo "$rawdata" | cut -d '^' -f5 )"
  ttime="$( echo "$rawdata" | cut -d '^' -f6 )"
  ## IP is not stored.
  # ip="$( echo "$rawdata" | cut -d '^' -f7 )"
  size="$( echo "$rawdata" | cut -d '^' -f8 )"
  fullrel="$( echo "$rawdata" | cut -d '^' -f9 )"
  direction="$( echo "$rawdata" | cut -d '^' -f12 )"
  username="$( echo "$rawdata" | cut -d '^' -f14 )"
  groupname="$( echo "$rawdata" | cut -d '^' -f15 )"

  if [ "$day" -a "$month" -a "$date" -a "$SKIP" != "TRUE" ]; then
    datum="$( $datebin -d "$day $month $date" +%Y-%m-%d )"
    if [ -z "$datum" ]; then
      proc_debug "Error. Couldnt get 'datum' from day:$day, month:$month, date:$date."
      proc_debug "Rawline was $rawdata"
      SKIP="TRUE"
    fi
  fi

  if [ "$ttime" -lt "0" -a "$SKIP" != "TRUE" ]; then
    proc_debug "Error. ttime was $ttime. Setting it to 0 instead."
    ttime=0
  fi

  release="$( dirname "$fullrel" )"
  filename="$( basename "$fullrel" )"
  org_rel="$release"

  num=0
  while [ "$( basename $release | egrep -i "$jumpup" )" ]; do
    num="$[$num+1]"
    release="$( dirname "$release" )"
    if [ "$num" -gt "5" ]; then
      SKIP="TRUE"
      proc_debug "Cant find release for (1) $org_rel"
      break
    fi
  done

  num=0
  while [ -z "$( basename "$release" | egrep "\_|-|\." )" ]; do
    num="$[$num+1]"
    release="$( dirname "$release" )"
    if [ "$num" -gt "5" ]; then
      SKIP="TRUE"
      proc_debug "Cant find release for (2) $org_rel"
      break
    fi
  done

  if [ "$SKIP" != "TRUE" ]; then
    reldir="$( dirname "$release" )"
    release="$( basename "$release" )"

    for findsection in $sections; do
      findword="$( echo "$findsection" | cut -d '~' -f1 )"
      if [ "$( echo "$reldir" | grep "$findword" )" ]; then
        tosection="$( echo "$findsection" | cut -d '~' -f2 )"
#        proc_debug "Found section $tosection for $reldir"
        break
      fi
    done
  fi

  if [ -z "$tosection" -a "$SKIP" != "TRUE" ]; then
    proc_debug "No section found for $reldir. Skipping."
    SKIP="TRUE"
  fi

  if [ "$SKIP" != "TRUE" ]; then
    ## Make final check

    proc_sqlconnecttest

    if [ "$datum" -a "$ttime" -a "$size" -a "$tosection" -a "$release" -a "$direction" -a "$username" -a "$groupname" ]; then
      proc_debug "Ok, inserting $release into db as $tosection ($username -> $direction)."
      $SQL "insert into transfers (datum, ttime, size, section, name, file, direction, username, groupname) values ('$datum', '$ttime', '$size', '$tosection', '$release', '$filename', '$direction', '$username', '$groupname' )"

    else
      proc_debug "Not adding $release. Missing something."
    fi
  fi

  ## Build complete list
  xfer="$( echo "$rawdata" | tr -s '^' ' ' )"
  echo "$xfer" >> $tmp/xferlog.done

  ## Remove this line from processing file so its not added again.
  grep -v "$xfer" $tmp/xferlog.processing > $tmp/xferlog.processing2
  mv -f $tmp/xferlog.processing2 $tmp/xferlog.processing

  ## Update time on lockfile.
  touch $lockfile

done

## Clean up

if [ -e "$tmp/xferlog.done" ]; then
  cat $tmp/xferlog.done >> $archive
  rm -f $tmp/xferlog.done
fi

rm -f $tmp/xferlog.processing

rm -f $lockfile
exit 0
