#RequireAdmin
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile=Tur-Devcon_Game_Controller_Order.exe
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****


Local $Version = "1.0"

If @OSArch = "X64" Then
	Global $DevCon = @ScriptDir & "\devcon64.exe"
Elseif @OSArch = "X86" Then
	Global $DevCon = @ScriptDir & "\devcon32.exe"
Else
	Msgbox(16, "Error", "Could not determine if this is an x64 or x86 machine.. ?!")
	Exit
EndIf

Global $IniFile = @ScriptDir & "\Settings.ini"

If NOT FileExists($DevCon) Then
	Msgbox(16, "Error", "Could not find " & $DevCon)
	Exit
Elseif NOT FileExists($IniFile) Then
	MsgBox(16, "Error", "Could not find " & $IniFile)
	Exit
EndIf

Global $PortArray = ""
Global $PortArray = IniReadSection($IniFile, "Game Ports")

; Remove all except Port 1
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)

; Remove all except Port 1 and 2
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $Name <> "Port2" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)

; Remove all except Port 1 and 2 and 3
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $Name <> "Port2" and $Name <> "Port3" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)