
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile=Tur-Devcon_Game_Controller_Order.exe
#AutoIt3Wrapper_Res_Fileversion=1.1.0.0
#AutoIt3Wrapper_Res_ProductVersion=1.1.0
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#RequireAdmin
#include <constants.au3>
#include <array.au3>

Local $Version = "1.1"

If @OSArch = "X64" Then
	Global $DevCon = @ScriptDir & "\devcon64.exe"
Elseif @OSArch = "X86" Then
	Global $DevCon = @ScriptDir & "\devcon32.exe"
Else
	Msgbox(16, "Error", "Could not determine if this is an x64 or x86 machine.. ?!")
	Exit
EndIf

Global $IniFile = @ScriptDir & "\Settings.ini"

If NOT FileExists($DevCon) Then
	Msgbox(16, "Error", "Could not find " & $DevCon)
	Exit
EndIf

If NOT FileExists($IniFile) Then

	Local $CurrentPID = Run(@ComSpec & ' /c ' & Chr(34) & $DevCon & Chr(34) & " status *game controller* | findstr HID\VID", "", @SW_HIDE, $STDERR_CHILD + $STDOUT_CHILD)
	If Not ProcessWaitClose($CurrentPID,60) Then
		MsgBox(16, "No output", "Did not get any return from " & $DevCon & " status *game controller*" )
		Exit
	EndIf

	$CurrentOutput = StdoutRead($CurrentPID)
	If $CurrentOutput == "" Then
		MsgBox(16, "Error", "Did not find any game controllers when running" & @CRLF & Chr(34) & $DevCon & Chr(34) & " status *game controller*" & @CRLF & @CRLF & "Make sure your BlissBox is connected.")
		Exit
	EndIf

	Run("control.exe joy.cpl")

	MsgBox(0, "Setup", "This is the first time you run this program. We will now run through the setup and identify your joystick ports HIDs." & @CRLF & @CRLF & "I have opened the Game Controllers window and you should see 4 controllers (4-Play_port1 to port4)." & @CRLF & @CRLF & "To make this easier, if you see any other game controllers, disconnect them for now before clicking OK.")

	Local $HIDArrayRaw = StringSplit($CurrentOutput, @CR)

	If $HIDArrayRaw[0] < "5" Then
		MsgBox(16, "Failure", "Did not find atleast 4 HIDs. Aborting.")
		Exit
	EndIf

	Local $HIDDisplay = ""

	For $i = 1 to $HIDArrayRaw[0]
		If $HIDArrayRaw[$i] <> "" Then
			Local $HIDCleaned = StringStripWS($HIDArrayRaw[$i], 1)
			If $HIDDisplay = "" Then
				$HIDDisplay = $HIDCleaned
			Else
				$HIDDisplay = $HIDDisplay & @CRLF & $HIDCleaned
			EndIf
		EndIf
	Next

	Local $GoResponse = MsgBox(49, "Ready!", "I am now going to disconnect the game controllers, one at a time." & @CRLF & @CRLF & "Have a look at the Game Controllers window and tell me which port disappears when you click OK." & @CRLF & @CRLF & "FYI: The following HIDs were found:" & @CRLF & $HIDDisplay)
	If $GoResponse <> "1" Then
		Exit
	EndIf

	For $i = 1 to $HIDArrayRaw[0]
		Local $HIDCleaned = StringStripWS($HIDArrayRaw[$i], 1)
		If $HIDCleaned <> "" Then
			Local $HIDCleaned = StringStripWS($HIDArrayRaw[$i], 1)

			Local $HIDArray = StringSplit($HIDCleaned, "\")
			Local $HIDCleaned = $HIDArray[2]
			ConsoleWrite($HIDCleaned & @CRLF)
			RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $HIDCleaned & "*" & Chr(34), "", @SW_HIDE)
			Local $SelectedPort = InputBox("Select a port", "Which port vanished from the Game Controllers list? Specify 1 - 4 or 0 if none of them did.")

			If $SelectedPort == "" Then
				MsgBox(16, "Aborting.", "Nothing typed. Running rescan and aborting")
				_Exit()
			EndIf

			_RescanHardware()

			If $SelectedPort == "0" Then
				MsgBox(0, "Hmm", "No controllers vanished? I will continue but its quite possible that you are not running this program as administrator. If you have more then the 4 ports visable in the Game Controllers window and one of the others vanished, this is normal.")
			Elseif $SelectedPort == "1" Then
				IniWrite($IniFile, "Game Ports", "Port1", $HIDCleaned)
				MsgBox(0, "Port1", "Wrote Port1=" & $HIDCleaned & " to the Settings.ini file." & @CRLF & @CRLF & "I will now remove another port. Look at the Game Controllers window again.")
			Elseif $SelectedPort == "2" Then
				IniWrite($IniFile, "Game Ports", "Port2", $HIDCleaned)
				MsgBox(0, "Port2", "Wrote Port2=" & $HIDCleaned & " to the Settings.ini file." & @CRLF & @CRLF & "I will now remove another port. Look at the Game Controllers window again.")
			Elseif $SelectedPort == "3" Then
				IniWrite($IniFile, "Game Ports", "Port3", $HIDCleaned)
				MsgBox(0, "Port3", "Wrote Port3=" & $HIDCleaned & " to the Settings.ini file." & @CRLF & @CRLF & "I will now remove another port. Look at the Game Controllers window again.")
			Elseif $SelectedPort == "4" Then
				IniWrite($IniFile, "Game Ports", "Port4", $HIDCleaned)
				MsgBox(0, "Port4", "Wrote Port4=" & $HIDCleaned & " to the Settings.ini file." & @CRLF & @CRLF & "I will now remove another port. Look at the Game Controllers window again.")
			Else
				MsgBox(16, "Error", "You should only type 0, 1, 2, 3 or 4. Rescanning hardware and aborting.")
				_Exit()
			EndIf
		EndIf
	Next

	_RescanHardware()
	MsgBox(0, "Done", "Setup is done. Providing all went well, you should now be able to restart me to have the ports reordered correctly." & @CRLF & @CRLF & "Please verify that you have 4 ports defined in Settings.ini." & @CRLF & @CRLF & "To restart this setup, delete the Settings.ini file")
	Exit

EndIf


Global $PortArray = ""
Global $PortArray = IniReadSection($IniFile, "Game Ports")

; Remove all except Port 1
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)

; Remove all except Port 1 and 2
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $Name <> "Port2" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)

; Remove all except Port 1 and 2 and 3
For $i = 1 to $PortArray[0][0]
	Local $Name = $PortArray[$i][0]
	Local $ID = $PortArray[$i][1]
	If $Name <> "Port1" and $Name <> "Port2" and $Name <> "Port3" and $ID <> "" Then
		ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE)
	EndIf
Next

; Rescan it
RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)

Func _RescanHardware()
	SplashTextOn("Rescanning hardware", "Please wait...",200, 50)
	RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)
	SplashOff()
EndFunc

Func _Exit()
	_RescanHardware()
	Exit
EndFunc
