
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Outfile=Tur-Game_Controller_Order.exe
#AutoIt3Wrapper_Res_Fileversion=1.4.0.0
#AutoIt3Wrapper_Res_ProductVersion=1.4.0
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

#RequireAdmin
#include <Constants.au3>
#include <Array.au3>

Local $Version = "1.4"

; Find out which devcon to run depending on OS architecture.
If @OSArch = "X64" Then
	Global $DevCon = @ScriptDir & "\devcon64.exe"
ElseIf @OSArch = "X86" Then
	Global $DevCon = @ScriptDir & "\devcon32.exe"
Else
	MsgBox(16, "Error", "Could not determine if this is an x64 or x86 machine.. ?!")
	Exit
EndIf

; Define the INI file.

If $CmdLine[0] > "0" Then
	Global $IniFile = @ScriptDir & "\" & $CmdLine[1]
	Local $IniName = $CmdLine[1]
Else
	Global $IniFile = @ScriptDir & "\Settings.ini"
	Local $IniName = "Settings.ini"
EndIf

; Make sure we really have a devcon command...
If Not FileExists($DevCon) Then
	MsgBox(16, "Error", "Could not find " & $DevCon)
	Exit
EndIf

; Check if the ini file exists. If not, run the guide.
If Not FileExists($IniFile) Then

	; Run the Game Controllers control panel item.
	Run("control.exe joy.cpl")

	; Find all HIDs for everything called "game controller".
	Local $CurrentPID = Run(@ComSpec & ' /c ' & Chr(34) & $DevCon & Chr(34) & " status *game controller* | findstr HID\VID", "", @SW_HIDE, $STDERR_CHILD + $STDOUT_CHILD)
	If Not ProcessWaitClose($CurrentPID, 60) Then
		MsgBox(16, "No output", "Did not get any return from " & $DevCon & " status *game controller*")
		Exit
	EndIf

	; Read the output we got.
	$CurrentOutput = StdoutRead($CurrentPID)
	If $CurrentOutput == "" Then
		MsgBox(16, "Error", "Did not find any game controllers when running" & @CRLF & Chr(34) & $DevCon & Chr(34) & " status *game controller*" & @CRLF & @CRLF & "Make sure your BlissBox and any other controllers you have are connected.")
		Exit
	EndIf

	; Show initial message with information.
	MsgBox(48, "Setup " & $IniName, "This is the first time you run this program. We will now run through the setup and identify your joystick ports HIDs." & @CRLF & @CRLF & "I have opened the Game Controllers window and you should see all your controllers. Please connect all Game Controllers and make sure they appear before clicking OK.")

	; Create a new array from the output from devcon, clean up of any newlines and empty rows that might appear.
	Local $HIDArrayRaw[0]
	Local $HIDArrayRawRaw = StringSplit($CurrentOutput, @CR)
	For $i = 1 To $HIDArrayRawRaw[0]
		Local $HIDCleaned = StringStripWS($HIDArrayRawRaw[$i], 1)
		If $HIDCleaned <> "" Then
			_ArrayAdd($HIDArrayRaw, $HIDCleaned)
		EndIf
	Next
	Local $HIDsFound = UBound($HIDArrayRaw)

	; The final list of HIDs should be 1 (or more). Make sure it is.
	If $HIDsFound < "0" Then
		MsgBox(16, "Failure", "Did not find atleast 1 HID. Aborting.")
		Exit
	EndIf

	; Create a nice list we can use in the next msgbox.
	Local $HIDDisplay = ""
	Local $HIDDisplayArray[0]
	For $i = 0 To $HIDsFound - 1
		Local $HidNameTemp = StringSplit($HIDArrayRaw[$i], "&")
		Local $HidNameTemp2 = $HidNameTemp[1] & "&" & $HidNameTemp[2]
		Local $HidNameTemp3 = StringSplit($HidNameTemp2, "\") ; Part 1, get the part we need to search for the name in the registry.
		Local $HidNameTemp4 = $HidNameTemp3[2] ; Part 2
		Local $HIDNamed = RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\MediaProperties\PrivateProperties\Joystick\OEM\" & $HidNameTemp4, "OEMName")
		If $HIDNamed == "" Then
			$HIDNamed = "Unknown"
		EndIf
		_ArrayAdd($HIDDisplayArray, $HIDNamed & @TAB & "HID: " & $HidNameTemp4)
	Next
	_ArraySort($HIDDisplayArray)								; Sort the list before we present it. Looks better.
	Local $HIDDisplay = _ArrayToString($HIDDisplayArray,@CR)	; Convert the sorted array to a string that we can display.

	; Show the next message, that we are ready to start.
	Local $GoResponse = MsgBox(65, "Ready!", "The following controllers were found:" & @CRLF & @CRLF & $HIDDisplay & @CRLF & @CRLF & "Press OK to continue.")
	; Make sure OK was clicked. Quit otherwise.
	If $GoResponse <> "1" Then
		Exit
	EndIf

	Local $DonePorts = "|"
	Local $DonePortsNice = ""

	_ArraySort($HIDArrayRaw)

	; Go through each HID that we found.
	For $i = 0 To $HIDsFound - 1
		; Put the HID in a string (easier to work with).
		Local $HIDCleaned = $HIDArrayRaw[$i]
		; Make sure its not empty. It should never be, but here is a check for it since we can.
		If $HIDCleaned <> "" Then

			; Make sure the HID contains atleast 2 backslashes or its nothing we want.. weird
			If Not StringInStr($HIDCleaned, "\", 0, 2) Then
				MsgBox(16, "HID error", "The HID:" & @CRLF & $HIDCleaned & @CRLF & "does not contain atleast 2 backslashes. Aborting")
				Exit
			EndIf

			; Create a temporary array from the HID. We cant use the full HID as we only want the middle part in the backslashes.
			Local $HIDArrayTemp = StringSplit($HIDCleaned, "\")
			If Not IsArray($HIDArrayTemp) Then
				MsgBox(16, "Error", "Could not split up " & $HIDCleaned & " - Aborting")
				Exit
			EndIf
			; Change the $HIDCleaned string to only be the middle part of the backslashes.
			Local $HIDCleaned = $HIDArrayTemp[2]

			; Get the actual name for this Controller from the registry.
			Local $HidNameTemp = StringSplit($HIDCleaned, "&")
			Local $HidNameTemp2 = $HidNameTemp[1] & "&" & $HidNameTemp[2]
			Local $HIDNamed = RegRead("HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\MediaProperties\PrivateProperties\Joystick\OEM\" & $HidNameTemp2, "OEMName")
			If $HIDNamed == "" Then
				$HIDNamed = "Unknown"
			EndIf

			; Ask which priority this game controller should be in the future. 1 and up.
			Local $SelectedPort = InputBox($HIDCleaned, "Controller found: " & Chr(34) & $HIDNamed & Chr(34) & @CRLF & @CRLF & "Where in the Game Controllers list would you like this to appear in the future?" & @CRLF & "1 for the top (first), " & $HIDsFound & " for the bottom." & @CRLF & @CRLF & "Or in other words, which Joy # would you like this controller to appear as?", "", "", 450)

			While StringIsDigit($SelectedPort) = "0" Or $SelectedPort < "1" Or $SelectedPort > $HIDsFound Or StringInStr($DonePorts, "|" & $SelectedPort & "|") And $SelectedPort <> ""
				If StringInStr($DonePorts, "|" & $SelectedPort & "|")  Then
					MsgBox(16, "#" & $SelectedPort & " already assigned!", "Already selected a controller #" & $SelectedPort & @CRLF & @CRLF & $DonePortsNice & @CRLF & "Please try again")
				EndIf
				Local $SelectedPort = InputBox($HIDNamed, "Wrong input. Should be a number from 1 to " & $HIDsFound & @CRLF & "Please select another port for " & $HIDNamed & @CRLF & @CRLF & "1 for the top (first), " & $HIDsFound & " for the bottom." & @CRLF & @CRLF & "Or in other words, which Joy # would you like this controller to appear as?", "", "", 450)
			WEnd

			$DonePorts = $DonePorts & $SelectedPort & "|"
			$DonePortsNice = $DonePortsNice & $SelectedPort & " = " & $HIDNamed & @CRLF

			; Depending on what the user responded with, write it to the Settings.ini file.
			If $SelectedPort == "" Then
				MsgBox(16, "Aborting.", "Nothing typed. Aborting.")
				If FileExists($IniFile) Then
					FileDelete($IniFile)
				EndIf
				Exit
			Else
				IniWrite($IniFile, "Game Ports", "Port" & $SelectedPort, $HIDCleaned)
			EndIf
		EndIf
	Next

	; Sort the INI file. Looks better.
	_IniSort($IniFile)
	; Show a final message and exit.
	MsgBox(0, "Done", "Setup is done. Providing all went well, you should now be able to restart me to have the ports reordered automatically." & @CRLF & @CRLF & "Please verify that your ports in " & $IniName & " are correct, starting with Port1 and going up without gaps." & @CRLF & @CRLF & "To restart this setup, delete the " & $IniName & " file" & @CRLF & @CRLF & $DonePortsNice)
	Exit

EndIf

; We end up here if you start the program with a Settings.ini file existing already.

; Read the Ports from the ini file into an array.
Global $PortArray = ""
Global $PortArray = IniReadSection($IniFile, "Game Ports")

; Verify that we got an array
If Not IsArray($PortArray) Then
	MsgBox(16, "Error", "Settings.ini error. Can not read ports. Please delete your ini file and rerun to set it up correctly.")
	Exit
ElseIf $PortArray[0][0] < "2" Then
	MsgBox(16, "Error", "Error in Settings.ini. Seems there are not atleast 2 ports defined. Please delete the .ini and rerun to set it up correctly.")
	Exit
EndIf

; Verify that the controllers are connected

; Find all HIDs for everything called "game controller".
Local $CurrentPID = Run(@ComSpec & ' /c ' & Chr(34) & $DevCon & Chr(34) & " status *game controller* | findstr HID\VID", "", @SW_HIDE, $STDERR_CHILD + $STDOUT_CHILD)
If Not ProcessWaitClose($CurrentPID, 60) Then
	MsgBox(16, "No output", "Did not get any return from " & $DevCon & " status *game controller*", 10)
	Exit
EndIf
; Read the output we got.
$CurrentOutput = StdoutRead($CurrentPID)
If $CurrentOutput == "" Then
	MsgBox(16, "Error", "Did not find any game controllers when running" & @CRLF & Chr(34) & $DevCon & Chr(34) & " status *game controller*" & @CRLF & @CRLF & "Make sure your controllers are connected.", 10)
	Exit
EndIf

; Create a new array from the output from devcon so we know which HIDs actually exists.
Local $HIDArrayRaw[0]
Local $HIDArrayRawRaw = StringSplit($CurrentOutput, @CR)
For $i = 1 To $HIDArrayRawRaw[0]
	Local $HIDCleaned = StringStripWS($HIDArrayRawRaw[$i], 1)
	If $HIDCleaned <> "" Then
		Local $HIDArrayTemp = StringSplit($HIDCleaned, "\")
		Local $HIDCleaned = $HIDArrayTemp[2]
		If $HIDCleaned <> "" Then
			_ArrayAdd($HIDArrayRaw, $HIDCleaned)
		EndIf
	EndIf
Next
Local $HIDsFound = UBound($HIDArrayRaw)

Local $HIDsDone[0]
Local $PortNum = "1"

For $y = 1 To $PortArray[0][0]																; We need to go through this the number of ports in Settings.ini times..
	For $i = 1 To $PortArray[0][0]															; the time the number of ports. Confusing, I know.
		Local $Name = $PortArray[$i][0]														; Get the defined name from Settings.ini
		Local $ID = $PortArray[$i][1]														; Get the defined HID from Settings.ini
		If _ArraySearch($HIDArrayRaw, $ID) <> "-1" Then										; Check if this HID is actually detected right now before trying to disconnect it.
			If $Name <> "Port" & $PortNum And _ArraySearch($HIDsDone, $Name) = "-1" Then	; Dont disconnect this one if its the current port or if its already been disconnected before.
				ConsoleWrite("Removing " & $Name & " which has ID: " & $ID & @CRLF)
				RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $ID & "*" & Chr(34), "", @SW_HIDE) ; Actually discconect it.
			Else
				_ArrayAdd($HIDsDone, $Name) 												; This port is the current port and its now done. Add it to array so its not run again.
			EndIf
		EndIf
	Next
	$PortNum = $PortNum + 1																	; Add +1 to the Portnumber so we check the next one in order on the next loop.
	ConsoleWrite("- Rescanning hardware" & @CRLF)
	RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE)							; Rescan the hardware so all ports pop back into the Game Controller window.
Next

; Clean up any other controllers that are not defined in the ini file and put them at the bottom of the Game Controllers list..
Local $FoundExtras = "FALSE"
For $i = 0 to $HIDsFound -1
	If _ArraySearch($PortArray, $HIDArrayRaw[$i]) = -1 Then
		RunWait(Chr(34) & $DevCon & Chr(34) & " remove " & Chr(34) & "*" & $HIDArrayRaw[$i] & "*" & Chr(34), "", @SW_HIDE) ; Actually discconect it.
		Local $FoundExtras = "TRUE"
	EndIf
Next
If $FoundExtras = "TRUE" Then
	RunWait(Chr(34) & $DevCon & Chr(34) & " rescan", "", @SW_HIDE) ; Rescan the hardware so all ports pop back into the Game Controller window.
EndIf

; Function to sort the ini file at the end of creation. Not needed but looks better in Settings.ini if they are in order from 1-4.
Func _IniSort($hIni)
	Local $aIRSN = IniReadSectionNames($hIni)
	If Not IsArray($aIRSN) Then Return SetError(1, 0, 0)
	_ArraySort($aIRSN, 0, 1)
	Local $aKey, $sHold
	For $iCC = 1 To UBound($aIRSN) - 1
		Local $aIRS = IniReadSection($hIni, $aIRSN[$iCC])
		If Not IsArray($aIRS) Then ContinueLoop
		For $xCC = 1 To $aIRS[0][0]
			$aKey &= $aIRS[$xCC][0] & Chr(1)
		Next
		If $aKey Then
			$aKey = StringSplit(StringTrimRight($aKey, 1), Chr(1))
			_ArraySort($aKey, 0, 1)
			$sHold &= '[' & $aIRSN[$iCC] & ']' & @CRLF
			For $aCC = 1 To UBound($aKey) - 1
				$sHold &= $aKey[$aCC] & '=' & IniRead($hIni, $aIRSN[$iCC], $aKey[$aCC], 'blahblah') & @CRLF
			Next
			$aKey = ''
		EndIf
	Next
	If $sHold Then
		$sHold = StringTrimRight($sHold, 2)
		FileClose(FileOpen($hIni, 2))
		FileWrite($hIni, $sHold)
		Return 1
	EndIf
	Return SetError(1, 0, 0)
EndFunc   ;==>_IniSort

